@extends('layouts.app')

@section('title', 'سندات القبض')

@section('content')
<div class="container-fluid">
    <!-- Header Section -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">سندات القبض</h1>
        <a href="{{ route('receipt-vouchers.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> إنشاء سند قبض جديد
        </a>
    </div>

    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">إجمالي المبالغ</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($stats['total_amount'], 2) }} ر.س</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-money-bill-wave fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">عدد السندات النشطة</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $stats['total_count'] }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-receipt fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">السندات المعلقة</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $stats['pending_count'] }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-danger shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">السندات الملغية</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $stats['cancelled_count'] }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-times-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters Card -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">فلاتر البحث</h6>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('receipt-vouchers.index') }}">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="company_id">الشركة</label>
                            <select name="company_id" id="company_id" class="form-control">
                                <option value="">جميع الشركات</option>
                                @foreach($companies as $company)
                                    <option value="{{ $company->id }}" {{ request('company_id') == $company->id ? 'selected' : '' }}>
                                        {{ $company->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="customer_id">العميل</label>
                            <select name="customer_id" id="customer_id" class="form-control select2-filter-customer">
                                <option value="">جميع العملاء</option>
                                @foreach($customers as $customer)
                                    <option value="{{ $customer->id }}" {{ request('customer_id') == $customer->id ? 'selected' : '' }}>
                                        {{ $customer->name }} - {{ $customer->email ?? 'لا يوجد بريد' }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="status">الحالة</label>
                            <select name="status" id="status" class="form-control">
                                <option value="">جميع الحالات</option>
                                <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>نشط</option>
                                <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>معلق</option>
                                <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="date_from">من تاريخ</label>
                            <input type="date" name="date_from" id="date_from" class="form-control" value="{{ request('date_from') }}">
                        </div>
                    </div>

                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="date_to">إلى تاريخ</label>
                            <input type="date" name="date_to" id="date_to" class="form-control" value="{{ request('date_to') }}">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="search">البحث</label>
                            <input type="text" name="search" id="search" class="form-control" placeholder="البحث برقم السند، الرقم المرجعي، أو الوصف..." value="{{ request('search') }}">
                        </div>
                    </div>

                    <div class="col-md-6 d-flex align-items-end">
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary mr-2">
                                <i class="fas fa-search"></i> بحث
                            </button>
                            <a href="{{ route('receipt-vouchers.index') }}" class="btn btn-secondary mr-2">
                                <i class="fas fa-undo"></i> إعادة تعيين
                            </a>
                            <a href="{{ route('receipt-vouchers.export', request()->query()) }}" class="btn btn-success">
                                <i class="fas fa-download"></i> تصدير
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Data Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">قائمة سندات القبض</h6>
        </div>
        <div class="card-body">
            @if($vouchers->count() > 0)
                <div class="table-responsive">
                    <table class="table table-bordered" width="100%" cellspacing="0">
                            <tr>
                                <th>رقم السند</th>
                                <th>الشركة</th>
                                <th>العميل</th>
                                <th>التاريخ</th>
                                <th>المبلغ</th>
                                <th>طريقة الدفع</th>
                                <th>الحالة</th>
                                <th>الإجراءات</th>
                            </tr>
                        <tbody>
                            @foreach($vouchers as $voucher)
                                <tr>
                                    <td>
                                        <a href="{{ route('receipt-vouchers.show', $voucher) }}" class="text-primary font-weight-bold">
                                            {{ $voucher->voucher_number }}
                                        </a>
                                    </td>
                                    <td>{{ $voucher->company->name }}</td>
                                    <td>{{ $voucher->customer->name }}</td>
                                    <td>{{ $voucher->receipt_date->format('Y-m-d') }}</td>
                                    <td>{{ number_format($voucher->amount, 2) }} ر.س</td>
                                    <td>{{ $voucher->getPaymentMethodText() }}</td>
                                    <td>
                                        <span class="badge badge-{{ $voucher->getStatusColor() }}">
                                            {{ $voucher->getStatusText() }}
                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('receipt-vouchers.show', $voucher) }}" class="btn btn-sm btn-info" title="عرض">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            @if($voucher->status !== 'cancelled')
                                                <a href="{{ route('receipt-vouchers.edit', $voucher) }}" class="btn btn-sm btn-warning" title="تحرير">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            @endif
                                            <a href="{{ route('receipt-vouchers.print', $voucher) }}" class="btn btn-sm btn-secondary" title="طباعة" target="_blank">
                                                <i class="fas fa-print"></i>
                                            </a>
                                            @if($voucher->status !== 'cancelled')
                                                <form action="{{ route('receipt-vouchers.destroy', $voucher) }}" method="POST" style="display: inline-block;" onsubmit="return confirm('هل أنت متأكد من إلغاء هذا السند؟')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger" title="إلغاء">
                                                        <i class="fas fa-times"></i>
                                                    </button>
                                                </form>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-center">
                    {{ $vouchers->appends(request()->query())->links() }}
                </div>
            @else
                <div class="text-center py-4">
                    <i class="fas fa-receipt fa-3x text-gray-300 mb-3"></i>
                    <p class="text-gray-500">لا توجد سندات قبض متاحة</p>
                    <a href="{{ route('receipt-vouchers.create') }}" class="btn btn-primary">إنشاء سند قبض جديد</a>
                </div>
            @endif
        </div>
    </div>
</div>
@push('styles')
<!-- Select2 CSS -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />
@endpush

@push('scripts')
<!-- Select2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
$(document).ready(function() {
    // تفعيل Select2 للعملاء في الفلاتر
    $('.select2-filter-customer').select2({
        theme: 'bootstrap-5',
        placeholder: 'ابحث عن العميل...',
        allowClear: true,
        width: '100%',
        language: {
            noResults: function() {
                return "لا توجد نتائج";
            },
            searching: function() {
                return "جاري البحث...";
            }
        }
    });
});
</script>
@endpush

@endsection