@extends('layouts.app')

@section('title', 'تحرير سند القبض - ' . $receiptVoucher->voucher_number)

@section('content')
<div class="container-fluid">
    <!-- Header Section -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">تحرير سند القبض - {{ $receiptVoucher->voucher_number }}</h1>
        <div class="btn-group">
            <a href="{{ route('receipt-vouchers.show', $receiptVoucher) }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> العودة للعرض
            </a>
            <a href="{{ route('receipt-vouchers.index') }}" class="btn btn-info">
                <i class="fas fa-list"></i> القائمة
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">تحرير بيانات سند القبض</h6>
                </div>
                <div class="card-body">
                    <form action="{{ route('receipt-vouchers.update', $receiptVoucher) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <!-- الشركة -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="company_id" class="form-label">الشركة <span class="text-danger">*</span></label>
                                    <select name="company_id" id="company_id" class="form-control @error('company_id') is-invalid @enderror" required>
                                        <option value="">اختر الشركة</option>
                                        @foreach($companies as $company)
                                            <option value="{{ $company->id }}" {{ old('company_id', $receiptVoucher->company_id) == $company->id ? 'selected' : '' }}>
                                                {{ $company->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('company_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- العميل -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="customer_id" class="form-label">العميل <span class="text-danger">*</span></label>
                                    <select name="customer_id" id="customer_id" class="form-control select2-customer @error('customer_id') is-invalid @enderror" required>
                                        <option value="">اختر العميل أو ابحث...</option>
                                        @foreach($customers as $customer)
                                            <option value="{{ $customer->id }}" {{ old('customer_id', $receiptVoucher->customer_id) == $customer->id ? 'selected' : '' }}>
                                                {{ $customer->name }} - {{ $customer->email ?? 'لا يوجد بريد' }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('customer_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- تاريخ الاستلام -->
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="receipt_date" class="form-label">تاريخ الاستلام <span class="text-danger">*</span></label>
                                    <input type="datetime-local" name="receipt_date" id="receipt_date" 
                                           class="form-control @error('receipt_date') is-invalid @enderror" 
                                           value="{{ old('receipt_date', $receiptVoucher->receipt_date->format('Y-m-d\TH:i')) }}" required>
                                    @error('receipt_date')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- المبلغ -->
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="amount" class="form-label">المبلغ (ر.س) <span class="text-danger">*</span></label>
                                    <input type="number" name="amount" id="amount" step="0.01" min="0.01"
                                           class="form-control @error('amount') is-invalid @enderror" 
                                           value="{{ old('amount', $receiptVoucher->amount) }}" required>
                                    @error('amount')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- طريقة الدفع -->
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="payment_method" class="form-label">طريقة الدفع <span class="text-danger">*</span></label>
                                    <select name="payment_method" id="payment_method" class="form-control @error('payment_method') is-invalid @enderror" required>
                                        <option value="">اختر طريقة الدفع</option>
                                        <option value="cash" {{ old('payment_method', $receiptVoucher->payment_method) == 'cash' ? 'selected' : '' }}>نقداً</option>
                                        <option value="bank_transfer" {{ old('payment_method', $receiptVoucher->payment_method) == 'bank_transfer' ? 'selected' : '' }}>تحويل بنكي</option>
                                        <option value="check" {{ old('payment_method', $receiptVoucher->payment_method) == 'check' ? 'selected' : '' }}>شيك</option>
                                        <option value="credit_card" {{ old('payment_method', $receiptVoucher->payment_method) == 'credit_card' ? 'selected' : '' }}>بطاقة ائتمان</option>
                                        <option value="other" {{ old('payment_method', $receiptVoucher->payment_method) == 'other' ? 'selected' : '' }}>أخرى</option>
                                    </select>
                                    @error('payment_method')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- الرقم المرجعي -->
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="reference_number" class="form-label">الرقم المرجعي</label>
                                    <input type="text" name="reference_number" id="reference_number" 
                                           class="form-control @error('reference_number') is-invalid @enderror" 
                                           value="{{ old('reference_number', $receiptVoucher->reference_number) }}" placeholder="رقم الشيك، رقم التحويل، إلخ">
                                    @error('reference_number')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- رمز الحساب -->
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="account_code" class="form-label">رمز الحساب</label>
                                    <input type="text" name="account_code" id="account_code" 
                                           class="form-control @error('account_code') is-invalid @enderror" 
                                           value="{{ old('account_code', $receiptVoucher->account_code) }}" placeholder="رمز الحساب المحاسبي">
                                    @error('account_code')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- الحالة -->
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="status" class="form-label">الحالة <span class="text-danger">*</span></label>
                                    <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                                        <option value="active" {{ old('status', $receiptVoucher->status) == 'active' ? 'selected' : '' }}>نشط</option>
                                        <option value="pending" {{ old('status', $receiptVoucher->status) == 'pending' ? 'selected' : '' }}>معلق</option>
                                    </select>
                                    @error('status')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- الفاتورة المرتبطة -->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="invoice_id" class="form-label">الفاتورة المرتبطة (اختياري)</label>
                                    <select name="invoice_id" id="invoice_id" class="form-control @error('invoice_id') is-invalid @enderror">
                                        <option value="">لا توجد فاتورة مرتبطة</option>
                                        @foreach($invoices as $invoice)
                                            <option value="{{ $invoice->id }}" {{ old('invoice_id', $receiptVoucher->invoice_id) == $invoice->id ? 'selected' : '' }}>
                                                {{ $invoice->invoice_number }} - {{ $invoice->customer->name }} 
                                                ({{ number_format($invoice->remaining_amount, 2) }} ر.س متبقي)
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('invoice_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="form-text text-muted">
                                        إذا كان السند مرتبط بفاتورة معينة، سيتم تحديث حالة الدفع للفاتورة تلقائياً
                                    </small>
                                </div>
                            </div>
                        </div>

                        <!-- الوصف -->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="description" class="form-label">الوصف <span class="text-danger">*</span></label>
                                    <input type="text" name="description" id="description" 
                                           class="form-control @error('description') is-invalid @enderror" 
                                           value="{{ old('description', $receiptVoucher->description) }}" required 
                                           placeholder="وصف مختصر لسند القبض">
                                    @error('description')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- الملاحظات -->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="notes" class="form-label">ملاحظات</label>
                                    <textarea name="notes" id="notes" rows="3" 
                                              class="form-control @error('notes') is-invalid @enderror" 
                                              placeholder="ملاحظات إضافية">{{ old('notes', $receiptVoucher->notes) }}</textarea>
                                    @error('notes')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- أزرار الإجراءات -->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save"></i> حفظ التعديلات
                                    </button>
                                    <a href="{{ route('receipt-vouchers.show', $receiptVoucher) }}" class="btn btn-secondary ml-2">
                                        <i class="fas fa-times"></i> إلغاء
                                    </a>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<!-- Select2 CSS -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />
@endpush

@push('scripts')
<!-- Select2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
$(document).ready(function() {
    // تفعيل Select2 للعملاء
    $('.select2-customer').select2({
        theme: 'bootstrap-5',
        placeholder: 'ابحث عن العميل...',
        allowClear: true,
        width: '100%',
        language: {
            noResults: function() {
                return "لا توجد نتائج";
            },
            searching: function() {
                return "جاري البحث...";
            }
        }
    });
});
</script>
@endpush

@endsection