@extends('layouts.app')

@section('title', 'تفاصيل أمر الشراء')
@section('page-title', 'تفاصيل أمر الشراء: ' . $purchaseOrder->po_number)

@section('page-actions')
    <div class="btn-group" role="group">
        @if($purchaseOrder->status == 'draft')
            <form method="POST" action="{{ route('purchase-orders.update-status', $purchaseOrder) }}" class="d-inline">
                @csrf
                @method('PATCH')
                <input type="hidden" name="status" value="pending">
                <button type="submit" class="btn btn-success" 
                        onclick="return confirm('تأكيد إرسال أمر الشراء؟')">
                    <i class="fas fa-paper-plane me-2"></i>
                    إرسال الأمر
                </button>
            </form>
        @endif
        
        @if($purchaseOrder->status == 'pending')
            <form method="POST" action="{{ route('purchase-orders.update-status', $purchaseOrder) }}" class="d-inline">
                @csrf
                @method('PATCH')
                <input type="hidden" name="status" value="approved">
                <button type="submit" class="btn btn-primary" 
                        onclick="return confirm('تأكيد اعتماد أمر الشراء؟')">
                    <i class="fas fa-check me-2"></i>
                    اعتماد الأمر
                </button>
            </form>
        @endif
        
        @if(in_array($purchaseOrder->status, ['approved', 'sent']))
            <a href="{{ route('goods-receipts.create', ['purchase_order_id' => $purchaseOrder->id]) }}" 
               class="btn btn-warning">
                <i class="fas fa-dolly me-2"></i>
                استلام البضائع
            </a>
        @endif
        
        @if(in_array($purchaseOrder->status, ['draft', 'pending']))
            <a href="{{ route('purchase-orders.edit', $purchaseOrder) }}" class="btn btn-info">
                <i class="fas fa-edit me-2"></i>
                تعديل
            </a>
        @endif
        
        <a href="{{ route('purchase-orders.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-right me-2"></i>
            العودة للقائمة
        </a>
    </div>
@endsection

@section('content')
<div class="row">
    <!-- معلومات أمر الشراء -->
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-info-circle me-2"></i>
                    معلومات أمر الشراء
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <td><strong>رقم الأمر:</strong></td>
                                <td>{{ $purchaseOrder->po_number }}</td>
                            </tr>
                            <tr>
                                <td><strong>المورد:</strong></td>
                                <td>
                                    <a href="{{ route('suppliers.show', $purchaseOrder->supplier) }}" class="text-decoration-none">
                                        {{ $purchaseOrder->supplier->name }}
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>تاريخ الأمر:</strong></td>
                                <td>{{ $purchaseOrder->order_date->format('Y/m/d') }}</td>
                            </tr>
                            <tr>
                                <td><strong>تاريخ التسليم المتوقع:</strong></td>
                                <td>{{ $purchaseOrder->expected_delivery_date ? $purchaseOrder->expected_delivery_date->format('Y/m/d') : '-' }}</td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <td><strong>الحالة:</strong></td>
                                <td>
                                    @switch($purchaseOrder->status)
                                        @case('draft')
                                            <span class="badge bg-secondary">مسودة</span>
                                            @break
                                        @case('pending')
                                            <span class="badge bg-warning">معلق</span>
                                            @break
                                        @case('approved')
                                            <span class="badge bg-info">مؤكد</span>
                                            @break
                                        @case('sent')
                                            <span class="badge bg-primary">مرسل</span>
                                            @break
                                        @case('partially_received')
                                            <span class="badge bg-warning">مستلم جزئي</span>
                                            @break
                                        @case('received')
                                            <span class="badge bg-success">مستلم</span>
                                            @break
                                        @case('cancelled')
                                            <span class="badge bg-danger">ملغي</span>
                                            @break
                                    @endswitch
                                </td>
                            </tr>
                            <tr>
                                <td><strong>المنشئ:</strong></td>
                                <td>{{ $purchaseOrder->user->name }}</td>
                            </tr>
                            <tr>
                                <td><strong>تاريخ الإنشاء:</strong></td>
                                <td>{{ $purchaseOrder->created_at->format('Y/m/d H:i') }}</td>
                            </tr>
                            <tr>
                                <td><strong>آخر تحديث:</strong></td>
                                <td>{{ $purchaseOrder->updated_at->format('Y/m/d H:i') }}</td>
                            </tr>
                        </table>
                    </div>
                </div>
                
                @if($purchaseOrder->notes)
                <div class="row">
                    <div class="col-12">
                        <hr>
                        <strong>ملاحظات:</strong>
                        <p class="mt-2">{{ $purchaseOrder->notes }}</p>
                    </div>
                </div>
                @endif
            </div>
        </div>
        
        <!-- عناصر أمر الشراء -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-list me-2"></i>
                    عناصر أمر الشراء
                </h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                            <tr>
                                <th>المنتج</th>
                                <th>الكمية المطلوبة</th>
                                <th>الكمية المستلمة</th>
                                <th>المتبقي</th>
                                <th>سعر الوحدة</th>
                                <th>معدل الضريبة</th>
                                <th>المجموع</th>
                                <th>حالة الاستلام</th>
                            </tr>
                        <tbody>
                            @foreach($purchaseOrder->items as $item)
                            @php
                                $receivedQuantity = $purchaseOrder->receipts()
                                    ->where('status', 'confirmed')
                                    ->get()
                                    ->flatMap(function($receipt) {
                                        return $receipt->items;
                                    })
                                    ->where('purchase_order_item_id', $item->id)
                                    ->sum('received_quantity');
                                
                                $remainingQuantity = $item->quantity - $receivedQuantity;
                                $totalPrice = $item->quantity * $item->unit_price;
                                $taxAmount = $totalPrice * ($item->tax_rate / 100);
                                $totalWithTax = $totalPrice + $taxAmount;
                            @endphp
                            <tr>
                                <td>
                                    <strong>{{ $item->product->name }}</strong>
                                    <br><small class="text-muted">{{ $item->product->sku }}</small>
                                </td>
                                <td>{{ number_format($item->quantity) }}</td>
                                <td>
                                    <span class="badge bg-{{ $receivedQuantity > 0 ? 'success' : 'secondary' }}">
                                        {{ number_format($receivedQuantity) }}
                                    </span>
                                </td>
                                <td>
                                    <span class="badge bg-{{ $remainingQuantity > 0 ? 'warning' : 'success' }}">
                                        {{ number_format($remainingQuantity) }}
                                    </span>
                                </td>
                                <td>{{ number_format($item->unit_price, 2) }} ر.س</td>
                                <td>{{ number_format($item->tax_rate, 1) }}%</td>
                                <td>{{ number_format($totalWithTax, 2) }} ر.س</td>
                                <td>
                                    @if($remainingQuantity == 0)
                                        <span class="badge bg-success">مكتمل</span>
                                    @elseif($receivedQuantity > 0)
                                        <span class="badge bg-warning">جزئي</span>
                                    @else
                                        <span class="badge bg-secondary">معلق</span>
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        
        <!-- عمليات الاستلام -->
        @if($purchaseOrder->receipts->count() > 0)
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-dolly me-2"></i>
                    عمليات الاستلام
                </h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                            <tr>
                                <th>رقم الاستلام</th>
                                <th>تاريخ الاستلام</th>
                                <th>عدد العناصر</th>
                                <th>الكمية المستلمة</th>
                                <th>الحالة</th>
                                <th>المستلم</th>
                                <th>الإجراء</th>
                            </tr>
                        <tbody>
                            @foreach($purchaseOrder->receipts as $receipt)
                            <tr>
                                <td>{{ $receipt->receipt_number }}</td>
                                <td>{{ $receipt->receipt_date->format('Y/m/d') }}</td>
                                <td>{{ $receipt->items->count() }}</td>
                                <td>{{ $receipt->items->sum('received_quantity') }}</td>
                                <td>
                                    @switch($receipt->status)
                                        @case('pending')
                                            <span class="badge bg-warning">معلق</span>
                                            @break
                                        @case('confirmed')
                                            <span class="badge bg-success">مؤكد</span>
                                            @break
                                        @case('cancelled')
                                            <span class="badge bg-danger">ملغي</span>
                                            @break
                                    @endswitch
                                </td>
                                <td>{{ $receipt->user->name }}</td>
                                <td>
                                    <a href="{{ route('goods-receipts.show', $receipt) }}" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        @endif
    </div>
    
    <!-- ملخص أمر الشراء -->
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-calculator me-2"></i>
                    ملخص الأمر
                </h5>
            </div>
            <div class="card-body">
                <table class="table table-borderless">
                    <tr>
                        <td>المجموع الفرعي:</td>
                        <td class="text-end">{{ number_format($purchaseOrder->subtotal_amount, 2) }} ر.س</td>
                    </tr>
                    <tr>
                        <td>الضريبة:</td>
                        <td class="text-end">{{ number_format($purchaseOrder->tax_amount, 2) }} ر.س</td>
                    </tr>
                    <tr class="table-primary">
                        <td><strong>المجموع الكلي:</strong></td>
                        <td class="text-end"><strong>{{ number_format($purchaseOrder->total_amount, 2) }} ر.س</strong></td>
                    </tr>
                </table>
                
                <hr>
                
                @php
                    $totalOrdered = $purchaseOrder->items->sum('quantity');
                    $totalReceived = $purchaseOrder->receipts()
                        ->where('status', 'confirmed')
                        ->get()
                        ->sum(function($receipt) {
                            return $receipt->items->sum('received_quantity');
                        });
                    $completionPercentage = $totalOrdered > 0 ? ($totalReceived / $totalOrdered) * 100 : 0;
                @endphp
                
                <div class="mb-3">
                    <strong>تقدم الاستلام:</strong>
                    <div class="progress mt-2">
                        <div class="progress-bar bg-{{ $completionPercentage == 100 ? 'success' : ($completionPercentage > 0 ? 'warning' : 'secondary') }}" 
                             style="width: {{ $completionPercentage }}%">
                            {{ number_format($completionPercentage, 1) }}%
                        </div>
                    </div>
                    <small class="text-muted">
                        {{ number_format($totalReceived) }} من {{ number_format($totalOrdered) }} مستلم
                    </small>
                </div>
                
                <div class="text-center">
                    <h4>{{ $purchaseOrder->items->count() }}</h4>
                    <p class="mb-0">إجمالي العناصر</p>
                </div>
            </div>
        </div>
        
        <!-- معلومات المورد -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-truck me-2"></i>
                    معلومات المورد
                </h5>
            </div>
            <div class="card-body">
                <div class="text-center mb-3">
                    <h6>{{ $purchaseOrder->supplier->name }}</h6>
                    @if($purchaseOrder->supplier->name_en)
                        <small class="text-muted">{{ $purchaseOrder->supplier->name_en }}</small>
                    @endif
                </div>
                
                <table class="table table-sm table-borderless">
                    <tr>
                        <td><i class="fas fa-user me-2"></i></td>
                        <td>{{ $purchaseOrder->supplier->contact_person ?? '-' }}</td>
                    </tr>
                    <tr>
                        <td><i class="fas fa-envelope me-2"></i></td>
                        <td>{{ $purchaseOrder->supplier->email ?? '-' }}</td>
                    </tr>
                    <tr>
                        <td><i class="fas fa-phone me-2"></i></td>
                        <td>{{ $purchaseOrder->supplier->phone ?? '-' }}</td>
                    </tr>
                    <tr>
                        <td><i class="fas fa-credit-card me-2"></i></td>
                        <td>{{ $purchaseOrder->supplier->payment_terms ?? '-' }}</td>
                    </tr>
                </table>
                
                <div class="d-grid">
                    <a href="{{ route('suppliers.show', $purchaseOrder->supplier) }}" class="btn btn-outline-primary btn-sm">
                        <i class="fas fa-eye me-2"></i>
                        عرض تفاصيل المورد
                    </a>
                </div>
            </div>
        </div>
        
        <!-- الإجراءات السريعة -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-bolt me-2"></i>
                    إجراءات سريعة
                </h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    @if(in_array($purchaseOrder->status, ['approved', 'sent', 'partially_received']))
                        <a href="{{ route('goods-receipts.create', ['purchase_order_id' => $purchaseOrder->id]) }}" 
                           class="btn btn-warning btn-sm">
                            <i class="fas fa-dolly me-2"></i>
                            تسجيل استلام
                        </a>
                    @endif
                    
                    <a href="{{ route('purchase-orders.create', ['supplier_id' => $purchaseOrder->supplier->id]) }}" 
                       class="btn btn-info btn-sm">
                        <i class="fas fa-plus me-2"></i>
                        أمر شراء جديد
                    </a>
                    
                    <button type="button" class="btn btn-success btn-sm" onclick="window.print()">
                        <i class="fas fa-print me-2"></i>
                        طباعة الأمر
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
@media print {
    .btn, .card-header, .d-print-none {
        display: none !important;
    }
    
    .card {
        border: 1px solid #000 !important;
        box-shadow: none !important;
        margin-bottom: 20px !important;
    }
    
    .badge {
        color: #000 !important;
        background-color: #fff !important;
        border: 1px solid #000 !important;
    }
}
</style>
@endpush