@extends('layouts.app')

@section('title', 'أوامر الشراء')
@section('page-title', 'إدارة أوامر الشراء')

@section('page-actions')
    <a href="{{ route('purchase-orders.create') }}" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>
        إنشاء أمر شراء جديد
    </a>
@endsection

@section('content')
<!-- فلاتر البحث -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('purchase-orders.index') }}">
            <div class="row">
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="supplier_id" class="form-label">المورد</label>
                        <select class="form-control" id="supplier_id" name="supplier_id">
                            <option value="">جميع الموردين</option>
                            @foreach($suppliers as $supplier)
                                <option value="{{ $supplier->id }}" {{ request('supplier_id') == $supplier->id ? 'selected' : '' }}>
                                    {{ $supplier->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="status" class="form-label">الحالة</label>
                        <select class="form-control" id="status" name="status">
                            <option value="">جميع الحالات</option>
                            <option value="draft" {{ request('status') == 'draft' ? 'selected' : '' }}>مسودة</option>
                            <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>معلق</option>
                            <option value="approved" {{ request('status') == 'approved' ? 'selected' : '' }}>مؤكد</option>
                            <option value="sent" {{ request('status') == 'sent' ? 'selected' : '' }}>مرسل</option>
                            <option value="partially_received" {{ request('status') == 'partially_received' ? 'selected' : '' }}>مستلم جزئي</option>
                            <option value="received" {{ request('status') == 'received' ? 'selected' : '' }}>مستلم</option>
                            <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label class="form-label">&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-search me-2"></i>
                                بحث
                            </button>
                            <a href="{{ route('purchase-orders.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times me-2"></i>
                                إعادة تعيين
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- قائمة أوامر الشراء -->
<div class="card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fas fa-shopping-cart me-2"></i>
            قائمة أوامر الشراء
        </h5>
    </div>
    <div class="card-body">
        @if($purchaseOrders->count() > 0)
        <div class="table-responsive">
            <table class="table table-striped">
                    <tr>
                        <th>رقم الأمر</th>
                        <th>المورد</th>
                        <th>تاريخ الأمر</th>
                        <th>تاريخ التسليم المتوقع</th>
                        <th>المبلغ الإجمالي</th>
                        <th>الحالة</th>
                        <th>المنشئ</th>
                        <th>الإجراءات</th>
                    </tr>
                    @foreach($purchaseOrders as $order)
                    <tr>
                        <td>
                            <strong>{{ $order->po_number }}</strong>
                        </td>
                        <td>{{ $order->supplier->name }}</td>
                        <td>{{ $order->order_date->format('Y/m/d') }}</td>
                        <td>{{ $order->expected_delivery_date ? $order->expected_delivery_date->format('Y/m/d') : '-' }}</td>
                        <td>{{ number_format($order->total_amount, 2) }} ر.س</td>
                        <td>
                            @switch($order->status)
                                @case('draft')
                                    <span class="badge bg-secondary">مسودة</span>
                                    @break
                                @case('pending')
                                    <span class="badge bg-warning">معلق</span>
                                    @break
                                @case('approved')
                                    <span class="badge bg-info">مؤكد</span>
                                    @break
                                @case('sent')
                                    <span class="badge bg-primary">مرسل</span>
                                    @break
                                @case('partially_received')
                                    <span class="badge bg-warning">مستلم جزئي</span>
                                    @break
                                @case('received')
                                    <span class="badge bg-success">مستلم</span>
                                    @break
                                @case('cancelled')
                                    <span class="badge bg-danger">ملغي</span>
                                    @break
                            @endswitch
                        </td>
                        <td>{{ $order->user->name }}</td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="{{ route('purchase-orders.show', $order) }}" class="btn btn-sm btn-info">
                                    <i class="fas fa-eye"></i>
                                </a>
                                
                                @if(in_array($order->status, ['draft', 'pending']))
                                    <a href="{{ route('purchase-orders.edit', $order) }}" class="btn btn-sm btn-warning">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                @endif
                                
                                @if($order->status == 'draft')
                                    <form method="POST" action="{{ route('purchase-orders.update-status', $order) }}" class="d-inline">
                                        @csrf
                                        @method('PATCH')
                                        <input type="hidden" name="status" value="pending">
                                        <button type="submit" class="btn btn-sm btn-success" 
                                                onclick="return confirm('تأكيد إرسال أمر الشراء؟')">
                                            <i class="fas fa-paper-plane"></i>
                                        </button>
                                    </form>
                                @endif
                                
                                @if($order->status == 'pending')
                                    <form method="POST" action="{{ route('purchase-orders.update-status', $order) }}" class="d-inline">
                                        @csrf
                                        @method('PATCH')
                                        <input type="hidden" name="status" value="approved">
                                        <button type="submit" class="btn btn-sm btn-primary" 
                                                onclick="return confirm('تأكيد اعتماد أمر الشراء؟')">
                                            <i class="fas fa-check"></i>
                                        </button>
                                    </form>
                                @endif
                                
                                @if(in_array($order->status, ['approved', 'sent']))
                                    <a href="{{ route('goods-receipts.create', ['purchase_order_id' => $order->id]) }}" 
                                       class="btn btn-sm btn-success">
                                        <i class="fas fa-dolly"></i>
                                    </a>
                                @endif
                                
                                @if(in_array($order->status, ['draft', 'cancelled']))
                                    <form method="POST" action="{{ route('purchase-orders.destroy', $order) }}" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger" 
                                                onclick="return confirm('هل أنت متأكد من حذف أمر الشراء؟')">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @endforeach
            </table>
        </div>
        
        <div class="d-flex justify-content-center">
            {{ $purchaseOrders->links() }}
        </div>
        @else
        <div class="text-center py-5">
            <i class="fas fa-shopping-cart text-muted" style="font-size: 4rem;"></i>
            <h4 class="mt-3 text-muted">لا توجد أوامر شراء</h4>
            <p class="text-muted">ابدأ بإنشاء أول أمر شراء</p>
            <a href="{{ route('purchase-orders.create') }}" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i>
                إنشاء أمر شراء جديد
            </a>
        </div>
        @endif
    </div>
</div>

<!-- إحصائيات سريعة -->
@if($purchaseOrders->count() > 0)
<div class="row mt-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ $purchaseOrders->count() }}</h4>
                        <p class="mb-0">إجمالي الأوامر</p>
                    </div>
                    <div>
                        <i class="fas fa-shopping-cart fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ $purchaseOrders->where('status', 'pending')->count() }}</h4>
                        <p class="mb-0">أوامر معلقة</p>
                    </div>
                    <div>
                        <i class="fas fa-clock fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-info text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ $purchaseOrders->where('status', 'approved')->count() }}</h4>
                        <p class="mb-0">أوامر مؤكدة</p>
                    </div>
                    <div>
                        <i class="fas fa-check fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ number_format($purchaseOrders->sum('total_amount'), 0) }}</h4>
                        <p class="mb-0">إجمالي القيمة (ر.س)</p>
                    </div>
                    <div>
                        <i class="fas fa-money-bill fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endif
@endsection