@extends('layouts.app')

@section('title', 'تفاصيل فاتورة الشراء')
@section('page-title', 'فاتورة الشراء: ' . $purchaseInvoice->invoice_number)

@section('page-actions')
    <div class="btn-group" role="group">
        @if($purchaseInvoice->status === 'pending')
            <button type="button" class="btn btn-success" onclick="approveInvoice()">
                <i class="fas fa-check me-2"></i>
                اعتماد الفاتورة
            </button>
        @endif
        
        @if($purchaseInvoice->status === 'approved')
            <button type="button" class="btn btn-info" data-bs-toggle="modal" data-bs-target="#receiveModal">
                <i class="fas fa-truck me-2"></i>
                تسجيل الاستلام
            </button>
        @endif
        
        @if($purchaseInvoice->remaining_amount > 0 && in_array($purchaseInvoice->status, ['approved', 'received']))
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#paymentModal">
                <i class="fas fa-money-bill-wave me-2"></i>
                إضافة دفعة
            </button>
        @endif
        
        @if($purchaseInvoice->status === 'draft')
            <a href="{{ route('purchase-invoices.edit', $purchaseInvoice) }}" class="btn btn-warning">
                <i class="fas fa-edit me-2"></i>
                تعديل
            </a>
        @endif
        
        <a href="{{ route('purchase-invoices.print', $purchaseInvoice) }}" class="btn btn-secondary" target="_blank">
            <i class="fas fa-print me-2"></i>
            طباعة
        </a>
        
        @if(in_array($purchaseInvoice->status, ['draft', 'pending', 'approved']))
            <button type="button" class="btn btn-danger" onclick="cancelInvoice()">
                <i class="fas fa-times me-2"></i>
                إلغاء الفاتورة
            </button>
        @endif
        
        <a href="{{ route('purchase-invoices.index') }}" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-right me-2"></i>
            العودة للقائمة
        </a>
    </div>
@endsection

@section('content')
<div class="row">
    <!-- معلومات الفاتورة -->
    <div class="col-lg-8 mb-4">
        <div class="card">
            <div class="card-header bg-light">
                <h6 class="card-title mb-0">
                    <i class="fas fa-file-invoice me-2"></i>
                    معلومات الفاتورة
                </h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <td><strong>رقم الفاتورة:</strong></td>
                                <td>{{ $purchaseInvoice->invoice_number }}</td>
                            </tr>
                            @if($purchaseInvoice->supplier_invoice_number)
                            <tr>
                                <td><strong>رقم فاتورة المورد:</strong></td>
                                <td>{{ $purchaseInvoice->supplier_invoice_number }}</td>
                            </tr>
                            @endif
                            <tr>
                                <td><strong>المورد:</strong></td>
                                <td>
                                    <a href="{{ route('suppliers.show', $purchaseInvoice->supplier) }}" class="text-decoration-none">
                                        {{ $purchaseInvoice->supplier->name }}
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>تاريخ الفاتورة:</strong></td>
                                <td>{{ $purchaseInvoice->invoice_date->format('d/m/Y') }}</td>
                            </tr>
                            <tr>
                                <td><strong>تاريخ الاستحقاق:</strong></td>
                                <td>
                                    {{ $purchaseInvoice->due_date->format('d/m/Y') }}
                                    @if($purchaseInvoice->is_overdue)
                                        <span class="badge bg-danger ms-2">متأخر {{ $purchaseInvoice->days_overdue }} يوم</span>
                                    @endif
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            @if($purchaseInvoice->costCenter)
                            <tr>
                                <td><strong>مركز التكلفة:</strong></td>
                                <td>{{ $purchaseInvoice->costCenter->name }}</td>
                            </tr>
                            @endif
                            @if($purchaseInvoice->reference)
                            <tr>
                                <td><strong>المرجع:</strong></td>
                                <td>{{ $purchaseInvoice->reference }}</td>
                            </tr>
                            @endif
                            <tr>
                                <td><strong>طريقة الدفع:</strong></td>
                                <td>
                                    @switch($purchaseInvoice->payment_method)
                                        @case('cash') نقداً @break
                                        @case('credit') آجل @break
                                        @case('bank_transfer') تحويل بنكي @break
                                        @case('check') شيك @break
                                        @case('credit_card') بطاقة ائتمان @break
                                        @default {{ $purchaseInvoice->payment_method }}
                                    @endswitch
                                </td>
                            </tr>
                            <tr>
                                <td><strong>الحالة:</strong></td>
                                <td>
                                    @switch($purchaseInvoice->status)
                                        @case('draft')
                                            <span class="badge bg-secondary">مسودة</span>
                                            @break
                                        @case('pending')
                                            <span class="badge bg-warning">معلقة</span>
                                            @break
                                        @case('approved')
                                            <span class="badge bg-info">معتمدة</span>
                                            @break
                                        @case('received')
                                            <span class="badge bg-success">مستلمة</span>
                                            @break
                                        @case('cancelled')
                                            <span class="badge bg-danger">ملغاة</span>
                                            @break
                                    @endswitch
                                </td>
                            </tr>
                            <tr>
                                <td><strong>حالة الدفع:</strong></td>
                                <td>
                                    @switch($purchaseInvoice->payment_status)
                                        @case('unpaid')
                                            <span class="badge bg-danger">غير مدفوعة</span>
                                            @break
                                        @case('partial')
                                            <span class="badge bg-warning">مدفوعة جزئياً</span>
                                            @break
                                        @case('paid')
                                            <span class="badge bg-success">مدفوعة</span>
                                            @break
                                        @case('overdue')
                                            <span class="badge bg-dark">متأخرة</span>
                                            @break
                                    @endswitch
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
                
                @if($purchaseInvoice->delivery_address)
                <div class="row mt-3">
                    <div class="col-12">
                        <strong>عنوان التسليم:</strong>
                        <p class="mb-0">{{ $purchaseInvoice->delivery_address }}</p>
                    </div>
                </div>
                @endif
                
                @if($purchaseInvoice->notes)
                <div class="row mt-3">
                    <div class="col-12">
                        <strong>ملاحظات:</strong>
                        <p class="mb-0">{{ $purchaseInvoice->notes }}</p>
                    </div>
                </div>
                @endif
            </div>
        </div>
        
        <!-- تفاصيل الأصناف -->
        <div class="card mt-4">
            <div class="card-header bg-light">
                <h6 class="card-title mb-0">
                    <i class="fas fa-list me-2"></i>
                    تفاصيل الأصناف
                </h6>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>الصنف</th>
                                <th class="text-center">الكمية المطلوبة</th>
                                <th class="text-center">الكمية المستلمة</th>
                                <th class="text-center">سعر الوحدة</th>
                                <th class="text-center">الخصم</th>
                                <th class="text-center">بعد الخصم</th>
                                <th class="text-center">الضريبة</th>
                                <th class="text-center">المجموع</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($purchaseInvoice->purchaseInvoiceDetails as $detail)
                            <tr>
                                <td>
                                    <strong>{{ $detail->item->name }}</strong>
                                    @if($detail->item_description)
                                        <br><small class="text-muted">{{ $detail->item_description }}</small>
                                    @endif
                                    @if($detail->batch_number)
                                        <br><small class="text-info">رقم الدفعة: {{ $detail->batch_number }}</small>
                                    @endif
                                    @if($detail->expiry_date)
                                        <br><small class="text-warning">انتهاء الصلاحية: {{ $detail->expiry_date->format('d/m/Y') }}</small>
                                    @endif
                                </td>
                                <td class="text-center">{{ number_format($detail->quantity, 3) }} {{ $detail->unit }}</td>
                                <td class="text-center">
                                    {{ number_format($detail->received_quantity, 3) }} {{ $detail->unit }}
                                    @if($detail->received_quantity > 0)
                                        <div class="progress mt-1" style="height: 4px;">
                                            <div class="progress-bar" style="width: {{ $detail->received_percentage }}%"></div>
                                        </div>
                                        <small class="text-muted">{{ number_format($detail->received_percentage, 1) }}%</small>
                                    @endif
                                </td>
                                <td class="text-center">{{ number_format($detail->unit_price, 2) }} ر.س</td>
                                <td class="text-center">
                                    @if($detail->discount_amount > 0)
                                        {{ number_format($detail->discount_amount, 2) }} ر.س
                                        @if($detail->discount_percentage > 0)
                                            <br><small class="text-muted">({{ $detail->discount_percentage }}%)</small>
                                        @endif
                                    @else
                                        -
                                    @endif
                                </td>
                                <td class="text-center">{{ number_format($detail->net_price, 2) }} ر.س</td>
                                <td class="text-center">
                                    {{ number_format($detail->tax_amount, 2) }} ر.س
                                    @if($detail->tax_percentage > 0)
                                        <br><small class="text-muted">({{ $detail->tax_percentage }}%)</small>
                                    @endif
                                </td>
                                <td class="text-center">
                                    <strong>{{ number_format($detail->total_amount, 2) }} ر.س</strong>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <!-- ملخص المبالغ ومعلومات إضافية -->
    <div class="col-lg-4">
        <!-- ملخص المبالغ -->
        <div class="card mb-4">
            <div class="card-header bg-light">
                <h6 class="card-title mb-0">
                    <i class="fas fa-calculator me-2"></i>
                    ملخص المبالغ
                </h6>
            </div>
            <div class="card-body">
                <table class="table table-borderless">
                    <tr>
                        <td>المجموع الفرعي:</td>
                        <td class="text-end">{{ number_format($purchaseInvoice->subtotal, 2) }} ر.س</td>
                    </tr>
                    @if($purchaseInvoice->discount_amount > 0)
                    <tr>
                        <td>
                            الخصم:
                            @if($purchaseInvoice->discount_percentage > 0)
                                <br><small class="text-muted">({{ $purchaseInvoice->discount_percentage }}%)</small>
                            @endif
                        </td>
                        <td class="text-end text-success">-{{ number_format($purchaseInvoice->discount_amount, 2) }} ر.س</td>
                    </tr>
                    <tr>
                        <td>بعد الخصم:</td>
                        <td class="text-end">{{ number_format($purchaseInvoice->subtotal - $purchaseInvoice->discount_amount, 2) }} ر.س</td>
                    </tr>
                    @endif
                    @if($purchaseInvoice->tax_amount > 0)
                    <tr>
                        <td>
                            الضريبة:
                            @if($purchaseInvoice->tax_percentage > 0)
                                <br><small class="text-muted">({{ $purchaseInvoice->tax_percentage }}%)</small>
                            @endif
                        </td>
                        <td class="text-end">{{ number_format($purchaseInvoice->tax_amount, 2) }} ر.س</td>
                    </tr>
                    @endif
                    @if($purchaseInvoice->shipping_amount > 0)
                    <tr>
                        <td>الشحن:</td>
                        <td class="text-end">{{ number_format($purchaseInvoice->shipping_amount, 2) }} ر.س</td>
                    </tr>
                    @endif
                    @if($purchaseInvoice->other_charges > 0)
                    <tr>
                        <td>مصاريف أخرى:</td>
                        <td class="text-end">{{ number_format($purchaseInvoice->other_charges, 2) }} ر.س</td>
                    </tr>
                    @endif
                    <tr class="border-top">
                        <td><strong>الإجمالي:</strong></td>
                        <td class="text-end"><strong>{{ number_format($purchaseInvoice->total_amount, 2) }} ر.س</strong></td>
                    </tr>
                    <tr>
                        <td>المبلغ المدفوع:</td>
                        <td class="text-end text-success">{{ number_format($purchaseInvoice->paid_amount, 2) }} ر.س</td>
                    </tr>
                    <tr class="table-warning">
                        <td><strong>المبلغ المتبقي:</strong></td>
                        <td class="text-end">
                            <strong class="text-{{ $purchaseInvoice->remaining_amount > 0 ? 'danger' : 'success' }}">
                                {{ number_format($purchaseInvoice->remaining_amount, 2) }} ر.س
                            </strong>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        
        <!-- معلومات المورد -->
        <div class="card mb-4">
            <div class="card-header bg-light">
                <h6 class="card-title mb-0">
                    <i class="fas fa-user-tie me-2"></i>
                    معلومات المورد
                </h6>
            </div>
            <div class="card-body">
                <div class="text-center mb-3">
                    <h6>{{ $purchaseInvoice->supplier->name }}</h6>
                    @if($purchaseInvoice->supplier->name_en)
                        <small class="text-muted">{{ $purchaseInvoice->supplier->name_en }}</small>
                    @endif
                </div>
                
                <table class="table table-borderless table-sm">
                    @if($purchaseInvoice->supplier->contact_person)
                    <tr>
                        <td><i class="fas fa-user me-2"></i></td>
                        <td>{{ $purchaseInvoice->supplier->contact_person }}</td>
                    </tr>
                    @endif
                    @if($purchaseInvoice->supplier->email)
                    <tr>
                        <td><i class="fas fa-envelope me-2"></i></td>
                        <td>{{ $purchaseInvoice->supplier->email }}</td>
                    </tr>
                    @endif
                    @if($purchaseInvoice->supplier->phone)
                    <tr>
                        <td><i class="fas fa-phone me-2"></i></td>
                        <td>{{ $purchaseInvoice->supplier->phone }}</td>
                    </tr>
                    @endif
                    @if($purchaseInvoice->supplier->payment_terms)
                    <tr>
                        <td><i class="fas fa-credit-card me-2"></i></td>
                        <td>{{ $purchaseInvoice->supplier->payment_terms }}</td>
                    </tr>
                    @endif
                </table>
                
                <div class="d-grid">
                    <a href="{{ route('suppliers.show', $purchaseInvoice->supplier) }}" class="btn btn-outline-primary btn-sm">
                        <i class="fas fa-eye me-2"></i>
                        عرض ملف المورد
                    </a>
                </div>
            </div>
        </div>
        
        <!-- إحصائيات سريعة -->
        <div class="card">
            <div class="card-header bg-light">
                <h6 class="card-title mb-0">
                    <i class="fas fa-chart-line me-2"></i>
                    إحصائيات
                </h6>
            </div>
            <div class="card-body">
                @php
                    $totalItems = $purchaseInvoice->purchaseInvoiceDetails->count();
                    $totalQuantity = $purchaseInvoice->purchaseInvoiceDetails->sum('quantity');
                    $receivedQuantity = $purchaseInvoice->purchaseInvoiceDetails->sum('received_quantity');
                    $receivedPercentage = $totalQuantity > 0 ? ($receivedQuantity / $totalQuantity) * 100 : 0;
                @endphp
                
                <div class="row text-center">
                    <div class="col-4">
                        <div class="h6 mb-0 text-primary">{{ $totalItems }}</div>
                        <small class="text-muted">أصناف</small>
                    </div>
                    <div class="col-4">
                        <div class="h6 mb-0 text-info">{{ number_format($totalQuantity, 0) }}</div>
                        <small class="text-muted">كمية مطلوبة</small>
                    </div>
                    <div class="col-4">
                        <div class="h6 mb-0 text-success">{{ number_format($receivedQuantity, 0) }}</div>
                        <small class="text-muted">كمية مستلمة</small>
                    </div>
                </div>
                
                <div class="mt-3">
                    <div class="d-flex justify-content-between mb-1">
                        <small>نسبة الاستلام</small>
                        <small>{{ number_format($receivedPercentage, 1) }}%</small>
                    </div>
                    <div class="progress" style="height: 6px;">
                        <div class="progress-bar" style="width: {{ $receivedPercentage }}%"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

<!-- مودال تسجيل الاستلام -->
<div class="modal fade" id="receiveModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="receiveForm">
                <div class="modal-header">
                    <h5 class="modal-title">تسجيل استلام البضاعة</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="received_by" class="form-label">تم الاستلام بواسطة</label>
                        <input type="text" class="form-control" id="received_by" value="{{ auth()->user()->name }}">
                    </div>
                    
                    <h6>تفاصيل الاستلام:</h6>
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>الصنف</th>
                                    <th class="text-center">المطلوب</th>
                                    <th class="text-center">المستلم</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($purchaseInvoice->purchaseInvoiceDetails as $detail)
                                <tr>
                                    <td>{{ $detail->item->name }}</td>
                                    <td class="text-center">{{ number_format($detail->quantity, 3) }}</td>
                                    <td class="text-center">
                                        <input type="hidden" name="items[{{ $detail->id }}][id]" value="{{ $detail->id }}">
                                        <input type="number" class="form-control form-control-sm" 
                                               name="items[{{ $detail->id }}][received_quantity]" 
                                               value="{{ $detail->quantity }}" 
                                               min="0" max="{{ $detail->quantity }}" step="0.001">
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">تأكيد الاستلام</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- مودال إضافة دفعة -->
<div class="modal fade" id="paymentModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="paymentForm">
                <div class="modal-header">
                    <h5 class="modal-title">إضافة دفعة</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="payment_amount" class="form-label">مبلغ الدفعة (ر.س)</label>
                        <input type="number" class="form-control" id="payment_amount" 
                               value="{{ $purchaseInvoice->remaining_amount }}" 
                               max="{{ $purchaseInvoice->remaining_amount }}" 
                               step="0.01" min="0.01" required>
                        <small class="text-muted">الحد الأقصى: {{ number_format($purchaseInvoice->remaining_amount, 2) }} ر.س</small>
                    </div>
                    <div class="mb-3">
                        <label for="payment_date" class="form-label">تاريخ الدفعة</label>
                        <input type="date" class="form-control" id="payment_date" value="{{ date('Y-m-d') }}" required>
                    </div>
                    <div class="mb-3">
                        <label for="payment_method_modal" class="form-label">طريقة الدفع</label>
                        <select class="form-control" id="payment_method_modal" required>
                            <option value="cash">نقداً</option>
                            <option value="bank_transfer">تحويل بنكي</option>
                            <option value="check">شيك</option>
                            <option value="credit_card">بطاقة ائتمان</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="payment_reference" class="form-label">المرجع</label>
                        <input type="text" class="form-control" id="payment_reference">
                    </div>
                    <div class="mb-3">
                        <label for="payment_notes" class="form-label">ملاحظات</label>
                        <textarea class="form-control" id="payment_notes" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">تسجيل الدفعة</button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
    function approveInvoice() {
        if (confirm('هل تريد اعتماد هذه الفاتورة؟')) {
            fetch(`/purchase-invoices/{{ $purchaseInvoice->id }}/approve`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert('حدث خطأ في اعتماد الفاتورة');
                }
            });
        }
    }
    
    function cancelInvoice() {
        if (confirm('هل تريد إلغاء هذه الفاتورة؟ لا يمكن التراجع عن هذا الإجراء.')) {
            fetch(`/purchase-invoices/{{ $purchaseInvoice->id }}/cancel`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert('حدث خطأ في إلغاء الفاتورة');
                }
            });
        }
    }
    
    // معالج نموذج تسجيل الاستلام
    document.getElementById('receiveForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const data = {
            received_by: document.getElementById('received_by').value,
            items: {}
        };
        
        // جمع بيانات الأصناف
        document.querySelectorAll('input[name^="items["]').forEach(input => {
            const matches = input.name.match(/items\[(\d+)\]\[(.+)\]/);
            if (matches) {
                const itemId = matches[1];
                const field = matches[2];
                
                if (!data.items[itemId]) {
                    data.items[itemId] = {};
                }
                data.items[itemId][field] = input.value;
            }
        });
        
        // تحويل إلى مصفوفة
        data.items = Object.values(data.items);
        
        fetch(`/purchase-invoices/{{ $purchaseInvoice->id }}/mark-received`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify(data)
        })
        .then(response => response.json())
        .then(result => {
            if (result.success) {
                bootstrap.Modal.getInstance(document.getElementById('receiveModal')).hide();
                location.reload();
            } else {
                alert('حدث خطأ في تسجيل الاستلام');
            }
        });
    });
    
    // معالج نموذج إضافة الدفعة
    document.getElementById('paymentForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = {
            payment_amount: document.getElementById('payment_amount').value,
            payment_date: document.getElementById('payment_date').value,
            payment_method: document.getElementById('payment_method_modal').value,
            reference: document.getElementById('payment_reference').value,
            notes: document.getElementById('payment_notes').value
        };
        
        fetch(`/purchase-invoices/{{ $purchaseInvoice->id }}/add-payment`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify(formData)
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                bootstrap.Modal.getInstance(document.getElementById('paymentModal')).hide();
                location.reload();
            } else {
                alert('حدث خطأ في تسجيل الدفعة');
            }
        });
    });
</script>
@endpush