@extends('layouts.app')

@section('title', 'فواتير الشراء')
@section('page-title', 'فواتير الشراء')

@section('page-actions')
    <div class="btn-group" role="group">
        <a href="{{ route('purchase-invoices.create') }}" class="btn btn-primary">
            <i class="fas fa-plus me-2"></i>
            فاتورة شراء جديدة
        </a>
        <button type="button" class="btn btn-info" data-bs-toggle="modal" data-bs-target="#filterModal">
            <i class="fas fa-filter me-2"></i>
            فلترة متقدمة
        </button>
        <div class="btn-group" role="group">
            <button type="button" class="btn btn-success dropdown-toggle" data-bs-toggle="dropdown">
                <i class="fas fa-download me-2"></i>
                تصدير
            </button>
            <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="{{ route('purchase-invoices.export', request()->query()) }}">
                    <i class="fas fa-file-excel me-2"></i>Excel
                </a></li>
                <li><a class="dropdown-item" href="#" onclick="exportReport('pdf')">
                    <i class="fas fa-file-pdf me-2"></i>PDF
                </a></li>
            </ul>
        </div>
    </div>
@endsection

@section('content')
<!-- إحصائيات سريعة -->
<div class="row mb-4">
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-file-invoice fa-2x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="card-title h5 mb-1">{{ number_format($stats['total_invoices']) }}</div>
                        <div class="card-text small">إجمالي الفواتير</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-clock fa-2x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="card-title h5 mb-1">{{ number_format($stats['pending_invoices']) }}</div>
                        <div class="card-text small">فواتير معلقة</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card text-white bg-danger">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-exclamation-triangle fa-2x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="card-title h5 mb-1">{{ number_format($stats['overdue_invoices']) }}</div>
                        <div class="card-text small">فواتير متأخرة</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card text-white bg-success">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-money-bill-wave fa-2x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="card-title h5 mb-1">{{ number_format($stats['total_amount'], 0) }}</div>
                        <div class="card-text small">إجمالي المبالغ (ر.س)</div>
                    </div>
                </div>
                <div class="mt-2">
                    <small class="text-white-50">غير مدفوع: {{ number_format($stats['unpaid_amount'], 0) }} ر.س</small>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- فلاتر سريعة -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <form method="GET" action="{{ route('purchase-invoices.index') }}" class="row align-items-center">
                    <div class="col-md-3 mb-2">
                        <select name="status" class="form-select" onchange="this.form.submit()">
                            <option value="">جميع الحالات</option>
                            <option value="draft" {{ request('status') === 'draft' ? 'selected' : '' }}>مسودة</option>
                            <option value="pending" {{ request('status') === 'pending' ? 'selected' : '' }}>معلقة</option>
                            <option value="approved" {{ request('status') === 'approved' ? 'selected' : '' }}>معتمدة</option>
                            <option value="received" {{ request('status') === 'received' ? 'selected' : '' }}>مستلمة</option>
                            <option value="cancelled" {{ request('status') === 'cancelled' ? 'selected' : '' }}>ملغاة</option>
                        </select>
                    </div>
                    <div class="col-md-3 mb-2">
                        <select name="payment_status" class="form-select" onchange="this.form.submit()">
                            <option value="">جميع حالات الدفع</option>
                            <option value="unpaid" {{ request('payment_status') === 'unpaid' ? 'selected' : '' }}>غير مدفوعة</option>
                            <option value="partial" {{ request('payment_status') === 'partial' ? 'selected' : '' }}>مدفوعة جزئياً</option>
                            <option value="paid" {{ request('payment_status') === 'paid' ? 'selected' : '' }}>مدفوعة</option>
                            <option value="overdue" {{ request('payment_status') === 'overdue' ? 'selected' : '' }}>متأخرة</option>
                        </select>
                    </div>
                    <div class="col-md-3 mb-2">
                        <select name="supplier_id" class="form-select" onchange="this.form.submit()">
                            <option value="">جميع الموردين</option>
                            @foreach($suppliers as $supplier)
                                <option value="{{ $supplier->id }}" {{ request('supplier_id') == $supplier->id ? 'selected' : '' }}>
                                    {{ $supplier->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3 mb-2">
                        <div class="input-group">
                            <input type="text" name="search" class="form-control" placeholder="البحث..." 
                                   value="{{ request('search') }}">
                            <button type="submit" class="btn btn-outline-primary">
                                <i class="fas fa-search"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- جدول الفواتير -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">قائمة فواتير الشراء</h6>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>رقم الفاتورة</th>
                                <th>المورد</th>
                                <th>تاريخ الفاتورة</th>
                                <th>تاريخ الاستحقاق</th>
                                <th class="text-center">المبلغ الإجمالي</th>
                                <th class="text-center">المبلغ المدفوع</th>
                                <th class="text-center">المبلغ المتبقي</th>
                                <th class="text-center">الحالة</th>
                                <th class="text-center">حالة الدفع</th>
                                <th class="text-center">الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($purchaseInvoices as $invoice)
                            <tr>
                                <td>
                                    <strong>{{ $invoice->invoice_number }}</strong>
                                    @if($invoice->supplier_invoice_number)
                                        <br><small class="text-muted">{{ $invoice->supplier_invoice_number }}</small>
                                    @endif
                                </td>
                                <td>
                                    <a href="{{ route('suppliers.show', $invoice->supplier) }}" class="text-decoration-none">
                                        {{ $invoice->supplier->name }}
                                    </a>
                                </td>
                                <td>{{ $invoice->invoice_date->format('d/m/Y') }}</td>
                                <td>
                                    {{ $invoice->due_date->format('d/m/Y') }}
                                    @if($invoice->is_overdue)
                                        <br><small class="text-danger">متأخر {{ $invoice->days_overdue }} يوم</small>
                                    @endif
                                </td>
                                <td class="text-center">
                                    <strong>{{ number_format($invoice->total_amount, 2) }} ر.س</strong>
                                </td>
                                <td class="text-center">
                                    {{ number_format($invoice->paid_amount, 2) }} ر.س
                                </td>
                                <td class="text-center">
                                    <strong class="text-{{ $invoice->remaining_amount > 0 ? 'danger' : 'success' }}">
                                        {{ number_format($invoice->remaining_amount, 2) }} ر.س
                                    </strong>
                                </td>
                                <td class="text-center">
                                    @switch($invoice->status)
                                        @case('draft')
                                            <span class="badge bg-secondary">مسودة</span>
                                            @break
                                        @case('pending')
                                            <span class="badge bg-warning">معلقة</span>
                                            @break
                                        @case('approved')
                                            <span class="badge bg-info">معتمدة</span>
                                            @break
                                        @case('received')
                                            <span class="badge bg-success">مستلمة</span>
                                            @break
                                        @case('cancelled')
                                            <span class="badge bg-danger">ملغاة</span>
                                            @break
                                    @endswitch
                                </td>
                                <td class="text-center">
                                    @switch($invoice->payment_status)
                                        @case('unpaid')
                                            <span class="badge bg-danger">غير مدفوعة</span>
                                            @break
                                        @case('partial')
                                            <span class="badge bg-warning">جزئياً</span>
                                            @break
                                        @case('paid')
                                            <span class="badge bg-success">مدفوعة</span>
                                            @break
                                        @case('overdue')
                                            <span class="badge bg-dark">متأخرة</span>
                                            @break
                                    @endswitch
                                </td>
                                <td class="text-center">
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="{{ route('purchase-invoices.show', $invoice) }}" 
                                           class="btn btn-outline-info" title="عرض">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        
                                        @if($invoice->status === 'draft')
                                            <a href="{{ route('purchase-invoices.edit', $invoice) }}" 
                                               class="btn btn-outline-warning" title="تعديل">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                        @endif
                                        
                                        @if($invoice->status === 'pending')
                                            <button type="button" class="btn btn-outline-success" 
                                                    onclick="approveInvoice({{ $invoice->id }})" title="اعتماد">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        @endif
                                        
                                        @if($invoice->remaining_amount > 0 && in_array($invoice->status, ['approved', 'received']))
                                            <button type="button" class="btn btn-outline-primary" 
                                                    onclick="addPayment({{ $invoice->id }}, {{ $invoice->remaining_amount }})" 
                                                    title="إضافة دفعة">
                                                <i class="fas fa-money-bill-wave"></i>
                                            </button>
                                        @endif
                                        
                                        <a href="{{ route('purchase-invoices.print', $invoice) }}" 
                                           class="btn btn-outline-secondary" title="طباعة" target="_blank">
                                            <i class="fas fa-print"></i>
                                        </a>
                                        
                                        @if(in_array($invoice->status, ['draft', 'pending']))
                                            <button type="button" class="btn btn-outline-danger" 
                                                    onclick="cancelInvoice({{ $invoice->id }})" title="إلغاء">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="10" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-inbox fa-2x mb-3"></i>
                                        <p>لا توجد فواتير شراء</p>
                                        <a href="{{ route('purchase-invoices.create') }}" class="btn btn-primary">
                                            <i class="fas fa-plus me-2"></i>
                                            إنشاء فاتورة جديدة
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            
            @if($purchaseInvoices->hasPages())
            <div class="card-footer">
                <div class="d-flex justify-content-center">
                    {{ $purchaseInvoices->links() }}
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection

<!-- مودال الفلترة المتقدمة -->
<div class="modal fade" id="filterModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form method="GET" action="{{ route('purchase-invoices.index') }}">
                <div class="modal-header">
                    <h5 class="modal-title">فلترة متقدمة</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="date_from" class="form-label">من تاريخ</label>
                                <input type="date" class="form-control" id="date_from" name="date_from" 
                                       value="{{ request('date_from') }}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="date_to" class="form-label">إلى تاريخ</label>
                                <input type="date" class="form-control" id="date_to" name="date_to" 
                                       value="{{ request('date_to') }}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="amount_from" class="form-label">من مبلغ</label>
                                <input type="number" class="form-control" id="amount_from" name="amount_from" 
                                       value="{{ request('amount_from') }}" step="0.01" min="0">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="amount_to" class="form-label">إلى مبلغ</label>
                                <input type="number" class="form-control" id="amount_to" name="amount_to" 
                                       value="{{ request('amount_to') }}" step="0.01" min="0">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <a href="{{ route('purchase-invoices.index') }}" class="btn btn-outline-warning">إعادة تعيين</a>
                    <button type="submit" class="btn btn-primary">تطبيق الفلتر</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- مودال إضافة دفعة -->
<div class="modal fade" id="paymentModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="paymentForm">
                <div class="modal-header">
                    <h5 class="modal-title">إضافة دفعة</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" id="invoice_id">
                    <div class="mb-3">
                        <label for="payment_amount" class="form-label">مبلغ الدفعة (ر.س)</label>
                        <input type="number" class="form-control" id="payment_amount" step="0.01" min="0.01" required>
                    </div>
                    <div class="mb-3">
                        <label for="payment_date" class="form-label">تاريخ الدفعة</label>
                        <input type="date" class="form-control" id="payment_date" value="{{ date('Y-m-d') }}" required>
                    </div>
                    <div class="mb-3">
                        <label for="payment_method" class="form-label">طريقة الدفع</label>
                        <select class="form-control" id="payment_method" required>
                            <option value="cash">نقداً</option>
                            <option value="bank_transfer">تحويل بنكي</option>
                            <option value="check">شيك</option>
                            <option value="credit_card">بطاقة ائتمان</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="payment_reference" class="form-label">المرجع</label>
                        <input type="text" class="form-control" id="payment_reference">
                    </div>
                    <div class="mb-3">
                        <label for="payment_notes" class="form-label">ملاحظات</label>
                        <textarea class="form-control" id="payment_notes" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">تسجيل الدفعة</button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
    function approveInvoice(invoiceId) {
        if (confirm('هل تريد اعتماد هذه الفاتورة؟')) {
            fetch(`/purchase-invoices/${invoiceId}/approve`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert('حدث خطأ في اعتماد الفاتورة');
                }
            });
        }
    }
    
    function cancelInvoice(invoiceId) {
        if (confirm('هل تريد إلغاء هذه الفاتورة؟')) {
            fetch(`/purchase-invoices/${invoiceId}/cancel`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert('حدث خطأ في إلغاء الفاتورة');
                }
            });
        }
    }
    
    function addPayment(invoiceId, remainingAmount) {
        document.getElementById('invoice_id').value = invoiceId;
        document.getElementById('payment_amount').value = remainingAmount;
        document.getElementById('payment_amount').max = remainingAmount;
        
        const modal = new bootstrap.Modal(document.getElementById('paymentModal'));
        modal.show();
    }
    
    document.getElementById('paymentForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const invoiceId = document.getElementById('invoice_id').value;
        const formData = {
            payment_amount: document.getElementById('payment_amount').value,
            payment_date: document.getElementById('payment_date').value,
            payment_method: document.getElementById('payment_method').value,
            reference: document.getElementById('payment_reference').value,
            notes: document.getElementById('payment_notes').value
        };
        
        fetch(`/purchase-invoices/${invoiceId}/add-payment`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify(formData)
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                bootstrap.Modal.getInstance(document.getElementById('paymentModal')).hide();
                location.reload();
            } else {
                alert('حدث خطأ في تسجيل الدفعة');
            }
        });
    });
    
    function exportReport(format) {
        const params = new URLSearchParams(window.location.search);
        params.set('format', format);
        
        window.open(`{{ route('purchase-invoices.export') }}?${params}`, '_blank');
    }
</script>
@endpush