@extends('layouts.app')

@section('title', 'فاتورة شراء جديدة')
@section('page-title', 'فاتورة شراء جديدة')

@section('page-actions')
    <a href="{{ route('purchase-invoices.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-right me-2"></i>
        العودة للقائمة
    </a>
@endsection

@section('content')
<form id="purchaseInvoiceForm" method="POST" action="{{ route('purchase-invoices.store') }}">
    @csrf
    
    <div class="row">
        <!-- معلومات الفاتورة -->
        <div class="col-lg-8">
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-info-circle me-2"></i>
                        معلومات الفاتورة
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="invoice_number" class="form-label">رقم الفاتورة <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="invoice_number" 
                                       value="{{ $invoiceNumber }}" readonly>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="supplier_invoice_number" class="form-label">رقم فاتورة المورد</label>
                                <input type="text" class="form-control @error('supplier_invoice_number') is-invalid @enderror" 
                                       id="supplier_invoice_number" name="supplier_invoice_number" 
                                       value="{{ old('supplier_invoice_number') }}">
                                @error('supplier_invoice_number')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="supplier_id" class="form-label">المورد <span class="text-danger">*</span></label>
                                <select class="form-control @error('supplier_id') is-invalid @enderror" 
                                        id="supplier_id" name="supplier_id" required>
                                    <option value="">اختر المورد</option>
                                    @foreach($suppliers as $supplier)
                                        <option value="{{ $supplier->id }}" {{ old('supplier_id') == $supplier->id ? 'selected' : '' }}
                                                data-payment-terms="{{ $supplier->payment_terms }}"
                                                data-payment-days="{{ $supplier->payment_terms_days }}">
                                            {{ $supplier->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('supplier_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="cost_center_id" class="form-label">مركز التكلفة</label>
                                <select class="form-control @error('cost_center_id') is-invalid @enderror" 
                                        id="cost_center_id" name="cost_center_id">
                                    <option value="">اختر مركز التكلفة</option>
                                    @foreach($costCenters as $costCenter)
                                        <option value="{{ $costCenter->id }}" {{ old('cost_center_id') == $costCenter->id ? 'selected' : '' }}>
                                            {{ $costCenter->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('cost_center_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="invoice_date" class="form-label">تاريخ الفاتورة <span class="text-danger">*</span></label>
                                <input type="date" class="form-control @error('invoice_date') is-invalid @enderror" 
                                       id="invoice_date" name="invoice_date" 
                                       value="{{ old('invoice_date', date('Y-m-d')) }}" required>
                                @error('invoice_date')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="due_date" class="form-label">تاريخ الاستحقاق <span class="text-danger">*</span></label>
                                <input type="date" class="form-control @error('due_date') is-invalid @enderror" 
                                       id="due_date" name="due_date" 
                                       value="{{ old('due_date') }}" required>
                                @error('due_date')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="payment_method" class="form-label">طريقة الدفع <span class="text-danger">*</span></label>
                                <select class="form-control @error('payment_method') is-invalid @enderror" 
                                        id="payment_method" name="payment_method" required>
                                    <option value="cash" {{ old('payment_method') == 'cash' ? 'selected' : '' }}>نقداً</option>
                                    <option value="credit" {{ old('payment_method', 'credit') == 'credit' ? 'selected' : '' }}>آجل</option>
                                    <option value="bank_transfer" {{ old('payment_method') == 'bank_transfer' ? 'selected' : '' }}>تحويل بنكي</option>
                                    <option value="check" {{ old('payment_method') == 'check' ? 'selected' : '' }}>شيك</option>
                                    <option value="credit_card" {{ old('payment_method') == 'credit_card' ? 'selected' : '' }}>بطاقة ائتمان</option>
                                </select>
                                @error('payment_method')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="reference" class="form-label">المرجع</label>
                                <input type="text" class="form-control @error('reference') is-invalid @enderror" 
                                       id="reference" name="reference" 
                                       value="{{ old('reference') }}">
                                @error('reference')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- تفاصيل الأصناف -->
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-list me-2"></i>
                        أصناف الفاتورة
                    </h6>
                    <button type="button" class="btn btn-primary btn-sm" onclick="addItem()">
                        <i class="fas fa-plus me-2"></i>
                        إضافة صنف
                    </button>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" id="itemsTable">
                            <thead class="table-light">
                                <tr>
                                    <th style="width: 25%">الصنف</th>
                                    <th style="width: 15%">الوصف</th>
                                    <th style="width: 10%">الكمية</th>
                                    <th style="width: 8%">الوحدة</th>
                                    <th style="width: 12%">سعر الوحدة</th>
                                    <th style="width: 10%">خصم %</th>
                                    <th style="width: 10%">ضريبة %</th>
                                    <th style="width: 12%">المجموع</th>
                                    <th style="width: 5%">حذف</th>
                                </tr>
                            </thead>
                            <tbody id="itemsTableBody">
                                <!-- سيتم إضافة الصفوف ديناميكياً -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- ملخص الفاتورة والمعلومات الإضافية -->
        <div class="col-lg-4">
            <!-- ملخص المبالغ -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-calculator me-2"></i>
                        ملخص المبالغ
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="currency" class="form-label">العملة</label>
                            <select class="form-control" id="currency" name="currency">
                                <option value="SAR" selected>ريال سعودي</option>
                                <option value="USD">دولار أمريكي</option>
                                <option value="EUR">يورو</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="exchange_rate" class="form-label">سعر الصرف</label>
                            <input type="number" class="form-control" id="exchange_rate" name="exchange_rate" 
                                   value="1" step="0.0001" min="0.0001">
                        </div>
                    </div>
                    
                    <table class="table table-sm">
                        <tr>
                            <td>المجموع الفرعي:</td>
                            <td class="text-end"><span id="subtotal">0.00</span> ر.س</td>
                        </tr>
                        <tr>
                            <td>
                                الخصم:
                                <div class="input-group input-group-sm mt-1">
                                    <input type="number" class="form-control" id="discount_percentage" 
                                           name="discount_percentage" value="0" min="0" max="100" step="0.01"
                                           onchange="calculateTotals()">
                                    <span class="input-group-text">%</span>
                                </div>
                            </td>
                            <td class="text-end"><span id="discount_amount">0.00</span> ر.س</td>
                        </tr>
                        <tr>
                            <td>بعد الخصم:</td>
                            <td class="text-end"><span id="after_discount">0.00</span> ر.س</td>
                        </tr>
                        <tr>
                            <td>
                                الضريبة:
                                <div class="input-group input-group-sm mt-1">
                                    <input type="number" class="form-control" id="tax_percentage" 
                                           name="tax_percentage" value="15" min="0" max="100" step="0.01"
                                           onchange="calculateTotals()">
                                    <span class="input-group-text">%</span>
                                </div>
                            </td>
                            <td class="text-end"><span id="tax_amount">0.00</span> ر.س</td>
                        </tr>
                        <tr>
                            <td>
                                الشحن:
                                <div class="input-group input-group-sm mt-1">
                                    <input type="number" class="form-control" id="shipping_amount" 
                                           name="shipping_amount" value="0" min="0" step="0.01"
                                           onchange="calculateTotals()">
                                </div>
                            </td>
                            <td class="text-end"><span id="shipping_display">0.00</span> ر.س</td>
                        </tr>
                        <tr>
                            <td>
                                مصاريف أخرى:
                                <div class="input-group input-group-sm mt-1">
                                    <input type="number" class="form-control" id="other_charges" 
                                           name="other_charges" value="0" min="0" step="0.01"
                                           onchange="calculateTotals()">
                                </div>
                            </td>
                            <td class="text-end"><span id="other_charges_display">0.00</span> ر.س</td>
                        </tr>
                        <tr class="table-primary">
                            <td><strong>الإجمالي:</strong></td>
                            <td class="text-end"><strong><span id="total_amount">0.00</span> ر.س</strong></td>
                        </tr>
                    </table>
                </div>
            </div>
            
            <!-- معلومات إضافية -->
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-sticky-note me-2"></i>
                        معلومات إضافية
                    </h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="payment_terms" class="form-label">شروط الدفع</label>
                        <input type="text" class="form-control" id="payment_terms" name="payment_terms" 
                               value="{{ old('payment_terms') }}">
                    </div>
                    <div class="mb-3">
                        <label for="delivery_address" class="form-label">عنوان التسليم</label>
                        <textarea class="form-control" id="delivery_address" name="delivery_address" 
                                  rows="2">{{ old('delivery_address') }}</textarea>
                    </div>
                    <div class="mb-3">
                        <label for="delivery_date" class="form-label">تاريخ التسليم</label>
                        <input type="date" class="form-control" id="delivery_date" name="delivery_date" 
                               value="{{ old('delivery_date') }}">
                    </div>
                    <div class="mb-3">
                        <label for="notes" class="form-label">ملاحظات</label>
                        <textarea class="form-control" id="notes" name="notes" 
                                  rows="3">{{ old('notes') }}</textarea>
                    </div>
                    <div class="mb-3">
                        <label for="terms_conditions" class="form-label">الشروط والأحكام</label>
                        <textarea class="form-control" id="terms_conditions" name="terms_conditions" 
                                  rows="3">{{ old('terms_conditions') }}</textarea>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- أزرار الحفظ -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-end gap-2">
                        <a href="{{ route('purchase-invoices.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times me-2"></i>
                            إلغاء
                        </a>
                        <button type="submit" name="action" value="draft" class="btn btn-outline-primary">
                            <i class="fas fa-save me-2"></i>
                            حفظ كمسودة
                        </button>
                        <button type="submit" name="action" value="pending" class="btn btn-primary">
                            <i class="fas fa-paper-plane me-2"></i>
                            حفظ وإرسال للاعتماد
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
@endsection

@push('scripts')
<script>
    let itemIndex = 0;
    const items = @json($items);
    
    document.addEventListener('DOMContentLoaded', function() {
        // إضافة صف فارغ للبداية
        addItem();
        
        // تحديث تاريخ الاستحقاق عند تغيير المورد
        document.getElementById('supplier_id').addEventListener('change', function() {
            const selectedOption = this.options[this.selectedIndex];
            const paymentDays = selectedOption.dataset.paymentDays || 30;
            const paymentTerms = selectedOption.dataset.paymentTerms || '';
            
            // تحديث تاريخ الاستحقاق
            const invoiceDate = document.getElementById('invoice_date').value;
            if (invoiceDate) {
                const dueDate = new Date(invoiceDate);
                dueDate.setDate(dueDate.getDate() + parseInt(paymentDays));
                document.getElementById('due_date').value = dueDate.toISOString().split('T')[0];
            }
            
            // تحديث شروط الدفع
            document.getElementById('payment_terms').value = paymentTerms;
        });
        
        // تحديث تاريخ الاستحقاق عند تغيير تاريخ الفاتورة
        document.getElementById('invoice_date').addEventListener('change', function() {
            const supplierSelect = document.getElementById('supplier_id');
            const selectedOption = supplierSelect.options[supplierSelect.selectedIndex];
            const paymentDays = selectedOption.dataset.paymentDays || 30;
            
            const dueDate = new Date(this.value);
            dueDate.setDate(dueDate.getDate() + parseInt(paymentDays));
            document.getElementById('due_date').value = dueDate.toISOString().split('T')[0];
        });
    });
    
    function addItem() {
        const tbody = document.getElementById('itemsTableBody');
        const row = document.createElement('tr');
        row.innerHTML = `
            <td>
                <select class="form-control item-select" name="items[${itemIndex}][item_id]" required>
                    <option value="">اختر الصنف</option>
                    ${items.map(item => `<option value="${item.id}" data-price="${item.purchase_price || 0}" data-unit="${item.unit}">${item.name}</option>`).join('')}
                </select>
            </td>
            <td>
                <input type="text" class="form-control" name="items[${itemIndex}][description]" 
                       placeholder="وصف إضافي">
            </td>
            <td>
                <input type="number" class="form-control quantity-input" name="items[${itemIndex}][quantity]" 
                       value="1" min="0.001" step="0.001" required onchange="calculateRowTotal(this)">
            </td>
            <td>
                <input type="text" class="form-control unit-input" name="items[${itemIndex}][unit]" 
                       value="قطعة" required>
            </td>
            <td>
                <input type="number" class="form-control price-input" name="items[${itemIndex}][unit_price]" 
                       value="0" min="0" step="0.01" required onchange="calculateRowTotal(this)">
            </td>
            <td>
                <input type="number" class="form-control discount-input" name="items[${itemIndex}][discount_percentage]" 
                       value="0" min="0" max="100" step="0.01" onchange="calculateRowTotal(this)">
            </td>
            <td>
                <input type="number" class="form-control tax-input" name="items[${itemIndex}][tax_percentage]" 
                       value="15" min="0" max="100" step="0.01" onchange="calculateRowTotal(this)">
            </td>
            <td>
                <input type="text" class="form-control total-input" readonly value="0.00">
            </td>
            <td>
                <button type="button" class="btn btn-danger btn-sm" onclick="removeItem(this)">
                    <i class="fas fa-trash"></i>
                </button>
            </td>
        `;
        
        tbody.appendChild(row);
        
        // إضافة مستمع لتحديد الصنف
        const itemSelect = row.querySelector('.item-select');
        itemSelect.addEventListener('change', function() {
            const selectedOption = this.options[this.selectedIndex];
            const price = selectedOption.dataset.price || 0;
            const unit = selectedOption.dataset.unit || 'قطعة';
            
            const row = this.closest('tr');
            row.querySelector('.price-input').value = price;
            row.querySelector('.unit-input').value = unit;
            
            calculateRowTotal(this);
        });
        
        itemIndex++;
    }
    
    function removeItem(button) {
        const tbody = document.getElementById('itemsTableBody');
        if (tbody.rows.length > 1) {
            button.closest('tr').remove();
            calculateTotals();
        } else {
            alert('يجب أن تحتوي الفاتورة على صنف واحد على الأقل');
        }
    }
    
    function calculateRowTotal(element) {
        const row = element.closest('tr');
        const quantity = parseFloat(row.querySelector('.quantity-input').value) || 0;
        const price = parseFloat(row.querySelector('.price-input').value) || 0;
        const discountPercent = parseFloat(row.querySelector('.discount-input').value) || 0;
        const taxPercent = parseFloat(row.querySelector('.tax-input').value) || 0;
        
        const subtotal = quantity * price;
        const discountAmount = (subtotal * discountPercent) / 100;
        const afterDiscount = subtotal - discountAmount;
        const taxAmount = (afterDiscount * taxPercent) / 100;
        const total = afterDiscount + taxAmount;
        
        row.querySelector('.total-input').value = total.toFixed(2);
        
        calculateTotals();
    }
    
    function calculateTotals() {
        let subtotal = 0;
        
        // حساب المجموع الفرعي من جميع الصفوف
        document.querySelectorAll('.total-input').forEach(input => {
            subtotal += parseFloat(input.value) || 0;
        });
        
        // تطبيق خصم إضافي على الفاتورة
        const discountPercent = parseFloat(document.getElementById('discount_percentage').value) || 0;
        const discountAmount = (subtotal * discountPercent) / 100;
        const afterDiscount = subtotal - discountAmount;
        
        // تطبيق ضريبة إضافية على الفاتورة
        const taxPercent = parseFloat(document.getElementById('tax_percentage').value) || 0;
        const taxAmount = (afterDiscount * taxPercent) / 100;
        
        // إضافة الشحن والمصاريف الأخرى
        const shipping = parseFloat(document.getElementById('shipping_amount').value) || 0;
        const otherCharges = parseFloat(document.getElementById('other_charges').value) || 0;
        
        const total = afterDiscount + taxAmount + shipping + otherCharges;
        
        // تحديث الشاشة
        document.getElementById('subtotal').textContent = subtotal.toFixed(2);
        document.getElementById('discount_amount').textContent = discountAmount.toFixed(2);
        document.getElementById('after_discount').textContent = afterDiscount.toFixed(2);
        document.getElementById('tax_amount').textContent = taxAmount.toFixed(2);
        document.getElementById('shipping_display').textContent = shipping.toFixed(2);
        document.getElementById('other_charges_display').textContent = otherCharges.toFixed(2);
        document.getElementById('total_amount').textContent = total.toFixed(2);
    }
    
    // التحقق من صحة النموذج قبل الإرسال
    document.getElementById('purchaseInvoiceForm').addEventListener('submit', function(e) {
        const tbody = document.getElementById('itemsTableBody');
        if (tbody.rows.length === 0) {
            e.preventDefault();
            alert('يجب إضافة صنف واحد على الأقل');
            return;
        }
        
        let hasItems = false;
        document.querySelectorAll('.item-select').forEach(select => {
            if (select.value) {
                hasItems = true;
            }
        });
        
        if (!hasItems) {
            e.preventDefault();
            alert('يجب اختيار صنف واحد على الأقل');
            return;
        }
    });
</script>
@endpush