@extends('layouts.app')

@section('title', 'تفاصيل المنتج: ' . $product->name)
@section('page-title', 'تفاصيل المنتج')

@section('page-actions')
<div class="btn-group">
    <a href="{{ route('products.edit', $product) }}" class="btn btn-warning">
        <i class="fas fa-edit me-2"></i>
        تعديل
    </a>
    <a href="{{ route('products.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-2"></i>
        العودة للقائمة
    </a>
    <div class="btn-group" role="group">
        <button type="button" class="btn btn-outline-secondary dropdown-toggle" data-bs-toggle="dropdown">
            <i class="fas fa-ellipsis-v me-1"></i>
            المزيد
        </button>
        <ul class="dropdown-menu">
            <li>
                <button type="button" class="dropdown-item" onclick="duplicateProduct()">
                    <i class="fas fa-copy me-2"></i>
                    نسخ المنتج
                </button>
            </li>
            <li>
                <button type="button" class="dropdown-item" onclick="exportProduct()">
                    <i class="fas fa-download me-2"></i>
                    تصدير البيانات
                </button>
            </li>
            <li><hr class="dropdown-divider"></li>
            <li>
                <button type="button" class="dropdown-item text-danger"
                        data-bs-toggle="modal"
                        data-bs-target="#deleteProductModal"
                        data-product-id="{{ $product->id }}"
                        data-product-name="{{ $product->name }}"
                        data-product-type="{{ $product->type == 'product' ? 'منتج' : 'خدمة' }}"
                        data-product-sku="{{ $product->sku }}">
                    <i class="fas fa-trash me-2"></i>
                    حذف المنتج
                </button>
            </li>
        </ul>
    </div>
</div>
@endsection

@section('content')
<div class="row">
    <!-- معلومات المنتج الأساسية -->
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-info-circle me-2"></i>
                    المعلومات الأساسية
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <h6 class="text-muted">اسم المنتج (عربي):</h6>
                        <p class="mb-3"><strong>{{ $product->name }}</strong></p>
                        
                        @if($product->name_en)
                            <h6 class="text-muted">اسم المنتج (إنجليزي):</h6>
                            <p class="mb-3">{{ $product->name_en }}</p>
                        @endif
                        
                        <h6 class="text-muted">رمز المنتج (SKU):</h6>
                        <p class="mb-3"><code>{{ $product->sku }}</code></p>
                        
                        @if($product->barcode)
                            <h6 class="text-muted">الباركود:</h6>
                            <p class="mb-3"><code>{{ $product->barcode }}</code></p>
                        @endif
                    </div>
                    
                    <div class="col-md-6">
                        <h6 class="text-muted">النوع:</h6>
                        <p class="mb-3">
                            @if($product->type == 'product')
                                <span class="badge bg-primary fs-6">منتج</span>
                            @else
                                <span class="badge bg-info fs-6">خدمة</span>
                            @endif
                        </p>
                        
                        <h6 class="text-muted">الوحدة:</h6>
                        <p class="mb-3">{{ $product->unit }}</p>
                        
                        <h6 class="text-muted">الحالة:</h6>
                        <p class="mb-3">
                            @if($product->is_active)
                                <span class="badge bg-success fs-6">نشط</span>
                            @else
                                <span class="badge bg-secondary fs-6">غير نشط</span>
                            @endif
                        </p>
                        
                        @if($product->zatca_category_code)
                            <h6 class="text-muted">رمز تصنيف ZATCA:</h6>
                            <p class="mb-3"><code>{{ $product->zatca_category_code }}</code></p>
                        @endif
                    </div>
                </div>
                
                @if($product->description)
                    <hr>
                    <h6 class="text-muted">الوصف:</h6>
                    <p class="mb-0">{{ $product->description }}</p>
                @endif
            </div>
        </div>
        
        <!-- الأسعار والضرائب -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-money-bill-wave me-2"></i>
                    الأسعار والضرائب
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <h6 class="text-muted">السعر بدون ضريبة:</h6>
                        <h4 class="text-primary">{{ number_format($product->price, 2) }} ر.س</h4>
                    </div>
                    
                    <div class="col-md-4">
                        <h6 class="text-muted">معدل الضريبة:</h6>
                        @if($product->is_taxable)
                            <h4 class="text-success">{{ number_format($product->tax_rate, 2) }}%</h4>
                        @else
                            <h4 class="text-secondary">معفى من الضريبة</h4>
                        @endif
                    </div>
                    
                    <div class="col-md-4">
                        <h6 class="text-muted">السعر مع الضريبة:</h6>
                        <h4 class="text-success">{{ number_format($product->price_with_tax, 2) }} ر.س</h4>
                    </div>
                </div>
                
                @if($product->is_taxable)
                    <hr>
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        <strong>مبلغ الضريبة:</strong> {{ number_format($product->price_with_tax - $product->price, 2) }} ر.س
                    </div>
                @endif
            </div>
        </div>
        
        <!-- إدارة المخزون -->
        @if($product->type == 'product')
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-warehouse me-2"></i>
                    إدارة المخزون
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <h6 class="text-muted">الكمية الحالية:</h6>
                        <h4 class="
                            @if($product->isOutOfStock()) text-danger
                            @elseif($product->isLowStock()) text-warning
                            @else text-success
                            @endif
                        ">
                            {{ number_format($product->stock_quantity, 0) }} {{ $product->unit }}
                            @if($product->isOutOfStock())
                                <i class="fas fa-times-circle"></i>
                            @elseif($product->isLowStock())
                                <i class="fas fa-exclamation-triangle"></i>
                            @else
                                <i class="fas fa-check-circle"></i>
                            @endif
                        </h4>
                    </div>
                    
                    <div class="col-md-4">
                        <h6 class="text-muted">الحد الأدنى:</h6>
                        <h4 class="text-info">{{ number_format($product->min_stock, 0) }} {{ $product->unit }}</h4>
                    </div>
                    
                    <div class="col-md-4">
                        <h6 class="text-muted">حالة المخزون:</h6>
                        @if($product->isOutOfStock())
                            <h4 class="text-danger">نفد المخزون</h4>
                        @elseif($product->isLowStock())
                            <h4 class="text-warning">مخزون منخفض</h4>
                        @else
                            <h4 class="text-success">متوفر</h4>
                        @endif
                    </div>
                </div>
                
                @if($product->isLowStock() || $product->isOutOfStock())
                    <hr>
                    <div class="alert alert-{{ $product->isOutOfStock() ? 'danger' : 'warning' }}">
                        <i class="fas fa-{{ $product->isOutOfStock() ? 'times' : 'exclamation' }}-triangle me-2"></i>
                        @if($product->isOutOfStock())
                            <strong>تحذير:</strong> نفد مخزون هذا المنتج! يجب إعادة التزويد فوراً.
                        @else
                            <strong>تنبيه:</strong> مخزون المنتج منخفض. يُنصح بإعادة التزويد قريباً.
                        @endif
                    </div>
                @endif
            </div>
        </div>
        @endif
        
        <!-- سجل المبيعات -->
        @if($product->invoiceItems->count() > 0)
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-history me-2"></i>
                    آخر المبيعات
                </h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                            <tr>
                                <th>رقم الفاتورة</th>
                                <th>العميل</th>
                                <th>الكمية</th>
                                <th>السعر</th>
                                <th>التاريخ</th>
                            </tr>
                        <tbody>
                            @foreach($product->invoiceItems->take(5) as $item)
                            <tr>
                                <td>
                                    <a href="{{ route('invoices.show', $item->invoice) }}" class="text-decoration-none">
                                        {{ $item->invoice->invoice_number }}
                                    </a>
                                </td>
                                <td>
                                    @if($item->invoice->customer)
                                        {{ $item->invoice->customer->name }}
                                    @else
                                        <span class="text-muted">عميل غير محدد</span>
                                    @endif
                                </td>
                                <td>{{ number_format($item->quantity, 2) }} {{ $item->unit }}</td>
                                <td>{{ number_format($item->unit_price, 2) }} ر.س</td>
                                <td>{{ $item->created_at->format('Y-m-d') }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                @if($product->invoiceItems->count() > 5)
                    <div class="text-center mt-3">
                        <small class="text-muted">عرض 5 من أصل {{ $product->invoiceItems->count() }} عملية بيع</small>
                    </div>
                @endif
            </div>
        </div>
        @endif
    </div>
    
    <!-- الشريط الجانبي -->
    <div class="col-lg-4">
        <!-- إحصائيات سريعة -->
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-chart-line me-2"></i>
                    إحصائيات المبيعات
                </h5>
            </div>
            <div class="card-body">
                <div class="row text-center">
                    <div class="col-6">
                        <div class="mb-3">
                            <h3 class="text-primary mb-0">{{ $product->invoiceItems->count() }}</h3>
                            <small class="text-muted">مرات البيع</small>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="mb-3">
                            <h3 class="text-success mb-0">{{ number_format($product->invoiceItems->sum('quantity'), 0) }}</h3>
                            <small class="text-muted">إجمالي الكمية المباعة</small>
                        </div>
                    </div>
                </div>
                
                <div class="row text-center">
                    <div class="col-12">
                        <div class="mb-3">
                            <h3 class="text-info mb-0">{{ number_format($product->invoiceItems->sum('total_with_tax'), 2) }} ر.س</h3>
                            <small class="text-muted">إجمالي الإيرادات</small>
                        </div>
                    </div>
                </div>
                
                @if($product->invoiceItems->count() > 0)
                    <hr>
                    <div class="text-center">
                        <small class="text-muted">
                            <strong>آخر بيع:</strong> {{ $product->invoiceItems->last()->created_at->diffForHumans() }}
                        </small>
                    </div>
                @endif
            </div>
        </div>
        
        <!-- معلومات إضافية -->
        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-info me-2"></i>
                    معلومات إضافية
                </h6>
            </div>
            <div class="card-body">
                <div class="mb-2">
                    <strong>تاريخ الإنشاء:</strong>
                    <br><small class="text-muted">{{ $product->created_at->format('Y-m-d H:i') }}</small>
                </div>
                
                @if($product->updated_at != $product->created_at)
                    <div class="mb-2">
                        <strong>آخر تحديث:</strong>
                        <br><small class="text-muted">{{ $product->updated_at->diffForHumans() }}</small>
                    </div>
                @endif
                
                <div class="mb-2">
                    <strong>معرف المنتج:</strong>
                    <br><small class="text-muted">#{{ $product->id }}</small>
                </div>
            </div>
        </div>
        
        <!-- إجراءات سريعة -->
        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-bolt me-2"></i>
                    إجراءات سريعة
                </h6>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('invoices.create', ['product_id' => $product->id]) }}" class="btn btn-primary btn-sm">
                        <i class="fas fa-file-invoice me-2"></i>
                        إنشاء فاتورة
                    </a>
                    
                    @if($product->type == 'product')
                        <button type="button" class="btn btn-info btn-sm" onclick="adjustStock()">
                            <i class="fas fa-warehouse me-2"></i>
                            تعديل المخزون
                        </button>
                    @endif
                    
                    <button type="button" class="btn btn-success btn-sm" onclick="updatePrice()">
                        <i class="fas fa-money-bill me-2"></i>
                        تحديث السعر
                    </button>
                </div>
            </div>
        </div>
        
        @if($product->invoiceItems->count() > 0)
        <!-- تحذير الحذف -->
        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title mb-0 text-warning">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    تنبيه
                </h6>
            </div>
            <div class="card-body">
                <div class="alert alert-warning">
                    <small>
                        هذا المنتج مستخدم في {{ $product->invoiceItems->count() }} فاتورة.
                        لا يمكن حذفه لحماية سلامة البيانات.
                    </small>
                </div>
            </div>
        </div>
        @endif
    </div>
</div>
@endsection

@push('scripts')
<script>
function duplicateProduct() {
    if (confirm('هل تريد إنشاء نسخة من هذا المنتج؟')) {
        // سيتم تطوير هذه الوظيفة لاحقاً
        alert('سيتم تطوير وظيفة النسخ قريباً');
    }
}

function exportProduct() {
    // تصدير بيانات المنتج
    const productData = {
        name: '{{ $product->name }}',
        sku: '{{ $product->sku }}',
        type: '{{ $product->type }}',
        price: {{ $product->price }},
        tax_rate: {{ $product->tax_rate }},
        stock_quantity: {{ $product->stock_quantity }},
        sales_count: {{ $product->invoiceItems->count() }},
        total_revenue: {{ $product->invoiceItems->sum('total_with_tax') }}
    };
    
    const dataStr = JSON.stringify(productData, null, 2);
    const dataBlob = new Blob([dataStr], {type: 'application/json'});
    const url = URL.createObjectURL(dataBlob);
    const link = document.createElement('a');
    link.href = url;
    link.download = 'product_{{ $product->sku }}_data.json';
    link.click();
}

function adjustStock() {
    const currentStock = {{ $product->stock_quantity }};
    const newStock = prompt('أدخل الكمية الجديدة للمخزون:', currentStock);
    
    if (newStock !== null && !isNaN(newStock) && newStock >= 0) {
        // سيتم تطوير API لتحديث المخزون
        alert('سيتم تطوير وظيفة تحديث المخزون قريباً');
    }
}

function updatePrice() {
    const currentPrice = {{ $product->price }};
    const newPrice = prompt('أدخل السعر الجديد:', currentPrice);
    
    if (newPrice !== null && !isNaN(newPrice) && newPrice >= 0) {
        // سيتم تطوير API لتحديث السعر
        alert('سيتم تطوير وظيفة تحديث السعر قريباً');
    }
}
</script>

<!-- Modal تأكيد حذف المنتج -->
<div class="modal fade" id="deleteProductModal" tabindex="-1" aria-labelledby="deleteProductModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title" id="deleteProductModalLabel">
                    <i class="fas fa-exclamation-triangle"></i>
                    تأكيد حذف المنتج
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="إغلاق"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-triangle"></i>
                    <strong>تحذير:</strong> هذا الإجراء لا يمكن التراجع عنه!
                </div>
                <p class="mb-3">هل تريد حذف هذا المنتج؟</p>
                <div class="card">
                    <div class="card-body">
                        <h6 class="card-title">تفاصيل المنتج:</h6>
                        <p class="mb-1"><strong>الاسم:</strong> <span id="productNameToDelete"></span></p>
                        <p class="mb-1"><strong>الرمز:</strong> <span id="productSkuToDelete"></span></p>
                        <p class="mb-0"><strong>النوع:</strong> <span id="productTypeToDelete"></span></p>
                    </div>
                </div>
                <div class="alert alert-info mt-3">
                    <i class="fas fa-info-circle"></i>
                    <strong>ملاحظة:</strong> سيتم حذف جميع البيانات المرتبطة بهذا المنتج بما في ذلك عناصر الفواتير والحركات المخزنية.
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="fas fa-times"></i>
                    إلغاء
                </button>
                <form id="deleteProductForm" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">
                        <i class="fas fa-trash"></i>
                        تأكيد الحذف
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const deleteModal = document.getElementById('deleteProductModal');
    const deleteForm = document.getElementById('deleteProductForm');
    const productName = document.getElementById('productNameToDelete');
    const productSku = document.getElementById('productSkuToDelete');
    const productType = document.getElementById('productTypeToDelete');

    deleteModal.addEventListener('show.bs.modal', function (event) {
        const button = event.relatedTarget;
        const productId = button.getAttribute('data-product-id');
        const productNameValue = button.getAttribute('data-product-name');
        const productSkuValue = button.getAttribute('data-product-sku');
        const productTypeValue = button.getAttribute('data-product-type');

        // تحديث النموذج
        deleteForm.action = `{{ url('products') }}/${productId}`;
        
        // تحديث محتوى المودال
        productName.textContent = productNameValue;
        productSku.textContent = productSkuValue;
        productType.textContent = productTypeValue;
    });
});
</script>
@endpush