@extends('layouts.app')

@section('title', 'إدارة المنتجات - نظام المبيعات')
@section('page-title', 'إدارة المنتجات')
@section('breadcrumb')
    <i class="fas fa-home"></i>
    <span>لوحة التحكم</span>
    <i class="fas fa-chevron-left"></i>
    <span>المنتجات والخدمات</span>
@endsection

@section('page-actions')
    <div class="d-flex gap-2">
        <button type="button" class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#importModal">
            <i class="fas fa-upload me-2"></i>استيراد
        </button>
        <button type="button" class="btn btn-outline-secondary" onclick="exportProducts()">
            <i class="fas fa-download me-2"></i>تصدير
        </button>
        <a href="{{ route('products.create') }}" class="btn btn-primary">
            <i class="fas fa-plus me-2"></i>منتج جديد
        </a>
    </div>
@endsection

@section('content')
<div class="products-management">
    <!-- المرشحات المتقدمة -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-body">
            <form method="GET" action="{{ route('products.index') }}" id="filtersForm" class="row g-3">
                <div class="col-md-3">
                    <label class="form-label fw-medium">البحث</label>
                    <div class="input-group">
                        <input type="text" 
                               class="form-control" 
                               name="search" 
                               value="{{ request('search') }}" 
                               placeholder="اسم، رمز، أو باركود المنتج">
                        <button class="btn btn-outline-secondary" type="submit">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>
                </div>
                
                <div class="col-md-2">
                    <label class="form-label fw-medium">النوع</label>
                    <select name="type" class="form-select">
                        <option value="">جميع الأنواع</option>
                        <option value="product" {{ request('type') == 'product' ? 'selected' : '' }}>منتج</option>
                        <option value="service" {{ request('type') == 'service' ? 'selected' : '' }}>خدمة</option>
                    </select>
                </div>
                
                <div class="col-md-2">
                    <label class="form-label fw-medium">نوع العنصر</label>
                    <select name="item_type" class="form-select">
                        <option value="">جميع العناصر</option>
                        <option value="food" {{ request('item_type') == 'food' ? 'selected' : '' }}>طعام</option>
                        <option value="beverage" {{ request('item_type') == 'beverage' ? 'selected' : '' }}>مشروب</option>
                        <option value="dessert" {{ request('item_type') == 'dessert' ? 'selected' : '' }}>حلوى</option>
                        <option value="appetizer" {{ request('item_type') == 'appetizer' ? 'selected' : '' }}>مقبلات</option>
                        <option value="main_course" {{ request('item_type') == 'main_course' ? 'selected' : '' }}>طبق رئيسي</option>
                    </select>
                </div>
                
                <div class="col-md-2">
                    <label class="form-label fw-medium">الحالة</label>
                    <select name="status" class="form-select">
                        <option value="">جميع الحالات</option>
                        <option value="available" {{ request('status') == 'available' ? 'selected' : '' }}>متوفر</option>
                        <option value="unavailable" {{ request('status') == 'unavailable' ? 'selected' : '' }}>غير متوفر</option>
                        <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>غير نشط</option>
                        <option value="low_stock" {{ request('status') == 'low_stock' ? 'selected' : '' }}>مخزون منخفض</option>
                    </select>
                </div>
                
                <div class="col-md-2">
                    <label class="form-label fw-medium">المميزة</label>
                    <select name="is_featured" class="form-select">
                        <option value="">الكل</option>
                        <option value="true" {{ request('is_featured') == 'true' ? 'selected' : '' }}>مميزة</option>
                        <option value="false" {{ request('is_featured') == 'false' ? 'selected' : '' }}>عادية</option>
                    </select>
                </div>
                
                <div class="col-md-1">
                    <label class="form-label fw-medium">&nbsp;</label>
                    <div class="d-flex gap-1">
                        <button type="submit" class="btn btn-primary btn-sm">
                            <i class="fas fa-filter"></i>
                        </button>
                        <a href="{{ route('products.index') }}" class="btn btn-outline-secondary btn-sm">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- بطاقات الإحصائيات -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card border-0 shadow-sm stats-card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="card-title opacity-75 mb-1">إجمالي المنتجات</h6>
                            <h3 class="mb-0">{{ number_format($products->total()) }}</h3>
                        </div>
                        <div class="stats-icon">
                            <i class="fas fa-boxes"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="card border-0 shadow-sm stats-card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="card-title opacity-75 mb-1">المنتجات النشطة</h6>
                            <h3 class="mb-0">{{ number_format(\App\Models\Product::active()->count()) }}</h3>
                        </div>
                        <div class="stats-icon">
                            <i class="fas fa-check-circle"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="card border-0 shadow-sm stats-card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="card-title opacity-75 mb-1">مخزون منخفض</h6>
                            <h3 class="mb-0">{{ number_format(\App\Models\Product::lowStock()->count()) }}</h3>
                        </div>
                        <div class="stats-icon">
                            <i class="fas fa-exclamation-triangle"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="card border-0 shadow-sm stats-card bg-danger text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="card-title opacity-75 mb-1">نفاد المخزون</h6>
                            <h3 class="mb-0">{{ number_format(\App\Models\Product::where('stock_quantity', '<=', 0)->count()) }}</h3>
                        </div>
                        <div class="stats-icon">
                            <i class="fas fa-times-circle"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- قائمة المنتجات -->
    <div class="card border-0 shadow-sm">
        <div class="card-body p-0">
            @if($products->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="border-0 fw-semibold">المنتج</th>
                                <th class="border-0 fw-semibold">النوع</th>
                                <th class="border-0 fw-semibold">السعر</th>
                                <th class="border-0 fw-semibold">المخزون</th>
                                <th class="border-0 fw-semibold">الحالة</th>
                                <th class="border-0 fw-semibold text-center">الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($products as $product)
                            <tr>
                                <td class="py-3">
                                    <div class="d-flex align-items-center">
                                        <div class="product-avatar me-3">
                                            @if($product->image_url)
                                                <img src="{{ $product->image_url }}" alt="{{ $product->name }}" class="rounded">
                                            @else
                                                <div class="product-placeholder rounded d-flex align-items-center justify-content-center">
                                                    <i class="fas fa-box text-muted"></i>
                                                </div>
                                            @endif
                                        </div>
                                        <div>
                                            <h6 class="mb-1 fw-semibold">{{ $product->name }}</h6>
                                            <div class="text-muted small">
                                                <span class="me-3">
                                                    <i class="fas fa-barcode me-1"></i>{{ $product->sku }}
                                                </span>
                                                @if($product->barcode)
                                                <span>
                                                    <i class="fas fa-qrcode me-1"></i>{{ $product->barcode }}
                                                </span>
                                                @endif
                                            </div>
                                            @if($product->is_featured)
                                                <span class="badge bg-warning text-dark mt-1">
                                                    <i class="fas fa-star me-1"></i>مميز
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </td>
                                
                                <td class="py-3">
                                    <div>
                                        <span class="badge bg-light text-dark border">
                                            {{ $product->type == 'product' ? 'منتج' : 'خدمة' }}
                                        </span>
                                        @if($product->item_type)
                                            <div class="text-muted small mt-1">{{ $product->item_type_name }}</div>
                                        @endif
                                    </div>
                                </td>
                                
                                <td class="py-3">
                                    <div>
                                        <span class="fw-semibold text-primary">{{ number_format($product->price, 2) }} ر.س</span>
                                        @if($product->is_taxable && $product->tax_rate > 0)
                                            <div class="text-muted small">
                                                شامل ضريبة {{ $product->tax_rate }}%
                                            </div>
                                            <div class="text-success small">
                                                {{ number_format($product->price_with_tax, 2) }} ر.س
                                            </div>
                                        @endif
                                    </div>
                                </td>
                                
                                <td class="py-3">
                                    @if($product->type == 'service')
                                        <span class="badge bg-info">خدمة</span>
                                    @else
                                        <div>
                                            <span class="fw-semibold 
                                                {{ $product->isOutOfStock() ? 'text-danger' : ($product->isLowStock() ? 'text-warning' : 'text-success') }}">
                                                {{ number_format($product->stock_quantity) }}
                                            </span>
                                            <span class="text-muted">{{ $product->unit }}</span>
                                        </div>
                                        @if($product->min_stock > 0)
                                            <div class="text-muted small">
                                                الحد الأدنى: {{ number_format($product->min_stock) }}
                                            </div>
                                        @endif
                                        @if($product->isLowStock())
                                            <span class="badge bg-warning text-dark small">مخزون منخفض</span>
                                        @endif
                                    @endif
                                </td>
                                
                                <td class="py-3">
                                    <div class="d-flex flex-column gap-1">
                                        @if($product->is_active)
                                            <span class="badge bg-success">نشط</span>
                                        @else
                                            <span class="badge bg-secondary">غير نشط</span>
                                        @endif
                                        
                                        @if($product->is_available !== null)
                                            @if($product->is_available)
                                                <span class="badge bg-primary">متوفر</span>
                                            @else
                                                <span class="badge bg-danger">غير متوفر</span>
                                            @endif
                                        @endif
                                    </div>
                                </td>
                                
                                <td class="py-3 text-center">
                                    <div class="btn-group btn-group-sm">
                                        <a href="{{ route('products.show', $product) }}" 
                                           class="btn btn-outline-primary btn-sm" 
                                           title="عرض التفاصيل">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('products.edit', $product) }}" 
                                           class="btn btn-outline-warning btn-sm" 
                                           title="تعديل">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <button type="button" 
                                                class="btn btn-outline-danger btn-sm" 
                                                onclick="confirmDelete({{ $product->id }}, '{{ addslashes($product->name) }}')"
                                                title="حذف">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <!-- التقسيم -->
                @if($products->hasPages())
                <div class="card-footer bg-white border-0 pt-3">
                    <div class="d-flex flex-column flex-md-row justify-content-between align-items-center gap-3">
                        <div class="pagination-info">
                            <span class="text-muted">
                                عرض <span class="fw-semibold text-primary">{{ $products->firstItem() }}</span>
                                إلى <span class="fw-semibold text-primary">{{ $products->lastItem() }}</span>
                                من <span class="fw-semibold text-primary">{{ number_format($products->total()) }}</span> منتج
                            </span>
                        </div>
                        <div class="pagination-wrapper">
                            {{ $products->appends(request()->query())->links('pagination::bootstrap-4') }}
                        </div>
                    </div>
                </div>
                @endif
            @else
                <div class="text-center py-5">
                    <div class="empty-state">
                        <i class="fas fa-boxes text-muted mb-3" style="font-size: 4rem;"></i>
                        <h5 class="text-muted">لا توجد منتجات</h5>
                        <p class="text-muted mb-4">لم يتم العثور على أي منتجات تطابق معايير البحث</p>
                        <a href="{{ route('products.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus me-2"></i>إضافة منتج جديد
                        </a>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- نافذة الاستيراد -->
<div class="modal fade" id="importModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-upload me-2"></i>استيراد المنتجات
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="importForm" method="POST" action="{{ route('products.import') }}" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label fw-medium">ملف Excel</label>
                        <input type="file" class="form-control" name="excel_file" accept=".xlsx,.xls" required>
                        <div class="form-text">
                            يدعم ملفات Excel (.xlsx, .xls) بحد أقصى 10 ميجابايت
                        </div>
                    </div>
                    
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" name="preview_mode" id="previewMode">
                        <label class="form-check-label" for="previewMode">
                            معاينة البيانات قبل الاستيراد
                        </label>
                    </div>
                    
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        <strong>تلميح:</strong> يمكنك تحميل قالب Excel فارغ 
                        <a href="{{ route('products.export-template') }}" class="alert-link">من هنا</a>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-upload me-2"></i>استيراد
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- نافذة تأكيد الحذف -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title text-danger">
                    <i class="fas fa-exclamation-triangle me-2"></i>تأكيد الحذف
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>هل أنت متأكد من حذف المنتج؟</p>
                <p class="fw-semibold" id="productName"></p>
                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    هذا الإجراء لا يمكن التراجع عنه
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <form id="deleteForm" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">
                        <i class="fas fa-trash me-2"></i>حذف
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .stats-card {
        border-radius: var(--radius-lg);
        overflow: hidden;
        transition: transform var(--duration-200) var(--ease-out);
    }

    .stats-card:hover {
        transform: translateY(-2px);
    }

    .stats-icon {
        font-size: 2.5rem;
        opacity: 0.8;
    }

    .product-avatar img,
    .product-placeholder {
        width: 50px;
        height: 50px;
        object-fit: cover;
    }

    .product-placeholder {
        background: var(--gray-100);
        font-size: 1.5rem;
    }

    .table th {
        font-weight: 600;
        color: var(--gray-700);
        background: var(--gray-50) !important;
    }

    .table tbody tr {
        transition: all var(--duration-200) var(--ease-out);
    }

    .table tbody tr:hover {
        background: var(--gray-50);
        transform: translateX(-2px);
    }

    .btn-group-sm .btn {
        padding: 0.375rem 0.75rem;
    }

    .empty-state {
        padding: 3rem 2rem;
    }

    .badge {
        font-size: 0.75rem;
        font-weight: 500;
    }

    .form-control:focus,
    .form-select:focus {
        border-color: var(--primary-400);
        box-shadow: 0 0 0 0.2rem rgba(59, 130, 246, 0.15);
    }

    .modal-content {
        border: none;
        border-radius: var(--radius-xl);
        box-shadow: var(--shadow-xl);
    }

    .modal-header {
        background: var(--gradient-primary);
        color: white;
        border-bottom: none;
        border-radius: var(--radius-xl) var(--radius-xl) 0 0;
    }

    .alert {
        border: none;
        border-radius: var(--radius-md);
        border-left: 4px solid;
    }

    .alert-info {
        background: rgba(59, 130, 246, 0.1);
        border-left-color: var(--primary-500);
        color: var(--primary-700);
    }

    .alert-warning {
        background: rgba(245, 158, 11, 0.1);
        border-left-color: var(--warning-500);
        color: var(--warning-700);
    }

    /* تنسيق التقسيم الاحترافي */
    .pagination-wrapper .pagination {
        margin: 0;
        gap: 0.25rem;
    }

    .pagination-wrapper .page-link {
        border: 1px solid var(--gray-300);
        color: var(--gray-600);
        padding: 0.5rem 0.75rem;
        border-radius: var(--radius-md);
        font-weight: 500;
        font-size: 0.875rem;
        transition: all var(--duration-200) var(--ease-out);
        text-decoration: none;
        margin: 0 2px;
    }

    .pagination-wrapper .page-link:hover {
        background: var(--primary-50);
        border-color: var(--primary-300);
        color: var(--primary-600);
        transform: translateY(-1px);
        box-shadow: var(--shadow-sm);
    }

    .pagination-wrapper .page-item.active .page-link {
        background: var(--gradient-primary);
        border-color: var(--primary-600);
        color: white;
        box-shadow: var(--shadow-md);
        transform: translateY(-1px);
    }

    .pagination-wrapper .page-item.disabled .page-link {
        background: var(--gray-100);
        border-color: var(--gray-200);
        color: var(--gray-400);
        cursor: not-allowed;
    }

    .pagination-wrapper .page-link:focus {
        box-shadow: 0 0 0 0.2rem rgba(59, 130, 246, 0.25);
        z-index: 3;
    }

    .pagination-info {
        font-size: 0.875rem;
    }

    /* تحسينات للصفحة الأولى والأخيرة */
    .pagination-wrapper .page-item:first-child .page-link,
    .pagination-wrapper .page-item:last-child .page-link {
        font-weight: 600;
    }

    .pagination-wrapper .page-item:first-child .page-link:hover,
    .pagination-wrapper .page-item:last-child .page-link:hover {
        background: var(--success-50);
        border-color: var(--success-300);
        color: var(--success-600);
    }

    @media (max-width: 768px) {
        .stats-card {
            margin-bottom: 1rem;
        }
        
        .table-responsive {
            font-size: 0.875rem;
        }
        
        .btn-group-sm .btn {
            padding: 0.25rem 0.5rem;
            font-size: 0.75rem;
        }

        /* تحسينات التقسيم للهواتف */
        .pagination-wrapper .pagination {
            justify-content: center;
            flex-wrap: wrap;
            gap: 0.125rem;
        }

        .pagination-wrapper .page-link {
            padding: 0.375rem 0.5rem;
            font-size: 0.75rem;
            margin: 0 1px;
        }

        .pagination-info {
            text-align: center;
            font-size: 0.8rem;
        }

        /* إخفاء بعض روابط التقسيم على الشاشات الصغيرة جداً */
        @media (max-width: 480px) {
            .pagination-wrapper .page-item:not(.active):not(.disabled):not(:first-child):not(:last-child):not(:nth-child(2)):not(:nth-last-child(2)) {
                display: none;
            }
        }
    }
</style>
@endpush

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // معالج نموذج الاستيراد
    const importForm = document.getElementById('importForm');
    if (importForm) {
        importForm.addEventListener('submit', function(e) {
            const fileInput = this.querySelector('input[type="file"]');
            const submitBtn = this.querySelector('button[type="submit"]');
            
            // التحقق من وجود ملف
            if (!fileInput.files.length) {
                e.preventDefault();
                alert('يرجى اختيار ملف Excel للاستيراد');
                return false;
            }
            
            // تغيير نص الزر أثناء التحميل
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>جاري الاستيراد...';
            submitBtn.disabled = true;
            
            // السماح للنموذج بالإرسال بالطريقة التقليدية
            return true;
        });
    }
});

// دالة تصدير المنتجات
function exportProducts() {
    const params = new URLSearchParams(window.location.search);
    const exportUrl = '{{ route("products.export") }}?' + params.toString();
    window.location.href = exportUrl;
}

// دالة تأكيد الحذف
function confirmDelete(productId, productName) {
    document.getElementById('productName').textContent = productName;
    document.getElementById('deleteForm').action = `/products/${productId}`;
    
    const deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
    deleteModal.show();
}

// تحديث المرشحات تلقائياً
document.addEventListener('DOMContentLoaded', function() {
    const selects = document.querySelectorAll('#filtersForm select');
    selects.forEach(select => {
        select.addEventListener('change', function() {
            document.getElementById('filtersForm').submit();
        });
    });
});
</script>
@endpush