@extends('layouts.app')

@section('title', 'مشاكل تصدير Excel - تدريب عملي')
@section('page-title', 'مشاكل تصدير Excel - تدريب عملي')

@push('styles')
<style>
    :root {
        --danger-bg: #fee2e2;
        --danger-border: #fecaca;
        --danger-text: #991b1b;
        --warning-bg: #fef3c7;
        --warning-border: #fde68a;
        --warning-text: #92400e;
        --info-bg: #dbeafe;
        --info-border: #bfdbfe;
        --info-text: #1e40af;
        --success-bg: #dcfce7;
        --success-border: #bbf7d0;
        --success-text: #166534;
    }

    .problem-card {
        border-radius: 12px;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
        transition: all 0.3s ease;
        margin-bottom: 1.5rem;
    }

    .problem-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 15px -3px rgba(0, 0, 0, 0.1);
    }

    .problem-severe {
        background: var(--danger-bg);
        border-left: 4px solid #dc2626;
    }

    .problem-moderate {
        background: var(--warning-bg);
        border-left: 4px solid #d97706;
    }

    .problem-minor {
        background: var(--info-bg);
        border-left: 4px solid #2563eb;
    }

    .problem-header {
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-bottom: 1rem;
    }

    .problem-title {
        font-weight: 700;
        font-size: 1.1rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .severity-badge {
        padding: 0.25rem 0.75rem;
        border-radius: 20px;
        font-size: 0.8rem;
        font-weight: 600;
    }

    .severity-severe {
        background: #dc2626;
        color: white;
    }

    .severity-moderate {
        background: #d97706;
        color: white;
    }

    .severity-minor {
        background: #2563eb;
        color: white;
    }

    .problem-code {
        background: #1f2937;
        color: #f9fafb;
        padding: 1rem;
        border-radius: 8px;
        font-family: 'Monaco', 'Menlo', 'Ubuntu Mono', monospace;
        font-size: 0.85rem;
        overflow-x: auto;
        margin: 1rem 0;
    }

    .problem-impact {
        background: rgba(239, 68, 68, 0.1);
        border: 1px solid rgba(239, 68, 68, 0.2);
        padding: 1rem;
        border-radius: 8px;
        margin: 1rem 0;
    }

    .export-demo-buttons {
        display: flex;
        gap: 1rem;
        margin: 2rem 0;
        flex-wrap: wrap;
    }

    .btn-demo {
        padding: 12px 24px;
        border-radius: 8px;
        font-weight: 600;
        text-decoration: none;
        transition: all 0.3s ease;
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
    }

    .btn-normal {
        background: #10b981;
        color: white;
        border: 2px solid #10b981;
    }

    .btn-normal:hover {
        background: #059669;
        border-color: #059669;
        color: white;
    }

    .btn-problematic {
        background: #ef4444;
        color: white;
        border: 2px solid #ef4444;
    }

    .btn-problematic:hover {
        background: #dc2626;
        border-color: #dc2626;
        color: white;
    }

    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 1rem;
        margin: 2rem 0;
    }

    .stat-card {
        background: white;
        padding: 1.5rem;
        border-radius: 12px;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        text-align: center;
    }

    .stat-number {
        font-size: 2rem;
        font-weight: 800;
        color: #1f2937;
    }

    .stat-label {
        color: #6b7280;
        font-size: 0.9rem;
        margin-top: 0.5rem;
    }

    .file-structure {
        background: #f8fafc;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        padding: 1rem;
        font-family: monospace;
        font-size: 0.9rem;
    }

    .collapsible {
        cursor: pointer;
        user-select: none;
    }

    .collapsible:hover {
        background: rgba(59, 130, 246, 0.1);
    }

    .collapsible-content {
        display: none;
        padding-left: 1rem;
        border-left: 2px solid #e5e7eb;
        margin-left: 0.5rem;
        margin-top: 0.5rem;
    }

    .collapsible-content.active {
        display: block;
    }
</style>
@endpush

@section('content')
<div class="container-fluid">
    <!-- Header Section -->
    <div class="row">
        <div class="col-12">
            <div class="alert alert-info">
                <h4><i class="fas fa-graduation-cap me-2"></i>مرحباً بك في تدريب مشاكل تصدير Excel</h4>
                <p class="mb-0">
                    تم إنشاء نظام تصدير معطوب خصيصاً للتدريب على إيجاد وحل المشاكل الشائعة في تصدير البيانات.
                    ستجد هنا <strong>24 مشكلة مختلفة</strong> تغطي جوانب متعددة من الأداء، الأمان، الذاكرة، والترميز.
                </p>
            </div>
        </div>
    </div>

    <!-- Statistics -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-number text-danger">24</div>
            <div class="stat-label">إجمالي المشاكل</div>
        </div>
        <div class="stat-card">
            <div class="stat-number text-warning">8</div>
            <div class="stat-label">مشاكل حرجة</div>
        </div>
        <div class="stat-card">
            <div class="stat-number text-info">10</div>
            <div class="stat-label">مشاكل متوسطة</div>
        </div>
        <div class="stat-card">
            <div class="stat-number text-success">6</div>
            <div class="stat-label">مشاكل بسيطة</div>
        </div>
    </div>

    <!-- Demo Buttons -->
    <div class="export-demo-buttons">
        <form method="POST" action="{{ route('products.export') }}" style="display: inline;">
            @csrf
            <button type="submit" class="btn-demo btn-normal">
                <i class="fas fa-download"></i>
                تصدير عادي (سليم)
            </button>
        </form>
        
        <form method="POST" action="{{ route('products.export-problematic') }}" style="display: inline;">
            @csrf
            <button type="submit" class="btn-demo btn-problematic">
                <i class="fas fa-bug"></i>
                تصدير معطوب (للتدريب)
            </button>
        </form>
    </div>

    <!-- File Structure -->
    <div class="row">
        <div class="col-12">
            <h3><i class="fas fa-folder-tree me-2"></i>هيكل الملفات المنشأة</h3>
            <div class="file-structure">
                <div class="collapsible" onclick="toggleCollapsible(this)">
                    <i class="fas fa-folder"></i> app/
                </div>
                <div class="collapsible-content">
                    <div class="collapsible" onclick="toggleCollapsible(this)">
                        <i class="fas fa-folder"></i> Exports/
                    </div>
                    <div class="collapsible-content">
                        <i class="fas fa-file-code"></i> ProductsExport.php <span class="text-success">(الأصلي - سليم)</span><br>
                        <i class="fas fa-file-code text-danger"></i> ProductsExportProblematic.php <span class="text-danger">(معطوب - للتدريب)</span>
                    </div>
                    <div class="collapsible" onclick="toggleCollapsible(this)">
                        <i class="fas fa-folder"></i> Http/Controllers/
                    </div>
                    <div class="collapsible-content">
                        <i class="fas fa-file-code"></i> ProductController.php <span class="text-success">(محدث)</span><br>
                        <i class="fas fa-file-code text-danger"></i> ProductExportProblematicController.php <span class="text-danger">(معطوب)</span>
                    </div>
                </div>
                <div class="collapsible" onclick="toggleCollapsible(this)">
                    <i class="fas fa-folder"></i> routes/
                </div>
                <div class="collapsible-content">
                    <i class="fas fa-file-code"></i> web.php <span class="text-info">(تم إضافة مسار جديد)</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Problems List -->
    <div class="row mt-4">
        <div class="col-12">
            <h2><i class="fas fa-list-check me-2"></i>قائمة المشاكل المنشأة</h2>
        </div>
    </div>

    <!-- Severe Problems -->
    <div class="row">
        <div class="col-12">
            <h3 class="text-danger"><i class="fas fa-exclamation-triangle me-2"></i>المشاكل الحرجة</h3>
        </div>
        
        <div class="col-lg-6">
            <div class="problem-card problem-severe">
                <div class="problem-header">
                    <div class="problem-title">
                        <i class="fas fa-skull-crossbones"></i>
                        مشكلة Eval خطيرة
                    </div>
                    <span class="severity-badge severity-severe">حرج</span>
                </div>
                <p><strong>الموقع:</strong> ProductExportProblematicController.php:102</p>
                <div class="problem-code">eval('$processed["' . $key . '"] = ' . $value . ';');</div>
                <div class="problem-impact">
                    <strong>التأثير:</strong> يمكن تنفيذ أي كود PHP من خلال المدخلات، مما يعرض النظام لهجمات RCE
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="problem-card problem-severe">
                <div class="problem-header">
                    <div class="problem-title">
                        <i class="fas fa-memory"></i>
                        استهلاك ذاكرة مفرط
                    </div>
                    <span class="severity-badge severity-severe">حرج</span>
                </div>
                <p><strong>الموقع:</strong> ProductsExportProblematic.php:82</p>
                <div class="problem-code">$products = $query->orderBy('created_at', 'desc')->get();</div>
                <div class="problem-impact">
                    <strong>التأثير:</strong> تحميل كامل البيانات في الذاكرة يمكن أن يسبب Memory Limit Exceeded
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="problem-card problem-severe">
                <div class="problem-header">
                    <div class="problem-title">
                        <i class="fas fa-database"></i>
                        مشكلة N+1 Query
                    </div>
                    <span class="severity-badge severity-severe">حرج</span>
                </div>
                <p><strong>الموقع:</strong> ProductsExportProblematic.php:34</p>
                <div class="problem-code">$query = Product::with(['category', 'supplier', 'invoiceItems']);</div>
                <div class="problem-impact">
                    <strong>التأثير:</strong> استعلامات مفرطة تؤدي إلى بطء شديد في الأداء
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="problem-card problem-severe">
                <div class="problem-header">
                    <div class="problem-title">
                        <i class="fas fa-lock-open"></i>
                        تسريب معلومات حساسة
                    </div>
                    <span class="severity-badge severity-severe">حرج</span>
                </div>
                <p><strong>الموقع:</strong> ProductExportProblematicController.php:87</p>
                <div class="problem-code">'server_info' => $_SERVER</div>
                <div class="problem-impact">
                    <strong>التأثير:</strong> كشف معلومات الخادم والبيئة في logs الأخطاء
                </div>
            </div>
        </div>
    </div>

    <!-- Moderate Problems -->
    <div class="row mt-4">
        <div class="col-12">
            <h3 class="text-warning"><i class="fas fa-exclamation-circle me-2"></i>المشاكل المتوسطة</h3>
        </div>
        
        <div class="col-lg-6">
            <div class="problem-card problem-moderate">
                <div class="problem-header">
                    <div class="problem-title">
                        <i class="fas fa-code"></i>
                        ترميز نصوص خاطئ
                    </div>
                    <span class="severity-badge severity-moderate">متوسط</span>
                </div>
                <p><strong>الموقع:</strong> ProductsExportProblematic.php:133</p>
                <div class="problem-code">iconv('UTF-8', 'ISO-8859-1//IGNORE', 'الرقم')</div>
                <div class="problem-impact">
                    <strong>التأثير:</strong> النصوص العربية تظهر بشكل مشوه في Excel
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="problem-card problem-moderate">
                <div class="problem-header">
                    <div class="problem-title">
                        <i class="fas fa-calculator"></i>
                        حسابات معقدة غير مفيدة
                    </div>
                    <span class="severity-badge severity-moderate">متوسط</span>
                </div>
                <p><strong>الموقع:</strong> ProductsExportProblematic.php:156</p>
                <div class="problem-code">$complexCalculation += sin($i) * cos($i) * tan($i);</div>
                <div class="problem-impact">
                    <strong>التأثير:</strong> استهلاك CPU مفرط لحسابات غير مفيدة
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="problem-card problem-moderate">
                <div class="problem-header">
                    <div class="problem-title">
                        <i class="fas fa-align-left"></i>
                        تنسيق Excel معقد
                    </div>
                    <span class="severity-badge severity-moderate">متوسط</span>
                </div>
                <p><strong>الموقع:</strong> ProductsExportProblematic.php:250</p>
                <div class="problem-code">for ($row = 2; $row <= 10000; $row++)</div>
                <div class="problem-impact">
                    <strong>التأثير:</strong> تطبيق تنسيق على آلاف الصفوف يسبب بطء شديد
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="problem-card problem-moderate">
                <div class="problem-header">
                    <div class="problem-title">
                        <i class="fas fa-chunks"></i>
                        حجم Chunk صغير جداً
                    </div>
                    <span class="severity-badge severity-moderate">متوسط</span>
                </div>
                <p><strong>الموقع:</strong> ProductsExportProblematic.php:268</p>
                <div class="problem-code">return 10; // chunk صغير جداً</div>
                <div class="problem-impact">
                    <strong>التأثير:</strong> overhead مفرط من كثرة العمليات الصغيرة
                </div>
            </div>
        </div>
    </div>

    <!-- Minor Problems -->
    <div class="row mt-4">
        <div class="col-12">
            <h3 class="text-info"><i class="fas fa-info-circle me-2"></i>المشاكل البسيطة</h3>
        </div>
        
        <div class="col-lg-6">
            <div class="problem-card problem-minor">
                <div class="problem-header">
                    <div class="problem-title">
                        <i class="fas fa-calendar"></i>
                        معالجة تاريخ معقدة
                    </div>
                    <span class="severity-badge severity-minor">بسيط</span>
                </div>
                <p><strong>الموقع:</strong> ProductsExportProblematic.php:171</p>
                <div class="problem-code">$createdAt = DateTime::createFromFormat('Y-m-d H:i:s', $createdAt)->format('d/m/Y H:i:s');</div>
                <div class="problem-impact">
                    <strong>التأثير:</strong> معالجة غير ضرورية قد تسبب أخطاء تنسيق
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="problem-card problem-minor">
                <div class="problem-header">
                    <div class="problem-title">
                        <i class="fas fa-sort-numeric-up"></i>
                        تنسيق أرقام خاطئ
                    </div>
                    <span class="severity-badge severity-minor">بسيط</span>
                </div>
                <p><strong>الموقع:</strong> ProductsExportProblematic.php:178</p>
                <div class="problem-code">$price = number_format($price, 10, '.', ',');</div>
                <div class="problem-impact">
                    <strong>التأثير:</strong> دقة عالية غير ضرورية تؤثر على الأداء
                </div>
            </div>
        </div>
    </div>

    <!-- Solutions Section -->
    <div class="row mt-5">
        <div class="col-12">
            <div class="alert alert-success">
                <h4><i class="fas fa-lightbulb me-2"></i>نصائح لحل المشاكل</h4>
                <ul class="mb-0">
                    <li><strong>مشاكل الأداء:</strong> استخدم pagination أو chunking، تجنب eager loading غير الضروري</li>
                    <li><strong>مشاكل الأمان:</strong> لا تستخدم eval أبداً، تحقق من صحة المدخلات، لا تسرب معلومات حساسة</li>
                    <li><strong>مشاكل الذاكرة:</strong> استخدم generators أو streaming، تجنب تحميل البيانات الكبيرة مرة واحدة</li>
                    <li><strong>مشاكل الترميز:</strong> استخدم UTF-8 دائماً، تأكد من إعدادات قاعدة البيانات والتطبيق</li>
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function toggleCollapsible(element) {
    const content = element.nextElementSibling;
    const icon = element.querySelector('i');
    
    if (content.classList.contains('active')) {
        content.classList.remove('active');
        icon.classList.remove('fa-folder-open');
        icon.classList.add('fa-folder');
    } else {
        content.classList.add('active');
        icon.classList.remove('fa-folder');
        icon.classList.add('fa-folder-open');
    }
}

// Auto-expand first level
document.addEventListener('DOMContentLoaded', function() {
    const firstLevel = document.querySelectorAll('.file-structure > .collapsible-content');
    firstLevel.forEach(content => {
        content.classList.add('active');
        const icon = content.previousElementSibling.querySelector('i');
        icon.classList.remove('fa-folder');
        icon.classList.add('fa-folder-open');
    });
});
</script>
@endpush