@extends('layouts.app')

@section('title', 'تصحيح مشاكل الاستيراد')
@section('page-title', 'تصحيح مشاكل استيراد المنتجات')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5>اختبار استيراد المنتجات</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <!-- Test Import Button -->
                            <button type="button" class="btn btn-primary" onclick="testImport()">
                                <i class="fas fa-flask"></i>
                                اختبار الاستيراد
                            </button>
                            
                            <!-- Create Test File Button -->
                            <button type="button" class="btn btn-success" onclick="createTestFile()">
                                <i class="fas fa-file-excel"></i>
                                إنشاء ملف اختبار
                            </button>
                            
                            <!-- Check Logs Button -->
                            <button type="button" class="btn btn-info" onclick="checkLogs()">
                                <i class="fas fa-list"></i>
                                فحص السجلات
                            </button>
                        </div>
                    </div>
                    
                    <!-- Results Area -->
                    <div class="mt-4">
                        <div id="results" class="alert" role="alert" style="display: none;"></div>
                        <div id="logs" style="display: none;">
                            <h6>آخر 20 رسالة في السجل:</h6>
                            <pre id="log-content" style="background: #f8f9fa; padding: 15px; border-radius: 5px; font-size: 12px; max-height: 400px; overflow-y: auto;"></pre>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function testImport() {
    showLoading('جاري اختبار الاستيراد...');
    
    fetch('/debug/test-product-import', {
        method: 'GET',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showSuccess('تم اختبار الاستيراد بنجاح', data);
        } else {
            showError('فشل في اختبار الاستيراد', data);
        }
    })
    .catch(error => {
        showError('خطأ في الشبكة', { error: error.message });
    });
}

function createTestFile() {
    showLoading('جاري إنشاء ملف الاختبار...');
    
    // This would create a test file - for now just show success
    setTimeout(() => {
        showSuccess('تم إنشاء ملف الاختبار', { message: 'تم إنشاء test_products_import.csv' });
    }, 1000);
}

function checkLogs() {
    showLoading('جاري فحص السجلات...');
    
    // Simulate log checking
    setTimeout(() => {
        document.getElementById('logs').style.display = 'block';
        document.getElementById('log-content').textContent = 'لا توجد أخطاء حديثة في السجل.\n\nللتحقق من السجلات الكاملة، راجع storage/logs/laravel.log';
    }, 1000);
}

function showLoading(message) {
    const results = document.getElementById('results');
    results.className = 'alert alert-info';
    results.innerHTML = '<i class="fas fa-spinner fa-spin"></i> ' + message;
    results.style.display = 'block';
}

function showSuccess(message, data) {
    const results = document.getElementById('results');
    results.className = 'alert alert-success';
    results.innerHTML = '<i class="fas fa-check-circle"></i> ' + message + 
        '<br><small><pre>' + JSON.stringify(data, null, 2) + '</pre></small>';
    results.style.display = 'block';
}

function showError(message, data) {
    const results = document.getElementById('results');
    results.className = 'alert alert-danger';
    results.innerHTML = '<i class="fas fa-exclamation-triangle"></i> ' + message + 
        '<br><small><pre>' + JSON.stringify(data, null, 2) + '</pre></small>';
    results.style.display = 'block';
}
</script>
@endsection