@extends('layouts.app')

@section('title', 'إضافة منتج/خدمة جديدة')
@section('page-title', 'إضافة منتج/خدمة جديدة')

@push('styles')
<style>
    .professional-form {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        min-height: 100vh;
        padding: 20px 0;
    }
    
    .form-card {
        border: none;
        border-radius: 15px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        transition: all 0.3s ease;
        background: white;
        overflow: hidden;
    }
    
    .form-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 15px 40px rgba(0, 0, 0, 0.12);
    }
    
    .card-header-modern {
        background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
        color: white;
        border: none;
        padding: 20px 25px;
        position: relative;
        overflow: hidden;
    }
    
    .card-header-modern::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="white" opacity="0.1"/><circle cx="75" cy="75" r="1" fill="white" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
        opacity: 0.3;
    }
    
    .card-header-modern h5 {
        margin: 0;
        font-weight: 600;
        font-size: 1.2rem;
        position: relative;
        z-index: 1;
    }
    
    .card-header-modern i {
        font-size: 1.1rem;
        margin-left: 10px;
        opacity: 0.9;
    }
    
    .card-body-modern {
        padding: 30px 25px;
        background: white;
    }
    
    .form-label-modern {
        font-weight: 600;
        color: #495057;
        margin-bottom: 8px;
        font-size: 0.95rem;
    }
    
    .form-control-modern {
        border: 2px solid #e9ecef;
        border-radius: 10px;
        padding: 12px 15px;
        font-size: 0.95rem;
        transition: all 0.3s ease;
        background-color: #f8f9fa;
    }
    
    .form-control-modern:focus {
        border-color: #007bff;
        box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.15);
        background-color: white;
        transform: translateY(-1px);
    }
    
    .form-select-modern {
        border: 2px solid #e9ecef;
        border-radius: 10px;
        padding: 12px 15px;
        font-size: 0.95rem;
        transition: all 0.3s ease;
        background-color: #f8f9fa;
    }
    
    .form-select-modern:focus {
        border-color: #007bff;
        box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.15);
        background-color: white;
    }
    
    .input-group-modern .input-group-text {
        background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
        color: white;
        border: none;
        border-radius: 0 10px 10px 0;
        font-weight: 600;
    }
    
    .input-group-modern .form-control {
        border-right: none;
        border-radius: 10px 0 0 10px;
    }
    
    .section-divider {
        height: 2px;
        background: linear-gradient(90deg, transparent 0%, #007bff 50%, transparent 100%);
        margin: 25px 0;
        border-radius: 1px;
    }
    
    .preview-card {
        position: sticky;
        top: 20px;
        border: none;
        border-radius: 15px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        background: white;
        overflow: hidden;
    }
    
    .preview-header {
        background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
        color: white;
        padding: 20px 25px;
        text-align: center;
        position: relative;
    }
    
    .preview-header::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="dots" width="20" height="20" patternUnits="userSpaceOnUse"><circle cx="10" cy="10" r="1.5" fill="white" opacity="0.2"/></pattern></defs><rect width="100" height="100" fill="url(%23dots)"/></svg>');
    }
    
    .preview-content {
        padding: 25px;
    }
    
    .preview-icon-container {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        padding: 25px;
        border-radius: 15px;
        margin-bottom: 20px;
        text-align: center;
        border: 2px dashed #dee2e6;
        transition: all 0.3s ease;
    }
    
    .preview-icon-container:hover {
        border-color: #007bff;
        background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%);
    }
    
    .price-display {
        font-size: 1.5rem;
        font-weight: 700;
        color: #007bff;
        text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }
    
    .badge-modern {
        padding: 8px 15px;
        border-radius: 20px;
        font-weight: 600;
        font-size: 0.85rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .btn-save-modern {
        background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
        border: none;
        border-radius: 12px;
        padding: 15px 25px;
        font-weight: 600;
        font-size: 1.1rem;
        color: white;
        transition: all 0.3s ease;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .btn-save-modern:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(40, 167, 69, 0.3);
        color: white;
    }
    
    .tips-card {
        border: none;
        border-radius: 15px;
        background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%);
        border-left: 5px solid #ffc107;
        margin-top: 20px;
    }
    
    .tips-header {
        background: transparent;
        border: none;
        padding: 15px 20px;
    }
    
    .tips-body {
        padding: 0 20px 20px;
    }
    
    .alert-modern {
        border: none;
        border-radius: 12px;
        padding: 20px;
        margin-bottom: 25px;
        border-left: 5px solid #17a2b8;
        background: linear-gradient(135deg, #d1ecf1 0%, #bee5eb 100%);
    }
    
    .form-check-modern .form-check-input:checked {
        background-color: #007bff;
        border-color: #007bff;
    }
    
    .invalid-feedback {
        display: block;
        font-size: 0.875rem;
        color: #dc3545;
        margin-top: 5px;
        font-weight: 500;
    }
    
    .form-control.is-invalid, .form-select.is-invalid {
        border-color: #dc3545;
        background-color: #f8d7da;
    }
    
    @media (max-width: 768px) {
        .professional-form {
            padding: 10px 0;
        }
        
        .form-card {
            margin-bottom: 20px;
            border-radius: 12px;
        }
        
        .preview-card {
            position: relative;
            top: 0;
            margin-top: 20px;
        }
        
        .card-body-modern {
            padding: 20px 15px;
        }
        
        .card-header-modern {
            padding: 15px 20px;
        }
        
        .card-header-modern h5 {
            font-size: 1.1rem;
        }
        
        .preview-content {
            padding: 20px;
        }
        
        .preview-icon-container {
            padding: 20px;
        }
        
        .btn-save-modern {
            padding: 12px 20px;
            font-size: 1rem;
        }
    }
    
    @media (max-width: 576px) {
        .professional-form {
            padding: 5px 0;
        }
        
        .form-card, .preview-card {
            border-radius: 10px;
            margin-bottom: 15px;
        }
        
        .card-body-modern {
            padding: 15px 10px;
        }
        
        .card-header-modern {
            padding: 12px 15px;
        }
        
        .section-divider {
            margin: 15px 0;
        }
        
        .form-control-modern, .form-select-modern {
            padding: 10px 12px;
            font-size: 0.9rem;
        }
        
        .input-group-modern .input-group-text {
            padding: 10px 12px;
            font-size: 0.9rem;
        }
        
        .preview-content {
            padding: 15px;
        }
        
        .price-display {
            font-size: 1.3rem;
        }
        
        .tips-body {
            padding: 0 15px 15px;
        }
    }
    
    .fade-in {
        animation: fadeIn 0.6s ease-in-out;
    }
    
    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
</style>
@endpush

@section('page-actions')
<a href="{{ route('products.index') }}" class="btn btn-outline-secondary rounded-pill">
    <i class="fas fa-arrow-left me-2"></i>
    العودة للقائمة
</a>
@endsection

@section('content')
<div class="professional-form">
    <form method="POST" action="{{ route('products.store') }}" id="product-form" class="fade-in">
        @csrf
        
        <div class="row g-4">
            <div class="col-lg-9">
                <!-- المعلومات الأساسية -->
                <div class="form-card fade-in">
                    <div class="card-header-modern">
                        <h5>
                            <i class="fas fa-info-circle"></i>
                            المعلومات الأساسية
                        </h5>
                    </div>
                    <div class="card-body-modern">
                        <div class="row g-4">
                            <div class="col-md-12">
                                <label class="form-label-modern">اسم المنتج/الخدمة <span class="text-danger">*</span></label>
                                <input type="text" name="name" class="form-control form-control-modern @error('name') is-invalid @enderror"
                                       value="{{ old('name') }}" required placeholder="أدخل اسم المنتج أو الخدمة">
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="section-divider"></div>
                        
                        <div class="row g-4">
                            <div class="col-md-4">
                                <label class="form-label-modern">النوع <span class="text-danger">*</span></label>
                                <select name="type" class="form-select form-select-modern @error('type') is-invalid @enderror"
                                        required onchange="toggleStockFields()">
                                    <option value="">اختر النوع</option>
                                    <option value="product" {{ old('type') == 'product' ? 'selected' : '' }}>منتج</option>
                                    <option value="service" {{ old('type') == 'service' ? 'selected' : '' }}>خدمة</option>
                                </select>
                                @error('type')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-4">
                                <label class="form-label-modern">رمز المنتج (SKU) <span class="text-danger">*</span></label>
                                <input type="text" name="sku" class="form-control form-control-modern @error('sku') is-invalid @enderror"
                                       value="{{ old('sku') }}" required placeholder="مثال: PRD001">
                                @error('sku')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-4">
                                <label class="form-label-modern">الباركود</label>
                                <input type="text" name="barcode" class="form-control form-control-modern @error('barcode') is-invalid @enderror"
                                       value="{{ old('barcode') }}" placeholder="رقم الباركود">
                                @error('barcode')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="section-divider"></div>
                        
                        <div class="row g-4">
                            <div class="col-md-4">
                                <label class="form-label-modern">الفئة</label>
                                <select name="category_id" class="form-select form-select-modern @error('category_id') is-invalid @enderror">
                                    <option value="">اختر الفئة</option>
                                    @foreach($categories as $id => $name)
                                        <option value="{{ $id }}" {{ old('category_id') == $id ? 'selected' : '' }}>{{ $name }}</option>
                                    @endforeach
                                </select>
                                @error('category_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-4">
                                <label class="form-label-modern">نوع العنصر <span class="text-danger">*</span></label>
                                <select name="item_type" class="form-select form-select-modern @error('item_type') is-invalid @enderror" required>
                                    <option value="">اختر نوع العنصر</option>
                                    <option value="food" {{ old('item_type') == 'food' ? 'selected' : '' }}>طعام</option>
                                    <option value="beverage" {{ old('item_type') == 'beverage' ? 'selected' : '' }}>مشروب</option>
                                    <option value="dessert" {{ old('item_type') == 'dessert' ? 'selected' : '' }}>حلوى</option>
                                    <option value="appetizer" {{ old('item_type') == 'appetizer' ? 'selected' : '' }}>مقبلات</option>
                                    <option value="main_course" {{ old('item_type') == 'main_course' ? 'selected' : '' }}>طبق رئيسي</option>
                                    <option value="combo" {{ old('item_type') == 'combo' ? 'selected' : '' }}>وجبة كومبو</option>
                                    <option value="other" {{ old('item_type') == 'other' ? 'selected' : '' }}>أخرى</option>
                                </select>
                                @error('item_type')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-4">
                                <label class="form-label-modern">رابط الصورة</label>
                                <input type="url" name="image_url" class="form-control form-control-modern @error('image_url') is-invalid @enderror"
                                       value="{{ old('image_url') }}" placeholder="https://example.com/image.jpg">
                                @error('image_url')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
            
                <!-- الأسعار والضرائب -->
                <div class="form-card mt-4 fade-in">
                    <div class="card-header-modern">
                        <h5>
                            <i class="fas fa-money-bill-wave"></i>
                            الأسعار والضرائب
                        </h5>
                    </div>
                    <div class="card-body-modern">
                        <div class="row g-4">
                            <div class="col-md-4">
                                <label class="form-label-modern">السعر بدون ضريبة <span class="text-danger">*</span></label>
                                <div class="input-group input-group-modern">
                                    <input type="number" name="price" class="form-control form-control-modern @error('price') is-invalid @enderror"
                                           value="{{ old('price') }}" step="0.01" min="0" required onchange="calculatePriceWithTax()" placeholder="0.00">
                                    <span class="input-group-text">ر.س</span>
                                </div>
                                @error('price')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-4">
                                <label class="form-label-modern">معدل الضريبة <span class="text-danger">*</span></label>
                                <div class="input-group input-group-modern">
                                    <input type="number" name="tax_rate" class="form-control form-control-modern @error('tax_rate') is-invalid @enderror"
                                           value="{{ old('tax_rate', 15) }}" step="0.01" min="0" max="100" required onchange="calculatePriceWithTax()" placeholder="15.00">
                                    <span class="input-group-text">%</span>
                                </div>
                                @error('tax_rate')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-4">
                                <label class="form-label-modern">السعر مع الضريبة</label>
                                <div class="input-group input-group-modern">
                                    <input type="text" id="price-with-tax-display" class="form-control form-control-modern" readonly placeholder="0.00">
                                    <span class="input-group-text">ر.س</span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="section-divider"></div>
                        
                        <div class="row g-4">
                            <div class="col-md-6">
                                <div class="form-check form-check-modern">
                                    <input type="checkbox" name="is_taxable" class="form-check-input"
                                           value="1" {{ old('is_taxable', true) ? 'checked' : '' }} onchange="toggleTaxFields()">
                                    <label class="form-check-label form-label-modern">
                                        خاضع للضريبة
                                    </label>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <label class="form-label-modern">رمز تصنيف ZATCA</label>
                                <input type="text" name="zatca_category_code" class="form-control form-control-modern @error('zatca_category_code') is-invalid @enderror"
                                       value="{{ old('zatca_category_code') }}" placeholder="مثال: ELEC001">
                                @error('zatca_category_code')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
               
                <!-- أسعار الأحجام المختلفة -->
                <div class="form-card mt-4 fade-in">
                    <div class="card-header-modern">
                        <h5>
                            <i class="fas fa-expand-arrows-alt"></i>
                            أسعار الأحجام المختلفة
                        </h5>
                    </div>
                    <div class="card-body-modern">
                        <div class="alert alert-modern">
                            <i class="fas fa-info-circle me-2"></i>
                            يمكنك تحديد أسعار مختلفة للأحجام المتعددة. اتركها فارغة إذا لم تكن متوفرة.
                        </div>
                        <div class="row g-4">
                            <div class="col-md-4">
                                <label class="form-label-modern">سعر الحجم الصغير</label>
                                <div class="input-group input-group-modern">
                                    <input type="number" name="size_small_price" class="form-control form-control-modern @error('size_small_price') is-invalid @enderror"
                                           value="{{ old('size_small_price') }}" step="0.01" min="0" placeholder="اختياري">
                                    <span class="input-group-text">ر.س</span>
                                </div>
                                @error('size_small_price')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-4">
                                <label class="form-label-modern">سعر الحجم الوسط</label>
                                <div class="input-group input-group-modern">
                                    <input type="number" name="size_medium_price" class="form-control form-control-modern @error('size_medium_price') is-invalid @enderror"
                                           value="{{ old('size_medium_price') }}" step="0.01" min="0" placeholder="اختياري">
                                    <span class="input-group-text">ر.س</span>
                                </div>
                                @error('size_medium_price')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-4">
                                <label class="form-label-modern">سعر الحجم الكبير</label>
                                <div class="input-group input-group-modern">
                                    <input type="number" name="size_large_price" class="form-control form-control-modern @error('size_large_price') is-invalid @enderror"
                                           value="{{ old('size_large_price') }}" step="0.01" min="0" placeholder="اختياري">
                                    <span class="input-group-text">ر.س</span>
                                </div>
                                @error('size_large_price')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- إدارة المخزون -->
                <div class="form-card mt-4 fade-in" id="stock-section">
                    <div class="card-header-modern">
                        <h5>
                            <i class="fas fa-warehouse"></i>
                            إدارة المخزون
                        </h5>
                    </div>
                    <div class="card-body-modern">
                        <div class="row g-4">
                            <div class="col-md-4">
                                <label class="form-label-modern">الوحدة <span class="text-danger">*</span></label>
                                <input type="text" name="unit" class="form-control form-control-modern @error('unit') is-invalid @enderror"
                                       value="{{ old('unit') }}" required placeholder="مثال: قطعة، كيلو، ساعة">
                                @error('unit')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-4" id="stock-quantity-field">
                                <label class="form-label-modern">الكمية الحالية <span class="text-danger">*</span></label>
                                <input type="number" name="stock_quantity" class="form-control form-control-modern @error('stock_quantity') is-invalid @enderror"
                                       value="{{ old('stock_quantity', 0) }}" min="0" required placeholder="0">
                                @error('stock_quantity')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-4" id="min-stock-field">
                                <label class="form-label-modern">الحد الأدنى للمخزون <span class="text-danger">*</span></label>
                                <input type="number" name="min_stock" class="form-control form-control-modern @error('min_stock') is-invalid @enderror"
                                       value="{{ old('min_stock', 0) }}" min="0" required placeholder="0">
                                @error('min_stock')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
        </div>
        
            <!-- معاينة المنتج -->
            <div class="col-lg-3">
                <div class="preview-card fade-in">
                    <div class="preview-header">
                        <h5 class="mb-0" style="position: relative; z-index: 1;">
                            <i class="fas fa-eye me-2"></i>
                            معاينة المنتج
                        </h5>
                    </div>
                    <div class="preview-content">
                        <div class="preview-icon-container">
                            <i class="fas fa-box fa-3x mb-3" style="color: #007bff;"></i>
                            <div id="product-preview-name" class="h6 mb-2" style="color: #495057; font-weight: 600;">اسم المنتج</div>
                            <div id="product-preview-sku" class="text-muted small">رمز المنتج</div>
                        </div>
                        
                        <div class="mb-4">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <strong style="color: #495057;">السعر:</strong>
                            </div>
                            <div id="product-preview-price" class="price-display mb-1">0.00 ر.س</div>
                            <div id="product-preview-price-with-tax" class="text-muted small">مع الضريبة: 0.00 ر.س</div>
                        </div>
                        
                        <div class="mb-4">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <strong style="color: #495057;">الفئة:</strong>
                            </div>
                            <div id="product-preview-category" class="small text-muted">غير محددة</div>
                        </div>
                        
                        <div class="mb-4">
                            <div class="d-flex justify-content-between align-items-center">
                                <strong style="color: #495057;">النوع:</strong>
                                <span id="product-preview-type" class="badge badge-modern bg-secondary">غير محدد</span>
                            </div>
                        </div>
                        
                        <div class="mb-4" id="product-preview-stock">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <strong style="color: #495057;">المخزون:</strong>
                            </div>
                            <div id="product-preview-stock-qty" class="h6" style="color: #17a2b8;">0 وحدة</div>
                        </div>
                        
                        <div class="form-check form-check-modern mb-4">
                            <input type="checkbox" name="is_active" class="form-check-input"
                                   value="1" {{ old('is_active', true) ? 'checked' : '' }}>
                            <label class="form-check-label form-label-modern">
                                منتج نشط
                            </label>
                        </div>
                        
                        <div class="d-grid">
                            <button type="submit" class="btn btn-save-modern">
                                <i class="fas fa-save me-2"></i>
                                حفظ المنتج
                            </button>
                        </div>
                    </div>
                </div>
                
                <!-- نصائح -->
                <div class="tips-card fade-in">
                    <div class="tips-header">
                        <h6 class="mb-0" style="color: #856404; font-weight: 600;">
                            <i class="fas fa-lightbulb me-2"></i>
                            نصائح مهمة
                        </h6>
                    </div>
                    <div class="tips-body">
                        <ul class="list-unstyled mb-0">
                            <li class="mb-3 d-flex align-items-start">
                                <i class="fas fa-check-circle text-success me-2 mt-1" style="font-size: 0.9rem;"></i>
                                <span class="small" style="color: #856404; font-weight: 500;">استخدم رموز SKU واضحة ومتسقة لسهولة إدارة المخزون</span>
                            </li>
                            <li class="mb-3 d-flex align-items-start">
                                <i class="fas fa-check-circle text-success me-2 mt-1" style="font-size: 0.9rem;"></i>
                                <span class="small" style="color: #856404; font-weight: 500;">حدد نوع العنصر بدقة (طعام، مشروب، إلخ) لتحسين التصنيف</span>
                            </li>
                            <li class="mb-0 d-flex align-items-start">
                                <i class="fas fa-check-circle text-success me-2 mt-1" style="font-size: 0.9rem;"></i>
                                <span class="small" style="color: #856404; font-weight: 500;">تأكد من إدخال الأسعار بدقة لتجنب الأخطاء المحاسبية</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
    </div>
</form>
@endsection

@push('scripts')
<script>
function toggleStockFields() {
    const type = document.querySelector('select[name="type"]').value;
    const stockSection = document.getElementById('stock-section');
    const stockQuantityField = document.getElementById('stock-quantity-field');
    const minStockField = document.getElementById('min-stock-field');
    const stockQuantityInput = document.querySelector('input[name="stock_quantity"]');
    const minStockInput = document.querySelector('input[name="min_stock"]');
    
    if (type === 'service') {
        stockQuantityField.style.display = 'none';
        minStockField.style.display = 'none';
        stockQuantityInput.required = false;
        minStockInput.required = false;
        stockQuantityInput.value = 0;
        minStockInput.value = 0;
        
        document.getElementById('product-preview-stock').style.display = 'none';
        document.getElementById('product-preview-type').textContent = 'خدمة';
        document.getElementById('product-preview-type').className = 'badge bg-info';
    } else if (type === 'product') {
        stockQuantityField.style.display = 'block';
        minStockField.style.display = 'block';
        stockQuantityInput.required = true;
        minStockInput.required = true;
        
        document.getElementById('product-preview-stock').style.display = 'block';
        document.getElementById('product-preview-type').textContent = 'منتج';
        document.getElementById('product-preview-type').className = 'badge bg-primary';
        updateStockPreview();
    } else {
        document.getElementById('product-preview-type').textContent = 'غير محدد';
        document.getElementById('product-preview-type').className = 'badge bg-secondary';
    }
}

function toggleTaxFields() {
    const isTaxable = document.querySelector('input[name="is_taxable"]').checked;
    const taxRateInput = document.querySelector('input[name="tax_rate"]');
    
    if (isTaxable) {
        taxRateInput.disabled = false;
        taxRateInput.required = true;
    } else {
        taxRateInput.disabled = true;
        taxRateInput.required = false;
        taxRateInput.value = 0;
    }
    
    calculatePriceWithTax();
}

function calculatePriceWithTax() {
    const price = parseFloat(document.querySelector('input[name="price"]').value) || 0;
    const taxRate = parseFloat(document.querySelector('input[name="tax_rate"]').value) || 0;
    const isTaxable = document.querySelector('input[name="is_taxable"]').checked;
    
    let priceWithTax = price;
    if (isTaxable) {
        priceWithTax = price * (1 + (taxRate / 100));
    }
    
    document.getElementById('price-with-tax-display').value = priceWithTax.toFixed(2);
    
    // تحديث المعاينة
    document.getElementById('product-preview-price').textContent = price.toFixed(2) + ' ر.س';
    document.getElementById('product-preview-price-with-tax').textContent = 'مع الضريبة: ' + priceWithTax.toFixed(2) + ' ر.س';
}

function updatePreview() {
    const name = document.querySelector('input[name="name"]').value || 'اسم المنتج';
    const sku = document.querySelector('input[name="sku"]').value || 'رمز المنتج';
    const itemType = document.querySelector('select[name="item_type"]').value;
    const categorySelect = document.querySelector('select[name="category_id"]');
    const categoryText = categorySelect.options[categorySelect.selectedIndex].text;
    
    document.getElementById('product-preview-name').textContent = name;
    document.getElementById('product-preview-sku').textContent = sku;
    document.getElementById('product-preview-category').textContent = categorySelect.value ? categoryText : 'غير محددة';
    
    // تحديث أيقونة المنتج حسب النوع
    const productIcon = document.querySelector('.fa-box');
    if (productIcon) {
        switch (itemType) {
            case 'food':
                productIcon.className = 'fas fa-utensils fa-3x text-muted mb-2';
                break;
            case 'beverage':
                productIcon.className = 'fas fa-coffee fa-3x text-muted mb-2';
                break;
            case 'dessert':
                productIcon.className = 'fas fa-birthday-cake fa-3x text-muted mb-2';
                break;
            case 'appetizer':
                productIcon.className = 'fas fa-cookie-bite fa-3x text-muted mb-2';
                break;
            case 'main_course':
                productIcon.className = 'fas fa-drumstick-bite fa-3x text-muted mb-2';
                break;
            case 'combo':
                productIcon.className = 'fas fa-hamburger fa-3x text-muted mb-2';
                break;
            default:
                productIcon.className = 'fas fa-box fa-3x text-muted mb-2';
        }
    }
}


function updateStockPreview() {
    const stockQuantity = document.querySelector('input[name="stock_quantity"]').value || 0;
    const unit = document.querySelector('input[name="unit"]').value || 'وحدة';
    
    document.getElementById('product-preview-stock-qty').textContent = stockQuantity + ' ' + unit;
}

// ربط الأحداث
document.querySelector('input[name="name"]').addEventListener('input', updatePreview);
document.querySelector('input[name="sku"]').addEventListener('input', updatePreview);
document.querySelector('select[name="category_id"]').addEventListener('change', updatePreview);
document.querySelector('select[name="item_type"]').addEventListener('change', updatePreview);
document.querySelector('input[name="price"]').addEventListener('input', calculatePriceWithTax);
document.querySelector('input[name="tax_rate"]').addEventListener('input', calculatePriceWithTax);
document.querySelector('input[name="stock_quantity"]').addEventListener('input', updateStockPreview);
document.querySelector('input[name="unit"]').addEventListener('input', updateStockPreview);
// تشغيل الوظائف عند التحميل
document.addEventListener('DOMContentLoaded', function() {
    toggleStockFields();
    toggleTaxFields();
    calculatePriceWithTax();
    updatePreview();
});
</script>
@endpush