@extends('layouts.app')

@section('title', 'تحليل أداء الموردين')
@section('page-title', 'تحليل أداء الموردين المتقدم')

@section('page-actions')
    <div class="btn-group" role="group">
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#dateRangeModal">
            <i class="fas fa-calendar me-2"></i>
            تخصيص الفترة
        </button>
        <div class="btn-group" role="group">
            <button type="button" class="btn btn-outline-secondary dropdown-toggle" data-bs-toggle="dropdown">
                <i class="fas fa-download me-2"></i>
                تصدير التقرير
            </button>
            <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="#" onclick="exportReport('excel')">
                    <i class="fas fa-file-excel me-2"></i>Excel
                </a></li>
                <li><a class="dropdown-item" href="#" onclick="exportReport('pdf')">
                    <i class="fas fa-file-pdf me-2"></i>PDF
                </a></li>
            </ul>
        </div>
    </div>
@endsection

@section('content')
<!-- معلومات الفترة الزمنية -->
<div class="row mb-4">
    <div class="col-12">
        <div class="alert alert-info">
            <i class="fas fa-info-circle me-2"></i>
            <strong>الفترة المحددة:</strong> 
            من {{ \Carbon\Carbon::parse($dateFrom)->format('Y-m-d') }} 
            إلى {{ \Carbon\Carbon::parse($dateTo)->format('Y-m-d') }}
        </div>
    </div>
</div>

<!-- جدول تحليل أداء الموردين -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-chart-line me-2"></i>
                    تحليل أداء الموردين
                </h6>
                <div class="card-tools">
                    <span class="badge bg-secondary">{{ $suppliers->count() }} مورد</span>
                </div>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>المورد</th>
                                <th class="text-center">عدد الأوامر</th>
                                <th class="text-center">الأوامر المكتملة</th>
                                <th class="text-center">إجمالي القيمة</th>
                                <th class="text-center">معدل التسليم في الوقت</th>
                                <th class="text-center">معدل الجودة</th>
                                <th class="text-center">متوسط أيام التسليم</th>
                                <th class="text-center">الامتثال للدفع</th>
                                <th class="text-center">التقييم العام</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($suppliers as $supplierData)
                            @php
                                $supplier = $supplierData['supplier'];
                                $overallRating = ($supplierData['on_time_rate'] + $supplierData['quality_rate'] + $supplierData['payment_terms_compliance']) / 3;
                            @endphp
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0 me-3">
                                            @if($overallRating >= 90)
                                                <i class="fas fa-star text-success fa-lg"></i>
                                            @elseif($overallRating >= 75)
                                                <i class="fas fa-star text-warning fa-lg"></i>
                                            @else
                                                <i class="fas fa-star text-danger fa-lg"></i>
                                            @endif
                                        </div>
                                        <div>
                                            <strong>{{ $supplier->name }}</strong>
                                            @if($supplier->email)
                                                <br><small class="text-muted">{{ $supplier->email }}</small>
                                            @endif
                                        </div>
                                    </div>
                                </td>
                                <td class="text-center">
                                    <strong>{{ number_format($supplierData['total_orders']) }}</strong>
                                </td>
                                <td class="text-center">
                                    <strong>{{ number_format($supplierData['completed_orders']) }}</strong>
                                    @if($supplierData['total_orders'] > 0)
                                        <br><small class="text-muted">
                                            {{ number_format(($supplierData['completed_orders'] / $supplierData['total_orders']) * 100, 1) }}%
                                        </small>
                                    @endif
                                </td>
                                <td class="text-center">
                                    <strong class="text-primary">{{ number_format($supplierData['total_value'], 0) }} ر.س</strong>
                                </td>
                                <td class="text-center">
                                    <div class="d-flex flex-column align-items-center">
                                        <strong class="text-{{ $supplierData['on_time_rate'] >= 90 ? 'success' : ($supplierData['on_time_rate'] >= 75 ? 'warning' : 'danger') }}">
                                            {{ $supplierData['on_time_rate'] }}%
                                        </strong>
                                        <div class="progress mt-1" style="width: 60px; height: 6px;">
                                            <div class="progress-bar bg-{{ $supplierData['on_time_rate'] >= 90 ? 'success' : ($supplierData['on_time_rate'] >= 75 ? 'warning' : 'danger') }}" 
                                                 style="width: {{ $supplierData['on_time_rate'] }}%"></div>
                                        </div>
                                    </div>
                                </td>
                                <td class="text-center">
                                    <div class="d-flex flex-column align-items-center">
                                        <strong class="text-{{ $supplierData['quality_rate'] >= 95 ? 'success' : ($supplierData['quality_rate'] >= 85 ? 'warning' : 'danger') }}">
                                            {{ $supplierData['quality_rate'] }}%
                                        </strong>
                                        <div class="progress mt-1" style="width: 60px; height: 6px;">
                                            <div class="progress-bar bg-{{ $supplierData['quality_rate'] >= 95 ? 'success' : ($supplierData['quality_rate'] >= 85 ? 'warning' : 'danger') }}" 
                                                 style="width: {{ $supplierData['quality_rate'] }}%"></div>
                                        </div>
                                    </div>
                                </td>
                                <td class="text-center">
                                    <strong class="text-{{ $supplierData['avg_delivery_days'] <= 14 ? 'success' : ($supplierData['avg_delivery_days'] <= 21 ? 'warning' : 'danger') }}">
                                        {{ $supplierData['avg_delivery_days'] }} يوم
                                    </strong>
                                </td>
                                <td class="text-center">
                                    <div class="d-flex flex-column align-items-center">
                                        <strong class="text-{{ $supplierData['payment_terms_compliance'] >= 90 ? 'success' : ($supplierData['payment_terms_compliance'] >= 75 ? 'warning' : 'danger') }}">
                                            {{ number_format($supplierData['payment_terms_compliance'], 1) }}%
                                        </strong>
                                        <div class="progress mt-1" style="width: 60px; height: 6px;">
                                            <div class="progress-bar bg-{{ $supplierData['payment_terms_compliance'] >= 90 ? 'success' : ($supplierData['payment_terms_compliance'] >= 75 ? 'warning' : 'danger') }}" 
                                                 style="width: {{ $supplierData['payment_terms_compliance'] }}%"></div>
                                        </div>
                                    </div>
                                </td>
                                <td class="text-center">
                                    <div class="d-flex flex-column align-items-center">
                                        @if($overallRating >= 90)
                                            <span class="badge bg-success">ممتاز</span>
                                        @elseif($overallRating >= 75)
                                            <span class="badge bg-warning">جيد</span>
                                        @elseif($overallRating >= 60)
                                            <span class="badge bg-info">مقبول</span>
                                        @else
                                            <span class="badge bg-danger">ضعيف</span>
                                        @endif
                                        <small class="text-muted mt-1">{{ number_format($overallRating, 1) }}%</small>
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="9" class="text-center py-5">
                                    <div class="text-muted">
                                        <i class="fas fa-chart-line fa-3x mb-3"></i>
                                        <h5>لا توجد بيانات أداء</h5>
                                        <p>لا توجد بيانات أداء للموردين في الفترة المحددة</p>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- إحصائيات إضافية -->
@if($suppliers->count() > 0)
<div class="row mt-4">
    <div class="col-md-3 mb-3">
        <div class="card text-white bg-success">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-star fa-2x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="card-title h5 mb-1">{{ $suppliers->where('0', function($item) { return (($item['on_time_rate'] + $item['quality_rate'] + $item['payment_terms_compliance']) / 3) >= 90; })->count() }}</div>
                        <div class="card-text small">موردين ممتازين</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-3 mb-3">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-clock fa-2x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="card-title h5 mb-1">{{ number_format($suppliers->avg('on_time_rate'), 1) }}%</div>
                        <div class="card-text small">متوسط التسليم في الوقت</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-3 mb-3">
        <div class="card text-white bg-info">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-award fa-2x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="card-title h5 mb-1">{{ number_format($suppliers->avg('quality_rate'), 1) }}%</div>
                        <div class="card-text small">متوسط معدل الجودة</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-3 mb-3">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-shipping-fast fa-2x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="card-title h5 mb-1">{{ number_format($suppliers->avg('avg_delivery_days'), 0) }}</div>
                        <div class="card-text small">متوسط أيام التسليم</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endif

<!-- مودال تخصيص الفترة الزمنية -->
<div class="modal fade" id="dateRangeModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="GET" action="{{ route('procurement.workflow.supplier-performance') }}">
                <div class="modal-header">
                    <h5 class="modal-title">تخصيص الفترة الزمنية</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="date_from" class="form-label">من تاريخ</label>
                                <input type="date" class="form-control" id="date_from" name="date_from" 
                                       value="{{ $dateFrom }}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="date_to" class="form-label">إلى تاريخ</label>
                                <input type="date" class="form-control" id="date_to" name="date_to" 
                                       value="{{ $dateTo }}">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class="btn-group w-100" role="group">
                                <button type="button" class="btn btn-outline-secondary" onclick="setDateRange('last_month')">الشهر الماضي</button>
                                <button type="button" class="btn btn-outline-secondary" onclick="setDateRange('last_3_months')">آخر 3 شهور</button>
                                <button type="button" class="btn btn-outline-secondary" onclick="setDateRange('last_6_months')">آخر 6 شهور</button>
                                <button type="button" class="btn btn-outline-secondary" onclick="setDateRange('last_year')">السنة الماضية</button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">تطبيق</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function setDateRange(period) {
    const dateFrom = document.getElementById('date_from');
    const dateTo = document.getElementById('date_to');
    const today = new Date();
    
    switch(period) {
        case 'last_month':
            const lastMonth = new Date(today.getFullYear(), today.getMonth() - 1, 1);
            const lastMonthEnd = new Date(today.getFullYear(), today.getMonth(), 0);
            dateFrom.value = lastMonth.toISOString().split('T')[0];
            dateTo.value = lastMonthEnd.toISOString().split('T')[0];
            break;
        case 'last_3_months':
            const last3Months = new Date(today.getFullYear(), today.getMonth() - 3, today.getDate());
            dateFrom.value = last3Months.toISOString().split('T')[0];
            dateTo.value = today.toISOString().split('T')[0];
            break;
        case 'last_6_months':
            const last6Months = new Date(today.getFullYear(), today.getMonth() - 6, today.getDate());
            dateFrom.value = last6Months.toISOString().split('T')[0];
            dateTo.value = today.toISOString().split('T')[0];
            break;
        case 'last_year':
            const lastYear = new Date(today.getFullYear() - 1, today.getMonth(), today.getDate());
            dateFrom.value = lastYear.toISOString().split('T')[0];
            dateTo.value = today.toISOString().split('T')[0];
            break;
    }
}

function exportReport(format) {
    const params = new URLSearchParams(window.location.search);
    params.set('format', format);
    
    window.open(`/procurement/workflow/supplier-performance/export?${params}`, '_blank');
}
</script>
@endpush

@push('styles')
<style>
.progress {
    background-color: #e9ecef;
}

.table td {
    vertical-align: middle;
}

.badge {
    font-size: 0.75rem;
}

.card-tools {
    display: flex;
    align-items: center;
}

@media (max-width: 768px) {
    .table-responsive {
        font-size: 0.875rem;
    }
    
    .progress {
        width: 40px !important;
        height: 4px !important;
    }
}
</style>
@endpush