@extends('layouts.app')

@section('title', 'إدارة أوامر الشراء')
@section('page-title', 'إدارة أوامر الشراء المتقدمة')

@section('page-actions')
    <div class="btn-group" role="group">
        <a href="{{ route('purchase-orders.create') }}" class="btn btn-primary">
            <i class="fas fa-plus me-2"></i>
            أمر شراء جديد
        </a>
        <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#bulkApproveModal">
            <i class="fas fa-check me-2"></i>
            موافقة مجمعة
        </button>
        <div class="btn-group" role="group">
            <button type="button" class="btn btn-outline-secondary dropdown-toggle" data-bs-toggle="dropdown">
                <i class="fas fa-download me-2"></i>
                تصدير
            </button>
            <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="#" onclick="exportOrders('excel')">
                    <i class="fas fa-file-excel me-2"></i>Excel
                </a></li>
                <li><a class="dropdown-item" href="#" onclick="exportOrders('pdf')">
                    <i class="fas fa-file-pdf me-2"></i>PDF
                </a></li>
            </ul>
        </div>
    </div>
@endsection

@section('content')
<!-- فلاتر البحث -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <form method="GET" action="{{ route('procurement.workflow.orders') }}" class="row align-items-center">
                    <div class="col-md-2 mb-2">
                        <select name="status" class="form-select">
                            <option value="">جميع الحالات</option>
                            <option value="pending" {{ request('status') === 'pending' ? 'selected' : '' }}>في الانتظار</option>
                            <option value="approved" {{ request('status') === 'approved' ? 'selected' : '' }}>موافق عليه</option>
                            <option value="sent" {{ request('status') === 'sent' ? 'selected' : '' }}>مرسل</option>
                            <option value="completed" {{ request('status') === 'completed' ? 'selected' : '' }}>مكتمل</option>
                            <option value="cancelled" {{ request('status') === 'cancelled' ? 'selected' : '' }}>ملغي</option>
                        </select>
                    </div>
                    <div class="col-md-2 mb-2">
                        <select name="supplier_id" class="form-select">
                            <option value="">جميع الموردين</option>
                            @foreach($suppliers as $supplier)
                                <option value="{{ $supplier->id }}" {{ request('supplier_id') == $supplier->id ? 'selected' : '' }}>
                                    {{ $supplier->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2 mb-2">
                        <input type="date" name="date_from" class="form-control" value="{{ request('date_from') }}" placeholder="من تاريخ">
                    </div>
                    <div class="col-md-2 mb-2">
                        <input type="date" name="date_to" class="form-control" value="{{ request('date_to') }}" placeholder="إلى تاريخ">
                    </div>
                    <div class="col-md-4 mb-2">
                        <div class="input-group">
                            <input type="text" name="search" class="form-control" placeholder="البحث في الأوامر..." 
                                   value="{{ request('search') }}">
                            <button type="submit" class="btn btn-outline-primary">
                                <i class="fas fa-search"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- جدول أوامر الشراء -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-list me-2"></i>
                    قائمة أوامر الشراء
                </h6>
                <div class="card-tools">
                    <span class="badge bg-secondary">{{ $orders->total() }} أمر</span>
                </div>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th width="30">
                                    <input type="checkbox" id="selectAll" class="form-check-input">
                                </th>
                                <th>رقم الأمر</th>
                                <th>المورد</th>
                                <th>تاريخ الأمر</th>
                                <th>تاريخ التسليم المتوقع</th>
                                <th>إجمالي المبلغ</th>
                                <th>الحالة</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($orders as $order)
                            <tr>
                                <td>
                                    <input type="checkbox" class="form-check-input order-checkbox" value="{{ $order->id }}">
                                </td>
                                <td>
                                    <strong>{{ $order->po_number }}</strong>
                                </td>
                                <td>
                                    <div>
                                        <strong>{{ $order->supplier->name }}</strong>
                                        @if($order->supplier->email)
                                            <br><small class="text-muted">{{ $order->supplier->email }}</small>
                                        @endif
                                    </div>
                                </td>
                                <td>{{ $order->order_date->format('Y-m-d') }}</td>
                                <td>
                                    <span class="text-{{ $order->expected_delivery_date->isPast() && $order->status !== 'completed' ? 'danger' : 'muted' }}">
                                        {{ $order->expected_delivery_date->format('Y-m-d') }}
                                    </span>
                                    @if($order->expected_delivery_date->isPast() && $order->status !== 'completed')
                                        <br><small class="text-danger">متأخر</small>
                                    @endif
                                </td>
                                <td>
                                    <strong>{{ number_format($order->total_amount, 2) }} ر.س</strong>
                                </td>
                                <td>
                                    @switch($order->status)
                                        @case('pending')
                                            <span class="badge bg-warning">في الانتظار</span>
                                            @break
                                        @case('approved')
                                            <span class="badge bg-info">موافق عليه</span>
                                            @break
                                        @case('sent')
                                            <span class="badge bg-primary">مرسل</span>
                                            @break
                                        @case('completed')
                                            <span class="badge bg-success">مكتمل</span>
                                            @break
                                        @case('cancelled')
                                            <span class="badge bg-danger">ملغي</span>
                                            @break
                                        @default
                                            <span class="badge bg-secondary">{{ $order->status }}</span>
                                    @endswitch
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="{{ route('purchase-orders.show', $order) }}" 
                                           class="btn btn-outline-info" title="عرض">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        
                                        @if($order->status === 'pending')
                                            <button type="button" class="btn btn-outline-success" 
                                                    onclick="approveOrder({{ $order->id }})" title="موافقة">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        @endif
                                        
                                        <a href="{{ route('procurement.workflow.track-order', $order) }}" 
                                           class="btn btn-outline-primary" title="تتبع">
                                            <i class="fas fa-route"></i>
                                        </a>
                                        
                                        @if(in_array($order->status, ['pending', 'approved']))
                                            <a href="{{ route('purchase-orders.edit', $order) }}" 
                                               class="btn btn-outline-warning" title="تعديل">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="8" class="text-center py-5">
                                    <div class="text-muted">
                                        <i class="fas fa-inbox fa-3x mb-3"></i>
                                        <h5>لا توجد أوامر شراء</h5>
                                        <p>لم يتم العثور على أوامر شراء تطابق معايير البحث</p>
                                        <a href="{{ route('purchase-orders.create') }}" class="btn btn-primary">
                                            <i class="fas fa-plus me-2"></i>
                                            إنشاء أمر شراء جديد
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            
            @if($orders->hasPages())
            <div class="card-footer">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="text-muted">
                        عرض {{ $orders->firstItem() }} إلى {{ $orders->lastItem() }} 
                        من أصل {{ $orders->total() }} أمر
                    </div>
                    <div>
                        {{ $orders->links() }}
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>

<!-- مودال الموافقة المجمعة -->
<div class="modal fade" id="bulkApproveModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">موافقة مجمعة على الأوامر</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>هل تريد الموافقة على الأوامر المحددة؟</p>
                <div id="selectedOrdersInfo"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <button type="button" class="btn btn-success" onclick="bulkApproveOrders()">موافقة</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// تحديد/إلغاء تحديد جميع الأوامر
document.getElementById('selectAll').addEventListener('change', function() {
    const checkboxes = document.querySelectorAll('.order-checkbox');
    checkboxes.forEach(checkbox => {
        checkbox.checked = this.checked;
    });
});

// موافقة على أمر واحد
function approveOrder(orderId) {
    if (confirm('هل تريد الموافقة على هذا الأمر؟')) {
        fetch(`/procurement/workflow/bulk-approve-orders`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                order_ids: [orderId]
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('حدث خطأ في الموافقة على الأمر');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('حدث خطأ في الموافقة على الأمر');
        });
    }
}

// الموافقة المجمعة
function bulkApproveOrders() {
    const selectedOrders = Array.from(document.querySelectorAll('.order-checkbox:checked')).map(cb => cb.value);
    
    if (selectedOrders.length === 0) {
        alert('يرجى اختيار أوامر للموافقة عليها');
        return;
    }
    
    fetch(`/procurement/workflow/bulk-approve-orders`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify({
            order_ids: selectedOrders
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        } else {
            alert('حدث خطأ في الموافقة على الأوامر');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('حدث خطأ في الموافقة على الأوامر');
    });
    
    // إغلاق المودال
    const modal = bootstrap.Modal.getInstance(document.getElementById('bulkApproveModal'));
    modal.hide();
}

// تصدير الأوامر
function exportOrders(format) {
    const params = new URLSearchParams(window.location.search);
    params.set('format', format);
    
    window.open(`/procurement/workflow/orders/export?${params}`, '_blank');
}

// تحديث معلومات الأوامر المحددة في المودال
document.getElementById('bulkApproveModal').addEventListener('show.bs.modal', function() {
    const selectedOrders = document.querySelectorAll('.order-checkbox:checked');
    const info = document.getElementById('selectedOrdersInfo');
    
    if (selectedOrders.length > 0) {
        info.innerHTML = `<div class="alert alert-info">تم تحديد ${selectedOrders.length} أمر شراء</div>`;
    } else {
        info.innerHTML = '<div class="alert alert-warning">لم يتم تحديد أي أوامر</div>';
    }
});
</script>
@endpush

@push('styles')
<style>
.badge {
    font-size: 0.75rem;
}

.table td {
    vertical-align: middle;
}

.btn-group-sm .btn {
    font-size: 0.75rem;
    padding: 0.25rem 0.5rem;
}

.card-tools {
    display: flex;
    align-items: center;
}

@media (max-width: 768px) {
    .table-responsive {
        font-size: 0.875rem;
    }
    
    .btn-group .btn {
        font-size: 0.75rem;
        padding: 0.25rem 0.5rem;
    }
}
</style>
@endpush