@extends('layouts.app')

@section('title', 'تحسين المخزون والشراء')
@section('page-title', 'تحسين المخزون والشراء الذكي')

@section('page-actions')
    <div class="btn-group" role="group">
        <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#autoOrderModal">
            <i class="fas fa-magic me-2"></i>
            إنشاء أمر تلقائي
        </button>
        <div class="btn-group" role="group">
            <button type="button" class="btn btn-outline-secondary dropdown-toggle" data-bs-toggle="dropdown">
                <i class="fas fa-download me-2"></i>
                تصدير التحليل
            </button>
            <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="#" onclick="exportAnalysis('excel')">
                    <i class="fas fa-file-excel me-2"></i>Excel
                </a></li>
                <li><a class="dropdown-item" href="#" onclick="exportAnalysis('pdf')">
                    <i class="fas fa-file-pdf me-2"></i>PDF
                </a></li>
            </ul>
        </div>
    </div>
@endsection

@section('content')
<!-- إحصائيات سريعة -->
<div class="row mb-4">
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-exclamation-triangle fa-2x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="card-title h5 mb-1">{{ count($reorderProducts) }}</div>
                        <div class="card-text small">منتجات تحتاج إعادة طلب</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card text-white bg-danger">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-clock fa-2x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="card-title h5 mb-1">{{ count($slowMovingProducts) }}</div>
                        <div class="card-text small">منتجات بطيئة الحركة</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-chart-line fa-2x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="card-title h5 mb-1">{{ count($purchaseRecommendations) }}</div>
                        <div class="card-text small">توصيات ذكية</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card text-white bg-success">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fas fa-dollar-sign fa-2x"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <div class="card-title h5 mb-1">{{ number_format(collect($reorderProducts)->sum('estimated_cost'), 0) }}</div>
                        <div class="card-text small">تكلفة متوقعة (ر.س)</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- المنتجات التي تحتاج إعادة طلب -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-shopping-cart me-2"></i>
                    منتجات تحتاج إعادة طلب
                </h6>
                <div class="card-tools">
                    <span class="badge bg-warning">{{ count($reorderProducts) }} منتج</span>
                </div>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th width="30">
                                    <input type="checkbox" id="selectAllReorder" class="form-check-input">
                                </th>
                                <th>المنتج</th>
                                <th class="text-center">المخزون الحالي</th>
                                <th class="text-center">مستوى الطلب</th>
                                <th class="text-center">الاستهلاك الشهري</th>
                                <th class="text-center">الكمية المقترحة</th>
                                <th class="text-center">التكلفة المتوقعة</th>
                                <th class="text-center">الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($reorderProducts as $item)
                            @php $product = $item['product']; @endphp
                            <tr>
                                <td>
                                    <input type="checkbox" class="form-check-input reorder-checkbox" 
                                           value="{{ $product->id }}" 
                                           data-supplier="{{ $product->supplier_id ?? '' }}"
                                           data-quantity="{{ $item['suggested_order_qty'] }}"
                                           data-cost="{{ $item['estimated_cost'] }}">
                                </td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0 me-3">
                                            <i class="fas fa-exclamation-triangle text-danger fa-lg"></i>
                                        </div>
                                        <div>
                                            <strong>{{ $product->name }}</strong>
                                            @if($product->sku)
                                                <br><small class="text-muted">{{ $product->sku }}</small>
                                            @endif
                                            @if($product->supplier)
                                                <br><small class="text-info">{{ $product->supplier->name }}</small>
                                            @endif
                                        </div>
                                    </div>
                                </td>
                                <td class="text-center">
                                    <strong class="text-danger">{{ number_format($item['current_stock']) }}</strong>
                                    <br><small class="text-muted">{{ $product->unit }}</small>
                                </td>
                                <td class="text-center">
                                    <strong>{{ number_format($item['reorder_level']) }}</strong>
                                    <br><small class="text-muted">{{ $product->unit }}</small>
                                </td>
                                <td class="text-center">
                                    <strong>{{ number_format($item['avg_monthly_usage']) }}</strong>
                                    <br><small class="text-muted">{{ $product->unit }}/شهر</small>
                                </td>
                                <td class="text-center">
                                    <div class="input-group input-group-sm">
                                        <input type="number" class="form-control suggested-qty" 
                                               value="{{ $item['suggested_order_qty'] }}" 
                                               data-product="{{ $product->id }}"
                                               min="1" style="width: 80px;">
                                        <span class="input-group-text">{{ $product->unit }}</span>
                                    </div>
                                </td>
                                <td class="text-center">
                                    <strong class="text-primary estimated-cost">{{ number_format($item['estimated_cost'], 2) }}</strong>
                                    <br><small class="text-muted">ر.س</small>
                                </td>
                                <td class="text-center">
                                    <div class="btn-group btn-group-sm" role="group">
                                        <button type="button" class="btn btn-outline-success" 
                                                onclick="addToOrder({{ $product->id }})" title="إضافة للأمر">
                                            <i class="fas fa-plus"></i>
                                        </button>
                                        <button type="button" class="btn btn-outline-info" 
                                                onclick="viewProductHistory({{ $product->id }})" title="عرض التاريخ">
                                            <i class="fas fa-history"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="8" class="text-center py-5">
                                    <div class="text-muted">
                                        <i class="fas fa-check-circle fa-3x mb-3 text-success"></i>
                                        <h5>جميع المنتجات في وضع جيد</h5>
                                        <p>لا توجد منتجات تحتاج إعادة طلب حالياً</p>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- المنتجات بطيئة الحركة -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-turtle me-2"></i>
                    منتجات بطيئة الحركة
                </h6>
                <div class="card-tools">
                    <span class="badge bg-secondary">{{ count($slowMovingProducts) }} منتج</span>
                </div>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>المنتج</th>
                                <th class="text-center">المخزون الحالي</th>
                                <th class="text-center">آخر حركة</th>
                                <th class="text-center">قيمة المخزون</th>
                                <th class="text-center">التوصية</th>
                                <th class="text-center">الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($slowMovingProducts as $product)
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0 me-3">
                                            <i class="fas fa-pause-circle text-warning fa-lg"></i>
                                        </div>
                                        <div>
                                            <strong>{{ $product->name }}</strong>
                                            @if($product->sku)
                                                <br><small class="text-muted">{{ $product->sku }}</small>
                                            @endif
                                            @if($product->supplier)
                                                <br><small class="text-info">{{ $product->supplier->name }}</small>
                                            @endif
                                        </div>
                                    </div>
                                </td>
                                <td class="text-center">
                                    <strong>{{ number_format($product->current_stock ?? $product->stock_quantity) }}</strong>
                                    <br><small class="text-muted">{{ $product->unit }}</small>
                                </td>
                                <td class="text-center">
                                    <span class="text-muted">6+ أشهر</span>
                                    <br><small class="text-warning">حركة قليلة</small>
                                </td>
                                <td class="text-center">
                                    <strong>{{ number_format(($product->current_stock ?? $product->stock_quantity) * ($product->cost_price ?? $product->price), 2) }}</strong>
                                    <br><small class="text-muted">ر.س</small>
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-warning">مراجعة التسعير</span>
                                </td>
                                <td class="text-center">
                                    <div class="btn-group btn-group-sm" role="group">
                                        <button type="button" class="btn btn-outline-warning" title="تخفيض السعر">
                                            <i class="fas fa-tags"></i>
                                        </button>
                                        <button type="button" class="btn btn-outline-info" title="عرض التفاصيل">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="6" class="text-center py-5">
                                    <div class="text-muted">
                                        <i class="fas fa-tachometer-alt fa-3x mb-3 text-success"></i>
                                        <h5>جميع المنتجات نشطة</h5>
                                        <p>لا توجد منتجات بطيئة الحركة</p>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- توصيات الشراء الذكية -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-lightbulb me-2"></i>
                    توصيات الشراء الذكية
                </h6>
                <div class="card-tools">
                    <span class="badge bg-info">{{ count($purchaseRecommendations) }} توصية</span>
                </div>
            </div>
            <div class="card-body">
                @forelse($purchaseRecommendations as $recommendation)
                <div class="alert alert-{{ $recommendation['type'] === 'bulk_discount' ? 'success' : 'info' }} d-flex align-items-center">
                    <div class="flex-shrink-0 me-3">
                        @if($recommendation['type'] === 'bulk_discount')
                            <i class="fas fa-percentage fa-2x"></i>
                        @else
                            <i class="fas fa-chart-line fa-2x"></i>
                        @endif
                    </div>
                    <div class="flex-grow-1">
                        <h6 class="alert-heading">{{ $recommendation['title'] }}</h6>
                        <p class="mb-1">{{ $recommendation['description'] }}</p>
                        @if(isset($recommendation['potential_savings']))
                            <small class="text-success">
                                <i class="fas fa-coins me-1"></i>
                                توفير محتمل: {{ number_format($recommendation['potential_savings']) }} ر.س
                            </small>
                        @endif
                        @if(isset($recommendation['recommended_action']))
                            <br><small class="fw-bold">{{ $recommendation['recommended_action'] }}</small>
                        @endif
                    </div>
                    <div class="flex-shrink-0">
                        <button type="button" class="btn btn-sm btn-outline-primary">تطبيق</button>
                    </div>
                </div>
                @empty
                <div class="text-center py-4">
                    <i class="fas fa-brain fa-3x text-muted mb-3"></i>
                    <h6>لا توجد توصيات حالياً</h6>
                    <p class="text-muted">سيتم تحديث التوصيات تلقائياً بناءً على تحليل البيانات</p>
                </div>
                @endforelse
            </div>
        </div>
    </div>
</div>

<!-- مودال إنشاء أمر تلقائي -->
<div class="modal fade" id="autoOrderModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form action="{{ route('procurement.workflow.create-auto-purchase-order') }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">إنشاء أمر شراء تلقائي</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="supplier_id" class="form-label">اختر المورد</label>
                        <select class="form-select" id="supplier_id" name="supplier_id" required>
                            <option value="">اختر المورد...</option>
                            <!-- سيتم ملؤها بـ JavaScript -->
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">المنتجات المحددة</label>
                        <div id="selectedProductsList" class="border rounded p-3 bg-light">
                            <p class="text-muted mb-0">لم يتم تحديد منتجات</p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body text-center">
                                    <h6>إجمالي المنتجات</h6>
                                    <h4 id="totalProducts" class="text-primary">0</h4>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body text-center">
                                    <h6>التكلفة المتوقعة</h6>
                                    <h4 id="totalCost" class="text-success">0 ر.س</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-success" id="createOrderBtn" disabled>إنشاء الأمر</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
let selectedProducts = {};

// تحديد/إلغاء تحديد جميع المنتجات
document.getElementById('selectAllReorder').addEventListener('change', function() {
    const checkboxes = document.querySelectorAll('.reorder-checkbox');
    checkboxes.forEach(checkbox => {
        checkbox.checked = this.checked;
        updateSelectedProducts();
    });
});

// تحديث المنتجات المحددة
document.addEventListener('change', function(e) {
    if (e.target.classList.contains('reorder-checkbox')) {
        updateSelectedProducts();
    }
    if (e.target.classList.contains('suggested-qty')) {
        updateCosts(e.target);
    }
});

function updateSelectedProducts() {
    selectedProducts = {};
    const checkboxes = document.querySelectorAll('.reorder-checkbox:checked');
    
    checkboxes.forEach(checkbox => {
        const productId = checkbox.value;
        const supplierId = checkbox.dataset.supplier;
        const row = checkbox.closest('tr');
        const quantity = row.querySelector('.suggested-qty').value;
        const productName = row.querySelector('strong').textContent;
        
        if (!selectedProducts[supplierId]) {
            selectedProducts[supplierId] = [];
        }
        
        selectedProducts[supplierId].push({
            product_id: productId,
            quantity: quantity,
            name: productName
        });
    });
    
    updateModalContent();
}

function updateCosts(input) {
    const row = input.closest('tr');
    const productId = input.dataset.product;
    const quantity = parseFloat(input.value) || 0;
    const checkbox = row.querySelector('.reorder-checkbox');
    const costPerUnit = parseFloat(checkbox.dataset.cost) / parseFloat(checkbox.dataset.quantity);
    const newCost = quantity * costPerUnit;
    
    row.querySelector('.estimated-cost').textContent = newCost.toLocaleString('ar-SA', {
        minimumFractionDigits: 2,
        maximumFractionDigits: 2
    });
    
    updateSelectedProducts();
}

function updateModalContent() {
    const supplierSelect = document.getElementById('supplier_id');
    const productsList = document.getElementById('selectedProductsList');
    const totalProducts = document.getElementById('totalProducts');
    const totalCost = document.getElementById('totalCost');
    const createBtn = document.getElementById('createOrderBtn');
    
    // Clear supplier options
    supplierSelect.innerHTML = '<option value="">اختر المورد...</option>';
    
    let totalProductCount = 0;
    let totalCostValue = 0;
    
    if (Object.keys(selectedProducts).length === 0) {
        productsList.innerHTML = '<p class="text-muted mb-0">لم يتم تحديد منتجات</p>';
        createBtn.disabled = true;
    } else {
        let html = '';
        
        Object.entries(selectedProducts).forEach(([supplierId, products]) => {
            if (supplierId && supplierId !== '') {
                supplierSelect.innerHTML += `<option value="${supplierId}">مورد ${supplierId}</option>`;
            }
            
            products.forEach(product => {
                html += `<div class="badge bg-primary me-1 mb-1">${product.name} (${product.quantity})</div>`;
                totalProductCount++;
                totalCostValue += parseFloat(product.quantity) * 10; // تقدير
            });
        });
        
        productsList.innerHTML = html;
        createBtn.disabled = false;
    }
    
    totalProducts.textContent = totalProductCount;
    totalCost.textContent = totalCostValue.toLocaleString('ar-SA') + ' ر.س';
}

function addToOrder(productId) {
    const checkbox = document.querySelector(`input[value="${productId}"]`);
    checkbox.checked = true;
    updateSelectedProducts();
    
    // إظهار المودال
    const modal = new bootstrap.Modal(document.getElementById('autoOrderModal'));
    modal.show();
}

function viewProductHistory(productId) {
    // يمكن إضافة مودال لعرض تاريخ المنتج
    alert(`عرض تاريخ المنتج ${productId}`);
}

function exportAnalysis(format) {
    window.open(`/procurement/workflow/inventory-optimization/export?format=${format}`, '_blank');
}
</script>
@endpush

@push('styles')
<style>
.table td {
    vertical-align: middle;
}

.badge {
    font-size: 0.75rem;
}

.input-group-sm .form-control {
    font-size: 0.875rem;
}

.card-tools {
    display: flex;
    align-items: center;
}

.alert {
    border-left: 4px solid currentColor;
}

@media (max-width: 768px) {
    .table-responsive {
        font-size: 0.875rem;
    }
    
    .btn-group .btn {
        font-size: 0.75rem;
        padding: 0.25rem 0.5rem;
    }
}
</style>
@endpush