@extends('layouts.app')

@section('title', 'لوحة تحكم سير عمل المشتريات')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-0 text-gray-800">
                        <i class="fas fa-cogs me-2"></i>
                        إدارة سير عمل المشتريات
                    </h1>
                    <p class="text-muted mb-0">متابعة وإدارة عمليات الشراء من البداية إلى النهاية</p>
                </div>
                <div>
                    <a href="{{ route('procurement.workflow.orders') }}" class="btn btn-primary">
                        <i class="fas fa-list me-1"></i>
                        إدارة الأوامر
                    </a>
                    <a href="{{ route('procurement.workflow.inventory-optimization') }}" class="btn btn-success">
                        <i class="fas fa-chart-line me-1"></i>
                        تحسين المخزون
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- إحصائيات أوامر الشراء -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                أوامر معلقة الموافقة
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $stats['pending_orders'] }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                أوامر معتمدة
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $stats['approved_orders'] }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                أوامر مكتملة
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $stats['completed_orders'] }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-flag-checkered fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                فواتير معلقة
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $stats['pending_invoices'] }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-file-invoice-dollar fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- الرسوم البيانية -->
    <div class="row mb-4">
        <div class="col-xl-8 col-lg-7">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">الأداء الشهري للمشتريات</h6>
                </div>
                <div class="card-body">
                    <canvas id="monthlyPerfChart"></canvas>
                </div>
            </div>
        </div>

        <div class="col-xl-4 col-lg-5">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">توزيع أوامر الشراء</h6>
                </div>
                <div class="card-body">
                    <canvas id="orderStatusChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- الأوامر المعلقة والمتأخرة -->
    <div class="row">
        <div class="col-xl-6 mb-4">
            <div class="card shadow">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">أوامر معلقة الموافقة</h6>
                    <div>
                        <button type="button" class="btn btn-sm btn-success" onclick="bulkApprove()">
                            <i class="fas fa-check me-1"></i>
                            موافقة مجمعة
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>
                                        <input type="checkbox" id="selectAllPending">
                                    </th>
                                    <th>رقم الأمر</th>
                                    <th>المورد</th>
                                    <th>القيمة</th>
                                    <th>التاريخ</th>
                                    <th>الإجراء</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($pendingApprovalOrders as $order)
                                <tr>
                                    <td>
                                        <input type="checkbox" class="order-checkbox" value="{{ $order->id }}">
                                    </td>
                                    <td>
                                        <a href="{{ route('procurement.workflow.track-order', $order) }}">
                                            {{ $order->po_number }}
                                        </a>
                                    </td>
                                    <td>{{ $order->supplier->name }}</td>
                                    <td>
                                        <strong>{{ number_format($order->total_amount, 2) }}</strong> ر.س
                                    </td>
                                    <td>{{ $order->order_date->format('d/m/Y') }}</td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <button class="btn btn-outline-success" onclick="approveOrder({{ $order->id }})">
                                                <i class="fas fa-check"></i>
                                            </button>
                                            <a href="{{ route('purchase-orders.show', $order) }}" class="btn btn-outline-primary">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6" class="text-center text-muted py-4">
                                        لا توجد أوامر معلقة الموافقة
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-6 mb-4">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">أوامر متأخرة التسليم</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>رقم الأمر</th>
                                    <th>المورد</th>
                                    <th>القيمة</th>
                                    <th>متأخر بـ</th>
                                    <th>الإجراء</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($overdueOrders as $order)
                                <tr class="table-warning">
                                    <td>
                                        <a href="{{ route('procurement.workflow.track-order', $order) }}">
                                            {{ $order->po_number }}
                                        </a>
                                    </td>
                                    <td>{{ $order->supplier->name }}</td>
                                    <td>
                                        <strong>{{ number_format($order->total_amount, 2) }}</strong> ر.س
                                    </td>
                                    <td>
                                        <span class="badge badge-danger">
                                            {{ $order->expected_delivery_date->diffInDays(now()) }} يوم
                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <button class="btn btn-outline-warning" onclick="followUpOrder({{ $order->id }})">
                                                <i class="fas fa-phone"></i>
                                            </button>
                                            <a href="{{ route('purchase-orders.show', $order) }}" class="btn btn-outline-primary">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="5" class="text-center text-muted py-4">
                                        لا توجد أوامر متأخرة التسليم
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- إحصائيات استلام البضائع -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">حالة استلام البضائع</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4 text-center">
                            <div class="mb-3">
                                <i class="fas fa-truck fa-3x text-warning mb-2"></i>
                                <h4 class="font-weight-bold text-warning">{{ $stats['pending_receipts'] }}</h4>
                                <p class="text-muted mb-0">في انتظار الاستلام</p>
                            </div>
                        </div>
                        <div class="col-md-4 text-center">
                            <div class="mb-3">
                                <i class="fas fa-box-open fa-3x text-info mb-2"></i>
                                <h4 class="font-weight-bold text-info">{{ $stats['partial_receipts'] }}</h4>
                                <p class="text-muted mb-0">استلام جزئي</p>
                            </div>
                        </div>
                        <div class="col-md-4 text-center">
                            <div class="mb-3">
                                <i class="fas fa-check-circle fa-3x text-success mb-2"></i>
                                <h4 class="font-weight-bold text-success">{{ $stats['completed_receipts'] }}</h4>
                                <p class="text-muted mb-0">مكتمل الاستلام</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- روابط سريعة -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">الوصول السريع</h6>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-md-2 mb-3">
                            <a href="{{ route('purchase-orders.create') }}" class="btn btn-light btn-block">
                                <i class="fas fa-plus fa-2x mb-2"></i>
                                <br>
                                أمر شراء جديد
                            </a>
                        </div>
                        <div class="col-md-2 mb-3">
                            <a href="{{ route('procurement.workflow.supplier-performance') }}" class="btn btn-light btn-block">
                                <i class="fas fa-chart-bar fa-2x mb-2"></i>
                                <br>
                                أداء الموردين
                            </a>
                        </div>
                        <div class="col-md-2 mb-3">
                            <a href="{{ route('suppliers.debt.dashboard') }}" class="btn btn-light btn-block">
                                <i class="fas fa-money-check-alt fa-2x mb-2"></i>
                                <br>
                                إدارة المديونيات
                            </a>
                        </div>
                        <div class="col-md-2 mb-3">
                            <a href="{{ route('goods-receipts.index') }}" class="btn btn-light btn-block">
                                <i class="fas fa-warehouse fa-2x mb-2"></i>
                                <br>
                                استلام البضائع
                            </a>
                        </div>
                        <div class="col-md-2 mb-3">
                            <a href="{{ route('suppliers.analytics.dashboard') }}" class="btn btn-light btn-block">
                                <i class="fas fa-analytics fa-2x mb-2"></i>
                                <br>
                                تحليلات متقدمة
                            </a>
                        </div>
                        <div class="col-md-2 mb-3">
                            <a href="{{ route('purchase-invoices.index') }}" class="btn btn-light btn-block">
                                <i class="fas fa-file-invoice fa-2x mb-2"></i>
                                <br>
                                فواتير الشراء
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// رسم الأداء الشهري
const monthlyPerfCtx = document.getElementById('monthlyPerfChart').getContext('2d');
new Chart(monthlyPerfCtx, {
    type: 'bar',
    data: {
        labels: @json(array_keys($monthlyStats)),
        datasets: [
            {
                label: 'أوامر منشأة',
                data: @json(array_column(array_values($monthlyStats), 'orders_created')),
                backgroundColor: '#4e73df'
            },
            {
                label: 'أوامر مكتملة',
                data: @json(array_column(array_values($monthlyStats), 'orders_completed')),
                backgroundColor: '#1cc88a'
            }
        ]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

// رسم توزيع الأوامر
const orderStatusCtx = document.getElementById('orderStatusChart').getContext('2d');
new Chart(orderStatusCtx, {
    type: 'doughnut',
    data: {
        labels: ['مسودة', 'معلقة', 'معتمدة', 'مرسلة', 'مكتملة', 'ملغاة'],
        datasets: [{
            data: [
                {{ $orderStatusDistribution['draft'] }},
                {{ $orderStatusDistribution['pending'] }},
                {{ $orderStatusDistribution['approved'] }},
                {{ $orderStatusDistribution['sent'] }},
                {{ $orderStatusDistribution['completed'] }},
                {{ $orderStatusDistribution['cancelled'] }}
            ],
            backgroundColor: [
                '#6c757d',
                '#f6c23e',
                '#1cc88a',
                '#36b9cc',
                '#858796',
                '#e74a3b'
            ]
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: {
                position: 'bottom'
            }
        }
    }
});

// تحديد/إلغاء تحديد الكل
document.getElementById('selectAllPending').addEventListener('change', function() {
    const checkboxes = document.querySelectorAll('.order-checkbox');
    checkboxes.forEach(checkbox => {
        checkbox.checked = this.checked;
    });
});

// موافقة على أمر واحد
function approveOrder(orderId) {
    if (confirm('هل تريد الموافقة على هذا الأمر؟')) {
        fetch(`/procurement/workflow/bulk-approve-orders`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                order_ids: [orderId]
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('تمت الموافقة بنجاح');
                location.reload();
            }
        });
    }
}

// موافقة مجمعة
function bulkApprove() {
    const selectedOrders = Array.from(document.querySelectorAll('.order-checkbox:checked')).map(cb => cb.value);
    
    if (selectedOrders.length === 0) {
        alert('يرجى اختيار أمر واحد على الأقل');
        return;
    }
    
    if (confirm(`هل تريد الموافقة على ${selectedOrders.length} أمر؟`)) {
        fetch(`/procurement/workflow/bulk-approve-orders`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                order_ids: selectedOrders
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('تمت الموافقة بنجاح');
                location.reload();
            }
        });
    }
}

// متابعة أمر متأخر
function followUpOrder(orderId) {
    alert('سيتم تنفيذ ميزة المتابعة قريباً');
    // يمكن إضافة منطق إرسال إشعار أو إيميل للمورد
}
</script>
@endpush