@extends('layouts.app')

@section('title', 'تقارير المشتريات الشاملة')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-0 text-gray-800">
                        <i class="fas fa-chart-pie me-2"></i>
                        تقارير المشتريات الشاملة
                    </h1>
                    <p class="text-muted mb-0">تقارير متقدمة لإدارة المشتريات والموردين</p>
                </div>
            </div>
        </div>
    </div>

    <!-- بطاقات التقارير الرئيسية -->
    <div class="row">
        <!-- تقرير أداء الموردين -->
        <div class="col-xl-4 col-lg-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                تقرير أداء الموردين
                            </div>
                            <div class="text-xs text-gray-600 mb-3">
                                تحليل مفصل لأداء الموردين ومعدلات التسليم والجودة
                            </div>
                            <div class="d-grid gap-2">
                                <a href="{{ route('suppliers.analytics.performance') }}" class="btn btn-primary btn-sm">
                                    <i class="fas fa-chart-line me-1"></i>
                                    عرض التقرير
                                </a>
                                <button class="btn btn-outline-primary btn-sm" onclick="exportReport('supplier-performance')">
                                    <i class="fas fa-download me-1"></i>
                                    تصدير Excel
                                </button>
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-users fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- تقرير المديونيات -->
        <div class="col-xl-4 col-lg-6 mb-4">
            <div class="card border-left-danger shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                تقرير المديونيات
                            </div>
                            <div class="text-xs text-gray-600 mb-3">
                                تحليل أعمار الديون والمدفوعات المتأخرة والجدولة
                            </div>
                            <div class="d-grid gap-2">
                                <a href="{{ route('suppliers.debt.overdue-report') }}" class="btn btn-danger btn-sm">
                                    <i class="fas fa-exclamation-triangle me-1"></i>
                                    عرض التقرير
                                </a>
                                <button class="btn btn-outline-danger btn-sm" onclick="exportReport('debt-analysis')">
                                    <i class="fas fa-download me-1"></i>
                                    تصدير PDF
                                </button>
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-money-bill-wave fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- تقرير أوامر الشراء -->
        <div class="col-xl-4 col-lg-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                تقرير أوامر الشراء
                            </div>
                            <div class="text-xs text-gray-600 mb-3">
                                تحليل حالة أوامر الشراء والتسليم والإنجاز
                            </div>
                            <div class="d-grid gap-2">
                                <a href="{{ route('purchase-orders.index') }}" class="btn btn-success btn-sm">
                                    <i class="fas fa-shopping-cart me-1"></i>
                                    عرض التقرير
                                </a>
                                <button class="btn btn-outline-success btn-sm" onclick="exportReport('purchase-orders')">
                                    <i class="fas fa-download me-1"></i>
                                    تصدير Excel
                                </button>
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-shopping-cart fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- تقرير الائتمان -->
        <div class="col-xl-4 col-lg-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                تقرير مراقبة الائتمان
                            </div>
                            <div class="text-xs text-gray-600 mb-3">
                                مراقبة حدود الائتمان واستخدام الموردين للائتمان
                            </div>
                            <div class="d-grid gap-2">
                                <a href="{{ route('suppliers.analytics.credit-monitoring') }}" class="btn btn-warning btn-sm">
                                    <i class="fas fa-credit-card me-1"></i>
                                    عرض التقرير
                                </a>
                                <button class="btn btn-outline-warning btn-sm" onclick="exportReport('credit-monitoring')">
                                    <i class="fas fa-download me-1"></i>
                                    تصدير Excel
                                </button>
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-credit-card fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- تقرير المدفوعات -->
        <div class="col-xl-4 col-lg-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                تقرير المدفوعات
                            </div>
                            <div class="text-xs text-gray-600 mb-3">
                                تحليل المدفوعات للموردين وطرق الدفع المختلفة
                            </div>
                            <div class="d-grid gap-2">
                                <a href="{{ route('suppliers.payments.index') }}" class="btn btn-info btn-sm">
                                    <i class="fas fa-hand-holding-usd me-1"></i>
                                    عرض التقرير
                                </a>
                                <button class="btn btn-outline-info btn-sm" onclick="exportReport('payments-analysis')">
                                    <i class="fas fa-download me-1"></i>
                                    تصدير PDF
                                </button>
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-hand-holding-usd fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- تقرير المقارنة -->
        <div class="col-xl-4 col-lg-6 mb-4">
            <div class="card border-left-secondary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-secondary text-uppercase mb-1">
                                تقرير المقارنة
                            </div>
                            <div class="text-xs text-gray-600 mb-3">
                                مقارنة شاملة بين الموردين والأسعار والأداء
                            </div>
                            <div class="d-grid gap-2">
                                <a href="{{ route('suppliers.analytics.comparison') }}" class="btn btn-secondary btn-sm">
                                    <i class="fas fa-balance-scale me-1"></i>
                                    عرض التقرير
                                </a>
                                <button class="btn btn-outline-secondary btn-sm" onclick="exportReport('supplier-comparison')">
                                    <i class="fas fa-download me-1"></i>
                                    تصدير Excel
                                </button>
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-balance-scale fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- تقارير مخصصة -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-cog me-2"></i>
                        إنشاء تقرير مخصص
                    </h6>
                </div>
                <div class="card-body">
                    <form id="customReportForm" class="row g-3">
                        <div class="col-md-3">
                            <label class="form-label">نوع التقرير</label>
                            <select class="form-select" name="report_type" id="report_type">
                                <option value="">اختر نوع التقرير...</option>
                                <option value="supplier_performance">أداء الموردين</option>
                                <option value="purchase_analysis">تحليل المشتريات</option>
                                <option value="payment_analysis">تحليل المدفوعات</option>
                                <option value="debt_aging">أعمار الديون</option>
                                <option value="credit_utilization">استخدام الائتمان</option>
                                <option value="delivery_performance">أداء التسليم</option>
                            </select>
                        </div>

                        <div class="col-md-2">
                            <label class="form-label">من تاريخ</label>
                            <input type="date" class="form-control" name="date_from" value="{{ date('Y-m-01') }}">
                        </div>

                        <div class="col-md-2">
                            <label class="form-label">إلى تاريخ</label>
                            <input type="date" class="form-control" name="date_to" value="{{ date('Y-m-d') }}">
                        </div>

                        <div class="col-md-2">
                            <label class="form-label">تنسيق التصدير</label>
                            <select class="form-select" name="export_format">
                                <option value="excel">Excel</option>
                                <option value="pdf">PDF</option>
                                <option value="csv">CSV</option>
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label class="form-label">&nbsp;</label>
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-file-export me-1"></i>
                                    إنشاء وتصدير
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- إحصائيات سريعة -->
    <div class="row">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                إجمالي الموردين النشطين
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ \App\Models\Supplier::active()->count() }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-users fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                أوامر الشراء هذا الشهر
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ \App\Models\PurchaseOrder::whereMonth('created_at', date('m'))->count() }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-shopping-cart fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                قيمة المشتريات الشهرية
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ number_format(\App\Models\PurchaseInvoice::whereMonth('created_at', date('m'))->sum('total_amount'), 0) }} ر.س
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                إجمالي المديونيات
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ number_format(\App\Models\Supplier::sum('current_balance'), 0) }} ر.س
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-exclamation-triangle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- التقارير المجدولة -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-clock me-2"></i>
                        التقارير المجدولة
                    </h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th>نوع التقرير</th>
                                    <th>التكرار</th>
                                    <th>آخر تشغيل</th>
                                    <th>التشغيل القادم</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>تقرير أداء الموردين الشهري</td>
                                    <td>شهرياً</td>
                                    <td>{{ date('d/m/Y', strtotime('first day of this month')) }}</td>
                                    <td>{{ date('d/m/Y', strtotime('first day of next month')) }}</td>
                                    <td><span class="badge badge-success">نشط</span></td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary" onclick="runScheduledReport('supplier_performance')">
                                            <i class="fas fa-play"></i> تشغيل الآن
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>تقرير المديونيات الأسبوعي</td>
                                    <td>أسبوعياً</td>
                                    <td>{{ date('d/m/Y', strtotime('last monday')) }}</td>
                                    <td>{{ date('d/m/Y', strtotime('next monday')) }}</td>
                                    <td><span class="badge badge-success">نشط</span></td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary" onclick="runScheduledReport('debt_analysis')">
                                            <i class="fas fa-play"></i> تشغيل الآن
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>تقرير مراقبة الائتمان اليومي</td>
                                    <td>يومياً</td>
                                    <td>{{ date('d/m/Y') }}</td>
                                    <td>{{ date('d/m/Y', strtotime('+1 day')) }}</td>
                                    <td><span class="badge badge-success">نشط</span></td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary" onclick="runScheduledReport('credit_monitoring')">
                                            <i class="fas fa-play"></i> تشغيل الآن
                                        </button>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// تصدير التقارير
function exportReport(reportType) {
    const form = document.createElement('form');
    form.method = 'POST';
    form.action = '/procurement/reports/export';
    
    const csrfToken = document.createElement('input');
    csrfToken.type = 'hidden';
    csrfToken.name = '_token';
    csrfToken.value = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
    
    const reportTypeInput = document.createElement('input');
    reportTypeInput.type = 'hidden';
    reportTypeInput.name = 'report_type';
    reportTypeInput.value = reportType;
    
    form.appendChild(csrfToken);
    form.appendChild(reportTypeInput);
    
    document.body.appendChild(form);
    form.submit();
    document.body.removeChild(form);
}

// تشغيل التقرير المجدول
function runScheduledReport(reportType) {
    if (confirm('هل تريد تشغيل هذا التقرير الآن؟')) {
        fetch('/procurement/reports/run-scheduled', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                report_type: reportType
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('تم تشغيل التقرير بنجاح');
            } else {
                alert('حدث خطأ في تشغيل التقرير');
            }
        });
    }
}

// نموذج التقرير المخصص
document.getElementById('customReportForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const reportType = formData.get('report_type');
    
    if (!reportType) {
        alert('يرجى اختيار نوع التقرير');
        return;
    }
    
    // إنشاء رابط التصدير
    const params = new URLSearchParams();
    for (let [key, value] of formData) {
        params.append(key, value);
    }
    
    window.open(`/procurement/reports/custom-export?${params.toString()}`, '_blank');
});
</script>
@endpush