@extends('layouts.app')

@section('title', 'عرض سند الصرف - ' . $paymentVoucher->voucher_number)

@section('content')
<div class="container-fluid">
    <!-- Header Section -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">سند الصرف - {{ $paymentVoucher->voucher_number }}</h1>
        <div class="btn-group">
            <a href="{{ route('payment-vouchers.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> العودة للقائمة
            </a>
            @if($paymentVoucher->status !== 'cancelled')
                <a href="{{ route('payment-vouchers.edit', $paymentVoucher) }}" class="btn btn-warning">
                    <i class="fas fa-edit"></i> تحرير
                </a>
            @endif
            <a href="{{ route('payment-vouchers.print', $paymentVoucher) }}" class="btn btn-info" target="_blank">
                <i class="fas fa-print"></i> طباعة
            </a>
        </div>
    </div>

    <div class="row">
        <!-- معلومات السند -->
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex justify-content-between align-items-center">
                    <h6 class="m-0 font-weight-bold text-primary">تفاصيل سند الصرف</h6>
                    <span class="badge badge-{{ $paymentVoucher->getStatusColor() }} badge-lg">
                        {{ $paymentVoucher->getStatusText() }}
                    </span>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td class="font-weight-bold">رقم السند:</td>
                                    <td>{{ $paymentVoucher->voucher_number }}</td>
                                </tr>
                                <tr>
                                    <td class="font-weight-bold">الشركة:</td>
                                    <td>{{ $paymentVoucher->company->name }}</td>
                                </tr>
                                <tr>
                                    <td class="font-weight-bold">المورد/المستفيد:</td>
                                    <td>
                                        @if($paymentVoucher->supplier)
                                            <a href="{{ route('customers.show', $paymentVoucher->supplier) }}" class="text-primary">
                                                {{ $paymentVoucher->supplier->name }}
                                            </a>
                                        @else
                                            {{ $paymentVoucher->supplier_name }}
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td class="font-weight-bold">تاريخ الدفع:</td>
                                    <td>{{ $paymentVoucher->payment_date->format('Y-m-d H:i') }}</td>
                                </tr>
                                <tr>
                                    <td class="font-weight-bold">المبلغ:</td>
                                    <td class="h5 text-danger">{{ number_format($paymentVoucher->amount, 2) }} ر.س</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td class="font-weight-bold">طريقة الدفع:</td>
                                    <td>{{ $paymentVoucher->getPaymentMethodText() }}</td>
                                </tr>
                                <tr>
                                    <td class="font-weight-bold">الرقم المرجعي:</td>
                                    <td>{{ $paymentVoucher->reference_number ?: 'غير محدد' }}</td>
                                </tr>
                                <tr>
                                    <td class="font-weight-bold">رمز الحساب:</td>
                                    <td>{{ $paymentVoucher->account_code ?: 'غير محدد' }}</td>
                                </tr>
                                <tr>
                                    <td class="font-weight-bold">المستخدم:</td>
                                    <td>{{ $paymentVoucher->user->name }}</td>
                                </tr>
                                <tr>
                                    <td class="font-weight-bold">تاريخ الإنشاء:</td>
                                    <td>{{ $paymentVoucher->created_at->format('Y-m-d H:i') }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <!-- معلومات إضافية -->
                    @if($paymentVoucher->beneficiary_name || $paymentVoucher->beneficiary_account || $paymentVoucher->invoice_reference)
                    <div class="row">
                        <div class="col-md-12">
                            <hr>
                            <h6 class="font-weight-bold">معلومات إضافية:</h6>
                            <div class="row">
                                @if($paymentVoucher->beneficiary_name)
                                <div class="col-md-4">
                                    <strong>اسم المستفيد:</strong><br>
                                    {{ $paymentVoucher->beneficiary_name }}
                                </div>
                                @endif
                                @if($paymentVoucher->beneficiary_account)
                                <div class="col-md-4">
                                    <strong>رقم حساب المستفيد:</strong><br>
                                    {{ $paymentVoucher->beneficiary_account }}
                                </div>
                                @endif
                                @if($paymentVoucher->invoice_reference)
                                <div class="col-md-4">
                                    <strong>مرجع الفاتورة:</strong><br>
                                    {{ $paymentVoucher->invoice_reference }}
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    @endif

                    <div class="row">
                        <div class="col-md-12">
                            <hr>
                            <h6 class="font-weight-bold">الوصف:</h6>
                            <p class="text-gray-800">{{ $paymentVoucher->description }}</p>

                            @if($paymentVoucher->notes)
                                <h6 class="font-weight-bold">الملاحظات:</h6>
                                <p class="text-gray-600">{{ $paymentVoucher->notes }}</p>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- معلومات إضافية -->
        <div class="col-lg-4">
            <!-- معلومات المورد -->
            @if($paymentVoucher->supplier)
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">معلومات المورد</h6>
                    </div>
                    <div class="card-body">
                        @php
                            $supplier = $paymentVoucher->supplier;
                            $supplierPayments = $supplier->paymentVouchers()->active()->get();
                            $totalPaid = $supplierPayments->sum('amount');
                            $paymentCount = $supplierPayments->count();
                        @endphp
                        <div class="text-center">
                            <i class="fas fa-truck fa-2x text-info mb-3"></i>
                            <h6>{{ $supplier->name }}</h6>
                            <p class="text-muted mb-2">{{ $supplier->email ?: 'لا يوجد بريد إلكتروني' }}</p>
                            <hr>
                            <div class="row">
                                <div class="col-6">
                                    <p class="mb-1">
                                        <strong>إجمالي المدفوع:</strong><br>
                                        <span class="text-danger">{{ number_format($totalPaid, 2) }} ر.س</span>
                                    </p>
                                </div>
                                <div class="col-6">
                                    <p class="mb-1">
                                        <strong>عدد السندات:</strong><br>
                                        <span class="text-info">{{ $paymentCount }}</span>
                                    </p>
                                </div>
                            </div>
                            <a href="{{ route('customers.show', $supplier) }}" class="btn btn-sm btn-info mt-2">
                                <i class="fas fa-eye"></i> ملف المورد
                            </a>
                        </div>
                    </div>
                </div>
            @else
                <!-- معلومات المورد غير المسجل -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">معلومات المورد</h6>
                    </div>
                    <div class="card-body">
                        <div class="text-center">
                            <i class="fas fa-user fa-2x text-secondary mb-3"></i>
                            <h6>{{ $paymentVoucher->supplier_name }}</h6>
                            <p class="text-muted mb-2">مورد غير مسجل</p>
                            
                            @if($paymentVoucher->beneficiary_name && $paymentVoucher->beneficiary_name !== $paymentVoucher->supplier_name)
                                <hr>
                                <p class="mb-1">
                                    <strong>المستفيد الفعلي:</strong><br>
                                    {{ $paymentVoucher->beneficiary_name }}
                                </p>
                            @endif
                        </div>
                    </div>
                </div>
            @endif

            <!-- إحصائيات الشركة -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">إحصائيات الشركة</h6>
                </div>
                <div class="card-body">
                    @php
                        $company = $paymentVoucher->company;
                        $companyPayments = $company->paymentVouchers()->active()->get();
                        $totalCompanyPayments = $companyPayments->sum('amount');
                        $companyPaymentCount = $companyPayments->count();
                    @endphp
                    <div class="text-center">
                        <i class="fas fa-building fa-2x text-primary mb-3"></i>
                        <h6>{{ $company->name }}</h6>
                        <hr>
                        <div class="row">
                            <div class="col-6">
                                <p class="mb-1">
                                    <strong>إجمالي المصروفات:</strong><br>
                                    <span class="text-danger">{{ number_format($totalCompanyPayments, 2) }} ر.س</span>
                                </p>
                            </div>
                            <div class="col-6">
                                <p class="mb-1">
                                    <strong>عدد السندات:</strong><br>
                                    <span class="text-info">{{ $companyPaymentCount }}</span>
                                </p>
                            </div>
                        </div>
                        <a href="{{ route('companies.show', $company) }}" class="btn btn-sm btn-primary mt-2">
                            <i class="fas fa-eye"></i> ملف الشركة
                        </a>
                    </div>
                </div>
            </div>

            <!-- إجراءات سريعة -->
            @if($paymentVoucher->status !== 'cancelled')
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">إجراءات سريعة</h6>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <a href="{{ route('payment-vouchers.edit', $paymentVoucher) }}" class="btn btn-warning btn-sm">
                                <i class="fas fa-edit"></i> تحرير السند
                            </a>
                            
                            <a href="{{ route('payment-vouchers.print', $paymentVoucher) }}" class="btn btn-info btn-sm" target="_blank">
                                <i class="fas fa-print"></i> طباعة السند
                            </a>
                            
                            <hr>
                            
                            <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#cancelModal">
                                <i class="fas fa-times"></i> إلغاء السند
                            </button>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Modal إلغاء السند -->
@if($paymentVoucher->status !== 'cancelled')
<div class="modal fade" id="cancelModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">تأكيد إلغاء السند</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>هل أنت متأكد من إلغاء سند الصرف <strong>{{ $paymentVoucher->voucher_number }}</strong>؟</p>
                <p class="text-danger"><strong>تحذير:</strong> هذا الإجراء لا يمكن التراجع عنه.</p>
            </div>
            <div class="modal-footer">
                <form action="{{ route('payment-vouchers.destroy', $paymentVoucher) }}" method="POST">
                    @csrf
                    @method('DELETE')
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-danger">تأكيد الإلغاء</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endif
@endsection