@extends('layouts.app')

@section('title', 'إنشاء سند صرف جديد')

@section('content')
<div class="container-fluid">
    <!-- Header Section -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">إنشاء سند صرف جديد</h1>
        <a href="{{ route('payment-vouchers.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> العودة للقائمة
        </a>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">بيانات سند الصرف</h6>
                </div>
                <div class="card-body">
                    <form action="{{ route('payment-vouchers.store') }}" method="POST">
                        @csrf
                        
                        <div class="row">
                            <!-- الشركة -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="company_id" class="form-label">الشركة <span class="text-danger">*</span></label>
                                    <select name="company_id" id="company_id" class="form-control @error('company_id') is-invalid @enderror" required>
                                        <option value="">اختر الشركة</option>
                                        @foreach($companies as $company)
                                            <option value="{{ $company->id }}" {{ old('company_id') == $company->id ? 'selected' : '' }}>
                                                {{ $company->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('company_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- المورد -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="supplier_selection" class="form-label">نوع المورد <span class="text-danger">*</span></label>
                                    <select id="supplier_selection" class="form-control" onchange="toggleSupplierFields()">
                                        <option value="">اختر نوع المورد</option>
                                        <option value="existing" {{ old('supplier_id') ? 'selected' : '' }}>مورد مسجل</option>
                                        <option value="new" {{ old('supplier_name') && !old('supplier_id') ? 'selected' : '' }}>مورد جديد</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- المورد المسجل -->
                            <div class="col-md-6" id="existing_supplier_field" style="display: none;">
                                <div class="form-group">
                                    <label for="supplier_id" class="form-label">المورد المسجل</label>
                                    <select name="supplier_id" id="supplier_id" class="form-control select2-supplier @error('supplier_id') is-invalid @enderror">
                                        <option value="">ابحث عن المورد...</option>
                                        @foreach($suppliers as $supplier)
                                            <option value="{{ $supplier->id }}" {{ old('supplier_id') == $supplier->id ? 'selected' : '' }}>
                                                {{ $supplier->name }} - {{ $supplier->email ?? 'لا يوجد بريد' }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('supplier_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- اسم المورد الجديد -->
                            <div class="col-md-6" id="new_supplier_field" style="display: none;">
                                <div class="form-group">
                                    <label for="supplier_name" class="form-label">اسم المورد/المستفيد</label>
                                    <input type="text" name="supplier_name" id="supplier_name" 
                                           class="form-control @error('supplier_name') is-invalid @enderror" 
                                           value="{{ old('supplier_name') }}" placeholder="اسم المورد أو المستفيد">
                                    @error('supplier_name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- اسم المستفيد -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="beneficiary_name" class="form-label">اسم المستفيد (اختياري)</label>
                                    <input type="text" name="beneficiary_name" id="beneficiary_name" 
                                           class="form-control @error('beneficiary_name') is-invalid @enderror" 
                                           value="{{ old('beneficiary_name') }}" placeholder="اسم المستفيد إذا كان مختلف عن المورد">
                                    @error('beneficiary_name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- تاريخ الدفع -->
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="payment_date" class="form-label">تاريخ الدفع <span class="text-danger">*</span></label>
                                    <input type="datetime-local" name="payment_date" id="payment_date" 
                                           class="form-control @error('payment_date') is-invalid @enderror" 
                                           value="{{ old('payment_date', now()->format('Y-m-d\TH:i')) }}" required>
                                    @error('payment_date')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- المبلغ -->
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="amount" class="form-label">المبلغ (ر.س) <span class="text-danger">*</span></label>
                                    <input type="number" name="amount" id="amount" step="0.01" min="0.01"
                                           class="form-control @error('amount') is-invalid @enderror" 
                                           value="{{ old('amount') }}" required>
                                    @error('amount')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- طريقة الدفع -->
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="payment_method" class="form-label">طريقة الدفع <span class="text-danger">*</span></label>
                                    <select name="payment_method" id="payment_method" class="form-control @error('payment_method') is-invalid @enderror" required>
                                        <option value="">اختر طريقة الدفع</option>
                                        <option value="cash" {{ old('payment_method') == 'cash' ? 'selected' : '' }}>نقداً</option>
                                        <option value="bank_transfer" {{ old('payment_method') == 'bank_transfer' ? 'selected' : '' }}>تحويل بنكي</option>
                                        <option value="check" {{ old('payment_method') == 'check' ? 'selected' : '' }}>شيك</option>
                                        <option value="credit_card" {{ old('payment_method') == 'credit_card' ? 'selected' : '' }}>بطاقة ائتمان</option>
                                        <option value="online_transfer" {{ old('payment_method') == 'online_transfer' ? 'selected' : '' }}>تحويل إلكتروني</option>
                                        <option value="other" {{ old('payment_method') == 'other' ? 'selected' : '' }}>أخرى</option>
                                    </select>
                                    @error('payment_method')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- الرقم المرجعي -->
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="reference_number" class="form-label">الرقم المرجعي</label>
                                    <input type="text" name="reference_number" id="reference_number" 
                                           class="form-control @error('reference_number') is-invalid @enderror" 
                                           value="{{ old('reference_number') }}" placeholder="رقم الشيك، رقم التحويل، إلخ">
                                    @error('reference_number')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- رقم الحساب المستفيد -->
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="beneficiary_account" class="form-label">رقم حساب المستفيد</label>
                                    <input type="text" name="beneficiary_account" id="beneficiary_account" 
                                           class="form-control @error('beneficiary_account') is-invalid @enderror" 
                                           value="{{ old('beneficiary_account') }}" placeholder="رقم الحساب البنكي للمستفيد">
                                    @error('beneficiary_account')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- رمز الحساب -->
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="account_code" class="form-label">رمز الحساب</label>
                                    <input type="text" name="account_code" id="account_code" 
                                           class="form-control @error('account_code') is-invalid @enderror" 
                                           value="{{ old('account_code') }}" placeholder="رمز الحساب المحاسبي">
                                    @error('account_code')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- مرجع الفاتورة -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="invoice_reference" class="form-label">مرجع الفاتورة (اختياري)</label>
                                    <input type="text" name="invoice_reference" id="invoice_reference" 
                                           class="form-control @error('invoice_reference') is-invalid @enderror" 
                                           value="{{ old('invoice_reference') }}" placeholder="رقم فاتورة المورد أو المرجع">
                                    @error('invoice_reference')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- الحالة -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="status" class="form-label">الحالة <span class="text-danger">*</span></label>
                                    <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                                        <option value="active" {{ old('status', 'active') == 'active' ? 'selected' : '' }}>نشط</option>
                                        <option value="pending" {{ old('status') == 'pending' ? 'selected' : '' }}>معلق</option>
                                    </select>
                                    @error('status')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- الوصف -->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="description" class="form-label">الوصف <span class="text-danger">*</span></label>
                                    <input type="text" name="description" id="description" 
                                           class="form-control @error('description') is-invalid @enderror" 
                                           value="{{ old('description') }}" required 
                                           placeholder="وصف مختصر لسند الصرف">
                                    @error('description')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- الملاحظات -->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="notes" class="form-label">ملاحظات</label>
                                    <textarea name="notes" id="notes" rows="3" 
                                              class="form-control @error('notes') is-invalid @enderror" 
                                              placeholder="ملاحظات إضافية">{{ old('notes') }}</textarea>
                                    @error('notes')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- أزرار الإجراءات -->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save"></i> حفظ سند الصرف
                                    </button>
                                    <a href="{{ route('payment-vouchers.index') }}" class="btn btn-secondary ml-2">
                                        <i class="fas fa-times"></i> إلغاء
                                    </a>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<!-- Select2 CSS -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />
@endpush

@push('scripts')
<!-- Select2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
$(document).ready(function() {
    // تفعيل Select2 للموردين
    $('.select2-supplier').select2({
        theme: 'bootstrap-5',
        placeholder: 'ابحث عن المورد...',
        allowClear: true,
        width: '100%',
        language: {
            noResults: function() {
                return "لا توجد نتائج";
            },
            searching: function() {
                return "جاري البحث...";
            }
        }
    });
    
    // عرض الحقول المناسبة حسب النوع المحدد
    toggleSupplierFields();
    
    // تحديث الوصف تلقائياً حسب طريقة الدفع
    $('#payment_method').change(function() {
        var method = $(this).val();
        var description = $('#description');
        
        if (!description.val()) {
            var methodTexts = {
                'cash': 'دفع نقدي للمورد',
                'bank_transfer': 'تحويل بنكي للمورد',
                'check': 'دفع بالشيك للمورد',
                'credit_card': 'دفع بالبطاقة الائتمانية',
                'online_transfer': 'تحويل إلكتروني للمورد',
                'other': 'دفع للمورد'
            };
            
            if (methodTexts[method]) {
                description.val(methodTexts[method]);
            }
        }
    });
});

function toggleSupplierFields() {
    var selection = $('#supplier_selection').val();
    var existingField = $('#existing_supplier_field');
    var newField = $('#new_supplier_field');
    var supplierIdInput = $('#supplier_id');
    var supplierNameInput = $('#supplier_name');
    
    if (selection === 'existing') {
        existingField.show();
        newField.hide();
        supplierIdInput.prop('required', true);
        supplierNameInput.prop('required', false);
        
        // تفعيل Select2 عند إظهار الحقل
        $('.select2-supplier').select2({
            theme: 'bootstrap-5',
            placeholder: 'ابحث عن المورد...',
            allowClear: true,
            width: '100%',
            language: {
                noResults: function() {
                    return "لا توجد نتائج";
                },
                searching: function() {
                    return "جاري البحث...";
                }
            }
        });
    } else if (selection === 'new') {
        existingField.hide();
        newField.show();
        supplierIdInput.prop('required', false);
        supplierNameInput.prop('required', true);
    } else {
        existingField.hide();
        newField.hide();
        supplierIdInput.prop('required', false);
        supplierNameInput.prop('required', false);
    }
}
</script>
@endpush
@endsection