<!DOCTYPE html>
<html lang="ar" dir="rtl" data-theme="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="color-scheme" content="light dark">
    <title>@yield('title', 'نظام المبيعات - ZATCA')</title>
    
    <!-- Modern CSS Loading -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        /* ========== Modern CSS Variables ========== */
        :root {
            /* Clean Color Palette */
            --primary-600: #2563eb;
            --primary-700: #1d4ed8;
            --primary-500: #3b82f6;
            --primary-400: #60a5fa;
            
            /* Semantic Colors */
            --success-50: #f0fdf4;
            --success-500: #22c55e;
            --success-600: #16a34a;
            --warning-50: #fffbeb;
            --warning-500: #f59e0b;
            --warning-600: #d97706;
            --danger-50: #fef2f2;
            --danger-500: #ef4444;
            --danger-600: #dc2626;

            /* Clean Neutral Colors */
            --gray-50: #f8fafc;
            --gray-100: #f1f5f9;
            --gray-200: #e2e8f0;
            --gray-300: #cbd5e1;
            --gray-400: #94a3b8;
            --gray-500: #64748b;
            --gray-600: #475569;
            --gray-700: #334155;
            --gray-800: #1e293b;
            --gray-900: #0f172a;

            /* Clean Gradients */
            --gradient-primary: linear-gradient(135deg, var(--primary-600) 0%, var(--primary-700) 100%);
            --gradient-dark: linear-gradient(135deg, var(--gray-800) 0%, var(--gray-900) 100%);

            /* Layout System */
            --sidebar-width: 280px;
            --navbar-height: 70px;
            --content-padding: 1.5rem;

            /* Border Radius */
            --radius-sm: 6px;
            --radius-md: 10px;
            --radius-lg: 14px;
            --radius-xl: 20px;

            /* Shadow System */
            --shadow-sm: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px -1px rgba(0, 0, 0, 0.1);
            --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -2px rgba(0, 0, 0, 0.1);
            --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -4px rgba(0, 0, 0, 0.1);
            --shadow-xl: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 8px 10px -6px rgba(0, 0, 0, 0.1);

            /* Animation System */
            --duration-200: 200ms;
            --duration-300: 300ms;
            --ease-out: cubic-bezier(0, 0, 0.2, 1);

            /* Typography */
            --font-family: 'Cairo', -apple-system, BlinkMacSystemFont, 'Segoe UI', system-ui, sans-serif;
            --text-xs: 0.75rem;
            --text-sm: 0.875rem;
            --text-base: 1rem;
            --text-lg: 1.125rem;
            --text-xl: 1.25rem;
            --text-2xl: 1.5rem;
        }

        /* Dark Theme */
        [data-theme="dark"] {
            --gray-50: #0f172a;
            --gray-100: #1e293b;
            --gray-200: #334155;
            --gray-300: #475569;
            --gray-400: #64748b;
            --gray-500: #94a3b8;
            --gray-600: #cbd5e1;
            --gray-700: #e2e8f0;
            --gray-800: #f1f5f9;
            --gray-900: #f8fafc;
        }

        [data-theme="dark"] body {
            background: var(--gray-50);
            color: var(--gray-800);
        }

        [data-theme="dark"] .sidebar {
            background: var(--gradient-dark);
        }

        [data-theme="dark"] .top-navbar {
            background: rgba(30, 41, 59, 0.95);
            border-bottom-color: var(--gray-200);
        }

        /* Global Reset */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        html {
            scroll-behavior: smooth;
            height: 100%;
        }

        body {
            font-family: var(--font-family);
            font-size: var(--text-base);
            line-height: 1.6;
            color: var(--gray-800);
            background: var(--gray-50);
            min-height: 100vh;
            text-rendering: optimizeLegibility;
            -webkit-font-smoothing: antialiased;
        }

        /* ========== Clean Professional Sidebar ========== */
        .sidebar {
            display: none !important;
        }

        .sidebar-scrollable {
            height: 100%;
            overflow-y: auto;
            overflow-x: hidden;
            scrollbar-width: thin;
            scrollbar-color: rgba(255, 255, 255, 0.3) transparent;
            display: flex;
            flex-direction: column;
        }

        .sidebar-scrollable::-webkit-scrollbar {
            width: 3px;
        }

        .sidebar-scrollable::-webkit-scrollbar-track {
            background: transparent;
        }

        .sidebar-scrollable::-webkit-scrollbar-thumb {
            background: rgba(255, 255, 255, 0.2);
            border-radius: 2px;
        }

        /* Clean Sidebar Header */
        .sidebar-header {
            padding: 1.5rem;
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            text-align: center;
            position: relative;
            flex-shrink: 0;
        }

        .sidebar-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 2px;
            background: var(--gradient-primary);
        }

        .sidebar-logo {
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 0.75rem;
        }

        .sidebar-logo .logo-icon {
            width: 48px;
            height: 48px;
            background: var(--gradient-primary);
            border-radius: var(--radius-lg);
            display: flex;
            align-items: center;
            justify-content: center;
            margin-left: 12px;
            box-shadow: var(--shadow-lg);
        }

        .sidebar-logo .logo-icon i {
            color: white;
            font-size: 1.5rem;
        }

        .sidebar-logo .logo-text {
            color: white;
            font-size: var(--text-xl);
            font-weight: 700;
            letter-spacing: -0.02em;
        }

        .sidebar-subtitle {
            color: rgba(255, 255, 255, 0.7);
            font-size: var(--text-sm);
            font-weight: 500;
            margin: 0;
            padding: 0.5rem 0.75rem;
            background: rgba(255, 255, 255, 0.08);
            border-radius: var(--radius-md);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        /* Simplified Navigation */
        .sidebar-nav {
            padding: 1rem 0;
            flex: 1;
            overflow-y: auto;
        }

        .nav-section {
            margin-bottom: 1.5rem;
        }

        .nav-section:last-child {
            margin-bottom: 0;
        }

        .nav-section-title {
            color: rgba(255, 255, 255, 0.5);
            font-size: var(--text-xs);
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            padding: 0 1.25rem 0.5rem;
            margin-bottom: 0.5rem;
        }

        .nav-item {
            margin: 1px 0.75rem;
        }

        .nav-link {
            display: flex;
            align-items: center;
            padding: 0.75rem 1rem;
            color: rgba(255, 255, 255, 0.85);
            text-decoration: none;
            border-radius: var(--radius-md);
            font-weight: 500;
            font-size: var(--text-sm);
            transition: all var(--duration-200) var(--ease-out);
            border: 1px solid transparent;
        }

        .nav-link:hover,
        .nav-link.active {
            color: white;
            background: rgba(255, 255, 255, 0.1);
            transform: translateX(-3px);
            border-color: rgba(255, 255, 255, 0.15);
        }

        .nav-link.active {
            background: var(--gradient-primary);
            box-shadow: var(--shadow-md);
        }

        .nav-link-icon {
            width: 18px;
            height: 18px;
            margin-left: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: transform var(--duration-200) var(--ease-out);
        }

        .nav-link:hover .nav-link-icon,
        .nav-link.active .nav-link-icon {
            transform: scale(1.1);
        }

        /* Clean Dropdown Styles */
        .nav-dropdown {
            position: relative;
        }

        .nav-dropdown-toggle::after {
            content: '\f107';
            font-family: 'Font Awesome 6 Free';
            font-weight: 900;
            margin-right: auto;
            transition: transform var(--duration-200) var(--ease-out);
            font-size: 0.7rem;
            opacity: 0.7;
        }

        .nav-dropdown.show .nav-dropdown-toggle::after {
            transform: rotate(180deg);
        }

        .nav-dropdown-menu {
            max-height: 0;
            overflow: hidden;
            background: rgba(0, 0, 0, 0.15);
            backdrop-filter: blur(10px);
            border-radius: var(--radius-md);
            margin: 0.25rem 0;
            transition: all var(--duration-300) ease;
            border: 1px solid rgba(255, 255, 255, 0.05);
        }

        .nav-dropdown.show .nav-dropdown-menu {
            max-height: 400px;
            padding: 0.5rem 0;
        }

        .nav-dropdown-item {
            display: flex;
            align-items: center;
            padding: 0.625rem 0.75rem 0.625rem 2.5rem;
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
            font-weight: 400;
            font-size: var(--text-sm);
            transition: all var(--duration-200) var(--ease-out);
            border-radius: var(--radius-sm);
            margin: 1px 0.5rem;
            position: relative;
        }

        .nav-dropdown-item::before {
            content: '';
            position: absolute;
            right: 1.75rem;
            top: 50%;
            transform: translateY(-50%);
            width: 3px;
            height: 3px;
            background: rgba(255, 255, 255, 0.4);
            border-radius: 50%;
            transition: all var(--duration-200) var(--ease-out);
        }

        .nav-dropdown-item:hover,
        .nav-dropdown-item.active {
            color: white;
            background: rgba(255, 255, 255, 0.1);
            transform: translateX(-2px);
        }

        .nav-dropdown-item:hover::before,
        .nav-dropdown-item.active::before {
            background: var(--primary-400);
            transform: translateY(-50%) scale(1.3);
        }

        .nav-dropdown-item.active {
            background: var(--gradient-primary);
        }

        .nav-dropdown-item i {
            width: 14px;
            margin-left: 8px;
            font-size: 0.8rem;
        }

        /* Clean Navigation Divider */
        .nav-divider {
            height: 1px;
            background: rgba(255, 255, 255, 0.1);
            margin: 0.75rem 1rem;
            position: relative;
        }

        .nav-divider::before {
            content: '';
            position: absolute;
            left: 50%;
            top: 0;
            transform: translateX(-50%);
            width: 30px;
            height: 1px;
            background: var(--gradient-primary);
        }

        /* Clean User Section */
        .user-section {
            padding: 1rem;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            flex-shrink: 0;
        }

        .user-info {
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
            border-radius: var(--radius-lg);
            padding: 1rem;
            text-align: center;
            border: 1px solid rgba(255, 255, 255, 0.1);
            position: relative;
        }

        .user-info::before {
            content: '';
            position: absolute;
            top: -1px;
            left: -1px;
            right: -1px;
            height: 2px;
            background: var(--gradient-primary);
            border-radius: var(--radius-lg) var(--radius-lg) 0 0;
        }

        .user-avatar {
            width: 40px;
            height: 40px;
            background: var(--gradient-primary);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 0.5rem;
            box-shadow: var(--shadow-md);
        }

        .user-avatar i {
            color: white;
            font-size: 1.1rem;
        }

        .user-greeting {
            color: rgba(255, 255, 255, 0.6);
            font-size: var(--text-xs);
            margin-bottom: 0.25rem;
        }

        .user-name {
            color: white;
            font-weight: 600;
            font-size: var(--text-base);
            margin-bottom: 0.25rem;
        }

        .user-role {
            color: rgba(255, 255, 255, 0.7);
            font-size: var(--text-xs);
            background: rgba(255, 255, 255, 0.1);
            padding: 0.25rem 0.5rem;
            border-radius: var(--radius-sm);
            display: inline-block;
        }

        /* Clean Logout Button */
        .logout-btn {
            width: 100%;
            background: rgba(220, 38, 38, 0.9);
            border: none;
            color: white;
            padding: 0.75rem;
            border-radius: var(--radius-md);
            font-weight: 500;
            font-size: var(--text-sm);
            margin-top: 0.75rem;
            cursor: pointer;
            transition: all var(--duration-200) var(--ease-out);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
        }

        .logout-btn:hover {
            background: #dc2626;
            transform: translateY(-1px);
            box-shadow: var(--shadow-lg);
        }

        /* Main Content */
        .main-content {
            margin-right: 0;
            min-height: 100vh;
            width: 100%;
            background: var(--gray-50);
        }

        /* Clean Navbar */
        .top-navbar {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(15px);
            border-bottom: 1px solid var(--gray-200);
            padding: 0 1.5rem;
            height: var(--navbar-height);
            display: flex;
            align-items: center;
            justify-content: space-between;
            box-shadow: var(--shadow-sm);
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .navbar-left {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .mobile-toggle {
            display: none !important;
        }

        .page-title {
            font-size: var(--text-2xl);
            font-weight: 700;
            color: var(--gray-900);
            margin: 0;
            letter-spacing: -0.025em;
        }

        .page-breadcrumb {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            color: var(--gray-500);
            font-size: var(--text-sm);
            margin-top: 0.25rem;
        }

        .navbar-right {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .navbar-actions {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .theme-toggle {
            background: var(--gray-100);
            border: 1px solid var(--gray-200);
            color: var(--gray-600);
            padding: 0.5rem;
            border-radius: var(--radius-md);
            transition: all var(--duration-200) var(--ease-out);
        }

        .theme-toggle:hover {
            background: var(--gray-200);
            color: var(--gray-800);
        }

        /* Content Wrapper */
        .content-wrapper {
            padding: var(--content-padding);
            max-width: 100%;
        }

        /* Enhanced Alert System */
        .alert {
            border: none;
            border-radius: var(--radius-lg);
            padding: 1rem 1.25rem;
            margin-bottom: 1.5rem;
            box-shadow: var(--shadow-sm);
            border-left: 4px solid;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .alert-success {
            background: var(--success-50);
            color: var(--success-600);
            border-left-color: var(--success-500);
        }

        .alert-danger {
            background: var(--danger-50);
            color: var(--danger-600);
            border-left-color: var(--danger-500);
        }

        .alert-warning {
            background: var(--warning-50);
            color: var(--warning-600);
            border-left-color: var(--warning-500);
        }

        /* Modal Styles */
        .modal-content {
            border: none;
            border-radius: var(--radius-xl);
            box-shadow: var(--shadow-xl);
            overflow: hidden;
        }

        .modal-header {
            background: var(--gradient-primary);
            color: white;
            padding: 1.25rem 1.5rem;
            border-bottom: none;
        }

        .modal-title {
            font-weight: 600;
            font-size: var(--text-lg);
            margin: 0;
        }

        .modal-body {
            padding: 1.5rem;
        }

        .modal-footer {
            padding: 1rem 1.5rem;
            background: var(--gray-50);
            border-top: 1px solid var(--gray-200);
        }

        /* Button System */
        .btn {
            border-radius: var(--radius-md);
            padding: 0.625rem 1.25rem;
            font-weight: 500;
            font-size: var(--text-sm);
            transition: all var(--duration-200) var(--ease-out);
            border: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
        }

        .btn-primary {
            background: var(--gradient-primary);
            color: white;
            box-shadow: var(--shadow-md);
        }

        .btn-primary:hover {
            transform: translateY(-1px);
            box-shadow: var(--shadow-lg);
        }

        .btn-secondary {
            background: var(--gray-600);
            color: white;
        }

        .btn-danger {
            background: var(--danger-500);
            color: white;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .content-wrapper {
                padding: 1rem;
            }

            .top-navbar {
                padding: 0 1rem;
                height: 60px;
            }

            .page-title {
                font-size: var(--text-xl);
            }
        }

        /* Animations */
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes slideIn {
            from {
                transform: translateX(20px);
                opacity: 0;
            }
            to {
                transform: translateX(0);
                opacity: 1;
            }
        }

        .fade-in {
            animation: fadeIn var(--duration-300) var(--ease-out);
        }

        .slide-in {
            animation: slideIn var(--duration-300) var(--ease-out);
        }
    </style>
    
    @stack('styles')
</head>
<body>
    <div class="app-layout">
        <!-- Main Content -->
        <div class="main-content">
            <!-- Clean Header -->
            <div class="top-navbar">
                <div class="navbar-left">
                    <div>
                        <h1 class="page-title">@yield('page-title', 'لوحة التحكم')</h1>
                        <div class="page-breadcrumb">@yield('breadcrumb')</div>
                    </div>
                </div>
                <div class="navbar-right">
                    <button class="btn btn-outline-secondary theme-toggle" id="themeToggle">
                        <i class="fas fa-moon"></i>
                    </button>
                    <div class="navbar-actions">@yield('page-actions')</div>
                </div>
            </div>
            
            <div class="content-wrapper">
                <!-- Clean Alerts -->
                @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show slide-in" role="alert">
                    <i class="fas fa-check-circle"></i>
                    <div>{{ session('success') }}</div>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                @endif
                
                @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show slide-in" role="alert">
                    <i class="fas fa-exclamation-circle"></i>
                    <div>{{ session('error') }}</div>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                @endif
                
                @if(session('warning'))
                <div class="alert alert-warning alert-dismissible fade show slide-in" role="alert">
                    <i class="fas fa-exclamation-triangle"></i>
                    <div>{{ session('warning') }}</div>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                @endif
                
                <!-- Page Content -->
                <div class="fade-in">
                    @yield('content')
                </div>
            </div>
        </div>
    </div>
    
    <!-- Clean Logout Modal -->
    <div class="modal fade" id="logoutModal" tabindex="-1" aria-labelledby="logoutModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="logoutModalLabel">
                        <i class="fas fa-sign-out-alt me-2"></i>تأكيد تسجيل الخروج
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body text-center">
                    <div class="mb-3">
                        <i class="fas fa-question-circle text-warning" style="font-size: 3rem;"></i>
                    </div>
                    <h6 class="mb-3">هل أنت متأكد من رغبتك في تسجيل الخروج؟</h6>
                    <p class="text-muted mb-0">سيتم إنهاء جلستك وإعادة توجيهك إلى صفحة تسجيل الدخول</p>
                </div>
                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times me-2"></i>إلغاء
                    </button>
                    <form method="POST" action="{{ route('logout') }}" class="d-inline">
                        @csrf
                        <button type="submit" class="btn btn-danger">
                            <i class="fas fa-sign-out-alt me-2"></i>تسجيل الخروج
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Enhanced Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js" crossorigin="anonymous"></script>
    
    <!-- Clean JavaScript -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Clean theme toggle
            const themeToggle = document.getElementById('themeToggle');
            const html = document.documentElement;
            
            if (themeToggle) {
                // Load saved theme
                const savedTheme = localStorage.getItem('theme') || 'light';
                html.setAttribute('data-theme', savedTheme);
                updateThemeIcon(savedTheme);
                
                themeToggle.addEventListener('click', () => {
                    const currentTheme = html.getAttribute('data-theme');
                    const newTheme = currentTheme === 'light' ? 'dark' : 'light';
                    
                    html.setAttribute('data-theme', newTheme);
                    localStorage.setItem('theme', newTheme);
                    updateThemeIcon(newTheme);
                });
            }
            
            function updateThemeIcon(theme) {
                const icon = themeToggle.querySelector('i');
                icon.className = theme === 'light' ? 'fas fa-moon' : 'fas fa-sun';
            }
            
            // Clean alert auto-dismiss
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(alert => {
                setTimeout(() => {
                    if (alert.parentNode) {
                        const bsAlert = new bootstrap.Alert(alert);
                        bsAlert.close();
                    }
                }, 5000);
            });
        });
    </script>
    
    @stack('scripts')
</body>
</html>