<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'نظام المبيعات - ZATCA')</title>
    
    <!-- Bootstrap CSS (RTL) -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts (Arabic) -->
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@200;300;400;500;700;800;900&display=swap" rel="stylesheet">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Tajawal', sans-serif;
            background: linear-gradient(135deg, #17a4a5 0%, #10514b 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            overflow-x: hidden;
        }
        
        /* Enhanced Background with Geometric Patterns */
        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background:
                radial-gradient(circle at 25% 75%, rgba(255, 255, 255, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 75% 25%, rgba(255, 255, 255, 0.08) 0%, transparent 50%),
                radial-gradient(circle at 50% 50%, rgba(23, 164, 165, 0.3) 0%, transparent 70%);
            animation: backgroundPulse 8s ease-in-out infinite;
            z-index: -2;
        }
        
        @keyframes backgroundPulse {
            0%, 100% { 
                opacity: 1;
                transform: scale(1);
            }
            50% { 
                opacity: 0.8;
                transform: scale(1.05);
            }
        }
        
        /* Floating geometric shapes */
        .geometric-bg {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1;
            overflow: hidden;
        }
        
        .geometric-shape {
            position: absolute;
            opacity: 0.1;
            animation: float 12s ease-in-out infinite;
        }
        
        .geometric-shape:nth-child(1) {
            top: 10%;
            left: 10%;
            width: 60px;
            height: 60px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            animation-delay: 0s;
        }
        
        .geometric-shape:nth-child(2) {
            top: 20%;
            right: 20%;
            width: 80px;
            height: 80px;
            background: rgba(255, 255, 255, 0.15);
            transform: rotate(45deg);
            animation-delay: 2s;
        }
        
        .geometric-shape:nth-child(3) {
            bottom: 20%;
            left: 15%;
            width: 0;
            height: 0;
            border-left: 40px solid transparent;
            border-right: 40px solid transparent;
            border-bottom: 70px solid rgba(255, 255, 255, 0.1);
            animation-delay: 4s;
        }
        
        .geometric-shape:nth-child(4) {
            bottom: 30%;
            right: 15%;
            width: 50px;
            height: 50px;
            background: rgba(255, 255, 255, 0.12);
            border-radius: 50%;
            animation-delay: 1s;
        }
        
        @keyframes float {
            0%, 100% {
                transform: translateY(0px) rotate(0deg);
                opacity: 0.1;
            }
            25% {
                transform: translateY(-20px) rotate(90deg);
                opacity: 0.2;
            }
            50% {
                transform: translateY(-10px) rotate(180deg);
                opacity: 0.15;
            }
            75% {
                transform: translateY(-25px) rotate(270deg);
                opacity: 0.18;
            }
        }
        
        .auth-container {
            width: 100%;
            max-width: 550px;
            padding: 20px;
            animation: slideInUp 1s ease-out;
        }
        
        @keyframes slideInUp {
            from {
                opacity: 0;
                transform: translateY(60px) scale(0.95);
            }
            to {
                opacity: 1;
                transform: translateY(0) scale(1);
            }
        }
        
        .auth-card {
            background: rgba(255, 255, 255, 0.98);
            border-radius: 20px;
            box-shadow:
                0 20px 60px rgba(0, 0, 0, 0.15),
                0 0 0 1px rgba(255, 255, 255, 0.2);
            overflow: hidden;
            backdrop-filter: blur(20px);
            position: relative;
            transition: all 0.4s ease;
        }
        
        .auth-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, #17a4a5, #10514b);
            z-index: 1;
        }
        
        .auth-card:hover {
            transform: translateY(-8px);
            box-shadow:
                0 30px 80px rgba(0, 0, 0, 0.2),
                0 0 0 1px rgba(255, 255, 255, 0.3);
        }
        
        .auth-header {
            background: linear-gradient(135deg, #17a4a5 0%, #10514b 100%);
            color: white;
            padding: 50px 40px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }
        
        .auth-header::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background:
                radial-gradient(circle, rgba(255, 255, 255, 0.1) 0%, transparent 70%);
            animation: rotate 20s linear infinite;
        }
        
        @keyframes rotate {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }
        
        .auth-header .logo {
            font-size: 4rem;
            margin-bottom: 20px;
            color: #ffffff;
            position: relative;
            z-index: 2;
            display: inline-block;
            animation: logoPulse 3s ease-in-out infinite;
            text-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
        }
        
        @keyframes logoPulse {
            0%, 100% { 
                transform: scale(1);
                filter: drop-shadow(0 0 10px rgba(255, 255, 255, 0.3));
            }
            50% { 
                transform: scale(1.05);
                filter: drop-shadow(0 0 20px rgba(255, 255, 255, 0.5));
            }
        }
        
        .auth-header h2 {
            margin: 0 0 10px 0;
            font-weight: 700;
            font-size: 2rem;
            position: relative;
            z-index: 2;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.3);
        }
        
        .auth-header p {
            margin: 0;
            opacity: 0.95;
            font-size: 1.1rem;
            position: relative;
            z-index: 2;
            font-weight: 400;
        }
        
        .auth-body {
            padding: 50px 40px;
            position: relative;
        }
        
        .form-floating {
            margin-bottom: 30px;
            position: relative;
        }
        
        .form-floating > .form-control {
            border: 2px solid #e8f4f8;
            border-radius: 12px;
            padding: 22px 20px 10px;
            font-size: 1.1rem;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            background: rgba(248, 251, 252, 0.8);
            backdrop-filter: blur(10px);
            color: #2c3e50;
        }
        
        .form-floating > .form-control:focus {
            border-color: #17a4a5;
            box-shadow:
                0 0 0 0.25rem rgba(23, 164, 165, 0.15),
                0 8px 25px rgba(23, 164, 165, 0.1);
            background: rgba(255, 255, 255, 0.95);
            transform: translateY(-2px);
        }
        
        .form-floating > .form-control:not(:placeholder-shown) {
            background: rgba(255, 255, 255, 0.95);
        }
        
        .form-floating > label {
            padding: 20px;
            font-weight: 600;
            color: #5a6c7d;
            transition: all 0.3s ease;
        }
        
        .form-floating > .form-control:focus ~ label,
        .form-floating > .form-control:not(:placeholder-shown) ~ label {
            color: #17a4a5;
            transform: scale(0.85) translateY(-0.5rem) translateX(0.15rem);
        }
        
        .btn-auth {
            background: linear-gradient(135deg, #17a4a5 0%, #10514b 100%);
            border: none;
            border-radius: 12px;
            padding: 18px;
            font-size: 1.2rem;
            font-weight: 700;
            color: white;
            width: 100%;
            margin: 35px 0 30px;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
            text-transform: uppercase;
            letter-spacing: 1px;
            box-shadow: 0 8px 25px rgba(23, 164, 165, 0.3);
        }
        
        .btn-auth::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
            transition: left 0.6s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        .btn-auth:hover::before {
            left: 100%;
        }
        
        .btn-auth:hover {
            transform: translateY(-3px);
            box-shadow: 0 15px 40px rgba(23, 164, 165, 0.4);
            background: linear-gradient(135deg, #0e8e8f 0%, #0d4842 100%);
        }
        
        .btn-auth:active {
            transform: translateY(-1px);
            box-shadow: 0 8px 25px rgba(23, 164, 165, 0.3);
        }
        
        .auth-links {
            text-align: center;
            padding-top: 30px;
            border-top: 2px solid rgba(23, 164, 165, 0.1);
            position: relative;
        }
        
        .auth-links::before {
            content: '';
            position: absolute;
            top: -1px;
            left: 50%;
            transform: translateX(-50%);
            width: 60px;
            height: 2px;
            background: linear-gradient(90deg, #17a4a5, #10514b);
            border-radius: 2px;
        }
        
        .auth-links a {
            color: #17a4a5;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
            position: relative;
            display: inline-block;
        }
        
        .auth-links a::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 0;
            width: 0;
            height: 2px;
            background: linear-gradient(90deg, #17a4a5, #10514b);
            transition: width 0.3s ease;
        }
        
        .auth-links a:hover {
            color: #10514b;
            transform: translateY(-1px);
        }
        
        .auth-links a:hover::after {
            width: 100%;
        }
        
        .auth-links p {
            margin-bottom: 15px;
            font-size: 1rem;
            color: #5a6c7d;
        }
        
        .remember-checkbox {
            margin-bottom: 25px;
        }
        
        .form-check {
            display: flex;
            align-items: center;
            gap: 12px;
        }
        
        .form-check-input {
            border-radius: 6px;
            border: 2px solid #e8f4f8;
            width: 20px;
            height: 20px;
            transition: all 0.3s ease;
            cursor: pointer;
        }
        
        .form-check-input:checked {
            background-color: #17a4a5;
            border-color: #17a4a5;
            box-shadow: 0 0 0 0.2rem rgba(23, 164, 165, 0.15);
        }
        
        .form-check-label {
            font-weight: 500;
            color: #5a6c7d;
            cursor: pointer;
            transition: color 0.3s ease;
        }
        
        .form-check-input:checked + .form-check-label {
            color: #17a4a5;
        }
        
        .alert {
            border-radius: 12px;
            border: none;
            margin-bottom: 25px;
            padding: 18px 22px;
            font-weight: 500;
            backdrop-filter: blur(10px);
            animation: slideInDown 0.5s ease-out;
        }
        
        @keyframes slideInDown {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .alert-success {
            background: rgba(25, 135, 84, 0.1);
            color: #198754;
            border: 1px solid rgba(25, 135, 84, 0.2);
        }
        
        .alert-danger {
            background: rgba(220, 53, 69, 0.1);
            color: #dc3545;
            border: 1px solid rgba(220, 53, 69, 0.2);
        }
        
        .invalid-feedback {
            font-size: 0.9rem;
            margin-top: 8px;
            font-weight: 500;
        }
        
        /* Enhanced Mobile Responsiveness */
        @media (max-width: 768px) {
            .auth-container {
                padding: 15px;
                max-width: 95%;
            }
            
            .auth-body {
                padding: 40px 30px;
            }
            
            .auth-header {
                padding: 40px 30px;
            }
            
            .auth-header .logo {
                font-size: 3.5rem;
            }
            
            .auth-header h2 {
                font-size: 1.8rem;
            }
            
            .form-floating > .form-control {
                font-size: 1rem;
                padding: 20px 18px 8px;
            }
            
            .btn-auth {
                font-size: 1.1rem;
                padding: 16px;
            }
        }
        
        @media (max-width: 480px) {
            .auth-container {
                padding: 10px;
            }
            
            .auth-body {
                padding: 35px 25px;
            }
            
            .auth-header {
                padding: 35px 25px;
            }
            
            .auth-header .logo {
                font-size: 3rem;
            }
            
            .auth-header h2 {
                font-size: 1.6rem;
            }
            
            .auth-header p {
                font-size: 1rem;
            }
        }
        
        /* Password Toggle Eye Icon Enhancement */
        .password-toggle {
            position: absolute;
            top: 50%;
            left: 20px;
            transform: translateY(-50%);
            cursor: pointer;
            color: #5a6c7d;
            font-size: 1.1rem;
            z-index: 10;
            transition: all 0.3s ease;
            padding: 8px;
            border-radius: 50%;
        }
        
        .password-toggle:hover {
            color: #17a4a5;
            background: rgba(23, 164, 165, 0.1);
        }
        
        /* Loading Animation for Button */
        .btn-auth.loading {
            pointer-events: none;
            position: relative;
        }
        
        .btn-auth.loading::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 20px;
            height: 20px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: white;
            animation: spin 0.8s linear infinite;
        }
        
        @keyframes spin {
            to { transform: translate(-50%, -50%) rotate(360deg); }
        }
        
        .btn-auth.loading span {
            opacity: 0;
        }
        
        /* Enhanced animations */
        .form-floating {
            animation: slideInUp 0.6s ease-out both;
        }
        
        .form-floating:nth-child(1) { animation-delay: 0.1s; }
        .form-floating:nth-child(2) { animation-delay: 0.2s; }
        .remember-checkbox { animation: slideInUp 0.6s ease-out 0.3s both; }
        .btn-auth { animation: slideInUp 0.6s ease-out 0.4s both; }
        .auth-links { animation: slideInUp 0.6s ease-out 0.5s both; }
        
        @keyframes slideInUpSmooth {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
    </style>
    
    @stack('styles')
</head>
<body>
    <!-- Geometric Background -->
    <div class="geometric-bg">
        <div class="geometric-shape"></div>
        <div class="geometric-shape"></div>
        <div class="geometric-shape"></div>
        <div class="geometric-shape"></div>
    </div>

    <div class="auth-container">
        <div class="auth-card">
            <div class="auth-header">
                <div class="logo">
                    <i class="fas fa-receipt"></i>
                </div>
                <h2>@yield('header-title', 'نظام المبيعات')</h2>
                <p>@yield('header-subtitle', 'متوافق مع ZATCA')</p>
            </div>
            
            <div class="auth-body">
                <!-- Alerts -->
                @if(session('success'))
                    <div class="alert alert-success" role="alert">
                        <i class="fas fa-check-circle me-2"></i>
                        {{ session('success') }}
                    </div>
                @endif
                
                @if(session('error'))
                    <div class="alert alert-danger" role="alert">
                        <i class="fas fa-exclamation-circle me-2"></i>
                        {{ session('error') }}
                    </div>
                @endif
                
                @if($errors->any())
                    <div class="alert alert-danger" role="alert">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        @if($errors->count() > 1)
                            يرجى تصحيح الأخطاء التالية:
                            <ul class="mb-0 mt-2">
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        @else
                            {{ $errors->first() }}
                        @endif
                    </div>
                @endif
                
                @yield('content')
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    @stack('scripts')
</body>
</html>