<!DOCTYPE html>
<html lang="ar" dir="rtl" data-theme="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="color-scheme" content="light dark">
    <title>@yield('title', 'نظام المبيعات - ZATCA')</title>
    
    <!-- Modern CSS Loading -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        /* ========== Modern CSS Variables ========== */
        :root {
            /* Clean Color Palette */
            --primary-600: #2563eb;
            --primary-700: #1d4ed8;
            --primary-500: #3b82f6;
            --primary-400: #60a5fa;
            
            /* Semantic Colors */
            --success-50: #f0fdf4;
            --success-500: #22c55e;
            --success-600: #16a34a;
            --warning-50: #fffbeb;
            --warning-500: #f59e0b;
            --warning-600: #d97706;
            --danger-50: #fef2f2;
            --danger-500: #ef4444;
            --danger-600: #dc2626;

            /* Clean Neutral Colors */
            --gray-50: #f8fafc;
            --gray-100: #f1f5f9;
            --gray-200: #e2e8f0;
            --gray-300: #cbd5e1;
            --gray-400: #94a3b8;
            --gray-500: #64748b;
            --gray-600: #475569;
            --gray-700: #334155;
            --gray-800: #1e293b;
            --gray-900: #0f172a;

            /* Clean Gradients */
            --gradient-primary: linear-gradient(135deg, var(--primary-600) 0%, var(--primary-700) 100%);
            --gradient-dark: linear-gradient(135deg, var(--gray-800) 0%, var(--gray-900) 100%);

            /* Layout System */
            --sidebar-width: 280px;
            --navbar-height: 70px;
            --content-padding: 1.5rem;

            /* Border Radius */
            --radius-sm: 6px;
            --radius-md: 10px;
            --radius-lg: 14px;
            --radius-xl: 20px;

            /* Shadow System */
            --shadow-sm: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px -1px rgba(0, 0, 0, 0.1);
            --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -2px rgba(0, 0, 0, 0.1);
            --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -4px rgba(0, 0, 0, 0.1);
            --shadow-xl: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 8px 10px -6px rgba(0, 0, 0, 0.1);

            /* Animation System */
            --duration-200: 200ms;
            --duration-300: 300ms;
            --ease-out: cubic-bezier(0, 0, 0.2, 1);

            /* Typography */
            --font-family: 'Cairo', -apple-system, BlinkMacSystemFont, 'Segoe UI', system-ui, sans-serif;
            --text-xs: 0.75rem;
            --text-sm: 0.875rem;
            --text-base: 1rem;
            --text-lg: 1.125rem;
            --text-xl: 1.25rem;
            --text-2xl: 1.5rem;
        }

        /* Dark Theme */
        [data-theme="dark"] {
            --gray-50: #0f172a;
            --gray-100: #1e293b;
            --gray-200: #334155;
            --gray-300: #475569;
            --gray-400: #64748b;
            --gray-500: #94a3b8;
            --gray-600: #cbd5e1;
            --gray-700: #e2e8f0;
            --gray-800: #f1f5f9;
            --gray-900: #f8fafc;
        }

        [data-theme="dark"] body {
            background: var(--gray-50);
            color: var(--gray-800);
        }

        [data-theme="dark"] .sidebar {
            background: var(--gradient-dark);
        }

        [data-theme="dark"] .top-navbar {
            background: rgba(30, 41, 59, 0.95);
            border-bottom-color: var(--gray-200);
        }

        /* Global Reset */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        html {
            scroll-behavior: smooth;
            height: 100%;
        }

        body {
            font-family: var(--font-family);
            font-size: var(--text-base);
            line-height: 1.6;
            color: var(--gray-800);
            background: var(--gray-50);
            min-height: 100vh;
            text-rendering: optimizeLegibility;
            -webkit-font-smoothing: antialiased;
        }

        /* ========== Clean Professional Sidebar ========== */
        .sidebar {
            position: fixed;
            top: 0;
            right: 0;
            width: var(--sidebar-width);
            height: 100vh;
            background: var(--gradient-dark);
            z-index: 1050;
            overflow: hidden;
            box-shadow: var(--shadow-xl);
            transition: all var(--duration-300) var(--ease-out);
            display: flex;
            flex-direction: column;
        }

        .sidebar-scrollable {
            height: 100%;
            overflow-y: auto;
            overflow-x: hidden;
            scrollbar-width: thin;
            scrollbar-color: rgba(255, 255, 255, 0.3) transparent;
            display: flex;
            flex-direction: column;
        }

        .sidebar-scrollable::-webkit-scrollbar {
            width: 3px;
        }

        .sidebar-scrollable::-webkit-scrollbar-track {
            background: transparent;
        }

        .sidebar-scrollable::-webkit-scrollbar-thumb {
            background: rgba(255, 255, 255, 0.2);
            border-radius: 2px;
        }

        /* Clean Sidebar Header */
        .sidebar-header {
            padding: 1.5rem;
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            text-align: center;
            position: relative;
            flex-shrink: 0;
        }

        .sidebar-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 2px;
            background: var(--gradient-primary);
        }

        .sidebar-logo {
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 0.75rem;
        }

        .sidebar-logo .logo-icon {
            width: 48px;
            height: 48px;
            background: var(--gradient-primary);
            border-radius: var(--radius-lg);
            display: flex;
            align-items: center;
            justify-content: center;
            margin-left: 12px;
            box-shadow: var(--shadow-lg);
        }

        .sidebar-logo .logo-icon i {
            color: white;
            font-size: 1.5rem;
        }

        .sidebar-logo .logo-text {
            color: white;
            font-size: var(--text-xl);
            font-weight: 700;
            letter-spacing: -0.02em;
        }

        .sidebar-subtitle {
            color: rgba(255, 255, 255, 0.7);
            font-size: var(--text-sm);
            font-weight: 500;
            margin: 0;
            padding: 0.5rem 0.75rem;
            background: rgba(255, 255, 255, 0.08);
            border-radius: var(--radius-md);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        /* Simplified Navigation */
        .sidebar-nav {
            padding: 1rem 0;
            flex: 1;
            overflow-y: auto;
        }

        .nav-section {
            margin-bottom: 1.5rem;
        }

        .nav-section:last-child {
            margin-bottom: 0;
        }

        .nav-section-title {
            color: rgba(255, 255, 255, 0.5);
            font-size: var(--text-xs);
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            padding: 0 1.25rem 0.5rem;
            margin-bottom: 0.5rem;
        }

        .nav-item {
            margin: 1px 0.75rem;
        }

        .nav-link {
            display: flex;
            align-items: center;
            padding: 0.75rem 1rem;
            color: rgba(255, 255, 255, 0.85);
            text-decoration: none;
            border-radius: var(--radius-md);
            font-weight: 500;
            font-size: var(--text-sm);
            transition: all var(--duration-200) var(--ease-out);
            border: 1px solid transparent;
        }

        .nav-link:hover,
        .nav-link.active {
            color: white;
            background: rgba(255, 255, 255, 0.1);
            transform: translateX(-3px);
            border-color: rgba(255, 255, 255, 0.15);
        }

        .nav-link.active {
            background: var(--gradient-primary);
            box-shadow: var(--shadow-md);
        }

        .nav-link-icon {
            width: 18px;
            height: 18px;
            margin-left: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: transform var(--duration-200) var(--ease-out);
        }

        .nav-link:hover .nav-link-icon,
        .nav-link.active .nav-link-icon {
            transform: scale(1.1);
        }

        /* Clean Dropdown Styles */
        .nav-dropdown {
            position: relative;
        }

        .nav-dropdown-toggle::after {
            content: '\f107';
            font-family: 'Font Awesome 6 Free';
            font-weight: 900;
            margin-right: auto;
            transition: transform var(--duration-200) var(--ease-out);
            font-size: 0.7rem;
            opacity: 0.7;
        }

        .nav-dropdown.show .nav-dropdown-toggle::after {
            transform: rotate(180deg);
        }

        .nav-dropdown-menu {
            max-height: 0;
            overflow: hidden;
            background: rgba(0, 0, 0, 0.15);
            backdrop-filter: blur(10px);
            border-radius: var(--radius-md);
            margin: 0.25rem 0;
            transition: all var(--duration-300) ease;
            border: 1px solid rgba(255, 255, 255, 0.05);
        }

        .nav-dropdown.show .nav-dropdown-menu {
            max-height: 400px;
            padding: 0.5rem 0;
        }

        .nav-dropdown-item {
            display: flex;
            align-items: center;
            padding: 0.625rem 0.75rem 0.625rem 2.5rem;
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
            font-weight: 400;
            font-size: var(--text-sm);
            transition: all var(--duration-200) var(--ease-out);
            border-radius: var(--radius-sm);
            margin: 1px 0.5rem;
            position: relative;
        }

        .nav-dropdown-item::before {
            content: '';
            position: absolute;
            right: 1.75rem;
            top: 50%;
            transform: translateY(-50%);
            width: 3px;
            height: 3px;
            background: rgba(255, 255, 255, 0.4);
            border-radius: 50%;
            transition: all var(--duration-200) var(--ease-out);
        }

        .nav-dropdown-item:hover,
        .nav-dropdown-item.active {
            color: white;
            background: rgba(255, 255, 255, 0.1);
            transform: translateX(-2px);
        }

        .nav-dropdown-item:hover::before,
        .nav-dropdown-item.active::before {
            background: var(--primary-400);
            transform: translateY(-50%) scale(1.3);
        }

        .nav-dropdown-item.active {
            background: var(--gradient-primary);
        }

        .nav-dropdown-item i {
            width: 14px;
            margin-left: 8px;
            font-size: 0.8rem;
        }

        /* Clean Navigation Divider */
        .nav-divider {
            height: 1px;
            background: rgba(255, 255, 255, 0.1);
            margin: 0.75rem 1rem;
            position: relative;
        }

        .nav-divider::before {
            content: '';
            position: absolute;
            left: 50%;
            top: 0;
            transform: translateX(-50%);
            width: 30px;
            height: 1px;
            background: var(--gradient-primary);
        }

        /* Clean User Section */
        .user-section {
            padding: 1rem;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            flex-shrink: 0;
        }

        .user-info {
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
            border-radius: var(--radius-lg);
            padding: 1rem;
            text-align: center;
            border: 1px solid rgba(255, 255, 255, 0.1);
            position: relative;
        }

        .user-info::before {
            content: '';
            position: absolute;
            top: -1px;
            left: -1px;
            right: -1px;
            height: 2px;
            background: var(--gradient-primary);
            border-radius: var(--radius-lg) var(--radius-lg) 0 0;
        }

        .user-avatar {
            width: 40px;
            height: 40px;
            background: var(--gradient-primary);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 0.5rem;
            box-shadow: var(--shadow-md);
        }

        .user-avatar i {
            color: white;
            font-size: 1.1rem;
        }

        .user-greeting {
            color: rgba(255, 255, 255, 0.6);
            font-size: var(--text-xs);
            margin-bottom: 0.25rem;
        }

        .user-name {
            color: white;
            font-weight: 600;
            font-size: var(--text-base);
            margin-bottom: 0.25rem;
        }

        .user-role {
            color: rgba(255, 255, 255, 0.7);
            font-size: var(--text-xs);
            background: rgba(255, 255, 255, 0.1);
            padding: 0.25rem 0.5rem;
            border-radius: var(--radius-sm);
            display: inline-block;
        }

        /* Clean Logout Button */
        .logout-btn {
            width: 100%;
            background: rgba(220, 38, 38, 0.9);
            border: none;
            color: white;
            padding: 0.75rem;
            border-radius: var(--radius-md);
            font-weight: 500;
            font-size: var(--text-sm);
            margin-top: 0.75rem;
            cursor: pointer;
            transition: all var(--duration-200) var(--ease-out);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
        }

        .logout-btn:hover {
            background: #dc2626;
            transform: translateY(-1px);
            box-shadow: var(--shadow-lg);
        }

        /* Main Content */
        .main-content {
            margin-right: var(--sidebar-width);
            min-height: 100vh;
            transition: margin-right var(--duration-300) var(--ease-out);
            background: var(--gray-50);
        }

        /* Clean Navbar */
        .top-navbar {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(15px);
            border-bottom: 1px solid var(--gray-200);
            padding: 0 1.5rem;
            height: var(--navbar-height);
            display: flex;
            align-items: center;
            justify-content: space-between;
            box-shadow: var(--shadow-sm);
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .navbar-left {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .mobile-toggle {
            display: none;
            background: var(--gradient-primary);
            border: none;
            color: white;
            padding: 0.625rem;
            border-radius: var(--radius-md);
            transition: all var(--duration-200) var(--ease-out);
            box-shadow: var(--shadow-md);
        }

        .mobile-toggle:hover {
            transform: scale(1.05);
            box-shadow: var(--shadow-lg);
        }

        .page-title {
            font-size: var(--text-2xl);
            font-weight: 700;
            color: var(--gray-900);
            margin: 0;
            letter-spacing: -0.025em;
        }

        .page-breadcrumb {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            color: var(--gray-500);
            font-size: var(--text-sm);
            margin-top: 0.25rem;
        }

        .navbar-right {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .navbar-actions {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .theme-toggle {
            background: var(--gray-100);
            border: 1px solid var(--gray-200);
            color: var(--gray-600);
            padding: 0.5rem;
            border-radius: var(--radius-md);
            transition: all var(--duration-200) var(--ease-out);
        }

        .theme-toggle:hover {
            background: var(--gray-200);
            color: var(--gray-800);
        }

        /* Content Wrapper */
        .content-wrapper {
            padding: var(--content-padding);
            max-width: 100%;
        }

        /* Enhanced Alert System */
        .alert {
            border: none;
            border-radius: var(--radius-lg);
            padding: 1rem 1.25rem;
            margin-bottom: 1.5rem;
            box-shadow: var(--shadow-sm);
            border-left: 4px solid;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .alert-success {
            background: var(--success-50);
            color: var(--success-600);
            border-left-color: var(--success-500);
        }

        .alert-danger {
            background: var(--danger-50);
            color: var(--danger-600);
            border-left-color: var(--danger-500);
        }

        .alert-warning {
            background: var(--warning-50);
            color: var(--warning-600);
            border-left-color: var(--warning-500);
        }

        /* Modal Styles */
        .modal-content {
            border: none;
            border-radius: var(--radius-xl);
            box-shadow: var(--shadow-xl);
            overflow: hidden;
        }

        .modal-header {
            background: var(--gradient-primary);
            color: white;
            padding: 1.25rem 1.5rem;
            border-bottom: none;
        }

        .modal-title {
            font-weight: 600;
            font-size: var(--text-lg);
            margin: 0;
        }

        .modal-body {
            padding: 1.5rem;
        }

        .modal-footer {
            padding: 1rem 1.5rem;
            background: var(--gray-50);
            border-top: 1px solid var(--gray-200);
        }

        /* Button System */
        .btn {
            border-radius: var(--radius-md);
            padding: 0.625rem 1.25rem;
            font-weight: 500;
            font-size: var(--text-sm);
            transition: all var(--duration-200) var(--ease-out);
            border: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
        }

        .btn-primary {
            background: var(--gradient-primary);
            color: white;
            box-shadow: var(--shadow-md);
        }

        .btn-primary:hover {
            transform: translateY(-1px);
            box-shadow: var(--shadow-lg);
        }

        .btn-secondary {
            background: var(--gray-600);
            color: white;
        }

        .btn-danger {
            background: var(--danger-500);
            color: white;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(100%);
                width: 100%;
                max-width: 300px;
            }

            .sidebar.show {
                transform: translateX(0);
            }

            .main-content {
                margin-right: 0;
            }

            .mobile-toggle {
                display: flex;
                align-items: center;
                justify-content: center;
            }

            .content-wrapper {
                padding: 1rem;
            }

            .top-navbar {
                padding: 0 1rem;
                height: 60px;
            }

            .page-title {
                font-size: var(--text-xl);
            }

            /* Mobile backdrop */
            .sidebar-backdrop {
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                background: rgba(0, 0, 0, 0.5);
                z-index: 1040;
                opacity: 0;
                visibility: hidden;
                transition: all var(--duration-300) var(--ease-out);
            }

            .sidebar.show ~ .sidebar-backdrop,
            .sidebar-backdrop.show {
                opacity: 1;
                visibility: visible;
            }
        }

        /* Animations */
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes slideIn {
            from {
                transform: translateX(20px);
                opacity: 0;
            }
            to {
                transform: translateX(0);
                opacity: 1;
            }
        }

        .fade-in {
            animation: fadeIn var(--duration-300) var(--ease-out);
        }

        .slide-in {
            animation: slideIn var(--duration-300) var(--ease-out);
        }
    </style>
    
    @stack('styles')
</head>
<body>
    <div class="app-layout">
        <!-- Clean Professional Sidebar -->
        <aside class="sidebar" id="sidebar">
            <div class="sidebar-scrollable">
                <!-- Clean Header -->
                <div class="sidebar-header">
                    <div class="sidebar-logo">
                        <div class="logo-icon">
                            <i class="fas fa-receipt"></i>
                        </div>
                        <div class="logo-text">نظام ردكو</div>
                    </div>
                    <p class="sidebar-subtitle">نظام إدارة المبيعات</p>
                </div>
                
                <!-- Simplified Navigation -->
                <div class="sidebar-nav">
                    <!-- Dashboard -->
                    <div class="nav-section">
                        <div class="nav-item">
                            <a class="nav-link {{ request()->routeIs('dashboard') ? 'active' : '' }}"
                               href="{{ route('dashboard') }}">
                                <div class="nav-link-icon">
                                    <i class="fas fa-tachometer-alt"></i>
                                </div>
                                لوحة التحكم
                            </a>
                        </div>
                    </div>
                    
                    <!-- الفواتير الإلكترونية -->
                    <div class="nav-section">
                        <div class="nav-item nav-dropdown {{ request()->routeIs('invoices.*') || request()->routeIs('receipt-vouchers.*') || request()->routeIs('payment-vouchers.*') ? 'show' : '' }}">
                            <a class="nav-link nav-dropdown-toggle {{ request()->routeIs('invoices.*') || request()->routeIs('receipt-vouchers.*') || request()->routeIs('payment-vouchers.*') ? 'active' : '' }}"
                               href="#" role="button">
                                <div class="nav-link-icon">
                                    <i class="fas fa-file-invoice"></i>
                                </div>
                                إدارة الفواتير
                            </a>
                            <div class="nav-dropdown-menu">
                                <a class="nav-dropdown-item {{ request()->routeIs('invoices.index') || request()->routeIs('invoices.show') || request()->routeIs('invoices.create') || request()->routeIs('invoices.edit') ? 'active' : '' }}"
                                   href="{{ route('invoices.index') }}">
                                    <i class="fas fa-file-invoice"></i>
                                    الفواتير الرئيسية
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('invoices.payments-report') ? 'active' : '' }}"
                                   href="{{ route('invoices.payments-report') }}">
                                    <i class="fas fa-chart-line"></i>
                                    تقرير المدفوعات
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('invoices.payment-analytics') ? 'active' : '' }}"
                                   href="{{ route('invoices.payment-analytics') }}">
                                    <i class="fas fa-chart-bar"></i>
                                    تحليلات متقدمة
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('invoices.customer-statement') ? 'active' : '' }}"
                                   href="{{ route('invoices.customer-statement') }}">
                                    <i class="fas fa-file-alt"></i>
                                    كشف حساب العملاء
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('invoices.debt-management') ? 'active' : '' }}"
                                   href="{{ route('invoices.debt-management') }}">
                                    <i class="fas fa-exclamation-triangle"></i>
                                    إدارة الديون
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('invoices.collection-performance') ? 'active' : '' }}"
                                   href="{{ route('invoices.collection-performance') }}">
                                    <i class="fas fa-chart-line"></i>
                                    أداء التحصيل
                                </a>
                                <div class="nav-divider"></div>
                                <a class="nav-dropdown-item {{ request()->routeIs('receipt-vouchers.*') ? 'active' : '' }}"
                                   href="{{ route('receipt-vouchers.index') }}">
                                    <i class="fas fa-hand-holding-usd"></i>
                                    سندات القبض
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('payment-vouchers.*') ? 'active' : '' }}"
                                   href="{{ route('payment-vouchers.index') }}">
                                    <i class="fas fa-money-check-alt"></i>
                                    سندات الصرف
                                </a>
                                <div class="nav-divider"></div>
                                <a class="nav-dropdown-item {{ request()->routeIs('invoices.notification-settings') ? 'active' : '' }}"
                                   href="{{ route('invoices.notification-settings') }}">
                                    <i class="fas fa-bell-slash"></i>
                                    إعدادات الإشعارات
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- إدارة المشتريات -->
                    <div class="nav-section">
                        <div class="nav-item nav-dropdown {{ request()->routeIs('suppliers.*') || request()->routeIs('purchase-orders.*') || request()->routeIs('goods-receipts.*') || request()->routeIs('procurement.*') ? 'show' : '' }}">
                            <a class="nav-link nav-dropdown-toggle {{ request()->routeIs('suppliers.*') || request()->routeIs('purchase-orders.*') || request()->routeIs('goods-receipts.*') || request()->routeIs('procurement.*') ? 'active' : '' }}"
                               href="#" role="button">
                                <div class="nav-link-icon">
                                    <i class="fas fa-shopping-cart"></i>
                                </div>
                                نظام المشتريات
                            </a>
                            <div class="nav-dropdown-menu">
                                <a class="nav-dropdown-item {{ request()->routeIs('procurement.workflow.dashboard') ? 'active' : '' }}"
                                   href="{{ route('procurement.workflow.dashboard') }}">
                                    <i class="fas fa-tachometer-alt"></i>
                                    لوحة تحكم المشتريات
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('suppliers.index') || request()->routeIs('suppliers.create') || request()->routeIs('suppliers.show') || request()->routeIs('suppliers.edit') ? 'active' : '' }}"
                                   href="{{ route('suppliers.index') }}">
                                    <i class="fas fa-truck"></i>
                                    إدارة الموردين
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('suppliers.debt.*') ? 'active' : '' }}"
                                   href="{{ route('suppliers.debt.dashboard') }}">
                                    <i class="fas fa-money-check-alt"></i>
                                    إدارة المديونيات
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('suppliers.analytics.*') ? 'active' : '' }}"
                                   href="{{ route('suppliers.analytics.dashboard') }}">
                                    <i class="fas fa-chart-line"></i>
                                    تحليلات الموردين
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('purchase-orders.*') ? 'active' : '' }}"
                                   href="{{ route('purchase-orders.index') }}">
                                    <i class="fas fa-shopping-cart"></i>
                                    أوامر الشراء
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('purchase-invoices.*') ? 'active' : '' }}"
                                   href="{{ route('purchase-invoices.index') }}">
                                    <i class="fas fa-file-invoice"></i>
                                    فواتير الشراء
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('suppliers.payments.*') ? 'active' : '' }}"
                                   href="{{ route('suppliers.payments.index') }}">
                                    <i class="fas fa-hand-holding-usd"></i>
                                    مدفوعات الموردين
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('goods-receipts.*') ? 'active' : '' }}"
                                   href="{{ route('goods-receipts.index') }}">
                                    <i class="fas fa-dolly"></i>
                                    استلام البضائع
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('procurement.reports.*') ? 'active' : '' }}"
                                   href="{{ route('procurement.reports.index') }}">
                                    <i class="fas fa-chart-pie"></i>
                                    تقارير المشتريات
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- إدارة المخزون -->
                    <div class="nav-section">
                        <div class="nav-item nav-dropdown {{ request()->routeIs('inventory.*') ? 'show' : '' }}">
                            <a class="nav-link nav-dropdown-toggle {{ request()->routeIs('inventory.*') ? 'active' : '' }}"
                               href="#" role="button">
                                <div class="nav-link-icon">
                                    <i class="fas fa-warehouse"></i>
                                </div>
                                نظام المخزون
                            </a>
                            <div class="nav-dropdown-menu">
                                <a class="nav-dropdown-item {{ request()->routeIs('inventory.index') ? 'active' : '' }}"
                                   href="{{ route('inventory.index') }}">
                                    <i class="fas fa-warehouse"></i>
                                    حالة المخزون
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('inventory.movements') ? 'active' : '' }}"
                                   href="{{ route('inventory.movements') }}">
                                    <i class="fas fa-exchange-alt"></i>
                                    حركات المخزون
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('inventory.adjustments.*') ? 'active' : '' }}"
                                   href="{{ route('inventory.adjustments.index') }}">
                                    <i class="fas fa-tools"></i>
                                    تسويات المخزون
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('inventory.valuation') ? 'active' : '' }}"
                                   href="{{ route('inventory.valuation') }}">
                                    <i class="fas fa-chart-pie"></i>
                                    تقييم المخزون
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('inventory.reports') ? 'active' : '' }}"
                                   href="{{ route('inventory.reports') }}">
                                    <i class="fas fa-chart-bar"></i>
                                    تقارير المخزون
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- البيانات الأساسية -->
                    <div class="nav-section">
                        <div class="nav-item nav-dropdown {{ request()->routeIs('customers.*') || request()->routeIs('categories.*') || request()->routeIs('products.*') ? 'show' : '' }}">
                            <a class="nav-link nav-dropdown-toggle {{ request()->routeIs('customers.*') || request()->routeIs('categories.*') || request()->routeIs('products.*') ? 'active' : '' }}"
                               href="#" role="button">
                                <div class="nav-link-icon">
                                    <i class="fas fa-database"></i>
                                </div>
                                البيانات الرئيسية
                            </a>
                            <div class="nav-dropdown-menu">
                                <a class="nav-dropdown-item {{ request()->routeIs('customers.*') ? 'active' : '' }}"
                                   href="{{ route('customers.index') }}">
                                    <i class="fas fa-users"></i>
                                    إدارة العملاء
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('categories.*') ? 'active' : '' }}"
                                   href="{{ route('categories.index') }}">
                                    <i class="fas fa-tags"></i>
                                    إدارة الفئات
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('products.*') ? 'active' : '' }}"
                                   href="{{ route('products.index') }}">
                                    <i class="fas fa-boxes"></i>
                                    المنتجات والخدمات
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- النظام المحاسبي -->
                    <div class="nav-section">
                        <div class="nav-item nav-dropdown {{ request()->routeIs('accounting.*') ? 'show' : '' }}">
                            <a class="nav-link nav-dropdown-toggle {{ request()->routeIs('accounting.*') ? 'active' : '' }}"
                               href="#" role="button">
                                <div class="nav-link-icon">
                                    <i class="fas fa-calculator"></i>
                                </div>
                                النظام المحاسبي
                            </a>
                            <div class="nav-dropdown-menu">
                                <a class="nav-dropdown-item {{ request()->routeIs('accounting.accounts.*') ? 'active' : '' }}"
                                   href="{{ route('accounting.accounts.index') }}">
                                    <i class="fas fa-list-alt"></i>
                                    دليل الحسابات
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('accounting.accounts.tree') ? 'active' : '' }}"
                                   href="{{ route('accounting.accounts.tree') }}">
                                    <i class="fas fa-sitemap"></i>
                                    شجرة الحسابات
                                </a>
                                <div class="nav-divider"></div>
                                <a class="nav-dropdown-item {{ request()->routeIs('accounting.journal-entries.*') ? 'active' : '' }}"
                                   href="{{ route('accounting.journal-entries.index') }}">
                                    <i class="fas fa-book"></i>
                                    قيود اليومية
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('accounting.cash-transactions.*') ? 'active' : '' }}"
                                   href="{{ route('accounting.cash-transactions.index') }}">
                                    <i class="fas fa-coins"></i>
                                    الحركات النقدية
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('accounting.bank-accounts.*') ? 'active' : '' }}"
                                   href="{{ route('accounting.bank-accounts.index') }}">
                                    <i class="fas fa-university"></i>
                                    الحسابات البنكية
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('accounting.bank-transactions.*') ? 'active' : '' }}"
                                   href="{{ route('accounting.bank-transactions.index') }}">
                                    <i class="fas fa-credit-card"></i>
                                    الحركات البنكية
                                </a>
                                <div class="nav-divider"></div>
                                <a class="nav-dropdown-item {{ request()->routeIs('accounting.reports.trial-balance') ? 'active' : '' }}"
                                   href="{{ route('accounting.reports.trial-balance') }}">
                                    <i class="fas fa-balance-scale"></i>
                                    ميزان المراجعة
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('accounting.reports.balance-sheet') ? 'active' : '' }}"
                                   href="{{ route('accounting.reports.balance-sheet') }}">
                                    <i class="fas fa-chart-line"></i>
                                    الميزانية العمومية
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('accounting.reports.income-statement') ? 'active' : '' }}"
                                   href="{{ route('accounting.reports.income-statement') }}">
                                    <i class="fas fa-chart-bar"></i>
                                    قائمة الدخل
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('accounting.reports.general-ledger') ? 'active' : '' }}"
                                   href="{{ route('accounting.reports.general-ledger') }}">
                                    <i class="fas fa-book-open"></i>
                                    دفتر الأستاذ العام
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('accounting.reports.cash-flow') ? 'active' : '' }}"
                                   href="{{ route('accounting.reports.cash-flow') }}">
                                    <i class="fas fa-exchange-alt"></i>
                                    قائمة التدفقات النقدية
                                </a>
                                <div class="nav-divider"></div>
                                <a class="nav-dropdown-item {{ request()->routeIs('accounting.cost-centers.*') ? 'active' : '' }}"
                                   href="{{ route('accounting.cost-centers.index') }}">
                                    <i class="fas fa-project-diagram"></i>
                                    مراكز التكلفة
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- التقارير والتحليلات -->
                    <div class="nav-section">
                        <div class="nav-item nav-dropdown {{ request()->routeIs('system-reports.*') ? 'show' : '' }}">
                            <a class="nav-link nav-dropdown-toggle {{ request()->routeIs('system-reports.*') ? 'active' : '' }}"
                               href="#" role="button">
                                <div class="nav-link-icon">
                                    <i class="fas fa-chart-pie"></i>
                                </div>
                                تقارير النظام
                            </a>
                            <div class="nav-dropdown-menu">
                                <a class="nav-dropdown-item {{ request()->routeIs('system-reports.sales.*') ? 'active' : '' }}"
                                   href="{{ route('system-reports.sales.index') }}">
                                    <i class="fas fa-chart-line"></i>
                                    تقارير المبيعات
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('system-reports.purchase.*') ? 'active' : '' }}"
                                   href="{{ route('system-reports.purchase.index') }}">
                                    <i class="fas fa-shopping-cart"></i>
                                    تقارير المشتريات
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('system-reports.product.*') ? 'active' : '' }}"
                                   href="{{ route('system-reports.product.index') }}">
                                    <i class="fas fa-boxes"></i>
                                    تقارير المنتجات
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('system-reports.customer.*') ? 'active' : '' }}"
                                   href="{{ route('system-reports.customer.index') }}">
                                    <i class="fas fa-users"></i>
                                    تقارير العملاء
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('system-reports.supplier.*') ? 'active' : '' }}"
                                   href="{{ route('system-reports.supplier.index') }}">
                                    <i class="fas fa-truck"></i>
                                    تقارير الموردين
                                </a>
                                <div class="nav-divider"></div>
                                <a class="nav-dropdown-item {{ request()->routeIs('system-reports.tax.*') ? 'active' : '' }}"
                                   href="{{ route('system-reports.tax.index') }}">
                                    <i class="fas fa-receipt"></i>
                                    الإقرارات الضريبية
                                </a>
                                <div class="nav-divider"></div>
                                <a class="nav-dropdown-item {{ request()->routeIs('restaurant.reports.*') ? 'active' : '' }}"
                                   href="{{ route('restaurant.reports.index') }}">
                                    <i class="fas fa-utensils"></i>
                                    تقارير المطعم
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- أدوات النظام -->
                    <div class="nav-section">
                        <div class="nav-item">
                            <a class="nav-link {{ request()->routeIs('file-manager.*') ? 'active' : '' }}"
                               href="{{ route('file-manager.index') }}">
                                <div class="nav-link-icon">
                                    <i class="fas fa-folder-open"></i>
                                </div>
                                إدارة الملفات
                            </a>
                        </div>
                    </div>
                    
                    <!-- إعدادات النظام -->
                    <div class="nav-section">
                        <div class="nav-item nav-dropdown {{ request()->routeIs('companies.*') || request()->routeIs('zatca-settings.*') || request()->routeIs('invoices.sync*') || request()->routeIs('users.*') ? 'show' : '' }}">
                            <a class="nav-link nav-dropdown-toggle {{ request()->routeIs('companies.*') || request()->routeIs('zatca-settings.*') || request()->routeIs('invoices.sync*') || request()->routeIs('users.*') ? 'active' : '' }}"
                               href="#" role="button">
                                <div class="nav-link-icon">
                                    <i class="fas fa-cogs"></i>
                                </div>
                                إعدادات النظام
                            </a>
                            <div class="nav-dropdown-menu">
                                <a class="nav-dropdown-item {{ request()->routeIs('companies.*') ? 'active' : '' }}"
                                   href="{{ route('companies.index') }}">
                                    <i class="fas fa-building"></i>
                                    إدارة الشركة
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('zatca-settings.*') ? 'active' : '' }}"
                                   href="{{ route('zatca-settings.index') }}">
                                    <i class="fas fa-cog"></i>
                                    إعدادات ZATCA
                                </a>
                                <a class="nav-dropdown-item {{ request()->routeIs('invoices.sync*') ? 'active' : '' }}"
                                   href="{{ route('invoices.sync') }}">
                                    <i class="fas fa-sync-alt"></i>
                                    مزامنة ZATCA
                                </a>
                                @if(auth()->user() && auth()->user()->isAdmin())
                                <div class="nav-divider"></div>
                                <a class="nav-dropdown-item {{ request()->routeIs('users.*') ? 'active' : '' }}"
                                   href="{{ route('users.index') }}">
                                    <i class="fas fa-users-cog"></i>
                                    إدارة المستخدمين
                                </a>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Clean User Section -->
                <div class="user-section">
                    <div class="user-info">
                        <div class="user-avatar">
                            <i class="fas fa-user"></i>
                        </div>
                        <div class="user-greeting">مرحباً،</div>
                        <div class="user-name">{{ auth()->user()->name ?? 'المستخدم' }}</div>
                        <div class="user-role">{{ auth()->user()->role_name ?? 'المستخدم' }}</div>
                    </div>
                    
                    <button type="button" class="logout-btn" data-bs-toggle="modal" data-bs-target="#logoutModal">
                        <i class="fas fa-sign-out-alt"></i>
                        تسجيل الخروج
                    </button>
                </div>
            </div>
        </aside>
        
        <!-- Main Content -->
        <div class="main-content">
            <!-- Clean Header -->
            <div class="top-navbar">
                <div class="navbar-left">
                    <button class="mobile-toggle" type="button" id="sidebarToggle">
                        <i class="fas fa-bars"></i>
                    </button>
                    <div>
                        <h1 class="page-title">@yield('page-title', 'لوحة التحكم')</h1>
                        <div class="page-breadcrumb">@yield('breadcrumb')</div>
                    </div>
                </div>
                <div class="navbar-right">
                    <button class="btn btn-outline-secondary theme-toggle" id="themeToggle">
                        <i class="fas fa-moon"></i>
                    </button>
                    <div class="navbar-actions">@yield('page-actions')</div>
                </div>
            </div>
            
            <div class="content-wrapper">
                <!-- Clean Alerts -->
                @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show slide-in" role="alert">
                    <i class="fas fa-check-circle"></i>
                    <div>{{ session('success') }}</div>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                @endif
                
                @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show slide-in" role="alert">
                    <i class="fas fa-exclamation-circle"></i>
                    <div>{{ session('error') }}</div>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                @endif
                
                @if(session('warning'))
                <div class="alert alert-warning alert-dismissible fade show slide-in" role="alert">
                    <i class="fas fa-exclamation-triangle"></i>
                    <div>{{ session('warning') }}</div>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                @endif
                
                <!-- Page Content -->
                <div class="fade-in">
                    @yield('content')
                </div>
            </div>
        </div>
    </div>
    
    <!-- Mobile Sidebar Backdrop -->
    <div class="sidebar-backdrop" id="sidebarBackdrop"></div>
    
    <!-- Clean Logout Modal -->
    <div class="modal fade" id="logoutModal" tabindex="-1" aria-labelledby="logoutModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="logoutModalLabel">
                        <i class="fas fa-sign-out-alt me-2"></i>تأكيد تسجيل الخروج
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body text-center">
                    <div class="mb-3">
                        <i class="fas fa-question-circle text-warning" style="font-size: 3rem;"></i>
                    </div>
                    <h6 class="mb-3">هل أنت متأكد من رغبتك في تسجيل الخروج؟</h6>
                    <p class="text-muted mb-0">سيتم إنهاء جلستك وإعادة توجيهك إلى صفحة تسجيل الدخول</p>
                </div>
                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times me-2"></i>إلغاء
                    </button>
                    <form method="POST" action="{{ route('logout') }}" class="d-inline">
                        @csrf
                        <button type="submit" class="btn btn-danger">
                            <i class="fas fa-sign-out-alt me-2"></i>تسجيل الخروج
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Enhanced Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js" crossorigin="anonymous"></script>
    
    <!-- Clean JavaScript -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Clean sidebar dropdown management
            const sidebarDropdowns = document.querySelectorAll('.nav-dropdown');
            
            sidebarDropdowns.forEach(dropdown => {
                const toggle = dropdown.querySelector('.nav-dropdown-toggle');
                if (toggle) {
                    toggle.addEventListener('click', function(e) {
                        e.preventDefault();
                        
                        // Close other dropdowns
                        sidebarDropdowns.forEach(otherDropdown => {
                            if (otherDropdown !== dropdown) {
                                otherDropdown.classList.remove('show');
                            }
                        });
                        
                        // Toggle current dropdown
                        dropdown.classList.toggle('show');
                    });
                }
            });
            
            // Clean mobile sidebar toggle
            const sidebarToggle = document.getElementById('sidebarToggle');
            const sidebar = document.getElementById('sidebar');
            const sidebarBackdrop = document.getElementById('sidebarBackdrop');
            
            if (sidebarToggle && sidebar && sidebarBackdrop) {
                function toggleSidebar() {
                    const isOpen = sidebar.classList.contains('show');
                    
                    if (!isOpen) {
                        sidebar.classList.add('show');
                        sidebarBackdrop.classList.add('show');
                        document.body.style.overflow = 'hidden';
                    } else {
                        closeSidebar();
                    }
                }
                
                function closeSidebar() {
                    sidebar.classList.remove('show');
                    sidebarBackdrop.classList.remove('show');
                    document.body.style.overflow = '';
                }
                
                sidebarToggle.addEventListener('click', toggleSidebar);
                sidebarBackdrop.addEventListener('click', closeSidebar);
                
                // Close sidebar when clicking outside on mobile
                document.addEventListener('click', (e) => {
                    if (window.innerWidth <= 768) {
                        if (!sidebar.contains(e.target) && !sidebarToggle.contains(e.target)) {
                            closeSidebar();
                        }
                    }
                });
                
                // Close sidebar on escape key
                document.addEventListener('keydown', (e) => {
                    if (e.key === 'Escape' && sidebar.classList.contains('show')) {
                        closeSidebar();
                    }
                });
                
                // Handle window resize
                window.addEventListener('resize', () => {
                    if (window.innerWidth > 768) {
                        closeSidebar();
                    }
                });
            }
            
            // Clean theme toggle
            const themeToggle = document.getElementById('themeToggle');
            const html = document.documentElement;
            
            if (themeToggle) {
                // Load saved theme
                const savedTheme = localStorage.getItem('theme') || 'light';
                html.setAttribute('data-theme', savedTheme);
                updateThemeIcon(savedTheme);
                
                themeToggle.addEventListener('click', () => {
                    const currentTheme = html.getAttribute('data-theme');
                    const newTheme = currentTheme === 'light' ? 'dark' : 'light';
                    
                    html.setAttribute('data-theme', newTheme);
                    localStorage.setItem('theme', newTheme);
                    updateThemeIcon(newTheme);
                });
            }
            
            function updateThemeIcon(theme) {
                const icon = themeToggle.querySelector('i');
                icon.className = theme === 'light' ? 'fas fa-moon' : 'fas fa-sun';
            }
            
            // Clean alert auto-dismiss
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(alert => {
                setTimeout(() => {
                    if (alert.parentNode) {
                        const bsAlert = new bootstrap.Alert(alert);
                        bsAlert.close();
                    }
                }, 5000);
            });
            
            // Clean navigation highlighting
            const currentPath = window.location.pathname;
            document.querySelectorAll('.nav-link, .nav-dropdown-item').forEach(link => {
                if (link.getAttribute('href') === currentPath) {
                    link.classList.add('active');
                    
                    // Open parent dropdown if nested
                    const parentDropdown = link.closest('.nav-dropdown');
                    if (parentDropdown) parentDropdown.classList.add('show');
                }
            });
        });
    </script>
    
    @stack('scripts')
</body>
</html>