<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>التحقق من الفاتورة {{ $invoice->invoice_number }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@200;300;400;500;700;800;900&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Tajawal', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            direction: rtl;
        }
        
        .verification-container {
            padding: 20px 0;
        }
        
        .verification-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
            overflow: hidden;
            margin: 20px 0;
        }
        
        .verification-header {
            background: linear-gradient(135deg, #28a745, #20c997);
            color: white;
            padding: 30px;
            text-align: center;
        }
        
        .verification-icon {
            font-size: 60px;
            margin-bottom: 15px;
        }
        
        .verification-title {
            font-size: 28px;
            font-weight: bold;
            margin-bottom: 10px;
        }
        
        .verification-subtitle {
            font-size: 16px;
            opacity: 0.9;
        }
        
        .invoice-details {
            padding: 40px;
        }
        
        .company-section {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 2px solid #f8f9fa;
        }
        
        .company-name {
            font-size: 32px;
            font-weight: 900;
            color: #007bff;
            margin-bottom: 10px;
        }
        
        .company-vat {
            font-size: 18px;
            color: #6c757d;
            margin-bottom: 5px;
        }
        
        .invoice-info {
            background: #f8f9fa;
            border-radius: 15px;
            padding: 25px;
            margin-bottom: 30px;
        }
        
        .info-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 12px 0;
            border-bottom: 1px solid #e9ecef;
        }
        
        .info-row:last-child {
            border-bottom: none;
        }
        
        .info-label {
            font-weight: 600;
            color: #495057;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .info-value {
            font-weight: 500;
            color: #333;
        }
        
        .status-badge {
            display: inline-flex;
            align-items: center;
            gap: 5px;
            padding: 8px 15px;
            border-radius: 25px;
            font-size: 14px;
            font-weight: bold;
            color: white;
        }
        
        .status-valid {
            background: linear-gradient(135deg, #28a745, #20c997);
        }
        
        .status-draft {
            background: linear-gradient(135deg, #6c757d, #545b62);
        }
        
        .customer-section {
            background: #e3f2fd;
            border-radius: 15px;
            padding: 25px;
            margin-bottom: 30px;
        }
        
        .section-title {
            font-size: 20px;
            font-weight: bold;
            color: #007bff;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .total-section {
            background: linear-gradient(135deg, #007bff, #0056b3);
            color: white;
            border-radius: 20px;
            padding: 30px;
            text-align: center;
            margin-bottom: 30px;
        }
        
        .total-label {
            font-size: 18px;
            opacity: 0.9;
            margin-bottom: 10px;
        }
        
        .total-amount {
            font-size: 36px;
            font-weight: 900;
            margin-bottom: 5px;
        }
        
        .verification-footer {
            background: #f8f9fa;
            padding: 25px;
            text-align: center;
            color: #6c757d;
            font-size: 14px;
        }
        
        .verification-time {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 10px;
            padding: 15px;
            margin-top: 20px;
            text-align: center;
            color: #856404;
        }
        
        @media (max-width: 768px) {
            .verification-container {
                padding: 10px;
            }
            
            .invoice-details {
                padding: 20px;
            }
            
            .company-name {
                font-size: 24px;
            }
            
            .total-amount {
                font-size: 28px;
            }
        }
    </style>
</head>
<body>
    <div class="container verification-container">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-xl-6">
                <div class="verification-card">
                    <!-- رأس التحقق -->
                    <div class="verification-header">
                        <div class="verification-icon">
                            <i class="fas fa-check-circle"></i>
                        </div>
                        <div class="verification-title">فاتورة صالحة ومعتمدة</div>
                        <div class="verification-subtitle">تم التحقق من صحة الفاتورة بنجاح</div>
                    </div>
                    
                    <!-- تفاصيل الفاتورة -->
                    <div class="invoice-details">
                        <!-- معلومات الشركة -->
                        <div class="company-section">
                            <div class="company-name">{{ $invoice->company->name }}</div>
                            <div class="company-vat">الرقم الضريبي: {{ $invoice->company->vat_number }}</div>
                            @if($invoice->company->cr_number)
                                <div class="company-vat">السجل التجاري: {{ $invoice->company->cr_number }}</div>
                            @endif
                        </div>
                        
                        <!-- معلومات الفاتورة -->
                        <div class="invoice-info">
                            <div class="info-row">
                                <div class="info-label">
                                    <i class="fas fa-file-invoice"></i>
                                    رقم الفاتورة
                                </div>
                                <div class="info-value">{{ $invoice->invoice_number }}</div>
                            </div>
                            
                            <div class="info-row">
                                <div class="info-label">
                                    <i class="fas fa-tag"></i>
                                    نوع الفاتورة
                                </div>
                                <div class="info-value">
                                    @if($invoice->type == 'standard')
                                        فاتورة ضريبية معيارية
                                    @else
                                        فاتورة ضريبية مبسطة
                                    @endif
                                </div>
                            </div>
                            
                            <div class="info-row">
                                <div class="info-label">
                                    <i class="fas fa-calendar"></i>
                                    تاريخ الإصدار
                                </div>
                                <div class="info-value">{{ $invoice->issue_date->format('Y-m-d') }}</div>
                            </div>
                            
                            @if($invoice->due_date)
                            <div class="info-row">
                                <div class="info-label">
                                    <i class="fas fa-clock"></i>
                                    تاريخ الاستحقاق
                                </div>
                                <div class="info-value">{{ $invoice->due_date->format('Y-m-d') }}</div>
                            </div>
                            @endif
                            
                            <div class="info-row">
                                <div class="info-label">
                                    <i class="fas fa-info-circle"></i>
                                    حالة الفاتورة
                                </div>
                                <div class="info-value">
                                    @switch($invoice->status)
                                        @case('cleared')
                                            <span class="status-badge status-valid">
                                                <i class="fas fa-check"></i>
                                                (قياسية)
                                            </span>
                                            @break
                                        @case('reported')
                                            <span class="status-badge status-valid">
                                                <i class="fas fa-paper-plane"></i>
                                                مبلغة
                                            </span>
                                            @break
                                        @case('draft')
                                            <span class="status-badge status-draft">
                                                <i class="fas fa-edit"></i>
                                                مسودة
                                            </span>
                                            @break
                                        @default
                                            <span class="status-badge status-draft">
                                                {{ $invoice->status }}
                                            </span>
                                    @endswitch
                                </div>
                            </div>
                            
                            @if($invoice->uuid)
                            <div class="info-row">
                                <div class="info-label">
                                    <i class="fas fa-fingerprint"></i>
                                    معرف الفاتورة
                                </div>
                                <div class="info-value">
                                    <small>{{ $invoice->uuid }}</small>
                                </div>
                            </div>
                            @endif
                        </div>
                        
                        <!-- معلومات العميل -->
                        @if($invoice->customer)
                        <div class="customer-section">
                            <div class="section-title">
                                <i class="fas fa-user"></i>
                                معلومات العميل
                            </div>
                            
                            <div class="info-row">
                                <div class="info-label">الاسم</div>
                                <div class="info-value">{{ $invoice->customer->name }}</div>
                            </div>
                            
                            @if($invoice->customer->customer_type == 'business' && $invoice->customer->vat_number)
                                <div class="info-row">
                                    <div class="info-label">الرقم الضريبي</div>
                                    <div class="info-value">{{ $invoice->customer->vat_number }}</div>
                                </div>
                            @endif
                            
                            @if($invoice->customer->customer_type == 'individual' && $invoice->customer->national_id)
                                <div class="info-row">
                                    <div class="info-label">الهوية الوطنية</div>
                                    <div class="info-value">{{ $invoice->customer->national_id }}</div>
                                </div>
                            @endif
                        </div>
                        @endif
                        
                        <!-- المبلغ الإجمالي -->
                        <div class="total-section">
                            <div class="total-label">المبلغ الإجمالي شامل الضريبة</div>
                            <div class="total-amount">{{ number_format($invoice->total_amount, 2) }} ر.س</div>
                            <small>الضريبة: {{ number_format($invoice->tax_amount, 2) }} ر.س</small>
                        </div>
                        
                        <!-- معلومات ZATCA إذا كانت متوفرة -->
                        @if($invoice->sent_to_zatca_at)
                        <div class="alert alert-success" role="alert">
                            <h6 class="alert-heading">
                                <i class="fas fa-shield-alt me-2"></i>
                                تم الإبلاغ لهيئة الزكاة والضريبة والجمارك
                            </h6>
                            <p class="mb-0">
                                تاريخ الإرسال: {{ $invoice->sent_to_zatca_at->format('Y-m-d H:i:s') }}
                            </p>
                        </div>
                        @endif
                    </div>
                    
                    <!-- تذييل التحقق -->
                    <div class="verification-footer">
                        <div>
                            <strong>هذه الفاتورة معتمدة ومتوافقة مع متطلبات هيئة الزكاة والضريبة والجمارك</strong>
                        </div>
                        <div class="verification-time">
                            <i class="fas fa-clock me-2"></i>
                            تم التحقق في: {{ now()->format('Y-m-d H:i:s') }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>