<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>فاتورة حرارية - {{ $invoice->invoice_number }}</title>
    <style>
        /* إعدادات الطباعة الحرارية */
        @page {
            size: 80mm auto;
            margin: 0;
            padding: 0;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Courier New', 'Monaco', monospace;
            font-size: 11px;
            line-height: 1.2;
            color: #000;
            background: #fff;
            width: 80mm;
            margin: 0 auto;
            padding: 2mm;
            direction: rtl;
            text-align: right;
        }

        /* عرض 58mm للطابعات الصغيرة */
        @media print and (max-width: 58mm) {
            body {
                width: 58mm;
                font-size: 9px;
                padding: 1mm;
            }
        }

        /* أنماط النصوص */
        .center { text-align: center; }
        .left { text-align: left; }
        .right { text-align: right; }
        .bold { font-weight: bold; }
        .large { font-size: 14px; line-height: 1.3; }
        .medium { font-size: 12px; }
        .small { font-size: 9px; }

        /* رأس الفاتورة */
        .header {
            text-align: center;
            margin-bottom: 3mm;
            border-bottom: 1px dashed #000;
            padding-bottom: 2mm;
        }

        .company-name {
            font-size: 16px;
            font-weight: bold;
            margin-bottom: 1mm;
        }

        .company-name-en {
            font-size: 14px;
            margin-bottom: 1mm;
            font-style: italic;
        }

        .company-details {
            font-size: 9px;
            line-height: 1.1;
        }

        .invoice-type {
            font-size: 12px;
            font-weight: bold;
            margin: 2mm 0;
            padding: 1mm;
            border: 1px solid #000;
            text-align: center;
        }

        /* معلومات الفاتورة */
        .invoice-info {
            margin: 2mm 0;
            font-size: 10px;
            border: 1px solid #000;
            padding: 2mm;
            background: #f9f9f9;
        }

        .info-table {
            width: 100%;
            border-collapse: collapse;
        }

        .info-table td {
            padding: 1mm 2mm;
            border-bottom: 1px dotted #ccc;
        }

        .info-table td:first-child {
            text-align: right;
            font-weight: bold;
            width: 50%;
        }

        .info-table td:last-child {
            text-align: left;
            font-family: 'Courier New', monospace;
        }

        /* معلومات العميل */
        .customer-info {
            margin: 2mm 0;
            border: 1px solid #000;
            padding: 2mm;
            font-size: 10px;
            background: #f5f5f5;
        }

        .customer-title {
            text-align: center;
            font-weight: bold;
            margin-bottom: 2mm;
            padding-bottom: 1mm;
            border-bottom: 1px solid #000;
        }

        /* جدول العناصر */
        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin: 2mm 0;
            font-size: 9px;
            border: 1px solid #000;
        }

        .items-table th {
            border-bottom: 2px solid #000;
            border-top: 1px solid #000;
            border-left: 1px solid #000;
            border-right: 1px solid #000;
            padding: 2mm 1mm;
            font-weight: bold;
            text-align: center;
            background: #f0f0f0;
        }

        .items-table td {
            padding: 2mm 1mm;
            border-bottom: 1px solid #ccc;
            border-left: 1px solid #ccc;
            border-right: 1px solid #ccc;
            text-align: center;
            vertical-align: top;
        }

        .item-desc {
            text-align: right;
            word-wrap: break-word;
            border-right: 1px solid #000;
        }

        .item-qty, .item-price, .item-total {
            text-align: center;
            font-family: 'Courier New', monospace;
        }

        .item-total {
            font-weight: bold;
            border-left: 1px solid #000;
        }

        /* الإجماليات */
        .totals {
            margin: 2mm 0;
            border: 1px solid #000;
            padding: 2mm;
            font-size: 10px;
            background: #f9f9f9;
        }

        .totals-table {
            width: 100%;
            border-collapse: collapse;
        }

        .totals-table td {
            padding: 1mm 2mm;
            border-bottom: 1px dotted #ccc;
        }

        .totals-table td:first-child {
            text-align: right;
            font-weight: bold;
        }

        .totals-table td:last-child {
            text-align: left;
            font-family: 'Courier New', monospace;
        }

        .grand-total-row td {
            border-top: 2px solid #000;
            border-bottom: 2px solid #000;
            font-weight: bold;
            font-size: 12px;
            padding: 2mm;
            background: #e0e0e0;
        }

        /* المبلغ بالحروف */
        .amount-words {
            margin: 2mm 0;
            border: 1px dashed #000;
            padding: 2mm;
            font-size: 9px;
            text-align: center;
        }

        /* QR Code */
        .qr-section {
            text-align: center;
            margin: 3mm 0;
            border-top: 1px dashed #000;
            padding-top: 2mm;
        }

        .qr-code {
            margin: 2mm auto;
            max-width: 55mm;
            height: 55mm;
            border: 1px solid #000;
        }

        .qr-title {
            font-size: 10px;
            margin-bottom: 2mm;
            font-weight: bold;
        }

        /* الملاحظات */
        .notes {
            margin: 2mm 0;
            border-top: 1px dashed #000;
            padding-top: 2mm;
            font-size: 9px;
        }

        /* التذييل */
        .footer {
            margin-top: 3mm;
            border-top: 1px double #000;
            padding-top: 2mm;
            text-align: center;
            font-size: 8px;
        }

        .footer-line {
            margin-bottom: 1mm;
        }

        /* خط فاصل */
        .divider {
            border-top: 1px dashed #000;
            margin: 2mm 0;
        }

        .thick-divider {
            border-top: 2px solid #000;
            margin: 3mm 0;
        }

        /* أنماط الطباعة */
        @media print {
            .no-print { display: none !important; }
            
            body {
                width: 80mm;
                margin: 0;
                padding: 1mm;
            }

            .page-break {
                page-break-before: always;
            }
        }

        /* أنماط لعرض 58mm */
        @media (max-width: 58mm) {
            body { width: 58mm; font-size: 8px; }
            .company-name { font-size: 12px; }
            .company-name-en { font-size: 10px; }
            .invoice-type { font-size: 10px; }
            .items-table { font-size: 8px; }
            .qr-code { max-width: 20mm; height: 20mm; }
        }

        /* أنماط للشاشة */
        @media screen {
            body {
                box-shadow: 0 0 10px rgba(0,0,0,0.1);
                max-width: 80mm;
                margin: 20px auto;
                background: white;
            }
        }

        /* أزرار التحكم للشاشة فقط */
        .control-buttons {
            position: fixed;
            top: 10px;
            left: 10px;
            z-index: 1000;
            display: flex;
            gap: 5px;
        }

        .control-buttons button {
            padding: 5px 10px;
            border: 1px solid #000;
            background: #fff;
            cursor: pointer;
            font-size: 12px;
            border-radius: 3px;
        }

        .control-buttons button:hover {
            background: #000;
            color: #fff;
        }

        /* تحسينات للنص العربي */
        .arabic-text {
            font-family: 'Arial', 'Tahoma', sans-serif;
            font-size: 10px;
        }

        /* نمط للأرقام */
        .number {
            font-family: 'Courier New', monospace;
            font-weight: bold;
        }

        /* خاص بالعملة */
        .currency {
            font-family: 'Courier New', monospace;
        }

        /* تنسيق خاص للطابعات ESC/POS */
        .esc-pos-bold {
            font-weight: bold;
            text-decoration: underline;
        }

        .esc-pos-center {
            text-align: center;
            font-weight: bold;
        }

        .esc-pos-large {
            font-size: 14px;
            font-weight: bold;
            letter-spacing: 1px;
        }
    </style>
</head>

<body>
    <!-- أزرار التحكم (للشاشة فقط) -->
    <div class="control-buttons no-print">
        <button onclick="window.print()">🖨️ طباعة</button>
        <button onclick="window.close()">❌ إغلاق</button>
        <button onclick="window.location.href='{{ route('invoices.create') }}'">🏪 POS</button>
    </div>

    <!-- رأس الفاتورة -->
    <div class="header">
        <div class="company-name esc-pos-large">{{ $invoice->company->name ?? 'اسم الشركة' }}</div>
        @if($invoice->company && $invoice->company->name_en)
            <div class="company-name-en">{{ $invoice->company->name_en }}</div>
        @endif
        
        <div class="company-details arabic-text">
            @if($invoice->company)
                @if($invoice->company->vat_number)
                    <div>ض.ب: {{ $invoice->company->vat_number }}</div>
                @endif
                @if($invoice->company->cr_number)
                    <div>س.ت: {{ $invoice->company->cr_number }}</div>
                @endif
                @if($invoice->company->phone)
                    <div>ت: {{ $invoice->company->phone }}</div>
                @endif
                @if($invoice->company->email)
                    <div class="small">{{ $invoice->company->email }}</div>
                @endif
                <div class="small">{{ $invoice->company->getFullAddressAttribute() }}</div>
            @endif
        </div>
    </div>

    <!-- نوع الفاتورة -->
    <div class="invoice-type esc-pos-center">
        @if($invoice->type == 'standard')
            فاتورة ضريبية
        @else
            فاتورة ضريبية مبسطة
        @endif
    </div>

    <!-- معلومات الفاتورة -->
    <div class="invoice-info">
        <table class="info-table">
            <tr>
                <td>رقم الفاتورة:</td>
                <td class="number">{{ $invoice->invoice_number }}</td>
            </tr>
            <tr>
                <td>التاريخ:</td>
                <td class="number">{{ $invoice->issue_date->format('Y-m-d') }}</td>
            </tr>
            <tr>
                <td>الوقت:</td>
                <td class="number">{{ $invoice->issue_date->format('H:i') }}</td>
            </tr>
            @if($invoice->supply_date && $invoice->supply_date != $invoice->issue_date)
            <tr>
                <td>تاريخ التوريد:</td>
                <td class="number">{{ $invoice->supply_date->format('Y-m-d') }}</td>
            </tr>
            @endif
        </table>
    </div>

    <!-- معلومات العميل -->
    @if($invoice->customer)
    <div class="customer-info arabic-text">
        <div class="customer-title">معلومات العميل</div>
        <table class="info-table">
            <tr>
                <td>الاسم:</td>
                <td>{{ $invoice->customer->name }}</td>
            </tr>
            @if($invoice->customer->vat_number)
            <tr>
                <td>الرقم الضريبي:</td>
                <td class="number">{{ $invoice->customer->vat_number }}</td>
            </tr>
            @endif
            @if($invoice->customer->phone)
            <tr>
                <td>الهاتف:</td>
                <td class="number">{{ $invoice->customer->phone }}</td>
            </tr>
            @endif
        </table>
    </div>
    @endif

    <div class="divider"></div>

    <!-- جدول العناصر -->
    <table class="items-table">
        <thead>
            <tr>
                <th style="width: 40%;">البيان</th>
                <th style="width: 15%;">الكمية</th>
                <th style="width: 20%;">السعر</th>
                <th style="width: 25%;">المجموع</th>
            </tr>
        </thead>
        <tbody>
            @foreach($invoice->items as $index => $item)
            <tr>
                <td class="item-desc arabic-text">
                    <div class="bold">{{ $item->name }}</div>
                    @if($item->description)
                        <div class="small">{{ $item->description }}</div>
                    @endif
                    @if($item->sku)
                        <div class="small">كود: {{ $item->sku }}</div>
                    @endif
                </td>
                <td class="item-qty number">{{ number_format($item->quantity, 0) }}</td>
                <td class="item-price number currency">{{ number_format($item->unit_price, 2) }}</td>
                <td class="item-total number currency bold">{{ number_format($item->total_with_tax, 2) }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="thick-divider"></div>

    <!-- الإجماليات -->
    <div class="totals">
        <table class="totals-table">
            <tr>
                <td>المجموع قبل الضريبة:</td>
                <td class="number currency">{{ number_format($invoice->subtotal, 2) }} ر.س</td>
            </tr>
            
            @if($invoice->discount_amount > 0)
            <tr>
                <td>الخصم:</td>
                <td class="number currency">- {{ number_format($invoice->discount_amount, 2) }} ر.س</td>
            </tr>
            @endif
            
            <tr>
                <td>ضريبة القيمة المضافة (15%):</td>
                <td class="number currency">{{ number_format($invoice->tax_amount, 2) }} ر.س</td>
            </tr>
            
            <tr class="grand-total-row esc-pos-bold">
                <td>الإجمالي:</td>
                <td class="number currency">{{ number_format($invoice->total_amount, 2) }} ر.س</td>
            </tr>

            @if($invoice->paid_amount > 0)
            <tr>
                <td>المدفوع:</td>
                <td class="number currency">{{ number_format($invoice->paid_amount, 2) }} ر.س</td>
            </tr>
            @endif

            @if($invoice->remaining_amount > 0)
            <tr>
                <td>المتبقي:</td>
                <td class="number currency">{{ number_format($invoice->remaining_amount, 2) }} ر.س</td>
            </tr>
            @endif
        </table>
    </div>

    <!-- المبلغ بالحروف -->
    <div class="amount-words arabic-text">
        <div class="small bold center">المبلغ بالحروف</div>
        <div class="center">
            {{ \App\Helpers\ArabicNumberToWords::convert($invoice->total_amount, 'ريال سعودي', 'هللة') }}
        </div>
    </div>

    <div class="divider"></div>

    <!-- QR Code -->
    @if($invoice->qr_code)
    <div class="qr-section">
        <div class="qr-title">رمز التحقق الإلكتروني</div>
        <img src="{{ $invoice->getQrCodeDataUrl() }}" alt="QR Code" class="qr-code">
        <div class="small">امسح الرمز للتحقق من الفاتورة</div>
    </div>
    @endif

    <!-- الملاحظات -->
    @if($invoice->notes)
    <div class="notes arabic-text">
        <div class="bold">ملاحظات:</div>
        <div>{{ $invoice->notes }}</div>
    </div>
    @endif

    <!-- معلومات الدفع -->
    @if($invoice->payment_method)
    <div class="divider"></div>
    <div class="invoice-info">
        <table class="info-table">
            <tr>
                <td>طريقة الدفع:</td>
                <td>
                    @switch($invoice->payment_method)
                        @case('cash') نقداً @break
                        @case('credit_card') بطاقة ائتمان @break
                        @case('bank_transfer') تحويل بنكي @break
                        @case('check') شيك @break
                        @default {{ $invoice->payment_method }}
                    @endswitch
                </td>
            </tr>
            @if($invoice->payment_date)
            <tr>
                <td>تاريخ الدفع:</td>
                <td class="number">{{ $invoice->payment_date->format('Y-m-d H:i') }}</td>
            </tr>
            @endif
        </table>
    </div>
    @endif

    <div class="thick-divider"></div>

    <!-- التذييل -->
    <div class="footer">
        <div class="footer-line bold">شكراً لتعاملكم معنا</div>
        <div class="footer-line small">تم إنشاء هذه الفاتورة إلكترونياً</div>
        <div class="footer-line small">{{ $invoice->company->name ?? 'اسم الشركة' }}</div>
        <div class="footer-line small">{{ now()->setTimezone('Asia/Riyadh')->format('Y-m-d H:i:s') }}</div>
        @if($invoice->user)
            <div class="footer-line small">كاشير: {{ $invoice->user->name }}</div>
        @endif
    </div>

    <script>
        // طباعة تلقائية عند فتح الصفحة
        window.addEventListener('load', function() {
            // تأخير صغير للسماح بتحميل المحتوى
            setTimeout(function() {
                // التحقق من معامل الطباعة التلقائية
                const urlParams = new URLSearchParams(window.location.search);
                if (urlParams.get('auto_print') === '1') {
                    window.print();
                }
            }, 500);
        });

        // دالة للتبديل بين أحجام الطابعات
        function switchPrinterSize(size) {
            const body = document.body;
            if (size === '58mm') {
                body.style.width = '58mm';
                body.style.fontSize = '8px';
            } else {
                body.style.width = '80mm';
                body.style.fontSize = '11px';
            }
        }

        // إضافة دعم لاختصارات لوحة المفاتيح
        document.addEventListener('keydown', function(e) {
            if (e.ctrlKey && e.key === 'p') {
                e.preventDefault();
                window.print();
            }
            if (e.key === 'Escape') {
                window.close();
            }
        });

        // دعم الطباعة عبر ESC/POS إذا كان متاحاً
        if (typeof window.qz !== 'undefined') {
            // يمكن إضافة دعم QZ Tray للطباعة المباشرة هنا
            console.log('QZ Tray detected - direct printing available');
        }
    </script>
</body>
</html>