@extends('layouts.app')

@section('title', 'اختبار XML - الفاتورة ' . $invoice->invoice_number)

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-code"></i>
                        اختبار XML المحسن - الفاتورة {{ $invoice->invoice_number }}
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('invoices.show', $invoice) }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> العودة
                        </a>
                        <a href="{{ route('invoices.ubl-xml', $invoice) }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-download"></i> تحميل XML
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- نتائج التحقق -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card border-{{ $validation['is_valid'] ? 'success' : 'danger' }}">
                                <div class="card-header bg-{{ $validation['is_valid'] ? 'success' : 'danger' }} text-white">
                                    <h5 class="mb-0">
                                        <i class="fas fa-{{ $validation['is_valid'] ? 'check-circle' : 'times-circle' }}"></i>
                                        نتيجة التحقق العامة
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <h4 class="text-{{ $validation['is_valid'] ? 'success' : 'danger' }}">
                                        {{ $validation['is_valid'] ? 'مطابق للمعايير' : 'غير مطابق للمعايير' }}
                                    </h4>
                                    <p class="mb-0">
                                        <strong>الأخطاء:</strong> {{ count($validation['errors']) }}<br>
                                        <strong>التحذيرات:</strong> {{ count($validation['warnings']) }}
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card border-info">
                                <div class="card-header bg-info text-white">
                                    <h5 class="mb-0">
                                        <i class="fas fa-info-circle"></i>
                                        معلومات XML
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <p class="mb-1"><strong>الحجم:</strong> {{ $xml_structure['size_kb'] }} كيلوبايت</p>
                                    <p class="mb-1"><strong>عدد الأسطر:</strong> {{ $xml_structure['lines'] }}</p>
                                    <p class="mb-1"><strong>التوقيع الرقمي:</strong> {{ $xml_structure['has_signature'] ? 'موجود' : 'غير موجود' }}</p>
                                    <p class="mb-0"><strong>الامتدادات:</strong> {{ $xml_structure['has_extensions'] ? 'موجودة' : 'غير موجودة' }}</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- الأخطاء -->
                    @if(count($validation['errors']) > 0)
                    <div class="alert alert-danger">
                        <h5><i class="fas fa-exclamation-triangle"></i> الأخطاء التي يجب إصلاحها:</h5>
                        <ul class="mb-0">
                            @foreach($validation['errors'] as $error)
                            <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    <!-- التحذيرات -->
                    @if(count($validation['warnings']) > 0)
                    <div class="alert alert-warning">
                        <h5><i class="fas fa-exclamation-circle"></i> التحذيرات:</h5>
                        <ul class="mb-0">
                            @foreach($validation['warnings'] as $warning)
                            <li>{{ $warning }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    <!-- تفاصيل الفحوصات -->
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5><i class="fas fa-list-check"></i> تفاصيل الفحوصات</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <!-- البنية الأساسية -->
                                        <div class="col-md-6 mb-3">
                                            <h6><i class="fas fa-code"></i> البنية الأساسية</h6>
                                            <div class="badge badge-{{ $validation['checks']['basic_structure']['passed'] ? 'success' : 'danger' }}">
                                                {{ $validation['checks']['basic_structure']['passed'] ? 'مطابق' : 'غير مطابق' }}
                                            </div>
                                        </div>

                                        <!-- العناصر المطلوبة -->
                                        <div class="col-md-6 mb-3">
                                            <h6><i class="fas fa-list"></i> العناصر المطلوبة</h6>
                                            <div class="badge badge-{{ $validation['checks']['required_elements']['passed'] ? 'success' : 'danger' }}">
                                                {{ $validation['checks']['required_elements']['passed'] ? 'مطابق' : 'غير مطابق' }}
                                            </div>
                                        </div>

                                        <!-- توزيع الضريبة -->
                                        <div class="col-md-6 mb-3">
                                            <h6><i class="fas fa-calculator"></i> توزيع الضريبة (BG-23)</h6>
                                            <div class="badge badge-{{ $validation['checks']['vat_breakdown']['passed'] ? 'success' : 'danger' }}">
                                                {{ $validation['checks']['vat_breakdown']['passed'] ? 'مطابق' : 'غير مطابق' }}
                                            </div>
                                        </div>

                                        <!-- QR Code -->
                                        <div class="col-md-6 mb-3">
                                            <h6><i class="fas fa-qrcode"></i> QR Code</h6>
                                            <div class="badge badge-{{ $validation['checks']['qr_code']['passed'] ? 'success' : 'danger' }}">
                                                {{ $validation['checks']['qr_code']['passed'] ? 'مطابق' : 'غير مطابق' }}
                                            </div>
                                        </div>

                                        <!-- رمز الفاتورة -->
                                        <div class="col-md-6 mb-3">
                                            <h6><i class="fas fa-barcode"></i> رمز الفاتورة (KSA-2)</h6>
                                            <div class="badge badge-{{ $validation['checks']['invoice_code']['passed'] ? 'success' : 'danger' }}">
                                                {{ $validation['checks']['invoice_code']['passed'] ? 'مطابق' : 'غير مطابق' }}
                                            </div>
                                        </div>

                                        <!-- عداد الفاتورة -->
                                        <div class="col-md-6 mb-3">
                                            <h6><i class="fas fa-counter"></i> عداد الفاتورة (KSA-16)</h6>
                                            <div class="badge badge-{{ $validation['checks']['invoice_counter']['passed'] ? 'success' : 'danger' }}">
                                                {{ $validation['checks']['invoice_counter']['passed'] ? 'مطابق' : 'غير مطابق' }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- معلومات QR Code -->
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5><i class="fas fa-qrcode"></i> معلومات QR Code</h5>
                                </div>
                                <div class="card-body">
                                    <p><strong>المرحلة:</strong> Phase {{ $qr_code_info['phase'] }}</p>
                                    <p><strong>يحتوي على توقيع:</strong> {{ $qr_code_info['contains_signature'] ? 'نعم' : 'لا' }}</p>
                                    <p><strong>يحتوي على مفتاح عام:</strong> {{ $qr_code_info['contains_public_key'] ? 'نعم' : 'لا' }}</p>
                                    <p><strong>يحتوي على طابع تشفيري:</strong> {{ $qr_code_info['contains_cryptographic_stamp'] ? 'نعم' : 'لا' }}</p>
                                    <p><strong>مرسل لـ ZATCA:</strong> {{ $qr_code_info['sent_to_zatca'] ? 'نعم' : 'لا' }}</p>
                                    <p class="mb-0"><strong>يحتوي على Hash:</strong> {{ $qr_code_info['has_hash'] ? 'نعم' : 'لا' }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5><i class="fas fa-building"></i> امتثال عنوان الشركة</h5>
                                </div>
                                <div class="card-body">
                                    <p><strong>مطابق:</strong> 
                                        <span class="badge badge-{{ $company_address_complete['compliant'] ? 'success' : 'danger' }}">
                                            {{ $company_address_complete['compliant'] ? 'نعم' : 'لا' }}
                                        </span>
                                    </p>
                                    @if(!$company_address_complete['compliant'])
                                    <p><strong>البيانات المفقودة:</strong></p>
                                    <ul>
                                        @foreach($company_address_complete['missing'] as $missing)
                                        <li>{{ $missing }}</li>
                                        @endforeach
                                    </ul>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- عرض XML -->
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5><i class="fas fa-code"></i> محتوى XML</h5>
                                    <div class="card-tools">
                                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                            <i class="fas fa-minus"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="card-body" style="max-height: 500px; overflow-y: auto;">
                                    <pre><code class="language-xml">{{ $xml_content }}</code></pre>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- مكتبة تمييز الكود -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/prism/1.24.1/themes/prism.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/prism/1.24.1/components/prism-core.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/prism/1.24.1/plugins/autoloader/prism-autoloader.min.js"></script>

<style>
.badge {
    font-size: 0.9em;
}
code[class*="language-"], pre[class*="language-"] {
    font-size: 12px;
    direction: ltr;
    text-align: left;
}
</style>
@endsection