<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>فاتورة رقم {{ $invoice->invoice_number }}</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background: #fff;
            margin: 0;
            padding: 8px;
            color: #000;
            font-size: 15px;
            line-height: 1.3;
        }

        .invoice-container {
            max-width: 200mm;
            margin: 0 auto;
            background: #fff;
            padding: 12px;
            border: 1px solid #000;
            box-shadow: none;
            border-radius: 0;
            height: auto;
            min-height: 277mm;
            display: flex;
            flex-direction: column;
        }

        .invoice-content {
            flex: 1;
        }

        @media print {
            body {
                background: #fff;
                padding: 0;
                font-size: 15px;
                line-height: 1.2;
                font-family: 'Arial', sans-serif;
            }
            .invoice-container {
                max-width: none;
                border: 1px solid #000;
                padding: 4mm;
                margin: 0;
                box-shadow: none;
                border-radius: 0;
                height: auto;
                max-height: none;
            }
            .no-print { display: none !important; }
            @page {
                size: A4;
                margin: 3mm;
            }
            .invoice-header {
                background: #fff !important;
                border-radius: 0;
                padding: 6px;
                page-break-inside: avoid;
                margin-bottom: 8px;
            }
            .company-info h1 {
                font-size: 16px;
                text-shadow: none;
                margin-bottom: 2px;
            }
            .company-details {
                font-size: 15px;
            }
            .invoice-meta {
                background: #fff !important;
                box-shadow: none;
                border: 1px solid #000;
                padding: 4px;
            }
            .invoice-title {
                font-size: 13px;
                margin-bottom: 4px;
            }
            .invoice-number {
                font-size: 11px;
                margin-bottom: 2px;
            }
            .info-section {
                margin-bottom: 8px;
                gap: 8px;
            }
            .info-box {
                background: #fff !important;
                box-shadow: none;
                border: 1px solid #000;
                padding: 6px;
            }
            .info-box h3 {
                font-size: 11px;
                margin-bottom: 4px;
                padding-bottom: 2px;
            }
            .info-item {
                font-size: 9px;
                margin-bottom: 2px;
            }
            .items-table {
                box-shadow: none;
                border-radius: 0;
                font-size: 9px;
                margin-bottom: 8px;
            }
            .items-table th {
                background: #f5f5f5 !important;
                color: #000 !important;
                font-size: 9px;
                padding: 3px 2px;
            }
            .items-table td {
                font-size: 8px;
                padding: 3px 2px;
            }
            .items-table tbody tr:nth-child(even) {
                background-color: #f9f9f9 !important;
            }
            .totals-section {
                margin-bottom: 8px;
                gap: 8px;
            }
            .amount-words {
                background: #fff !important;
                border: 1px solid #000;
                padding: 6px;
            }
            .amount-words h4 {
                font-size: 10px;
                margin-bottom: 3px;
                padding-bottom: 2px;
            }
            .amount-words p {
                background: #f9f9f9 !important;
                padding: 3px;
                font-size: 9px;
            }
            .totals-table {
                box-shadow: none;
                border-radius: 0;
                min-width: 150px;
            }
            .totals-table td {
                padding: 2px 4px;
                font-size: 9px;
            }
            .totals-label {
                background: #f5f5f5 !important;
            }
            .grand-total {
                background: #e5e5e5 !important;
            }
            .grand-total .totals-label,
            .grand-total .totals-value {
                color: #000 !important;
            }
            .bottom-section {
                gap: 8px;
                margin-top: 8px;
            }
            .qr-section, .notes-section {
                background: #fff !important;
                box-shadow: none;
                border: 1px solid #000;
                padding: 6px;
            }
            .qr-title, .notes-title {
                font-size: 10px;
                margin-bottom: 3px;
                padding-bottom: 2px;
            }
            .qr-section img {
                background: #fff !important;
                border: 1px solid #000;
                width: 70px;
                height: 70px;
                padding: 2px;
                margin: 2px 0;
            }
            .notes-text {
                background: #f9f9f9 !important;
                padding: 3px;
                font-size: 9px;
            }
            .invoice-footer {
                background: #fff !important;
                border-radius: 0;
                padding: 6px;
                page-break-inside: avoid;
                font-size: 8px;
                margin-top: 8px;
            }
            .footer-highlight {
                background: #f5f5f5 !important;
                border: 1px solid #000;
                padding: 3px;
                font-size: 9px;
                margin-bottom: 3px;
            }
        }

        /* أزرار التحكم */
        .control-buttons {
            position: fixed;
            top: 20px;
            left: 20px;
            z-index: 1000;
            display: flex;
            gap: 10px;
        }
        .control-buttons button,
        .control-buttons a {
            padding: 8px 15px;
            border: 2px solid #000;
            border-radius: 0;
            font-size: 15px;
            cursor: pointer;
            text-decoration: none;
            color: #000;
            background: #fff;
        }
        .control-buttons button:hover,
        .control-buttons a:hover {
            background: #000;
            color: #fff;
        }

        /* رأس الفاتورة */
        .invoice-header {
            border-bottom: 2px solid #000;
            padding-bottom: 8px;
            margin-bottom: 10px;
            background: #fff;
            padding: 8px;
            border-radius: 0;
            border: 1px solid #000;
            border-bottom-width: 2px;
        }

        .header-row {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            gap: 15px;
        }

        .company-info {
            flex: 2;
        }

        .company-info h1 {
            font-size: 20px;
            font-weight: 700;
            color: #000;
            margin-bottom: 4px;
            text-shadow: none;
        }

        .company-info .company-en {
            font-size: 13px;
            color: #333;
            margin-bottom: 6px;
            font-style: italic;
        }

        .company-details {
            font-size: 11px;
            color: #000;
            line-height: 1.3;
        }

        .company-details div {
            margin-bottom: 2px;
            padding: 1px 0;
        }

        .invoice-meta {
            flex: 1;
            text-align: center;
            background: #fff;
            padding: 8px;
            border-radius: 0;
            border: 1px solid #000;
            box-shadow: none;
        }

        .invoice-title {
            font-size: 16px;
            font-weight: 700;
            color: #000;
            margin-bottom: 6px;
            border-bottom: 1px solid #000;
            padding-bottom: 4px;
        }

        .invoice-number {
            font-size: 13px;
            color: #000;
            margin-bottom: 4px;
            font-weight: 600;
        }

        /* معلومات العميل والفاتورة */
        .info-section {
            display: flex;
            justify-content: space-between;
            margin-bottom: 8px;
            gap: 8px;
        }

        .info-box {
            flex: 1;
            border: 1px solid #000;
            border-radius: 0;
            padding: 6px;
            background: #fff;
            box-shadow: none;
        }

        .info-box h3 {
            font-size: 15px;
            font-weight: 700;
            color: #000;
            margin-bottom: 4px;
            border-bottom: 1px solid #000;
            padding-bottom: 2px;
            text-align: center;
        }

        .info-item {
            display: flex;
            margin-bottom: 2px;
            font-size: 10px;
            align-items: flex-start;
        }

        .info-label {
            font-weight: 600;
            min-width: 60px;
            color: #000;
            padding-left: 4px;
        }

        .info-value {
            color: #000;
            flex: 1;
        }

        /* جدول العناصر */
        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 8px;
            font-size: 9px;
            box-shadow: none;
            border-radius: 0;
            overflow: hidden;
            border: 1px solid #000;
        }

        .items-table th {
            background: #f5f5f5;
            border: 1px solid #000;
            padding: 3px 2px;
            text-align: center;
            font-weight: 700;
            color: #000;
            font-size: 9px;
        }

        .items-table td {
            border: 1px solid #000;
            padding: 2px 1px;
            text-align: center;
            color: #000;
            background: #fff;
        }

        .items-table tbody tr:nth-child(even) {
            background-color: #f9f9f9;
        }

        .items-table tbody tr:hover {
            background-color: #f0f0f0;
        }

        .items-table .description {
            text-align: right;
            padding: 2px 3px;
        }

        .item-name {
            font-weight: 600;
            color: #000;
            margin-bottom: 1px;
            font-size: 9px;
        }

        .item-desc {
            font-size: 8px;
            color: #333;
            font-style: italic;
        }

        /* الإجماليات */
        .totals-section {
            display: flex;
            justify-content: space-between;
            margin-bottom: 8px;
            gap: 8px;
        }

        .amount-words {
            flex: 1;
            background: #fff;
            padding: 6px;
            border-radius: 0;
            border: 1px solid #000;
        }

        .amount-words h4 {
            font-size: 10px;
            font-weight: 700;
            color: #000;
            margin-bottom: 4px;
            border-bottom: 1px solid #000;
            padding-bottom: 2px;
        }

        .amount-words p {
            font-size: 9px;
            color: #000;
            line-height: 1.3;
            font-weight: 500;
            background: #f9f9f9;
            padding: 4px;
            border-radius: 0;
            border: 1px solid #000;
        }

        .totals-table {
            min-width: 180px;
            border: 1px solid #000;
            border-radius: 0;
            overflow: hidden;
            box-shadow: none;
        }

        .totals-table td {
            padding: 3px 4px;
            border-bottom: 1px solid #000;
            font-size: 9px;
        }

        .totals-label {
            font-weight: 600;
            text-align: right;
            color: #000;
            background: #f5f5f5;
            min-width: 90px;
        }

        .totals-value {
            text-align: left;
            color: #000;
            font-weight: 700;
            background: #fff;
        }

        .grand-total {
            background: #e5e5e5;
            font-size: 10px;
            font-weight: 700;
        }

        .grand-total .totals-label,
        .grand-total .totals-value {
            color: #000;
            background: transparent;
        }

        /* QR Code والملاحظات */
        .bottom-section {
            display: flex;
            justify-content: space-between;
            margin-top: 8px;
            gap: 8px;
        }

        .qr-section {
            text-align: center;
            border: 1px solid #000;
            border-radius: 0;
            padding: 6px;
            min-width: 100px;
            background: #fff;
            box-shadow: none;
        }

        .qr-title {
            font-size: 9px;
            font-weight: 700;
            margin-bottom: 4px;
            color: #000;
            border-bottom: 1px solid #000;
            padding-bottom: 2px;
        }

        .qr-section img {
            width: 70px;
            height: 70px;
            border: 1px solid #000;
            border-radius: 0;
            margin: 4px 0;
            background: #fff;
            padding: 2px;
        }

        .qr-info {
            font-size: 8px;
            color: #333;
            margin-top: 3px;
        }

        .notes-section {
            flex: 1;
            border: 1px solid #000;
            border-radius: 0;
            padding: 6px;
            background: #fff;
            box-shadow: none;
        }

        .notes-title {
            font-size: 9px;
            font-weight: 700;
            color: #000;
            margin-bottom: 4px;
            border-bottom: 1px solid #000;
            padding-bottom: 2px;
        }

        .notes-text {
            font-size: 8px;
            color: #000;
            line-height: 1.3;
            background: #f9f9f9;
            padding: 4px;
            border-radius: 0;
            border: 1px solid #000;
        }

        /* التذييل */
        .invoice-footer {
            border-top: 1px solid #000;
            background: #fff;
            padding: 6px;
            margin-top: auto;
            text-align: center;
            font-size: 8px;
            color: #000;
            border-radius: 0;
            border: 1px solid #000;
            border-top-width: 1px;
        }

        .footer-highlight {
            font-weight: 700;
            margin-bottom: 4px;
            color: #000;
            font-size: 9px;
            padding: 4px;
            background: #f5f5f5;
            border-radius: 0;
            border: 1px solid #000;
        }

        /* تحسينات الطباعة */
        @media print {
            .items-table th,
            .items-table td {
                padding: 4px 3px;
                font-size: 10px;
            }
            .info-box {
                padding: 10px;
            }
            .totals-table td {
                padding: 5px 8px;
            }
        }

        /* Barcode styling */
        .barcode-container {
            text-align: center;
            margin-top: 6px;
        }
        
        .barcode-container svg {
            width: auto !important;
            height: 25px !important;
        }

        /* تصميم متجاوب */
        @media (max-width: 768px) {
            body {
                padding: 10px;
                font-size: 13px;
            }
            .invoice-container {
                padding: 15px;
                border-radius: 0;
            }
            .control-buttons {
                position: relative;
                top: auto;
                left: auto;
                margin-bottom: 15px;
                justify-content: center;
            }
            .header-row {
                flex-direction: column;
                gap: 20px;
                align-items: center;
            }
            .company-info h1 {
                font-size: 24px;
                text-align: center;
            }
            .invoice-meta {
                width: 100%;
                max-width: 300px;
            }
            .info-section {
                flex-direction: column;
                gap: 15px;
            }
            .items-table {
                font-size: 11px;
            }
            .items-table th,
            .items-table td {
                padding: 6px 4px;
            }
            .totals-section {
                flex-direction: column;
                gap: 15px;
            }
            .amount-words {
                order: 2;
            }
            .totals-table {
                order: 1;
                min-width: auto;
                width: 100%;
            }
            .bottom-section {
                flex-direction: column;
                gap: 15px;
            }
            .qr-section {
                min-width: auto;
                width: 100%;
            }
            .qr-section img {
                width: 120px;
                height: 120px;
            }
        }

        @media (max-width: 480px) {
            body {
                font-size: 15px;
            }
            .invoice-container {
                padding: 10px;
            }
            .company-info h1 {
                font-size: 20px;
            }
            .invoice-title {
                font-size: 18px;
            }
            .items-table {
                font-size: 10px;
            }
            .items-table th,
            .items-table td {
                padding: 4px 2px;
            }
            /* إخفاء بعض الأعمدة في الشاشات الصغيرة جداً */
            .items-table th:nth-child(4),
            .items-table td:nth-child(4),
            .items-table th:nth-child(6),
            .items-table td:nth-child(6) {
                display: none;
            }
        }
    </style>
    
    <!-- JsBarcode Library -->
    <script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.5/dist/JsBarcode.all.min.js"></script>
</head>

<body>
    <!-- أزرار التحكم -->
    <div class="control-buttons no-print">
        <button class="print-btn" onclick="window.print()">🖨️ طباعة</button>
        <a href="{{ route('invoices.show', $invoice) }}" class="back-btn">← عودة</a>
    </div>

    <div class="invoice-container">
        <div class="invoice-content">
        <!-- رأس الفاتورة -->
  

        <div class="invoice-header">
            <div class="header-row">
                <div class="company-info">
                    <h1>{{ $invoice->company->name ?? 'اسم الشركة' }}</h1>
                    @if($invoice->company && $invoice->company->name_en)
                        <div class="company-en">{{ $invoice->company->name_en }}</div>
                    @endif
                    <div class="company-details">
                        <div><strong>الرقم الضريبي:</strong> {{ $invoice->company->vat_number ?? 'غير محدد' }}</div>
                        @if($invoice->company && $invoice->company->cr_number)
                            <div><strong>السجل التجاري:</strong> {{ $invoice->company->cr_number }}</div>
                        @endif
                        <div><strong>العنوان:</strong> {{ $invoice->company ? $invoice->company->getFullAddressAttribute() : 'العنوان غير محدد' }}</div>
                        @if($invoice->company && $invoice->company->phone)
                            <div><strong>الهاتف:</strong> {{ $invoice->company->phone }}</div>
                        @endif
                        @if($invoice->company && $invoice->company->email)
                            <div><strong>البريد الإلكتروني:</strong> {{ $invoice->company->email }}</div>
                        @endif
                    </div>
                </div>
                
                <div class="invoice-meta">
                    <div class="invoice-title">
                        @if($invoice->type == 'standard')
                            فاتورة ضريبية 
                        @else
                            فاتورة ضريبية مبسطة
                        @endif
                    </div>
                    <div class="invoice-number">رقم: {{ $invoice->invoice_number }}</div>
                    <div class="barcode-container">
                        <svg id="invoice-barcode"></svg>
                    </div>
                    <div class="invoice-number">تاريخ: {{ $invoice->issue_date->format('Y-m-d') }}</div>
                </div>
            </div>
        </div>

        <!-- معلومات العميل والفاتورة -->
        <div class="info-section">
            <div class="info-box">
                <h3>معلومات المشتري</h3>
                @if($invoice->customer)
                    <div class="info-item">
                        <div class="info-label">الاسم:</div>
                        <div class="info-value">{{ $invoice->customer->name }}</div>
                    </div>
                    @if($invoice->customer->vat_number)
                        <div class="info-item">
                            <div class="info-label">الرقم الضريبي:</div>
                            <div class="info-value">{{ $invoice->customer->vat_number }}</div>
                        </div>
                    @endif
                    <div class="info-item">
                        <div class="info-label">العنوان:</div>
                        <div class="info-value">{{ $invoice->customer->getFullAddressAttribute() }}</div>
                    </div>
                    @if($invoice->customer->phone)
                        <div class="info-item">
                            <div class="info-label">الهاتف:</div>
                            <div class="info-value">{{ $invoice->customer->phone }}</div>
                        </div>
                    @endif
                @else
                    <div class="info-item">
                        <div class="info-label">الاسم:</div>
                        <div class="info-value">عميل غير محدد</div>
                    </div>
                @endif
            </div>
            
            <div class="info-box">
                <h3>تفاصيل الفاتورة</h3>
                <div class="info-item">
                    <div class="info-label">تاريخ الإصدار:</div>
                    <div class="info-value">{{ $invoice->issue_date->format('Y-m-d') }}</div>
                </div>
                <div class="info-item">
                    <div class="info-label">تاريخ التوريد:</div>
                    <div class="info-value">{{ $invoice->supply_date->format('Y-m-d') }}</div>
                </div>
                <div class="info-item">
                    <div class="info-label">العملة:</div>
                    <div class="info-value">{{ $invoice->currency }} (ريال سعودي)</div>
                </div>
                <div class="info-item">
                    <div class="info-label">الحالة:</div>
                    <div class="info-value">
                        @switch($invoice->status)
                            @case('cleared') مقبولة @break
                            @case('reported') مبلغة @break
                            @case('draft') مسودة @break
                            @case('rejected') مرفوضة @break
                            @default {{ $invoice->status }}
                        @endswitch
                    </div>
                </div>
            </div>
        </div>

        <!-- جدول العناصر -->
        <table class="items-table">
            <thead>
                <tr>
                    <th style="width: 5%;">م</th>
                    <th style="width: 35%;">الوصف</th>
                    <th style="width: 8%;">الكمية</th>
                    <th style="width: 8%;">الوحدة</th>
                    <th style="width: 12%;">سعر الوحدة</th>
                    <th style="width: 8%;">الخصم</th>
                    <th style="width: 12%;">الإجمالي</th>
                    <th style="width: 8%;">الضريبة</th>
                    <th style="width: 12%;">المجموع النهائي</th>
                </tr>
            </thead>
            <tbody>
                @foreach($invoice->items as $index => $item)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td class="description">
                        <div class="item-name">{{ $item->name }}</div>
                        @if($item->description)
                            <div class="item-desc">{{ $item->description }}</div>
                        @endif
                    </td>
                    <td>{{ number_format($item->quantity, 2) }}</td>
                    <td>{{ $item->unit ?? 'قطعة' }}</td>
                    <td>{{ number_format($item->unit_price, 2) }}</td>
                    <td>{{ number_format($item->discount_amount ?? 0, 2) }}</td>
                    <td>{{ number_format($item->line_total, 2) }}</td>
                    <td>{{ number_format($item->tax_amount, 2) }}</td>
                    <td><strong>{{ number_format($item->total_with_tax, 2) }}</strong></td>
                </tr>
                @endforeach
            </tbody>
        </table>

        <!-- الإجماليات -->
        <div class="totals-section">
            <div class="amount-words">
                <h4>المبلغ بالحروف:</h4>
                <p>
                    {{ \App\Helpers\ArabicNumberToWords::convert($invoice->total_amount, 'ريال سعودي', 'هللة') }}
                </p>
            </div>
            
            <table class="totals-table">
                <tr>
                    <td class="totals-label">المجموع الفرعي:</td>
                    <td class="totals-value">{{ number_format($invoice->subtotal, 2) }} ر.س</td>
                </tr>
                @if($invoice->discount_amount > 0)
                <tr>
                    <td class="totals-label">الخصم:</td>
                    <td class="totals-value">{{ number_format($invoice->discount_amount, 2) }} ر.س</td>
                </tr>
                @endif
                <tr>
                    <td class="totals-label">ضريبة القيمة المضافة:</td>
                    <td class="totals-value">{{ number_format($invoice->tax_amount, 2) }} ر.س</td>
                </tr>
                <tr class="grand-total">
                    <td class="totals-label">المجموع الكلي:</td>
                    <td class="totals-value">{{ number_format($invoice->total_amount, 2) }} ر.س</td>
                </tr>
            </table>
        </div>

        <!-- QR Code والملاحظات -->
        <div class="bottom-section">
            @if($invoice->qr_code)
                <div class="qr-section">
                    <div class="qr-title">رمز التحقق الإلكتروني</div>
                    <img src="{{ $invoice->getQrCodeDataUrl() }}" alt="QR Code" style="width:170px;height:170px;">
              
                </div>
            @endif
            
            @if($invoice->notes)
                <div class="notes-section">
                    <div class="notes-title">ملاحظات:</div>
                    <div class="notes-text">{{ $invoice->notes }}</div>
                </div>
            @endif
        </div>
        </div>

        <!-- التذييل -->
        <div class="invoice-footer">
            <div class="footer-highlight">
                تم إنشاء هذه الفاتورة إلكترونياً وهي صالحة قانونياً
            </div>
            <div>تاريخ الطباعة: {{ now()->setTimezone('Asia/Riyadh')->format('Y-m-d H:i:s') }}</div>
            <div style="margin-top: 10px; font-weight: bold;">{{ $invoice->company->name ?? 'اسم الشركة' }}</div>
        </div>
    </div>

    <script>
        // تحسين تجربة الطباعة
        window.addEventListener('beforeprint', function() {
            document.body.classList.add('printing');
        });
        
        window.addEventListener('afterprint', function() {
            document.body.classList.remove('printing');
        });
        
        // إنشاء باركود لرقم الفاتورة
        document.addEventListener('DOMContentLoaded', function() {
            const invoiceNumber = "{{ $invoice->invoice_number }}";
            try {
                JsBarcode("#invoice-barcode", invoiceNumber, {
                    format: "CODE128",
                    width: 1.2,
                    height: 25,
                    displayValue: false,
                    margin: 0,
                    fontSize: 0
                });
            } catch (error) {
                console.log('Barcode generation failed:', error);
                // إخفاء حاوي الباركود في حالة فشل إنتاج الباركود
                document.querySelector('.barcode-container').style.display = 'none';
            }
        });
    </script>
</body>
</html>