<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>فاتورة ضريبية - {{ $invoice->invoice_number }}</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700&display=swap');
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        :root {
            --primary-color: #2c3e50;
            --secondary-color: #34495e;
            --accent-color: #3498db;
            --success-color: #27ae60;
            --border-color: #bdc3c7;
            --light-bg: #f8f9fa;
            --text-color: #2c3e50;
            --light-text: #7f8c8d;
            --shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        body {
            font-family: 'Cairo', 'DejaVu Sans', 'Arial', sans-serif;
            font-size: 11px;
            line-height: 1.4;
            color: var(--text-color);
            background: #fff;
            direction: rtl;
            width: 80mm;
            margin: 0 auto;
            padding: 3mm;
            font-weight: 400;
        }

        /* أزرار التحكم المحسّنة */
        .control-buttons {
            position: fixed;
            top: 15px;
            left: 15px;
            z-index: 1000;
            display: flex;
            gap: 8px;
            background: rgba(255, 255, 255, 0.95);
            padding: 10px;
            border-radius: 12px;
            box-shadow: var(--shadow);
            backdrop-filter: blur(10px);
        }

        .control-buttons button {
            background: linear-gradient(135deg, var(--accent-color), #2980b9);
            color: white;
            border: none;
            padding: 10px 16px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 11px;
            font-weight: 600;
            font-family: 'Cairo', sans-serif;
            transition: all 0.3s ease;
            box-shadow: 0 2px 8px rgba(52, 152, 219, 0.3);
        }

        .control-buttons button:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(52, 152, 219, 0.4);
        }

        .control-buttons button.active {
            background: linear-gradient(135deg, var(--success-color), #229954);
            box-shadow: 0 2px 8px rgba(39, 174, 96, 0.3);
        }

        .control-buttons button.secondary {
            background: linear-gradient(135deg, var(--secondary-color), #2c3e50);
        }

        /* الحاوي الأساسي */
        .invoice-container {
            width: 100%;
            max-width: 76mm;
            margin: 0 auto;
            background: #fff;
            position: relative;
        }

        /* خط زخرفي علوي */
        .top-accent {
            height: 4px;
            background: linear-gradient(90deg, var(--accent-color), var(--success-color));
            margin-bottom: 8px;
            border-radius: 2px;
        }

        /* رأس الشركة المحسّن */
        .company-header {
            text-align: center;
            background: linear-gradient(135deg, var(--light-bg), #ecf0f1);
            border: 2px solid var(--border-color);
            border-radius: 8px;
            padding: 12px;
            margin-bottom: 10px;
            position: relative;
            overflow: hidden;
        }

        .company-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--accent-color), var(--success-color));
        }

        .company-name {
            font-size: 18px;
            font-weight: 700;
            margin-bottom: 4px;
            color: var(--primary-color);
            text-shadow: 1px 1px 2px rgba(0,0,0,0.1);
            letter-spacing: 0.5px;
        }

        .company-name-en {
            font-size: 13px;
            font-style: italic;
            margin-bottom: 6px;
            color: var(--light-text);
            font-weight: 300;
        }

        .company-details {
            font-size: 10px;
            line-height: 1.5;
            color: var(--secondary-color);
            font-weight: 400;
        }

        /* نوع الفاتورة المحسّن */
        .invoice-type {
            text-align: center;
            font-size: 16px;
            font-weight: 700;
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 10px;
            margin-bottom: 10px;
            border-radius: 8px;
            text-shadow: 1px 1px 2px rgba(0,0,0,0.3);
            letter-spacing: 0.5px;
            box-shadow: var(--shadow);
        }

        /* معلومات الفاتورة المحسّنة */
        .invoice-info {
            background: var(--light-bg);
            border-radius: 8px;
            padding: 8px;
            margin-bottom: 10px;
            border: 1px solid var(--border-color);
        }

        .info-row {
            display: flex;
            justify-content: space-between;
            padding: 4px 0;
            border-bottom: 1px dotted #ddd;
            align-items: center;
        }

        .info-row:last-child {
            border-bottom: none;
        }

        .info-label {
            font-weight: 600;
            width: 42%;
            color: var(--primary-color);
            font-size: 10px;
        }

        .info-value {
            width: 58%;
            text-align: left;
            font-weight: 400;
            color: var(--text-color);
            font-size: 10px;
        }

        /* فواصل أنيقة */
        .separator {
            height: 1px;
            background: linear-gradient(90deg, transparent, var(--border-color), transparent);
            margin: 10px 0;
        }

        .double-separator {
            height: 2px;
            background: linear-gradient(90deg, var(--accent-color), var(--success-color));
            margin: 12px 0;
            border-radius: 1px;
        }

        /* قسم العناصر المحسّن */
        .items-section {
            margin-bottom: 10px;
        }

        .items-header {
            text-align: center;
            font-weight: 700;
            font-size: 12px;
            background: linear-gradient(135deg, var(--accent-color), #2980b9);
            color: white;
            padding: 8px;
            border-radius: 6px;
            margin-bottom: 6px;
            text-shadow: 1px 1px 2px rgba(0,0,0,0.2);
            letter-spacing: 0.3px;
        }

        .item {
            background: #fff;
            border: 1px solid var(--border-color);
            border-radius: 6px;
            padding: 8px;
            margin-bottom: 4px;
            transition: all 0.2s ease;
            position: relative;
        }

        .item:hover {
            box-shadow: var(--shadow);
            border-color: var(--accent-color);
        }

        .item::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            bottom: 0;
            width: 3px;
            background: linear-gradient(180deg, var(--accent-color), var(--success-color));
            border-radius: 0 3px 3px 0;
        }

        .item-row {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
        }

        .item-details {
            flex: 1;
            padding-left: 8px;
        }

        .item-name {
            font-weight: 600;
            font-size: 11px;
            margin-bottom: 2px;
            color: var(--primary-color);
            line-height: 1.3;
        }

        .item-desc {
            font-size: 9px;
            color: var(--light-text);
            margin-bottom: 2px;
            line-height: 1.3;
            font-weight: 300;
        }

        .item-code {
            font-size: 8px;
            color: var(--light-text);
            font-family: 'Courier New', monospace;
            background: #f1f2f3;
            padding: 1px 4px;
            border-radius: 3px;
            display: inline-block;
        }

        .item-qty-price {
            text-align: left;
            font-size: 10px;
            min-width: 65px;
            color: var(--secondary-color);
            font-weight: 500;
        }

        .item-total {
            text-align: left;
            font-weight: 700;
            min-width: 55px;
            color: var(--primary-color);
            font-size: 11px;
        }

        /* الإجماليات المحسّنة */
        .totals-section {
            background: var(--light-bg);
            border-radius: 8px;
            padding: 10px;
            margin-top: 10px;
            border: 1px solid var(--border-color);
        }

        .total-row {
            display: flex;
            justify-content: space-between;
            padding: 5px 0;
            font-size: 11px;
            align-items: center;
        }

        .total-row.grand-total {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 12px 10px;
            margin: 8px -10px -10px -10px;
            border-radius: 0 0 8px 8px;
            font-size: 14px;
            font-weight: 700;
            text-shadow: 1px 1px 2px rgba(0,0,0,0.3);
        }

        .total-label {
            font-weight: 600;
            color: var(--primary-color);
        }

        .grand-total .total-label {
            color: white;
        }

        .total-value {
            text-align: left;
            font-family: 'Cairo', 'Courier New', monospace;
            font-weight: 700;
            color: var(--text-color);
        }

        .grand-total .total-value {
            color: white;
            font-size: 15px;
        }

        /* المبلغ بالحروف المحسّن */
        .amount-words {
            margin: 10px 0;
            padding: 10px;
            background: linear-gradient(135deg, #e8f4fd, #f0f8ff);
            border: 1px solid var(--accent-color);
            border-radius: 8px;
            font-size: 10px;
            text-align: center;
            color: var(--primary-color);
            font-weight: 500;
            line-height: 1.4;
        }

        .amount-words strong {
            color: var(--accent-color);
            font-weight: 700;
        }

        /* الملاحظات المحسّنة */
        .notes-section {
            margin: 10px 0;
            padding: 10px;
            background: linear-gradient(135deg, #fff5e6, #fdf2e9);
            border: 1px solid #f39c12;
            border-radius: 8px;
            font-size: 10px;
        }

        .notes-label {
            font-weight: 700;
            margin-bottom: 4px;
            color: #d68910;
        }

        .notes-content {
            color: var(--secondary-color);
            line-height: 1.4;
        }

        /* QR Code المحسّن */
        .qr-section {
            text-align: center;
            margin: 12px 0;
            padding: 12px;
            background: var(--light-bg);
            border: 2px dashed var(--border-color);
            border-radius: 8px;
        }

        .qr-code {
            max-width: 60mm;
            height: auto;
            margin: 6px 0;
            border-radius: 4px;
            box-shadow: var(--shadow);
        }

        .qr-label {
            font-weight: 700;
            font-size: 10px;
            margin-bottom: 6px;
            color: var(--primary-color);
        }

        /* التذييل المحسّن */
        .footer {
            text-align: center;
            margin-top: 12px;
            padding: 12px;
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            border-radius: 8px;
            font-size: 10px;
            position: relative;
            overflow: hidden;
        }

        .footer::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--accent-color), var(--success-color));
        }

        .footer-title {
            font-weight: 700;
            font-size: 13px;
            margin-bottom: 4px;
            text-shadow: 1px 1px 2px rgba(0,0,0,0.3);
        }

        .footer-details {
            line-height: 1.5;
            color: #ecf0f1;
            font-weight: 300;
        }

        /* طباعة 58mm */
        .thermal-58mm {
            width: 58mm;
            font-size: 10px;
        }

        .thermal-58mm .invoice-container {
            max-width: 54mm;
        }

        .thermal-58mm .company-name {
            font-size: 16px;
        }

        .thermal-58mm .invoice-type {
            font-size: 14px;
        }

        .thermal-58mm .item-details {
            padding-left: 6px;
        }

        .thermal-58mm .item-qty-price {
            min-width: 50px;
            font-size: 9px;
        }

        .thermal-58mm .item-total {
            min-width: 45px;
            font-size: 10px;
        }

        .thermal-58mm .qr-code {
            max-width: 45mm;
        }

        .thermal-58mm .total-row.grand-total {
            font-size: 12px;
        }

        .thermal-58mm .grand-total .total-value {
            font-size: 13px;
        }

        /* طباعة 80mm */
        .thermal-80mm {
            width: 80mm;
        }

        .thermal-80mm .invoice-container {
            max-width: 76mm;
        }

        /* تحسينات الطباعة */
        @media print {
            body {
                margin: 0;
                padding: 2mm;
                width: auto;
                font-size: 10px;
            }

            .control-buttons {
                display: none !important;
            }

            .invoice-container {
                margin: 0;
                padding: 0;
                max-width: none;
                width: 100%;
            }

            /* تحسين الألوان للطباعة الحرارية */
            .company-header,
            .invoice-type,
            .items-header,
            .totals-section,
            .amount-words,
            .qr-section,
            .footer {
                -webkit-print-color-adjust: exact;
                color-adjust: exact;
            }

            /* تحويل الخلفيات الملونة إلى حدود في الطباعة */
            .invoice-type,
            .items-header,
            .total-row.grand-total,
            .footer {
                background: white !important;
                color: black !important;
                border: 2px solid black !important;
            }

            .company-header {
                background: white !important;
                border: 1px solid black !important;
            }

            .item {
                border: 1px solid black !important;
            }

            .amount-words,
            .notes-section,
            .qr-section,
            .totals-section,
            .invoice-info {
                background: white !important;
                border: 1px solid black !important;
            }

            /* تحسين الخطوط */
            .company-name,
            .invoice-type,
            .items-header,
            .total-label,
            .footer-title,
            .item-name {
                font-weight: bold !important;
            }

            .top-accent,
            .double-separator {
                background: black !important;
            }
        }

        /* إخفاء العناصر في الطباعة */
        .no-print {
            display: block;
        }

        @media print {
            .no-print {
                display: none !important;
            }
        }

        /* تحسينات إضافية للطباعة الحرارية */
        .thermal-optimized {
            line-height: 1.2;
        }

        .thermal-optimized .item {
            padding: 6px;
            margin-bottom: 3px;
        }

        .thermal-optimized .total-row {
            padding: 3px 0;
        }

        .thermal-optimized .company-header,
        .thermal-optimized .invoice-info,
        .thermal-optimized .totals-section {
            padding: 8px;
        }

        /* رسوم متحركة خفيفة */
        .item,
        .control-buttons button {
            transition: all 0.3s ease;
        }

        /* تحسين الاستجابة */
        @media (max-width: 320px) {
            .control-buttons {
                flex-direction: column;
                gap: 4px;
                padding: 8px;
            }
            
            .control-buttons button {
                padding: 8px 12px;
                font-size: 10px;
            }
        }
    </style>
</head>

<body id="thermal-body">
    <!-- أزرار التحكم المحسّنة -->
    <div class="control-buttons no-print">
        <button onclick="window.print()" title="طباعة الفاتورة">
            🖨️ طباعة
        </button>
        <button onclick="window.close()" class="secondary" title="إغلاق النافذة">
            ✖️ إغلاق
        </button>
        <button id="btn-58mm" onclick="switchPrinterSize('58mm')" title="طباعة 58 مم">
            📄 58mm
        </button>
        <button id="btn-80mm" onclick="switchPrinterSize('80mm')" class="active" title="طباعة 80 مم">
            📄 80mm
        </button>
        <button onclick="toggleOptimization()" title="تحسين حراري">
            ⚡ تحسين
        </button>
    </div>

    <div class="invoice-container">
        
        <!-- خط زخرفي علوي -->
        <div class="top-accent"></div>
        
        <!-- رأس الشركة -->
        <div class="company-header">
            <div class="company-name">{{ $invoice->company->name ?? 'اسم الشركة' }}</div>
            @if($invoice->company && $invoice->company->name_en)
                <div class="company-name-en">{{ $invoice->company->name_en }}</div>
            @endif
            <div class="company-details">
                @if($invoice->company)
                    @if($invoice->company->vat_number)
                        <strong>الرقم الضريبي:</strong> {{ $invoice->company->vat_number }}<br>
                    @endif
                    @if($invoice->company->cr_number)
                        <strong>س.ت:</strong> {{ $invoice->company->cr_number }}<br>
                    @endif
                    📍 {{ $invoice->company->getFullAddressAttribute() }}<br>
                    @if($invoice->company->phone)
                        📞 {{ $invoice->company->phone }}
                    @endif
                    @if($invoice->company->email)
                        <br>📧 {{ $invoice->company->email }}
                    @endif
                @endif
            </div>
        </div>

        <!-- نوع الفاتورة -->
        <div class="invoice-type">
            @if($invoice->type == 'standard')
                📋 فاتورة ضريبية
            @else
                📋 فاتورة ضريبية مبسطة
            @endif
        </div>

        <!-- معلومات الفاتورة -->
        <div class="invoice-info">
            <div class="info-row">
                <span class="info-label">🔢 رقم الفاتورة:</span>
                <span class="info-value"><strong>{{ $invoice->invoice_number }}</strong></span>
            </div>
            <div class="info-row">
                <span class="info-label">📅 التاريخ والوقت:</span>
                <span class="info-value">{{ $invoice->payment_date->format('Y-m-d H:i') }}</span>
            </div>
            @if($invoice->supply_date && $invoice->supply_date != $invoice->issue_date)
            <div class="info-row">
                <span class="info-label">🚛 تاريخ التوريد:</span>
                <span class="info-value">{{ $invoice->supply_date->format('Y-m-d') }}</span>
            </div>
            @endif
            @if($invoice->customer)
            <div class="info-row">
                <span class="info-label">👤 العميل:</span>
                <span class="info-value"><strong>{{ $invoice->customer->name }}</strong></span>
            </div>
            @if($invoice->customer->vat_number)
            <div class="info-row">
                <span class="info-label">🆔 الرقم الضريبي:</span>
                <span class="info-value">{{ $invoice->customer->vat_number }}</span>
            </div>
            @endif
            @if($invoice->customer->phone)
            <div class="info-row">
                <span class="info-label">📱 الهاتف:</span>
                <span class="info-value">{{ $invoice->customer->phone }}</span>
            </div>
            @endif
            @endif
            @if($invoice->payment_method)
            <div class="info-row">
                <span class="info-label">💳 طريقة الدفع:</span>
                <span class="info-value">
                    @switch($invoice->payment_method)
                        @case('cash') 💵 نقداً @break
                        @case('credit_card') 💳 بطاقة ائتمان @break
                        @case('bank_transfer') 🏦 تحويل بنكي @break
                        @case('check') 📝 شيك @break
                        @default {{ $invoice->payment_method }}
                    @endswitch
                </span>
            </div>
            @endif
            @if($invoice->user)
            <div class="info-row">
                <span class="info-label">👨‍💼 الكاشير:</span>
                <span class="info-value">{{ $invoice->user->name }}</span>
            </div>
            @endif
        </div>

        <div class="double-separator"></div>

        <!-- العناصر -->
        <div class="items-section">
            <div class="items-header">🛍️ تفاصيل الفاتورة</div>
            
            @foreach($invoice->items as $index => $item)
            <div class="item">
                <div class="item-row">
                    <div class="item-details">
                        <div class="item-name">{{ $index + 1 }}. {{ $item->name }}</div>
                        @if($item->description)
                            <div class="item-desc">{{ $item->description }}</div>
                        @endif
                        @if($item->sku)
                            <div class="item-code">كود: {{ $item->sku }}</div>
                        @endif
                    </div>
                    <div class="item-qty-price">
                        {{ number_format($item->quantity, 0) }} × {{ number_format($item->unit_price, 2) }}
                    </div>
                    <div class="item-total">
                        {{ number_format($item->total_with_tax, 2) }} ر.س
                    </div>
                </div>
            </div>
            @endforeach
        </div>

        <!-- الإجماليات -->
        <div class="totals-section">
            <div class="total-row">
                <span class="total-label">💰 المجموع قبل الضريبة:</span>
                <span class="total-value">{{ number_format($invoice->subtotal, 2) }} ر.س</span>
            </div>
            
            @if($invoice->discount_amount > 0)
            <div class="total-row">
                <span class="total-label">🏷️ الخصم:</span>
                <span class="total-value">- {{ number_format($invoice->discount_amount, 2) }} ر.س</span>
            </div>
            @endif
            
            <div class="total-row">
                <span class="total-label">📊 ض.ق.م (15%):</span>
                <span class="total-value">{{ number_format($invoice->tax_amount, 2) }} ر.س</span>
            </div>

            <div class="total-row grand-total">
                <span class="total-label">💎 الإجمالي النهائي:</span>
                <span class="total-value">{{ number_format($invoice->total_amount, 2) }} ر.س</span>
            </div>

            @if($invoice->paid_amount > 0)
            <div class="total-row">
                <span class="total-label">✅ المدفوع:</span>
                <span class="total-value">{{ number_format($invoice->paid_amount, 2) }} ر.س</span>
            </div>
            @endif

            @if($invoice->remaining_amount > 0)
            <div class="total-row">
                <span class="total-label">⏳ المتبقي:</span>
                <span class="total-value">{{ number_format($invoice->remaining_amount, 2) }} ر.س</span>
            </div>
            @endif
        </div>

        <!-- المبلغ بالحروف -->
        <div class="amount-words">
            <strong>💬 المبلغ بالحروف:</strong><br>
            {{ \App\Helpers\ArabicNumberToWords::convert($invoice->total_amount, 'ريال سعودي', 'هللة') }}
        </div>

        <!-- الملاحظات -->
        @if($invoice->notes)
        <div class="notes-section">
            <div class="notes-label">📝 ملاحظات:</div>
            <div class="notes-content">{{ $invoice->notes }}</div>
        </div>
        @endif

        <!-- QR Code -->
        @if($invoice->qr_code)
        <div class="qr-section">
            <div class="qr-label">🔍 رمز التحقق الإلكتروني</div>
            <img src="{{ $invoice->getQrCodeDataUrl() }}" alt="QR Code" class="qr-code">
        </div>
        @endif

        <div class="separator"></div>

        <!-- التذييل -->
        <div class="footer">
            <div class="footer-title">🙏 شكراً لتعاملكم معنا</div>
            <div class="footer-details">
                🏢 {{ $invoice->company->name ?? 'اسم الشركة' }}<br>
                🕐 {{ now()->setTimezone('Asia/Riyadh')->format('Y-m-d H:i:s') }}
            </div>
        </div>

    </div>

    <script>
        // الطباعة التلقائية مع تحسينات
        window.addEventListener('load', function() {
            // تطبيق التحسين الحراري افتراضياً
            document.body.classList.add('thermal-optimized');
            
            // استعادة الإعدادات المحفوظة
            const savedSize = localStorage.getItem('thermalPrinterSize') || '80mm';
            switchPrinterSize(savedSize);
            
            const isOptimized = localStorage.getItem('thermalOptimized');
            if (isOptimized !== 'false') {
                document.body.classList.add('thermal-optimized');
            }
            
            setTimeout(function() {
                const urlParams = new URLSearchParams(window.location.search);
                if (urlParams.get('auto_print') === '1') {
                    window.print();
                }
            }, 800);
        });

        // اختصارات لوحة المفاتيح المحسّنة
        document.addEventListener('keydown', function(e) {
            if (e.ctrlKey && e.key === 'p') {
                e.preventDefault();
                window.print();
            }
            if (e.key === 'Escape') {
                window.close();
            }
            if (e.key === '1') {
                switchPrinterSize('58mm');
            }
            if (e.key === '2') {
                switchPrinterSize('80mm');
            }
            if (e.key === 'o' || e.key === 'O') {
                toggleOptimization();
            }
        });

        // التبديل بين أحجام الطابعات مع تأثيرات بصرية
        function switchPrinterSize(size) {
            const body = document.getElementById('thermal-body');
            const btn58 = document.getElementById('btn-58mm');
            const btn80 = document.getElementById('btn-80mm');
            
            // إزالة الكلاسات السابقة
            body.classList.remove('thermal-58mm', 'thermal-80mm');
            btn58.classList.remove('active');
            btn80.classList.remove('active');
            
            if (size === '58mm') {
                body.classList.add('thermal-58mm');
                btn58.classList.add('active');
            } else if (size === '80mm') {
                body.classList.add('thermal-80mm');
                btn80.classList.add('active');
            }
            
            // حفظ الإعداد
            localStorage.setItem('thermalPrinterSize', size);
            
            // إظهار تأكيد بصري
            showNotification(`تم التبديل إلى حجم ${size}`);
        }

        // تبديل التحسين الحراري
        function toggleOptimization() {
            const body = document.body;
            body.classList.toggle('thermal-optimized');
            
            const isOptimized = body.classList.contains('thermal-optimized');
            localStorage.setItem('thermalOptimized', isOptimized);
            
            showNotification(isOptimized ? 'تم تفعيل التحسين الحراري' : 'تم إلغاء التحسين الحراري');
        }

        // إظهار إشعار بصري
        function showNotification(message) {
            const notification = document.createElement('div');
            notification.textContent = message;
            notification.style.cssText = `
                position: fixed;
                top: 70px;
                left: 50%;
                transform: translateX(-50%);
                background: linear-gradient(135deg, #27ae60, #2ecc71);
                color: white;
                padding: 12px 20px;
                border-radius: 25px;
                font-size: 12px;
                font-weight: 600;
                z-index: 10000;
                box-shadow: 0 4px 15px rgba(39, 174, 96, 0.3);
                opacity: 0;
                transition: all 0.3s ease;
            `;
            
            document.body.appendChild(notification);
            
            // إظهار الإشعار
            setTimeout(() => {
                notification.style.opacity = '1';
                notification.style.transform = 'translateX(-50%) translateY(0)';
            }, 100);
            
            // إخفاء الإشعار
            setTimeout(() => {
                notification.style.opacity = '0';
                notification.style.transform = 'translateX(-50%) translateY(-20px)';
                setTimeout(() => {
                    document.body.removeChild(notification);
                }, 300);
            }, 2000);
        }

        // تحسين للطابعات الحرارية قبل الطباعة
        window.addEventListener('beforeprint', function() {
            // تحسينات للطباعة الحرارية
            document.body.style.backgroundColor = 'white';
            document.body.style.color = 'black';
            
            showNotification('جاري التحضير للطباعة...');
        });

        window.addEventListener('afterprint', function() {
            showNotification('تمت عملية الطباعة بنجاح');
        });

        // تحسين الأداء عند تغيير حجم النافذة
        let resizeTimeout;
        window.addEventListener('resize', function() {
            clearTimeout(resizeTimeout);
            resizeTimeout = setTimeout(function() {
                // إعادة تطبيق التحسينات
                const body = document.body;
                if (body.classList.contains('thermal-optimized')) {
                    body.classList.remove('thermal-optimized');
                    setTimeout(() => body.classList.add('thermal-optimized'), 50);
                }
            }, 250);
        });
    </script>
</body>
</html>