<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>فاتورة رقم {{ $invoice->invoice_number }}</title>
    <style>
        body {
            font-family: 'Noto Sans Arabic', 'Arial', 'Tahoma', sans-serif;
            background: #fff;
            margin: 0;
            padding: 15px;
            color: #333;
            font-size: 14px;
            line-height: 1.4;
            unicode-bidi: bidi-override;
            direction: rtl;
        }

        .invoice-container {
            max-width: 210mm;
            margin: 0 auto;
            background: #fff;
            padding: 15px;
            border: 1px solid #ddd;
        }

        @media print {
            body { 
                background: #fff; 
                padding: 0;
                font-size: 12px;
            }
            .invoice-container {
                max-width: none;
                border: none;
                padding: 15px;
                margin: 0;
                box-shadow: none;
            }
            .no-print { display: none !important; }
            @page {
                size: A4;
                margin: 10mm;
            }
        }

        /* أزرار التحكم */
        .control-buttons {
            position: fixed;
            top: 20px;
            left: 20px;
            z-index: 1000;
            display: flex;
            gap: 10px;
        }
        .control-buttons button,
        .control-buttons a {
            padding: 8px 15px;
            border: none;
            border-radius: 4px;
            font-size: 12px;
            cursor: pointer;
            text-decoration: none;
            color: white;
        }
        .print-btn {
            background: #007bff;
        }
        .back-btn {
            background: #6c757d;
        }

        /* رأس الفاتورة */
        .invoice-header {
            border-bottom: 2px solid #333;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }

        .header-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .company-info h1 {
            font-size: 24px;
            font-weight: bold;
            color: #333;
            margin-bottom: 5px;
        }

        .company-info .company-en {
            font-size: 14px;
            color: #666;
            margin-bottom: 10px;
        }

        .company-details {
            font-size: 12px;
            color: #555;
            line-height: 1.3;
        }

        .invoice-title {
            text-align: center;
            font-size: 20px;
            font-weight: bold;
            color: #333;
            margin-bottom: 10px;
        }

        .invoice-number {
            text-align: center;
            font-size: 16px;
            color: #666;
        }

        /* معلومات العميل والفاتورة */
        .info-section {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
            gap: 20px;
        }

        .info-box {
            flex: 1;
            border: 1px solid #ddd;
            padding: 15px;
        }

        .info-box h3 {
            font-size: 16px;
            font-weight: bold;
            color: #333;
            margin-bottom: 10px;
            border-bottom: 1px solid #eee;
            padding-bottom: 5px;
        }

        .info-item {
            display: flex;
            margin-bottom: 5px;
            font-size: 12px;
        }

        .info-label {
            font-weight: bold;
            min-width: 80px;
            color: #555;
        }

        .info-value {
            color: #333;
        }

        /* جدول العناصر */
        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            font-size: 12px;
        }

        .items-table th {
            background: #f5f5f5;
            border: 1px solid #ddd;
            padding: 8px 4px;
            text-align: center;
            font-weight: bold;
            color: #333;
        }

        .items-table td {
            border: 1px solid #ddd;
            padding: 6px 4px;
            text-align: center;
            color: #555;
        }

        .items-table .description {
            text-align: right;
            padding: 6px 8px;
        }

        .item-name {
            font-weight: bold;
            color: #333;
            margin-bottom: 2px;
        }

        .item-desc {
            font-size: 10px;
            color: #666;
        }

        /* الإجماليات */
        .totals-section {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
        }

        .amount-words {
            flex: 1;
            padding-right: 20px;
        }

        .amount-words h4 {
            font-size: 14px;
            font-weight: bold;
            color: #333;
            margin-bottom: 10px;
        }

        .amount-words p {
            font-size: 13px;
            color: #555;
            line-height: 1.4;
        }

        .totals-table {
            min-width: 250px;
            border: 1px solid #ddd;
        }

        .totals-table td {
            padding: 8px 12px;
            border-bottom: 1px solid #eee;
            font-size: 13px;
        }

        .totals-label {
            font-weight: bold;
            text-align: right;
            color: #555;
        }

        .totals-value {
            text-align: left;
            color: #333;
            font-weight: bold;
        }

        .grand-total {
            background: #f5f5f5;
            font-size: 16px;
            font-weight: bold;
        }

        .grand-total .totals-value {
            color: #000;
        }

        /* QR Code والملاحظات */
        .bottom-section {
            display: flex;
            justify-content: space-between;
            margin-top: 20px;
            gap: 20px;
        }

        .qr-section {
            text-align: center;
            border: 1px solid #ddd;
            padding: 15px;
            min-width: 150px;
        }

        .qr-title {
            font-size: 12px;
            font-weight: bold;
            margin-bottom: 10px;
            color: #333;
        }

        .qr-section img {
            width: 120px;
            height: 120px;
            border: 1px solid #ddd;
            margin: 10px 0;
        }

        .qr-info {
            font-size: 10px;
            color: #666;
        }

        .notes-section {
            flex: 1;
            border: 1px solid #ddd;
            padding: 15px;
        }

        .notes-title {
            font-size: 14px;
            font-weight: bold;
            color: #333;
            margin-bottom: 10px;
        }

        .notes-text {
            font-size: 12px;
            color: #555;
            line-height: 1.4;
        }

        /* التذييل */
        .invoice-footer {
            border-top: 2px solid #333;
            padding-top: 15px;
            margin-top: 20px;
            text-align: center;
            font-size: 11px;
            color: #666;
        }

        .footer-highlight {
            font-weight: bold;
            margin-bottom: 10px;
            color: #333;
        }

        /* تحسينات الطباعة */
        @media print {
            .items-table th,
            .items-table td {
                padding: 4px 3px;
                font-size: 10px;
            }
            .info-box {
                padding: 10px;
            }
            .totals-table td {
                padding: 5px 8px;
            }
        }
    </style>
</head>

<body>
    <!-- أزرار التحكم -->
    <div class="control-buttons no-print">
        <button class="print-btn" onclick="window.print()">🖨️ طباعة</button>
        <a href="{{ route('invoices.show', $invoice) }}" class="back-btn">← عودة</a>
    </div>

    <div class="invoice-container">
        <!-- رأس الفاتورة -->
        <div class="invoice-header">
            <div class="header-row">
                <div class="company-info">
                    <h1>{{ $invoice->company->name ?? 'اسم الشركة' }}</h1>
                    @if($invoice->company && $invoice->company->name_en)
                        <div class="company-en">{{ $invoice->company->name_en }}</div>
                    @endif
                    <div class="company-details">
                        <div><strong>الرقم الضريبي:</strong> {{ $invoice->company->vat_number ?? 'غير محدد' }}</div>
                        @if($invoice->company && $invoice->company->cr_number)
                            <div><strong>السجل التجاري:</strong> {{ $invoice->company->cr_number }}</div>
                        @endif
                        <div><strong>العنوان:</strong> {{ $invoice->company ? $invoice->company->getFullAddressAttribute() : 'العنوان غير محدد' }}</div>
                        @if($invoice->company && $invoice->company->phone)
                            <div><strong>الهاتف:</strong> {{ $invoice->company->phone }}</div>
                        @endif
                        @if($invoice->company && $invoice->company->email)
                            <div><strong>البريد الإلكتروني:</strong> {{ $invoice->company->email }}</div>
                        @endif
                    </div>
                </div>
                
                <div class="invoice-meta">
                    <div class="invoice-title">
                        @if($invoice->type == 'standard')
                            فاتورة ضريبية معيارية
                        @else
                            فاتورة ضريبية مبسطة
                        @endif
                    </div>
                    <div class="invoice-number">رقم: {{ $invoice->invoice_number }}</div>
                    <div class="invoice-number">تاريخ: {{ $invoice->issue_date->format('Y-m-d') }}</div>
                </div>
            </div>
        </div>

        <!-- معلومات العميل والفاتورة -->
        <div class="info-section">
            <div class="info-box">
                <h3>معلومات المشتري</h3>
                @if($invoice->customer)
                    <div class="info-item">
                        <div class="info-label">الاسم:</div>
                        <div class="info-value">{{ $invoice->customer->name }}</div>
                    </div>
                    @if($invoice->customer->vat_number)
                        <div class="info-item">
                            <div class="info-label">الرقم الضريبي:</div>
                            <div class="info-value">{{ $invoice->customer->vat_number }}</div>
                        </div>
                    @endif
                    <div class="info-item">
                        <div class="info-label">العنوان:</div>
                        <div class="info-value">{{ $invoice->customer->getFullAddressAttribute() }}</div>
                    </div>
                    @if($invoice->customer->phone)
                        <div class="info-item">
                            <div class="info-label">الهاتف:</div>
                            <div class="info-value">{{ $invoice->customer->phone }}</div>
                        </div>
                    @endif
                @else
                    <div class="info-item">
                        <div class="info-label">الاسم:</div>
                        <div class="info-value">عميل غير محدد</div>
                    </div>
                @endif
            </div>
            
            <div class="info-box">
                <h3>تفاصيل الفاتورة</h3>
                <div class="info-item">
                    <div class="info-label">تاريخ الإصدار:</div>
                    <div class="info-value">{{ $invoice->issue_date->format('Y-m-d') }}</div>
                </div>
                <div class="info-item">
                    <div class="info-label">تاريخ التوريد:</div>
                    <div class="info-value">{{ $invoice->supply_date->format('Y-m-d') }}</div>
                </div>
                <div class="info-item">
                    <div class="info-label">العملة:</div>
                    <div class="info-value">{{ $invoice->currency }} (ريال سعودي)</div>
                </div>
                <div class="info-item">
                    <div class="info-label">الحالة:</div>
                    <div class="info-value">
                        @switch($invoice->status)
                            @case('cleared') مقبولة @break
                            @case('reported') مبلغة @break
                            @case('draft') مسودة @break
                            @case('rejected') مرفوضة @break
                            @default {{ $invoice->status }}
                        @endswitch
                    </div>
                </div>
            </div>
        </div>

        <!-- جدول العناصر -->
        <table class="items-table">
            <thead>
                <tr>
                    <th style="width: 5%;">م</th>
                    <th style="width: 35%;">الوصف</th>
                    <th style="width: 8%;">الكمية</th>
                    <th style="width: 8%;">الوحدة</th>
                    <th style="width: 12%;">سعر الوحدة</th>
                    <th style="width: 8%;">الخصم</th>
                    <th style="width: 12%;">الإجمالي</th>
                    <th style="width: 8%;">الضريبة</th>
                    <th style="width: 12%;">المجموع النهائي</th>
                </tr>
            </thead>
            <tbody>
                @foreach($invoice->items as $index => $item)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td class="description">
                        <div class="item-name">{{ $item->name }}</div>
                        @if($item->description)
                            <div class="item-desc">{{ $item->description }}</div>
                        @endif
                    </td>
                    <td>{{ number_format($item->quantity, 2) }}</td>
                    <td>{{ $item->unit ?? 'قطعة' }}</td>
                    <td>{{ number_format($item->unit_price, 2) }}</td>
                    <td>{{ number_format($item->discount_amount ?? 0, 2) }}</td>
                    <td>{{ number_format($item->line_total, 2) }}</td>
                    <td>{{ number_format($item->tax_amount, 2) }}</td>
                    <td><strong>{{ number_format($item->total_with_tax, 2) }}</strong></td>
                </tr>
                @endforeach
            </tbody>
        </table>

        <!-- الإجماليات -->
        <div class="totals-section">
            <div class="amount-words">
                <h4>المبلغ بالحروف:</h4>
                <p>
                    {{ \App\Helpers\ArabicNumberToWords::convert($invoice->total_amount, 'ريال سعودي', 'هللة') }}
                </p>
            </div>
            
            <table class="totals-table">
                <tr>
                    <td class="totals-label">المجموع الفرعي:</td>
                    <td class="totals-value">{{ number_format($invoice->subtotal, 2) }} ر.س</td>
                </tr>
                @if($invoice->discount_amount > 0)
                <tr>
                    <td class="totals-label">الخصم:</td>
                    <td class="totals-value">{{ number_format($invoice->discount_amount, 2) }} ر.س</td>
                </tr>
                @endif
                <tr>
                    <td class="totals-label">ضريبة القيمة المضافة:</td>
                    <td class="totals-value">{{ number_format($invoice->tax_amount, 2) }} ر.س</td>
                </tr>
                <tr class="grand-total">
                    <td class="totals-label">المجموع الكلي:</td>
                    <td class="totals-value">{{ number_format($invoice->total_amount, 2) }} ر.س</td>
                </tr>
            </table>
        </div>

        <!-- QR Code والملاحظات -->
        <div class="bottom-section">
            @if($invoice->qr_code)
                <div class="qr-section">
                    <div class="qr-title">رمز التحقق الإلكتروني</div>
                    <img src="{{ $invoice->getQrCodeDataUrl() }}" alt="QR Code" style="width:250px;height:250px;">
              
                </div>
            @endif
            
            @if($invoice->notes)
                <div class="notes-section">
                    <div class="notes-title">ملاحظات:</div>
                    <div class="notes-text">{{ $invoice->notes }}</div>
                </div>
            @endif
        </div>

        <!-- التذييل -->
        <div class="invoice-footer">
            <div class="footer-highlight">
                تم إنشاء هذه الفاتورة إلكترونياً وهي صالحة قانونياً
            </div>
            <div>تاريخ الطباعة: {{ now()->setTimezone('Asia/Riyadh')->format('Y-m-d H:i:s') }}</div>
            <div style="margin-top: 10px; font-weight: bold;">{{ $invoice->company->name ?? 'اسم الشركة' }}</div>
        </div>
    </div>

    <script>
        // تحسين تجربة الطباعة
        window.addEventListener('beforeprint', function() {
            document.body.classList.add('printing');
        });
        
        window.addEventListener('afterprint', function() {
            document.body.classList.remove('printing');
        });
    </script>
</body>
</html>