@extends('layouts.app')

@section('title', 'تحليلات المدفوعات المتقدمة')
@section('page-title', 'تحليلات المدفوعات المتقدمة')

@section('page-actions')
<div class="btn-group">
    <a href="{{ route('invoices.export-analytics', ['format' => 'csv']) }}" class="btn btn-outline-primary">
        <i class="fas fa-download me-2"></i>
        تصدير CSV
    </a>
    <a href="{{ route('invoices.export-analytics', ['format' => 'json']) }}" class="btn btn-outline-secondary">
        <i class="fas fa-code me-2"></i>
        تصدير JSON
    </a>
</div>
@endsection

@section('content')
<div class="container-fluid analytics-dashboard">
    <!-- بطاقات الإحصائيات العامة المحسّنة -->
    <div class="row mb-5">
        <div class="col-lg-3 col-md-6 mb-4">
            <div class="stat-card primary hover-lift fade-in-up">
                <i class="fas fa-chart-line stat-icon"></i>
                <div class="text-right">
                    <div class="stat-value">{{ number_format($analytics['totals']['revenue'], 0) }}</div>
                    <div class="stat-label">إجمالي الإيرادات (ر.س)</div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-4">
            <div class="stat-card success hover-lift fade-in-up" style="animation-delay: 0.1s">
                <i class="fas fa-money-bill-wave stat-icon"></i>
                <div class="text-right">
                    <div class="stat-value">{{ number_format($analytics['totals']['collected'], 0) }}</div>
                    <div class="stat-label">المحصل فعلياً (ر.س)</div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-4">
            <div class="stat-card warning hover-lift fade-in-up" style="animation-delay: 0.2s">
                <i class="fas fa-percentage stat-icon"></i>
                <div class="text-right">
                    <div class="stat-value">{{ $analytics['totals']['collection_rate'] }}%</div>
                    <div class="stat-label">معدل التحصيل</div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-4">
            <div class="stat-card info hover-lift fade-in-up" style="animation-delay: 0.3s">
                <i class="fas fa-clock stat-icon"></i>
                <div class="text-right">
                    <div class="stat-value">{{ $analytics['totals']['avg_collection_time'] }}</div>
                    <div class="stat-label">متوسط وقت التحصيل (يوم)</div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- مؤشرات إضافية محسّنة -->
    <div class="row mb-5">
        <div class="col-lg-3 col-md-6 mb-4">
            <div class="stat-card purple hover-lift fade-in-up" style="animation-delay: 0.4s">
                <i class="fas fa-hourglass-half stat-icon"></i>
                <div class="text-right">
                    <div class="stat-value">{{ number_format($analytics['totals']['pending'], 0) }}</div>
                    <div class="stat-label">قيد التحصيل (ر.س)</div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-4">
            <div class="stat-card danger hover-lift fade-in-up" style="animation-delay: 0.5s">
                <i class="fas fa-exclamation-triangle stat-icon"></i>
                <div class="text-right">
                    <div class="stat-value">{{ number_format($analytics['totals']['overdue'], 0) }}</div>
                    <div class="stat-label">متأخر السداد (ر.س)</div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-4">
            <div class="stat-card pink hover-lift fade-in-up" style="animation-delay: 0.6s">
                <i class="fas fa-{{ $analytics['totals']['revenue_growth'] >= 0 ? 'arrow-trend-up' : 'arrow-trend-down' }} stat-icon"></i>
                <div class="text-right">
                    <div class="stat-value">{{ $analytics['totals']['revenue_growth'] > 0 ? '+' : '' }}{{ $analytics['totals']['revenue_growth'] }}%</div>
                    <div class="stat-label">نمو الإيرادات (شهرياً)</div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-4">
            <div class="stat-card ocean hover-lift fade-in-up" style="animation-delay: 0.7s">
                <i class="fas fa-users stat-icon"></i>
                <div class="text-right">
                    <div class="stat-value">{{ count($analytics['top_customers']) }}</div>
                    <div class="stat-label">عملاء نشطون</div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- الرسوم البيانية المحسّنة -->
    <div class="row mb-5">
        <div class="col-xl-8 col-lg-7 mb-4">
            <!-- رسم الإيرادات الشهرية -->
            <div class="card hover-lift fade-in-left mb-4">
                <div class="enhanced-card-header">
                    <h5 class="mb-0">
                        <i class="fas fa-chart-line me-2"></i>
                        تطور الإيرادات الشهرية
                    </h5>
                </div>
                <div class="card-body p-0">
                    <div class="chart-container">
                        <canvas id="revenueChart"></canvas>
                    </div>
                </div>
            </div>
            
            <!-- رسم معدل التحصيل -->
            <div class="card hover-lift fade-in-left mb-4">
                <div class="enhanced-card-header">
                    <h5 class="mb-0">
                        <i class="fas fa-percentage me-2"></i>
                        معدل التحصيل ومتوسط الأوقات
                    </h5>
                </div>
                <div class="card-body p-0">
                    <div class="chart-container">
                        <canvas id="trendsChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-xl-4 col-lg-5 mb-4">
            <!-- طرق السداد -->
            <div class="card hover-lift fade-in-right mb-4">
                <div class="enhanced-card-header">
                    <h5 class="mb-0">
                        <i class="fas fa-credit-card me-2"></i>
                        توزيع طرق السداد
                    </h5>
                </div>
                <div class="card-body">
                    <div class="doughnut-chart-container mb-4">
                        <canvas id="paymentMethodsChart"></canvas>
                    </div>
                    
                    <div class="payment-methods-legend">
                        @foreach($analytics['payment_methods'] as $method => $count)
                            @if($count > 0)
                            <div class="d-flex justify-content-between align-items-center mb-3 p-2 rounded" style="background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);">
                                <div class="d-flex align-items-center">
                                    <div class="method-indicator me-3" style="width: 12px; height: 12px; border-radius: 50%; background:
                                        @switch($method)
                                            @case('cash') #3498db @break
                                            @case('bank_transfer') #27ae60 @break
                                            @case('credit_card') #f39c12 @break
                                            @case('check') #e74c3c @break
                                            @case('installment') #9b59b6 @break
                                            @default #95a5a6
                                        @endswitch
                                    "></div>
                                    <span class="fw-medium">
                                        @switch($method)
                                            @case('cash') نقداً @break
                                            @case('bank_transfer') تحويل بنكي @break
                                            @case('credit_card') بطاقة ائتمان @break
                                            @case('check') شيك @break
                                            @case('installment') تقسيط @break
                                            @default {{ $method }}
                                        @endswitch
                                    </span>
                                </div>
                                <span class="enhanced-badge bg-primary">{{ $count }}</span>
                            </div>
                            @endif
                        @endforeach
                    </div>
                </div>
            </div>
            
            <!-- تحليل الديون حسب العمر -->
            <div class="card hover-lift fade-in-right">
                <div class="enhanced-card-header">
                    <h5 class="mb-0">
                        <i class="fas fa-chart-pie me-2"></i>
                        تحليل الديون حسب العمر
                    </h5>
                </div>
                <div class="card-body">
                    <div class="pie-chart-container mb-4">
                        <canvas id="debtAnalysisChart"></canvas>
                    </div>
                    
                    <div class="debt-analysis-legend">
                        @foreach($analytics['debt_analysis'] as $range => $amount)
                            @if($amount > 0)
                            <div class="d-flex justify-content-between align-items-center mb-3 p-3 rounded" style="background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%); border-left: 4px solid
                                @if($range === '+90 يوم') #dc3545
                                @elseif($range === '61-90 يوم') #ffc107
                                @else #17a2b8
                                @endif
                            ">
                                <div>
                                    <div class="fw-bold text-dark">{{ $range }}</div>
                                    <small class="text-muted">فترة الاستحقاق</small>
                                </div>
                                <div class="text-right">
                                    <div class="fw-bold text-{{ $range === '+90 يوم' ? 'danger' : ($range === '61-90 يوم' ? 'warning' : 'info') }}" style="font-size: 1.1rem;">
                                        {{ number_format($amount, 0) }} ر.س
                                    </div>
                                </div>
                            </div>
                            @endif
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- جدول أفضل العملاء المحسّن -->
    <div class="row">
        <div class="col-12">
            <div class="analytics-table hover-scale fade-in-up">
                <div class="enhanced-card-header">
                    <h5 class="mb-0">
                        <i class="fas fa-trophy me-2"></i>
                        أفضل العملاء (أعلى إيرادات)
                    </h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead>
                                <tr>
                                    <th width="10%">الترتيب</th>
                                    <th width="25%">اسم العميل</th>
                                    <th width="15%">عدد الفواتير</th>
                                    <th width="20%">إجمالي المبلغ</th>
                                    <th width="20%">معدل السداد</th>
                                    <th width="10%">التقييم</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($analytics['top_customers'] as $index => $customer)
                                <tr class="customer-row">
                                    <td class="text-center">
                                        <div class="d-flex align-items-center justify-content-center">
                                            @if($index < 3)
                                                <i class="fas fa-medal me-2 text-{{ $index === 0 ? 'warning' : ($index === 1 ? 'secondary' : 'dark') }}" style="font-size: 1.2rem;"></i>
                                            @endif
                                            <span class="fw-bold" style="font-size: 1.1rem;">{{ $index + 1 }}</span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="customer-avatar me-3 d-flex align-items-center justify-content-center"
                                                 style="width: 40px; height: 40px; border-radius: 50%; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; font-weight: bold;">
                                                {{ substr($customer['name'], 0, 1) }}
                                            </div>
                                            <div>
                                                <div class="fw-bold text-dark">{{ $customer['name'] }}</div>
                                                <small class="text-muted">عميل نشط</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <span class="enhanced-badge bg-info">{{ $customer['invoices_count'] }} فاتورة</span>
                                    </td>
                                    <td>
                                        <div class="fw-bold" style="color: #667eea; font-size: 1.1rem;">{{ number_format($customer['total_amount'], 2) }} ر.س</div>
                                    </td>
                                    <td>
                                        <div class="enhanced-progress mb-1">
                                            <div class="progress-bar bg-{{ $customer['payment_rate'] >= 90 ? 'success' : ($customer['payment_rate'] >= 70 ? 'warning' : 'danger') }}"
                                                 style="width: {{ $customer['payment_rate'] }}%">
                                            </div>
                                        </div>
                                        <small class="text-muted">{{ $customer['payment_rate'] }}% معدل السداد</small>
                                    </td>
                                    <td class="text-center">
                                        @if($customer['payment_rate'] >= 90)
                                            <span class="enhanced-badge bg-success">ممتاز</span>
                                        @elseif($customer['payment_rate'] >= 70)
                                            <span class="enhanced-badge bg-warning">جيد</span>
                                        @else
                                            <span class="enhanced-badge bg-danger">يحتاج متابعة</span>
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                                
                                @if(count($analytics['top_customers']) === 0)
                                <tr>
                                    <td colspan="6" class="text-center py-5">
                                        <div class="empty-state">
                                            <i class="fas fa-inbox text-muted mb-3" style="font-size: 3rem; opacity: 0.5;"></i>
                                            <h6 class="text-muted">لا توجد بيانات متاحة حالياً</h6>
                                            <p class="text-muted small mb-0">لم يتم العثور على عملاء في الفترة المحددة</p>
                                        </div>
                                    </td>
                                </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<link href="{{ asset('css/analytics-enhancements.css') }}" rel="stylesheet">
<style>
/* ========== Enhanced Payment Analytics Styles ========== */
:root {
    --analytics-primary: #1e3a8a;
    --analytics-secondary: #3b82f6;
    --analytics-success: #059669;
    --analytics-warning: #d97706;
    --analytics-danger: #dc2626;
    --analytics-info: #0284c7;
    --analytics-purple: #7c3aed;
    --analytics-pink: #db2777;
    --analytics-teal: #0d9488;
    
    /* Gradient Palettes */
    --gradient-blue: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    --gradient-green: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
    --gradient-orange: linear-gradient(135deg, #ff7e5f 0%, #feb47b 100%);
    --gradient-purple: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    --gradient-pink: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    --gradient-teal: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
    --gradient-sunset: linear-gradient(135deg, #fa709a 0%, #fee140 100%);
    --gradient-ocean: linear-gradient(135deg, #2196F3 0%, #21CBF3 100%);
    
    /* Enhanced Shadows */
    --shadow-card: 0 4px 20px rgba(0, 0, 0, 0.1);
    --shadow-card-hover: 0 8px 30px rgba(0, 0, 0, 0.15);
    --shadow-deep: 0 10px 40px rgba(0, 0, 0, 0.2);
}

/* ========== Enhanced Card Styles ========== */
.analytics-dashboard .card {
    border: none;
    border-radius: 20px;
    box-shadow: var(--shadow-card);
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    overflow: hidden;
    position: relative;
    backdrop-filter: blur(10px);
}

.analytics-dashboard .card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(135deg, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0.05) 100%);
    pointer-events: none;
    z-index: 1;
}

.analytics-dashboard .card:hover {
    transform: translateY(-8px);
    box-shadow: var(--shadow-card-hover);
}

/* Enhanced Stat Cards */
.stat-card {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border-radius: 20px;
    padding: 2rem 1.5rem;
    position: relative;
    overflow: hidden;
}

.stat-card::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -50%;
    width: 100%;
    height: 200%;
    background: linear-gradient(45deg, transparent 30%, rgba(255,255,255,0.1) 50%, transparent 70%);
    transform: rotate(45deg);
    transition: all 0.6s ease;
    opacity: 0;
}

.stat-card:hover::before {
    animation: shimmer 1.5s ease-in-out;
}

@keyframes shimmer {
    0% { transform: translateX(-100%) rotate(45deg); opacity: 0; }
    50% { opacity: 1; }
    100% { transform: translateX(100%) rotate(45deg); opacity: 0; }
}

.stat-card .stat-value {
    font-size: 2.5rem;
    font-weight: 800;
    line-height: 1;
    margin-bottom: 0.5rem;
    text-shadow: 0 2px 10px rgba(0,0,0,0.2);
}

.stat-card .stat-label {
    font-size: 0.9rem;
    opacity: 0.9;
    font-weight: 500;
}

.stat-card .stat-icon {
    position: absolute;
    top: 1.5rem;
    left: 1.5rem;
    font-size: 2.5rem;
    opacity: 0.3;
    transition: all 0.3s ease;
}

.stat-card:hover .stat-icon {
    opacity: 0.6;
    transform: scale(1.1);
}

/* Individual card color schemes */
.stat-card.primary { background: var(--gradient-blue); }
.stat-card.success { background: var(--gradient-green); }
.stat-card.warning { background: var(--gradient-orange); }
.stat-card.info { background: var(--gradient-teal); }
.stat-card.purple { background: var(--gradient-purple); }
.stat-card.pink { background: var(--gradient-pink); }
.stat-card.danger { background: linear-gradient(135deg, #ff416c 0%, #ff4b2b 100%); }
.stat-card.ocean { background: var(--gradient-ocean); }

/* ========== Chart Container Enhancements ========== */
.chart-container {
    position: relative;
    height: 400px;
    width: 100%;
    overflow: hidden;
    padding: 20px;
    background: linear-gradient(145deg, #ffffff 0%, #f8fafc 100%);
    border-radius: 20px;
    box-shadow: var(--shadow-card);
}

.chart-container canvas {
    max-height: 360px !important;
    max-width: 100% !important;
}

.pie-chart-container, .doughnut-chart-container {
    position: relative;
    height: 320px;
    width: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    overflow: hidden;
    padding: 20px;
    background: linear-gradient(145deg, #ffffff 0%, #f8fafc 100%);
    border-radius: 20px;
}

/* ========== Enhanced Table Styles ========== */
.analytics-table {
    background: white;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: var(--shadow-card);
}

.analytics-table .table {
    margin-bottom: 0;
}

.analytics-table .table thead th {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: none;
    font-weight: 600;
    padding: 1.2rem 1rem;
    text-align: center;
}

.analytics-table .table tbody tr {
    transition: all 0.3s ease;
    border-bottom: 1px solid #f1f5f9;
}

.analytics-table .table tbody tr:hover {
    background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
    transform: scale(1.01);
}

.analytics-table .table tbody td {
    padding: 1rem;
    vertical-align: middle;
    border: none;
}

/* ========== Progress Bar Enhancements ========== */
.enhanced-progress {
    height: 12px;
    border-radius: 10px;
    background: #e2e8f0;
    overflow: hidden;
    position: relative;
    box-shadow: inset 0 2px 4px rgba(0,0,0,0.1);
}

.enhanced-progress .progress-bar {
    border-radius: 10px;
    position: relative;
    overflow: hidden;
    transition: all 0.8s cubic-bezier(0.4, 0, 0.2, 1);
}

.enhanced-progress .progress-bar::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.4), transparent);
    animation: progressShine 2s infinite;
}

@keyframes progressShine {
    0% { left: -100%; }
    100% { left: 100%; }
}

/* ========== Badge Enhancements ========== */
.enhanced-badge {
    padding: 0.5rem 1rem;
    border-radius: 50px;
    font-weight: 600;
    font-size: 0.8rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.15);
    position: relative;
    overflow: hidden;
}

.enhanced-badge::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
    transition: left 0.5s ease;
}

.enhanced-badge:hover::before {
    left: 100%;
}

/* ========== Card Header Enhancements ========== */
.enhanced-card-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 1.5rem 2rem;
    border-radius: 20px 20px 0 0;
    position: relative;
    overflow: hidden;
}

.enhanced-card-header::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(135deg, rgba(255,255,255,0.1) 0%, transparent 100%);
}

.enhanced-card-header h5 {
    margin: 0;
    font-weight: 700;
    font-size: 1.2rem;
    text-shadow: 0 2px 4px rgba(0,0,0,0.2);
    position: relative;
    z-index: 2;
}

.enhanced-card-header i {
    margin-left: 10px;
    opacity: 0.8;
}

/* ========== Animation Classes ========== */
.fade-in-up {
    animation: fadeInUp 0.6s ease-out;
}

.fade-in-left {
    animation: fadeInLeft 0.6s ease-out;
}

.fade-in-right {
    animation: fadeInRight 0.6s ease-out;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

@keyframes fadeInLeft {
    from {
        opacity: 0;
        transform: translateX(-30px);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

@keyframes fadeInRight {
    from {
        opacity: 0;
        transform: translateX(30px);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

/* ========== Responsive Enhancements ========== */
@media (max-width: 768px) {
    .stat-card {
        padding: 1.5rem 1rem;
        margin-bottom: 1rem;
    }
    
    .stat-card .stat-value {
        font-size: 2rem;
    }
    
    .chart-container {
        height: 300px;
        padding: 15px;
    }
    
    .analytics-table .table thead th,
    .analytics-table .table tbody td {
        padding: 0.8rem 0.5rem;
        font-size: 0.9rem;
    }
}

/* ========== Loading States ========== */
.chart-loading {
    display: flex;
    align-items: center;
    justify-content: center;
    height: 300px;
    background: linear-gradient(45deg, #f8fafc, #e2e8f0);
    border-radius: 20px;
    position: relative;
    overflow: hidden;
}

.chart-loading::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.4), transparent);
    animation: loading 1.5s infinite;
}

@keyframes loading {
    0% { left: -100%; }
    100% { left: 100%; }
}

/* ========== Hover Effects ========== */
.hover-lift {
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

.hover-lift:hover {
    transform: translateY(-5px);
    box-shadow: var(--shadow-card-hover);
}

.hover-scale {
    transition: transform 0.3s ease;
}

.hover-scale:hover {
    transform: scale(1.02);
}
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels@2"></script>
<script src="{{ asset('js/payment-analytics.js') }}"></script>

<script>
// بيانات خاصة بهذه الصفحة
window.analyticsData = {
    monthlyData: @json($analytics['monthly_data']),
    paymentMethods: @json($analytics['payment_methods']),
    debtAnalysis: @json($analytics['debt_analysis']),
    totals: @json($analytics['totals'])
};

$(document).ready(function() {
    const { monthlyData, paymentMethods, debtAnalysis } = window.analyticsData;
    
    // ألوان محسّنة
    const colors = {
        primary: '#667eea',
        success: '#11998e',
        warning: '#f7931e',
        danger: '#ff416c',
        info: '#4facfe'
    };
    
    // رسم الإيرادات الشهرية المحسّن
    const revenueCtx = document.getElementById('revenueChart').getContext('2d');
    const revenueGradient1 = revenueCtx.createLinearGradient(0, 0, 0, 400);
    revenueGradient1.addColorStop(0, 'rgba(102, 126, 234, 0.8)');
    revenueGradient1.addColorStop(1, 'rgba(102, 126, 234, 0.1)');
    
    const revenueGradient2 = revenueCtx.createLinearGradient(0, 0, 0, 400);
    revenueGradient2.addColorStop(0, 'rgba(17, 153, 142, 0.8)');
    revenueGradient2.addColorStop(1, 'rgba(56, 239, 125, 0.1)');
    
    new Chart(revenueCtx, {
        type: 'line',
        data: {
            labels: monthlyData.map(item => item.month_name),
            datasets: [{
                label: 'إجمالي الإيرادات',
                data: monthlyData.map(item => item.revenue),
                borderColor: colors.primary,
                backgroundColor: revenueGradient1,
                borderWidth: 3,
                pointRadius: 6,
                pointHoverRadius: 8,
                pointBackgroundColor: '#ffffff',
                pointBorderColor: colors.primary,
                pointBorderWidth: 3,
                tension: 0.4,
                fill: true
            }, {
                label: 'المحصل فعلياً',
                data: monthlyData.map(item => item.collected),
                borderColor: colors.success,
                backgroundColor: revenueGradient2,
                borderWidth: 3,
                pointRadius: 6,
                pointHoverRadius: 8,
                pointBackgroundColor: '#ffffff',
                pointBorderColor: colors.success,
                pointBorderWidth: 3,
                tension: 0.4,
                fill: true
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            interaction: {
                intersect: false,
                mode: 'index',
            },
            plugins: {
                legend: {
                    position: 'top',
                    labels: {
                        padding: 20,
                        font: { size: 13, weight: '600' }
                    }
                },
                tooltip: {
                    backgroundColor: 'rgba(255, 255, 255, 0.95)',
                    titleColor: '#333',
                    bodyColor: '#666',
                    borderColor: '#e2e8f0',
                    borderWidth: 1,
                    cornerRadius: 12,
                    callbacks: {
                        label: function(context) {
                            return context.dataset.label + ': ' + context.parsed.y.toLocaleString() + ' ر.س';
                        }
                    }
                }
            },
            scales: {
                x: {
                    grid: { display: false },
                    ticks: { font: { size: 12, weight: '500' } }
                },
                y: {
                    beginAtZero: true,
                    grid: { color: 'rgba(0, 0, 0, 0.05)' },
                    ticks: {
                        font: { size: 12 },
                        callback: function(value) {
                            return value.toLocaleString() + ' ر.س';
                        }
                    }
                }
            },
            animation: {
                duration: 2000,
                easing: 'easeInOutQuart'
            }
        }
    });
    
    // رسم طرق السداد المحسّن
    const paymentMethodsCtx = document.getElementById('paymentMethodsChart').getContext('2d');
    const methodLabels = {
        'cash': 'نقداً',
        'bank_transfer': 'تحويل بنكي',
        'credit_card': 'بطاقة ائتمان',
        'check': 'شيك',
        'installment': 'تقسيط'
    };
    
    const methodsData = Object.entries(paymentMethods)
        .filter(([key, value]) => value > 0)
        .map(([key, value]) => ({
            label: methodLabels[key] || key,
            value: value
        }));
    
    new Chart(paymentMethodsCtx, {
        type: 'doughnut',
        data: {
            labels: methodsData.map(item => item.label),
            datasets: [{
                data: methodsData.map(item => item.value),
                backgroundColor: [colors.primary, colors.success, colors.warning, colors.danger, colors.info],
                borderWidth: 0,
                hoverBorderWidth: 2,
                hoverBorderColor: '#ffffff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            cutout: '60%',
            plugins: {
                legend: { display: false },
                tooltip: {
                    backgroundColor: 'rgba(255, 255, 255, 0.95)',
                    titleColor: '#333',
                    bodyColor: '#666',
                    borderColor: '#e2e8f0',
                    borderWidth: 1,
                    cornerRadius: 12,
                    callbacks: {
                        label: function(context) {
                            const total = context.dataset.data.reduce((a, b) => a + b, 0);
                            const percentage = ((context.parsed / total) * 100).toFixed(1);
                            return context.label + ': ' + context.parsed + ' (' + percentage + '%)';
                        }
                    }
                }
            },
            animation: { duration: 2000, easing: 'easeInOutQuart' }
        }
    });
    
    // رسم تحليل الديون المحسّن
    const debtCtx = document.getElementById('debtAnalysisChart').getContext('2d');
    const debtData = Object.entries(debtAnalysis).filter(([key, value]) => value > 0);
    
    new Chart(debtCtx, {
        type: 'pie',
        data: {
            labels: debtData.map(([key]) => key),
            datasets: [{
                data: debtData.map(([, value]) => value),
                backgroundColor: [colors.info, colors.warning, '#ff7f50', colors.danger],
                borderWidth: 0,
                hoverBorderWidth: 2,
                hoverBorderColor: '#ffffff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: { display: false },
                tooltip: {
                    backgroundColor: 'rgba(255, 255, 255, 0.95)',
                    titleColor: '#333',
                    bodyColor: '#666',
                    borderColor: '#e2e8f0',
                    borderWidth: 1,
                    cornerRadius: 12,
                    callbacks: {
                        label: function(context) {
                            const total = context.dataset.data.reduce((a, b) => a + b, 0);
                            const percentage = ((context.parsed / total) * 100).toFixed(1);
                            return context.label + ': ' + context.parsed.toLocaleString() + ' ر.س (' + percentage + '%)';
                        }
                    }
                }
            },
            animation: { duration: 2000, easing: 'easeInOutQuart' }
        }
    });
    
    // رسم الاتجاهات المحسّن
    fetch('{{ route("invoices.chart-data") }}?type=trends')
        .then(response => response.json())
        .then(data => {
            const trendsCtx = document.getElementById('trendsChart').getContext('2d');
            const trendsGradient1 = trendsCtx.createLinearGradient(0, 0, 0, 400);
            trendsGradient1.addColorStop(0, 'rgba(17, 153, 142, 0.6)');
            trendsGradient1.addColorStop(1, 'rgba(17, 153, 142, 0.1)');
            
            const trendsGradient2 = trendsCtx.createLinearGradient(0, 0, 0, 400);
            trendsGradient2.addColorStop(0, 'rgba(255, 65, 108, 0.6)');
            trendsGradient2.addColorStop(1, 'rgba(255, 65, 108, 0.1)');
            
            new Chart(trendsCtx, {
                type: 'line',
                data: {
                    labels: data.map(item => item.month),
                    datasets: [{
                        label: 'معدل التحصيل (%)',
                        data: data.map(item => item.collection_rate),
                        borderColor: colors.success,
                        backgroundColor: trendsGradient1,
                        borderWidth: 3,
                        pointRadius: 6,
                        pointHoverRadius: 8,
                        pointBackgroundColor: '#ffffff',
                        pointBorderColor: colors.success,
                        pointBorderWidth: 3,
                        yAxisID: 'y',
                        tension: 0.4,
                        fill: true
                    }, {
                        label: 'متوسط وقت التحصيل (يوم)',
                        data: data.map(item => item.avg_collection_days),
                        borderColor: colors.danger,
                        backgroundColor: trendsGradient2,
                        borderWidth: 3,
                        pointRadius: 6,
                        pointHoverRadius: 8,
                        pointBackgroundColor: '#ffffff',
                        pointBorderColor: colors.danger,
                        pointBorderWidth: 3,
                        yAxisID: 'y1',
                        tension: 0.4,
                        fill: true
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    interaction: { mode: 'index', intersect: false },
                    plugins: {
                        legend: {
                            position: 'top',
                            labels: { padding: 20, font: { size: 13, weight: '600' } }
                        },
                        tooltip: {
                            backgroundColor: 'rgba(255, 255, 255, 0.95)',
                            titleColor: '#333',
                            bodyColor: '#666',
                            borderColor: '#e2e8f0',
                            borderWidth: 1,
                            cornerRadius: 12
                        }
                    },
                    scales: {
                        x: { grid: { display: false } },
                        y: {
                            type: 'linear',
                            display: true,
                            position: 'left',
                            min: 0,
                            max: 100,
                            grid: { color: 'rgba(0, 0, 0, 0.05)' },
                            ticks: { callback: function(value) { return value + '%'; } }
                        },
                        y1: {
                            type: 'linear',
                            display: true,
                            position: 'right',
                            min: 0,
                            grid: { drawOnChartArea: false },
                            ticks: { callback: function(value) { return value + ' يوم'; } }
                        }
                    },
                    animation: { duration: 2000, easing: 'easeInOutQuart' }
                }
            });
        }).catch(console.error);
});
</script>
@endpush