@extends('layouts.app')

@section('title', 'إعدادات الإشعارات')
@section('page-title', 'إعدادات الإشعارات')

@push('styles')
<style>
:root {
    --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    --success-gradient: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
    --warning-gradient: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    --info-gradient: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
    --danger-gradient: linear-gradient(135deg, #fa709a 0%, #fee140 100%);
    --card-shadow: 0 10px 30px rgba(0,0,0,0.1);
    --card-shadow-hover: 0 20px 40px rgba(0,0,0,0.15);
}

.notification-settings-page {
    background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
    min-height: 100vh;
    padding: 2rem 0;
}

.settings-card {
    background: white;
    border-radius: 20px;
    box-shadow: var(--card-shadow);
    border: none;
    overflow: hidden;
    transition: all 0.3s ease;
    margin-bottom: 2rem;
}

.settings-card:hover {
    box-shadow: var(--card-shadow-hover);
    transform: translateY(-5px);
}

.settings-card .card-header {
    background: var(--primary-gradient);
    color: white;
    border: none;
    padding: 1.5rem 2rem;
    position: relative;
    overflow: hidden;
}

.settings-card .card-header::before {
    content: '';
    position: absolute;
    top: 0;
    right: 0;
    width: 100px;
    height: 100px;
    background: rgba(255,255,255,0.1);
    border-radius: 50%;
    transform: translate(30px, -30px);
}

.settings-card .card-header h5 {
    font-weight: 600;
    margin: 0;
    font-size: 1.25rem;
}

.settings-card .card-body {
    padding: 2rem;
}

.section-title {
    color: #4a5568;
    font-weight: 600;
    font-size: 1.1rem;
    margin-bottom: 1.5rem;
    padding-bottom: 0.5rem;
    border-bottom: 2px solid #e2e8f0;
    position: relative;
}

.section-title::after {
    content: '';
    position: absolute;
    bottom: -2px;
    right: 0;
    width: 50px;
    height: 2px;
    background: var(--primary-gradient);
    border-radius: 1px;
}

.section-title i {
    color: #667eea;
    margin-left: 0.5rem;
}

.form-group-modern {
    margin-bottom: 1.5rem;
    position: relative;
}

.form-control-modern {
    border: 2px solid #e2e8f0;
    border-radius: 12px;
    padding: 0.75rem 1rem;
    transition: all 0.3s ease;
    font-size: 0.95rem;
    background: #f8fafc;
}

.form-control-modern:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    background: white;
    outline: none;
}

.form-label-modern {
    font-weight: 600;
    color: #2d3748;
    margin-bottom: 0.5rem;
    font-size: 0.9rem;
}

.switch-container {
    background: #f7fafc;
    border: 2px solid #e2e8f0;
    border-radius: 15px;
    padding: 1.5rem;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.switch-container::before {
    content: '';
    position: absolute;
    top: 0;
    right: 0;
    width: 60px;
    height: 60px;
    background: linear-gradient(135deg, rgba(102, 126, 234, 0.1), rgba(118, 75, 162, 0.1));
    border-radius: 50%;
    transform: translate(20px, -20px);
}

.switch-container:hover {
    background: white;
    border-color: #667eea;
    transform: translateY(-2px);
}

.form-switch .form-check-input {
    width: 3rem;
    height: 1.5rem;
    background-color: #cbd5e0;
    background-image: none;
    border: none;
    border-radius: 1rem;
    position: relative;
    transition: all 0.3s ease;
}

.form-switch .form-check-input:checked {
    background: var(--success-gradient);
    border-color: transparent;
}

.form-switch .form-check-input:focus {
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.25);
}

.form-switch .form-check-label {
    font-weight: 600;
    color: #2d3748;
    margin-right: 1rem;
}

.switch-description {
    color: #718096;
    font-size: 0.85rem;
    margin-top: 0.5rem;
    font-style: italic;
}

.btn-modern {
    border-radius: 12px;
    font-weight: 600;
    padding: 0.75rem 1.5rem;
    border: none;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.btn-modern::before {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    width: 0;
    height: 0;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    transform: translate(-50%, -50%);
    transition: all 0.3s ease;
}

.btn-modern:hover::before {
    width: 300px;
    height: 300px;
}

.btn-primary-modern {
    background: var(--primary-gradient);
    color: white;
}

.btn-primary-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(102, 126, 234, 0.4);
}

.btn-success-modern {
    background: var(--success-gradient);
    color: white;
}

.btn-success-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(17, 153, 142, 0.4);
}

.btn-warning-modern {
    background: var(--warning-gradient);
    color: white;
}

.btn-warning-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(240, 147, 251, 0.4);
}

.btn-outline-modern {
    background: transparent;
    border: 2px solid #e2e8f0;
    color: #4a5568;
}

.btn-outline-modern:hover {
    background: #f7fafc;
    border-color: #667eea;
    color: #667eea;
}

.stats-card {
    text-align: center;
    padding: 1.5rem;
    border-radius: 15px;
    background: white;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    border: 1px solid #e2e8f0;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.stats-card::before {
    content: '';
    position: absolute;
    top: 0;
    right: 0;
    left: 0;
    height: 4px;
    background: var(--primary-gradient);
}

.stats-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.1);
}

.stats-number {
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 0.25rem;
    background: var(--primary-gradient);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.stats-label {
    font-size: 0.85rem;
    color: #718096;
    font-weight: 500;
}

.alert-modern {
    border: none;
    border-radius: 12px;
    padding: 1rem 1.5rem;
    font-weight: 500;
    position: relative;
    overflow: hidden;
}

.alert-modern::before {
    content: '';
    position: absolute;
    top: 0;
    right: 0;
    left: 0;
    height: 3px;
}

.alert-success {
    background: linear-gradient(135deg, #d4edda, #c3e6cb);
    color: #155724;
    border-left: 4px solid #28a745;
}

.alert-danger {
    background: linear-gradient(135deg, #f8d7da, #f5c6cb);
    color: #721c24;
    border-left: 4px solid #dc3545;
}

.loading-spinner {
    display: inline-block;
    width: 1rem;
    height: 1rem;
    border: 2px solid rgba(255,255,255,.3);
    border-radius: 50%;
    border-top-color: #fff;
    animation: spin 1s ease-in-out infinite;
}

@keyframes spin {
    to { transform: rotate(360deg); }
}

.fade-in {
    animation: fadeIn 0.5s ease-in;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

.info-tooltip {
    background: var(--info-gradient);
    color: white;
    padding: 0.5rem 1rem;
    border-radius: 8px;
    font-size: 0.8rem;
    margin-top: 1rem;
    border-left: 4px solid rgba(255,255,255,0.3);
}

.textarea-modern {
    border: 2px solid #e2e8f0;
    border-radius: 12px;
    padding: 1rem;
    resize: vertical;
    min-height: 120px;
    background: #f8fafc;
    transition: all 0.3s ease;
}

.textarea-modern:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    background: white;
    outline: none;
}

@media (max-width: 768px) {
    .notification-settings-page {
        padding: 1rem 0;
    }
    
    .settings-card .card-body {
        padding: 1.5rem;
    }
    
    .stats-card {
        margin-bottom: 1rem;
    }
}
</style>
@endpush

@section('content')
<div class="notification-settings-page">
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-8 col-lg-8 col-md-12">
                <!-- بطاقة الإعدادات العامة -->
                <div class="settings-card fade-in">
                    <div class="card-header">
                        <h5>
                            <i class="fas fa-cog"></i>
                            الإعدادات العامة للإشعارات
                        </h5>
                    </div>
                    <div class="card-body">
                        <form id="notificationSettingsForm" method="POST" action="{{ route('invoices.save-notification-settings') }}">
                            @csrf
                            
                            <!-- إعدادات أساسية -->
                            <h6 class="section-title">
                                <i class="fas fa-bell"></i>
                                إعدادات أساسية
                            </h6>
                            
                            <div class="row">
                                <div class="col-lg-6 col-md-12 mb-3">
                                    <div class="switch-container">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" 
                                                   id="auto_notifications" name="auto_notifications"
                                                   {{ $settings['auto_notifications'] ? 'checked' : '' }}>
                                            <label class="form-check-label" for="auto_notifications">
                                                تفعيل الإشعارات التلقائية
                                            </label>
                                        </div>
                                        <div class="switch-description">إرسال إشعارات تلقائية عند إنشاء الفواتير</div>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 col-md-12 mb-3">
                                    <div class="switch-container">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" 
                                                   id="payment_reminders" name="payment_reminders"
                                                   {{ $settings['payment_reminders'] ? 'checked' : '' }}>
                                            <label class="form-check-label" for="payment_reminders">
                                                تفعيل تذكيرات السداد
                                            </label>
                                        </div>
                                        <div class="switch-description">إرسال تذكيرات للفواتير المتأخرة</div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- إعدادات البريد الإلكتروني -->
                            <h6 class="section-title">
                                <i class="fas fa-envelope"></i>
                                إعدادات البريد الإلكتروني
                            </h6>
                            
                            <div class="row">
                                <div class="col-lg-6 col-md-12">
                                    <div class="form-group-modern">
                                        <label for="default_creditor_email" class="form-label-modern">بريد الدائن الافتراضي</label>
                                        <input type="email" class="form-control form-control-modern" 
                                               id="default_creditor_email" name="default_creditor_email" 
                                               value="{{ $settings['default_creditor_email'] }}"
                                               placeholder="admin@company.com">
                                        <small class="switch-description">البريد الذي سيستقبل إشعارات الإدارة</small>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 col-md-12">
                                    <div class="form-group-modern">
                                        <label for="sender_name" class="form-label-modern">اسم المرسل</label>
                                        <input type="text" class="form-control form-control-modern" 
                                               id="sender_name" name="sender_name" 
                                               value="{{ $settings['sender_name'] }}" required>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-lg-6 col-md-12">
                                    <div class="form-group-modern">
                                        <label for="new_invoice_subject" class="form-label-modern">عنوان الفاتورة الجديدة</label>
                                        <input type="text" class="form-control form-control-modern" 
                                               id="new_invoice_subject" name="new_invoice_subject" 
                                               value="{{ $settings['new_invoice_subject'] }}" required>
                                        <small class="switch-description">يمكن استخدام {invoice_number}</small>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 col-md-12">
                                    <div class="form-group-modern">
                                        <label for="reminder_subject" class="form-label-modern">عنوان تذكير السداد</label>
                                        <input type="text" class="form-control form-control-modern" 
                                               id="reminder_subject" name="reminder_subject" 
                                               value="{{ $settings['reminder_subject'] }}" required>
                                        <small class="switch-description">يمكن استخدام {invoice_number}</small>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- إعدادات الواتساب -->
                            <h6 class="section-title">
                                <i class="fab fa-whatsapp"></i>
                                إعدادات الواتساب
                            </h6>
                            
                            <div class="row">
                                <div class="col-lg-6 col-md-12 mb-3">
                                    <div class="switch-container">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" 
                                                   id="whatsapp_enabled" name="whatsapp_enabled"
                                                   {{ $settings['whatsapp_enabled'] ? 'checked' : '' }}>
                                            <label class="form-check-label" for="whatsapp_enabled">
                                                تفعيل الواتساب
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 col-md-12 mb-3">
                                    <div class="switch-container">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" 
                                                   id="whatsapp_auto" name="whatsapp_auto"
                                                   {{ $settings['whatsapp_auto'] ? 'checked' : '' }}>
                                            <label class="form-check-label" for="whatsapp_auto">
                                                إرسال تلقائي عبر الواتساب
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group-modern">
                                <label for="whatsapp_template" class="form-label-modern">قالب رسالة الواتساب</label>
                                <textarea class="form-control textarea-modern" id="whatsapp_template" 
                                          name="whatsapp_template" required>{{ $settings['whatsapp_template'] }}</textarea>
                                <div class="info-tooltip">
                                    <i class="fas fa-info-circle me-2"></i>
                                    يمكن استخدام: {customer_name}, {invoice_number}, {total_amount}, {company_name}
                                </div>
                            </div>
                            
                            <!-- إعدادات التذكيرات -->
                            <h6 class="section-title">
                                <i class="fas fa-clock"></i>
                                إعدادات التذكيرات
                            </h6>
                            
                            <div class="row">
                                <div class="col-lg-4 col-md-12">
                                    <div class="form-group-modern">
                                        <label for="first_reminder_days" class="form-label-modern">التذكير الأول (أيام)</label>
                                        <input type="number" class="form-control form-control-modern" 
                                               id="first_reminder_days" name="first_reminder_days" 
                                               value="{{ $settings['first_reminder_days'] }}" 
                                               min="1" max="30" required>
                                    </div>
                                </div>
                                
                                <div class="col-lg-4 col-md-12">
                                    <div class="form-group-modern">
                                        <label for="second_reminder_days" class="form-label-modern">التذكير الثاني (أيام)</label>
                                        <input type="number" class="form-control form-control-modern" 
                                               id="second_reminder_days" name="second_reminder_days" 
                                               value="{{ $settings['second_reminder_days'] }}" 
                                               min="1" max="30" required>
                                    </div>
                                </div>
                                
                                <div class="col-lg-4 col-md-12">
                                    <div class="form-group-modern">
                                        <label for="final_reminder_days" class="form-label-modern">التذكير النهائي (أيام)</label>
                                        <input type="number" class="form-control form-control-modern" 
                                               id="final_reminder_days" name="final_reminder_days" 
                                               value="{{ $settings['final_reminder_days'] }}" 
                                               min="1" max="60" required>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- طرق الإرسال -->
                            <h6 class="section-title">
                                <i class="fas fa-paper-plane"></i>
                                طرق إرسال التذكيرات
                            </h6>
                            
                            <div class="row">
                                <div class="col-lg-6 col-md-12 mb-3">
                                    <div class="switch-container">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" 
                                                   id="reminder_email" name="reminder_email"
                                                   {{ $settings['reminder_email'] ? 'checked' : '' }}>
                                            <label class="form-check-label" for="reminder_email">
                                                إرسال تذكيرات عبر البريد الإلكتروني
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 col-md-12 mb-3">
                                    <div class="switch-container">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" 
                                                   id="reminder_whatsapp" name="reminder_whatsapp"
                                                   {{ $settings['reminder_whatsapp'] ? 'checked' : '' }}>
                                            <label class="form-check-label" for="reminder_whatsapp">
                                                إرسال تذكيرات عبر الواتساب
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- أنواع الإشعارات -->
                            <h6 class="section-title">
                                <i class="fas fa-list-check"></i>
                                أنواع الإشعارات المفعلة
                            </h6>
                            
                            <div class="row">
                                <div class="col-lg-6 col-md-12 mb-3">
                                    <div class="switch-container">
                                        <div class="form-check form-switch mb-3">
                                            <input class="form-check-input" type="checkbox" 
                                                   id="notify_new_invoice" name="notify_new_invoice"
                                                   {{ $settings['notify_new_invoice'] ? 'checked' : '' }}>
                                            <label class="form-check-label" for="notify_new_invoice">
                                                إشعار الفاتورة الجديدة
                                            </label>
                                        </div>
                                        
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" 
                                                   id="notify_payment_received" name="notify_payment_received"
                                                   {{ $settings['notify_payment_received'] ? 'checked' : '' }}>
                                            <label class="form-check-label" for="notify_payment_received">
                                                إشعار استلام المدفوعات
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="col-lg-6 col-md-12 mb-3">
                                    <div class="switch-container">
                                        <div class="form-check form-switch mb-3">
                                            <input class="form-check-input" type="checkbox" 
                                                   id="notify_overdue" name="notify_overdue"
                                                   {{ $settings['notify_overdue'] ? 'checked' : '' }}>
                                            <label class="form-check-label" for="notify_overdue">
                                                إشعار الفواتير المتأخرة
                                            </label>
                                        </div>
                                        
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" 
                                                   id="notify_zatca_status" name="notify_zatca_status"
                                                   {{ $settings['notify_zatca_status'] ? 'checked' : '' }}>
                                            <label class="form-check-label" for="notify_zatca_status">
                                                إشعار حالة ZATCA
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- أزرار الحفظ -->
                            <div class="d-flex gap-3 mt-4">
                                <button type="submit" class="btn btn-modern btn-primary-modern">
                                    <i class="fas fa-save me-2"></i>
                                    حفظ الإعدادات
                                </button>
                                
                                <button type="button" class="btn btn-modern btn-outline-modern" onclick="location.reload()">
                                    <i class="fas fa-undo me-2"></i>
                                    إعادة تعيين
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            
            <div class="col-xl-4 col-lg-4 col-md-12">
                <!-- بطاقة اختبار الإشعارات -->
                <div class="settings-card fade-in" style="animation-delay: 0.1s;">
                    <div class="card-header">
                        <h5>
                            <i class="fas fa-flask"></i>
                            اختبار الإشعارات
                        </h5>
                    </div>
                    <div class="card-body">
                        <p class="text-muted mb-4">
                            اختبر إعدادات الإشعارات للتأكد من عملها بشكل صحيح
                        </p>
                        
                        <form id="testNotificationForm">
                            @csrf
                            <div class="form-group-modern">
                                <label for="test_email" class="form-label-modern">البريد الإلكتروني للاختبار</label>
                                <input type="email" class="form-control form-control-modern" 
                                       id="test_email" name="test_email" required 
                                       placeholder="test@example.com">
                            </div>
                            
                            <button type="submit" class="btn btn-modern btn-success-modern w-100">
                                <i class="fas fa-paper-plane me-2"></i>
                                إرسال إشعار تجريبي
                            </button>
                        </form>
                        
                        <div id="testResult" class="mt-4" style="display: none;"></div>
                    </div>
                </div>
                
                <!-- بطاقة إحصائيات الإشعارات -->
                <div class="settings-card fade-in" style="animation-delay: 0.2s;">
                    <div class="card-header">
                        <h5>
                            <i class="fas fa-chart-pie"></i>
                            إحصائيات الإشعارات
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-6">
                                <div class="stats-card">
                                    <div class="stats-number">{{ \App\Models\Invoice::count() }}</div>
                                    <div class="stats-label">إجمالي الفواتير</div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="stats-card">
                                    <div class="stats-number text-success">{{ \App\Models\Invoice::where('payment_status', 'paid')->count() }}</div>
                                    <div class="stats-label">مدفوعة</div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-6">
                                <div class="stats-card">
                                    <div class="stats-number text-warning">{{ \App\Models\Invoice::where('payment_status', 'partial')->count() }}</div>
                                    <div class="stats-label">جزئية</div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="stats-card">
                                    <div class="stats-number text-danger">{{ \App\Models\Invoice::where('payment_status', 'unpaid')->where('due_date', '<', now())->count() }}</div>
                                    <div class="stats-label">متأخرة</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- بطاقة التذكيرات التلقائية -->
                <div class="settings-card fade-in" style="animation-delay: 0.3s;">
                    <div class="card-header">
                        <h5>
                            <i class="fas fa-robot"></i>
                            التذكيرات التلقائية
                        </h5>
                    </div>
                    <div class="card-body">
                        <p class="text-muted mb-4">
                            إرسال تذكيرات للفواتير المتأخرة تلقائياً
                        </p>
                        
                        <button type="button" class="btn btn-modern btn-warning-modern w-100 mb-3" id="sendRemindersBtn">
                            <i class="fas fa-bell me-2"></i>
                            إرسال التذكيرات الآن
                        </button>
                        
                        <div id="remindersResult" class="mt-3" style="display: none;"></div>
                        
                        <div class="info-tooltip">
                            <i class="fas fa-info-circle me-2"></i>
                            يمكن جدولة هذه العملية لتتم تلقائياً باستخدام Laravel Scheduler
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // تحسين تأثيرات التحميل
    $('.fade-in').each(function(index) {
        $(this).css('animation-delay', (index * 0.1) + 's');
    });

    // اختبار الإشعارات
    $('#testNotificationForm').on('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const testResult = $('#testResult');
        const submitBtn = $(this).find('button[type="submit"]');
        
        $.ajax({
            url: '{{ route("invoices.test-notifications") }}',
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            beforeSend: function() {
                submitBtn.prop('disabled', true)
                    .html('<div class="loading-spinner"></div> جاري الإرسال...');
            },
            success: function(response) {
                testResult.html(`
                    <div class="alert alert-modern alert-success fade-in">
                        <i class="fas fa-check-circle me-2"></i>
                        ${response.message}
                    </div>
                `).show();
            },
            error: function(xhr) {
                const response = xhr.responseJSON;
                testResult.html(`
                    <div class="alert alert-modern alert-danger fade-in">
                        <i class="fas fa-exclamation-circle me-2"></i>
                        ${response.message || 'حدث خطأ أثناء الإرسال'}
                    </div>
                `).show();
            },
            complete: function() {
                submitBtn.prop('disabled', false)
                    .html('<i class="fas fa-paper-plane me-2"></i>إرسال إشعار تجريبي');
            }
        });
    });
    
    // إرسال التذكيرات التلقائية
    $('#sendRemindersBtn').on('click', function() {
        const button = $(this);
        const resultDiv = $('#remindersResult');
        
        $.ajax({
            url: '{{ route("invoices.send-payment-reminders") }}',
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            beforeSend: function() {
                button.prop('disabled', true)
                    .html('<div class="loading-spinner"></div> جاري الإرسال...');
            },
            success: function(response) {
                resultDiv.html(`
                    <div class="alert alert-modern alert-success fade-in">
                        <i class="fas fa-check-circle me-2"></i>
                        ${response.message}
                        <hr>
                        <small class="d-block mt-2">التفاصيل: ${response.results.details.join('<br>')}</small>
                    </div>
                `).show();
            },
            error: function(xhr) {
                const response = xhr.responseJSON;
                resultDiv.html(`
                    <div class="alert alert-modern alert-danger fade-in">
                        <i class="fas fa-exclamation-circle me-2"></i>
                        ${response.message || 'حدث خطأ أثناء إرسال التذكيرات'}
                    </div>
                `).show();
            },
            complete: function() {
                button.prop('disabled', false)
                    .html('<i class="fas fa-bell me-2"></i>إرسال التذكيرات الآن');
            }
        });
    });
    
    // حفظ الإعدادات مع تأثيرات بصرية محسنة
    $('#notificationSettingsForm').on('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const submitBtn = $(this).find('button[type="submit"]');
        
        $.ajax({
            url: $(this).attr('action'),
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function() {
                submitBtn.prop('disabled', true)
                    .html('<div class="loading-spinner"></div> جاري الحفظ...');
            },
            success: function(response) {
                // إظهار رسالة نجاح مع تأثير بصري محسن
                $('body').prepend(`
                    <div class="alert alert-modern alert-success alert-dismissible fade show fade-in" role="alert" 
                         style="position: fixed; top: 20px; right: 20px; z-index: 9999; min-width: 300px;">
                        <i class="fas fa-check-circle me-2"></i>
                        تم حفظ إعدادات الإشعارات بنجاح
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                `);
                
                // إزالة التنبيه تلقائياً بعد 5 ثوان
                setTimeout(function() {
                    $('.alert').fadeOut();
                }, 5000);
                
                // التمرير لأعلى الصفحة بسلاسة
                $('html, body').animate({ scrollTop: 0 }, 800);
            },
            error: function(xhr) {
                // إظهار رسالة خطأ
                $('body').prepend(`
                    <div class="alert alert-modern alert-danger alert-dismissible fade show fade-in" role="alert"
                         style="position: fixed; top: 20px; right: 20px; z-index: 9999; min-width: 300px;">
                        <i class="fas fa-exclamation-circle me-2"></i>
                        حدث خطأ أثناء حفظ الإعدادات
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                `);
                
                setTimeout(function() {
                    $('.alert').fadeOut();
                }, 5000);
            },
            complete: function() {
                submitBtn.prop('disabled', false)
                    .html('<i class="fas fa-save me-2"></i>حفظ الإعدادات');
            }
        });
    });
    
    // تأثيرات تفاعلية للمفاتيح
    $('.form-switch .form-check-input').on('change', function() {
        const container = $(this).closest('.switch-container');
        if ($(this).is(':checked')) {
            container.addClass('border-success bg-light');
        } else {
            container.removeClass('border-success bg-light');
        }
    });
    
    // تحديث المفاتيح عند التحميل
    $('.form-switch .form-check-input:checked').each(function() {
        $(this).closest('.switch-container').addClass('border-success bg-light');
    });
});
</script>
@endpush