@extends('layouts.app')

@section('title', 'كشف حساب العملاء')
@section('page-title', 'كشف حساب العملاء')

@section('page-actions')
<div class="btn-group">
    <button type="button" class="btn btn-outline-primary" onclick="window.print()">
        <i class="fas fa-print me-2"></i>
        طباعة
    </button>
    <button type="button" class="btn btn-outline-danger" onclick="generatePDF()">
        <i class="fas fa-file-pdf me-2"></i>
        تصدير PDF
    </button>
    <button type="button" class="btn btn-outline-success" onclick="sendEmail()">
        <i class="fas fa-envelope me-2"></i>
        إرسال بالبريد
    </button>
    <button type="button" class="btn btn-outline-info" onclick="sendWhatsApp()">
        <i class="fab fa-whatsapp me-2"></i>
        إرسال واتساب
    </button>
    <a href="{{ route('invoices.export-customer-statement', request()->all()) }}" class="btn btn-outline-secondary">
        <i class="fas fa-download me-2"></i>
        تصدير CSV
    </a>
    <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#filterModal">
        <i class="fas fa-filter me-2"></i>
        فلترة
    </button>
</div>
@endsection

@section('content')
<style>
/* طباعة محسّنة لصفحات A4 */
@media print {
    @page {
        size: A4;
        margin: 2cm 1.5cm;
    }
    
    * {
        -webkit-print-color-adjust: exact !important;
        color-adjust: exact !important;
        print-color-adjust: exact !important;
    }
    
    body {
        font-family: 'Arial', 'Tahoma', sans-serif !important;
        font-size: 12px !important;
        line-height: 1.4 !important;
        color: #000 !important;
        background: white !important;
        direction: rtl !important;
    }
    
    .no-print {
        display: none !important;
    }
    
    .container-fluid {
        padding: 0 !important;
        max-width: none !important;
    }
    
    /* رأس الصفحة مع معلومات الشركة */
    .print-header {
        position: fixed;
        top: -1.5cm;
        left: 0;
        right: 0;
        height: 3cm;
        background: white !important;
        border-bottom: 3px solid #2c3e50 !important;
        padding: 10px 20px;
        z-index: 1000;
    }
    
    .company-logo {
        width: 80px !important;
        height: 80px !important;
        border-radius: 8px !important;
        border: 2px solid #2c3e50 !important;
    }
    
    .company-info {
        color: #2c3e50 !important;
    }
    
    .company-name {
        font-size: 18px !important;
        font-weight: bold !important;
        color: #2c3e50 !important;
        margin-bottom: 5px !important;
    }
    
    .company-details {
        font-size: 11px !important;
        color: #555 !important;
        line-height: 1.3 !important;
    }
    
    .document-title {
        font-size: 20px !important;
        font-weight: bold !important;
        color: #2c3e50 !important;
        text-align: center !important;
        border: 2px solid #2c3e50 !important;
        padding: 8px !important;
        border-radius: 5px !important;
        background: #f8f9fa !important;
    }
    
    /* تذييل الصفحة */
    .print-footer {
        position: fixed;
        bottom: -1cm;
        left: 0;
        right: 0;
        height: 1cm;
        background: white !important;
        border-top: 1px solid #ddd !important;
        padding: 5px 20px;
        font-size: 10px !important;
        color: #666 !important;
        text-align: center !important;
    }
    
    /* المحتوى الرئيسي */
    .print-content {
        margin-top: 4cm !important;
        margin-bottom: 2cm !important;
    }
    
    .customer-statement-card {
        page-break-inside: avoid;
        margin-bottom: 30px !important;
        border: 1px solid #ddd !important;
        border-radius: 8px !important;
        overflow: hidden;
    }
    
    .customer-header {
        background: linear-gradient(135deg, #2c3e50 0%, #3498db 100%) !important;
        color: white !important;
        padding: 15px 20px !important;
        margin: 0 !important;
    }
    
    .customer-info h4 {
        color: white !important;
        font-size: 16px !important;
        margin-bottom: 8px !important;
    }
    
    .balance-display {
        background: rgba(255, 255, 255, 0.15) !important;
        border: 1px solid rgba(255, 255, 255, 0.3) !important;
        border-radius: 8px !important;
        padding: 10px !important;
        text-align: center !important;
    }
    
    .balance-display h3, .balance-display h5 {
        color: white !important;
        margin: 0 !important;
    }
    
    .badge {
        border: 1px solid rgba(255, 255, 255, 0.5) !important;
        color: white !important;
        background: rgba(255, 255, 255, 0.2) !important;
        padding: 3px 8px !important;
        font-size: 10px !important;
    }
    
    /* إحصائيات */
    .stats-grid {
        display: grid !important;
        grid-template-columns: repeat(4, 1fr) !important;
        gap: 15px !important;
        margin: 20px 0 !important;
        page-break-inside: avoid;
    }
    
    .stat-card {
        background: #f8f9fa !important;
        border: 1px solid #ddd !important;
        border-radius: 6px !important;
        padding: 12px !important;
        text-align: center !important;
    }
    
    .stat-card h4 {
        font-size: 14px !important;
        margin-bottom: 4px !important;
        color: #2c3e50 !important;
    }
    
    .stat-card p {
        font-size: 10px !important;
        margin: 0 !important;
        color: #666 !important;
    }
    
    /* الجداول */
    .modern-table {
        border-radius: 0 !important;
        box-shadow: none !important;
        margin-top: 20px !important;
        page-break-inside: avoid;
    }
    
    .table {
        border-collapse: collapse !important;
        width: 100% !important;
        font-size: 11px !important;
        margin: 0 !important;
    }
    
    .table thead th {
        background: #2c3e50 !important;
        color: white !important;
        border: 1px solid #000 !important;
        padding: 8px 6px !important;
        font-weight: bold !important;
        font-size: 11px !important;
        text-align: center !important;
    }
    
    .table tbody td {
        border: 1px solid #ddd !important;
        padding: 6px !important;
        font-size: 10px !important;
        vertical-align: middle !important;
    }
    
    .table tfoot td {
        background: #f8f9fa !important;
        border: 1px solid #000 !important;
        padding: 8px 6px !important;
        font-weight: bold !important;
        font-size: 11px !important;
    }
    
    /* الألوان للطباعة */
    .text-primary { color: #2c3e50 !important; }
    .text-success { color: #27ae60 !important; }
    .text-danger { color: #e74c3c !important; }
    .text-warning { color: #f39c12 !important; }
    .text-info { color: #3498db !important; }
    .text-secondary { color: #7f8c8d !important; }
    
    /* فواصل الصفحات */
    .customer-statement-card {
        page-break-after: always;
    }
    
    .customer-statement-card:last-child {
        page-break-after: avoid;
    }
    
    /* إخفاء العناصر غير المطلوبة */
    .summary-cards, .btn-group, .action-buttons, .modal, .no-print {
        display: none !important;
    }
    
    /* تحسين المساحات */
    .card-body {
        padding: 15px !important;
    }
    
    /* نمط الروابط */
    a {
        color: #2c3e50 !important;
        text-decoration: none !important;
    }
    
    /* تحسين الطباعة للأرقام */
    .fw-bold {
        font-weight: bold !important;
    }
    
    .text-end {
        text-align: left !important;
    }
    
    .text-center {
        text-align: center !important;
    }
    
    /* ترقيم الصفحات */
    .page-number:after {
        content: counter(page);
    }
    
    /* تحسين فواصل الصفحات */
    .page-break-before {
        page-break-before: always;
    }
    
    .page-break-after {
        page-break-after: always;
    }
    
    .page-break-avoid {
        page-break-inside: avoid;
    }
    
    /* تحسين الجداول للطباعة */
    .table-print-friendly {
        border-collapse: collapse !important;
        width: 100% !important;
    }
    
    .table-print-friendly th,
    .table-print-friendly td {
        border: 1px solid #000 !important;
        padding: 6px 8px !important;
        font-size: 10px !important;
        vertical-align: top !important;
    }
    
    /* تحسين النصوص للطباعة */
    .print-text-sm {
        font-size: 10px !important;
    }
    
    .print-text-md {
        font-size: 12px !important;
    }
    
    .print-text-lg {
        font-size: 14px !important;
    }
}

/* تحسين الطباعة - رأس الشركة */
.print-header {
    display: none;
}

@media print {
    .print-header {
        display: block !important;
    }
}

.statement-actions {
    position: sticky;
    top: 20px;
    z-index: 100;
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(10px);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 20px;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
}

.customer-statement-card {
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
    transition: all 0.3s ease;
    margin-bottom: 30px;
    overflow: hidden;
}

.customer-statement-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
}

.customer-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 25px;
    position: relative;
}

.customer-header::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><circle cx="50" cy="50" r="2" fill="rgba(255,255,255,0.1)"/></svg>') repeat;
    opacity: 0.3;
}

.customer-info {
    position: relative;
    z-index: 2;
}

.balance-display {
    background: rgba(255, 255, 255, 0.1);
    border-radius: 10px;
    padding: 15px;
    margin-top: 15px;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 20px;
    margin: 25px 0;
}

.stat-card {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border-radius: 12px;
    padding: 20px;
    text-align: center;
    border: 2px solid #e9ecef;
    transition: all 0.3s ease;
}

.stat-card:hover {
    border-color: #007bff;
    transform: translateY(-2px);
}

.modern-table {
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
}

.modern-table .table {
    margin-bottom: 0;
}

.modern-table .table thead th {
    background: linear-gradient(135deg, #343a40 0%, #495057 100%);
    color: white;
    border: none;
    padding: 15px;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.85rem;
    letter-spacing: 0.5px;
}

.modern-table .table tbody tr {
    transition: all 0.2s ease;
}

.modern-table .table tbody tr:hover {
    background-color: #f8f9fa;
    transform: scale(1.01);
}

.modern-table .table td {
    padding: 12px 15px;
    vertical-align: middle;
    border-color: #e9ecef;
}

.action-buttons {
    display: flex;
    gap: 10px;
    flex-wrap: wrap;
    margin-bottom: 20px;
}

.action-btn {
    border-radius: 25px;
    padding: 8px 20px;
    font-size: 0.9rem;
    font-weight: 500;
    transition: all 0.3s ease;
    border: 2px solid transparent;
}

.action-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
}

.summary-cards {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
    margin-bottom: 30px;
}

.summary-card {
    border-radius: 15px;
    padding: 25px;
    color: white;
    position: relative;
    overflow: hidden;
}

.summary-card::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
    animation: float 6s ease-in-out infinite;
}

@keyframes float {
    0%, 100% { transform: translateY(0px) rotate(0deg); }
    50% { transform: translateY(-10px) rotate(180deg); }
}

.icon-large {
    font-size: 2.5rem;
    opacity: 0.8;
}
</style>

<div class="container-fluid">
    <!-- رأس الشركة للطباعة -->
    <div class="print-header">
        <div class="row align-items-center">
            <div class="col-2">
                <!-- شعار الشركة -->
                <div class="company-logo d-flex align-items-center justify-content-center bg-light">
                    <i class="fas fa-building fa-2x text-primary"></i>
                </div>
            </div>
  
            <div class="col-3">
                <!-- عنوان التقرير -->
                <div class="document-title">
                    كشف حساب العملاء
                </div>
                <div class="text-center mt-2" style="font-size: 12px; color: #666;">
                    تاريخ الطباعة: {{ now()->format('Y-m-d H:i') }}
                </div>
            </div>
        </div>
    </div>

 

    <!-- المحتوى الرئيسي -->
    <div class="print-content">
        <!-- أزرار الإجراءات العائمة -->
        <div class="statement-actions no-print">
            <div class="action-buttons">
                <button type="button" class="btn btn-primary action-btn" onclick="window.print()">
                    <i class="fas fa-print me-2"></i>
                    طباعة التقرير
                </button>
                
                <div class="btn-group">
                    <button type="button" class="btn btn-danger action-btn dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="fas fa-file-pdf me-2"></i>
                        تصدير PDF
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="#" onclick="generatePDF()">
                            <i class="fas fa-download me-2"></i>تحميل PDF
                        </a></li>
                        <li><a class="dropdown-item" href="#" onclick="openEmailModal('pdf')">
                            <i class="fas fa-envelope me-2"></i>إرسال PDF بالبريد
                        </a></li>
                    </ul>
                </div>
                
                <div class="btn-group">
                    <button type="button" class="btn btn-success action-btn dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="fas fa-file-excel me-2"></i>
                        تصدير Excel
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="#" onclick="generateExcel()">
                            <i class="fas fa-download me-2"></i>تحميل Excel
                        </a></li>
                        <li><a class="dropdown-item" href="#" onclick="openEmailModal('excel')">
                            <i class="fas fa-envelope me-2"></i>إرسال Excel بالبريد
                        </a></li>
                    </ul>
                </div>
                
                <button type="button" class="btn btn-info action-btn" onclick="openWhatsAppModal()">
                    <i class="fab fa-whatsapp me-2"></i>
                    إرسال واتساب
                </button>
            </div>
        </div>

    <!-- فلترة البيانات -->
    <div class="card mb-4 no-print" style="border-radius: 15px; box-shadow: 0 4px 15px rgba(0,0,0,0.1);">
        <div class="card-header" style="background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%); border-radius: 15px 15px 0 0;">
            <h5 class="mb-0"><i class="fas fa-filter me-2"></i>فلترة البيانات</h5>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('invoices.customer-statement') }}" class="row g-3">
                <div class="col-md-3">
                    <label for="customer_id" class="form-label fw-bold">العميل</label>
                    <select name="customer_id" id="customer_id" class="form-select" style="border-radius: 10px;">
                        <option value="">جميع العملاء</option>
                        @foreach(\App\Models\Customer::orderBy('name')->get() as $customer)
                            <option value="{{ $customer->id }}" {{ request('customer_id') == $customer->id ? 'selected' : '' }}>
                                {{ $customer->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                
                <div class="col-md-2">
                    <label for="date_from" class="form-label fw-bold">من تاريخ</label>
                    <input type="date" name="date_from" id="date_from" class="form-control" style="border-radius: 10px;" value="{{ request('date_from') }}">
                </div>
                
                <div class="col-md-2">
                    <label for="date_to" class="form-label fw-bold">إلى تاريخ</label>
                    <input type="date" name="date_to" id="date_to" class="form-control" style="border-radius: 10px;" value="{{ request('date_to') }}">
                </div>
                
                <div class="col-md-3">
                    <label for="search" class="form-label fw-bold">البحث في اسم العميل</label>
                    <input type="text" name="search" id="search" class="form-control" style="border-radius: 10px;" placeholder="ابحث عن عميل..." value="{{ request('search') }}">
                </div>
                
                <div class="col-md-2 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary me-2 action-btn">
                        <i class="fas fa-search me-1"></i>
                        بحث
                    </button>
                    <a href="{{ route('invoices.customer-statement') }}" class="btn btn-outline-secondary action-btn">
                        <i class="fas fa-times me-1"></i>
                        إعادة تعيين
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- الإحصائيات العامة -->
    <div class="summary-cards">
        <div class="summary-card" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h3 class="mb-0 fw-bold">{{ $summary['total_customers'] }}</h3>
                    <p class="mb-0 opacity-90">إجمالي العملاء</p>
                </div>
                <i class="fas fa-users icon-large"></i>
            </div>
        </div>
        
        <div class="summary-card" style="background: linear-gradient(135deg, #ff6b6b 0%, #ee5a24 100%);">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h3 class="mb-0 fw-bold">{{ number_format($summary['total_debit'], 0) }}</h3>
                    <p class="mb-0 opacity-90">إجمالي المدين (ر.س)</p>
                </div>
                <i class="fas fa-arrow-up icon-large"></i>
            </div>
        </div>
        
        <div class="summary-card" style="background: linear-gradient(135deg, #51cf66 0%, #40c057 100%);">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h3 class="mb-0 fw-bold">{{ number_format($summary['total_credit'], 0) }}</h3>
                    <p class="mb-0 opacity-90">إجمالي الدائن (ر.س)</p>
                </div>
                <i class="fas fa-arrow-down icon-large"></i>
            </div>
        </div>
        
        <div class="summary-card" style="background: linear-gradient(135deg, {{ $summary['total_balance'] > 0 ? '#ffd43b, #fab005' : '#868e96, #495057' }});">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h3 class="mb-0 fw-bold">{{ number_format($summary['total_balance'], 0) }}</h3>
                    <p class="mb-0 opacity-90">الرصيد الإجمالي (ر.س)</p>
                </div>
                <i class="fas fa-balance-scale icon-large"></i>
            </div>
        </div>
    </div>

    <!-- إحصائيات إضافية -->
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="summary-card" style="background: linear-gradient(135deg, #845ec2 0%, #6c5ce7 100%);">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h3 class="mb-0 fw-bold">{{ $summary['customers_with_balance'] }}</h3>
                        <p class="mb-0 opacity-90">عملاء لديهم رصيد مدين</p>
                    </div>
                    <i class="fas fa-exclamation-triangle icon-large"></i>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="summary-card" style="background: linear-gradient(135deg, #fd79a8 0%, #e84393 100%);">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h3 class="mb-0 fw-bold">{{ $summary['customers_with_credit'] }}</h3>
                        <p class="mb-0 opacity-90">عملاء لديهم رصيد دائن</p>
                    </div>
                    <i class="fas fa-check-circle icon-large"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- كشوف الحسابات -->
    @if($customerStatements->count() > 0)
        @foreach($customerStatements as $statement)
        <div class="customer-statement-card">
            <div class="customer-header">
                <div class="customer-info">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <h4 class="mb-2 fw-bold">
                                <i class="fas fa-user me-2"></i>
                                {{ $statement['customer']->name }}
                            </h4>
                            <div class="customer-details">
                                @if($statement['customer']->email)
                                    <span class="badge bg-light text-dark me-2">
                                        <i class="fas fa-envelope me-1"></i>{{ $statement['customer']->email }}
                                    </span>
                                @endif
                                @if($statement['customer']->phone)
                                    <span class="badge bg-light text-dark me-2">
                                        <i class="fas fa-phone me-1"></i>{{ $statement['customer']->phone }}
                                    </span>
                                @endif
                                @if($statement['customer']->vat_number)
                                    <span class="badge bg-light text-dark me-2">
                                        <i class="fas fa-receipt me-1"></i>{{ $statement['customer']->vat_number }}
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="balance-display text-center">
                                <h5 class="mb-1">الرصيد النهائي</h5>
                                <h3 class="mb-0 fw-bold">
                                    {{ number_format(abs($statement['balance']), 2) }} ر.س
                                </h3>
                                @if($statement['balance'] > 0)
                                    <span class="badge bg-danger mt-1">مدين</span>
                                @elseif($statement['balance'] < 0)
                                    <span class="badge bg-success mt-1">دائن</span>
                                @else
                                    <span class="badge bg-secondary mt-1">متوازن</span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="card-body" style="padding: 30px;">
                <!-- أزرار الإجراءات لكل عميل -->
                <div class="action-buttons no-print mb-4">
                    <button type="button" class="btn btn-outline-primary action-btn" onclick="printCustomerStatement({{ $statement['customer']->id }})">
                        <i class="fas fa-print me-2"></i>
                        طباعة كشف الحساب
                    </button>
                    <button type="button" class="btn btn-outline-danger action-btn" onclick="generateCustomerPDF({{ $statement['customer']->id }})">
                        <i class="fas fa-file-pdf me-2"></i>
                        تصدير PDF
                    </button>
                    <button type="button" class="btn btn-outline-success action-btn" onclick="sendCustomerEmail({{ $statement['customer']->id }})">
                        <i class="fas fa-envelope me-2"></i>
                        إرسال بالبريد
                    </button>
                    <button type="button" class="btn btn-outline-info action-btn" onclick="sendCustomerWhatsApp({{ $statement['customer']->id }})">
                        <i class="fab fa-whatsapp me-2"></i>
                        إرسال واتساب
                    </button>
                </div>

                <!-- ملخص سريع محسّن -->
                <div class="stats-grid">
                    <div class="stat-card">
                        <h4 class="text-danger mb-1">{{ number_format($statement['total_debit'], 2) }}</h4>
                        <p class="mb-0 text-muted">إجمالي المدين (ر.س)</p>
                    </div>
                    <div class="stat-card">
                        <h4 class="text-success mb-1">{{ number_format($statement['total_credit'], 2) }}</h4>
                        <p class="mb-0 text-muted">إجمالي الدائن (ر.س)</p>
                    </div>
                    <div class="stat-card">
                        <h4 class="text-primary mb-1">
                            {{ $statement['total_debit'] > 0 ? number_format(($statement['total_credit'] / $statement['total_debit']) * 100, 1) : 0 }}%
                        </h4>
                        <p class="mb-0 text-muted">نسبة السداد</p>
                    </div>
                    <div class="stat-card">
                        <h4 class="text-info mb-1">{{ $statement['invoices_count'] }}</h4>
                        <p class="mb-0 text-muted">إجمالي الفواتير</p>
                        <small class="text-muted">
                            ({{ $statement['paid_invoices_count'] }} مدفوعة، {{ $statement['pending_invoices_count'] }} معلقة)
                        </small>
                    </div>
                </div>
                
                <!-- جدول المعاملات محسّن -->
                <div class="modern-table">
                    <table class="table table-hover">
                            <tr>
                                <th>التاريخ</th>
                                <th>النوع</th>
                                <th>المرجع</th>
                                <th>الوصف</th>
                                <th class="text-end">مدين (ر.س)</th>
                                <th class="text-end">دائن (ر.س)</th>
                                <th class="text-end">الرصيد (ر.س)</th>
                            </tr>
                        <tbody>
                            @foreach($statement['transactions'] as $transaction)
                            <tr>
                                <td>{{ $transaction['date']->format('Y-m-d') }}</td>
                                <td>
                                    @if($transaction['type'] === 'invoice')
                                       فاتورة
                                    @else
                                        دفعة
                                    @endif                                </td>
                                <td>
                                    <a href="{{ route('invoices.show', $transaction['invoice']) }}" class="text-decoration-none fw-bold text-primary">
                                        {{ $transaction['reference'] }}
                                    </a>
                                </td>
                                <td>{{ $transaction['description'] }}</td>
                                <td class="text-end">
                                    @if($transaction['debit'] > 0)
                                        <span class="text-danger fw-bold">{{ number_format($transaction['debit'], 2) }}</span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td class="text-end">
                                    @if($transaction['credit'] > 0)
                                        <span class="text-success fw-bold">{{ number_format($transaction['credit'], 2) }}</span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td class="text-end">
                                    <span class="fw-bold text-{{ $transaction['balance'] > 0 ? 'danger' : ($transaction['balance'] < 0 ? 'success' : 'secondary') }}">
                                        {{ number_format($transaction['balance'], 2) }}
                                    </span>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                        <tfoot style="background: linear-gradient(135deg, #f8f9fa, #e9ecef);">
                            <tr class="fw-bold">
                                <td colspan="4" class="text-center">الإجمالي</td>
                                <td class="text-end text-danger">{{ number_format($statement['total_debit'], 2) }}</td>
                                <td class="text-end text-success">{{ number_format($statement['total_credit'], 2) }}</td>
                                <td class="text-end text-{{ $statement['balance'] > 0 ? 'danger' : ($statement['balance'] < 0 ? 'success' : 'secondary') }}">
                                    {{ number_format($statement['balance'], 2) }}
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
        @endforeach
    @else
        <div class="card">
            <div class="card-body text-center py-5">
                <i class="fas fa-inbox fa-4x text-muted mb-3"></i>
                <h4 class="text-muted">لا توجد بيانات</h4>
                <p class="text-muted">لا توجد معاملات للعملاء في الفترة المحددة</p>
                <a href="{{ route('invoices.customer-statement') }}" class="btn btn-primary">
                    <i class="fas fa-refresh me-2"></i>
                    عرض جميع العملاء
                </a>
            </div>
        </div>
    @endif
    </div> <!-- إغلاق print-content -->
</div>

<!-- Modal الفلترة -->
<div class="modal fade" id="filterModal" tabindex="-1" aria-labelledby="filterModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="filterModalLabel">فلترة كشف الحساب</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="GET" action="{{ route('invoices.customer-statement') }}">
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="modal_customer_id" class="form-label">العميل</label>
                            <select name="customer_id" id="modal_customer_id" class="form-select">
                                <option value="">جميع العملاء</option>
                                @foreach(\App\Models\Customer::orderBy('name')->get() as $customer)
                                    <option value="{{ $customer->id }}" {{ request('customer_id') == $customer->id ? 'selected' : '' }}>
                                        {{ $customer->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        
                        <div class="col-md-6">
                            <label for="modal_search" class="form-label">البحث في اسم العميل</label>
                            <input type="text" name="search" id="modal_search" class="form-control" placeholder="ابحث عن عميل..." value="{{ request('search') }}">
                        </div>
                        
                        <div class="col-md-6">
                            <label for="modal_date_from" class="form-label">من تاريخ</label>
                            <input type="date" name="date_from" id="modal_date_from" class="form-control" value="{{ request('date_from') }}">
                        </div>
                        
                        <div class="col-md-6">
                            <label for="modal_date_to" class="form-label">إلى تاريخ</label>
                            <input type="date" name="date_to" id="modal_date_to" class="form-control" value="{{ request('date_to') }}">
                        </div>
                    </div>
                    
                    <div class="mt-4">
                        <h6>فلاتر سريعة:</h6>
                        <div class="btn-group" role="group">
                            <button type="button" class="btn btn-outline-primary btn-sm quick-filter" data-period="today">اليوم</button>
                            <button type="button" class="btn btn-outline-primary btn-sm quick-filter" data-period="week">هذا الأسبوع</button>
                            <button type="button" class="btn btn-outline-primary btn-sm quick-filter" data-period="month">هذا الشهر</button>
                            <button type="button" class="btn btn-outline-primary btn-sm quick-filter" data-period="quarter">هذا الربع</button>
                            <button type="button" class="btn btn-outline-primary btn-sm quick-filter" data-period="year">هذا العام</button>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <a href="{{ route('invoices.customer-statement') }}" class="btn btn-outline-danger">إعادة تعيين</a>
                    <button type="submit" class="btn btn-primary">تطبيق الفلترة</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal إرسال البريد الإلكتروني -->
<div class="modal fade" id="emailModal" tabindex="-1" aria-labelledby="emailModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="emailModalLabel">إرسال كشف الحساب بالبريد الإلكتروني</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="emailForm">
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="email_address" class="form-label">البريد الإلكتروني <span class="text-danger">*</span></label>
                            <input type="email" class="form-control" id="email_address" name="email" required>
                        </div>
                        <div class="col-md-6">
                            <label for="email_format" class="form-label">تنسيق الملف <span class="text-danger">*</span></label>
                            <select class="form-select" id="email_format" name="format" required>
                                <option value="pdf">PDF</option>
                                <option value="excel">Excel</option>
                            </select>
                        </div>
                        <div class="col-12">
                            <label for="email_subject" class="form-label">موضوع الرسالة</label>
                            <input type="text" class="form-control" id="email_subject" name="subject" placeholder="كشف حساب العملاء - {{ now()->format('Y-m-d') }}">
                        </div>
                        <div class="col-12">
                            <label for="email_message" class="form-label">رسالة إضافية (اختيارية)</label>
                            <textarea class="form-control" id="email_message" name="message" rows="4" placeholder="رسالة مخصصة للمرسل إليه..."></textarea>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-paper-plane me-2"></i>إرسال
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal إرسال الواتساب -->
<div class="modal fade" id="whatsappModal" tabindex="-1" aria-labelledby="whatsappModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="whatsappModalLabel">إرسال عبر الواتساب</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="whatsappForm">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="whatsapp_phone" class="form-label">رقم الهاتف <span class="text-danger">*</span></label>
                        <input type="tel" class="form-control" id="whatsapp_phone" name="phone" placeholder="+966501234567" required>
                        <div class="form-text">يرجى إدخال الرقم مع رمز الدولة (مثال: +966501234567)</div>
                    </div>
                    <div class="mb-3">
                        <label for="whatsapp_message" class="form-label">الرسالة</label>
                        <textarea class="form-control" id="whatsapp_message" name="message" rows="6" placeholder="رسالة مخصصة..."></textarea>
                        <div class="form-text">اتركها فارغة لاستخدام الرسالة الافتراضية</div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-success">
                        <i class="fab fa-whatsapp me-2"></i>إرسال
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
$(document).ready(function() {
    // الفلاتر السريعة
    $('.quick-filter').click(function() {
        const period = $(this).data('period');
        const today = new Date();
        let dateFrom, dateTo = today.toISOString().split('T')[0];
        
        switch(period) {
            case 'today':
                dateFrom = dateTo;
                break;
            case 'week':
                const weekStart = new Date(today.setDate(today.getDate() - today.getDay()));
                dateFrom = weekStart.toISOString().split('T')[0];
                break;
            case 'month':
                dateFrom = new Date(today.getFullYear(), today.getMonth(), 1).toISOString().split('T')[0];
                break;
            case 'quarter':
                const quarter = Math.floor(today.getMonth() / 3);
                dateFrom = new Date(today.getFullYear(), quarter * 3, 1).toISOString().split('T')[0];
                break;
            case 'year':
                dateFrom = new Date(today.getFullYear(), 0, 1).toISOString().split('T')[0];
                break;
        }
        
        $('#modal_date_from').val(dateFrom);
        $('#modal_date_to').val(dateTo);
    });
    
    // تحديث الفلاتر في النموذج المنبثق
    $('#filterModal').on('show.bs.modal', function() {
        $('#modal_customer_id').val($('#customer_id').val());
        $('#modal_search').val($('#search').val());
        $('#modal_date_from').val($('#date_from').val());
        $('#modal_date_to').val($('#date_to').val());
    });

    // معالجة إرسال البريد الإلكتروني
    $('#emailForm').on('submit', function(e) {
        e.preventDefault();
        sendEmail();
    });

    // معالجة إرسال الواتساب
    $('#whatsappForm').on('submit', function(e) {
        e.preventDefault();
        sendWhatsApp();
    });
});

// دالة تصدير PDF العام
function generatePDF() {
    Swal.fire({
        title: 'جاري تحضير ملف PDF...',
        html: 'يرجى الانتظار قليلاً',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });
    
    // إنشاء رابط تصدير PDF مع المعاملات الحالية
    const currentParams = new URLSearchParams(window.location.search);
    const pdfUrl = `{{ route('invoices.export-customer-statement') }}?${currentParams.toString()}&export=pdf`;
    
    // فتح رابط التصدير في نافذة جديدة
    window.open(pdfUrl, '_blank');
    
    setTimeout(() => {
        Swal.close();
        Swal.fire({
            icon: 'success',
            title: 'تم إنشاء ملف PDF بنجاح!',
            text: 'تم فتح الملف في نافذة جديدة',
            showConfirmButton: false,
            timer: 2000
        });
    }, 1500);
}

// دالة تصدير Excel
function generateExcel() {
    Swal.fire({
        title: 'جاري تحضير ملف Excel...',
        html: 'يرجى الانتظار قليلاً',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });
    
    // إنشاء رابط تصدير Excel مع المعاملات الحالية
    const currentParams = new URLSearchParams(window.location.search);
    const excelUrl = `{{ route('invoices.export-customer-statement') }}?${currentParams.toString()}&export=excel`;
    
    // فتح رابط التصدير في نافذة جديدة
    window.open(excelUrl, '_blank');
    
    setTimeout(() => {
        Swal.close();
        Swal.fire({
            icon: 'success',
            title: 'تم إنشاء ملف Excel بنجاح!',
            text: 'تم فتح الملف في نافذة جديدة',
            showConfirmButton: false,
            timer: 2000
        });
    }, 1500);
}

// فتح نموذج إرسال البريد الإلكتروني
function openEmailModal(format = 'pdf') {
    $('#email_format').val(format);
    $('#emailModal').modal('show');
}

// فتح نموذج إرسال الواتساب
function openWhatsAppModal() {
    $('#whatsappModal').modal('show');
}

// إرسال البريد الإلكتروني
function sendEmail() {
    const formData = new FormData();
    formData.append('email', $('#email_address').val());
    formData.append('format', $('#email_format').val());
    formData.append('subject', $('#email_subject').val());
    formData.append('message', $('#email_message').val());
    
    // إضافة معاملات الفلتر الحالية
    const currentParams = new URLSearchParams(window.location.search);
    for (const [key, value] of currentParams) {
        formData.append(key, value);
    }
    
    // إضافة CSRF token
    formData.append('_token', '{{ csrf_token() }}');
    
    Swal.fire({
        title: 'جاري إرسال البريد الإلكتروني...',
        html: 'يرجى الانتظار قليلاً',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });
    
    $.ajax({
        url: '{{ route("invoices.send-customer-statement-email") }}',
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function(response) {
            $('#emailModal').modal('hide');
            Swal.fire({
                icon: 'success',
                title: 'تم الإرسال بنجاح!',
                text: response.message,
                showConfirmButton: false,
                timer: 3000
            });
        },
        error: function(xhr) {
            let errorMessage = 'حدث خطأ أثناء إرسال البريد';
            if (xhr.responseJSON && xhr.responseJSON.message) {
                errorMessage = xhr.responseJSON.message;
            }
            
            Swal.fire({
                icon: 'error',
                title: 'خطأ في الإرسال',
                text: errorMessage,
                confirmButtonText: 'حسناً'
            });
        }
    });
}

// إرسال الواتساب
function sendWhatsApp() {
    const formData = new FormData();
    formData.append('phone', $('#whatsapp_phone').val());
    formData.append('message', $('#whatsapp_message').val());
    
    // إضافة CSRF token
    formData.append('_token', '{{ csrf_token() }}');
    
    Swal.fire({
        title: 'جاري تحضير رسالة الواتساب...',
        html: 'يرجى الانتظار قليلاً',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });
    
    $.ajax({
        url: '{{ route("invoices.send-customer-statement-whatsapp") }}',
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function(response) {
            $('#whatsappModal').modal('hide');
            Swal.close();
            
            // فتح الواتساب في نافذة جديدة
            window.open(response.whatsapp_url, '_blank');
            
            Swal.fire({
                icon: 'success',
                title: 'تم إعداد الرسالة!',
                text: 'تم فتح الواتساب في نافذة جديدة',
                showConfirmButton: false,
                timer: 3000
            });
        },
        error: function(xhr) {
            let errorMessage = 'حدث خطأ أثناء إعداد رسالة الواتساب';
            if (xhr.responseJSON && xhr.responseJSON.message) {
                errorMessage = xhr.responseJSON.message;
            }
            
            Swal.fire({
                icon: 'error',
                title: 'خطأ في الإعداد',
                text: errorMessage,
                confirmButtonText: 'حسناً'
            });
        }
    });
}

// دالة إرسال البريد الإلكتروني العام
function sendEmail() {
    Swal.fire({
        title: 'إرسال كشف الحساب بالبريد الإلكتروني',
        input: 'email',
        inputLabel: 'عنوان البريد الإلكتروني',
        inputPlaceholder: 'أدخل عنوان البريد الإلكتروني',
        showCancelButton: true,
        confirmButtonText: 'إرسال',
        cancelButtonText: 'إلغاء',
        inputValidator: (value) => {
            if (!value) {
                return 'يرجى إدخال عنوان بريد إلكتروني صحيح!'
            }
            if (!/\S+@\S+\.\S+/.test(value)) {
                return 'يرجى إدخال عنوان بريد إلكتروني صحيح!'
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: 'جاري الإرسال...',
                html: 'يرجى الانتظار قليلاً',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });
            
            // محاكاة إرسال البريد الإلكتروني
            setTimeout(() => {
                Swal.fire({
                    icon: 'success',
                    title: 'تم الإرسال بنجاح!',
                    text: `تم إرسال كشف الحساب إلى ${result.value}`,
                    showConfirmButton: false,
                    timer: 3000
                });
            }, 2000);
        }
    });
}

// دالة إرسال واتساب العام
function sendWhatsApp() {
    Swal.fire({
        title: 'إرسال كشف الحساب عبر واتساب',
        input: 'tel',
        inputLabel: 'رقم الهاتف',
        inputPlaceholder: 'أدخل رقم الهاتف مع كود البلد (مثال: +966501234567)',
        showCancelButton: true,
        confirmButtonText: 'إرسال',
        cancelButtonText: 'إلغاء',
        inputValidator: (value) => {
            if (!value) {
                return 'يرجى إدخال رقم الهاتف!'
            }
            if (!/^\+[1-9]\d{10,14}$/.test(value)) {
                return 'يرجى إدخال رقم هاتف صحيح مع كود البلد!'
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            const phoneNumber = result.value.replace('+', '');
            const message = encodeURIComponent('مرحباً، نرسل لك كشف حساب العملاء. يرجى مراجعة المرفقات.');
            const whatsappUrl = `https://wa.me/${phoneNumber}?text=${message}`;
            
            window.open(whatsappUrl, '_blank');
            
            Swal.fire({
                icon: 'success',
                title: 'تم فتح واتساب!',
                text: 'تم فتح محادثة واتساب، يمكنك إرفاق كشف الحساب',
                showConfirmButton: false,
                timer: 3000
            });
        }
    });
}

// دوال لكل عميل منفرد
function printCustomerStatement(customerId) {
    const customerCard = $(`.customer-statement-card:has([onclick*='${customerId}'])`).first();
    if (customerCard.length) {
        const printContent = customerCard.clone();
        printContent.find('.no-print').remove();
        
        // إنشاء رأس الشركة للطباعة
        const companyHeader = `
            <div class="company-header-print mb-4" style="border-bottom: 3px solid #2c3e50; padding-bottom: 20px; margin-bottom: 30px;">
                <div class="row align-items-center">
                    <div class="col-2">
                        <div class="company-logo" style="width: 80px; height: 80px; border: 2px solid #2c3e50; border-radius: 8px; display: flex; align-items: center; justify-content: center; background: #f8f9fa;">
                            <i class="fas fa-building fa-2x text-primary"></i>
                        </div>
                    </div>
                    <div class="col-7">
                        <div class="company-info">
                     
                        </div>
                    </div>
                    <div class="col-3">
                        <div style="text-align: center; border: 2px solid #2c3e50; padding: 10px; border-radius: 8px; background: #f8f9fa;">
                            <h4 style="color: #2c3e50; font-weight: bold; margin-bottom: 5px;">كشف حساب العميل</h4>
                            <div style="font-size: 11px; color: #666;">تاريخ الطباعة: ${new Date().toLocaleDateString('ar-SA')}</div>
                        </div>
                    </div>
                </div>
            </div>
        `;
        
        const printWindow = window.open('', '_blank');
        printWindow.document.write(`
            <html>
                <head>
                    <title>كشف حساب العميل</title>
                    <meta charset="UTF-8">
                    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
                    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
                    <style>
                        @page {
                            size: A4;
                            margin: 2cm 1.5cm;
                        }
                        
                        body {
                            font-family: 'Arial', 'Tahoma', sans-serif;
                            direction: rtl;
                            font-size: 12px;
                            line-height: 1.4;
                            color: #000;
                        }
                        
                        .table th, .table td {
                            border: 1px solid #000 !important;
                            padding: 8px !important;
                            font-size: 11px !important;
                        }
                        
                        .table thead th {
                            background: #2c3e50 !important;
                            color: white !important;
                            font-weight: bold !important;
                            text-align: center !important;
                        }
                        
                        .table tfoot td {
                            background: #f8f9fa !important;
                            font-weight: bold !important;
                        }
                        
                        .customer-header {
                            background: linear-gradient(135deg, #2c3e50 0%, #3498db 100%) !important;
                            color: white !important;
                            padding: 20px !important;
                            margin-bottom: 20px !important;
                        }
                        
                        .balance-display {
                            background: rgba(255, 255, 255, 0.15) !important;
                            border: 1px solid rgba(255, 255, 255, 0.3) !important;
                            border-radius: 8px !important;
                            padding: 10px !important;
                        }
                        
                        .balance-display h3, .balance-display h5 {
                            color: white !important;
                            margin: 0 !important;
                        }
                        
                        .badge {
                            border: 1px solid rgba(255, 255, 255, 0.5) !important;
                            color: white !important;
                            background: rgba(255, 255, 255, 0.2) !important;
                            padding: 3px 8px !important;
                            font-size: 10px !important;
                        }
                        
                        .stats-grid {
                            display: grid !important;
                            grid-template-columns: repeat(4, 1fr) !important;
                            gap: 15px !important;
                            margin: 20px 0 !important;
                        }
                        
                        .stat-card {
                            background: #f8f9fa !important;
                            border: 1px solid #ddd !important;
                            border-radius: 6px !important;
                            padding: 12px !important;
                            text-align: center !important;
                        }
                        
                        .stat-card h4 {
                            font-size: 14px !important;
                            margin-bottom: 4px !important;
                            color: #2c3e50 !important;
                        }
                        
                        .stat-card p {
                            font-size: 10px !important;
                            margin: 0 !important;
                            color: #666 !important;
                        }
                        
                        .no-print { display: none !important; }
                        
                        .text-primary { color: #2c3e50 !important; }
                        .text-success { color: #27ae60 !important; }
                        .text-danger { color: #e74c3c !important; }
                        .text-warning { color: #f39c12 !important; }
                        .text-info { color: #3498db !important; }
                        .text-secondary { color: #7f8c8d !important; }
                        
                        .fw-bold { font-weight: bold !important; }
                        .text-end { text-align: left !important; }
                        .text-center { text-align: center !important; }
                    </style>
                </head>
                <body>
                    <div class="container-fluid">
                        ${companyHeader}
                        ${printContent.html()}
                    </div>
                </body>
            </html>
        `);
        printWindow.document.close();
        printWindow.print();
    }
}

function generateCustomerPDF(customerId) {
    Swal.fire({
        title: 'جاري تحضير ملف PDF للعميل...',
        html: 'يرجى الانتظار قليلاً',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });
    
    const currentParams = new URLSearchParams(window.location.search);
    currentParams.set('customer_id', customerId);
    const pdfUrl = `{{ route('invoices.customer-statement') }}?${currentParams.toString()}&export=pdf`;
    
    window.open(pdfUrl, '_blank');
    
    setTimeout(() => {
        Swal.close();
        Swal.fire({
            icon: 'success',
            title: 'تم إنشاء ملف PDF للعميل!',
            text: 'تم فتح الملف في نافذة جديدة',
            showConfirmButton: false,
            timer: 2000
        });
    }, 1500);
}

function sendCustomerEmail(customerId) {
    // الحصول على بيانات العميل من DOM
    const customerCard = $(`.customer-statement-card:has([onclick*='${customerId}'])`).first();
    const customerName = customerCard.find('h4').text().replace(/\s+/g, ' ').trim().replace('', '').trim();
    const customerEmail = customerCard.find('.badge:contains("@")').text().replace(/.*@/, '@').split(' ')[0];
    
    Swal.fire({
        title: `إرسال كشف حساب ${customerName}`,
        input: 'email',
        inputLabel: 'عنوان البريد الإلكتروني',
        inputValue: customerEmail || '',
        inputPlaceholder: 'أدخل عنوان البريد الإلكتروني',
        showCancelButton: true,
        confirmButtonText: 'إرسال',
        cancelButtonText: 'إلغاء',
        inputValidator: (value) => {
            if (!value) {
                return 'يرجى إدخال عنوان بريد إلكتروني صحيح!'
            }
            if (!/\S+@\S+\.\S+/.test(value)) {
                return 'يرجى إدخال عنوان بريد إلكتروني صحيح!'
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: 'جاري الإرسال...',
                html: 'يرجى الانتظار قليلاً',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });
            
            setTimeout(() => {
                Swal.fire({
                    icon: 'success',
                    title: 'تم الإرسال بنجاح!',
                    text: `تم إرسال كشف حساب ${customerName} إلى ${result.value}`,
                    showConfirmButton: false,
                    timer: 3000
                });
            }, 2000);
        }
    });
}

function sendCustomerWhatsApp(customerId) {
    const customerCard = $(`.customer-statement-card:has([onclick*='${customerId}'])`).first();
    const customerName = customerCard.find('h4').text().replace(/\s+/g, ' ').trim().replace('', '').trim();
    const customerPhone = customerCard.find('.badge:contains("+")').text().replace(/.*\+/, '+').split(' ')[0];
    
    Swal.fire({
        title: `إرسال كشف حساب ${customerName} عبر واتساب`,
        input: 'tel',
        inputLabel: 'رقم الهاتف',
        inputValue: customerPhone || '',
        inputPlaceholder: 'أدخل رقم الهاتف مع كود البلد (مثال: +966501234567)',
        showCancelButton: true,
        confirmButtonText: 'إرسال',
        cancelButtonText: 'إلغاء',
        inputValidator: (value) => {
            if (!value) {
                return 'يرجى إدخال رقم الهاتف!'
            }
            if (!/^\+[1-9]\d{10,14}$/.test(value)) {
                return 'يرجى إدخال رقم هاتف صحيح مع كود البلد!'
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            const phoneNumber = result.value.replace('+', '');
            const message = encodeURIComponent(`مرحباً ${customerName}، نرسل لك كشف حسابك. يرجى مراجعة المرفقات.`);
            const whatsappUrl = `https://wa.me/${phoneNumber}?text=${message}`;
            
            window.open(whatsappUrl, '_blank');
            
            Swal.fire({
                icon: 'success',
                title: 'تم فتح واتساب!',
                text: `تم فتح محادثة واتساب مع ${customerName}`,
                showConfirmButton: false,
                timer: 3000
            });
        }
    });
}
</script>
@endpush