<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>كشف حساب العملاء</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Noto+Sans+Arabic:wght@300;400;500;600;700&display=swap');
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Noto Sans Arabic', Arial, sans-serif;
            font-size: 12px;
            line-height: 1.5;
            color: #333;
            direction: rtl;
            background: white;
        }
        
        .container {
            max-width: 210mm;
            margin: 0 auto;
            padding: 20mm;
        }
        
        /* رأس الصفحة */
        .header {
            border-bottom: 2px solid #2c3e50;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        
        .company-section {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 20px;
        }
        
        .company-info {
            flex: 1;
        }
        
        .company-name {
            font-size: 24px;
            font-weight: 700;
            color: #2c3e50;
            margin-bottom: 5px;
        }
        
        .company-details {
            font-size: 11px;
            color: #666;
            line-height: 1.4;
        }
        
        .company-details p {
            margin: 2px 0;
        }
        
        .report-title {
            text-align: center;
            background: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
        }
        
        .report-title h1 {
            font-size: 20px;
            font-weight: 700;
            color: #2c3e50;
            margin-bottom: 5px;
        }
        
        .report-title p {
            font-size: 12px;
            color: #666;
        }
        
        /* معلومات التقرير */
        .report-info {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 6px;
            margin-bottom: 25px;
        }
        
        .info-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 8px;
        }
        
        .info-row:last-child {
            margin-bottom: 0;
        }
        
        .info-label {
            font-weight: 600;
            color: #555;
        }
        
        .info-value {
            color: #333;
        }
        
        /* الملخص العام */
        .summary {
            background: #e3f2fd;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 30px;
        }
        
        .summary h2 {
            text-align: center;
            font-size: 16px;
            font-weight: 700;
            color: #1976d2;
            margin-bottom: 15px;
        }
        
        .summary-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 15px;
        }
        
        .summary-item {
            background: white;
            padding: 15px;
            border-radius: 6px;
            text-align: center;
            border: 1px solid #ddd;
        }
        
        .summary-value {
            font-size: 18px;
            font-weight: 700;
            color: #1976d2;
        }
        
        .summary-label {
            font-size: 10px;
            color: #666;
            margin-top: 5px;
        }
        
        /* كشف العميل */
        .customer-statement {
            margin-bottom: 30px;
            page-break-inside: avoid;
        }
        
        .customer-header {
            background: #2c3e50;
            color: white;
            padding: 15px;
            border-radius: 6px 6px 0 0;
        }
        
        .customer-name {
            font-size: 16px;
            font-weight: 700;
            margin-bottom: 5px;
        }
        
        .customer-details {
            font-size: 11px;
            opacity: 0.9;
        }
        
        .customer-summary {
            background: #f8f9fa;
            padding: 10px 15px;
            border: 1px solid #ddd;
            border-top: none;
            display: flex;
            justify-content: space-between;
            font-size: 11px;
        }
        
        .customer-summary span {
            font-weight: 600;
        }
        
        /* جدول المعاملات */
        .transactions-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 0;
            border: 1px solid #ddd;
        }
        
        .transactions-table th {
            background: #f8f9fa;
            color: #2c3e50;
            padding: 10px 8px;
            text-align: center;
            font-weight: 600;
            font-size: 11px;
            border: 1px solid #ddd;
        }
        
        .transactions-table td {
            padding: 8px;
            text-align: center;
            border: 1px solid #ddd;
            font-size: 10px;
        }
        
        .transactions-table tbody tr:nth-child(even) {
            background: #f9f9f9;
        }
        
        .amount-cell {
            text-align: left !important;
            font-weight: 600;
        }
        
        .debit-amount {
            color: #dc3545;
        }
        
        .credit-amount {
            color: #28a745;
        }
        
        .balance-cell {
            color: #1976d2;
            font-weight: 700;
        }
        
        .transaction-type {
            display: inline-block;
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 9px;
            font-weight: 600;
            background: #f5f5f5;
            color: #000;
            border: 1px solid #ddd;
        }
        
        /* صف الإجمالي */
        .total-row {
            background: #e9ecef !important;
            font-weight: 700;
        }
        
        .total-row td {
            padding: 10px 8px;
            font-size: 11px;
        }
        
        /* التذييل */
        .footer {
            margin-top: 40px;
            border-top: 2px solid #2c3e50;
            padding-top: 20px;
            font-size: 10px;
            color: #666;
        }
        
        .footer-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 20px;
            margin-bottom: 20px;
        }
        
        .footer-section h4 {
            font-size: 12px;
            color: #2c3e50;
            margin-bottom: 10px;
            font-weight: 700;
        }
        
        .footer-section p {
            margin: 3px 0;
            line-height: 1.3;
        }
        
        .disclaimer {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            padding: 15px;
            border-radius: 6px;
            text-align: center;
            font-size: 10px;
            color: #856404;
        }
        
        .signatures {
            display: flex;
            justify-content: space-between;
            margin-top: 30px;
        }
        
        .signature-box {
            text-align: center;
            width: 200px;
        }
        
        .signature-line {
            border-bottom: 1px solid #333;
            height: 40px;
            margin: 10px 0;
        }
        
        .signature-text {
            font-size: 10px;
            color: #666;
        }
        
        /* تحسينات الطباعة */
        @media print {
            body {
                margin: 0;
                padding: 0;
            }
            
            .container {
                max-width: none;
                padding: 15mm;
            }
            
            .customer-statement {
                page-break-after: always;
            }
            
            .customer-statement:last-child {
                page-break-after: avoid;
            }
            
            .footer {
                page-break-inside: avoid;
            }
            
            .summary-grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }
        
        /* تصميم متجاوب */
        @media (max-width: 768px) {
            .company-section {
                flex-direction: column;
            }
            
            .summary-grid {
                grid-template-columns: repeat(2, 1fr);
            }
            
            .footer-grid {
                grid-template-columns: 1fr;
            }
            
            .signatures {
                flex-direction: column;
                gap: 20px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        @php
            $company = \App\Models\Company::first();
        @endphp

        <!-- رأس التقرير -->
        <div class="header">
            <div class="company-section">
                <div class="company-info">
                    @if($company)
                        <h1 class="company-name">{{ $company->name }}</h1>
                        <div class="company-details">
                            @if($company->vat_number)
                                <p><strong>الرقم الضريبي:</strong> {{ $company->vat_number }}</p>
                            @endif
                            @if($company->cr_number)
                                <p><strong>السجل التجاري:</strong> {{ $company->cr_number }}</p>
                            @endif
                            @if($company->phone)
                                <p><strong>الهاتف:</strong> {{ $company->phone }}</p>
                            @endif
                            @if($company->email)
                                <p><strong>البريد الإلكتروني:</strong> {{ $company->email }}</p>
                            @endif
                            @if($company->address)
                                <p><strong>العنوان:</strong> {{ $company->address }}</p>
                            @endif
                        </div>
                    @else
                        <h1 class="company-name">اسم الشركة</h1>
                    @endif
                </div>
            </div>
            
            <div class="report-title">
                <h1>كشف حساب العملاء</h1>
                <p>تقرير شامل لحركات العملاء والأرصدة</p>
            </div>
        </div>

        <!-- معلومات التقرير -->
        <div class="report-info">
            <div class="info-row">
                <span class="info-label">تاريخ التقرير:</span>
                <span class="info-value">{{ now()->format('Y-m-d H:i') }}</span>
            </div>
            <div class="info-row">
                <span class="info-label">فترة التقرير:</span>
                <span class="info-value">
                    @if(request('date_from') || request('date_to'))
                        من {{ request('date_from', 'البداية') }} إلى {{ request('date_to', 'النهاية') }}
                    @else
                        جميع الفترات
                    @endif
                </span>
            </div>
            <div class="info-row">
                <span class="info-label">عدد العملاء:</span>
                <span class="info-value">{{ $summary['total_customers'] }}</span>
            </div>
            <div class="info-row">
                <span class="info-label">حالة التقرير:</span>
                <span class="info-value">نهائي ومعتمد</span>
            </div>
        </div>

        <!-- الملخص العام -->
        <div class="summary">
            <h2>الملخص المالي العام</h2>
            <div class="summary-grid">
                <div class="summary-item">
                    <div class="summary-value">{{ number_format($summary['total_debit'], 0) }}</div>
                    <div class="summary-label">إجمالي المدين (ر.س)</div>
                </div>
                <div class="summary-item">
                    <div class="summary-value">{{ number_format($summary['total_credit'], 0) }}</div>
                    <div class="summary-label">إجمالي الدائن (ر.س)</div>
                </div>
                <div class="summary-item">
                    <div class="summary-value">{{ number_format($summary['total_balance'], 0) }}</div>
                    <div class="summary-label">الرصيد الإجمالي (ر.س)</div>
                </div>
                <div class="summary-item">
                    <div class="summary-value">{{ $summary['customers_with_balance'] }}</div>
                    <div class="summary-label">عملاء لديهم رصيد مدين</div>
                </div>
            </div>
        </div>

        <!-- كشوف العملاء -->
        @foreach($customerStatements as $index => $statement)
            @if($index > 0)
                <div style="page-break-before: always;"></div>
            @endif
            
            <div class="customer-statement">
                <div class="customer-header">
                    <div class="customer-name">{{ $statement['customer']->name }}</div>
                    <div class="customer-details">
                        @if($statement['customer']->email)
                            البريد: {{ $statement['customer']->email }} | 
                        @endif
                        @if($statement['customer']->phone)
                            الهاتف: {{ $statement['customer']->phone }}
                        @endif
                    </div>
                </div>

                <div class="customer-summary">
                    <span>إجمالي المدين: {{ number_format($statement['total_debit'], 2) }} ر.س</span>
                    <span>إجمالي الدائن: {{ number_format($statement['total_credit'], 2) }} ر.س</span>
                    <span>الرصيد النهائي: {{ number_format($statement['balance'], 2) }} ر.س</span>
                </div>

                <!-- جدول المعاملات -->
                @if($statement['transactions']->count() > 0)
                    <table class="transactions-table">
                        <thead>
                            <tr>
                                <th style="width: 12%">التاريخ</th>
                                <th style="width: 10%">النوع</th>
                                <th style="width: 15%">المرجع</th>
                                <th style="width: 25%">الوصف</th>
                                <th style="width: 12%">مدين (ر.س)</th>
                                <th style="width: 12%">دائن (ر.س)</th>
                                <th style="width: 14%">الرصيد (ر.س)</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($statement['transactions'] as $transaction)
                                <tr>
                                    <td>{{ $transaction['date']->format('Y-m-d') }}</td>
                                    <td>
                                        <span class="transaction-type">
                                            {{ $transaction['type'] === 'invoice' ? 'فاتورة' : 'دفعة' }}
                                        </span>
                                    </td>
                                    <td>{{ $transaction['reference'] }}</td>
                                    <td style="text-align: right;">{{ $transaction['description'] }}</td>
                                    <td class="amount-cell">
                                        @if($transaction['debit'] > 0)
                                            <span class="debit-amount">{{ number_format($transaction['debit'], 2) }}</span>
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td class="amount-cell">
                                        @if($transaction['credit'] > 0)
                                            <span class="credit-amount">{{ number_format($transaction['credit'], 2) }}</span>
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td class="amount-cell balance-cell">
                                        {{ number_format($transaction['balance'], 2) }}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr class="total-row">
                                <td colspan="4">الإجمالي</td>
                                <td class="amount-cell debit-amount">{{ number_format($statement['total_debit'], 2) }}</td>
                                <td class="amount-cell credit-amount">{{ number_format($statement['total_credit'], 2) }}</td>
                                <td class="amount-cell balance-cell">{{ number_format($statement['balance'], 2) }}</td>
                            </tr>
                        </tfoot>
                    </table>
                @else
                    <div style="text-align: center; padding: 30px; color: #666; background: #f8f9fa;">
                        <p>لا توجد معاملات لهذا العميل في الفترة المحددة</p>
                    </div>
                @endif
            </div>
        @endforeach

        <!-- التذييل -->
        <div class="footer">
            <div class="footer-grid">
                <div class="footer-section">
                    <h4>معلومات التقرير</h4>
                    <p>تاريخ الإنشاء: {{ now()->format('Y-m-d H:i:s') }}</p>
                    <p>النظام: إدارة الفواتير المتقدم</p>
                    <p>المستخدم: {{ auth()->user()->name ?? 'النظام' }}</p>
                </div>
                <div class="footer-section">
                    <h4>معلومات الاتصال</h4>
                    @if($company)
                        @if($company->phone)
                            <p>الهاتف: {{ $company->phone }}</p>
                        @endif
                        @if($company->email)
                            <p>البريد: {{ $company->email }}</p>
                        @endif
                        @if($company->website)
                            <p>الموقع: {{ $company->website }}</p>
                        @endif
                    @endif
                </div>
            </div>
            
            <div class="disclaimer">
                <strong>تنويه:</strong> هذا التقرير سري ومخصص للاستخدام الداخلي فقط. 
                جميع البيانات محدثة حتى تاريخ {{ now()->format('Y-m-d H:i') }}.
            </div>
            
            <div class="signatures">
                <div class="signature-box">
                    <div class="signature-text">المسؤول المالي</div>
                    <div class="signature-line"></div>
                    <div class="signature-text">الاسم والتوقيع</div>
                </div>
                <div class="signature-box">
                    <div class="signature-text">المدير العام</div>
                    <div class="signature-line"></div>
                    <div class="signature-text">الاسم والتوقيع</div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>