@extends('layouts.pos')

@section('title', 'نقطة البيع')
@section('page-title', 'نقطة البيع ')

@section('page-actions')
<div class="d-flex gap-3 align-items-center flex-wrap">
    <!-- أزرار العمليات -->
    <div class="d-flex gap-2">
        <button type="button" class="btn btn-info" style="width:170px;" onclick="openAddProductModal()">
            <i class="fas fa-plus-circle me-2"></i>
            إضافة منتج
        </button>
        <button type="button" class="btn btn-warning" style="width:170px;" onclick="openCalculator()">
            <i class="fas fa-calculator me-2"></i>
             الحاسبة
        </button>
        <button type="button" class="btn btn-dark"  style="width:170px;" onclick="printLastInvoice()">
            <i class="fas fa-print me-2"></i>
            طباعة السابقة
        </button>

        <button type="button" class="btn btn-success"  onclick="holdOrder()" style="border: none; color: white; width:170px;">
            <i class="fas fa-pause me-2"></i>
            تعليق
        </button>
        <button type="button" class="btn" onclick="loadOrder()"  style="background: linear-gradient(135deg, #17a2b8 0%, #138496 100%);  border: none; color: white; width:170px;">
            <i class="fas fa-folder-open me-2"></i>
            استدعاء
        </button>
        <a href="{{ route('invoices.index') }}" style="width:170px;" class="btn btn-primary">
            <i class="fas fa-home me-2"></i>
            النظام
        </a>
        <button type="button" style="width:170px;" class="btn btn-danger" onclick="showLogoutModal()">
            <i class="fas fa-sign-out-alt me-2"></i>
             الخروج
        </button>
   
    </div>
    

</div>
@endsection


@section('content')
<form method="POST" action="{{ route('invoices.store') }}" id="restaurant-pos-form">
    @csrf
    <input type="hidden" name="type" value="simplified">
    <input type="hidden" name="issue_date" value="{{ date('Y-m-d') }}">
    <input type="hidden" name="supply_date" value="{{ date('Y-m-d') }}">
    <input type="hidden" name="customer_id" value="1">
    
    <div class="row">
        <!-- منطقة اختيار المنتجات -->
        <div class="col-lg-8">
            <!-- معلومات الطلب السريعة -->
            <div class="card restaurant-order-info">
                <div class="card-body p-3">
                    <div class="row align-items-center">
                        <div class="col-md-3">
                            <select name="order_type" class="form-select" required>
                                <option value="dine_in" selected>تناول في المطعم</option>
                                <option value="takeaway">طلب خارجي</option>
                                <option value="delivery">توصيل</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <input type="number" name="table_number" class="form-control" min="1" placeholder="رقم الطاولة">
                        </div>
                        <div class="col-md-3">
                            <input type="tel" name="customer_phone" class="form-control" placeholder="رقم هاتف العميل">
                        </div>
                        <div class="col-md-3">
                            <input type="text" name="customer_name" class="form-control" placeholder="اسم العميل">
                        </div>
                    </div>
                </div>
            </div>

            <!-- فئات المنتجات -->
            <div class="card mt-3">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-utensils me-2"></i>
                        القائمة
                    </h5>
                </div>
                <div class="card-body">
                    <!-- تبويبات الفئات -->
                    <div class="category-tabs mb-3">
                        <div class="btn-group w-100" role="group">
                            <!-- تبويبة "الكل" -->
                            <button type="button" class="btn category-tab category-all active" data-category="all">
                                <i class="fas fa-th me-1"></i>
                                الكل
                            </button>
                            
                            <!-- تبويبات الفئات من قاعدة البيانات -->
                            @foreach($categories as $category)
                            <button type="button" class="btn category-tab category-{{ $category['value'] }}" data-category="{{ $category['value'] }}">
                                <span class="me-1">{{ $category['icon'] }}</span>
                                {{ $category['name'] }}
                            </button>
                            @endforeach
                        </div>
                    </div>

                    <!-- شريط البحث -->
                    <div class="search-bar mb-3">
                        <div class="input-group">
                            <span class="input-group-text">
                                <i class="fas fa-search"></i>
                            </span>
                            <input type="text" class="form-control" id="product-search" placeholder="ابحث عن المنتجات...">
                            <button class="btn btn-outline-secondary" type="button" onclick="clearSearch()">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                    </div>

                    <!-- شبكة المنتجات -->
                    <div class="products-grid" id="products-grid">
                        @foreach($products as $product)
                        <div class="product-card"
                             data-product='@json($product)'
                             data-category="{{ $product->category_id ?? 'other' }}"
                             data-product-id="{{ $product->id }}"
                             data-product-name="{{ $product->name }}"
                             onclick="addProductToOrder(this); return false;"
                             style="cursor: pointer;">
                            <div class="product-image">
                                @if($product->image)
                                    <img src="{{ asset('storage/' . $product->image) }}" alt="{{ $product->name }}">
                                @else
                                    <div class="product-placeholder">
                                        <i class="fas fa-utensils"></i>
                                    </div>
                                @endif
                                @if($product->type == 'product' && $product->stock_quantity <= 0)
                                    <div class="out-of-stock-overlay">
                                        <span>نفذ المخزون</span>
                                    </div>
                                @endif
                            </div>
                            <div class="product-info">
                                <h6 class="product-name">{{ $product->name }}</h6>
                                <p class="product-price">{{ number_format($product->price, 2) }} ر.س</p>
                                @if($product->description)
                                    <p class="product-description">{{ Str::limit($product->description, 40) }}</p>
                                @endif
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
        
        <!-- منطقة الطلب وملخص الفاتورة -->
        <div class="col-lg-4">
            <!-- عناصر الطلب -->
            <div class="card order-summary">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-shopping-cart me-2"></i>
                        الطلب الحالي
                        <span class="badge ms-2" id="items-count" style="background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);">0</span>
                    </h5>
                    <button type="button" class="btn btn-sm btn-outline-danger" onclick="clearOrder()">
                        <i class="fas fa-trash me-1"></i>
                        مسح الطلب
                    </button>
                </div>
                <div class="card-body p-0">
                    <div class="order-items" id="order-items">
                        <div class="empty-order text-center p-4">
                            <i class="fas fa-shopping-cart fa-3x text-muted mb-3"></i>
                            <p class="text-muted">لم يتم إضافة أي عناصر بعد</p>
                            <p class="small text-muted">اختر من القائمة لإضافة العناصر</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- ملخص المبالغ -->
            <div class="card order-totals mt-3">
                <div class="card-body">
                    <!-- السطر الأول: المجموع الفرعي والخصم -->
                    <div class="row mb-3">
                        <div class="col-6">
                            <div class="totals-field">
                                <label class="totals-label">المجموع الفرعي:</label>
                                <div class="totals-value" id="subtotal-display">0.00 ر.س</div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="totals-field">
                                <label class="totals-label">الخصم:</label>
                                <div class="input-group">
                                    <input type="number" name="discount_amount" class="form-control discount-input"
                                           value="0" step="0.01" min="0" onchange="calculateTotals()">
                                    <span class="input-group-text">ر.س</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- السطر الثاني: الضريبة والمبلغ الإجمالي -->
                    <div class="row">
                        <div class="col-6">
                            <div class="totals-field">
                                <label class="totals-label">الضريبة (15%):</label>
                                <div class="totals-value" id="tax-total-display">0.00 ر.س</div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="totals-field total-field">
                                <label class="totals-label total-label">المبلغ الإجمالي:</label>
                                <div class="totals-value total-value" id="total-display">0.00 ر.س</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- طرق الدفع السريعة -->
            <div class="payment-methods-compact mt-2">
                <small class="text-muted mb-1 d-block">
                    <i class="fas fa-credit-card me-1"></i>
                    طريقة الدفع
                </small>
                <div class="payment-buttons-compact">
                    <button type="button" class="btn btn-payment-compact active" data-method="cash" onclick="selectPaymentMethod('cash')" title="الدفع نقداً">
                        <i class="fas fa-money-bill-wave"></i>
                        <span>نقداً</span>
                    </button>
                    <button type="button" class="btn btn-payment-compact" data-method="credit_card" onclick="selectPaymentMethod('credit_card')" title="الدفع بالبطاقة">
                        <i class="fas fa-credit-card"></i>
                        <span>بطاقة</span>
                    </button>
                    <button type="button" class="btn btn-payment-compact" data-method="bank_transfer" onclick="selectPaymentMethod('bank_transfer')" title="التحويل البنكي">
                        <i class="fas fa-university"></i>
                        <span>تحويل</span>
                    </button>
                </div>
                <input type="hidden" name="payment_method" value="cash">
                <input type="hidden" name="paid_amount" value="0">
                <input type="hidden" name="payment_date" value="{{ now() }}">
            </div>

            <!-- أزرار العمليات -->
        <div class="action-buttons mt-3">
            <!-- مؤشر حالة الحفظ -->
            <div class="save-status-indicator mb-2" id="save-status" style="display: none;">
                <div class="alert alert-info">
                    <i class="fas fa-spinner fa-spin me-2"></i>
                    جاري حفظ البيانات...
                </div>
            </div>
            
            <!-- أزرار الدفع السريع -->
            <div class="quick-pay-buttons mb-3">
                <button type="button" class="btn btn-lg w-100 mb-2" onclick="quickPay('full')" id="full-pay-btn" style="background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%); border: none; color: white;">
                    <i class="fas fa-print me-2"></i>
                    <span class="btn-text">دفع كامل وطباعة</span>
                    <span class="btn-loading" style="display: none;">
                        <i class="fas fa-spinner fa-spin me-2"></i>
                        جاري المعالجة...
                    </span>
                </button>
                <div class="row">
                    <div class="col-6">
                        <button type="button" class="btn w-100" onclick="quickPay('partial')" id="partial-pay-btn" style="background: linear-gradient(135deg, #ffc107 0%, #fd7e14 100%); border: none; color: white;">
                            <i class="fas fa-hand-holding-usd me-1"></i>
                            <span class="btn-text">دفع جزئي</span>
                        </button>
                    </div>
                    <div class="col-6">
                        <button type="button" class="btn w-100" onclick="saveOrder()" id="save-only-btn" style="background: linear-gradient(135deg, #17a2b8 0%, #138496 100%); border: none; color: white;">
                            <i class="fas fa-save me-1"></i>
                            <span class="btn-text">حفظ فقط</span>
                            <span class="btn-loading" style="display: none;">
                                <i class="fas fa-spinner fa-spin me-1"></i>
                                جاري الحفظ...
                            </span>
                        </button>
                    </div>
                </div>
            </div>
                
                <!-- أزرار إضافية -->
                <div class="additional-actions">
                    <div class="row">
                        <div class="col-6">
                            <button type="button" class="btn w-100" onclick="addDiscount()" style="border: 2px solid #20b2aa; color: #20b2aa; background: transparent;">
                                <i class="fas fa-percentage me-1"></i>
                                خصم
                            </button>
                        </div>
                        <div class="col-6">
                            <button type="button" class="btn w-100" onclick="addNote()" style="border: 2px solid #6c757d; color: #6c757d; background: transparent;">
                                <i class="fas fa-sticky-note me-1"></i>
                                ملاحظة
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>

<!-- Hidden form elements for invoice items -->
<div id="hidden-items-container" style="display: none;"></div>

<!-- نافذة تأكيد مسح الطلب -->
<div class="modal fade" id="clearOrderModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title">
                    <i class="fas fa-trash me-2"></i>
                    تأكيد مسح الطلب
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="text-center mb-3">
                    <i class="fas fa-exclamation-triangle fa-3x text-warning mb-3"></i>
                    <h5>هل أنت متأكد من مسح الطلب؟</h5>
                    <p class="text-muted">سيتم حذف جميع العناصر من الطلب الحالي ولا يمكن التراجع عن هذا الإجراء</p>
                </div>
                
                <div id="clear-order-summary" class="order-summary-preview">
                    <!-- سيتم ملؤها ديناميكياً -->
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="fas fa-times me-2"></i>
                    إلغاء
                </button>
                <button type="button" class="btn btn-danger" onclick="confirmClearOrder()">
                    <i class="fas fa-trash me-2"></i>
                    تأكيد المسح
                </button>
            </div>
        </div>
    </div>
</div>

<!-- نافذة تأكيد تعليق الطلب -->
<div class="modal fade" id="holdOrderModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-warning text-dark">
                <h5 class="modal-title">
                    <i class="fas fa-pause me-2"></i>
                    تأكيد تعليق الطلب
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="text-center mb-3">
                    <i class="fas fa-pause-circle fa-3x text-warning mb-3"></i>
                    <h5>هل تريد تعليق الطلب الحالي؟</h5>
                    <p class="text-muted">سيتم حفظ الطلب مؤقتاً ويمكنك استدعاؤه لاحقاً</p>
                </div>
                
                <div id="hold-order-summary" class="order-summary-preview">
                    <!-- سيتم ملؤها ديناميكياً -->
                </div>
                
                <div class="mt-3">
                    <label for="hold-order-note" class="form-label">ملاحظة اختيارية:</label>
                    <input type="text" class="form-control" id="hold-order-note" placeholder="أدخل ملاحظة للطلب المعلق...">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="fas fa-times me-2"></i>
                    إلغاء
                </button>
                <button type="button" class="btn btn-warning" onclick="confirmHoldOrder()">
                    <i class="fas fa-pause me-2"></i>
                    تأكيد التعليق
                </button>
            </div>
        </div>
    </div>
</div>

<!-- نافذة استدعاء الطلبات المعلقة -->
<div class="modal fade" id="loadOrderModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-info text-white">
                <h5 class="modal-title">
                    <i class="fas fa-folder-open me-2"></i>
                    استدعاء الطلبات المعلقة
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="held-orders-list">
                    <!-- سيتم ملؤها ديناميكياً -->
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="fas fa-times me-2"></i>
                    إغلاق
                </button>
            </div>
        </div>
    </div>
</div>

<!-- نافذة إضافة ملاحظة للطلب -->
<div class="modal fade" id="addNoteModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content add-note-modal">
            <div class="modal-header add-note-header">
                <div class="header-icon-container">
                    <div class="header-icon">
                        <i class="fas fa-sticky-note"></i>
                    </div>
                </div>
                <div class="header-content">
                    <h5 class="modal-title mb-1">إضافة ملاحظة للطلب</h5>
                    <p class="modal-subtitle mb-0">أضف تعليقات أو تعليمات خاصة للطلب</p>
                </div>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            
            <div class="modal-body add-note-body">
                <div class="note-input-section">
                    <div class="input-icon-wrapper">
                        <i class="fas fa-edit input-icon"></i>
                        <textarea class="form-control note-textarea"
                                  id="order-note-input"
                                  rows="4"
                                  placeholder="اكتب ملاحظتك هنا... (مثال: بدون بصل، إضافة صوص، تقديم ساخن)"
                                  maxlength="500"></textarea>
                    </div>
                    <div class="character-counter">
                        <span id="note-char-count">0</span> / 500 حرف
                    </div>
                </div>
                
                <!-- أمثلة للملاحظات السريعة -->
                <div class="quick-notes-section mt-4">
                    <h6 class="section-title mb-3">
                        <i class="fas fa-lightbulb me-2"></i>
                        ملاحظات سريعة
                    </h6>
                    <div class="quick-notes-grid">
                        <button type="button" class="quick-note-btn" onclick="selectQuickNote('بدون بصل')">
                            <i class="fas fa-times-circle me-1"></i>
                            بدون بصل
                        </button>
                        <button type="button" class="quick-note-btn" onclick="selectQuickNote('بدون ملح')">
                            <i class="fas fa-times-circle me-1"></i>
                            بدون ملح
                        </button>
                        <button type="button" class="quick-note-btn" onclick="selectQuickNote('إضافة صوص')">
                            <i class="fas fa-plus-circle me-1"></i>
                            إضافة صوص
                        </button>
                        <button type="button" class="quick-note-btn" onclick="selectQuickNote('تقديم ساخن')">
                            <i class="fas fa-fire me-1"></i>
                            تقديم ساخن
                        </button>
                        <button type="button" class="quick-note-btn" onclick="selectQuickNote('قليل التوابل')">
                            <i class="fas fa-leaf me-1"></i>
                            قليل التوابل
                        </button>
                        <button type="button" class="quick-note-btn" onclick="selectQuickNote('طلب عاجل')">
                            <i class="fas fa-clock me-1"></i>
                            طلب عاجل
                        </button>
                    </div>
                </div>
                
                <!-- معاينة الملاحظة الحالية -->
                <div class="current-note-section mt-4" id="current-note-section" style="display: none;">
                    <h6 class="section-title mb-2">
                        <i class="fas fa-eye me-2"></i>
                        الملاحظة الحالية
                    </h6>
                    <div class="current-note-display" id="current-note-display">
                        <!-- ستُملأ ديناميكياً -->
                    </div>
                </div>
            </div>
            
            <div class="modal-footer add-note-footer">
                <button type="button" class="btn btn-light btn-cancel" data-bs-dismiss="modal">
                    <i class="fas fa-times me-2"></i>
                    إلغاء
                </button>
                <button type="button" class="btn btn-outline-secondary btn-clear" onclick="clearNote()">
                    <i class="fas fa-eraser me-2"></i>
                    مسح الملاحظة
                </button>
                <button type="button" class="btn btn-success btn-save-note" onclick="saveOrderNote()">
                    <i class="fas fa-check me-2"></i>
                    <span class="btn-text">حفظ الملاحظة</span>
                </button>
            </div>
        </div>
    </div>
</div>

<!-- نافذة الخصم -->
<div class="modal fade" id="discountModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">إضافة خصم</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">نوع الخصم</label>
                    <select class="form-select" id="discount-type">
                        <option value="amount">مبلغ ثابت</option>
                        <option value="percentage">نسبة مئوية</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label">قيمة الخصم</label>
                    <input type="number" class="form-control" id="discount-value" min="0" step="0.01">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <button type="button" class="btn" onclick="applyDiscount()" style="background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%); border: none; color: white;">تطبيق الخصم</button>
            </div>
        </div>
    </div>
</div>

<!-- نافذة المبلغ المدفوع -->
<div class="modal fade" id="paymentModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">المبلغ المدفوع</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">إجمالي المبلغ</label>
                    <input type="text" class="form-control" id="modal-total-amount" readonly>
                </div>
                <div class="mb-3">
                    <label class="form-label">المبلغ المدفوع</label>
                    <input type="number" class="form-control" id="modal-paid-amount" min="0" step="0.01">
                </div>
                <div class="mb-3">
                    <label class="form-label">المبلغ المتبقي</label>
                    <input type="text" class="form-control" id="modal-remaining-amount" readonly>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <button type="button" class="btn" onclick="confirmPayment()" style="background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%); border: none; color: white;">تأكيد الدفع</button>
            </div>
        </div>
    </div>
</div>

<!-- نافذة الطباعة بعد الحفظ -->
<div class="modal fade" id="printModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title">
                    <i class="fas fa-check-circle me-2"></i>
                    تم حفظ الفاتورة بنجاح
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body text-center">
                <div class="mb-4">
                    <i class="fas fa-receipt fa-4x text-success mb-3"></i>
                    <h4>فاتورة رقم: <span id="invoice-number-display"></span></h4>
                    <p class="text-muted">تم إنشاء الفاتورة وحفظها في قاعدة البيانات</p>
                </div>
                
                <div class="row">
                    <div class="col-6">
                        <div class="info-card">
                            <h6>المبلغ الإجمالي</h6>
                            <strong id="final-total-display" class="text-primary"></strong>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="info-card">
                            <h6>حالة الدفع</h6>
                            <span id="payment-status-display" class="badge"></span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="startNewOrder()">
                    <i class="fas fa-plus me-2"></i>
                    طلب جديد
                </button>
                <button type="button" class="btn" onclick="printInvoice()" style="background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%); border: none; color: white;">
                    <i class="fas fa-print me-2"></i>
                    طباعة الفاتورة
                </button>
                <button type="button" class="btn" onclick="viewInvoice()" style="background: linear-gradient(135deg, #17a2b8 0%, #138496 100%); border: none; color: white;">
                    <i class="fas fa-eye me-2"></i>
                    عرض الفاتورة
                </button>
            </div>
        </div>
    </div>
</div>

<!-- نافذة تأكيد الحفظ المحسنة -->
<div class="modal fade" id="saveConfirmModal" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content save-confirm-modal">
            <div class="modal-header save-confirm-header">
                <div class="header-icon-container">
                    <div class="header-icon">
                        <i class="fas fa-receipt"></i>
                    </div>
                </div>
                <div class="header-content">
                    <h4 class="modal-title mb-1">تأكيد حفظ الفاتورة</h4>
                    <p class="modal-subtitle mb-0">مراجعة تفاصيل الطلب قبل الحفظ النهائي</p>
                </div>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            
            <div class="modal-body save-confirm-body">
                <!-- معلومات الطلب الأساسية -->
                <div class="order-info-section mb-4">
                    <div class="section-header mb-3">
                        <i class="fas fa-info-circle text-primary"></i>
                        <h6 class="section-title mb-0">معلومات الطلب</h6>
                    </div>
                    <div class="info-cards-grid">
                        <div class="info-card-modern">
                            <div class="info-icon">
                                <i class="fas fa-utensils"></i>
                            </div>
                            <div class="info-details">
                                <small class="info-label">نوع الطلب</small>
                                <div class="info-value" id="preview-order-type"></div>
                            </div>
                        </div>
                        
                        <div class="info-card-modern">
                            <div class="info-icon">
                                <i class="fas fa-user"></i>
                            </div>
                            <div class="info-details">
                                <small class="info-label">العميل</small>
                                <div class="info-value" id="preview-customer"></div>
                            </div>
                        </div>
                        
                        <div class="info-card-modern" id="table-info-card" style="display: none;">
                            <div class="info-icon">
                                <i class="fas fa-chair"></i>
                            </div>
                            <div class="info-details">
                                <small class="info-label">رقم الطاولة</small>
                                <div class="info-value" id="preview-table-number"></div>
                            </div>
                        </div>
                        
                        <div class="info-card-modern">
                            <div class="info-icon">
                                <i class="fas fa-clock"></i>
                            </div>
                            <div class="info-details">
                                <small class="info-label">الوقت</small>
                                <div class="info-value" id="preview-time"></div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- عناصر الطلب -->
                <div class="order-items-section mb-4">
                    <div class="section-header mb-3">
                        <i class="fas fa-shopping-basket text-success"></i>
                        <h6 class="section-title mb-0">عناصر الطلب</h6>
                        <span class="items-count-badge" id="preview-items-count">0 عنصر</span>
                    </div>
                    <div class="items-preview-modern" id="preview-items">
                        <!-- سيتم ملؤها ديناميكياً -->
                    </div>
                </div>

                <!-- ملخص المبالغ -->
                <div class="totals-section">
                    <div class="section-header mb-3">
                        <i class="fas fa-calculator text-warning"></i>
                        <h6 class="section-title mb-0">ملخص المبالغ</h6>
                    </div>
                    <div class="totals-preview-modern">
                        <div class="total-row">
                            <span class="total-label">المجموع الفرعي:</span>
                            <span class="total-value" id="preview-subtotal">0.00 ر.س</span>
                        </div>
                        <div class="total-row discount-row" id="discount-row" style="display: none;">
                            <span class="total-label">الخصم:</span>
                            <span class="total-value text-danger" id="preview-discount">0.00 ر.س</span>
                        </div>
                        <div class="total-row">
                            <span class="total-label">ضريبة القيمة المضافة (15%):</span>
                            <span class="total-value" id="preview-tax">0.00 ر.س</span>
                        </div>
                        <div class="total-row final-total">
                            <span class="total-label">المبلغ الإجمالي:</span>
                            <span class="total-value" id="preview-total">0.00 ر.س</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="modal-footer save-confirm-footer">
                <button type="button" class="btn btn-light btn-cancel" data-bs-dismiss="modal">
                    <i class="fas fa-times me-2"></i>
                    إلغاء
                </button>
                <button type="button" class="btn btn-success btn-confirm" onclick="confirmSaveOrder()">
                    <i class="fas fa-save me-2"></i>
                    <span class="btn-text">تأكيد الحفظ</span>
                    <span class="btn-spinner" style="display: none;">
                        <i class="fas fa-spinner fa-spin me-2"></i>
                        جاري الحفظ...
                    </span>
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Advanced Calculator Modal -->
<div class="modal fade" id="calculatorModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content calculator-modal">
            <div class="modal-header calculator-header">
                <div class="header-icon-container">
                    <div class="header-icon">
                        <i class="fas fa-calculator"></i>
                    </div>
                </div>
                <div class="header-content">
                    <h5 class="modal-title mb-1">الآلة الحاسبة المتقدمة</h5>
                </div>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            
            <div class="modal-body calculator-body">
                <!-- Calculator Display -->
                <div class="calculator-display-container">
                    <div class="calculator-history" id="calc-history"></div>
                    <div class="calculator-display" id="calc-display">0</div>
                    <div class="calculator-operation" id="calc-operation"></div>
                </div>
                
                <!-- Calculator Buttons -->
                <div class="calculator-grid">
      
                    
                    <!-- Scientific Functions Row 2 -->
                    <div class="calculator-row scientific-functions">
                        <button type="button" class="calc-btn function-btn" onclick="calcFunction('sqrt')">√</button>
                        <button type="button" class="calc-btn function-btn" onclick="calcFunction('power')">x²</button>
                        <button type="button" class="calc-btn function-btn" onclick="calcFunction('factorial')">x!</button>
                        <button type="button" class="calc-btn function-btn" onclick="calcFunction('percent')">%</button>
                        <button type="button" class="calc-btn function-btn" onclick="calcFunction('pi')">π</button>
                    </div>
                    
                    <!-- Main Calculator Buttons -->
                    <div class="calculator-row">
                        <button type="button" class="calc-btn clear-btn" onclick="calcClear()">C</button>
                        <button type="button" class="calc-btn clear-btn" onclick="calcClearEntry()">CE</button>
                        <button type="button" class="calc-btn operation-btn" onclick="calcBackspace()">⌫</button>
                        <button type="button" class="calc-btn operation-btn" onclick="calcOperation('÷')">÷</button>
                    </div>
                    
                    <div class="calculator-row">
                        <button type="button" class="calc-btn number-btn" onclick="calcNumber('7')">7</button>
                        <button type="button" class="calc-btn number-btn" onclick="calcNumber('8')">8</button>
                        <button type="button" class="calc-btn number-btn" onclick="calcNumber('9')">9</button>
                        <button type="button" class="calc-btn operation-btn" onclick="calcOperation('×')">×</button>
                    </div>
                    
                    <div class="calculator-row">
                        <button type="button" class="calc-btn number-btn" onclick="calcNumber('4')">4</button>
                        <button type="button" class="calc-btn number-btn" onclick="calcNumber('5')">5</button>
                        <button type="button" class="calc-btn number-btn" onclick="calcNumber('6')">6</button>
                        <button type="button" class="calc-btn operation-btn" onclick="calcOperation('-')">-</button>
                    </div>
                    
                    <div class="calculator-row">
                        <button type="button" class="calc-btn number-btn" onclick="calcNumber('1')">1</button>
                        <button type="button" class="calc-btn number-btn" onclick="calcNumber('2')">2</button>
                        <button type="button" class="calc-btn number-btn" onclick="calcNumber('3')">3</button>
                        <button type="button" class="calc-btn operation-btn" onclick="calcOperation('+')">+</button>
                    </div>
                    
                    <div class="calculator-row">
                        <button type="button" class="calc-btn number-btn zero-btn" onclick="calcNumber('0')">0</button>
                        <button type="button" class="calc-btn number-btn" onclick="calcDecimal()">.</button>
                        <button type="button" class="calc-btn equals-btn" onclick="calcEquals()">=</button>
                    </div>
                </div>
                
                <!-- Quick Actions -->
                <div class="calculator-quick-actions mt-3">
                    <div class="row">
                        <div class="col-6">
                            <button type="button" class="btn btn-outline-primary w-100" onclick="insertToDiscount()">
                                <i class="fas fa-tag me-1"></i>
                                إدراج في الخصم
                            </button>
                        </div>
                        <div class="col-6">
                            <button type="button" class="btn btn-outline-success w-100" onclick="copyResult()">
                                <i class="fas fa-copy me-1"></i>
                                نسخ النتيجة
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="modal-footer calculator-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="fas fa-times me-2"></i>
                    إغلاق
                </button>
                <button type="button" class="btn btn-primary" onclick="calcClear()">
                    <i class="fas fa-redo me-2"></i>
                    إعادة تعيين
                </button>
            </div>
        </div>
    </div>
</div>

<!-- نافذة تأكيد تسجيل الخروج -->
<div class="modal fade" id="logoutModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title">
                    <i class="fas fa-sign-out-alt me-2"></i>
                    تأكيد تسجيل الخروج
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="text-center mb-4">
                    <i class="fas fa-exclamation-triangle fa-3x text-warning mb-3"></i>
                    <h5>هل أنت متأكد من تسجيل الخروج؟</h5>
                    <p class="text-muted">سيتم إنهاء جلستك الحالية وستحتاج لتسجيل الدخول مرة أخرى</p>
                </div>
                
                <div id="logout-order-warning" class="alert alert-warning" role="alert" style="display: none;">
                    <i class="fas fa-shopping-cart me-2"></i>
                    <strong>تنبيه:</strong> يوجد طلب حالي لم يتم حفظه بعد. تأكد من حفظ الطلب قبل تسجيل الخروج لتجنب فقدان البيانات.
                </div>
                
                <div class="d-flex justify-content-center">
                    <div class="text-center">
                        <i class="fas fa-user-circle fa-2x text-muted mb-2"></i>
                        <p class="small text-muted">المستخدم: {{ Auth::user()->name ?? 'غير محدد' }}</p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="fas fa-times me-2"></i>
                    إلغاء
                </button>
                <button type="button" class="btn btn-danger" onclick="confirmLogout()">
                    <i class="fas fa-sign-out-alt me-2"></i>
                    تأكيد تسجيل الخروج
                </button>
            </div>
        </div>
    </div>
</div>

<!-- نافذة إضافة منتج جديد -->
<div class="modal fade" id="addProductModal" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content add-product-modal">
            <div class="modal-header add-product-header">
                <div class="header-icon-container">
                    <div class="header-icon">
                        <i class="fas fa-plus-circle"></i>
                    </div>
                </div>
                <div class="header-content">
                    <h4 class="modal-title mb-1">إضافة منتج جديد</h4>
                    <p class="modal-subtitle mb-0">أضف منتج جديد إلى قائمة المنتجات</p>
                </div>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            
            <form id="addProductForm" method="POST" action="{{ route('products.store') }}" enctype="multipart/form-data">
                @csrf
                <div class="modal-body add-product-body">
                    <div class="row">
                        <!-- الباركود -->
                        <div class="col-md-6 mb-3">
                            <label for="product-barcode" class="form-label">
                                <i class="fas fa-barcode me-2 text-primary"></i>
                                الباركود
                            </label>
                            <div class="input-group input-with-icon">
                                <span class="input-group-text">
                                    <i class="fas fa-barcode"></i>
                                </span>
                                <input type="text" class="form-control" id="product-barcode" name="barcode"
                                       placeholder="أدخل الباركود (اختياري)">
                                <button class="btn btn-outline-secondary" type="button" onclick="generateBarcode()">
                                    <i class="fas fa-random"></i>
                                </button>
                            </div>
                            <div class="form-text">رقم فريد لتعريف المنتج</div>
                        </div>
                        
                        <!-- رمز المنتج (SKU) -->
                        <div class="col-md-6 mb-3">
                            <label for="product-sku" class="form-label required">
                                <i class="fas fa-tag me-2 text-info"></i>
                                رمز المنتج (SKU)
                            </label>
                            <div class="input-group input-with-icon">
                                <span class="input-group-text">
                                    <i class="fas fa-tag"></i>
                                </span>
                                <input type="text" class="form-control" id="product-sku" name="sku"
                                       placeholder="مثال: PRD-001" required>
                            </div>
                            <div class="form-text">رمز داخلي للمنتج</div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <!-- اسم المنتج -->
                        <div class="col-12 mb-3">
                            <label for="product-name" class="form-label required">
                                <i class="fas fa-cube me-2 text-success"></i>
                                اسم المنتج
                            </label>
                            <div class="input-group input-with-icon">
                                <span class="input-group-text">
                                    <i class="fas fa-cube"></i>
                                </span>
                                <input type="text" class="form-control" id="product-name" name="name"
                                       placeholder="أدخل اسم المنتج" required maxlength="255">
                            </div>
                            <div class="character-counter">
                                <span id="name-char-count">0</span> / 255 حرف
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <!-- نوع المنتج -->
                        <div class="col-md-4 mb-3">
                            <label for="product-type" class="form-label required">
                                <i class="fas fa-cogs me-2 text-info"></i>
                                نوع المنتج
                            </label>
                            <div class="input-group input-with-icon">
                                <span class="input-group-text">
                                    <i class="fas fa-cogs"></i>
                                </span>
                                <select class="form-select" id="product-type" name="type" required>
                                    <option value="product">منتج</option>
                                    <option value="service">خدمة</option>
                                </select>
                            </div>
                        </div>
                        
                        <!-- السعر (بدون ضريبة) -->
                        <div class="col-md-4 mb-3">
                            <label for="product-price" class="form-label required">
                                <i class="fas fa-money-bill-wave me-2 text-warning"></i>
                                السعر (بدون ضريبة)
                            </label>
                            <div class="input-group input-with-icon">
                                <span class="input-group-text">
                                    <i class="fas fa-dollar-sign"></i>
                                </span>
                                <input type="number" class="form-control" id="product-price" name="price"
                                       placeholder="0.00" step="0.01" min="0" required>
                                <span class="input-group-text">ر.س</span>
                            </div>
                        </div>
                        
                        <!-- معدل الضريبة -->
                        <div class="col-md-4 mb-3">
                            <label for="product-tax-rate" class="form-label required">
                                <i class="fas fa-percent me-2 text-danger"></i>
                                معدل الضريبة
                            </label>
                            <div class="input-group input-with-icon">
                                <span class="input-group-text">
                                    <i class="fas fa-percent"></i>
                                </span>
                                <input type="number" class="form-control" id="product-tax-rate" name="tax_rate"
                                       placeholder="15" value="15" step="0.01" min="0" max="100" required>
                                <span class="input-group-text">%</span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row" id="stock-fields">
                        <!-- كمية المخزون -->
                        <div class="col-md-6 mb-3">
                            <label for="product-stock" class="form-label required">
                                <i class="fas fa-boxes me-2 text-success"></i>
                                كمية المخزون
                            </label>
                            <div class="input-group input-with-icon">
                                <span class="input-group-text">
                                    <i class="fas fa-boxes"></i>
                                </span>
                                <input type="number" class="form-control" id="product-stock" name="stock_quantity"
                                       placeholder="0" min="0" required>
                            </div>
                        </div>
                        
                        <!-- الحد الأدنى للمخزون -->
                        <div class="col-md-6 mb-3">
                            <label for="product-min-stock" class="form-label required">
                                <i class="fas fa-exclamation-triangle me-2 text-warning"></i>
                                الحد الأدنى للمخزون
                            </label>
                            <div class="input-group input-with-icon">
                                <span class="input-group-text">
                                    <i class="fas fa-exclamation-triangle"></i>
                                </span>
                                <input type="number" class="form-control" id="product-min-stock" name="min_stock"
                                       placeholder="5" min="0" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <!-- الوحدة -->
                        <div class="col-md-6 mb-3">
                            <label for="product-unit" class="form-label required">
                                <i class="fas fa-balance-scale me-2 text-info"></i>
                                الوحدة
                            </label>
                            <div class="input-group input-with-icon">
                                <span class="input-group-text">
                                    <i class="fas fa-balance-scale"></i>
                                </span>
                                <select class="form-select" id="product-unit" name="unit" required>
                                    <option value="قطعة">قطعة</option>
                                    <option value="كيلو">كيلو</option>
                                    <option value="جرام">جرام</option>
                                    <option value="لتر">لتر</option>
                                    <option value="متر">متر</option>
                                    <option value="علبة">علبة</option>
                                    <option value="كرتون">كرتون</option>
                                </select>
                            </div>
                        </div>
                        
                        <!-- الفئة -->
                        <div class="col-md-6 mb-3">
                            <label for="product-category" class="form-label">
                                <i class="fas fa-list me-2 text-purple"></i>
                                الفئة
                            </label>
                            <div class="input-group input-with-icon">
                                <span class="input-group-text">
                                    <i class="fas fa-list"></i>
                                </span>
                                <select class="form-select" id="product-category" name="category_id">
                                    <option value="">اختر الفئة (اختياري)</option>
                                    @foreach($categories as $category)
                                    <option value="{{ $category['value'] }}" data-icon="{{ $category['icon'] }}">
                                        {{ $category['name'] }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <!-- حقول مخفية -->
                    <input type="hidden" name="is_taxable" value="1">
                    <input type="hidden" name="is_active" value="1">
                    
                    <!-- صورة المنتج -->
                    <div class="row">
                        <div class="col-12 mb-3">
                            <label for="product-image" class="form-label">
                                <i class="fas fa-image me-2 text-danger"></i>
                                صورة المنتج
                            </label>
                            <div class="image-upload-section">
                                <div class="image-preview-container" id="image-preview-container">
                                    <div class="image-placeholder" id="image-placeholder">
                                        <i class="fas fa-image fa-3x text-muted mb-2"></i>
                                        <p class="text-muted mb-0">لا توجد صورة محددة</p>
                                        <small class="text-muted">اضغط أدناه لاختيار صورة</small>
                                    </div>
                                    <img id="image-preview" class="image-preview" style="display: none;" alt="معاينة الصورة">
                                </div>
                                
                                <div class="image-upload-controls mt-3">
                                    <div class="input-group">
                                        <input type="file" class="form-control" id="product-image" name="image"
                                               accept="image/jpeg,image/png,image/jpg,image/gif" onchange="previewImage(this)">
                                        <button class="btn btn-outline-danger" type="button" onclick="clearImage()" id="clear-image-btn" style="display: none;">
                                            <i class="fas fa-times"></i>
                                            مسح
                                        </button>
                                    </div>
                                    <div class="form-text">
                                        الصيغ المدعومة: JPG, JPEG, PNG, GIF - الحد الأقصى: 2MB
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- معاينة البيانات -->
                    <div class="product-preview-section mt-4" id="product-preview-section" style="display: none;">
                        <h6 class="section-title mb-3">
                            <i class="fas fa-eye me-2"></i>
                            معاينة المنتج
                        </h6>
                        <div class="product-preview-card">
                            <div class="preview-image">
                                <img id="preview-product-image" src="" alt="صورة المنتج" style="display: none;">
                                <div id="preview-placeholder" class="preview-placeholder">
                                    <i class="fas fa-utensils"></i>
                                </div>
                            </div>
                            <div class="preview-info">
                                <h6 id="preview-product-name" class="preview-name">اسم المنتج</h6>
                                <p id="preview-product-price" class="preview-price">0.00 ر.س</p>
                                <small id="preview-product-code" class="preview-code text-muted">رمز المنتج</small>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="modal-footer add-product-footer">
                    <button type="button" class="btn btn-light btn-cancel" data-bs-dismiss="modal">
                        <i class="fas fa-times me-2"></i>
                        إلغاء
                    </button>
                    <button type="button" class="btn btn-info btn-preview" onclick="togglePreview()">
                        <i class="fas fa-eye me-2"></i>
                        <span class="btn-text">معاينة</span>
                    </button>
                    <button type="submit" class="btn btn-success btn-save-product">
                        <i class="fas fa-plus me-2"></i>
                        <span class="btn-text">إضافة المنتج</span>
                        <span class="btn-spinner" style="display: none;">
                            <i class="fas fa-spinner fa-spin me-2"></i>
                            جاري الإضافة...
                        </span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@push('styles')
<style>
/* Restaurant POS Styles - Simplified Theme */
.restaurant-order-info {
    background: #20b2aa;
    color: white;
    border-radius: 8px;
    box-shadow: 0 2px 8px rgba(32, 178, 170, 0.2);
}

.restaurant-order-info .form-label {
    color: white;
    font-weight: 600;
    margin-bottom: 5px;
}

.restaurant-order-info .form-control,
.restaurant-order-info .form-select {
    border-radius: 6px;
    border: 1px solid rgba(255,255,255,0.3);
    background: rgba(255,255,255,0.95);
    font-weight: 500;
}

/* Category Tabs - Simplified Clean Design */
.category-tabs {
    background: white;
    border-radius: 8px;
    padding: 12px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    border: 1px solid #e9ecef;
    margin-bottom: 20px;
}

.category-tabs .btn-group {
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
    width: 100%;
    justify-content: flex-start;
}

.category-tabs .btn {
    border-radius: 8px;
    padding: 12px 20px;
    font-weight: 500;
    font-size: 0.9rem;
    transition: all 0.2s ease;
    border: 1px solid #dee2e6;
    flex: 0 0 auto;
    min-width: 110px;
    text-align: center;
    cursor: pointer;
    user-select: none;
    background: #f8f9fa;
    color: #495057;
}

/* الكل (All Category) */
.category-all {
    background: #20b2aa;
    border-color: #20b2aa;
    color: white;
}

.category-all:hover,
.category-all.active {
    background: #17a2b8;
    border-color: #17a2b8;
    color: white;
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(32, 178, 170, 0.3);
}

/* جميع التبويبات الأخرى - تصميم موحد وبسيط */
.category-tab:not(.category-all) {
    background: #f8f9fa;
    border-color: #dee2e6;
    color: #495057;
}

.category-tab:not(.category-all):hover,
.category-tab:not(.category-all).active {
    background: #20b2aa;
    border-color: #20b2aa;
    color: white;
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(32, 178, 170, 0.3);
}

/* إزالة جميع الألوان المخصصة للفئات - استخدام لون موحد */
.category-food,
.category-appetizer,
.category-beverage,
.category-dessert,
.category-main_course,
.category-combo,
.category-other {
    background: #f8f9fa !important;
    border-color: #dee2e6 !important;
    color: #495057 !important;
}

.category-food:hover,
.category-food.active,
.category-appetizer:hover,
.category-appetizer.active,
.category-beverage:hover,
.category-beverage.active,
.category-dessert:hover,
.category-dessert.active,
.category-main_course:hover,
.category-main_course.active,
.category-combo:hover,
.category-combo.active,
.category-other:hover,
.category-other.active {
    background: #20b2aa !important;
    border-color: #20b2aa !important;
    color: white !important;
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(32, 178, 170, 0.3);
}

/* تبسيط الأيقونات */
.category-tab i,
.category-tab span {
    margin-right: 6px;
    font-size: 1em;
    transition: none;
}

/* Search Bar */
.search-bar .input-group-text {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    border-color: #20b2aa;
    color: white;
}

.search-bar .form-control {
    border-radius: 0 2px 2px 0;
    padding: 12px;
    font-size: 16px;
}

/* Products Grid */
.products-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
    gap: 15px;
    max-height: 710px;
    overflow-y: auto;
    padding: 10px;
}

.product-card {
    background: white;
    border-radius: 2px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.08);
    overflow: hidden;
    cursor: pointer;
    transition: all 0.3s ease;
    border: 2px solid transparent;
    position: relative;
}

.product-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15);
    border-color: #20b2aa;
}

.product-image {
    height: 120px;
    background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    position: relative;
}

.product-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.product-placeholder {
    font-size: 2rem;
    color: #20b2aa;
}

.out-of-stock-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(220, 53, 69, 0.9);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
}

.product-info {
    padding: 15px;
    text-align: center;
}

.product-name {
    font-weight: 700;
    color: #2d3436;
    margin-bottom: 5px;
    font-size: 0.95rem;
}

.product-price {
    font-size: 1.1rem;
    font-weight: 800;
    color: #20b2aa;
    margin-bottom: 5px;
}

.product-description {
    font-size: 0.8rem;
    color: #636e72;
    margin: 0;
}

/* Order Summary */
.order-summary {
    border-radius: 2px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
}

.order-summary .card-header {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    color: white;
    border-radius: 2px 2px 0 0;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.order-items {
    max-height: 400px;
    overflow-y: auto;
}

.order-item {
    padding: 15px;
    border-bottom: 1px solid #eee;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.order-item:last-child {
    border-bottom: none;
}

.item-info h6 {
    margin: 0;
    font-weight: 600;
    color: #2d3436;
}

.item-price {
    font-weight: 700;
    color: #20b2aa;
}

.quantity-controls {
    display: flex;
    align-items: center;
    gap: 10px;
}

.quantity-btn {
    width: 30px;
    height: 30px;
    border-radius: 20%;
    border: 2px solid #20b2aa;
    background: white;
    color: #20b2aa;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.3s ease;
}

.quantity-btn:hover {
    background: #20b2aa;
    color: white;
}

.quantity-display {
    font-weight: bold;
    min-width: 30px;
    text-align: center;
}

/* Order Totals */
.order-totals {
    border-radius: 2px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
}

.totals-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 8px 0;
    font-size: 0.95rem;
}

.total-row {
    border-top: 2px solid #eee;
    padding-top: 15px;
    margin-top: 10px;
    font-size: 1.1rem;
}

/* أنماط حقول الملخص الجديدة */
.totals-field {
    background: #f8f9fa;
    border: 2px solid #e9ecef;
    border-radius: 8px;
    padding: 12px;
    height: 80px;
    display: flex;
    flex-direction: column;
    justify-content: center;
    text-align: center;
    transition: all 0.3s ease;
}

.totals-field:hover {
    border-color: #20b2aa;
    background: #f0fffe;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(32, 178, 170, 0.15);
}

.totals-label {
    font-size: 0.85rem;
    color: #6c757d;
    font-weight: 600;
    margin-bottom: 5px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.totals-value {
    font-size: 1.1rem;
    font-weight: 700;
    color: #2d3436;
    line-height: 1.2;
}

/* حقل الخصم */
.totals-field .input-group {
    margin-top: 5px;
}

.totals-field .discount-input {
    text-align: center;
    font-weight: 600;
    border: 1px solid #dee2e6;
    border-radius: 6px;
}

.totals-field .discount-input:focus {
    border-color: #20b2aa;
    box-shadow: 0 0 0 0.2rem rgba(32, 178, 170, 0.25);
}

.totals-field .input-group-text {
    background: #e9ecef;
    border: 1px solid #dee2e6;
    color: #6c757d;
    font-weight: 600;
    font-size: 0.9rem;
}

/* حقل المبلغ الإجمالي */
.total-field {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    border-color: #20b2aa;
    color: white;
    box-shadow: 0 4px 15px rgba(32, 178, 170, 0.3);
}

.total-field:hover {
    background: linear-gradient(135deg, #17a2b8 0%, #138496 100%);
    transform: translateY(-3px);
    box-shadow: 0 6px 20px rgba(32, 178, 170, 0.4);
}

.total-field .totals-label {
    color: rgba(255, 255, 255, 0.9);
}

.total-field .totals-value {
    color: white;
    font-size: 1.3rem;
    font-weight: 800;
    text-shadow: 0 1px 3px rgba(0, 0, 0, 0.2);
}

/* تحسين للأجهزة المحمولة */
@media (max-width: 768px) {
    .totals-field {
        height: 70px;
        padding: 10px;
        margin-bottom: 10px;
    }
    
    .totals-label {
        font-size: 0.8rem;
        margin-bottom: 3px;
    }
    
    .totals-value {
        font-size: 1rem;
    }
    
    .total-field .totals-value {
        font-size: 1.1rem;
    }
}

.discount-input {
    width: 80px;
    text-align: center;
}

/* Payment Methods - Compact Design */
.payment-methods-compact {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border: 1px solid #dee2e6;
    border-radius: 8px;
    padding: 8px 12px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}

.payment-buttons-compact {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 6px;
    margin-top: 4px;
}

.btn-payment-compact {
    display: flex;
    flex-direction: column;
    align-items: center;
    padding: 8px 6px;
    border-radius: 6px;
    border: 1px solid #dee2e6;
    background: white;
    color: #6c757d;
    transition: all 0.2s ease;
    font-size: 0.85rem;
    min-height: 50px;
}

.btn-payment-compact:hover,
.btn-payment-compact.active {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    border-color: #20b2aa;
    color: white;
    transform: translateY(-1px);
    box-shadow: 0 2px 8px rgba(32, 178, 170, 0.3);
}

.btn-payment-compact i {
    font-size: 1.1rem;
    margin-bottom: 2px;
}

.btn-payment-compact span {
    font-size: 0.75rem;
    font-weight: 500;
}

/* Legacy payment methods styles - keeping for backward compatibility */
.payment-methods {
    border-radius:2px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
}

.payment-buttons {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 10px;
}

.btn-payment {
    display: flex;
    flex-direction: column;
    align-items: center;
    padding: 15px 10px;
    border-radius: 2px;
    border: 2px solid #dee2e6;
    background: white;
    color: #6c757d;
    transition: all 0.3s ease;
}

.btn-payment:hover,
.btn-payment.active {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    border-color: #20b2aa;
    color: white;
    transform: translateY(-2px);
}

.btn-payment i {
    font-size: 1.5rem;
    margin-bottom: 5px;
}

/* Action Buttons */
.action-buttons .btn {
    border-radius: 2px;
    font-weight: 600;
    padding: 12px;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.action-buttons .btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(0,0,0,0.2);
}

.quick-pay-buttons .btn-success {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    border: none;
    font-size: 1.1rem;
    padding: 15px;
}

/* Empty Order State */
.empty-order {
    color: #6c757d;
}

.empty-order i {
    opacity: 0.5;
}

/* Touch-friendly improvements */
@media (max-width: 768px) {
    .products-grid {
        grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
        gap: 10px;
    }
    
    .product-card {
        border-radius: 2px;
    }
    
    .product-image {
        height: 100px;
    }
    
    .product-info {
        padding: 10px;
    }
    
    .btn-payment {
        padding: 12px 8px;
        font-size: 0.9rem;
    }
    
    .btn-payment-compact {
        padding: 6px 4px;
        font-size: 0.8rem;
        min-height: 45px;
    }
    
    .btn-payment-compact i {
        font-size: 1rem;
    }
    
    .btn-payment-compact span {
        font-size: 0.7rem;
    }
    
    .payment-methods-compact {
        padding: 6px 8px;
    }
    
    .payment-buttons-compact {
        gap: 4px;
    }
    
    .category-tabs .btn {
        padding: 10px 16px;
        font-size: 0.85rem;
        min-width: 100px;
        flex: 1;
        max-width: 140px;
    }
    
    .category-tabs .btn-group {
        flex-wrap: wrap;
        gap: 6px;
    }
    
    /* تحسين إضافي للتصميم المتجاوب على الشاشات الصغيرة */
    @media (max-width: 576px) {
        .category-tabs {
            padding: 8px;
            margin-bottom: 15px;
        }
        
        .category-tabs .btn {
            padding: 8px 12px;
            font-size: 0.8rem;
            min-width: 80px;
            flex: 1 1 calc(50% - 3px);
            max-width: none;
        }
        
        /* تحسين الأيقونات والنصوص للشاشات الصغيرة جداً */
        .category-tab i,
        .category-tab span {
            font-size: 0.9em;
            margin-right: 4px;
        }
        
        /* تحسين التأثيرات للمس */
        .category-tab:hover,
        .category-tab:active {
            transform: translateY(-1px) scale(1.01);
        }
        
        .category-tabs::before {
            height: 2px;
        }
    }
    
    /* تحسين للشاشات الصغيرة المتوسطة */
    @media (max-width: 480px) {
        .category-tabs .btn {
            padding: 6px 10px;
            font-size: 0.75rem;
            min-width: 70px;
            flex: 1 1 calc(33.333% - 4px);
        }
        
        .category-tab i,
        .category-tab span {
            font-size: 0.8em;
            margin-right: 2px;
        }
    }
    
    /* تحسين للشاشات الصغيرة جداً */
    @media (max-width: 360px) {
        .category-tabs {
            padding: 6px;
        }
        
        .category-tabs .btn {
            padding: 5px 8px;
            font-size: 0.7rem;
            min-width: 60px;
            border-radius: 8px;
        }
        
        .category-tab i {
            display: none; /* إخفاء الأيقونات في الشاشات الصغيرة جداً لتوفير مساحة */
        }
        
        .category-tab span {
            font-size: 0.7em;
            margin-right: 0;
        }
    }
}

/* Scrollbar Styling */
.products-grid::-webkit-scrollbar,
.order-items::-webkit-scrollbar {
    width: 6px;
}

.products-grid::-webkit-scrollbar-track,
.order-items::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 2px;
}

.products-grid::-webkit-scrollbar-thumb,
.order-items::-webkit-scrollbar-thumb {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    border-radius: 2px;
}

/* Animation for adding items */
@keyframes slideInRight {
    from {
        opacity: 0;
        transform: translateX(30px);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

.order-item.new-item {
    animation: slideInRight 0.3s ease;
}

/* Print Modal Styles */
.info-card {
    background: #f8f9fa;
    border-radius: 2px;
    padding: 15px;
    text-align: center;
    border: 1px solid #dee2e6;
}

.info-card h6 {
    margin-bottom: 5px;
    color: #6c757d;
    font-size: 0.8rem;
    text-transform: uppercase;
}

.order-summary-preview {
    background: #f8f9fa;
    border-radius: 2px;
    padding: 15px;
    border: 1px solid #dee2e6;
}

.items-preview {
    max-height: 150px;
    overflow-y: auto;
}

.items-preview .item {
    padding: 5px 0;
    border-bottom: 1px solid #eee;
    display: flex;
    justify-content: space-between;
    font-size: 0.9rem;
}

.items-preview .item:last-child {
    border-bottom: none;
}

.totals-preview {
    border-top: 2px solid #dee2e6;
    padding-top: 10px;
    margin-top: 10px;
}

.totals-preview > div {
    padding: 2px 0;
}

/* Loading state */
.btn-loading {
    position: relative;
    pointer-events: none;
}

.btn-loading::after {
    content: '';
    position: absolute;
    width: 16px;
    height: 16px;
    margin: auto;
    border: 2px solid transparent;
    border-top-color: #ffffff;
    border-radius: 20%;
    animation: button-loading-spinner 1s ease infinite;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
}

@keyframes button-loading-spinner {
    from {
        transform: rotate(0turn);
    }
    to {
        transform: rotate(1turn);
    }
}

/* أنماط للحقول غير الصحيحة */
.is-invalid {
    border-color: #dc3545 !important;
    box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25) !important;
    animation: shake 0.5s ease-in-out;
}

@keyframes shake {
    0%, 20%, 40%, 60%, 80% {
        transform: translateX(0);
    }
    10%, 30%, 50%, 70%, 90% {
        transform: translateX(-5px);
    }
}

/* تحسين مظهر الإشعارات */
.notification {
    max-width: 500px;
    white-space: pre-line;
    text-align: right;
    direction: rtl;
}

.notification.error {
    background-color: #f8d7da;
    border-color: #f5c6cb;
    color: #721c24;
}

/* تحسين مظهر النماذج */
.form-control:focus {
    border-color: #20b2aa;
    box-shadow: 0 0 0 0.2rem rgba(32, 178, 170, 0.25);
}

.form-select:focus {
    border-color: #20b2aa;
    box-shadow: 0 0 0 0.2rem rgba(32, 178, 170, 0.25);
}

/* أنماط الطلبات المعلقة */
.held-orders-container {
    max-height: 400px;
    overflow-y: auto;
}

.held-order-card {
    transition: all 0.3s ease;
}

.held-order-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
}

.held-order-card .card {
    border-radius: 2px;
    border: 1px solid #dee2e6;
}

.held-order-card .card-body {
    padding: 1rem;
}

.held-order-card .btn {
    font-size: 0.875rem;
    padding: 0.375rem 0.75rem;
    border-radius: 2px;
}

.held-order-card .btn-success {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    border: none;
}

.held-order-card .btn-success:hover {
    background: linear-gradient(135deg, #17a2b8 0%, #138496 100%);
}

/* تحسين مظهر modal الطلبات المعلقة */
#loadOrderModal .modal-body {
    padding: 1.5rem;
}

#loadOrderModal .modal-header {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    border-radius: 0.2rem 0.2rem 0 0;
}

/* أنماط تفاصيل الطلب */
.order-details-modal .table {
    margin-bottom: 0;
}

.order-details-modal .table th {
    background-color: #f8f9fa;
    border-top: none;
    font-weight: 600;
    color: #495057;
}

.order-details-modal .table td,
.order-details-modal .table th {
    padding: 0.75rem 0.5rem;
    border-color: #dee2e6;
}

/* تحسين مظهر modal تعليق الطلب */
#holdOrderModal .modal-header {
    background: linear-gradient(135deg, #ffeaa7 0%, #fab1a0 100%);
    color: #2d3436;
}

#holdOrderModal .modal-header .btn-close {
    filter: none;
    opacity: 0.8;
}

#holdOrderModal .modal-header .btn-close:hover {
    opacity: 1;
}

/* تحسين scrollbar للطلبات المعلقة */
.held-orders-container::-webkit-scrollbar {
    width: 6px;
}

.held-orders-container::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 2px;
}

.held-orders-container::-webkit-scrollbar-thumb {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    border-radius: 2px;
}

/* أنماط نافذة تأكيد الحفظ المحسنة */
.save-confirm-modal {
    border: none;
    border-radius: 2px;
    box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
    overflow: hidden;
    animation: modalSlideIn 0.4s ease-out;
}

@keyframes modalSlideIn {
    from {
        opacity: 0;
        transform: translateY(-50px) scale(0.95);
    }
    to {
        opacity: 1;
        transform: translateY(0) scale(1);
    }
}

.save-confirm-header {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    border: none;
    padding: 2rem 2rem 1.5rem;
    color: white;
    position: relative;
    overflow: hidden;
}

.save-confirm-header::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -50%;
    width: 200%;
    height: 200%;
    background: linear-gradient(45deg, transparent 40%, rgba(255, 255, 255, 0.1) 50%, transparent 60%);
    animation: shimmer 3s infinite;
}

@keyframes shimmer {
    0% { transform: translateX(-100%) translateY(-100%) rotate(45deg); }
    100% { transform: translateX(100%) translateY(100%) rotate(45deg); }
}

.header-icon-container {
    position: absolute;
    top: -20px;
    left: 2rem;
    width: 60px;
    height: 60px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 20%;
    display: flex;
    align-items: center;
    justify-content: center;
    backdrop-filter: blur(10px);
    border: 2px solid rgba(255, 255, 255, 0.3);
}

.header-icon {
    font-size: 1.5rem;
    color: white;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { transform: scale(1); }
    50% { transform: scale(1.1); }
}

.header-content {
    margin-right: 80px;
}

.modal-title {
    font-weight: 700;
    font-size: 1.5rem;
    margin: 0;
}

.modal-subtitle {
    font-size: 0.95rem;
    opacity: 0.9;
    font-weight: 400;
}

.save-confirm-body {
    padding: 2rem;
    background: linear-gradient(145deg, #f8f9ff 0%, #ffffff 100%);
}

.section-header {
    display: flex;
    align-items: center;
    gap: 10px;
    margin-bottom: 1rem;
    position: relative;
}

.section-title {
    font-weight: 600;
    color: #2d3436;
    margin: 0;
}

.items-count-badge {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    color: white;
    padding: 0.25rem 0.75rem;
    border-radius: 2px;
    font-size: 0.8rem;
    font-weight: 600;
    margin-right: auto;
}

.info-cards-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1rem;
    margin-bottom: 1rem;
}

.info-card-modern {
    background: white;
    border-radius: 2px;
    padding: 1rem;
    display: flex;
    align-items: center;
    gap: 12px;
    border: 1px solid #e9ecef;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.info-card-modern::before {
    content: '';
    position: absolute;
    top: 0;
    right: 0;
    width: 3px;
    height: 100%;
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
}

.info-card-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
    border-color: #20b2aa;
}

.info-icon {
    width: 40px;
    height: 40px;
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    border-radius: 2px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1rem;
    flex-shrink: 0;
}

.info-details {
    flex: 1;
}

.info-label {
    color: #6c757d;
    font-size: 0.8rem;
    text-transform: uppercase;
    font-weight: 600;
    letter-spacing: 0.5px;
}

.info-value {
    color: #2d3436;
    font-weight: 600;
    font-size: 0.95rem;
    margin-top: 2px;
}

.items-preview-modern {
    background: white;
    border-radius: 2px;
    border: 1px solid #e9ecef;
    max-height: 200px;
    overflow-y: auto;
}

.item-modern {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 1rem 1.25rem;
    border-bottom: 1px solid #f1f3f4;
    transition: background-color 0.3s ease;
}

.item-modern:last-child {
    border-bottom: none;
}

.item-modern:hover {
    background-color: #f8f9fa;
}

.item-info {
    display: flex;
    align-items: center;
    gap: 12px;
    flex: 1;
}

.item-icon {
    width: 35px;
    height: 35px;
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    border-radius: 2px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 0.9rem;
}

.item-details h6 {
    margin: 0;
    font-weight: 600;
    color: #2d3436;
    font-size: 0.95rem;
}

.item-details small {
    color: #6c757d;
    font-size: 0.8rem;
}

.item-quantity {
    background: #e9ecef;
    color: #495057;
    padding: 0.25rem 0.5rem;
    border-radius: 2px;
    font-weight: 600;
    font-size: 0.85rem;
    margin: 0 10px;
}

.item-price {
    font-weight: 700;
    color: #20b2aa;
    font-size: 1rem;
}

.totals-preview-modern {
    background: white;
    border-radius: 2px;
    padding: 1.5rem;
    border: 1px solid #e9ecef;
}

.total-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0.75rem 0;
    border-bottom: 1px solid #f1f3f4;
    transition: all 0.3s ease;
}

.total-row:last-child {
    border-bottom: none;
}

.total-row:hover {
    background: linear-gradient(90deg, transparent 0%, rgba(32, 178, 170, 0.05) 100%);
    margin: 0 -1rem;
    padding-left: 1rem;
    padding-right: 1rem;
    border-radius: 2px;
}

.total-label {
    color: #495057;
    font-weight: 500;
    font-size: 0.95rem;
}

.total-value {
    font-weight: 600;
    color: #2d3436;
    font-size: 1rem;
}

.discount-row .total-value {
    color: #dc3545 !important;
}

.final-total {
    border-top: 2px solid #20b2aa !important;
    border-bottom: none !important;
    margin-top: 0.5rem;
    padding-top: 1rem !important;
}

.final-total .total-label {
    font-weight: 700;
    font-size: 1.1rem;
    color: #2d3436;
}

.final-total .total-value {
    font-weight: 800;
    font-size: 1.3rem;
    color: #20b2aa;
}

.save-confirm-footer {
    background: #f8f9fa;
    border: none;
    padding: 1.5rem 2rem;
    display: flex;
    gap: 1rem;
    justify-content: flex-end;
}

.btn-cancel {
    border: 2px solid #dee2e6;
    color: #6c757d;
    font-weight: 600;
    padding: 0.75rem 1.5rem;
    border-radius: 2px;
    transition: all 0.3s ease;
}

.btn-cancel:hover {
    background: #6c757d;
    color: white;
    border-color: #6c757d;
    transform: translateY(-1px);
}

.btn-confirm {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    border: none;
    color: white;
    font-weight: 600;
    padding: 0.75rem 2rem;
    border-radius: 2px;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.btn-confirm:hover {
    background: linear-gradient(135deg, #17a2b8 0%, #138496 100%);
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(32, 178, 170, 0.3);
}

.btn-confirm:active {
    transform: translateY(0);
}

.btn-confirm.loading {
    pointer-events: none;
}

.btn-confirm.loading .btn-text {
    display: none;
}

.btn-confirm.loading .btn-spinner {
    display: inline-block !important;
}

/* تحسين scrollbar للعناصر */
.items-preview-modern::-webkit-scrollbar {
    width: 6px;
}

.items-preview-modern::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 2px;
}

.items-preview-modern::-webkit-scrollbar-thumb {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    border-radius: 2px;
}

/* تأثيرات الحركة للعناصر */
.item-modern {
    animation: itemSlideIn 0.3s ease-out;
}

@keyframes itemSlideIn {
    from {
        opacity: 0;
        transform: translateX(20px);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

/* تحسين الاستجابة للأجهزة المحمولة */
@media (max-width: 768px) {
    .save-confirm-modal .modal-dialog {
        margin: 1rem;
        max-width: calc(100% - 2rem);
    }
    
    .save-confirm-header {
        padding: 1.5rem 1.5rem 1rem;
    }
    
    .save-confirm-body {
        padding: 1.5rem;
    }
    
    .info-cards-grid {
        grid-template-columns: 1fr;
        gap: 0.75rem;
    }
    
    .header-content {
        margin-right: 70px;
    }
    
    .modal-title {
        font-size: 1.25rem;
    }
    
    .save-confirm-footer {
        padding: 1rem 1.5rem;
        flex-direction: column-reverse;
        gap: 0.75rem;
    }
    
    .btn-cancel,
    .btn-confirm {
        width: 100%;
        justify-content: center;
    }
}

/* أنماط نافذة إضافة الملاحظة */
.add-note-modal {
    border: none;
    border-radius: 2px;
    box-shadow: 0 15px 50px rgba(0, 0, 0, 0.2);
    overflow: hidden;
    animation: modalSlideIn 0.3s ease-out;
}

.add-note-header {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    border: none;
    padding: 1.5rem 2rem 1rem;
    color: white;
    position: relative;
    overflow: hidden;
}

.add-note-header::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -50%;
    width: 200%;
    height: 200%;
    background: linear-gradient(45deg, transparent 40%, rgba(255, 255, 255, 0.1) 50%, transparent 60%);
    animation: shimmer 2s infinite;
}

.add-note-body {
    padding: 2rem;
    background: linear-gradient(145deg, #fef7ff 0%, #ffffff 100%);
}

.note-input-section {
    position: relative;
}

.input-icon-wrapper {
    position: relative;
}

.input-icon {
    position: absolute;
    top: 1rem;
    right: 1rem;
    color: #6c757d;
    font-size: 1.1rem;
    z-index: 10;
}

.note-textarea {
    border: 2px solid #e9ecef;
    border-radius: 2px;
    padding: 1rem 3rem 1rem 1rem;
    font-size: 1rem;
    line-height: 1.5;
    resize: vertical;
    min-height: 120px;
    transition: all 0.3s ease;
    font-family: inherit;
}

.note-textarea:focus {
    border-color: #20b2aa;
    box-shadow: 0 0 0 0.2rem rgba(32, 178, 170, 0.25);
    background: #fefefe;
}

.note-textarea::placeholder {
    color: #adb5bd;
    font-style: italic;
}

.character-counter {
    text-align: left;
    margin-top: 0.5rem;
    font-size: 0.85rem;
    color: #6c757d;
}

.character-counter.warning {
    color: #fd7e14;
}

.character-counter.danger {
    color: #dc3545;
}

.quick-notes-section .section-title {
    color: #495057;
    font-weight: 600;
    display: flex;
    align-items: center;
}

.quick-notes-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
    gap: 0.75rem;
}

.quick-note-btn {
    background: white;
    border: 2px solid #dee2e6;
    border-radius: 2px;
    padding: 0.75rem 1rem;
    font-size: 0.9rem;
    color: #495057;
    transition: all 0.3s ease;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    text-align: center;
    font-weight: 500;
}

.quick-note-btn:hover {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    border-color: #20b2aa;
    color: white;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(32, 178, 170, 0.3);
}

.quick-note-btn:active {
    transform: translateY(0);
}

.current-note-section .section-title {
    color: #495057;
    font-weight: 600;
    display: flex;
    align-items: center;
}

.current-note-display {
    background: #f8f9fa;
    border: 1px solid #dee2e6;
    border-radius: 2px;
    padding: 1rem;
    font-style: italic;
    color: #6c757d;
    min-height: 60px;
    white-space: pre-wrap;
    line-height: 1.5;
}

.add-note-footer {
    background: #f8f9fa;
    border: none;
    padding: 1.5rem 2rem;
    display: flex;
    gap: 1rem;
    justify-content: flex-end;
}

.add-note-footer .btn {
    border-radius: 2px;
    font-weight: 500;
    padding: 0.6rem 1.5rem;
    transition: all 0.3s ease;
}

.add-note-footer .btn-cancel {
    border: 2px solid #dee2e6;
    color: #6c757d;
}

.add-note-footer .btn-cancel:hover {
    background: #6c757d;
    color: white;
    border-color: #6c757d;
    transform: translateY(-1px);
}

.add-note-footer .btn-clear {
    border: 2px solid #fd7e14;
    color: #fd7e14;
}

.add-note-footer .btn-clear:hover {
    background: #fd7e14;
    color: white;
    border-color: #fd7e14;
    transform: translateY(-1px);
}

.add-note-footer .btn-save-note {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    border: none;
    color: white;
}

.add-note-footer .btn-save-note:hover {
    background: linear-gradient(135deg, #17a2b8 0%, #138496 100%);
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(32, 178, 170, 0.3);
}

/* تحسين الاستجابة للأجهزة المحمولة للملاحظات */
@media (max-width: 768px) {
    .add-note-modal .modal-dialog {
        margin: 1rem;
        max-width: calc(100% - 2rem);
    }
    
    .add-note-header {
        padding: 1.25rem 1.5rem 0.75rem;
    }
    
    .add-note-body {
        padding: 1.5rem;
    }
    
    .quick-notes-grid {
        grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
        gap: 0.5rem;
    }
    
    .quick-note-btn {
        padding: 0.6rem 0.75rem;
        font-size: 0.85rem;
    }
    
    .add-note-footer {
        padding: 1rem 1.5rem;
        flex-direction: column-reverse;
        gap: 0.75rem;
    }
    
    .add-note-footer .btn {
        width: 100%;
        justify-content: center;
    }
}

/* تأثيرات إضافية للملاحظات */
@keyframes noteSlideIn {
    from {
        opacity: 0;
        transform: translateY(10px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.current-note-section {
    animation: noteSlideIn 0.3s ease-out;
}

/* Calculator Modal Styles */
.calculator-modal {
    border: none;
    border-radius: 2px;
    box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
    overflow: hidden;
    animation: modalSlideIn 0.4s ease-out;
}

.calculator-header {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    border: none;
    padding: 2rem 2rem 1.5rem;
    color: white;
    position: relative;
    overflow: hidden;
}

.calculator-header::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -50%;
    width: 200%;
    height: 200%;
    background: linear-gradient(45deg, transparent 40%, rgba(255, 255, 255, 0.1) 50%, transparent 60%);
    animation: shimmer 3s infinite;
}

.calculator-body {
    padding: 2rem;
    background: linear-gradient(145deg, #f8f9ff 0%, #ffffff 100%);
    min-height: 500px;
}

.calculator-display-container {
    background: #1a1a1a;
    border-radius: 2px;
    padding: 1.5rem;
    margin-bottom: 1.5rem;
    box-shadow: inset 0 4px 15px rgba(0, 0, 0, 0.3);
    position: relative;
    overflow: hidden;
}

.calculator-display-container::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 2px;
    background: linear-gradient(90deg, #20b2aa, #17a2b8, #20b2aa);
    animation: displayGlow 2s ease-in-out infinite alternate;
}

@keyframes displayGlow {
    0% { opacity: 0.5; }
    100% { opacity: 1; }
}

.calculator-history {
    color: #888;
    font-size: 0.9rem;
    font-family: 'Courier New', monospace;
    min-height: 20px;
    text-align: left;
    margin-bottom: 0.5rem;
    direction: ltr;
}

.calculator-display {
    color: #20b2aa;
    font-size: 2.5rem;
    font-family: 'Courier New', monospace;
    font-weight: bold;
    text-align: left;
    direction: ltr;
    text-shadow: 0 0 10px rgba(32, 178, 170, 0.5);
    transition: all 0.3s ease;
    min-height: 60px;
    display: flex;
    align-items: center;
    overflow-x: auto;
    white-space: nowrap;
}

.calculator-operation {
    color: #ffa500;
    font-size: 1.2rem;
    font-family: 'Courier New', monospace;
    text-align: left;
    direction: ltr;
    margin-top: 0.5rem;
    min-height: 20px;
}

.calculator-grid {
    display: flex;
    flex-direction: column;
    gap: 10px;
}

.calculator-row {
    display: grid;
    grid-template-columns: repeat(4, 1fr);
    gap: 10px;
}

.calculator-row.memory-functions {
    grid-template-columns: repeat(5, 1fr);
    margin-bottom: 15px;
}

.calculator-row.scientific-functions {
    grid-template-columns: repeat(5, 1fr);
}

.calculator-row:last-child {
    grid-template-columns: 2fr 1fr 1fr;
}

.calc-btn {
    height: 60px;
    border: none;
    border-radius: 2px;
    font-size: 1.2rem;
    font-weight: 600;
    transition: all 0.2s ease;
    position: relative;
    overflow: hidden;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
}

.calc-btn::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
    transition: left 0.5s ease;
}

.calc-btn:hover::before {
    left: 100%;
}

.calc-btn:active {
    transform: scale(0.95);
}

.number-btn {
    background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
    color: #2d3436;
    border: 2px solid #e9ecef;
}

.number-btn:hover {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border-color: #20b2aa;
    color: #20b2aa;
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(32, 178, 170, 0.2);
}

.operation-btn {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    color: white;
    border: none;
}

.operation-btn:hover {
    background: linear-gradient(135deg, #17a2b8 0%, #138496 100%);
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(32, 178, 170, 0.4);
}

.equals-btn {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    color: white;
    border: none;
    font-size: 1.5rem;
}

.equals-btn:hover {
    background: linear-gradient(135deg, #17a2b8 0%, #138496 100%);
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(32, 178, 170, 0.4);
}

.clear-btn {
    background: linear-gradient(135deg, #fd7e14 0%, #e8590c 100%);
    color: white;
    border: none;
}

.clear-btn:hover {
    background: linear-gradient(135deg, #e8590c 0%, #d63384 100%);
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(253, 126, 20, 0.4);
}

.memory-btn {
    background: linear-gradient(135deg, #6f42c1 0%, #563d7c 100%);
    color: white;
    border: none;
    font-size: 0.9rem;
    height: 45px;
}

.memory-btn:hover {
    background: linear-gradient(135deg, #563d7c 0%, #4c366d 100%);
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(111, 66, 193, 0.4);
}

.function-btn {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    color: white;
    border: none;
    font-size: 0.9rem;
    height: 45px;
}

.function-btn:hover {
    background: linear-gradient(135deg, #17a2b8 0%, #138496 100%);
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(32, 178, 170, 0.4);
}

.zero-btn {
    grid-column: span 2;
}

.calculator-quick-actions .btn {
    border-radius: 2px;
    font-weight: 500;
    padding: 0.75rem 1rem;
    transition: all 0.3s ease;
}

.calculator-quick-actions .btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
}

.calculator-footer {
    background: #f8f9fa;
    border: none;
    padding: 1.5rem 2rem;
    display: flex;
    gap: 1rem;
    justify-content: flex-end;
}

.calculator-footer .btn {
    border-radius: 2px;
    font-weight: 500;
    padding: 0.75rem 1.5rem;
    transition: all 0.3s ease;
}

.calculator-footer .btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.15);
}

/* Memory indicator */
.memory-indicator {
    position: absolute;
    top: 10px;
    right: 10px;
    background: #ff6b6b;
    color: white;
    padding: 2px 8px;
    border-radius: 2px;
    font-size: 0.7rem;
    font-weight: bold;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.memory-indicator.active {
    opacity: 1;
}

/* Responsive Design */
@media (max-width: 768px) {
    .calculator-modal .modal-dialog {
        margin: 1rem;
        max-width: calc(100% - 2rem);
    }
    
    .calculator-header {
        padding: 1.5rem 1.5rem 1rem;
    }
    
    .calculator-body {
        padding: 1.5rem;
    }
    
    .calculator-display {
        font-size: 2rem;
    }
    
    .calc-btn {
        height: 50px;
        font-size: 1rem;
    }
    
    .memory-btn,
    .function-btn {
        height: 40px;
        font-size: 0.8rem;
    }
    
    .calculator-row.memory-functions,
    .calculator-row.scientific-functions {
        grid-template-columns: repeat(5, 1fr);
        gap: 5px;
    }
    
    .calculator-grid {
        gap: 8px;
    }
    
    .calculator-row {
        gap: 8px;
    }
    
    .calculator-footer {
        padding: 1rem 1.5rem;
        flex-direction: column-reverse;
        gap: 0.75rem;
    }
    
    .calculator-footer .btn {
        width: 100%;
        justify-content: center;
    }
}

/* Animation for button press */
@keyframes buttonPress {
    0% { transform: scale(1); }
    50% { transform: scale(0.95); }
    100% { transform: scale(1); }
}

.calc-btn.pressed {
    animation: buttonPress 0.1s ease;
}

/* Error state */
.calculator-display.error {
    color: #dc3545;
    text-shadow: 0 0 10px rgba(220, 53, 69, 0.5);
}

/* Additional Turquoise Theme Enhancements */
.btn-primary {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%) !important;
    border: none !important;
}

.btn-primary:hover {
    background: linear-gradient(135deg, #17a2b8 0%, #138496 100%) !important;
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(32, 178, 170, 0.3);
}

.btn-success {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%) !important;
    border: none !important;
}

.btn-success:hover {
    background: linear-gradient(135deg, #17a2b8 0%, #138496 100%) !important;
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(32, 178, 170, 0.3);
}

.btn-info {
    background: linear-gradient(135deg, #17a2b8 0%, #138496 100%) !important;
    border: none !important;
}

.btn-info:hover {
    background: linear-gradient(135deg, #138496 0%, #117a8b 100%) !important;
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(23, 162, 184, 0.3);
}

.text-primary {
    color: #20b2aa !important;
}

.bg-primary {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%) !important;
}

.border-primary {
    border-color: #20b2aa !important;
}

/* Enhanced hover effects for interactive elements */
.product-card:hover .product-name {
    color: #20b2aa;
    transition: color 0.3s ease;
}

.order-item:hover {
    background: linear-gradient(90deg, transparent 0%, rgba(32, 178, 170, 0.05) 100%);
    border-radius: 2px;
    padding: 15px;
    margin: 0 -15px;
}

/* Loading spinner with turquoise color */
.fa-spinner {
    color: #20b2aa;
}

/* Enhanced focus states */
input:focus, select:focus, textarea:focus {
    border-color: #20b2aa !important;
    box-shadow: 0 0 0 0.2rem rgba(32, 178, 170, 0.25) !important;
}

/* Custom scrollbar for webkit browsers */
::-webkit-scrollbar {
    width: 8px;
    height: 8px;
}

::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 2px;
}

::-webkit-scrollbar-thumb {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    border-radius: 2px;
}

::-webkit-scrollbar-thumb:hover {
    background: linear-gradient(135deg, #17a2b8 0%, #138496 100%);
}

/* Enhanced animation for success states */
@keyframes successPulse {
    0% { transform: scale(1); }
    50% { transform: scale(1.05); }
    100% { transform: scale(1); }
}

.success-animation {
    animation: successPulse 0.6s ease-in-out;
}

/* Simplified Mobile-First Responsive Design */

@media (max-width: 1200px) {
    .category-tabs .btn {
        padding: 10px 16px;
        font-size: 0.85rem;
        min-width: 100px;
    }
    
    .products-grid {
        grid-template-columns: repeat(auto-fill, minmax(180px, 1fr));
        gap: 12px;
    }
}

@media (max-width: 768px) {
    .category-tabs {
        padding: 10px;
        margin-bottom: 15px;
    }
    
    .category-tabs .btn {
        padding: 10px 14px;
        font-size: 0.8rem;
        min-width: 90px;
        flex: 1 1 auto;
    }
    
    .products-grid {
        grid-template-columns: repeat(auto-fill, minmax(140px, 1fr));
        gap: 8px;
    }
    
    .product-card {
        min-height: 180px;
    }
}

@media (max-width: 576px) {
    .category-tabs .btn {
        padding: 8px 12px;
        font-size: 0.75rem;
        min-width: 80px;
        flex: 1 1 calc(50% - 4px);
        max-width: none;
    }
    
    .category-tabs .btn-group {
        gap: 4px;
    }
    
    .products-grid {
        grid-template-columns: repeat(auto-fill, minmax(130px, 1fr));
        gap: 6px;
    }
}

@media (max-width: 360px) {
    .category-tabs .btn {
        padding: 6px 10px;
        font-size: 0.7rem;
        min-width: 70px;
        flex: 1 1 calc(33.333% - 3px);
    }
    
    /* إخفاء الأيقونات في الشاشات الصغيرة جداً */
    .category-tab i {
        display: none;
    }
    
    .products-grid {
        grid-template-columns: repeat(auto-fill, minmax(110px, 1fr));
        gap: 4px;
    }
}

/* تحسين للأجهزة التي تدعم اللمس */
@media (pointer: coarse) {
    .category-tab {
        min-height: 44px; /* iOS minimum touch target */
    }
    
    .category-tab:active {
        transform: scale(0.98);
        transition: transform 0.1s ease;
    }
}

/* أنماط ملخص المبالغ المضغوط في الهيدر */
.order-totals-compact {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border: 2px solid #20b2aa;
    border-radius: 12px;
    padding: 10px 15px;
    box-shadow: 0 2px 8px rgba(32, 178, 170, 0.15);
}

.total-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    text-align: center;
    min-width: 100px;
}

.total-item small {
    font-size: 0.75rem;
    margin-bottom: 2px;
    font-weight: 500;
}

.total-item .fw-bold {
    font-size: 0.9rem;
    line-height: 1.2;
}

.total-item-main {
    display: flex;
    flex-direction: column;
    align-items: center;
    text-align: center;
    min-width: 120px;
    padding: 0 10px;
    border-right: 2px solid #20b2aa;
}

.total-item-main small {
    font-size: 0.75rem;
    margin-bottom: 2px;
    font-weight: 500;
}

.total-item-main .fw-bold {
    font-size: 1.1rem;
    line-height: 1.2;
}

/* تحسين مظهر الفاصل العمودي */
.vr {
    border: none;
    width: 2px;
    background: linear-gradient(to bottom, transparent, #20b2aa, transparent);
}

/* تحسين للأجهزة المحمولة */
@media (max-width: 992px) {
    .order-totals-compact .d-flex {
        flex-wrap: wrap;
        gap: 15px !important;
    }
    
    .total-item,
    .total-item-main {
        min-width: auto;
        flex: 1;
    }
    
    .total-item-main {
        border-right: none;
        border-top: 2px solid #20b2aa;
        padding-top: 10px;
        width: 100%;
    }
    
    .vr {
        display: none;
    }
}

@media (max-width: 768px) {
    .page-actions .d-flex {
        flex-direction: column;
        gap: 15px;
    }
    
    .order-totals-compact {
        width: 100%;
        order: -1;
    }
}

/* Add Product Modal Styles */
.add-product-modal {
    border: none;
    border-radius: 15px;
    box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
    overflow: hidden;
    animation: modalSlideIn 0.4s ease-out;
}

.add-product-header {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    border: none;
    padding: 2rem 2rem 1.5rem;
    color: white;
    position: relative;
    overflow: hidden;
}

.add-product-header::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -50%;
    width: 200%;
    height: 200%;
    background: linear-gradient(45deg, transparent 40%, rgba(255, 255, 255, 0.1) 50%, transparent 60%);
    animation: shimmer 3s infinite;
}

.add-product-body {
    padding: 2rem;
    background: linear-gradient(145deg, #f8f9ff 0%, #ffffff 100%);
}

.form-label.required::after {
    content: ' *';
    color: #dc3545;
    font-weight: bold;
}

.input-with-icon .input-group-text {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    border: none;
    color: white;
    font-weight: 600;
}

.input-with-icon .form-control,
.input-with-icon .form-select {
    border: 2px solid #e9ecef;
    border-radius: 0 8px 8px 0;
    padding: 12px 16px;
    font-size: 1rem;
    transition: all 0.3s ease;
}

.input-with-icon .form-control:focus,
.input-with-icon .form-select:focus {
    border-color: #20b2aa;
    box-shadow: 0 0 0 0.2rem rgba(32, 178, 170, 0.25);
    background: #fefefe;
}

.character-counter {
    text-align: left;
    margin-top: 0.25rem;
    font-size: 0.8rem;
    color: #6c757d;
}

/* Image Upload Section */
.image-upload-section {
    background: #f8f9fa;
    border: 2px dashed #dee2e6;
    border-radius: 12px;
    padding: 1.5rem;
    transition: all 0.3s ease;
}

.image-upload-section:hover {
    border-color: #20b2aa;
    background: #f0fffe;
}

.image-preview-container {
    position: relative;
    width: 150px;
    height: 150px;
    margin: 0 auto 1rem;
    border-radius: 12px;
    overflow: hidden;
    background: white;
    border: 2px solid #e9ecef;
}

.image-placeholder {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    height: 100%;
    text-align: center;
    padding: 1rem;
}

.image-preview {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* Product Preview Section */
.product-preview-section {
    background: linear-gradient(135deg, #e3f2fd 0%, #f3e5f5 100%);
    border-radius: 12px;
    padding: 1.5rem;
    border: 2px solid #20b2aa;
    animation: fadeIn 0.3s ease;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}

.product-preview-card {
    background: white;
    border-radius: 8px;
    padding: 1rem;
    display: flex;
    align-items: center;
    gap: 1rem;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.preview-image {
    width: 60px;
    height: 60px;
    border-radius: 8px;
    overflow: hidden;
    background: #f8f9fa;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
}

.preview-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.preview-placeholder {
    color: #20b2aa;
    font-size: 1.5rem;
}

.preview-info {
    flex: 1;
}

.preview-name {
    margin: 0 0 0.5rem 0;
    font-weight: 600;
    color: #2d3436;
}

.preview-price {
    margin: 0 0 0.25rem 0;
    font-weight: 700;
    color: #20b2aa;
    font-size: 1.1rem;
}

.preview-code {
    margin: 0;
    font-size: 0.85rem;
}

.section-title {
    color: #495057;
    font-weight: 600;
    display: flex;
    align-items: center;
}

/* Footer Styles */
.add-product-footer {
    background: #f8f9fa;
    border: none;
    padding: 1.5rem 2rem;
    display: flex;
    gap: 1rem;
    justify-content: flex-end;
}

.add-product-footer .btn {
    border-radius: 8px;
    font-weight: 500;
    padding: 0.75rem 1.5rem;
    transition: all 0.3s ease;
}

.btn-preview {
    border: 2px solid #17a2b8;
    color: #17a2b8;
    background: transparent;
}

.btn-preview:hover {
    background: #17a2b8;
    color: white;
    border-color: #17a2b8;
    transform: translateY(-1px);
}

.btn-save-product {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
    border: none;
    color: white;
}

.btn-save-product:hover {
    background: linear-gradient(135deg, #17a2b8 0%, #138496 100%);
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(32, 178, 170, 0.3);
}

/* Responsive Design for Add Product Modal */
@media (max-width: 768px) {
    .add-product-modal .modal-dialog {
        margin: 1rem;
        max-width: calc(100% - 2rem);
    }
    
    .add-product-header {
        padding: 1.5rem 1.5rem 1rem;
    }
    
    .add-product-body {
        padding: 1.5rem;
    }
    
    .image-preview-container {
        width: 120px;
        height: 120px;
    }
    
    .add-product-footer {
        padding: 1rem 1.5rem;
        flex-direction: column-reverse;
        gap: 0.75rem;
    }
    
    .add-product-footer .btn {
        width: 100%;
        justify-content: center;
    }
}
</style>
@endpush

@push('scripts')
<script>
// Restaurant POS JavaScript with Enhanced Debugging
console.log('🚀 Starting Restaurant POS JavaScript initialization...');

// Define critical functions immediately to prevent ReferenceError
window.openCalculator = function() {
    try {
        $('#calculatorModal').modal('show');
        if (typeof updateCalculatorDisplay === 'function') {
            updateCalculatorDisplay();
        }
        console.log('✅ Calculator modal opened successfully');
    } catch (error) {
        console.error('❌ Error opening calculator:', error);
        alert('حدث خطأ في فتح الآلة الحاسبة');
    }
};

let itemIndex = 0;
let orderItems = []; // تهيئة مصفوفة العناصر
let currentCategory = 'all';

// Global error handling
window.addEventListener('error', function(e) {
    console.error('🚨 JavaScript Error:', e.error);
    console.error('🚨 Error message:', e.message);
    console.error('🚨 Error source:', e.filename + ':' + e.lineno);
});

// Add debugging for all clicks on the page
document.addEventListener('click', function(e) {
    console.log('🖱️ Global click detected:', {
        target: e.target,
        tagName: e.target.tagName,
        className: e.target.className,
        id: e.target.id,
        isProductCard: e.target.closest('.product-card') ? true : false
    });
}, true);

// التأكد من تهيئة المصفوفة عند تحميل الصفحة
function initializeOrderItems() {
    if (!orderItems) {
        orderItems = [];
        console.log('OrderItems array initialized');
    }
    return orderItems;
}

// تهيئة الصفحة عند التحميل
document.addEventListener('DOMContentLoaded', function() {
    console.log('📱 DOM Content Loaded - Starting initialization...');
    
    // تهيئة مصفوفة العناصر أولاً
    initializeOrderItems();
    
    initializeEventListeners();
    updateOrderDisplay();
    
    // Test if addProductToOrder function is available
    console.log('🔧 Testing addProductToOrder function availability:', typeof addProductToOrder);
    
    if (typeof addProductToOrder !== 'function') {
        console.error('❌ addProductToOrder function is not defined!');
    } else {
        console.log('✅ addProductToOrder function is available');
        // Make it globally accessible
        window.addProductToOrder = addProductToOrder;
    }
    
    // التحقق من وجود المنتجات وإضافة debugging شامل
    setTimeout(function() {
        const productCards = document.querySelectorAll('.product-card');
        console.log('🔍 Found', productCards.length, 'product cards');
        
        if (productCards.length === 0) {
            console.warn('⚠️ No product cards found! Check if products are being loaded from the database.');
        } else {
            console.log('✅ Product cards found:', productCards);
            
            // فحص كل منتج
            productCards.forEach((card, index) => {
                console.log(`📦 Product ${index + 1}:`, {
                    element: card,
                    dataset: card.dataset,
                    productData: card.dataset.product,
                    onclick: card.getAttribute('onclick'),
                    classes: card.className
                });
                
                // اختبار النقر على المنتج الأول
                if (index === 0) {
                    console.log('🧪 Testing click on first product...');
                    // محاولة محاكاة النقر
                    card.addEventListener('click', function(e) {
                        console.log('🎯 First product clicked successfully!');
                    });
                }
            });
        }
        
        // التحقق من حالة orderItems
        console.log('📊 Initial orderItems state:', orderItems);
        
        // اختبار وجود الدالة
        console.log('🔧 addProductToOrder function exists:', typeof addProductToOrder);
        console.log('🔧 Window object contains addProductToOrder:', 'addProductToOrder' in window);
        
        // جعل الدالة متاحة عالمياً للتأكد
        window.addProductToOrder = addProductToOrder;
        console.log('🌐 addProductToOrder made globally available');
        
        // HTML onclick attributes are sufficient for product cards
        console.log('✅ Product cards already have HTML onclick handlers - no additional listeners needed');
    }, 100);
    
    // إضافة دوال مساعدة للتطوير والاختبار
    setupProductCards();
    setupTestFeatures();
    
    // التحقق من نجاح الحفظ وعرض modal الطباعة
    @if(session('invoice_saved') && session('invoice_data'))
        window.invoiceSaved = true;
        window.newInvoiceId = {{ session('invoice_data')['id'] }};
        window.newInvoiceNumber = '{{ session('invoice_data')['invoice_number'] }}';
        window.newInvoiceTotal = {{ session('invoice_data')['total_amount'] }};
        window.newInvoicePaid = {{ session('invoice_data')['paid_amount'] }};
        window.newInvoicePaymentStatus = '{{ session('invoice_data')['payment_status'] }}';
        window.newInvoiceItemsCount = {{ session('invoice_data')['items_count'] ?? 0 }};
        window.newInvoiceCustomer = '{{ session('invoice_data')['customer_name'] ?? "غير محدد" }}';
        
        // إخفاء مؤشرات التحميل
        setTimeout(function() {
            hideSaveStatus();
        }, 100);
        
        // عرض رسالة نجاح مفصلة
        setTimeout(function() {
            showNotification(
                `تم حفظ الفاتورة ${window.newInvoiceNumber} بنجاح!\n` +
                `العميل: ${window.newInvoiceCustomer}\n` +
                `عدد العناصر: ${window.newInvoiceItemsCount}\n` +
                `المبلغ: ${window.newInvoiceTotal.toFixed(2)} ر.س`,
                'success'
            );
        }, 300);
        
        // عرض modal الطباعة بعد تحميل الصفحة
        setTimeout(function() {
            showPrintModal({
                id: window.newInvoiceId,
                invoice_number: window.newInvoiceNumber,
                total_amount: window.newInvoiceTotal,
                paid_amount: window.newInvoicePaid,
                payment_status: window.newInvoicePaymentStatus
            });
        }, 100);
    @endif
});

// دالة إعداد المنتجات والتحقق من حالتها
function setupProductCards() {
    console.log('🔧 Setting up product cards...');
    
    const productCards = document.querySelectorAll('.product-card');
    if (productCards.length === 0) {
        console.warn('⚠️ No product cards found during setup');
        return;
    }
    
    // التحقق من كل منتج وإضافة معلومات debugging
    productCards.forEach((card, index) => {
        const productData = card.dataset.product;
        if (productData) {
            try {
                const product = JSON.parse(productData);
                console.log(`📦 Product ${index + 1} setup:`, {
                    id: product.id,
                    name: product.name,
                    price: product.price,
                    stock: product.stock_quantity,
                    type: product.type
                });
                
                // إضافة tooltip للمنتج
                card.title = `${product.name} - ${product.price} ر.س`;
                
                // إضافة معرف فريد للمنتج
                card.setAttribute('data-product-id', product.id);
                
            } catch (e) {
                console.error(`❌ Failed to parse product ${index + 1} data:`, e);
            }
        }
    });
    
    console.log('✅ Product cards setup complete');
}

// إضافة زر اختبار للمطورين
function addTestButton() {
    console.log('🧪 Adding test button for developers...');
    
    // التحقق من عدم وجود الزر مسبقاً
    if (document.getElementById('developer-test-btn')) {
        return;
    }
    
    // إنشاء زر الاختبار
    const testButton = document.createElement('button');
    testButton.id = 'developer-test-btn';
    testButton.type = 'button';
    testButton.className = 'btn btn-warning btn-sm position-fixed';
    testButton.style.cssText = `
        bottom: 20px;
        left: 20px;
        z-index: 9999;
        border-radius: 50px;
        padding: 10px 15px;
        box-shadow: 0 4px 12px rgba(255, 193, 7, 0.3);
        font-size: 0.8rem;
        font-weight: 600;
    `;
    testButton.innerHTML = '<i class="fas fa-bug me-1"></i>اختبار';
    testButton.title = 'أدوات اختبار للمطورين';
    
    // إضافة حدث النقر
    testButton.addEventListener('click', function() {
        showDeveloperTestModal();
    });
    
    // إضافة الزر للصفحة
    document.body.appendChild(testButton);
    
    console.log('✅ Developer test button added successfully');
}

// عرض نافذة أدوات الاختبار للمطورين
function showDeveloperTestModal() {
    const testModal = document.createElement('div');
    testModal.className = 'modal fade';
    testModal.id = 'developerTestModal';
    testModal.innerHTML = `
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header bg-warning text-dark">
                    <h5 class="modal-title">
                        <i class="fas fa-tools me-2"></i>
                        أدوات اختبار المطورين
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card mb-3">
                                <div class="card-header">
                                    <h6 class="mb-0">اختبار المنتجات</h6>
                                </div>
                                <div class="card-body">
                                    <button class="btn btn-sm btn-primary w-100 mb-2" onclick="testAddProduct()">
                                        إضافة منتج تجريبي
                                    </button>
                                    <button class="btn btn-sm btn-info w-100 mb-2" onclick="testFillOrder()">
                                        ملء طلب تجريبي
                                    </button>
                                    <button class="btn btn-sm btn-secondary w-100" onclick="testClearOrder()">
                                        مسح الطلب
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card mb-3">
                                <div class="card-header">
                                    <h6 class="mb-0">معلومات النظام</h6>
                                </div>
                                <div class="card-body">
                                    <small class="text-muted">عدد العناصر الحالي:</small>
                                    <div class="fw-bold">${orderItems ? orderItems.length : 0}</div>
                                    <small class="text-muted mt-2">عدد المنتجات المتاحة:</small>
                                    <div class="fw-bold">${document.querySelectorAll('.product-card').length}</div>
                                    <small class="text-muted mt-2">الإجمالي الحالي:</small>
                                    <div class="fw-bold text-success">${document.getElementById('total-display')?.textContent || '0.00 ر.س'}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header">
                            <h6 class="mb-0">سجل وحدة التحكم</h6>
                        </div>
                        <div class="card-body">
                            <div id="console-log" style="background: #1a1a1a; color: #00ff00; padding: 10px; border-radius: 5px; font-family: monospace; font-size: 0.8rem; max-height: 200px; overflow-y: auto;">
                                مرحباً بك في أدوات اختبار المطورين!<br>
                                استخدم الأزرار أعلاه لاختبار الوظائف المختلفة.
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                    <button type="button" class="btn btn-info" onclick="window.POS_DEBUG && console.log(window.POS_DEBUG)">
                        <i class="fas fa-terminal me-1"></i>
                        عرض كائن التطوير
                    </button>
                </div>
            </div>
        </div>
    `;
    
    document.body.appendChild(testModal);
    $(testModal).modal('show');
    
    // حذف النافذة عند الإغلاق
    $(testModal).on('hidden.bs.modal', function() {
        testModal.remove();
    });
}

// دوال اختبار المطورين
function testAddProduct() {
    const testProduct = {
        id: 9999,
        name: 'منتج اختبار ' + Date.now(),
        price: (Math.random() * 50 + 10).toFixed(2),
        type: 'service',
        account_id: 1,
        stock_quantity: 100
    };
    
    const mockCard = document.createElement('div');
    mockCard.dataset.product = JSON.stringify(testProduct);
    
    if (typeof addProductToOrder === 'function') {
        addProductToOrder(mockCard);
        logToConsole(`✅ تم إضافة منتج اختبار: ${testProduct.name} - ${testProduct.price} ر.س`);
    } else {
        logToConsole('❌ خطأ: دالة addProductToOrder غير متاحة');
    }
}

function testFillOrder() {
    const testProducts = [
        { id: 9991, name: 'برجر كلاسيك', price: '35.00', type: 'product', account_id: 1 },
        { id: 9992, name: 'بيتزا مارجريتا', price: '45.00', type: 'product', account_id: 1 },
        { id: 9993, name: 'عصير برتقال', price: '15.00', type: 'product', account_id: 1 }
    ];
    
    testProducts.forEach(product => {
        const mockCard = document.createElement('div');
        mockCard.dataset.product = JSON.stringify(product);
        
        if (typeof addProductToOrder === 'function') {
            addProductToOrder(mockCard);
        }
    });
    
    logToConsole(`✅ تم إضافة ${testProducts.length} منتجات تجريبية للطلب`);
}

function testClearOrder() {
    if (typeof window.POS_DEBUG?.clearOrder === 'function') {
        window.POS_DEBUG.clearOrder();
        logToConsole('✅ تم مسح الطلب التجريبي');
    } else {
        orderItems = [];
        updateOrderDisplay();
        calculateTotals();
        logToConsole('✅ تم مسح الطلب يدوياً');
    }
}

function logToConsole(message) {
    console.log(message);
    const consoleElement = document.getElementById('console-log');
    if (consoleElement) {
        consoleElement.innerHTML += '<br>' + message;
        consoleElement.scrollTop = consoleElement.scrollHeight;
    }
}

// إعداد ميزات التطوير والاختبار
function setupTestFeatures() {
    console.log('🧪 Setting up test features...');
    
    // إضافة زر اختبار (للمطورين فقط)
    if (window.location.hostname === 'localhost' || window.location.hostname.includes('127.0.0.1')) {
        addTestButton();
    }
    
    // إضافة console commands للمطورين
    window.POS_DEBUG = {
        getOrderItems: () => orderItems,
        addTestProduct: () => {
            const testProduct = {
                id: 999,
                name: 'منتج تجريبي',
                price: 25.00,
                type: 'service',
                account_id: 1
            };
            
            const mockCard = document.createElement('div');
            mockCard.dataset.product = JSON.stringify(testProduct);
            addProductToOrder(mockCard);
        },
        clearOrder: () => {
            orderItems = [];
            updateOrderDisplay();
            calculateTotals();
        },
        validateFormTest: () => validateForm({ preventDefault: () => {} })
    };
    
    console.log('🎯 Debug tools available in window.POS_DEBUG');
}



// تهيئة مستمعي الأحداث
function initializeEventListeners() {
    // البحث في المنتجات
    document.getElementById('product-search').addEventListener('input', filterProducts);
    
    // تبويبات الفئات
    document.querySelectorAll('.category-tab').forEach(tab => {
        tab.addEventListener('click', function() {
            switchCategory(this.dataset.category);
        });
    });
    
    // تغيير نوع الطلب
    document.querySelector('select[name="order_type"]').addEventListener('change', handleOrderTypeChange);
    
    // حقل الخصم
    document.querySelector('input[name="discount_amount"]').addEventListener('input', calculateTotals);
    
    // HTML onclick attributes handle product clicks directly - no backup listener needed
    console.log('✅ Product cards use HTML onclick attributes - backup listener removed to prevent duplicates');
    
    // التحقق من النموذج قبل الإرسال
    document.getElementById('restaurant-pos-form').addEventListener('submit', function(e) {
        // تحديث الحقول المخفية أولاً قبل التحقق
        updateHiddenFormInputs();
        
        // التحقق من صحة النموذج
        if (!validateForm(e)) {
            return false;
        }
        
        // إضافة debug logging للنموذج
        console.log('Form submission started');
        console.log('Order items:', orderItems);
        console.log('Form action:', this.action);
        console.log('Form method:', this.method);
        
        // تسجيل جميع البيانات المرسلة
        const formData = new FormData(this);
        console.log('Form data:');
        for (let [key, value] of formData.entries()) {
            console.log(key + ': ' + value);
        }
    });
}

// إضافة منتج للطلب - نسخة محسنة ومطورة
function addProductToOrder(productCard) {
    console.log('🚀 addProductToOrder called with:', productCard);
    console.log('🔍 Product card type:', typeof productCard, productCard);
    
    try {
        // التحقق من صحة المدخلات
        if (!productCard) {
            console.error('❌ Product card is null or undefined');
            showNotification('خطأ: لم يتم العثور على بيانات المنتج', 'error');
            return false;
        }
        
        // التحقق من وجود البيانات
        if (!productCard.dataset || !productCard.dataset.product) {
            console.error('❌ Missing product data in dataset');
            console.error('Available dataset keys:', Object.keys(productCard.dataset || {}));
            console.error('Dataset content:', productCard.dataset);
            
            // محاولة استخراج البيانات من خصائص أخرى
            const productId = productCard.dataset.productId;
            const productName = productCard.dataset.productName;
            if (productId && productName) {
                console.log('🔄 Attempting to get product data from alternative attributes...');
                // يمكن إضافة منطق للحصول على بيانات المنتج من مصدر آخر هنا
            }
            
            showNotification(
                'خطأ في بيانات المنتج\n' +
                'تأكد من أن المنتجات محملة من قاعدة البيانات بشكل صحيح\n' +
                'أعد تحميل الصفحة وحاول مرة أخرى',
                'error'
            );
            return false;
        }
        
        // تحليل بيانات المنتج مع معالجة أفضل للأخطاء
        let product;
        try {
            const productJsonString = productCard.dataset.product;
            console.log('📄 Raw product JSON:', productJsonString.substring(0, 100) + '...');
            
            product = JSON.parse(productJsonString);
            console.log('✅ Product parsed successfully:', {
                id: product.id,
                name: product.name,
                price: product.price,
                type: product.type,
                stock_quantity: product.stock_quantity
            });
        } catch (parseError) {
            console.error('❌ Failed to parse product JSON:', parseError);
            console.error('❌ Raw JSON string:', productCard.dataset.product);
            showNotification(
                'خطأ في تحليل بيانات المنتج\n' +
                'هناك مشكلة في تنسيق بيانات المنتج\n' +
                'تواصل مع المطور لحل هذه المشكلة',
                'error'
            );
            return false;
        }
        
        // التحقق الشامل من صحة بيانات المنتج
        const validationErrors = [];
        
        if (!product || typeof product !== 'object') {
            validationErrors.push('بيانات المنتج غير صالحة');
        }
        
        if (!product.id || (typeof product.id !== 'number' && typeof product.id !== 'string')) {
            validationErrors.push('معرف المنتج مفقود أو غير صحيح');
        }
        
        if (!product.name || typeof product.name !== 'string' || product.name.trim() === '') {
            validationErrors.push('اسم المنتج مفقود أو غير صحيح');
        }
        
        if (typeof product.price === 'undefined' || product.price === null || isNaN(parseFloat(product.price))) {
            validationErrors.push('سعر المنتج مفقود أو غير صحيح');
        }
        
        if (validationErrors.length > 0) {
            console.error('❌ Product validation failed:', validationErrors);
            console.error('❌ Product data:', product);
            showNotification(
                'بيانات المنتج غير صحيحة:\n' + validationErrors.join('\n'),
                'error'
            );
            return false;
        }
        
        // التحقق من المخزون (إذا كان منتج مادي)
        if (product.type === 'product' && product.stock_quantity !== undefined && product.stock_quantity <= 0) {
            console.log('⚠️ Product out of stock:', product.name);
            showNotification(
                `المنتج "${product.name}" غير متوفر في المخزون\n` +
                'اختر منتج آخر أو تحقق من المخزون',
                'warning'
            );
            return false;
        }
        
        // تهيئة مصفوفة العناصر إذا لم تكن موجودة
        if (!Array.isArray(orderItems)) {
            orderItems = [];
            console.log('📦 Initialized orderItems array');
        }
        
        console.log('📋 Current order before adding:', orderItems);
        
        // البحث عن المنتج في الطلب الحالي
        const existingItemIndex = orderItems.findIndex(item =>
            item.product && item.product.id == product.id // استخدام == للمقارنة المرنة
        );
        
        if (existingItemIndex !== -1) {
            // زيادة الكمية للمنتج الموجود
            const previousQuantity = orderItems[existingItemIndex].quantity;
            orderItems[existingItemIndex].quantity += 1;
            
            console.log('➕ Increased quantity for existing item:', {
                product: orderItems[existingItemIndex].product.name,
                previousQuantity: previousQuantity,
                newQuantity: orderItems[existingItemIndex].quantity
            });
            
            showNotification(
                `تم زيادة كمية ${product.name} في الطلب\n` +
                `الكمية الحالية: ${orderItems[existingItemIndex].quantity}`,
                'success'
            );
        } else {
            // إضافة منتج جديد للطلب
            const newItem = {
                id: itemIndex++,
                product: {
                    id: product.id,
                    name: product.name,
                    price: parseFloat(product.price),
                    account_id: product.account_id,
                    type: product.type,
                    stock_quantity: product.stock_quantity
                },
                quantity: 1,
                unit_price: parseFloat(product.price),
                discount_amount: 0
            };
            
            orderItems.unshift(newItem);
            console.log('➕ Added new item to order:', newItem);
            
            showNotification(
                `تم إضافة ${product.name} للطلب\n` +
                `السعر: ${parseFloat(product.price).toFixed(2)} ر.س`,
                'success'
            );
        }
        
        console.log('📋 Updated order items:', {
            totalItems: orderItems.length,
            items: orderItems.map(item => ({
                name: item.product.name,
                quantity: item.quantity,
                price: item.unit_price
            }))
        });
        
        // تحديث العرض والحسابات
        updateOrderDisplay();
        calculateTotals();
        updateHiddenFormInputs();
        
        // تأثير بصري محسن للمنتج
        addVisualFeedback(productCard);
        
        console.log('✅ Product added successfully to order');
        return true;
        
    } catch (error) {
        console.error('❌ Unexpected error in addProductToOrder:', error);
        console.error('❌ Stack trace:', error.stack);
        console.error('❌ Product card details:', {
            element: productCard,
            tagName: productCard?.tagName,
            className: productCard?.className,
            dataset: productCard?.dataset
        });
        
        showNotification(
            'حدث خطأ غير متوقع أثناء إضافة المنتج\n' +
            'تفاصيل الخطأ: ' + error.message + '\n' +
            'حاول إعادة تحميل الصفحة',
            'error'
        );
        return false;
    }
}

// إضافة تأثير بصري محسن
function addVisualFeedback(productCard) {
    if (!productCard || !productCard.style) return;
    
    // حفظ القيم الأصلية
    const originalTransform = productCard.style.transform || '';
    const originalTransition = productCard.style.transition || '';
    const originalBoxShadow = productCard.style.boxShadow || '';
    
    // تطبيق التأثير
    productCard.style.transition = 'all 0.2s ease';
    productCard.style.transform = 'scale(0.95)';
    productCard.style.boxShadow = '0 0 20px rgba(0, 184, 148, 0.5)';
    
    setTimeout(() => {
        productCard.style.transform = 'scale(1.02)';
        setTimeout(() => {
            // استعادة القيم الأصلية
            productCard.style.transform = originalTransform;
            productCard.style.boxShadow = originalBoxShadow;
            setTimeout(() => {
                productCard.style.transition = originalTransition;
            }, 200);
        }, 150);
    }, 150);
}

// تحديث عرض الطلب
function updateOrderDisplay() {
    const orderItemsContainer = document.getElementById('order-items');
    const itemsCount = document.getElementById('items-count');
    
    if (orderItems.length === 0) {
        orderItemsContainer.innerHTML = `
            <div class="empty-order text-center p-4">
                <i class="fas fa-shopping-cart fa-3x text-muted mb-3"></i>
                <p class="text-muted">لم يتم إضافة أي عناصر بعد</p>
                <p class="small text-muted">اختر من القائمة لإضافة العناصر</p>
            </div>
        `;
        itemsCount.textContent = '0';
    } else {
        let itemsHtml = '';
        orderItems.forEach((item, index) => {
            const lineTotal = (item.quantity * item.unit_price) - item.discount_amount;
            itemsHtml += `
                <div class="order-item ${index === 0 ? 'new-item' : ''}">
                    <div class="item-info">
                        <h6>${item.product.name}</h6>
                        <small class="text-muted">${parseFloat(item.unit_price).toFixed(2)} ر.س للوحدة</small>
                    </div>
                    <div class="quantity-controls">
                        <button type="button" class="quantity-btn" onclick="decreaseQuantity(${item.id})">
                            <i class="fas fa-minus"></i>
                        </button>
                        <span class="quantity-display">${item.quantity}</span>
                        <button type="button" class="quantity-btn" onclick="increaseQuantity(${item.id})">
                            <i class="fas fa-plus"></i>
                        </button>
                    </div>
                    <div class="text-end">
                        <div class="item-price">${lineTotal.toFixed(2)} ر.س</div>
                        <button type="button" class="btn btn-sm btn-outline-danger" onclick="removeFromOrder(${item.id})">
                            <i class="fas fa-trash"></i>
                        </button>
                    </div>
                </div>
            `;
        });
        
        orderItemsContainer.innerHTML = itemsHtml;
        itemsCount.textContent = orderItems.length;
    }
    
    // تحديث الحقول المخفية للنموذج
    updateHiddenFormInputs();
}

// زيادة الكمية
function increaseQuantity(itemId) {
    const item = orderItems.find(item => item.id === itemId);
    if (item) {
        item.quantity += 1;
        updateOrderDisplay();
        calculateTotals();
    }
}

// تقليل الكمية
function decreaseQuantity(itemId) {
    const item = orderItems.find(item => item.id === itemId);
    if (item && item.quantity > 1) {
        item.quantity -= 1;
        updateOrderDisplay();
        calculateTotals();
    }
}

// إزالة عنصر من الطلب
function removeFromOrder(itemId) {
    orderItems = orderItems.filter(item => item.id !== itemId);
    updateOrderDisplay();
    calculateTotals();
}

// مسح الطلب - عرض modal التأكيد
function clearOrder() {
    if (orderItems.length === 0) {
        showNotification('لا يوجد طلب لمسحه', 'info');
        return;
    }
    
    showClearOrderModal();
}

// عرض modal تأكيد مسح الطلب
function showClearOrderModal() {
    // تحديث ملخص الطلب في الـ modal
    updateClearOrderSummary();
    
    // عرض الـ modal
    $('#clearOrderModal').modal('show');
}

// تحديث ملخص الطلب قبل المسح
function updateClearOrderSummary() {
    const summaryContainer = document.getElementById('clear-order-summary');
    
    if (orderItems.length === 0) {
        summaryContainer.innerHTML = '<p class="text-muted text-center">لا توجد عناصر في الطلب</p>';
        return;
    }
    
    let summaryHtml = `
        <h6 class="mb-3">عناصر الطلب الحالي (${orderItems.length} عنصر):</h6>
        <div class="items-preview mb-3">
    `;
    
    let totalAmount = 0;
    orderItems.forEach(item => {
        const lineTotal = (item.quantity * item.unit_price) - (item.discount_amount || 0);
        totalAmount += lineTotal;
        
        summaryHtml += `
            <div class="item">
                <span><strong>${item.product.name}</strong> × ${item.quantity}</span>
                <span>${lineTotal.toFixed(2)} ر.س</span>
            </div>
        `;
    });
    
    summaryHtml += `
        </div>
        <div class="totals-preview">
            <div class="d-flex justify-content-between fw-bold">
                <span>إجمالي المبلغ:</span>
                <span class="text-primary">${totalAmount.toFixed(2)} ر.س</span>
            </div>
        </div>
    `;
    
    summaryContainer.innerHTML = summaryHtml;
}

// تأكيد مسح الطلب
function confirmClearOrder() {
    // إخفاء الـ modal
    $('#clearOrderModal').modal('hide');
    
    // مسح العناصر
    orderItems = [];
    updateOrderDisplay();
    calculateTotals();
    
    // عرض رسالة تأكيد
    showNotification('تم مسح الطلب بنجاح', 'success');
    
    // إعادة تعيين النموذج للعناصر المخفية
    updateHiddenFormInputs();
}

// حساب الإجماليات
function calculateTotals() {
    let subtotal = 0;
    
    orderItems.forEach(item => {
        const lineTotal = (item.quantity * item.unit_price) - item.discount_amount;
        subtotal += lineTotal;
    });
    
    const discount = parseFloat(document.querySelector('input[name="discount_amount"]').value) || 0;
    const taxableAmount = Math.max(0, subtotal - discount);
    const taxAmount = taxableAmount * 0.15; // 15% ضريبة
    const total = taxableAmount + taxAmount;
    
    // تحديث العرض
    document.getElementById('subtotal-display').textContent = subtotal.toFixed(2) + ' ر.س';
    document.getElementById('tax-total-display').textContent = taxAmount.toFixed(2) + ' ر.س';
    document.getElementById('total-display').textContent = total.toFixed(2) + ' ر.س';
}

// تحديث الحقول المخفية للنموذج - نسخة محسّنة ومُصلحة
function updateHiddenFormInputs() {
    console.log('🔄 Starting updateHiddenFormInputs...');
    
    const form = document.getElementById('restaurant-pos-form');
    const container = document.getElementById('hidden-items-container');
    
    // التأكد من تهيئة orderItems
    if (!orderItems) {
        console.log('OrderItems array is undefined, initializing...');
        orderItems = [];
    }
    
    // التحقق من وجود العناصر
    if (orderItems.length === 0) {
        console.log('⚠️ No order items found - order is empty');
        
        // مسح جميع حقول items[] الموجودة في النموذج
        form.querySelectorAll('input[name^="items["]').forEach(input => input.remove());
        container.innerHTML = '';
        return false;
    }
    
    console.log('📝 Updating hidden inputs for', orderItems.length, 'items:', orderItems);
    
    // مسح جميع حقول items[] الموجودة سابقاً في النموذج والحاوي
    form.querySelectorAll('input[name^="items["]').forEach(input => input.remove());
    container.innerHTML = '';
    
    // إضافة عناصر الطلب
    let validItemsCount = 0;
    orderItems.forEach((item, index) => {
        // التحقق الشامل من صحة البيانات
        if (!item || !item.product || !item.product.id) {
            console.error('❌ Invalid product data for item', index, item);
            return;
        }
        
        if (!item.quantity || item.quantity <= 0) {
            console.error('❌ Invalid quantity for item', index, item.quantity);
            return;
        }
        
        if (item.unit_price === undefined || item.unit_price < 0) {
            console.error('❌ Invalid price for item', index, item.unit_price);
            return;
        }
        
        console.log(`➕ Adding item ${index} to form:`, {
            product_id: item.product.id,
            product_name: item.product.name,
            quantity: item.quantity,
            unit_price: item.unit_price,
            discount_amount: item.discount_amount || 0
        });
        
        // إنشاء عناصر input منفصلة وإضافتها للنموذج مباشرة
        const productIdInput = document.createElement('input');
        productIdInput.type = 'hidden';
        productIdInput.name = `items[${validItemsCount}][product_id]`;
        productIdInput.value = item.product.id.toString();
        productIdInput.setAttribute('data-item-index', validItemsCount);
        form.appendChild(productIdInput);
        
        const quantityInput = document.createElement('input');
        quantityInput.type = 'hidden';
        quantityInput.name = `items[${validItemsCount}][quantity]`;
        quantityInput.value = item.quantity.toString();
        quantityInput.setAttribute('data-item-index', validItemsCount);
        form.appendChild(quantityInput);
        
        const priceInput = document.createElement('input');
        priceInput.type = 'hidden';
        priceInput.name = `items[${validItemsCount}][unit_price]`;
        priceInput.value = parseFloat(item.unit_price).toFixed(2);
        priceInput.setAttribute('data-item-index', validItemsCount);
        form.appendChild(priceInput);
        
        const discountInput = document.createElement('input');
        discountInput.type = 'hidden';
        discountInput.name = `items[${validItemsCount}][discount_amount]`;
        discountInput.value = parseFloat(item.discount_amount || 0).toFixed(2);
        discountInput.setAttribute('data-item-index', validItemsCount);
        form.appendChild(discountInput);
        
        // إضافة account_id إذا كان متوفراً
        if (item.product.account_id) {
            const accountInput = document.createElement('input');
            accountInput.type = 'hidden';
            accountInput.name = `items[${validItemsCount}][account_id]`;
            accountInput.value = item.product.account_id.toString();
            accountInput.setAttribute('data-item-index', validItemsCount);
            form.appendChild(accountInput);
        }
        
        validItemsCount++;
        console.log(`✅ Item ${index} (${item.product.name}) successfully added to form`);
    });
    
    // إضافة بيانات العميل إذا لم يكن محدد
    const customerName = document.querySelector('input[name="customer_name"]');
    const customerPhone = document.querySelector('input[name="customer_phone"]');
    const customerIdInput = document.querySelector('input[name="customer_id"]');
    
    if (customerName && customerName.value.trim() && (!customerIdInput || !customerIdInput.value)) {
        console.log('📝 Adding customer creation data to form');
        
        const createCustomerInput = document.createElement('input');
        createCustomerInput.type = 'hidden';
        createCustomerInput.name = 'create_customer';
        createCustomerInput.value = '1';
        form.appendChild(createCustomerInput);
        
        const newCustomerNameInput = document.createElement('input');
        newCustomerNameInput.type = 'hidden';
        newCustomerNameInput.name = 'new_customer_name';
        newCustomerNameInput.value = customerName.value.trim();
        form.appendChild(newCustomerNameInput);
        
        if (customerPhone && customerPhone.value.trim()) {
            const newCustomerPhoneInput = document.createElement('input');
            newCustomerPhoneInput.type = 'hidden';
            newCustomerPhoneInput.name = 'new_customer_phone';
            newCustomerPhoneInput.value = customerPhone.value.trim();
            form.appendChild(newCustomerPhoneInput);
        }
        
        const newCustomerTypeInput = document.createElement('input');
        newCustomerTypeInput.type = 'hidden';
        newCustomerTypeInput.name = 'new_customer_type';
        newCustomerTypeInput.value = 'individual';
        form.appendChild(newCustomerTypeInput);
        
        console.log('✅ Customer data added for creation:', {
            name: customerName.value.trim(),
            phone: customerPhone ? customerPhone.value.trim() : '',
            type: 'individual'
        });
    }
    
    // التحقق النهائي من عدد الحقول المضافة
    const finalItemInputs = form.querySelectorAll('input[name^="items["]');
    const customerInputs = form.querySelectorAll('input[name^="new_customer"]');
    const createCustomerInput = form.querySelector('input[name="create_customer"]');
    
    console.log('🎯 Final form validation:', {
        validItemsAdded: validItemsCount,
        totalOrderItems: orderItems.length,
        itemInputsInForm: finalItemInputs.length,
        customerInputsInForm: customerInputs.length,
        hasCreateCustomer: !!createCustomerInput,
        formInputsTotal: form.querySelectorAll('input').length,
        allItemInputNames: Array.from(finalItemInputs).map(input => input.name).slice(0, 10) // أول 10 فقط
    });
    
    // التحقق من أن جميع العناصر تم إضافتها بشكل صحيح
    const expectedItemInputs = validItemsCount * 4; // product_id, quantity, unit_price, discount_amount
    if (finalItemInputs.length < expectedItemInputs) {
        console.error('❌ Hidden inputs validation failed:', {
            expected: expectedItemInputs,
            actual: finalItemInputs.length,
            validItems: validItemsCount
        });
        
        showNotification(
            'خطأ في إعداد بيانات النموذج\n' +
            `متوقع: ${expectedItemInputs} حقل\n` +
            `موجود: ${finalItemInputs.length} حقل\n` +
            'تأكد من إضافة المنتجات بشكل صحيح',
            'error'
        );
        return false;
    }
    
    console.log('✅ Hidden inputs updated successfully - ready for submission');
    return true;
}

// تبديل الفئة
function switchCategory(category) {
    currentCategory = category;
    
    // تحديث التبويبات
    document.querySelectorAll('.category-tab').forEach(tab => {
        tab.classList.remove('active');
    });
    document.querySelector(`[data-category="${category}"]`).classList.add('active');
    
    // فلترة المنتجات
    filterProducts();
}

// فلترة المنتجات
function filterProducts() {
    const searchTerm = document.getElementById('product-search').value.toLowerCase();
    const productCards = document.querySelectorAll('.product-card');
    
    productCards.forEach(card => {
        const productName = card.querySelector('.product-name').textContent.toLowerCase();
        const productCategory = card.dataset.category;
        
        const matchesSearch = productName.includes(searchTerm);
        const matchesCategory = currentCategory === 'all' || productCategory == currentCategory;
        
        if (matchesSearch && matchesCategory) {
            card.style.display = '';
        } else {
            card.style.display = 'none';
        }
    });
}

// مسح البحث
function clearSearch() {
    document.getElementById('product-search').value = '';
    filterProducts();
}

// اختيار طريقة الدفع
function selectPaymentMethod(method) {
    // Support both compact and regular payment buttons
    document.querySelectorAll('.btn-payment, .btn-payment-compact').forEach(btn => {
        btn.classList.remove('active');
    });
    document.querySelector(`[data-method="${method}"]`).classList.add('active');
    document.querySelector('input[name="payment_method"]').value = method;
}

// معالجة تغيير نوع الطلب
function handleOrderTypeChange() {
    const orderType = this.value;
    const tableNumberField = document.querySelector('input[name="table_number"]');
    
    if (orderType === 'dine_in') {
        tableNumberField.required = true;
        tableNumberField.parentElement.querySelector('label').innerHTML = 'رقم الطاولة <span class="text-danger">*</span>';
    } else {
        tableNumberField.required = false;
        tableNumberField.parentElement.querySelector('label').textContent = 'رقم الطاولة';
    }
}

// إدارة حالة التحميل للأزرار
function setButtonLoading(button, isLoading, text = null) {
    if (!button) return;
    
    if (isLoading) {
        // حفظ النص الأصلي
        if (!button.dataset.originalText) {
            button.dataset.originalText = button.innerHTML;
        }
        
        // تعطيل الزر وإضافة مؤشر التحميل
        button.disabled = true;
        button.classList.add('btn-loading');
        
        if (text) {
            button.innerHTML = `<i class="fas fa-spinner fa-spin me-2"></i>${text}`;
        }
    } else {
        // استعادة الحالة الأصلية
        button.disabled = false;
        button.classList.remove('btn-loading');
        
        if (button.dataset.originalText) {
            button.innerHTML = button.dataset.originalText;
        }
    }
}

// إخفاء مؤشرات حالة الحفظ
function hideSaveStatus() {
    document.querySelectorAll('.btn-loading').forEach(btn => {
        setButtonLoading(btn, false);
    });
}

// إظهار حالة حفظ البيانات
function showSaveStatus(message) {
    // إخفاء أي إشعارات سابقة
    const existingNotifications = document.querySelectorAll('.save-status-notification');
    existingNotifications.forEach(notification => notification.remove());
    
    // إنشاء إشعار جديد
    const notification = document.createElement('div');
    notification.className = 'alert alert-info save-status-notification position-fixed';
    notification.style.cssText = `
        top: 20px;
        left: 50%;
        transform: translateX(-50%);
        z-index: 9999;
        min-width: 300px;
        text-align: center;
        box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    `;
    notification.innerHTML = `
        <i class="fas fa-spinner fa-spin me-2"></i>
        ${message}
    `;
    
    document.body.appendChild(notification);
    
    // إزالة الإشعار تلقائياً بعد 10 ثوانٍ
    setTimeout(() => {
        if (notification && notification.parentNode) {
            notification.remove();
        }
    }, 800);
}

// الدفع السريع مع مؤشرات التحميل
function quickPay(type) {
    if (orderItems.length === 0) {
        showNotification('يجب إضافة عناصر للطلب أولاً', 'warning');
        return;
    }
    
    const total = parseFloat(document.getElementById('total-display').textContent.replace(' ر.س', ''));
    
    if (type === 'full') {
        // إظهار مؤشر التحميل
        const fullPayBtn = document.getElementById('full-pay-btn');
        setButtonLoading(fullPayBtn, true);
        
        document.querySelector('input[name="paid_amount"]').value = total.toFixed(2);
        // إضافة حقل مخفي للطباعة
        addHiddenInput('print_invoice', '1');
        
        // تأخير قصير لإظهار المؤشر وتحديث الحقول المخفية
        setTimeout(() => {
            updateHiddenFormInputs();
            showSaveStatus('جاري حفظ البيانات وإعداد الطباعة...');
            document.getElementById('restaurant-pos-form').submit();
        }, 100);
    } else if (type === 'partial') {
        const partialPayBtn = document.getElementById('partial-pay-btn');
        setButtonLoading(partialPayBtn, true, 'فتح نافذة الدفع...');
        
        setTimeout(() => {
            setButtonLoading(partialPayBtn, false);
            showPaymentModal();
        }, 300);
    }
}

// حفظ الطلب مع مؤشر التحميل
function saveOrder() {
    if (orderItems.length === 0) {
        showNotification('يجب إضافة عناصر للطلب أولاً', 'warning');
        return;
    }
    
    // إظهار مؤشر التحميل
    const saveBtn = document.getElementById('save-only-btn');
    setButtonLoading(saveBtn, true);
    
    // عرض modal التأكيد أولاً
    setTimeout(() => {
        setButtonLoading(saveBtn, false);
        showSaveConfirmModal();
    }, 500);
}

// عرض modal تأكيد الحفظ
function showSaveConfirmModal() {
    // تحديث معاينة البيانات
    updateOrderPreview();
    $('#saveConfirmModal').modal('show');
}

// تحديث معاينة الطلب للمودال المحسن
function updateOrderPreview() {
    const orderType = document.querySelector('select[name="order_type"]').value;
    const customerName = document.querySelector('input[name="customer_name"]').value || 'غير محدد';
    const tableNumber = document.querySelector('input[name="table_number"]').value;
    const currentTime = new Date().toLocaleString('ar-SA');
    
    // نوع الطلب
    const orderTypeNames = {
        'dine_in': 'تناول في المطعم',
        'takeaway': 'طلب خارجي',
        'delivery': 'توصيل'
    };
    
    // تحديث معلومات الطلب الأساسية
    document.getElementById('preview-order-type').textContent = orderTypeNames[orderType];
    document.getElementById('preview-customer').textContent = customerName;
    document.getElementById('preview-time').textContent = currentTime;
    
    // إظهار أو إخفاء معلومات الطاولة
    const tableInfoCard = document.getElementById('table-info-card');
    const tableNumberElement = document.getElementById('preview-table-number');
    if (orderType === 'dine_in' && tableNumber) {
        tableInfoCard.style.display = 'block';
        tableNumberElement.textContent = tableNumber;
    } else {
        tableInfoCard.style.display = 'none';
    }
    
    // تحديث عدد العناصر
    document.getElementById('preview-items-count').textContent = `${orderItems.length} عنصر`;
    
    // تحديث عناصر الطلب بتصميم محسن
    let itemsHtml = '';
    if (orderItems.length === 0) {
        itemsHtml = `
            <div class="text-center p-4">
                <i class="fas fa-shopping-basket fa-2x text-muted mb-2"></i>
                <p class="text-muted mb-0">لا توجد عناصر في الطلب</p>
            </div>
        `;
    } else {
        orderItems.forEach((item, index) => {
            const lineTotal = (item.quantity * item.unit_price) - (item.discount_amount || 0);
            itemsHtml += `
                <div class="item-modern" style="animation-delay: ${index * 0.1}s">
                    <div class="item-info">
                        <div class="item-icon">
                            <i class="fas fa-utensils"></i>
                        </div>
                        <div class="item-details">
                            <h6>${item.product.name}</h6>
                            <small>${item.unit_price.toFixed(2)} ر.س للوحدة</small>
                        </div>
                    </div>
                    <div class="item-quantity">×${item.quantity}</div>
                    <div class="item-price">${lineTotal.toFixed(2)} ر.س</div>
                </div>
            `;
        });
    }
    document.getElementById('preview-items').innerHTML = itemsHtml;
    
    // حساب الإجماليات
    const subtotal = orderItems.reduce((sum, item) => sum + (item.quantity * item.unit_price), 0);
    const discount = parseFloat(document.querySelector('input[name="discount_amount"]').value) || 0;
    const taxableAmount = Math.max(0, subtotal - discount);
    const taxAmount = taxableAmount * 0.15;
    const total = taxableAmount + taxAmount;
    
    // تحديث الإجماليات
    document.getElementById('preview-subtotal').textContent = subtotal.toFixed(2) + ' ر.س';
    document.getElementById('preview-tax').textContent = taxAmount.toFixed(2) + ' ر.س';
    document.getElementById('preview-total').textContent = total.toFixed(2) + ' ر.س';
    
    // إظهار أو إخفاء صف الخصم
    const discountRow = document.getElementById('discount-row');
    const discountElement = document.getElementById('preview-discount');
    if (discount > 0) {
        discountRow.style.display = 'flex';
        discountElement.textContent = discount.toFixed(2) + ' ر.س';
    } else {
        discountRow.style.display = 'none';
    }
}

// تأكيد حفظ الطلب مع تحسينات للتصميم الجديد
function confirmSaveOrder() {
    // إظهار حالة التحميل على الزر المحسن
    const confirmBtn = document.querySelector('.btn-confirm');
    if (confirmBtn) {
        confirmBtn.classList.add('loading');
        confirmBtn.disabled = true;
    }
    
    // إظهار مؤشر حالة الحفظ
    showSaveStatus('جاري حفظ الفاتورة في قاعدة البيانات...');
    
    document.querySelector('input[name="paid_amount"]').value = '0';
    
    // حفظ بيانات الفاتورة للعرض في modal النجاح
    sessionStorage.setItem('invoiceData', JSON.stringify({
        items: orderItems,
        subtotal: orderItems.reduce((sum, item) => sum + (item.quantity * item.unit_price), 0),
        discount: parseFloat(document.querySelector('input[name="discount_amount"]').value) || 0,
        total: parseFloat(document.getElementById('total-display').textContent.replace(' ر.س', ''))
    }));
    
    // تأخير قصير لإظهار التأثير البصري
    setTimeout(() => {
        // إخفاء الـ modal مع تأثير
        $('#saveConfirmModal').modal('hide');
        
        // تأخير إضافي لتحديث الحقول وإرسال النموذج
        setTimeout(() => {
            updateHiddenFormInputs();
            document.getElementById('restaurant-pos-form').submit();
        }, 300);
    }, 500);
}

// إضافة خصم
function addDiscount() {
    $('#discountModal').modal('show');
}

// تطبيق الخصم
function applyDiscount() {
    const discountType = document.getElementById('discount-type').value;
    const discountValue = parseFloat(document.getElementById('discount-value').value) || 0;
    
    if (discountValue <= 0) {
        showNotification('يجب إدخال قيمة خصم صحيحة', 'warning');
        return;
    }
    
    const subtotal = orderItems.reduce((sum, item) => sum + (item.quantity * item.unit_price), 0);
    let discountAmount = 0;
    
    if (discountType === 'percentage') {
        if (discountValue > 100) {
            showNotification('نسبة الخصم لا يمكن أن تتجاوز 100%', 'warning');
            return;
        }
        discountAmount = (subtotal * discountValue) / 100;
    } else {
        discountAmount = discountValue;
    }
    
    if (discountAmount > subtotal) {
        showNotification('قيمة الخصم لا يمكن أن تتجاوز المجموع الفرعي', 'warning');
        return;
    }
    
    document.querySelector('input[name="discount_amount"]').value = discountAmount.toFixed(2);
    calculateTotals();
    $('#discountModal').modal('hide');
    showNotification('تم تطبيق الخصم بنجاح', 'success');
}

// إضافة ملاحظة - عرض modal محسن
function addNote() {
    // إظهار الملاحظة الحالية إن وجدت
    updateCurrentNoteDisplay();
    
    // عرض الـ modal
    $('#addNoteModal').modal('show');
    
    // التركيز على حقل النص
    setTimeout(() => {
        document.getElementById('order-note-input').focus();
    }, 500);
}

// تحديث عرض الملاحظة الحالية
function updateCurrentNoteDisplay() {
    const notesInput = document.querySelector('input[name="notes"]');
    const currentNoteSection = document.getElementById('current-note-section');
    const currentNoteDisplay = document.getElementById('current-note-display');
    const noteTextarea = document.getElementById('order-note-input');
    
    if (notesInput && notesInput.value.trim()) {
        currentNoteSection.style.display = 'block';
        currentNoteDisplay.textContent = notesInput.value.trim();
        noteTextarea.value = notesInput.value.trim();
        updateCharacterCount();
    } else {
        currentNoteSection.style.display = 'none';
        noteTextarea.value = '';
        updateCharacterCount();
    }
}

// تحديث عداد الأحرف
function updateCharacterCount() {
    const textarea = document.getElementById('order-note-input');
    const counter = document.getElementById('note-char-count');
    const currentLength = textarea.value.length;
    
    counter.textContent = currentLength;
    
    // تغيير لون العداد حسب الطول
    counter.parentElement.classList.remove('warning', 'danger');
    if (currentLength > 400) {
        counter.parentElement.classList.add('danger');
    } else if (currentLength > 350) {
        counter.parentElement.classList.add('warning');
    }
}

// اختيار ملاحظة سريعة
function selectQuickNote(noteText) {
    const textarea = document.getElementById('order-note-input');
    const currentText = textarea.value.trim();
    
    if (currentText) {
        // إضافة الملاحظة السريعة إلى النص الموجود
        textarea.value = currentText + (currentText.endsWith('.') || currentText.endsWith('،') ? ' ' : '، ') + noteText;
    } else {
        // إضافة الملاحظة السريعة كنص جديد
        textarea.value = noteText;
    }
    
    updateCharacterCount();
    textarea.focus();
    
    // تأثير بصري للزر المضغوط
    event.target.style.transform = 'scale(0.95)';
    setTimeout(() => {
        event.target.style.transform = '';
    }, 150);
}

// مسح الملاحظة
function clearNote() {
    const textarea = document.getElementById('order-note-input');
    textarea.value = '';
    updateCharacterCount();
    textarea.focus();
    
    showNotification('تم مسح الملاحظة', 'info');
}

// حفظ ملاحظة الطلب
function saveOrderNote() {
    const textarea = document.getElementById('order-note-input');
    const noteText = textarea.value.trim();
    
    // العثور على حقل الملاحظات المخفي أو إنشاؤه
    let notesInput = document.querySelector('input[name="notes"]');
    if (!notesInput) {
        notesInput = document.createElement('input');
        notesInput.type = 'hidden';
        notesInput.name = 'notes';
        document.getElementById('restaurant-pos-form').appendChild(notesInput);
    }
    
    // حفظ الملاحظة
    notesInput.value = noteText;
    
    // إخفاء الـ modal
    $('#addNoteModal').modal('hide');
    
    // عرض رسالة نجاح
    if (noteText) {
        showNotification(
            `تم حفظ الملاحظة بنجاح\n` +
            `الملاحظة: ${noteText.length > 50 ? noteText.substring(0, 50) + '...' : noteText}`,
            'success'
        );
    } else {
        showNotification('تم حذف الملاحظة', 'info');
    }
}

// إضافة مستمع للأحداث عند تحميل الصفحة للملاحظات
document.addEventListener('DOMContentLoaded', function() {
    // مستمع تحديث عداد الأحرف
    const noteTextarea = document.getElementById('order-note-input');
    if (noteTextarea) {
        noteTextarea.addEventListener('input', updateCharacterCount);
        noteTextarea.addEventListener('keydown', function(e) {
            // منع إدخال المزيد من النص إذا تم الوصول للحد الأقصى
            if (this.value.length >= 500 && e.key !== 'Backspace' && e.key !== 'Delete' && !e.ctrlKey) {
                e.preventDefault();
                showNotification('لقد وصلت للحد الأقصى من الأحرف (500)', 'warning');
            }
        });
    }
    
    // إضافة مستمع لإعادة تعيين الـ modal عند إغلاقه
    $('#addNoteModal').on('hidden.bs.modal', function() {
        // إعادة تعيين النموذج
        const textarea = document.getElementById('order-note-input');
        textarea.value = '';
        updateCharacterCount();
        
        // إخفاء قسم الملاحظة الحالية
        const currentNoteSection = document.getElementById('current-note-section');
        currentNoteSection.style.display = 'none';
    });
});

// عرض نافذة الدفع
function showPaymentModal() {
    const total = parseFloat(document.getElementById('total-display').textContent.replace(' ر.س', ''));
    document.getElementById('modal-total-amount').value = total.toFixed(2) + ' ر.س';
    document.getElementById('modal-paid-amount').value = '';
    document.getElementById('modal-remaining-amount').value = total.toFixed(2) + ' ر.س';
    
    // حساب المبلغ المتبقي عند التغيير
    document.getElementById('modal-paid-amount').addEventListener('input', function() {
        const paid = parseFloat(this.value) || 0;
        const remaining = Math.max(0, total - paid);
        document.getElementById('modal-remaining-amount').value = remaining.toFixed(2) + ' ر.س';
    });
    
    $('#paymentModal').modal('show');
}

// تأكيد الدفع
function confirmPayment() {
    const paidAmount = parseFloat(document.getElementById('modal-paid-amount').value) || 0;
    const total = parseFloat(document.getElementById('total-display').textContent.replace(' ر.س', ''));
    
    if (paidAmount > total) {
        showNotification('المبلغ المدفوع لا يمكن أن يكون أكبر من الإجمالي', 'warning');
        return;
    }
    
    document.querySelector('input[name="paid_amount"]').value = paidAmount.toFixed(2);
    
    // إذا كان الدفع كاملاً، طباعة الفاتورة
    if (paidAmount >= total) {
        addHiddenInput('print_invoice', '1');
    }
    
    $('#paymentModal').modal('hide');
    updateHiddenFormInputs();
    document.getElementById('restaurant-pos-form').submit();
}

// إضافة حقل مخفي للنموذج
function addHiddenInput(name, value) {
    let input = document.querySelector(`input[name="${name}"]`);
    if (!input) {
        input = document.createElement('input');
        input.type = 'hidden';
        input.name = name;
        document.getElementById('restaurant-pos-form').appendChild(input);
    }
    input.value = value;
}

// تعليق الطلب - عرض modal التأكيد
function holdOrder() {
    if (orderItems.length === 0) {
        showNotification('لا يوجد طلب لتعليقه', 'warning');
        return;
    }
    
    showHoldOrderModal();
}

// عرض modal تأكيد تعليق الطلب
function showHoldOrderModal() {
    // تحديث ملخص الطلب في الـ modal
    updateHoldOrderSummary();
    
    // مسح الملاحظة السابقة
    document.getElementById('hold-order-note').value = '';
    
    // عرض الـ modal
    $('#holdOrderModal').modal('show');
}

// تحديث ملخص الطلب قبل التعليق
function updateHoldOrderSummary() {
    const summaryContainer = document.getElementById('hold-order-summary');
    
    if (orderItems.length === 0) {
        summaryContainer.innerHTML = '<p class="text-muted text-center">لا توجد عناصر في الطلب</p>';
        return;
    }
    
    // معلومات الطلب
    const orderType = document.querySelector('select[name="order_type"]').value;
    const customerName = document.querySelector('input[name="customer_name"]').value || 'غير محدد';
    const tableNumber = document.querySelector('input[name="table_number"]').value;
    
    const orderTypeNames = {
        'dine_in': 'تناول في المطعم',
        'takeaway': 'طلب خارجي',
        'delivery': 'توصيل'
    };
    
    let summaryHtml = `
        <h6 class="mb-3">تفاصيل الطلب:</h6>
        <div class="row mb-3">
            <div class="col-6">
                <small class="text-muted">نوع الطلب:</small>
                <div><strong>${orderTypeNames[orderType]}</strong></div>
            </div>
            <div class="col-6">
                <small class="text-muted">العميل:</small>
                <div><strong>${customerName}</strong></div>
            </div>
        </div>
    `;
    
    if (tableNumber && orderType === 'dine_in') {
        summaryHtml += `
            <div class="mb-3">
                <small class="text-muted">رقم الطاولة:</small>
                <div><strong>${tableNumber}</strong></div>
            </div>
        `;
    }
    
    summaryHtml += `
        <h6 class="mb-2">عناصر الطلب (${orderItems.length} عنصر):</h6>
        <div class="items-preview mb-3">
    `;
    
    let totalAmount = 0;
    orderItems.forEach(item => {
        const lineTotal = (item.quantity * item.unit_price) - (item.discount_amount || 0);
        totalAmount += lineTotal;
        
        summaryHtml += `
            <div class="item">
                <span><strong>${item.product.name}</strong> × ${item.quantity}</span>
                <span>${lineTotal.toFixed(2)} ر.س</span>
            </div>
        `;
    });
    
    summaryHtml += `
        </div>
        <div class="totals-preview">
            <div class="d-flex justify-content-between fw-bold">
                <span>إجمالي المبلغ:</span>
                <span class="text-primary">${totalAmount.toFixed(2)} ر.س</span>
            </div>
        </div>
    `;
    
    summaryContainer.innerHTML = summaryHtml;
}

// تأكيد تعليق الطلب
function confirmHoldOrder() {
    const note = document.getElementById('hold-order-note').value.trim();
    const timestamp = Date.now();
    
    const orderData = {
        items: orderItems,
        order_type: document.querySelector('select[name="order_type"]').value,
        table_number: document.querySelector('input[name="table_number"]').value,
        customer_phone: document.querySelector('input[name="customer_phone"]').value,
        customer_name: document.querySelector('input[name="customer_name"]').value,
        discount_amount: document.querySelector('input[name="discount_amount"]').value,
        note: note,
        created_at: new Date(timestamp).toLocaleString('ar-SA'),
        timestamp: timestamp
    };
    
    // حفظ الطلب في localStorage
    localStorage.setItem(`held_order_${timestamp}`, JSON.stringify(orderData));
    
    // إخفاء الـ modal
    $('#holdOrderModal').modal('hide');
    
    // مسح الطلب الحالي
    orderItems = [];
    updateOrderDisplay();
    calculateTotals();
    updateHiddenFormInputs();
    
    // إعادة تعيين النموذج
    document.getElementById('restaurant-pos-form').reset();
    document.querySelector('input[name="paid_amount"]').value = '0';
    document.querySelector('input[name="customer_id"]').value = '1';
    selectPaymentMethod('cash');
    
    // عرض رسالة نجاح
    showNotification(
        `تم تعليق الطلب بنجاح\n` +
        `الوقت: ${new Date(timestamp).toLocaleString('ar-SA')}\n` +
        (note ? `الملاحظة: ${note}` : ''),
        'success'
    );
}

// استدعاء طلب - عرض modal الطلبات المعلقة
function loadOrder() {
    const heldOrders = [];
    for (let i = 0; i < localStorage.length; i++) {
        const key = localStorage.key(i);
        if (key.startsWith('held_order_')) {
            heldOrders.push({
                key: key,
                data: JSON.parse(localStorage.getItem(key)),
                timestamp: parseInt(key.replace('held_order_', ''))
            });
        }
    }
    
    if (heldOrders.length === 0) {
        showNotification('لا توجد طلبات معلقة', 'info');
        return;
    }
    
    // ترتيب الطلبات حسب الوقت (الأحدث أولاً)
    heldOrders.sort((a, b) => b.timestamp - a.timestamp);
    
    showLoadOrderModal(heldOrders);
}

// عرض modal الطلبات المعلقة
function showLoadOrderModal(heldOrders) {
    const listContainer = document.getElementById('held-orders-list');
    
    if (heldOrders.length === 0) {
        listContainer.innerHTML = `
            <div class="text-center p-4">
                <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">لا توجد طلبات معلقة</h5>
                <p class="text-muted">لم يتم تعليق أي طلبات بعد</p>
            </div>
        `;
    } else {
        let listHtml = '<div class="held-orders-container">';
        
        heldOrders.forEach((order, index) => {
            const orderData = order.data;
            const createdAt = orderData.created_at || new Date(order.timestamp).toLocaleString('ar-SA');
            const customerName = orderData.customer_name || 'غير محدد';
            const itemsCount = orderData.items ? orderData.items.length : 0;
            const note = orderData.note || '';
            
            // حساب إجمالي المبلغ
            let totalAmount = 0;
            if (orderData.items && orderData.items.length > 0) {
                totalAmount = orderData.items.reduce((sum, item) => {
                    const lineTotal = (item.quantity * item.unit_price) - (item.discount_amount || 0);
                    return sum + lineTotal;
                }, 0);
            }
            
            const orderTypeNames = {
                'dine_in': 'تناول في المطعم',
                'takeaway': 'طلب خارجي',
                'delivery': 'توصيل'
            };
            const orderTypeName = orderTypeNames[orderData.order_type] || 'غير محدد';
            
            listHtml += `
                <div class="held-order-card mb-3" data-order-key="${order.key}">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-8">
                                    <h6 class="card-title mb-2">
                                        <i class="fas fa-clock me-2 text-warning"></i>
                                        طلب معلق - ${createdAt}
                                    </h6>
                                    <div class="row mb-2">
                                        <div class="col-6">
                                            <small class="text-muted">العميل:</small>
                                            <div><strong>${customerName}</strong></div>
                                        </div>
                                        <div class="col-6">
                                            <small class="text-muted">نوع الطلب:</small>
                                            <div><strong>${orderTypeName}</strong></div>
                                        </div>
                                    </div>
                                    ${orderData.table_number && orderData.order_type === 'dine_in' ? `
                                        <div class="mb-2">
                                            <small class="text-muted">رقم الطاولة:</small>
                                            <strong>${orderData.table_number}</strong>
                                        </div>
                                    ` : ''}
                                    <div class="mb-2">
                                        <small class="text-muted">عدد العناصر:</small>
                                        <span class="badge bg-primary">${itemsCount} عنصر</span>
                                        <small class="text-muted ms-3">المبلغ:</small>
                                        <span class="fw-bold text-success">${totalAmount.toFixed(2)} ر.س</span>
                                    </div>
                                    ${note ? `
                                        <div class="mb-2">
                                            <small class="text-muted">الملاحظة:</small>
                                            <div class="text-info">${note}</div>
                                        </div>
                                    ` : ''}
                                </div>
                                <div class="col-md-4 text-end">
                                    <button type="button" class="btn btn-success btn-sm mb-2 w-100"
                                            onclick="loadSelectedOrder('${order.key}')">
                                        <i class="fas fa-download me-1"></i>
                                        استدعاء الطلب
                                    </button>
                                    <button type="button" class="btn btn-outline-secondary btn-sm w-100"
                                            onclick="viewOrderDetails('${order.key}')">
                                        <i class="fas fa-eye me-1"></i>
                                        عرض التفاصيل
                                    </button>
                                    <button type="button" class="btn btn-outline-danger btn-sm w-100 mt-1"
                                            onclick="deleteHeldOrder('${order.key}')">
                                        <i class="fas fa-trash me-1"></i>
                                        حذف
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            `;
        });
        
        listHtml += '</div>';
        listContainer.innerHTML = listHtml;
    }
    
    // عرض الـ modal
    $('#loadOrderModal').modal('show');
}

// استدعاء طلب محدد
function loadSelectedOrder(orderKey) {
    const orderData = JSON.parse(localStorage.getItem(orderKey));
    if (!orderData) {
        showNotification('خطأ في استدعاء الطلب', 'error');
        return;
    }
    
    // التحقق من وجود طلب حالي
    if (orderItems.length > 0) {
        showReplaceOrderModal(orderKey, orderData);
        return;
    }
    
    // تحميل بيانات الطلب مباشرة إذا لم يكن هناك طلب حالي
    confirmLoadOrder(orderKey, orderData);
}

// عرض modal تأكيد استبدال الطلب
function showReplaceOrderModal(orderKey, orderData) {
    // إنشاء modal تأكيد الاستبدال
    const replaceModal = document.createElement('div');
    replaceModal.className = 'modal fade';
    replaceModal.id = 'replaceOrderModal';
    replaceModal.innerHTML = `
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-warning text-dark">
                    <h5 class="modal-title">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        استبدال الطلب الحالي
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="text-center mb-4">
                        <i class="fas fa-exchange-alt fa-3x text-warning mb-3"></i>
                        <h5>يوجد طلب حالي. هل تريد استبداله بالطلب المعلق؟</h5>
                        <p class="text-muted">سيتم حذف الطلب الحالي نهائياً واستبداله بالطلب المعلق المختار</p>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card border-danger">
                                <div class="card-header bg-danger text-white">
                                    <h6 class="mb-0">
                                        <i class="fas fa-times me-1"></i>
                                        الطلب الحالي (سيتم حذفه)
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <small class="text-muted">عدد العناصر:</small>
                                    <div><strong>${orderItems.length} عنصر</strong></div>
                                    <small class="text-muted">المبلغ التقريبي:</small>
                                    <div><strong>${calculateCurrentOrderTotal().toFixed(2)} ر.س</strong></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card border-success">
                                <div class="card-header bg-success text-white">
                                    <h6 class="mb-0">
                                        <i class="fas fa-check me-1"></i>
                                        الطلب المعلق (سيتم تحميله)
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <small class="text-muted">العميل:</small>
                                    <div><strong>${orderData.customer_name || 'غير محدد'}</strong></div>
                                    <small class="text-muted">عدد العناصر:</small>
                                    <div><strong>${orderData.items ? orderData.items.length : 0} عنصر</strong></div>
                                    <small class="text-muted">الوقت:</small>
                                    <div><strong>${orderData.created_at || 'غير محدد'}</strong></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="alert alert-warning mt-3" role="alert">
                        <i class="fas fa-info-circle me-2"></i>
                        <strong>تنبيه:</strong> لا يمكن التراجع عن هذا الإجراء. تأكد من أن الطلب الحالي غير مهم قبل المتابعة.
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times me-2"></i>
                        إلغاء
                    </button>
                    <button type="button" class="btn btn-warning" onclick="confirmLoadOrder('${orderKey}', JSON.parse('${JSON.stringify(orderData).replace(/'/g, "\\'")}'))">
                        <i class="fas fa-exchange-alt me-2"></i>
                        تأكيد الاستبدال
                    </button>
                </div>
            </div>
        </div>
    `;
    
    // إضافة modal للصفحة وعرضه
    document.body.appendChild(replaceModal);
    $(replaceModal).modal('show');
    
    // حذف modal عند إخفاؤه
    $(replaceModal).on('hidden.bs.modal', function() {
        replaceModal.remove();
    });
}

// تأكيد تحميل الطلب
function confirmLoadOrder(orderKey, orderData) {
    // إخفاء modal الاستبدال إن كان موجوداً
    $('#replaceOrderModal').modal('hide');
    
    // تحميل بيانات الطلب
    loadOrderData(orderData);
    
    // حذف الطلب المعلق من localStorage
    localStorage.removeItem(orderKey);
    
    // إخفاء modal قائمة الطلبات المعلقة
    $('#loadOrderModal').modal('hide');
    
    // عرض رسالة نجاح
    showNotification(
        `تم استدعاء الطلب بنجاح\n` +
        `العميل: ${orderData.customer_name || 'غير محدد'}\n` +
        `عدد العناصر: ${orderData.items ? orderData.items.length : 0}`,
        'success'
    );
}

// حساب إجمالي الطلب الحالي
function calculateCurrentOrderTotal() {
    if (!orderItems || orderItems.length === 0) return 0;
    return orderItems.reduce((sum, item) => {
        const lineTotal = (item.quantity * item.unit_price) - (item.discount_amount || 0);
        return sum + lineTotal;
    }, 0);
}

// عرض تفاصيل الطلب المعلق
function viewOrderDetails(orderKey) {
    const orderData = JSON.parse(localStorage.getItem(orderKey));
    if (!orderData) {
        showNotification('خطأ في عرض تفاصيل الطلب', 'error');
        return;
    }
    
    let detailsHtml = `
        <div class="order-details-modal">
            <h6>تفاصيل الطلب المعلق</h6>
            <hr>
            <div class="row mb-3">
                <div class="col-6">
                    <strong>الوقت:</strong><br>
                    ${orderData.created_at || new Date(parseInt(orderKey.replace('held_order_', ''))).toLocaleString('ar-SA')}
                </div>
                <div class="col-6">
                    <strong>العميل:</strong><br>
                    ${orderData.customer_name || 'غير محدد'}
                </div>
            </div>
    `;
    
    if (orderData.note) {
        detailsHtml += `
            <div class="mb-3">
                <strong>الملاحظة:</strong><br>
                <div class="alert alert-info">${orderData.note}</div>
            </div>
        `;
    }
    
    detailsHtml += `
        <h6>عناصر الطلب:</h6>
        <div class="table-responsive">
            <table class="table table-sm">
                <thead>
                    <tr>
                        <th>المنتج</th>
                        <th>الكمية</th>
                        <th>السعر</th>
                        <th>الإجمالي</th>
                    </tr>
                </thead>
                <tbody>
    `;
    
    let totalAmount = 0;
    if (orderData.items && orderData.items.length > 0) {
        orderData.items.forEach(item => {
            const lineTotal = (item.quantity * item.unit_price) - (item.discount_amount || 0);
            totalAmount += lineTotal;
            
            detailsHtml += `
                <tr>
                    <td>${item.product.name}</td>
                    <td>${item.quantity}</td>
                    <td>${item.unit_price.toFixed(2)} ر.س</td>
                    <td>${lineTotal.toFixed(2)} ر.س</td>
                </tr>
            `;
        });
    }
    
    detailsHtml += `
                </tbody>
                <tfoot>
                    <tr class="fw-bold">
                        <td colspan="3">الإجمالي:</td>
                        <td>${totalAmount.toFixed(2)} ر.س</td>
                    </tr>
                </tfoot>
            </table>
        </div>
        </div>
    `;
    
    // عرض التفاصيل في alert modal
    const detailsModal = document.createElement('div');
    detailsModal.className = 'modal fade';
    detailsModal.innerHTML = `
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">تفاصيل الطلب المعلق</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    ${detailsHtml}
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                    <button type="button" class="btn btn-success" onclick="loadSelectedOrder('${orderKey}'); $(this).closest('.modal').modal('hide');">
                        <i class="fas fa-download me-1"></i>
                        استدعاء هذا الطلب
                    </button>
                </div>
            </div>
        </div>
    `;
    
    document.body.appendChild(detailsModal);
    $(detailsModal).modal('show');
    
    // حذف الـ modal بعد إخفاؤه
    $(detailsModal).on('hidden.bs.modal', function() {
        detailsModal.remove();
    });
}

// حذف طلب معلق
function deleteHeldOrder(orderKey) {
    // الحصول على بيانات الطلب لعرضها في modal التأكيد
    const orderData = JSON.parse(localStorage.getItem(orderKey));
    showDeleteOrderModal(orderKey, orderData);
}

// عرض modal تأكيد حذف الطلب المعلق
function showDeleteOrderModal(orderKey, orderData) {
    // إنشاء modal تأكيد الحذف
    const deleteModal = document.createElement('div');
    deleteModal.className = 'modal fade';
    deleteModal.id = 'deleteOrderModal';
    deleteModal.innerHTML = `
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title">
                        <i class="fas fa-trash me-2"></i>
                        تأكيد حذف الطلب المعلق
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="text-center mb-4">
                        <i class="fas fa-exclamation-triangle fa-3x text-danger mb-3"></i>
                        <h5>هل أنت متأكد من حذف هذا الطلب المعلق؟</h5>
                        <p class="text-muted">لا يمكن التراجع عن هذا الإجراء</p>
                    </div>
                    
                    ${orderData ? `
                    <div class="card border-danger">
                        <div class="card-header bg-light">
                            <h6 class="mb-0 text-danger">
                                <i class="fas fa-info-circle me-1"></i>
                                تفاصيل الطلب المراد حذفه
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-6">
                                    <small class="text-muted">العميل:</small>
                                    <div><strong>${orderData.customer_name || 'غير محدد'}</strong></div>
                                </div>
                                <div class="col-6">
                                    <small class="text-muted">الوقت:</small>
                                    <div><strong>${orderData.created_at || 'غير محدد'}</strong></div>
                                </div>
                            </div>
                            <div class="row mt-2">
                                <div class="col-6">
                                    <small class="text-muted">عدد العناصر:</small>
                                    <div><strong>${orderData.items ? orderData.items.length : 0} عنصر</strong></div>
                                </div>
                                <div class="col-6">
                                    <small class="text-muted">المبلغ التقريبي:</small>
                                    <div><strong>${orderData.items ? orderData.items.reduce((sum, item) => sum + (item.quantity * item.unit_price) - (item.discount_amount || 0), 0).toFixed(2) : '0.00'} ر.س</strong></div>
                                </div>
                            </div>
                            ${orderData.note ? `
                                <div class="mt-2">
                                    <small class="text-muted">الملاحظة:</small>
                                    <div class="text-info">${orderData.note}</div>
                                </div>
                            ` : ''}
                        </div>
                    </div>
                    ` : ''}
                    
                    <div class="alert alert-danger mt-3" role="alert">
                        <i class="fas fa-warning me-2"></i>
                        <strong>تحذير:</strong> سيتم حذف هذا الطلب نهائياً من الذاكرة المحلية ولن يمكن استرداده.
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times me-2"></i>
                        إلغاء
                    </button>
                    <button type="button" class="btn btn-danger" onclick="confirmDeleteOrder('${orderKey}')">
                        <i class="fas fa-trash me-2"></i>
                        تأكيد الحذف
                    </button>
                </div>
            </div>
        </div>
    `;
    
    // إضافة modal للصفحة وعرضه
    document.body.appendChild(deleteModal);
    $(deleteModal).modal('show');
    
    // حذف modal عند إخفاؤه
    $(deleteModal).on('hidden.bs.modal', function() {
        deleteModal.remove();
    });
}

// تأكيد حذف الطلب المعلق
function confirmDeleteOrder(orderKey) {
    // إخفاء modal التأكيد
    $('#deleteOrderModal').modal('hide');
    
    // حذف الطلب من localStorage
    localStorage.removeItem(orderKey);
    
    // عرض رسالة نجاح
    showNotification('تم حذف الطلب المعلق بنجاح', 'success');
    
    // إعادة تحديث قائمة الطلبات
    loadOrder();
}

// تحميل بيانات الطلب
function loadOrderData(orderData) {
    orderItems = orderData.items;
    document.querySelector('select[name="order_type"]').value = orderData.order_type;
    document.querySelector('input[name="table_number"]').value = orderData.table_number;
    document.querySelector('input[name="customer_phone"]').value = orderData.customer_phone;
    document.querySelector('input[name="customer_name"]').value = orderData.customer_name;
    document.querySelector('input[name="discount_amount"]').value = orderData.discount_amount;
    
    updateOrderDisplay();
    calculateTotals();
}

// التحقق من صحة النموذج المحسن
function validateForm(e) {
    console.log('🔍 Starting form validation...');
    const errors = [];
    
    // تحديث الحقول المخفية قبل التحقق (إضافي للأمان)
    const updateResult = updateHiddenFormInputs();
    if (!updateResult) {
        errors.push('فشل في تحديث بيانات النموذج - يرجى المحاولة مرة أخرى');
    }
    
    // التحقق من وجود عناصر في المصفوفة
    if (!orderItems || orderItems.length === 0) {
        errors.push(
            'يجب إضافة عنصر واحد على الأقل للطلب\n\n' +
            '📋 خطوات إضافة المنتجات:\n' +
            '1️⃣ اختر منتج من القائمة أدناه\n' +
            '2️⃣ انقر على المنتج لإضافته للطلب\n' +
            '3️⃣ تأكد من ظهور المنتج في قائمة "الطلب الحالي"\n' +
            '4️⃣ كرر العملية لإضافة منتجات أخرى\n\n' +
            '💡 إذا لم تعمل إضافة المنتجات، أعد تحميل الصفحة وحاول مرة أخرى'
        );
        console.warn('No items in orderItems array. User must select products first.');
    } else {
        console.log('✅ Found', orderItems.length, 'items in order');
    }
    
    // التحقق من وجود الحقول المخفية في النموذج (تحقق شامل ومحدث)
    const form = document.getElementById('restaurant-pos-form');
    const formItemInputs = form.querySelectorAll('input[name^="items["]');
    const expectedInputs = orderItems ? orderItems.length * 4 : 0; // product_id, quantity, unit_price, discount_amount
    
    console.log('🧪 Form inputs validation:', {
        orderItemsCount: orderItems ? orderItems.length : 0,
        expectedFormInputs: expectedInputs,
        actualFormInputs: formItemInputs.length,
        updateResult: updateResult
    });
    
    if (orderItems && orderItems.length > 0) {
        if (formItemInputs.length < expectedInputs) {
            errors.push(
                `خطأ في إعداد بيانات النموذج للإرسال\n` +
                `العناصر في الطلب: ${orderItems.length}\n` +
                `الحقول المتوقعة: ${expectedInputs}\n` +
                `الحقول الموجودة: ${formItemInputs.length}\n\n` +
                `يرجى إعادة إضافة المنتجات أو إعادة تحميل الصفحة`
            );
            console.error('❌ Form inputs validation failed:', {
                orderItemsCount: orderItems.length,
                expectedInputs: expectedInputs,
                actualInputs: formItemInputs.length,
                formInputNames: Array.from(formItemInputs).map(input => input.name).slice(0, 10)
            });
        } else {
            console.log('✅ Form inputs validation passed:', formItemInputs.length, 'inputs found in form');
        }
    }
    
    // التحقق من صحة العناصر
    if (orderItems && orderItems.length > 0) {
        orderItems.forEach((item, index) => {
            if (!item.product || !item.product.id) {
                errors.push(`العنصر رقم ${index + 1}: منتج غير صالح`);
            }
            if (!item.quantity || item.quantity <= 0) {
                errors.push(`العنصر رقم ${index + 1}: كمية غير صالحة (${item.quantity})`);
            }
            if (item.unit_price === undefined || item.unit_price < 0) {
                errors.push(`العنصر رقم ${index + 1}: سعر غير صالح (${item.unit_price})`);
            }
        });
    }
    
    // التحقق من نوع الطلب ورقم الطاولة
    const orderType = document.querySelector('select[name="order_type"]').value;
    const tableNumber = document.querySelector('input[name="table_number"]').value;
    
    if (orderType === 'dine_in' && !tableNumber) {
        errors.push('يجب إدخال رقم الطاولة للطلبات داخل المطعم');
    }
    
    // التحقق من معلومات العميل
    const customerName = document.querySelector('input[name="customer_name"]').value.trim();
    const customerId = document.querySelector('input[name="customer_id"]').value;
    
    if (!customerId && !customerName) {
        errors.push('يجب إدخال اسم العميل أو اختيار عميل موجود');
    }
    
    if (customerName && customerName.length < 2) {
        errors.push('اسم العميل يجب أن يكون على الأقل حرفين');
    }
    
    // التحقق من رقم الهاتف إذا تم إدخاله
    const customerPhone = document.querySelector('input[name="customer_phone"]').value.trim();
    if (customerPhone && !isValidPhoneNumber(customerPhone)) {
        errors.push('رقم الهاتف غير صحيح (يجب أن يبدأ بـ 05 ويحتوي على 10 أرقام)');
    }
    
    // التحقق من المبالغ
    const discountAmount = parseFloat(document.querySelector('input[name="discount_amount"]').value) || 0;
    let subtotal = 0;
    if (orderItems && orderItems.length > 0) {
        subtotal = orderItems.reduce((sum, item) => sum + (item.quantity * item.unit_price), 0);
    }
    
    if (discountAmount > subtotal) {
        errors.push('مبلغ الخصم لا يمكن أن يكون أكبر من المجموع الفرعي');
    }
    
    // عرض الأخطاء إن وجدت
    if (errors.length > 0) {
        e.preventDefault();
        const errorMessage = 'يرجى تصحيح الأخطاء التالية:\n\n' +
                           errors.map((error, index) => `${index + 1}. ${error}`).join('\n');
        showNotification(errorMessage, 'error');
        highlightInvalidFields();
        
        console.error('❌ Form validation failed:', errors);
        return false;
    }
    
    // تحديث الحقول المخفية قبل الإرسال (التأكد النهائي)
    const finalUpdateResult = updateHiddenFormInputs();
    if (!finalUpdateResult) {
        e.preventDefault();
        showNotification('خطأ في إعداد بيانات النموذج للإرسال', 'error');
        return false;
    }
    
    console.log('✅ Form validation passed successfully');
    console.log('📋 Final form data check:', {
        orderItems: orderItems,
        hiddenInputs: hiddenItemsContainer.children.length,
        customerName: customerName,
        orderType: orderType,
        subtotal: subtotal
    });
    
    return true;
}

// التحقق من صحة رقم الهاتف السعودي
function isValidPhoneNumber(phone) {
    const phoneRegex = /^05[0-9]{8}$/;
    return phoneRegex.test(phone.replace(/\s+/g, ''));
}

// إبراز الحقول غير الصحيحة
function highlightInvalidFields() {
    // إزالة التأثيرات السابقة
    document.querySelectorAll('.is-invalid').forEach(field => {
        field.classList.remove('is-invalid');
    });
    
    // التحقق من الحقول المطلوبة
    const customerName = document.querySelector('input[name="customer_name"]');
    const customerPhone = document.querySelector('input[name="customer_phone"]');
    const tableNumber = document.querySelector('input[name="table_number"]');
    const orderType = document.querySelector('select[name="order_type"]');
    
    if (orderType.value === 'dine_in' && !tableNumber.value) {
        tableNumber.classList.add('is-invalid');
    }
    
    if (!customerName.value.trim()) {
        customerName.classList.add('is-invalid');
    }
    
    if (customerPhone.value.trim() && !isValidPhoneNumber(customerPhone.value.trim())) {
        customerPhone.classList.add('is-invalid');
    }
    
    // إضافة مؤقت لإزالة التأثير
    setTimeout(() => {
        document.querySelectorAll('.is-invalid').forEach(field => {
            field.classList.remove('is-invalid');
        });
    }, 5000);
}

// دوال modal الطباعة بعد الحفظ
function showPrintModal(invoiceData) {
    // تحديث بيانات الفاتورة في modal
    document.getElementById('invoice-number-display').textContent = invoiceData.invoice_number || '#INV-' + Date.now();
    document.getElementById('final-total-display').textContent = invoiceData.total_amount + ' ر.س';
    
    // تحديث حالة الدفع
    const paymentStatusElement = document.getElementById('payment-status-display');
    if (invoiceData.paid_amount >= invoiceData.total_amount) {
        paymentStatusElement.textContent = 'مدفوع بالكامل';
        paymentStatusElement.className = 'badge bg-success';
    } else if (invoiceData.paid_amount > 0) {
        paymentStatusElement.textContent = 'مدفوع جزئياً';
        paymentStatusElement.className = 'badge bg-warning';
    } else {
        paymentStatusElement.textContent = 'غير مدفوع';
        paymentStatusElement.className = 'badge bg-danger';
    }
    
    // حفظ رقم الفاتورة للاستخدام في الدوال الأخرى
    window.currentInvoiceId = invoiceData.id;
    
    $('#printModal').modal('show');
}

// طباعة الفاتورة
function printInvoice() {
    if (window.currentInvoiceId) {
        // فتح نافذة الطباعة
        window.open(`/invoices/${window.currentInvoiceId}/print`, '_blank');
    } else {
        showNotification('خطأ في العثور على رقم الفاتورة', 'error');
    }
}

// عرض الفاتورة
function viewInvoice() {
    if (window.currentInvoiceId) {
        // الانتقال لصفحة عرض الفاتورة
        window.location.href = `/invoices/${window.currentInvoiceId}`;
    } else {
        showNotification('خطأ في العثور على رقم الفاتورة', 'error');
    }
}

// بدء طلب جديد
function startNewOrder() {
    // إخفاء modal الطباعة
    $('#printModal').modal('hide');
    
    // مسح البيانات المحفوظة
    sessionStorage.removeItem('invoiceData');
    window.currentInvoiceId = null;
    
    // إعادة تعيين النموذج
    resetOrderForm();
    
    showNotification('تم بدء طلب جديد', 'success');
}

// إعادة تعيين نموذج الطلب
function resetOrderForm() {
    // مسح العناصر
    orderItems = [];
    itemIndex = 0;
    
    // إعادة تعيين النموذج
    document.getElementById('restaurant-pos-form').reset();
    document.querySelector('input[name="paid_amount"]').value = '0';
    document.querySelector('input[name="customer_id"]').value = '';
    
    // إعادة تعيين طريقة الدفع
    selectPaymentMethod('cash');
    
    // تحديث العرض
    updateOrderDisplay();
    calculateTotals();
    
    // إعادة تعيين نوع الطلب
    document.querySelector('select[name="order_type"]').value = 'dine_in';
    handleOrderTypeChange.call(document.querySelector('select[name="order_type"]'));
    
    // إعادة تعيين الفئة النشطة
    switchCategory('all');
    
    // مسح البحث
    clearSearch();
}

// معالجة نجاح الحفظ (يتم استدعاؤها من الصفحة بعد إعادة التوجيه)
function handleSaveSuccess() {
    // التحقق من وجود بيانات محفوظة في session storage
    const savedData = sessionStorage.getItem('invoiceData');
    if (savedData) {
        const invoiceData = JSON.parse(savedData);
        // إضافة بيانات افتراضية للعرض
        invoiceData.id = window.newInvoiceId || Date.now();
        invoiceData.invoice_number = window.newInvoiceNumber || '#INV-' + Date.now();
        invoiceData.total_amount = invoiceData.total;
        invoiceData.paid_amount = 0; // لأننا حفظنا بدون دفع
        
        showPrintModal(invoiceData);
    }
}

// عرض الإشعارات المحسنة
function showNotification(message, type = 'info') {
    const notification = document.createElement('div');
    const typeIcons = {
        'success': 'fas fa-check-circle',
        'error': 'fas fa-exclamation-circle',
        'warning': 'fas fa-exclamation-triangle',
        'info': 'fas fa-info-circle'
    };
    
    const typeColors = {
        'success': 'success',
        'error': 'danger',
        'warning': 'warning',
        'info': 'info'
    };
    
    notification.className = `alert alert-${typeColors[type]} alert-dismissible fade show position-fixed`;
    notification.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 350px; max-width: 500px; white-space: pre-line;';
    
    const icon = typeIcons[type] || 'fas fa-info-circle';
    
    notification.innerHTML = `
        <i class="${icon} me-2"></i>
        <span>${message}</span>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    
    document.body.appendChild(notification);
    
    // تشغيل صوت إشعار للنجاح
    if (type === 'success') {
        try {
            // يمكن إضافة صوت هنا إذا أردت
            console.log('✅ عملية ناجحة:', message);
        } catch (e) {
            // تجاهل أخطاء الصوت
        }
    }
    
    const duration = type === 'success' ? 7000 : 5000;
    setTimeout(() => {
        if (notification.parentNode) {
            notification.classList.remove('show');
            setTimeout(() => {
                if (notification.parentNode) {
                    notification.remove();
                }
            }, 150);
        }
    }, duration);
}

// التحقق من نجاح الحفظ عند تحميل الصفحة
document.addEventListener('DOMContentLoaded', function() {
    // إذا كان هناك flash message يشير لنجاح الحفظ، عرض modal الطباعة
    if (window.invoiceSaved) {
        setTimeout(handleSaveSuccess, 500);
    }
});

// Advanced Calculator JavaScript
let calcDisplay = '';
let calcCurrentOperation = '';
let calcPrevValue = '';
let calcMemory = 0;
let calcWaitingForValue = false;
let calcHistory = '';

// Open Calculator Modal - Make immediately available globally
function openCalculator() {
    $('#calculatorModal').modal('show');
    updateCalculatorDisplay();
}

// Make calculator functions globally accessible immediately
window.openCalculator = openCalculator;

// Ensure the function is available before DOM loads
if (typeof window.openCalculator !== 'function') {
    window.openCalculator = function() {
        $('#calculatorModal').modal('show');
        updateCalculatorDisplay();
    };
}

// Update Calculator Display
function updateCalculatorDisplay() {
    const displayElement = document.getElementById('calc-display');
    const operationElement = document.getElementById('calc-operation');
    const historyElement = document.getElementById('calc-history');
    
    displayElement.textContent = calcDisplay || '0';
    operationElement.textContent = calcCurrentOperation;
    historyElement.textContent = calcHistory;
    
    // Add memory indicator if memory has value
    const memoryIndicator = document.querySelector('.memory-indicator');
    if (calcMemory !== 0) {
        if (!memoryIndicator) {
            const indicator = document.createElement('div');
            indicator.className = 'memory-indicator active';
            indicator.textContent = 'M';
            document.querySelector('.calculator-display-container').appendChild(indicator);
        } else {
            memoryIndicator.classList.add('active');
        }
    } else if (memoryIndicator) {
        memoryIndicator.classList.remove('active');
    }
}

// Calculator Number Input
function calcNumber(num) {
    addButtonPressEffect(event.target);
    
    if (calcWaitingForValue) {
        calcDisplay = num;
        calcWaitingForValue = false;
    } else {
        calcDisplay = calcDisplay === '0' ? num : calcDisplay + num;
    }
    
    updateCalculatorDisplay();
}

// Calculator Decimal Point
function calcDecimal() {
    addButtonPressEffect(event.target);
    
    if (calcWaitingForValue) {
        calcDisplay = '0.';
        calcWaitingForValue = false;
    } else if (calcDisplay.indexOf('.') === -1) {
        calcDisplay += '.';
    }
    
    updateCalculatorDisplay();
}

// Calculator Operations
function calcOperation(op) {
    addButtonPressEffect(event.target);
    
    const inputValue = parseFloat(calcDisplay);
    
    if (calcPrevValue === '') {
        calcPrevValue = inputValue;
    } else if (calcCurrentOperation) {
        const result = performCalculation();
        calcDisplay = String(result);
        calcPrevValue = result;
    }
    
    calcWaitingForValue = true;
    calcCurrentOperation = op;
    updateCalculatorDisplay();
}

// Calculator Equals
function calcEquals() {
    addButtonPressEffect(event.target);
    
    const inputValue = parseFloat(calcDisplay);
    
    if (calcPrevValue !== '' && calcCurrentOperation) {
        const result = performCalculation();
        calcHistory = `${calcPrevValue} ${calcCurrentOperation} ${inputValue} = ${result}`;
        calcDisplay = String(result);
        calcPrevValue = '';
        calcCurrentOperation = '';
        calcWaitingForValue = true;
    }
    
    updateCalculatorDisplay();
}

// Perform Calculation
function performCalculation() {
    const prev = parseFloat(calcPrevValue);
    const current = parseFloat(calcDisplay);
    
    try {
        switch (calcCurrentOperation) {
            case '+':
                return prev + current;
            case '-':
                return prev - current;
            case '×':
                return prev * current;
            case '÷':
                if (current === 0) {
                    throw new Error('Division by zero');
                }
                return prev / current;
            default:
                return current;
        }
    } catch (error) {
        showCalculatorError('خطأ في العملية');
        return 0;
    }
}

// Calculator Clear
function calcClear() {
    addButtonPressEffect(event.target);
    calcDisplay = '';
    calcCurrentOperation = '';
    calcPrevValue = '';
    calcWaitingForValue = false;
    calcHistory = '';
    updateCalculatorDisplay();
}

// Calculator Clear Entry
function calcClearEntry() {
    addButtonPressEffect(event.target);
    calcDisplay = '';
    updateCalculatorDisplay();
}

// Calculator Backspace
function calcBackspace() {
    addButtonPressEffect(event.target);
    
    if (calcDisplay.length > 1) {
        calcDisplay = calcDisplay.slice(0, -1);
    } else {
        calcDisplay = '';
    }
    
    updateCalculatorDisplay();
}

// Scientific Functions
function calcFunction(func) {
    addButtonPressEffect(event.target);
    
    const value = parseFloat(calcDisplay) || 0;
    let result;
    
    try {
        switch (func) {
            case 'sin':
                result = Math.sin(value * Math.PI / 180);
                break;
            case 'cos':
                result = Math.cos(value * Math.PI / 180);
                break;
            case 'tan':
                result = Math.tan(value * Math.PI / 180);
                break;
            case 'log':
                if (value <= 0) throw new Error('Invalid input for log');
                result = Math.log10(value);
                break;
            case 'ln':
                if (value <= 0) throw new Error('Invalid input for ln');
                result = Math.log(value);
                break;
            case 'sqrt':
                if (value < 0) throw new Error('Invalid input for sqrt');
                result = Math.sqrt(value);
                break;
            case 'power':
                result = Math.pow(value, 2);
                break;
            case 'factorial':
                if (value < 0 || value > 170) throw new Error('Invalid input for factorial');
                result = factorial(Math.floor(value));
                break;
            case 'percent':
                result = value / 100;
                break;
            case 'pi':
                result = Math.PI;
                break;
            default:
                result = value;
        }
        
        calcHistory = `${func}(${value}) = ${result}`;
        calcDisplay = String(result);
        calcWaitingForValue = true;
        
    } catch (error) {
        showCalculatorError('خطأ في الدالة');
        return;
    }
    
    updateCalculatorDisplay();
}

// Factorial Function
function factorial(n) {
    if (n <= 1) return 1;
    return n * factorial(n - 1);
}

// Memory Functions
function calcMemoryClear() {
    addButtonPressEffect(event.target);
    calcMemory = 0;
    updateCalculatorDisplay();
    showNotification('تم مسح الذاكرة', 'info');
}

function calcMemoryRecall() {
    addButtonPressEffect(event.target);
    calcDisplay = String(calcMemory);
    calcWaitingForValue = true;
    updateCalculatorDisplay();
}

function calcMemoryAdd() {
    addButtonPressEffect(event.target);
    calcMemory += parseFloat(calcDisplay) || 0;
    updateCalculatorDisplay();
    showNotification('تم إضافة القيمة للذاكرة', 'success');
}

function calcMemorySubtract() {
    addButtonPressEffect(event.target);
    calcMemory -= parseFloat(calcDisplay) || 0;
    updateCalculatorDisplay();
    showNotification('تم طرح القيمة من الذاكرة', 'success');
}

function calcMemoryStore() {
    addButtonPressEffect(event.target);
    calcMemory = parseFloat(calcDisplay) || 0;
    updateCalculatorDisplay();
    showNotification('تم حفظ القيمة في الذاكرة', 'success');
}

// Quick Actions
function insertToDiscount() {
    const value = parseFloat(calcDisplay) || 0;
    if (value > 0) {
        document.querySelector('input[name="discount_amount"]').value = value.toFixed(2);
        calculateTotals();
        showNotification(`تم إدراج ${value.toFixed(2)} في حقل الخصم`, 'success');
        $('#calculatorModal').modal('hide');
    } else {
        showNotification('يجب أن تكون القيمة أكبر من صفر', 'warning');
    }
}

function copyResult() {
    const value = calcDisplay || '0';
    
    // نسخ للحافظة
    if (navigator.clipboard) {
        navigator.clipboard.writeText(value).then(() => {
            showNotification('تم نسخ النتيجة للحافظة', 'success');
        }).catch(() => {
            fallbackCopyTextToClipboard(value);
        });
    } else {
        fallbackCopyTextToClipboard(value);
    }
}

// Fallback copy function
function fallbackCopyTextToClipboard(text) {
    const textArea = document.createElement('textarea');
    textArea.value = text;
    textArea.style.position = 'fixed';
    textArea.style.left = '-999999px';
    textArea.style.top = '-999999px';
    document.body.appendChild(textArea);
    textArea.focus();
    textArea.select();
    
    try {
        document.execCommand('copy');
        showNotification('تم نسخ النتيجة للحافظة', 'success');
    } catch (err) {
        showNotification('فشل في نسخ النتيجة', 'error');
    }
    
    document.body.removeChild(textArea);
}

// Show Calculator Error
function showCalculatorError(message) {
    const displayElement = document.getElementById('calc-display');
    displayElement.textContent = 'خطأ';
    displayElement.classList.add('error');
    
    setTimeout(() => {
        displayElement.classList.remove('error');
        calcClear();
    }, 100);
    
    showNotification(message, 'error');
}

// Add Button Press Effect
function addButtonPressEffect(button) {
    button.classList.add('pressed');
    setTimeout(() => {
        button.classList.remove('pressed');
    }, 100);
}

// Keyboard Support for Calculator
document.addEventListener('keydown', function(e) {
    if (!document.getElementById('calculatorModal').classList.contains('show')) return;
    
    e.preventDefault();
    
    const key = e.key;
    
    if (/[0-9]/.test(key)) {
        calcNumber(key);
    } else if (key === '.') {
        calcDecimal();
    } else if (key === '+') {
        calcOperation('+');
    } else if (key === '-') {
        calcOperation('-');
    } else if (key === '*') {
        calcOperation('×');
    } else if (key === '/') {
        calcOperation('÷');
    } else if (key === 'Enter' || key === '=') {
        calcEquals();
    } else if (key === 'Escape') {
        calcClear();
    } else if (key === 'Backspace') {
        calcBackspace();
    }
});

// Initialize Calculator on Modal Show
$('#calculatorModal').on('shown.bs.modal', function() {
    calcClear();
    updateCalculatorDisplay();
});

// Print Last Invoice Function
function printLastInvoice() {
    console.log('🖨️ Print last invoice clicked');
    
    // Show loading state
    const button = event.target.closest('button');
    const originalContent = button.innerHTML;
    button.disabled = true;
    button.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>جاري البحث عن آخر فاتورة...';
    
    // First try to get from current session (if user just created an invoice)
    if (window.currentInvoiceId || window.newInvoiceId) {
        const invoiceId = window.currentInvoiceId || window.newInvoiceId;
        const printUrl = `/invoices/${invoiceId}/print`;
        
        console.log('✅ Found invoice in current session:', invoiceId);
        
        // Restore button state
        button.disabled = false;
        button.innerHTML = originalContent;
        
        window.open(printUrl, '_blank');
        showNotification('تم فتح نافذة طباعة الفاتورة الحالية', 'success');
        return;
    }
    
    // Try to fetch last invoice from backend, with fallback handling
    fetch('/invoices/last', {
        method: 'GET',
        headers: {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'X-Requested-With': 'XMLHttpRequest',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
        }
    })
    .then(response => {
        console.log('🌐 API Response status:', response.status);
        
        // Restore button state
        button.disabled = false;
        button.innerHTML = originalContent;
        
        if (response.status === 404) {
            // Route not found - show informative message
            showNotification(
                'ميزة "طباعة آخر فاتورة" غير متاحة حالياً\n' +
                'يرجى:\n' +
                '1️⃣ إنشاء فاتورة جديدة أولاً\n' +
                '2️⃣ أو الانتقال لقائمة الفواتير لطباعة فاتورة موجودة\n' +
                '3️⃣ التواصل مع المطور لتفعيل هذه الميزة',
                'info'
            );
            return;
        }
        
        if (!response.ok) {
            throw new Error(`HTTP error! status: ${response.status}`);
        }
        
        return response.json();
    })
    .then(data => {
        if (!data) return; // Handle case where response was 404
        
        console.log('📄 Last invoice data received:', data);
        
        if (data.success && data.data) {
            const invoice = data.data;
            
            // Show invoice details and print options
            showLastInvoicePrintModal(invoice);
            
        } else {
            showNotification(
                data.message || 'لا توجد فواتير في النظام\nأنشئ فاتورة جديدة أولاً',
                'warning'
            );
        }
    })
    .catch(error => {
        console.error('❌ Error fetching last invoice:', error);
        
        // Restore button state
        button.disabled = false;
        button.innerHTML = originalContent;
        
        // Check if it's a network error or route not found
        if (error.message.includes('404')) {
            showNotification(
                'ميزة "طباعة آخر فاتورة" غير مُفعّلة\n' +
                'يرجى التواصل مع المطور لإضافة المسار المطلوب:\n' +
                'Route::get(\'/invoices/last\', [InvoiceController::class, \'getLastInvoice\']);',
                'warning'
            );
        } else {
            showNotification(
                'حدث خطأ أثناء البحث عن آخر فاتورة\n' +
                'تفاصيل الخطأ: ' + error.message + '\n' +
                'يرجى المحاولة مرة أخرى',
                'error'
            );
        }
    });
}

// Show Last Invoice Print Modal
function showLastInvoicePrintModal(invoice) {
    console.log('📋 Showing print modal for invoice:', invoice.invoice_number);
    
    // Create modal for last invoice print options
    const printModal = document.createElement('div');
    printModal.className = 'modal fade';
    printModal.id = 'lastInvoicePrintModal';
    printModal.innerHTML = `
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title">
                        <i class="fas fa-print me-2"></i>
                        طباعة آخر فاتورة
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="text-center mb-4">
                        <i class="fas fa-receipt fa-3x text-primary mb-3"></i>
                        <h4>فاتورة رقم: ${invoice.invoice_number}</h4>
                        <p class="text-muted">آخر فاتورة في النظام</p>
                    </div>
                    
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="info-card">
                                <h6 class="text-muted">العميل</h6>
                                <strong>${invoice.customer_name || 'غير محدد'}</strong>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="info-card">
                                <h6 class="text-muted">التاريخ</h6>
                                <strong>${new Date(invoice.created_at).toLocaleDateString('ar-SA')}</strong>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="info-card">
                                <h6 class="text-muted">المبلغ الإجمالي</h6>
                                <strong class="text-success">${parseFloat(invoice.total_amount).toFixed(2)} ر.س</strong>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="info-card">
                                <h6 class="text-muted">حالة الدفع</h6>
                                <span class="badge ${invoice.payment_status === 'paid' ? 'bg-success' : invoice.payment_status === 'partial' ? 'bg-warning' : 'bg-danger'}">
                                    ${invoice.payment_status === 'paid' ? 'مدفوع' : invoice.payment_status === 'partial' ? 'مدفوع جزئياً' : 'غير مدفوع'}
                                </span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="alert alert-info" role="alert">
                        <i class="fas fa-info-circle me-2"></i>
                        <strong>عدد العناصر:</strong> ${invoice.items_count || 0} عنصر
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times me-2"></i>
                        إلغاء
                    </button>
                    <button type="button" class="btn btn-info" onclick="openInvoiceView(${invoice.id})">
                        <i class="fas fa-eye me-2"></i>
                        عرض الفاتورة
                    </button>
                    <button type="button" class="btn btn-success" onclick="printSpecificInvoice(${invoice.id}, 'thermal')">
                        <i class="fas fa-print me-2"></i>
                        طباعة حرارية
                    </button>
                    <button type="button" class="btn btn-primary" onclick="printSpecificInvoice(${invoice.id}, 'regular')">
                        <i class="fas fa-print me-2"></i>
                        طباعة عادية
                    </button>
                </div>
            </div>
        </div>
    `;
    
    // Add modal to page and show it
    document.body.appendChild(printModal);
    $(printModal).modal('show');
    
    // Remove modal when hidden
    $(printModal).on('hidden.bs.modal', function() {
        printModal.remove();
    });
    
    showNotification(
        `تم العثور على آخر فاتورة: ${invoice.invoice_number}\n` +
        `العميل: ${invoice.customer_name || 'غير محدد'}\n` +
        `المبلغ: ${parseFloat(invoice.total_amount).toFixed(2)} ر.س`,
        'success'
    );
}

// Print Specific Invoice
function printSpecificInvoice(invoiceId, printType = 'regular') {
    console.log('🖨️ Printing invoice:', invoiceId, 'Type:', printType);
    
    let printUrl = `/invoices/${invoiceId}/print`;
    if (printType === 'thermal') {
        printUrl += '?type=thermal';
    }
    
    // Close the modal
    $('#lastInvoicePrintModal').modal('hide');
    
    // Open print window
    window.open(printUrl, '_blank');
    
    showNotification(`تم فتح نافذة الطباعة ${printType === 'thermal' ? 'الحرارية' : 'العادية'}`, 'success');
}

// Open Invoice View
function openInvoiceView(invoiceId) {
    console.log('👁️ Opening invoice view:', invoiceId);
    
    // Close the modal
    $('#lastInvoicePrintModal').modal('hide');
    
    // Open invoice view in new tab
    window.open(`/invoices/${invoiceId}`, '_blank');
}

// Make function globally accessible
window.printLastInvoice = printLastInvoice;

// Logout Functions
function showLogoutModal() {
    console.log('🚪 Logout modal requested');
    
    try {
        // التحقق من وجود طلب حالي غير محفوظ
        const orderWarning = document.getElementById('logout-order-warning');
        
        if (orderWarning) {
            if (orderItems && orderItems.length > 0) {
                orderWarning.style.display = 'block';
            } else {
                orderWarning.style.display = 'none';
            }
        } else {
            console.warn('⚠️ Element "logout-order-warning" not found in DOM');
        }
        
        // عرض modal التأكيد
        $('#logoutModal').modal('show');
        
    } catch (error) {
        console.error('❌ Error in showLogoutModal:', error);
        
        // عرض modal بدون التحقق من التحذير
        $('#logoutModal').modal('show');
    }
}

// تأكيد تسجيل الخروج
function confirmLogout() {
    console.log('🚪 Logout confirmed');
    
    // إظهار مؤشر التحميل
    const confirmBtn = event.target;
    const originalContent = confirmBtn.innerHTML;
    confirmBtn.disabled = true;
    confirmBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>جاري تسجيل الخروج...';
    
    // إضافة تأخير قصير للتأثير البصري
    setTimeout(() => {
        // إنشاء نموذج مخفي لتسجيل الخروج
        const logoutForm = document.createElement('form');
        logoutForm.method = 'POST';
        logoutForm.action = '/logout';
        logoutForm.style.display = 'none';
        
        // إضافة CSRF token
        const csrfToken = document.createElement('input');
        csrfToken.type = 'hidden';
        csrfToken.name = '_token';
        csrfToken.value = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || '';
        logoutForm.appendChild(csrfToken);
        
        // إضافة النموذج للصفحة وإرساله
        document.body.appendChild(logoutForm);
        logoutForm.submit();
        
    }, 100);
}

// إضافة دالة للتحقق من وجود طلب قبل المغادرة - تم إلغاؤها
// window.addEventListener('beforeunload', function(e) {
//     if (orderItems && orderItems.length > 0) {
//         const message = 'يوجد طلب حالي لم يتم حفظه. هل أنت متأكد من المغادرة؟';
//         e.returnValue = message;
//         return message;
//     }
// });

// مزامنة قيم الخصم بين الهيدر والنموذج الأصلي
function syncDiscountValues(source) {
    const headerDiscountInput = document.querySelector('input[name="discount_amount_header"]');
    const originalDiscountInput = document.querySelector('input[name="discount_amount"]');
    
    if (source.name === 'discount_amount_header') {
        // نسخ القيمة من الهيدر إلى النموذج الأصلي
        if (originalDiscountInput) {
            originalDiscountInput.value = source.value;
        }
    } else {
        // نسخ القيمة من النموذج الأصلي إلى الهيدر
        if (headerDiscountInput) {
            headerDiscountInput.value = source.value;
        }
    }
    
    // إعادة حساب الإجماليات
    calculateTotals();
}

// تحديث دالة حساب الإجماليات للعمل مع الهيدر والشريط الجانبي
const originalCalculateTotals = calculateTotals;
calculateTotals = function() {
    let subtotal = 0;
    
    orderItems.forEach(item => {
        const lineTotal = (item.quantity * item.unit_price) - item.discount_amount;
        subtotal += lineTotal;
    });
    
    const discount = parseFloat(document.querySelector('input[name="discount_amount"]').value) || 0;
    const taxableAmount = Math.max(0, subtotal - discount);
    const taxAmount = taxableAmount * 0.15; // 15% ضريبة
    const total = taxableAmount + taxAmount;
    
    // تحديث العرض في القسم الأصلي (الشريط الجانبي)
    const subtotalDisplay = document.getElementById('subtotal-display');
    const taxDisplay = document.getElementById('tax-total-display');
    const totalDisplay = document.getElementById('total-display');
    
    if (subtotalDisplay) subtotalDisplay.textContent = subtotal.toFixed(2) + ' ر.س';
    if (taxDisplay) taxDisplay.textContent = taxAmount.toFixed(2) + ' ر.س';
    if (totalDisplay) totalDisplay.textContent = total.toFixed(2) + ' ر.س';
    
    // تحديث العرض في الهيدر المضغوط
    const subtotalDisplayHeader = document.getElementById('subtotal-display-header');
    const taxDisplayHeader = document.getElementById('tax-total-display-header');
    const totalDisplayHeader = document.getElementById('total-display-header');
    
    if (subtotalDisplayHeader) subtotalDisplayHeader.textContent = subtotal.toFixed(2) + ' ر.س';
    if (taxDisplayHeader) taxDisplayHeader.textContent = taxAmount.toFixed(2) + ' ر.س';
    if (totalDisplayHeader) totalDisplayHeader.textContent = total.toFixed(2) + ' ر.س';
    
    // مزامنة قيم الخصم بين الهيدر والشريط الجانبي
    const headerDiscountInput = document.querySelector('input[name="discount_amount_header"]');
    const originalDiscountInput = document.querySelector('input[name="discount_amount"]');
    
    if (headerDiscountInput && originalDiscountInput) {
        if (headerDiscountInput.value !== originalDiscountInput.value) {
            headerDiscountInput.value = originalDiscountInput.value;
        }
    }
};

// جعل الدوال متاحة عالمياً
window.showLogoutModal = showLogoutModal;
window.confirmLogout = confirmLogout;
window.syncDiscountValues = syncDiscountValues;

// Add Product Modal Functions
function openAddProductModal() {
    // إعادة تعيين النموذج
    document.getElementById('addProductForm').reset();
    clearImage();
    hideProductPreview();
    updateCharacterCount();
    
    // عرض النافذة
    $('#addProductModal').modal('show');
    
    // التركيز على حقل الباركود
    setTimeout(() => {
        document.getElementById('product-barcode').focus();
    }, 500);
}

// تحديث عداد الأحرف لاسم المنتج
function updateCharacterCount() {
    const nameInput = document.getElementById('product-name');
    const counter = document.getElementById('name-char-count');
    
    if (nameInput && counter) {
        const currentLength = nameInput.value.length;
        counter.textContent = currentLength;
        
        // تغيير لون العداد حسب الطول
        counter.parentElement.classList.remove('warning', 'danger');
        if (currentLength > 200) {
            counter.parentElement.classList.add('danger');
        } else if (currentLength > 150) {
            counter.parentElement.classList.add('warning');
        }
    }
}

// معاينة الصورة
function previewImage(input) {
    const file = input.files[0];
    const preview = document.getElementById('image-preview');
    const placeholder = document.getElementById('image-placeholder');
    const clearBtn = document.getElementById('clear-image-btn');
    
    if (file) {
        // التحقق من نوع الملف
        if (!file.type.match('image.*')) {
            showNotification('يرجى اختيار ملف صورة صالح', 'error');
            input.value = '';
            return;
        }
        
        // التحقق من حجم الملف (2MB)
        if (file.size > 2 * 1024 * 1024) {
            showNotification('حجم الصورة يجب أن يكون أقل من 2 ميجابايت', 'error');
            input.value = '';
            return;
        }
        
        const reader = new FileReader();
        reader.onload = function(e) {
            preview.src = e.target.result;
            preview.style.display = 'block';
            placeholder.style.display = 'none';
            clearBtn.style.display = 'block';
            
            updateProductPreview();
        };
        reader.readAsDataURL(file);
    }
}

// مسح الصورة
function clearImage() {
    const input = document.getElementById('product-image');
    const preview = document.getElementById('image-preview');
    const placeholder = document.getElementById('image-placeholder');
    const clearBtn = document.getElementById('clear-image-btn');
    
    input.value = '';
    preview.src = '';
    preview.style.display = 'none';
    placeholder.style.display = 'flex';
    clearBtn.style.display = 'none';
    
    updateProductPreview();
}

// توليد باركود عشوائي
function generateBarcode() {
    const timestamp = Date.now();
    const random = Math.floor(Math.random() * 1000);
    const barcode = `${timestamp}${random}`.substring(0, 13);
    
    document.getElementById('product-barcode').value = barcode;
    updateProductPreview();
}

// تبديل عرض المعاينة
function togglePreview() {
    const previewSection = document.getElementById('product-preview-section');
    const previewBtn = document.querySelector('.btn-preview');
    
    if (previewSection.style.display === 'none') {
        updateProductPreview();
        previewSection.style.display = 'block';
        previewBtn.innerHTML = '<i class="fas fa-eye-slash me-2"></i>إخفاء المعاينة';
    } else {
        previewSection.style.display = 'none';
        previewBtn.innerHTML = '<i class="fas fa-eye me-2"></i>معاينة';
    }
}

// إخفاء المعاينة
function hideProductPreview() {
    const previewSection = document.getElementById('product-preview-section');
    const previewBtn = document.querySelector('.btn-preview');
    
    previewSection.style.display = 'none';
    previewBtn.innerHTML = '<i class="fas fa-eye me-2"></i>معاينة';
}

// تحديث معاينة المنتج
function updateProductPreview() {
    const name = document.getElementById('product-name').value || 'اسم المنتج';
    const price = document.getElementById('product-price').value || '0.00';
    const sku = document.getElementById('product-sku').value || 'رمز المنتج';
    const imagePreview = document.getElementById('image-preview');
    
    // تحديث النصوص
    if (document.getElementById('preview-product-name')) {
        document.getElementById('preview-product-name').textContent = name;
    }
    if (document.getElementById('preview-product-price')) {
        document.getElementById('preview-product-price').textContent = parseFloat(price).toFixed(2) + ' ر.س';
    }
    if (document.getElementById('preview-product-code')) {
        document.getElementById('preview-product-code').textContent = sku;
    }
    
    // تحديث الصورة
    const previewProductImage = document.getElementById('preview-product-image');
    const previewPlaceholder = document.getElementById('preview-placeholder');
    
    if (previewProductImage && previewPlaceholder) {
        if (imagePreview && imagePreview.src && imagePreview.style.display === 'block') {
            previewProductImage.src = imagePreview.src;
            previewProductImage.style.display = 'block';
            previewPlaceholder.style.display = 'none';
        } else {
            previewProductImage.style.display = 'none';
            previewPlaceholder.style.display = 'flex';
        }
    }
}

// إدارة حقول المخزون حسب نوع المنتج
function handleProductTypeChange() {
    const productType = document.getElementById('product-type').value;
    const stockFields = document.getElementById('stock-fields');
    const stockInput = document.getElementById('product-stock');
    const minStockInput = document.getElementById('product-min-stock');
    
    if (productType === 'service') {
        // إخفاء حقول المخزون للخدمات
        if (stockFields) {
            stockFields.style.display = 'none';
        }
        
        // إزالة خاصية required وتعيين قيم افتراضية
        if (stockInput) {
            stockInput.required = false;
            stockInput.value = '0';
        }
        if (minStockInput) {
            minStockInput.required = false;
            minStockInput.value = '0';
        }
        
        console.log('📋 Product type changed to service - stock fields hidden');
    } else {
        // إظهار حقول المخزون للمنتجات
        if (stockFields) {
            stockFields.style.display = 'block';
        }
        
        // إضافة خاصية required وتعيين قيم افتراضية
        if (stockInput) {
            stockInput.required = true;
            if (!stockInput.value || stockInput.value === '0') {
                stockInput.value = '1';
            }
        }
        if (minStockInput) {
            minStockInput.required = true;
            if (!minStockInput.value || minStockInput.value === '0') {
                minStockInput.value = '5';
            }
        }
        
        console.log('📋 Product type changed to product - stock fields shown');
    }
    
    // تحديث المعاينة
    updateProductPreview();
}

// التحقق من صحة النموذج
function validateProductForm() {
    console.log('🔍 Validating product form...');
    
    const barcode = document.getElementById('product-barcode').value.trim();
    const sku = document.getElementById('product-sku').value.trim();
    const name = document.getElementById('product-name').value.trim();
    const type = document.getElementById('product-type').value;
    const price = document.getElementById('product-price').value;
    const taxRate = document.getElementById('product-tax-rate').value;
    const unit = document.getElementById('product-unit').value;
    const stockQuantity = document.getElementById('product-stock').value;
    const minStock = document.getElementById('product-min-stock').value;
    
    const errors = [];
    
    // التحقق من رمز المنتج (SKU) - مطلوب
    if (!sku) {
        errors.push('رمز المنتج (SKU) مطلوب');
    } else if (sku.length < 2) {
        errors.push('رمز المنتج يجب أن يكون على الأقل حرفين');
    }
    
    // التحقق من اسم المنتج - مطلوب
    if (!name) {
        errors.push('اسم المنتج مطلوب');
    } else if (name.length < 2) {
        errors.push('اسم المنتج يجب أن يكون على الأقل حرفين');
    } else if (name.length > 255) {
        errors.push('اسم المنتج يجب أن يكون أقل من 255 حرف');
    }
    
    // التحقق من نوع المنتج - مطلوب
    if (!type) {
        errors.push('نوع المنتج مطلوب');
    } else if (!['product', 'service'].includes(type)) {
        errors.push('نوع المنتج يجب أن يكون "منتج" أو "خدمة"');
    }
    
    // التحقق من السعر - مطلوب
    if (!price || price === '') {
        errors.push('السعر مطلوب');
    } else {
        const priceValue = parseFloat(price);
        if (isNaN(priceValue) || priceValue < 0) {
            errors.push('السعر يجب أن يكون رقم صحيح وأكبر من أو يساوي صفر');
        } else if (priceValue > 999999.99) {
            errors.push('السعر كبير جداً (الحد الأقصى 999,999.99)');
        }
    }
    
    // التحقق من معدل الضريبة - مطلوب
    if (!taxRate || taxRate === '') {
        errors.push('معدل الضريبة مطلوب');
    } else {
        const taxValue = parseFloat(taxRate);
        if (isNaN(taxValue) || taxValue < 0 || taxValue > 100) {
            errors.push('معدل الضريبة يجب أن يكون بين 0 و 100');
        }
    }
    
    // التحقق من الوحدة - مطلوب
    if (!unit) {
        errors.push('وحدة القياس مطلوبة');
    }
    
    // التحقق من حقول المخزون (للمنتجات فقط)
    if (type === 'product') {
        if (!stockQuantity || stockQuantity === '') {
            errors.push('كمية المخزون مطلوبة للمنتجات');
        } else {
            const stockValue = parseInt(stockQuantity);
            if (isNaN(stockValue) || stockValue < 0) {
                errors.push('كمية المخزون يجب أن تكون رقم صحيح وأكبر من أو يساوي صفر');
            }
        }
        
        if (!minStock || minStock === '') {
            errors.push('الحد الأدنى للمخزون مطلوب للمنتجات');
        } else {
            const minStockValue = parseInt(minStock);
            if (isNaN(minStockValue) || minStockValue < 0) {
                errors.push('الحد الأدنى للمخزون يجب أن يكون رقم صحيح وأكبر من أو يساوي صفر');
            }
        }
    }
    
    // التحقق من الباركود (اختياري ولكن إذا تم إدخاله يجب أن يكون صحيح)
    if (barcode && barcode.length > 0) {
        if (barcode.length < 6) {
            errors.push('الباركود يجب أن يكون على الأقل 6 أرقام');
        } else if (barcode.length > 20) {
            errors.push('الباركود لا يمكن أن يكون أكثر من 20 رقم');
        } else if (!/^[0-9]+$/.test(barcode)) {
            errors.push('الباركود يجب أن يحتوي على أرقام فقط');
        }
    }
    
    // التحقق من الصورة (اختياري)
    const imageInput = document.getElementById('product-image');
    if (imageInput && imageInput.files && imageInput.files[0]) {
        const file = imageInput.files[0];
        
        // التحقق من نوع الملف
        const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif'];
        if (!allowedTypes.includes(file.type)) {
            errors.push('نوع الصورة غير مدعوم (JPG, PNG, GIF فقط)');
        }
        
        // التحقق من حجم الملف (2MB)
        if (file.size > 2 * 1024 * 1024) {
            errors.push('حجم الصورة يجب أن يكون أقل من 2 ميجابايت');
        }
    }
    
    console.log('🎯 Validation result:', {
        totalErrors: errors.length,
        errors: errors,
        formData: {
            sku: sku,
            name: name,
            type: type,
            price: price,
            taxRate: taxRate,
            unit: unit,
            hasBarcode: !!barcode,
            hasImage: !!(imageInput && imageInput.files && imageInput.files[0])
        }
    });
    
    return errors;
}

// إرسال النموذج
function submitProductForm() {
    console.log('🚀 Starting product form submission...');
    
    const errors = validateProductForm();
    
    if (errors.length > 0) {
        showNotification(
            'يرجى تصحيح الأخطاء التالية:\n\n' +
            errors.map((error, index) => `${index + 1}. ${error}`).join('\n'),
            'error'
        );
        console.error('❌ Form validation failed:', errors);
        return false;
    }
    
    const saveBtn = document.querySelector('.btn-save-product');
    const form = document.getElementById('addProductForm');
    
    // إظهار حالة التحميل
    saveBtn.classList.add('loading');
    saveBtn.disabled = true;
    
    // إنشاء FormData فارغ ثم إضافة الحقول يدوياً
    const formData = new FormData();
    
    // إضافة CSRF token
    const csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content');
    if (csrfToken) {
        formData.append('_token', csrfToken);
    }
    
    // إضافة الحقول المطلوبة حسب متطلبات الـ Controller (استخدام المعرفات الصحيحة)
    const name = form.querySelector('#product-name')?.value?.trim();
    const nameEn = form.querySelector('#product-name-en')?.value?.trim() || '';
    const description = form.querySelector('#product-description')?.value?.trim() || '';
    const sku = form.querySelector('#product-sku')?.value?.trim();
    const barcode = form.querySelector('#product-barcode')?.value?.trim() || '';
    const type = form.querySelector('#product-type')?.value;
    const categoryId = form.querySelector('#product-category')?.value || '';
    const price = form.querySelector('#product-price')?.value;
    const taxRate = form.querySelector('#product-tax-rate')?.value || '15';
    const stockQuantity = form.querySelector('#product-stock')?.value || '0';
    const minStock = form.querySelector('#product-min-stock')?.value || '0';
    const unit = form.querySelector('#product-unit')?.value?.trim() || 'قطعة';
    const zatcaCategoryCode = form.querySelector('#product-zatca-category-code')?.value?.trim() || '';
    const isTaxable = form.querySelector('#product-is-taxable')?.checked;
    const isActive = form.querySelector('#product-is-active')?.checked !== false; // default to true
    
    // إضافة الحقول المطلوبة
    if (name) formData.append('name', name);
    if (nameEn) formData.append('name_en', nameEn);
    if (description) formData.append('description', description);
    if (sku) formData.append('sku', sku);
    if (barcode) formData.append('barcode', barcode);
    if (type) formData.append('type', type);
    if (categoryId) formData.append('category_id', categoryId);
    if (price) formData.append('price', price);
    formData.append('tax_rate', taxRate);
    if (zatcaCategoryCode) formData.append('zatca_category_code', zatcaCategoryCode);
    formData.append('unit', unit);
    
    // للمنتجات المادية، أضف حقول المخزون
    if (type === 'product') {
        formData.append('stock_quantity', stockQuantity);
        formData.append('min_stock', minStock);
    }
    
    // إضافة الحقول المنطقية (Laravel يتوقع '1' أو '0')
    formData.append('is_taxable', isTaxable ? '1' : '0');
    formData.append('is_active', isActive ? '1' : '0');
    
    console.log('📝 Form data prepared with all required fields:', {
        name: formData.get('name'),
        sku: formData.get('sku'),
        price: formData.get('price'),
        type: formData.get('type'),
        tax_rate: formData.get('tax_rate'),
        unit: formData.get('unit'),
        stock_quantity: formData.get('stock_quantity'),
        min_stock: formData.get('min_stock'),
        is_taxable: formData.get('is_taxable'),
        is_active: formData.get('is_active'),
        _token: formData.get('_token') ? 'present' : 'missing'
    });
    
    // تحقق من وجود الـ action في النموذج
    const formAction = form.action || '{{ route("products.store") }}';
    console.log('🎯 Form action URL:', formAction);
    
    // إرسال البيانات بـ fetch API
    fetch(formAction, {
        method: 'POST',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        }
    })
    .then(response => {
        console.log('🌐 Response status:', response.status);
        console.log('🌐 Response headers:', [...response.headers.entries()]);
        
        // التحقق من نوع المحتوى
        const contentType = response.headers.get('content-type');
        console.log('📄 Content-Type:', contentType);
        
        if (!response.ok) {
            // For 422 errors, try to get validation errors
            if (response.status === 422) {
                if (contentType && contentType.includes('application/json')) {
                    return response.json().then(errorData => {
                        throw new Error(`Validation failed: ${JSON.stringify(errorData)}`);
                    });
                } else {
                    return response.text().then(htmlContent => {
                        console.error('🚨 Server returned HTML instead of JSON:', htmlContent.substring(0, 500));
                        throw new Error(`Server error (422): Received HTML response instead of JSON`);
                    });
                }
            }
            
            // للأخطاء الأخرى
            return response.text().then(textContent => {
                throw new Error(`HTTP error! status: ${response.status} - ${textContent.substring(0, 200)}`);
            });
        }
        
        // للاستجابات الناجحة
        if (contentType && contentType.includes('application/json')) {
            return response.json();
        } else {
            // إذا كانت الاستجابة HTML (إعادة توجيه مثلاً)
            return response.text().then(htmlContent => {
                console.log('✅ Success response (HTML):', htmlContent.substring(0, 200));
                return { success: true, message: 'Product created successfully' };
            });
        }
    })
    .then(data => {
        console.log('✅ Success response:', data);
        
        // إعادة تعيين الزر
        saveBtn.classList.remove('loading');
        saveBtn.disabled = false;
        
        // إخفاء النافذة
        $('#addProductModal').modal('hide');
        
        // عرض رسالة نجاح
        const productName = formData.get('name');
        showNotification(
            `تم إضافة المنتج "${productName}" بنجاح!\n` +
            `رمز المنتج: ${data.product?.sku || formData.get('sku')}\n` +
            `السعر: ${data.product?.price || formData.get('price')} ر.س\n` +
            'سيتم إعادة تحميل الصفحة لإظهار المنتج الجديد...',
            'success'
        );
        
        // إعادة تحميل الصفحة بعد 2 ثانية لإظهار المنتج الجديد
        setTimeout(() => {
            window.location.reload();
        }, 2000);
        
    })
    .catch(error => {
        console.error('❌ Error submitting form:', error);
        
        // إعادة تعيين الزر
        saveBtn.classList.remove('loading');
        saveBtn.disabled = false;
        
        // معالجة الأخطاء المختلفة
        let errorMessage = 'حدث خطأ أثناء إضافة المنتج\n';
        
        if (error.message.includes('Validation failed:')) {
            // استخراج تفاصيل أخطاء التحقق من الخادم
            try {
                const validationData = JSON.parse(error.message.replace('Validation failed: ', ''));
                console.log('🔍 Server validation errors:', validationData);
                
                errorMessage = 'أخطاء التحقق من الخادم:\n\n';
                
                if (validationData.errors) {
                    Object.keys(validationData.errors).forEach(field => {
                        const fieldErrors = validationData.errors[field];
                        errorMessage += `• ${field}: ${fieldErrors.join(', ')}\n`;
                    });
                } else if (validationData.message) {
                    errorMessage += validationData.message;
                } else {
                    errorMessage += 'تفاصيل الخطأ غير واضحة من الخادم';
                }
                
                errorMessage += '\n\nتأكد من:\n';
                errorMessage += '• رمز المنتج (SKU) غير مستخدم مسبقاً\n';
                errorMessage += '• جميع الحقول المطلوبة مملوءة بشكل صحيح\n';
                errorMessage += '• السعر ومعدل الضريبة أرقام صحيحة';
                
            } catch (parseError) {
                errorMessage += 'البيانات المدخلة غير صحيحة أو غير مكتملة\n';
                errorMessage += 'تأكد من:\n';
                errorMessage += '• رمز المنتج (SKU) غير مستخدم مسبقاً\n';
                errorMessage += '• جميع الحقول المطلوبة مملوءة\n';
                errorMessage += '• السعر رقم صحيح وأكبر من صفر';
            }
        } else if (error.message.includes('422')) {
            errorMessage += 'البيانات المدخلة غير صحيحة أو غير مكتملة\n';
            errorMessage += 'تأكد من:\n';
            errorMessage += '• رمز المنتج (SKU) غير مستخدم مسبقاً\n';
            errorMessage += '• جميع الحقول المطلوبة مملوءة\n';
            errorMessage += '• السعر رقم صحيح وأكبر من صفر';
        } else if (error.message.includes('413')) {
            errorMessage += 'حجم الصورة كبير جداً (الحد الأقصى 2MB)';
        } else if (error.message.includes('500')) {
            errorMessage += 'خطأ في الخادم - يرجى المحاولة مرة أخرى\n';
            errorMessage += 'إذا استمر الخطأ، تواصل مع المطور';
        } else if (error.message.includes('404')) {
            errorMessage += 'المسار غير موجود - تأكد من إعداد المسار:\n';
            errorMessage += 'Route::resource(\'products\', ProductController::class);';
        } else {
            errorMessage += `تفاصيل الخطأ: ${error.message}\n`;
            errorMessage += 'تأكد من اتصالك بالإنترنت وحاول مرة أخرى';
        }
        
        showNotification(errorMessage, 'error');
    });
    
    return false;
}

// إضافة مستمعي الأحداث عند تحميل الصفحة
document.addEventListener('DOMContentLoaded', function() {
    // مستمع عداد الأحرف
    const nameInput = document.getElementById('product-name');
    if (nameInput) {
        nameInput.addEventListener('input', updateCharacterCount);
    }
    
    // مستمعي المعاينة التلقائية
    const previewInputs = ['product-name', 'product-price', 'product-code'];
    previewInputs.forEach(inputId => {
        const input = document.getElementById(inputId);
        if (input) {
            input.addEventListener('input', updateProductPreview);
        }
    });
    
    // مستمع تغيير نوع المنتج لإخفاء/إظهار حقول المخزون
    const productTypeSelect = document.getElementById('product-type');
    if (productTypeSelect) {
        productTypeSelect.addEventListener('change', handleProductTypeChange);
        // تطبيق التغيير عند التحميل الأولي
        handleProductTypeChange();
    }
    
    // مستمع إرسال النموذج
    const form = document.getElementById('addProductForm');
    if (form) {
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            submitProductForm();
        });
    }
    
    // إعادة تعيين النموذج عند إغلاق النافذة
    $('#addProductModal').on('hidden.bs.modal', function() {
        document.getElementById('addProductForm').reset();
        clearImage();
        hideProductPreview();
        updateCharacterCount();
        // إعادة تعيين حقول المخزون للحالة الافتراضية (منتج)
        handleProductTypeChange();
    });
});

// جعل الدوال متاحة عالمياً
window.openAddProductModal = openAddProductModal;
window.previewImage = previewImage;
window.clearImage = clearImage;
window.generateBarcode = generateBarcode;
window.togglePreview = togglePreview;
</script>
@endpush