@extends('layouts.app')

@section('title', 'تقييم المخزون')
@section('page-title', 'تقرير تقييم المخزون')

@section('page-actions')
    <div class="btn-group" role="group">
        <a href="{{ route('inventory.index') }}" class="btn btn-secondary">
            <i class="fas fa-warehouse me-2"></i>
            عرض المخزون
        </a>
        <button type="button" class="btn btn-success" onclick="window.print()">
            <i class="fas fa-print me-2"></i>
            طباعة التقرير
        </button>
    </div>
@endsection

@section('content')
<!-- ملخص التقييم -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ $products->count() }}</h4>
                        <p class="mb-0">إجمالي المنتجات</p>
                    </div>
                    <div>
                        <i class="fas fa-boxes fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-info text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ number_format($products->sum(function($p) { return $p['product']->stock_quantity; })) }}</h4>
                        <p class="mb-0">إجمالي الكمية</p>
                    </div>
                    <div>
                        <i class="fas fa-cubes fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ number_format($products->avg('average_cost'), 2) }}</h4>
                        <p class="mb-0">متوسط التكلفة (ر.س)</p>
                    </div>
                    <div>
                        <i class="fas fa-calculator fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ number_format($totalInventoryValue, 2) }}</h4>
                        <p class="mb-0">إجمالي قيمة المخزون (ر.س)</p>
                    </div>
                    <div>
                        <i class="fas fa-money-bill fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- تفاصيل تقييم المخزون -->
<div class="card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fas fa-chart-pie me-2"></i>
            تفاصيل تقييم المخزون
            <small class="text-muted">- {{ now()->format('Y/m/d H:i') }}</small>
        </h5>
    </div>
    <div class="card-body">
        @if($products->count() > 0)
        <div class="table-responsive">
            <table class="table table-striped table-hover">
                    <tr>
                        <th>#</th>
                        <th>اسم المنتج</th>
                        <th>رمز المنتج</th>
                        <th>الوحدة</th>
                        <th>الكمية المتوفرة</th>
                        <th>متوسط التكلفة</th>
                        <th>إجمالي قيمة المنتج</th>
                        <th>نسبة من المخزون</th>
                        <th>حالة المخزون</th>
                    </tr>
                    @foreach($products as $index => $item)
                    @php 
                        $product = $item['product'];
                        $averageCost = $item['average_cost'];
                        $inventoryValue = $item['inventory_value'];
                        $percentage = $totalInventoryValue > 0 ? ($inventoryValue / $totalInventoryValue) * 100 : 0;
                    @endphp
                    <tr class="{{ $product->isOutOfStock() ? 'table-danger' : ($product->isLowStock() ? 'table-warning' : '') }}">
                        <td>{{ $index + 1 }}</td>
                        <td>
                            <strong>{{ $product->name }}</strong>
                            @if($product->name_en)
                                <br><small class="text-muted">{{ $product->name_en }}</small>
                            @endif
                        </td>
                        <td>{{ $product->sku }}</td>
                        <td>{{ $product->unit }}</td>
                        <td>
                            <span class="badge bg-{{ $product->isOutOfStock() ? 'danger' : ($product->isLowStock() ? 'warning' : 'success') }}">
                                {{ number_format($product->stock_quantity) }}
                            </span>
                        </td>
                        <td>{{ number_format($averageCost, 2) }} ر.س</td>
                        <td>
                            <strong>{{ number_format($inventoryValue, 2) }} ر.س</strong>
                        </td>
                        <td>
                            <div class="progress" style="height: 20px;">
                                <div class="progress-bar bg-info" role="progressbar" 
                                     style="width: {{ $percentage }}%" 
                                     aria-valuenow="{{ $percentage }}" 
                                     aria-valuemin="0" aria-valuemax="100">
                                    {{ number_format($percentage, 1) }}%
                                </div>
                            </div>
                        </td>
                        <td>
                            @if($product->isOutOfStock())
                                <span class="badge bg-danger">نافد</span>
                            @elseif($product->isLowStock())
                                <span class="badge bg-warning">منخفض</span>
                            @else
                                <span class="badge bg-success">متوفر</span>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot class="table-dark">
                    <tr>
                        <td colspan="4"><strong>الإجمالي</strong></td>
                        <td><strong>{{ number_format($products->sum(function($p) { return $p['product']->stock_quantity; })) }}</strong></td>
                        <td>-</td>
                        <td><strong>{{ number_format($totalInventoryValue, 2) }} ر.س</strong></td>
                        <td><strong>100%</strong></td>
                        <td>-</td>
                    </tr>
                </tfoot>
        </div>

        <!-- تحليل إضافي -->
        <div class="row mt-4">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0">توزيع المخزون حسب الحالة</h6>
                    </div>
                    <div class="card-body">
                        @php
                            $availableCount = $products->filter(function($p) { return !$p['product']->isLowStock(); })->count();
                            $lowStockCount = $products->filter(function($p) { return $p['product']->isLowStock() && !$p['product']->isOutOfStock(); })->count();
                            $outOfStockCount = $products->filter(function($p) { return $p['product']->isOutOfStock(); })->count();
                            $totalCount = $products->count();
                        @endphp
                        
                        <div class="mb-3">
                            <div class="d-flex justify-content-between">
                                <span>متوفر</span>
                                <span>{{ $availableCount }} ({{ $totalCount > 0 ? number_format(($availableCount / $totalCount) * 100, 1) : 0 }}%)</span>
                            </div>
                            <div class="progress">
                                <div class="progress-bar bg-success" style="width: {{ $totalCount > 0 ? ($availableCount / $totalCount) * 100 : 0 }}%"></div>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <div class="d-flex justify-content-between">
                                <span>منخفض</span>
                                <span>{{ $lowStockCount }} ({{ $totalCount > 0 ? number_format(($lowStockCount / $totalCount) * 100, 1) : 0 }}%)</span>
                            </div>
                            <div class="progress">
                                <div class="progress-bar bg-warning" style="width: {{ $totalCount > 0 ? ($lowStockCount / $totalCount) * 100 : 0 }}%"></div>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <div class="d-flex justify-content-between">
                                <span>نافد</span>
                                <span>{{ $outOfStockCount }} ({{ $totalCount > 0 ? number_format(($outOfStockCount / $totalCount) * 100, 1) : 0 }}%)</span>
                            </div>
                            <div class="progress">
                                <div class="progress-bar bg-danger" style="width: {{ $totalCount > 0 ? ($outOfStockCount / $totalCount) * 100 : 0 }}%"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0">أعلى 5 منتجات قيمة</h6>
                    </div>
                    <div class="card-body">
                        @php
                            $topProducts = $products->sortByDesc('inventory_value')->take(5);
                        @endphp
                        
                        @foreach($topProducts as $item)
                        @php
                            $product = $item['product'];
                            $inventoryValue = $item['inventory_value'];
                            $percentage = $totalInventoryValue > 0 ? ($inventoryValue / $totalInventoryValue) * 100 : 0;
                        @endphp
                        <div class="mb-3">
                            <div class="d-flex justify-content-between">
                                <span>{{ Str::limit($product->name, 20) }}</span>
                                <span>{{ number_format($inventoryValue, 2) }} ر.س</span>
                            </div>
                            <div class="progress">
                                <div class="progress-bar bg-info" style="width: {{ $percentage }}%"></div>
                            </div>
                            <small class="text-muted">{{ number_format($percentage, 1) }}% من إجمالي المخزون</small>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
        
        @else
        <div class="text-center py-5">
            <i class="fas fa-chart-pie text-muted" style="font-size: 4rem;"></i>
            <h4 class="mt-3 text-muted">لا توجد منتجات في المخزون</h4>
            <p class="text-muted">ابدأ بإضافة منتجات للنظام</p>
            <a href="{{ route('products.create') }}" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i>
                إضافة منتج جديد
            </a>
        </div>
        @endif
    </div>
</div>

<!-- معلومات التقرير -->
<div class="card mt-4 d-print-none">
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <h6>معلومات التقرير</h6>
                <ul class="list-unstyled">
                    <li><strong>تاريخ التقرير:</strong> {{ now()->format('Y/m/d H:i') }}</li>
                    <li><strong>المستخدم:</strong> {{ auth()->user()->name }}</li>
                    <li><strong>إجمالي المنتجات:</strong> {{ $products->count() }}</li>
                    <li><strong>إجمالي القيمة:</strong> {{ number_format($totalInventoryValue, 2) }} ر.س</li>
                </ul>
            </div>
            <div class="col-md-6">
                <h6>ملاحظات</h6>
                <ul class="list-unstyled">
                    <li>• يتم حساب متوسط التكلفة بناءً على حركات الشراء والتسويات</li>
                    <li>• قيمة المخزون = الكمية المتوفرة × متوسط التكلفة</li>
                    <li>• المنتجات النافدة (الكمية = 0) لا تدخل في حساب القيمة</li>
                    <li>• التقرير يعكس حالة المخزون في وقت إنشائه</li>
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
@media print {
    .d-print-none {
        display: none !important;
    }
    
    .card {
        border: 1px solid #dee2e6 !important;
        box-shadow: none !important;
    }
    
    .badge {
        color: #000 !important;
        background-color: #f8f9fa !important;
        border: 1px solid #dee2e6 !important;
    }
    
    .progress {
        background-color: #f8f9fa !important;
        border: 1px solid #dee2e6 !important;
    }
    
    .progress-bar {
        background-color: #6c757d !important;
    }
}
</style>
@endpush