@extends('layouts.app')

@section('title', 'تقارير المخزون')
@section('page-title', 'تقارير المخزون الشاملة')

@section('page-actions')
    <div class="btn-group" role="group">
        <div class="btn-group" role="group">
            <button type="button" class="btn btn-success dropdown-toggle" data-bs-toggle="dropdown">
                <i class="fas fa-download me-2"></i>
                تصدير التقارير
            </button>
            <ul class="dropdown-menu">
                <li>
                    <a class="dropdown-item" href="{{ route('inventory.export-report', array_merge(request()->all(), ['type' => 'movements'])) }}">
                        <i class="fas fa-exchange-alt me-2"></i>
                        تصدير حركات المخزون (Excel)
                    </a>
                </li>
                <li>
                    <a class="dropdown-item" href="{{ route('inventory.export-report', array_merge(request()->all(), ['type' => 'stock'])) }}">
                        <i class="fas fa-boxes me-2"></i>
                        تصدير حالة المخزون (Excel)
                    </a>
                </li>
            </ul>
        </div>
        <a href="{{ route('inventory.index') }}" class="btn btn-secondary">
            <i class="fas fa-warehouse me-2"></i>
            عرض المخزون
        </a>
        <button type="button" class="btn btn-info" onclick="window.print()">
            <i class="fas fa-print me-2"></i>
            طباعة التقارير
        </button>
    </div>
@endsection

@section('content')
<!-- فلاتر التقارير -->
<div class="card mb-4">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fas fa-filter me-2"></i>
            فلاتر التقارير
        </h5>
    </div>
    <div class="card-body">
        <form method="GET" action="{{ route('inventory.reports') }}">
            <div class="row">
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="date_from" class="form-label">من تاريخ</label>
                        <input type="date" class="form-control" id="date_from" name="date_from" 
                               value="{{ request('date_from', now()->subMonth()->format('Y-m-d')) }}">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="date_to" class="form-label">إلى تاريخ</label>
                        <input type="date" class="form-control" id="date_to" name="date_to" 
                               value="{{ request('date_to', now()->format('Y-m-d')) }}">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="category" class="form-label">التصنيف</label>
                        <select class="form-control" id="category" name="category">
                            <option value="">جميع التصنيفات</option>
                            @foreach($categories as $category)
                                <option value="{{ $category }}" {{ request('category') == $category ? 'selected' : '' }}>
                                    {{ $category }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label class="form-label">&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-search me-2"></i>
                                تطبيق الفلاتر
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- ملخص التقارير -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body text-center">
                <h4>{{ number_format($summaryData['total_products']) }}</h4>
                <p class="mb-0">إجمالي المنتجات</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-info text-white">
            <div class="card-body text-center">
                <h4>{{ number_format($summaryData['total_movements']) }}</h4>
                <p class="mb-0">إجمالي الحركات</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-white">
            <div class="card-body text-center">
                <h4>{{ number_format($summaryData['total_quantity_in']) }}</h4>
                <p class="mb-0">إجمالي الإدخال</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body text-center">
                <h4>{{ number_format($summaryData['total_value'], 2) }}</h4>
                <p class="mb-0">إجمالي القيمة (ر.س)</p>
            </div>
        </div>
    </div>
</div>

<!-- تقرير حركات المخزون -->
<div class="card mb-4">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fas fa-exchange-alt me-2"></i>
            تقرير حركات المخزون
        </h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped">
                    <tr>
                        <th>التاريخ</th>
                        <th>المنتج</th>
                        <th>نوع الحركة</th>
                        <th>الكمية</th>
                        <th>تكلفة الوحدة</th>
                        <th>التكلفة الإجمالية</th>
                        <th>المرجع</th>
                    </tr>
                    @foreach($movements as $movement)
                    <tr>
                        <td>{{ $movement->movement_date->format('Y/m/d') }}</td>
                        <td>{{ $movement->product->name }}</td>
                        <td>
                            <span class="badge bg-{{ $movement->isInbound() ? 'success' : 'warning' }}">
                                @switch($movement->type)
                                    @case('purchase')
                                        <i class="fas fa-shopping-cart me-1"></i> شراء
                                        @break
                                    @case('sale')
                                        <i class="fas fa-cash-register me-1"></i> بيع
                                        @break
                                    @case('adjustment_in')
                                        <i class="fas fa-plus me-1"></i> تسوية إدخال
                                        @break
                                    @case('adjustment_out')
                                        <i class="fas fa-minus me-1"></i> تسوية إخراج
                                        @break
                                    @default
                                        {{ $movement->type }}
                                @endswitch
                            </span>
                        </td>
                        <td>
                            <span class="badge bg-{{ $movement->isInbound() ? 'success' : 'danger' }}">
                                {{ $movement->isInbound() ? '+' : '-' }}{{ number_format($movement->quantity) }}
                            </span>
                        </td>
                        <td>{{ $movement->unit_cost ? number_format($movement->unit_cost, 2) . ' ر.س' : '-' }}</td>
                        <td>{{ $movement->total_cost ? number_format($movement->total_cost, 2) . ' ر.س' : '-' }}</td>
                        <td>
                            @if($movement->reference_type && $movement->reference_id)
                                <small>{{ class_basename($movement->reference_type) }} #{{ $movement->reference_id }}</small>
                            @else
                                -
                            @endif
                        </td>
                    </tr>
                    @endforeach
            </table>
        </div>
    </div>
</div>

<!-- تقرير المنتجات حسب الحالة -->
<div class="row mb-4">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-chart-bar me-2"></i>
                    تقرير المنتجات حسب الحالة
                </h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                            <tr>
                                <th>المنتج</th>
                                <th>التصنيف</th>
                                <th>الكمية الحالية</th>
                                <th>الحد الأدنى</th>
                                <th>متوسط التكلفة</th>
                                <th>قيمة المخزون</th>
                                <th>الحالة</th>
                            </tr>
                        <tbody>
                            @foreach($stockReport as $item)
                            @php
                                $product = $item['product'];
                                $isLowStock = $product->stock_quantity <= $product->min_stock;
                                $isOutOfStock = $product->stock_quantity <= 0;
                            @endphp
                            <tr class="{{ $isOutOfStock ? 'table-danger' : ($isLowStock ? 'table-warning' : '') }}">
                                <td>{{ $product->name }}</td>
                                <td>{{ $product->category ?? '-' }}</td>
                                <td>{{ number_format($product->stock_quantity) }}</td>
                                <td>{{ number_format($product->min_stock) }}</td>
                                <td>{{ number_format($item['average_cost'], 2) }} ر.س</td>
                                <td>{{ number_format($item['inventory_value'], 2) }} ر.س</td>
                                <td>
                                    @if($isOutOfStock)
                                        <span class="badge bg-danger">نافد</span>
                                    @elseif($isLowStock)
                                        <span class="badge bg-warning">منخفض</span>
                                    @else
                                        <span class="badge bg-success">متوفر</span>
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-chart-pie me-2"></i>
                    توزيع حالة المخزون
                </h5>
            </div>
            <div class="card-body">
                @php
                    $stockStatusDistribution = $stockReport->groupBy(function($item) {
                        $product = $item['product'];
                        if ($product->stock_quantity <= 0) return 'نافد';
                        if ($product->stock_quantity <= $product->min_stock) return 'منخفض';
                        return 'متوفر';
                    });
                    
                    $total = $stockReport->count();
                @endphp
                
                @foreach(['متوفر' => 'success', 'منخفض' => 'warning', 'نافد' => 'danger'] as $status => $color)
                @php $count = $stockStatusDistribution->get($status, collect())->count(); @endphp
                <div class="mb-3">
                    <div class="d-flex justify-content-between">
                        <span>{{ $status }}</span>
                        <span>{{ $count }} ({{ $total > 0 ? number_format(($count / $total) * 100, 1) : 0 }}%)</span>
                    </div>
                    <div class="progress">
                        <div class="progress-bar bg-{{ $color }}" 
                             style="width: {{ $total > 0 ? ($count / $total) * 100 : 0 }}%"></div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</div>

<!-- تقرير الحركات حسب النوع -->
<div class="row mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-chart-doughnut me-2"></i>
                    الحركات حسب النوع
                </h5>
            </div>
            <div class="card-body">
                @php
                    $movementsByType = $movements->groupBy('type');
                    $totalMovements = $movements->count();
                @endphp
                
                @foreach($movementsByType as $type => $typeMovements)
                @php
                    $count = $typeMovements->count();
                    $percentage = $totalMovements > 0 ? ($count / $totalMovements) * 100 : 0;
                    $typeLabel = [
                        'purchase' => 'شراء',
                        'sale' => 'بيع', 
                        'adjustment_in' => 'تسوية إدخال',
                        'adjustment_out' => 'تسوية إخراج',
                        'return_in' => 'إرجاع إدخال',
                        'return_out' => 'إرجاع إخراج'
                    ][$type] ?? $type;
                @endphp
                <div class="mb-3">
                    <div class="d-flex justify-content-between">
                        <span>{{ $typeLabel }}</span>
                        <span>{{ $count }} ({{ number_format($percentage, 1) }}%)</span>
                    </div>
                    <div class="progress">
                        <div class="progress-bar bg-info" style="width: {{ $percentage }}%"></div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-chart-line me-2"></i>
                    أعلى المنتجات حركة
                </h5>
            </div>
            <div class="card-body">
                @php
                    $topMovedProducts = $movements->groupBy('product_id')
                        ->map(function($productMovements) {
                            return [
                                'product' => $productMovements->first()->product,
                                'total_movements' => $productMovements->count(),
                                'total_quantity' => $productMovements->sum('quantity')
                            ];
                        })
                        ->sortByDesc('total_movements')
                        ->take(5);
                @endphp
                
                @foreach($topMovedProducts as $item)
                <div class="mb-3">
                    <div class="d-flex justify-content-between">
                        <span>{{ Str::limit($item['product']->name, 20) }}</span>
                        <span class="badge bg-primary">{{ $item['total_movements'] }} حركة</span>
                    </div>
                    <small class="text-muted">إجمالي الكمية: {{ number_format($item['total_quantity']) }}</small>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</div>

<!-- معلومات التقرير -->
<div class="card mt-4 d-print-none">
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <h6>معلومات التقرير</h6>
                <ul class="list-unstyled">
                    <li><strong>تاريخ التقرير:</strong> {{ now()->format('Y/m/d H:i') }}</li>
                    <li><strong>الفترة:</strong> {{ request('date_from', now()->subMonth()->format('Y-m-d')) }} إلى {{ request('date_to', now()->format('Y-m-d')) }}</li>
                    <li><strong>المستخدم:</strong> {{ auth()->user()->name }}</li>
                    <li><strong>إجمالي الحركات:</strong> {{ $movements->count() }}</li>
                </ul>
            </div>
            <div class="col-md-6">
                <h6>ملاحظات</h6>
                <ul class="list-unstyled">
                    <li>• التقرير يشمل جميع حركات المخزون في الفترة المحددة</li>
                    <li>• قيم المخزون محسوبة بناءً على متوسط التكلفة</li>
                    <li>• الحركات مرتبة حسب التاريخ الأحدث</li>
                    <li>• يمكن تصدير هذا التقرير للطباعة أو الحفظ</li>
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
@media print {
    .d-print-none {
        display: none !important;
    }
    
    .card {
        border: 1px solid #dee2e6 !important;
        box-shadow: none !important;
        margin-bottom: 20px !important;
    }
    
    .badge {
        color: #000 !important;
        background-color: #f8f9fa !important;
        border: 1px solid #dee2e6 !important;
    }
    
    .progress {
        background-color: #f8f9fa !important;
        border: 1px solid #dee2e6 !important;
    }
    
    .progress-bar {
        background-color: #6c757d !important;
    }
}
</style>
@endpush