@extends('layouts.app')

@section('title', 'حركات المخزون')
@section('page-title', 'حركات المخزون')

@section('page-actions')
    <div class="btn-group" role="group">
        <a href="{{ route('inventory.index') }}" class="btn btn-secondary">
            <i class="fas fa-warehouse me-2"></i>
            عرض المخزون
        </a>
        <a href="{{ route('inventory.adjustments.create') }}" class="btn btn-warning">
            <i class="fas fa-tools me-2"></i>
            تسوية مخزون
        </a>
    </div>
@endsection

@section('content')
<!-- فلاتر البحث -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('inventory.movements') }}">
            <div class="row">
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="product_id" class="form-label">المنتج</label>
                        <select class="form-control" id="product_id" name="product_id">
                            <option value="">جميع المنتجات</option>
                            @foreach($products as $product)
                                <option value="{{ $product->id }}" {{ request('product_id') == $product->id ? 'selected' : '' }}>
                                    {{ $product->name }} ({{ $product->sku }})
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="mb-3">
                        <label for="type" class="form-label">نوع الحركة</label>
                        <select class="form-control" id="type" name="type">
                            <option value="">جميع الأنواع</option>
                            <option value="purchase" {{ request('type') == 'purchase' ? 'selected' : '' }}>شراء</option>
                            <option value="sale" {{ request('type') == 'sale' ? 'selected' : '' }}>بيع</option>
                            <option value="adjustment_in" {{ request('type') == 'adjustment_in' ? 'selected' : '' }}>تسوية - إدخال</option>
                            <option value="adjustment_out" {{ request('type') == 'adjustment_out' ? 'selected' : '' }}>تسوية - إخراج</option>
                            <option value="return_in" {{ request('type') == 'return_in' ? 'selected' : '' }}>إرجاع - إدخال</option>
                            <option value="return_out" {{ request('type') == 'return_out' ? 'selected' : '' }}>إرجاع - إخراج</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="mb-3">
                        <label for="date_from" class="form-label">من تاريخ</label>
                        <input type="date" class="form-control" id="date_from" name="date_from" value="{{ request('date_from') }}">
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="mb-3">
                        <label for="date_to" class="form-label">إلى تاريخ</label>
                        <input type="date" class="form-control" id="date_to" name="date_to" value="{{ request('date_to') }}">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label class="form-label">&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-search me-2"></i>
                                بحث
                            </button>
                            <a href="{{ route('inventory.movements') }}" class="btn btn-secondary">
                                <i class="fas fa-times me-2"></i>
                                إعادة تعيين
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- قائمة حركات المخزون -->
<div class="card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fas fa-exchange-alt me-2"></i>
            سجل حركات المخزون
        </h5>
    </div>
    <div class="card-body">
        @if($movements->count() > 0)
        <div class="table-responsive">
            <table class="table table-striped">
                    <tr>
                        <th>التاريخ</th>
                        <th>المنتج</th>
                        <th>نوع الحركة</th>
                        <th>الكمية</th>
                        <th>تكلفة الوحدة</th>
                        <th>التكلفة الإجمالية</th>
                        <th>المرجع</th>
                        <th>المستخدم</th>
                        <th>ملاحظات</th>
                    </tr>
                    @foreach($movements as $movement)
                    <tr class="{{ $movement->isInbound() ? 'table-success' : 'table-warning' }}">
                        <td>{{ $movement->movement_date->format('Y/m/d H:i') }}</td>
                        <td>
                            <strong>{{ $movement->product->name }}</strong>
                            <br><small class="text-muted">{{ $movement->product->sku }}</small>
                        </td>
                        <td>
                            <span class="badge bg-{{ $movement->isInbound() ? 'success' : 'warning' }}">
                                @switch($movement->type)
                                    @case('purchase')
                                        <i class="fas fa-shopping-cart me-1"></i> شراء
                                        @break
                                    @case('sale')
                                        <i class="fas fa-cash-register me-1"></i> بيع
                                        @break
                                    @case('adjustment_in')
                                        <i class="fas fa-plus me-1"></i> تسوية إدخال
                                        @break
                                    @case('adjustment_out')
                                        <i class="fas fa-minus me-1"></i> تسوية إخراج
                                        @break
                                    @case('return_in')
                                        <i class="fas fa-undo me-1"></i> إرجاع إدخال
                                        @break
                                    @case('return_out')
                                        <i class="fas fa-redo me-1"></i> إرجاع إخراج
                                        @break
                                    @case('transfer_in')
                                        <i class="fas fa-arrow-right me-1"></i> نقل إدخال
                                        @break
                                    @case('transfer_out')
                                        <i class="fas fa-arrow-left me-1"></i> نقل إخراج
                                        @break
                                @endswitch
                            </span>
                        </td>
                        <td>
                            <span class="badge bg-{{ $movement->isInbound() ? 'success' : 'danger' }}">
                                {{ $movement->isInbound() ? '+' : '-' }}{{ number_format($movement->quantity) }}
                            </span>
                        </td>
                        <td>{{ $movement->unit_cost ? number_format($movement->unit_cost, 2) . ' ر.س' : '-' }}</td>
                        <td>{{ $movement->total_cost ? number_format($movement->total_cost, 2) . ' ر.س' : '-' }}</td>
                        <td>
                            @if($movement->reference_type && $movement->reference_id)
                                <small class="text-muted">
                                    {{ class_basename($movement->reference_type) }} #{{ $movement->reference_id }}
                                </small>
                            @else
                                -
                            @endif
                        </td>
                        <td>{{ $movement->user->name }}</td>
                        <td>
                            @if($movement->notes)
                                <small>{{ Str::limit($movement->notes, 50) }}</small>
                            @else
                                -
                            @endif
                        </td>
                    </tr>
                    @endforeach
            </table>
        </div>
        
        <div class="d-flex justify-content-center">
            {{ $movements->links() }}
        </div>
        @else
        <div class="text-center py-5">
            <i class="fas fa-exchange-alt text-muted" style="font-size: 4rem;"></i>
            <h4 class="mt-3 text-muted">لا توجد حركات مخزون</h4>
            <p class="text-muted">سيتم عرض حركات المخزون هنا عند حدوثها</p>
        </div>
        @endif
    </div>
</div>

<!-- ملخص الحركات -->
@if($movements->count() > 0)
<div class="row mt-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ $movements->count() }}</h4>
                        <p class="mb-0">إجمالي الحركات</p>
                    </div>
                    <div>
                        <i class="fas fa-exchange-alt fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ $movements->filter(function($m) { return $m->isInbound(); })->count() }}</h4>
                        <p class="mb-0">حركات إدخال</p>
                    </div>
                    <div>
                        <i class="fas fa-arrow-down fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ $movements->filter(function($m) { return $m->isOutbound(); })->count() }}</h4>
                        <p class="mb-0">حركات إخراج</p>
                    </div>
                    <div>
                        <i class="fas fa-arrow-up fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-info text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ number_format($movements->sum('total_cost'), 0) }}</h4>
                        <p class="mb-0">إجمالي القيمة (ر.س)</p>
                    </div>
                    <div>
                        <i class="fas fa-money-bill fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endif
@endsection