@extends('layouts.app')

@section('title', 'إدارة المخزون')
@section('page-title', 'إدارة المخزون')

@section('page-actions')
    <div class="btn-group" role="group">
        <a href="{{ route('inventory.movements') }}" class="btn btn-info">
            <i class="fas fa-exchange-alt me-2"></i>
            حركات المخزون
        </a>
        <a href="{{ route('inventory.adjustments.create') }}" class="btn btn-warning">
            <i class="fas fa-tools me-2"></i>
            تسوية مخزون
        </a>
        <a href="{{ route('inventory.valuation') }}" class="btn btn-success">
            <i class="fas fa-chart-pie me-2"></i>
            تقييم المخزون
        </a>
    </div>
@endsection

@section('content')
<!-- فلاتر البحث -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('inventory.index') }}">
            <div class="row">
                <div class="col-md-4">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="low_stock" value="1" 
                               {{ request('low_stock') ? 'checked' : '' }} id="lowStock">
                        <label class="form-check-label" for="lowStock">
                            المنتجات منخفضة المخزون
                        </label>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="out_of_stock" value="1" 
                               {{ request('out_of_stock') ? 'checked' : '' }} id="outOfStock">
                        <label class="form-check-label" for="outOfStock">
                            المنتجات النافدة
                        </label>
                    </div>
                </div>
                <div class="col-md-4">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search me-2"></i>
                        بحث
                    </button>
                    <a href="{{ route('inventory.index') }}" class="btn btn-secondary">
                        <i class="fas fa-times me-2"></i>
                        إعادة تعيين
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- قائمة المنتجات -->
<div class="card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fas fa-warehouse me-2"></i>
            حالة المخزون
        </h5>
    </div>
    <div class="card-body">
        @if($products->count() > 0)
        <div class="table-responsive">
            <table class="table table-striped">
                    <tr>
                        <th>#</th>
                        <th>اسم المنتج</th>
                        <th>رمز المنتج</th>
                        <th>الوحدة</th>
                        <th>الكمية الحالية</th>
                        <th>الحد الأدنى</th>
                        <th>متوسط التكلفة</th>
                        <th>قيمة المخزون</th>
                        <th>الحالة</th>
                        <th>آخر حركة</th>
                    </tr>
                    @foreach($products as $product)
                    <tr class="{{ $product->isOutOfStock() ? 'table-danger' : ($product->isLowStock() ? 'table-warning' : '') }}">
                        <td>{{ $product->id }}</td>
                        <td>
                            <strong>{{ $product->name }}</strong>
                            @if($product->name_en)
                                <br><small class="text-muted">{{ $product->name_en }}</small>
                            @endif
                        </td>
                        <td>{{ $product->sku }}</td>
                        <td>{{ $product->unit }}</td>
                        <td>
                            <span class="badge bg-{{ $product->isOutOfStock() ? 'danger' : ($product->isLowStock() ? 'warning' : 'success') }}">
                                {{ number_format($product->stock_quantity) }}
                            </span>
                        </td>
                        <td>{{ number_format($product->min_stock) }}</td>
                        <td>{{ number_format($product->getAverageCost(), 2) }} ر.س</td>
                        <td>{{ number_format($product->getCurrentInventoryValue(), 2) }} ر.س</td>
                        <td>
                            @if($product->isOutOfStock())
                                <span class="badge bg-danger">نافد</span>
                            @elseif($product->isLowStock())
                                <span class="badge bg-warning">منخفض</span>
                            @else
                                <span class="badge bg-success">متوفر</span>
                            @endif
                        </td>
                        <td>
                            @if($product->inventoryMovements->count() > 0)
                                @php $lastMovement = $product->inventoryMovements->first(); @endphp
                                <small>
                                    {{ $lastMovement->movement_date->format('Y/m/d') }}<br>
                                    <span class="text-muted">{{ $lastMovement->type }}</span>
                                </small>
                            @else
                                <span class="text-muted">لا توجد حركات</span>
                            @endif
                        </td>
                    </tr>
                    @endforeach
            </table>
        </div>
        
        <!-- pagination مبسط -->
        @if($products->hasPages())
        <nav aria-label="صفحات النتائج" class="mt-4">
            <div class="d-flex justify-content-between align-items-center">
                <div class="text-muted small">
                    عرض {{ $products->firstItem() ?? 0 }} إلى {{ $products->lastItem() ?? 0 }} من أصل {{ $products->total() }} نتيجة
                </div>
                <ul class="pagination pagination-sm mb-0">
                    {{-- السابق --}}
                    @if($products->onFirstPage())
                        <li class="page-item disabled">
                            <span class="page-link">السابق</span>
                        </li>
                    @else
                        <li class="page-item">
                            <a class="page-link" href="{{ $products->previousPageUrl() }}">السابق</a>
                        </li>
                    @endif

                    {{-- أرقام الصفحات --}}
                    @php
                        $currentPage = $products->currentPage();
                        $lastPage = $products->lastPage();
                        $startPage = max(1, $currentPage - 2);
                        $endPage = min($lastPage, $currentPage + 2);
                    @endphp

                    @if($startPage > 1)
                        <li class="page-item">
                            <a class="page-link" href="{{ $products->url(1) }}">1</a>
                        </li>
                        @if($startPage > 2)
                            <li class="page-item disabled">
                                <span class="page-link">...</span>
                            </li>
                        @endif
                    @endif

                    @for($page = $startPage; $page <= $endPage; $page++)
                        @if($page == $currentPage)
                            <li class="page-item active">
                                <span class="page-link">{{ $page }}</span>
                            </li>
                        @else
                            <li class="page-item">
                                <a class="page-link" href="{{ $products->url($page) }}">{{ $page }}</a>
                            </li>
                        @endif
                    @endfor

                    @if($endPage < $lastPage)
                        @if($endPage < $lastPage - 1)
                            <li class="page-item disabled">
                                <span class="page-link">...</span>
                            </li>
                        @endif
                        <li class="page-item">
                            <a class="page-link" href="{{ $products->url($lastPage) }}">{{ $lastPage }}</a>
                        </li>
                    @endif

                    {{-- التالي --}}
                    @if($products->hasMorePages())
                        <li class="page-item">
                            <a class="page-link" href="{{ $products->nextPageUrl() }}">التالي</a>
                        </li>
                    @else
                        <li class="page-item disabled">
                            <span class="page-link">التالي</span>
                        </li>
                    @endif
                </ul>
            </div>
        </nav>
        @endif
        @else
        <div class="text-center py-5">
            <i class="fas fa-warehouse text-muted" style="font-size: 4rem;"></i>
            <h4 class="mt-3 text-muted">لا توجد منتجات</h4>
            <p class="text-muted">ابدأ بإضافة منتجات للنظام</p>
            <a href="{{ route('products.create') }}" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i>
                إضافة منتج جديد
            </a>
        </div>
        @endif
    </div>
</div>

<!-- إحصائيات سريعة -->
@if($products->count() > 0)
<div class="row mt-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ $products->count() }}</h4>
                        <p class="mb-0">إجمالي المنتجات</p>
                    </div>
                    <div>
                        <i class="fas fa-boxes fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ $products->filter(function($p) { return !$p->isLowStock(); })->count() }}</h4>
                        <p class="mb-0">منتجات متوفرة</p>
                    </div>
                    <div>
                        <i class="fas fa-check-circle fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ $products->filter(function($p) { return $p->isLowStock() && !$p->isOutOfStock(); })->count() }}</h4>
                        <p class="mb-0">منتجات منخفضة</p>
                    </div>
                    <div>
                        <i class="fas fa-exclamation-triangle fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-danger text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ $products->filter(function($p) { return $p->isOutOfStock(); })->count() }}</h4>
                        <p class="mb-0">منتجات نافدة</p>
                    </div>
                    <div>
                        <i class="fas fa-times-circle fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endif
@endsection