@extends('layouts.app')

@section('title', 'تفاصيل تسوية المخزون')
@section('page-title', 'تفاصيل تسوية المخزون: ' . $adjustment->adjustment_number)

@section('page-actions')
    <div class="btn-group" role="group">
        @if($adjustment->status == 'pending')
            <form method="POST" action="{{ route('inventory.adjustments.approve', $adjustment) }}" class="d-inline">
                @csrf
                <button type="submit" class="btn btn-success" 
                        onclick="return confirm('هل أنت متأكد من اعتماد هذه التسوية؟ سيتم تطبيقها على المخزون فوراً.')">
                    <i class="fas fa-check me-2"></i>
                    اعتماد التسوية
                </button>
            </form>
        @endif
        
        <a href="{{ route('inventory.adjustments.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-right me-2"></i>
            العودة للقائمة
        </a>
    </div>
@endsection

@section('content')
<div class="row">
    <!-- معلومات التسوية -->
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-info-circle me-2"></i>
                    معلومات التسوية
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <td><strong>رقم التسوية:</strong></td>
                                <td>{{ $adjustment->adjustment_number }}</td>
                            </tr>
                            <tr>
                                <td><strong>تاريخ التسوية:</strong></td>
                                <td>{{ $adjustment->adjustment_date->format('Y/m/d') }}</td>
                            </tr>
                            <tr>
                                <td><strong>نوع التسوية:</strong></td>
                                <td>
                                    @switch($adjustment->type)
                                        @case('increase')
                                            <span class="badge bg-success">
                                                <i class="fas fa-plus me-1"></i> زيادة
                                            </span>
                                            @break
                                        @case('decrease')
                                            <span class="badge bg-warning">
                                                <i class="fas fa-minus me-1"></i> نقص
                                            </span>
                                            @break
                                        @case('recount')
                                            <span class="badge bg-info">
                                                <i class="fas fa-redo me-1"></i> إعادة عد
                                            </span>
                                            @break
                                    @endswitch
                                </td>
                            </tr>
                            <tr>
                                <td><strong>السبب:</strong></td>
                                <td>{{ $adjustment->reason }}</td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <td><strong>الحالة:</strong></td>
                                <td>
                                    @switch($adjustment->status)
                                        @case('pending')
                                            <span class="badge bg-warning">معلق</span>
                                            @break
                                        @case('approved')
                                            <span class="badge bg-success">مؤكد</span>
                                            @break
                                        @case('cancelled')
                                            <span class="badge bg-danger">ملغي</span>
                                            @break
                                    @endswitch
                                </td>
                            </tr>
                            <tr>
                                <td><strong>المنشئ:</strong></td>
                                <td>{{ $adjustment->user->name }}</td>
                            </tr>
                            <tr>
                                <td><strong>تاريخ الإنشاء:</strong></td>
                                <td>{{ $adjustment->created_at->format('Y/m/d H:i') }}</td>
                            </tr>
                            <tr>
                                <td><strong>آخر تحديث:</strong></td>
                                <td>{{ $adjustment->updated_at->format('Y/m/d H:i') }}</td>
                            </tr>
                        </table>
                    </div>
                </div>
                
                @if($adjustment->notes)
                <div class="row">
                    <div class="col-12">
                        <hr>
                        <strong>ملاحظات:</strong>
                        <p class="mt-2">{{ $adjustment->notes }}</p>
                    </div>
                </div>
                @endif
            </div>
        </div>
        
        <!-- عناصر التسوية -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-list me-2"></i>
                    عناصر التسوية
                </h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                            <tr>
                                <th>المنتج</th>
                                <th>الكمية الحالية</th>
                                <th>الكمية الجديدة</th>
                                <th>الفرق</th>
                                <th>تكلفة الوحدة</th>
                                <th>تأثير القيمة</th>
                                <th>السبب</th>
                            </tr>
                        <tbody>
                            @foreach($adjustment->items as $item)
                            <tr>
                                <td>
                                    <strong>{{ $item->product->name }}</strong>
                                    <br><small class="text-muted">{{ $item->product->sku }}</small>
                                </td>
                                <td>{{ number_format($item->current_quantity) }}</td>
                                <td>{{ number_format($item->adjusted_quantity) }}</td>
                                <td>
                                    <span class="badge bg-{{ $item->quantity_difference > 0 ? 'success' : ($item->quantity_difference < 0 ? 'danger' : 'secondary') }}">
                                        {{ $item->quantity_difference > 0 ? '+' : '' }}{{ number_format($item->quantity_difference) }}
                                    </span>
                                </td>
                                <td>{{ number_format($item->unit_cost, 2) }} ر.س</td>
                                <td>
                                    @php
                                        $valueImpact = $item->quantity_difference * $item->unit_cost;
                                    @endphp
                                    <span class="badge bg-{{ $valueImpact > 0 ? 'success' : ($valueImpact < 0 ? 'danger' : 'secondary') }}">
                                        {{ $valueImpact > 0 ? '+' : '' }}{{ number_format($valueImpact, 2) }} ر.س
                                    </span>
                                </td>
                                <td>{{ $item->reason ?? '-' }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <!-- ملخص التسوية -->
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-chart-bar me-2"></i>
                    ملخص التسوية
                </h5>
            </div>
            <div class="card-body">
                @php
                    $totalItems = $adjustment->items->count();
                    $totalValueImpact = $adjustment->items->sum(function($item) {
                        return $item->quantity_difference * $item->unit_cost;
                    });
                    $increaseItems = $adjustment->items->where('quantity_difference', '>', 0)->count();
                    $decreaseItems = $adjustment->items->where('quantity_difference', '<', 0)->count();
                    $noChangeItems = $adjustment->items->where('quantity_difference', '=', 0)->count();
                @endphp
                
                <div class="text-center mb-4">
                    <h3 class="text-primary">{{ $totalItems }}</h3>
                    <p class="mb-0">إجمالي العناصر</p>
                </div>
                
                <div class="text-center mb-4">
                    <h3 class="text-{{ $totalValueImpact > 0 ? 'success' : ($totalValueImpact < 0 ? 'danger' : 'secondary') }}">
                        {{ $totalValueImpact > 0 ? '+' : '' }}{{ number_format($totalValueImpact, 2) }}
                    </h3>
                    <p class="mb-0">تأثير القيمة (ر.س)</p>
                </div>
                
                <hr>
                
                <div class="mb-3">
                    <div class="d-flex justify-content-between">
                        <span>عناصر زيادة:</span>
                        <span class="badge bg-success">{{ $increaseItems }}</span>
                    </div>
                </div>
                
                <div class="mb-3">
                    <div class="d-flex justify-content-between">
                        <span>عناصر نقص:</span>
                        <span class="badge bg-danger">{{ $decreaseItems }}</span>
                    </div>
                </div>
                
                <div class="mb-3">
                    <div class="d-flex justify-content-between">
                        <span>بدون تغيير:</span>
                        <span class="badge bg-secondary">{{ $noChangeItems }}</span>
                    </div>
                </div>
                
                @if($adjustment->status == 'approved')
                <div class="alert alert-success">
                    <i class="fas fa-check-circle me-2"></i>
                    تم اعتماد هذه التسوية وتطبيقها على المخزون
                </div>
                @elseif($adjustment->status == 'pending')
                <div class="alert alert-warning">
                    <i class="fas fa-clock me-2"></i>
                    هذه التسوية معلقة وتحتاج لموافقة
                </div>
                @endif
            </div>
        </div>
        
        <!-- تفاصيل إضافية -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-clipboard-list me-2"></i>
                    تفاصيل إضافية
                </h5>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <strong>أكبر زيادة:</strong>
                    @php
                        $maxIncrease = $adjustment->items->where('quantity_difference', '>', 0)->sortByDesc('quantity_difference')->first();
                    @endphp
                    @if($maxIncrease)
                        <div class="text-success">
                            {{ $maxIncrease->product->name }}<br>
                            <small>+{{ number_format($maxIncrease->quantity_difference) }}</small>
                        </div>
                    @else
                        <span class="text-muted">لا توجد</span>
                    @endif
                </div>
                
                <div class="mb-3">
                    <strong>أكبر نقص:</strong>
                    @php
                        $maxDecrease = $adjustment->items->where('quantity_difference', '<', 0)->sortBy('quantity_difference')->first();
                    @endphp
                    @if($maxDecrease)
                        <div class="text-danger">
                            {{ $maxDecrease->product->name }}<br>
                            <small>{{ number_format($maxDecrease->quantity_difference) }}</small>
                        </div>
                    @else
                        <span class="text-muted">لا توجد</span>
                    @endif
                </div>
                
                <div class="mb-3">
                    <strong>أعلى تأثير قيمة:</strong>
                    @php
                        $maxValueImpact = $adjustment->items->sortByDesc(function($item) {
                            return abs($item->quantity_difference * $item->unit_cost);
                        })->first();
                    @endphp
                    @if($maxValueImpact)
                        <div>
                            {{ $maxValueImpact->product->name }}<br>
                            <small class="text-muted">{{ number_format(abs($maxValueImpact->quantity_difference * $maxValueImpact->unit_cost), 2) }} ر.س</small>
                        </div>
                    @else
                        <span class="text-muted">لا توجد</span>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection