@extends('layouts.app')

@section('title', 'تسويات المخزون')
@section('page-title', 'إدارة تسويات المخزون')

@section('page-actions')
    <div class="btn-group" role="group">
        <a href="{{ route('inventory.adjustments.create') }}" class="btn btn-primary">
            <i class="fas fa-plus me-2"></i>
            إنشاء تسوية جديدة
        </a>
        <a href="{{ route('inventory.index') }}" class="btn btn-secondary">
            <i class="fas fa-warehouse me-2"></i>
            عرض المخزون
        </a>
    </div>
@endsection

@section('content')
<!-- فلاتر البحث -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('inventory.adjustments.index') }}">
            <div class="row">
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="status" class="form-label">الحالة</label>
                        <select class="form-control" id="status" name="status">
                            <option value="">جميع الحالات</option>
                            <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>معلق</option>
                            <option value="approved" {{ request('status') == 'approved' ? 'selected' : '' }}>مؤكد</option>
                            <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="type" class="form-label">النوع</label>
                        <select class="form-control" id="type" name="type">
                            <option value="">جميع الأنواع</option>
                            <option value="increase" {{ request('type') == 'increase' ? 'selected' : '' }}>زيادة</option>
                            <option value="decrease" {{ request('type') == 'decrease' ? 'selected' : '' }}>نقص</option>
                            <option value="recount" {{ request('type') == 'recount' ? 'selected' : '' }}>إعادة عد</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label class="form-label">&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-search me-2"></i>
                                بحث
                            </button>
                            <a href="{{ route('inventory.adjustments.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times me-2"></i>
                                إعادة تعيين
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- قائمة التسويات -->
<div class="card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fas fa-tools me-2"></i>
            قائمة تسويات المخزون
        </h5>
    </div>
    <div class="card-body">
        @if($adjustments->count() > 0)
        <div class="table-responsive">
            <table class="table table-striped">
                    <tr>
                        <th>رقم التسوية</th>
                        <th>تاريخ التسوية</th>
                        <th>النوع</th>
                        <th>السبب</th>
                        <th>عدد العناصر</th>
                        <th>تأثير القيمة</th>
                        <th>الحالة</th>
                        <th>المنشئ</th>
                        <th>الإجراءات</th>
                    </tr>
                    @foreach($adjustments as $adjustment)
                    <tr>
                        <td>
                            <strong>{{ $adjustment->adjustment_number }}</strong>
                        </td>
                        <td>{{ $adjustment->adjustment_date->format('Y/m/d') }}</td>
                        <td>
                            @switch($adjustment->type)
                                @case('increase')
                                    <span class="badge bg-success">
                                        <i class="fas fa-plus me-1"></i> زيادة
                                    </span>
                                    @break
                                @case('decrease')
                                    <span class="badge bg-warning">
                                        <i class="fas fa-minus me-1"></i> نقص
                                    </span>
                                    @break
                                @case('recount')
                                    <span class="badge bg-info">
                                        <i class="fas fa-redo me-1"></i> إعادة عد
                                    </span>
                                    @break
                            @endswitch
                        </td>
                        <td>{{ Str::limit($adjustment->reason, 30) }}</td>
                        <td>
                            <span class="badge bg-primary">{{ $adjustment->total_items }}</span>
                        </td>
                        <td>
                            <span class="badge bg-{{ $adjustment->total_value_impact >= 0 ? 'success' : 'danger' }}">
                                {{ $adjustment->total_value_impact >= 0 ? '+' : '' }}{{ number_format($adjustment->total_value_impact, 2) }} ر.س
                            </span>
                        </td>
                        <td>
                            @switch($adjustment->status)
                                @case('pending')
                                    <span class="badge bg-warning">معلق</span>
                                    @break
                                @case('approved')
                                    <span class="badge bg-success">مؤكد</span>
                                    @break
                                @case('cancelled')
                                    <span class="badge bg-danger">ملغي</span>
                                    @break
                            @endswitch
                        </td>
                        <td>{{ $adjustment->user->name }}</td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="{{ route('inventory.adjustments.show', $adjustment) }}" class="btn btn-sm btn-info">
                                    <i class="fas fa-eye"></i>
                                </a>
                                
                                @if($adjustment->status == 'pending')
                                    <form method="POST" action="{{ route('inventory.adjustments.approve', $adjustment) }}" class="d-inline">
                                        @csrf
                                        <button type="submit" class="btn btn-sm btn-success" 
                                                onclick="return confirm('هل أنت متأكد من اعتماد هذه التسوية؟ سيتم تطبيقها على المخزون فوراً.')">
                                            <i class="fas fa-check"></i>
                                        </button>
                                    </form>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @endforeach
            </table>
        </div>
        
        <div class="d-flex justify-content-center">
            {{ $adjustments->links() }}
        </div>
        @else
        <div class="text-center py-5">
            <i class="fas fa-tools text-muted" style="font-size: 4rem;"></i>
            <h4 class="mt-3 text-muted">لا توجد تسويات مخزون</h4>
            <p class="text-muted">ابدأ بإنشاء أول تسوية مخزون</p>
            <a href="{{ route('inventory.adjustments.create') }}" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i>
                إنشاء تسوية جديدة
            </a>
        </div>
        @endif
    </div>
</div>

<!-- إحصائيات سريعة -->
@if($adjustments->count() > 0)
<div class="row mt-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ $adjustments->count() }}</h4>
                        <p class="mb-0">إجمالي التسويات</p>
                    </div>
                    <div>
                        <i class="fas fa-tools fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ $adjustments->where('status', 'pending')->count() }}</h4>
                        <p class="mb-0">تسويات معلقة</p>
                    </div>
                    <div>
                        <i class="fas fa-clock fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ $adjustments->where('status', 'approved')->count() }}</h4>
                        <p class="mb-0">تسويات مؤكدة</p>
                    </div>
                    <div>
                        <i class="fas fa-check fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-info text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ number_format($adjustments->sum('total_value_impact'), 0) }}</h4>
                        <p class="mb-0">تأثير القيمة (ر.س)</p>
                    </div>
                    <div>
                        <i class="fas fa-chart-line fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endif
@endsection