@extends('layouts.app')

@section('title', 'تفاصيل استلام البضائع')
@section('page-title', 'تفاصيل استلام البضائع: ' . $goodsReceipt->receipt_number)

@section('page-actions')
    <div class="btn-group" role="group">
        @if($goodsReceipt->status == 'pending')
            <form method="POST" action="{{ route('goods-receipts.confirm', $goodsReceipt) }}" class="d-inline">
                @csrf
                <button type="submit" class="btn btn-success" 
                        onclick="return confirm('هل أنت متأكد من تأكيد الاستلام؟ سيتم تحديث المخزون.')">
                    <i class="fas fa-check me-2"></i>
                    تأكيد الاستلام
                </button>
            </form>
            
            <form method="POST" action="{{ route('goods-receipts.cancel', $goodsReceipt) }}" class="d-inline">
                @csrf
                <button type="submit" class="btn btn-warning" 
                        onclick="return confirm('هل أنت متأكد من إلغاء الاستلام؟')">
                    <i class="fas fa-times me-2"></i>
                    إلغاء الاستلام
                </button>
            </form>
        @endif
        
        <a href="{{ route('goods-receipts.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-right me-2"></i>
            العودة للقائمة
        </a>
    </div>
@endsection

@section('content')
<div class="row">
    <!-- معلومات الاستلام -->
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-info-circle me-2"></i>
                    معلومات الاستلام
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <td><strong>رقم الاستلام:</strong></td>
                                <td>{{ $goodsReceipt->receipt_number }}</td>
                            </tr>
                            <tr>
                                <td><strong>أمر الشراء:</strong></td>
                                <td>
                                    <a href="{{ route('purchase-orders.show', $goodsReceipt->purchaseOrder) }}" class="text-decoration-none">
                                        {{ $goodsReceipt->purchaseOrder->po_number }}
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>المورد:</strong></td>
                                <td>
                                    <a href="{{ route('suppliers.show', $goodsReceipt->purchaseOrder->supplier) }}" class="text-decoration-none">
                                        {{ $goodsReceipt->purchaseOrder->supplier->name }}
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>تاريخ الاستلام:</strong></td>
                                <td>{{ $goodsReceipt->receipt_date->format('Y/m/d') }}</td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <td><strong>الحالة:</strong></td>
                                <td>
                                    @switch($goodsReceipt->status)
                                        @case('pending')
                                            <span class="badge bg-warning">معلق</span>
                                            @break
                                        @case('confirmed')
                                            <span class="badge bg-success">مؤكد</span>
                                            @break
                                        @case('cancelled')
                                            <span class="badge bg-danger">ملغي</span>
                                            @break
                                    @endswitch
                                </td>
                            </tr>
                            <tr>
                                <td><strong>المستلم:</strong></td>
                                <td>{{ $goodsReceipt->user->name }}</td>
                            </tr>
                            <tr>
                                <td><strong>تاريخ الإنشاء:</strong></td>
                                <td>{{ $goodsReceipt->created_at->format('Y/m/d H:i') }}</td>
                            </tr>
                            <tr>
                                <td><strong>آخر تحديث:</strong></td>
                                <td>{{ $goodsReceipt->updated_at->format('Y/m/d H:i') }}</td>
                            </tr>
                        </table>
                    </div>
                </div>
                
                @if($goodsReceipt->notes)
                <div class="row">
                    <div class="col-12">
                        <hr>
                        <strong>ملاحظات:</strong>
                        <p class="mt-2">{{ $goodsReceipt->notes }}</p>
                    </div>
                </div>
                @endif
            </div>
        </div>
        
        <!-- عناصر الاستلام -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-list me-2"></i>
                    عناصر الاستلام
                </h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        
                            <tr>
                                <th>المنتج</th>
                                <th>الكمية المطلوبة</th>
                                <th>الكمية المستلمة</th>
                                <th>الكمية المتبقية</th>
                                <th>تكلفة الوحدة</th>
                                <th>إجمالي التكلفة</th>
                                <th>ملاحظات</th>
                            </tr>
                        <tbody>
                            @foreach($goodsReceipt->items as $item)
                            @php
                                $remainingQuantity = $item->purchaseOrderItem->quantity - $item->purchaseOrderItem->receivedQuantity();
                                $totalCost = $item->received_quantity * $item->unit_cost;
                            @endphp
                            <tr>
                                <td>
                                    <strong>{{ $item->product->name }}</strong>
                                    <br><small class="text-muted">{{ $item->product->sku }}</small>
                                </td>
                                <td>{{ number_format($item->purchaseOrderItem->quantity) }}</td>
                                <td>
                                    <span class="badge bg-success">
                                        {{ number_format($item->received_quantity) }}
                                    </span>
                                </td>
                                <td>
                                    <span class="badge bg-{{ $remainingQuantity > 0 ? 'warning' : 'success' }}">
                                        {{ number_format($remainingQuantity) }}
                                    </span>
                                </td>
                                <td>{{ number_format($item->unit_cost, 2) }} ر.س</td>
                                <td>{{ number_format($totalCost, 2) }} ر.س</td>
                                <td>{{ $item->notes ?? '-' }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                        <tfoot class="table-dark">
                            <tr>
                                <td colspan="2"><strong>الإجمالي</strong></td>
                                <td><strong>{{ number_format($goodsReceipt->items->sum('received_quantity')) }}</strong></td>
                                <td>-</td>
                                <td>-</td>
                                <td><strong>{{ number_format($goodsReceipt->items->sum(function($item) { return $item->received_quantity * $item->unit_cost; }), 2) }} ر.س</strong></td>
                                <td>-</td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
        
        <!-- حركات المخزون المرتبطة -->
        @if($goodsReceipt->status == 'confirmed')
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-exchange-alt me-2"></i>
                    حركات المخزون المرتبطة
                </h5>
            </div>
            <div class="card-body">
                @php
                    $movements = \App\Models\InventoryMovement::where('reference_type', get_class($goodsReceipt))
                        ->where('reference_id', $goodsReceipt->id)
                        ->with('product')
                        ->get();
                @endphp
                
                @if($movements->count() > 0)
                <div class="table-responsive">
                    <table class="table table-sm">
                            <tr>
                                <th>المنتج</th>
                                <th>النوع</th>
                                <th>الكمية</th>
                                <th>تكلفة الوحدة</th>
                                <th>التكلفة الإجمالية</th>
                                <th>التاريخ</th>
                            </tr>
                        <tbody>
                            @foreach($movements as $movement)
                            <tr>
                                <td>{{ $movement->product->name }}</td>
                                <td>
                                    <span class="badge bg-success">
                                        <i class="fas fa-arrow-down me-1"></i> إدخال
                                    </span>
                                </td>
                                <td>{{ number_format($movement->quantity) }}</td>
                                <td>{{ number_format($movement->unit_cost, 2) }} ر.س</td>
                                <td>{{ number_format($movement->total_cost, 2) }} ر.س</td>
                                <td>{{ $movement->movement_date->format('Y/m/d H:i') }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                @else
                <div class="text-center text-muted py-3">
                    <i class="fas fa-info-circle me-2"></i>
                    لم يتم إنشاء حركات مخزون بعد
                </div>
                @endif
            </div>
        </div>
        @endif
    </div>
    
    <!-- ملخص الاستلام -->
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-chart-bar me-2"></i>
                    ملخص الاستلام
                </h5>
            </div>
            <div class="card-body">
                @php
                    $totalItems = $goodsReceipt->items->count();
                    $totalReceived = $goodsReceipt->items->sum('received_quantity');
                    $totalOrdered = $goodsReceipt->items->sum(function($item) {
                        return $item->purchaseOrderItem->quantity;
                    });
                    $totalCost = $goodsReceipt->items->sum(function($item) {
                        return $item->received_quantity * $item->unit_cost;
                    });
                    $completionPercentage = $totalOrdered > 0 ? ($totalReceived / $totalOrdered) * 100 : 0;
                @endphp
                
                <div class="text-center mb-4">
                    <h3 class="text-primary">{{ $totalItems }}</h3>
                    <p class="mb-0">عناصر مستلمة</p>
                </div>
                
                <div class="text-center mb-4">
                    <h3 class="text-success">{{ number_format($totalCost, 2) }}</h3>
                    <p class="mb-0">إجمالي قيمة الاستلام (ر.س)</p>
                </div>
                
                <hr>
                
                <div class="mb-3">
                    <strong>تقدم الاستلام:</strong>
                    <div class="progress mt-2">
                        <div class="progress-bar bg-{{ $completionPercentage == 100 ? 'success' : 'warning' }}" 
                             style="width: {{ $completionPercentage }}%">
                            {{ number_format($completionPercentage, 1) }}%
                        </div>
                    </div>
                    <small class="text-muted">
                        {{ number_format($totalReceived) }} من {{ number_format($totalOrdered) }} مستلم
                    </small>
                </div>
                
                <div class="mb-3">
                    <div class="d-flex justify-content-between">
                        <span>الكمية المطلوبة:</span>
                        <span class="badge bg-primary">{{ number_format($totalOrdered) }}</span>
                    </div>
                </div>
                
                <div class="mb-3">
                    <div class="d-flex justify-content-between">
                        <span>الكمية المستلمة:</span>
                        <span class="badge bg-success">{{ number_format($totalReceived) }}</span>
                    </div>
                </div>
                
                <div class="mb-3">
                    <div class="d-flex justify-content-between">
                        <span>الكمية المتبقية:</span>
                        <span class="badge bg-warning">{{ number_format($totalOrdered - $totalReceived) }}</span>
                    </div>
                </div>
                
                @if($goodsReceipt->status == 'confirmed')
                <div class="alert alert-success">
                    <i class="fas fa-check-circle me-2"></i>
                    تم تأكيد هذا الاستلام وتحديث المخزون
                </div>
                @elseif($goodsReceipt->status == 'pending')
                <div class="alert alert-warning">
                    <i class="fas fa-clock me-2"></i>
                    هذا الاستلام معلق ولم يتم تأكيده بعد
                </div>
                @elseif($goodsReceipt->status == 'cancelled')
                <div class="alert alert-danger">
                    <i class="fas fa-times-circle me-2"></i>
                    تم إلغاء هذا الاستلام
                </div>
                @endif
            </div>
        </div>
        
        <!-- معلومات أمر الشراء -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-shopping-cart me-2"></i>
                    معلومات أمر الشراء
                </h5>
            </div>
            <div class="card-body">
                <table class="table table-sm table-borderless">
                    <tr>
                        <td><strong>رقم الأمر:</strong></td>
                        <td>{{ $goodsReceipt->purchaseOrder->po_number }}</td>
                    </tr>
                    <tr>
                        <td><strong>تاريخ الأمر:</strong></td>
                        <td>{{ $goodsReceipt->purchaseOrder->order_date->format('Y/m/d') }}</td>
                    </tr>
                    <tr>
                        <td><strong>حالة الأمر:</strong></td>
                        <td>
                            @switch($goodsReceipt->purchaseOrder->status)
                                @case('approved')
                                    <span class="badge bg-info">مؤكد</span>
                                    @break
                                @case('sent')
                                    <span class="badge bg-primary">مرسل</span>
                                    @break
                                @case('partially_received')
                                    <span class="badge bg-warning">مستلم جزئي</span>
                                    @break
                                @case('received')
                                    <span class="badge bg-success">مستلم</span>
                                    @break
                            @endswitch
                        </td>
                    </tr>
                    <tr>
                        <td><strong>قيمة الأمر:</strong></td>
                        <td>{{ number_format($goodsReceipt->purchaseOrder->total_amount, 2) }} ر.س</td>
                    </tr>
                </table>
                
                <div class="d-grid">
                    <a href="{{ route('purchase-orders.show', $goodsReceipt->purchaseOrder) }}" class="btn btn-outline-primary btn-sm">
                        <i class="fas fa-eye me-2"></i>
                        عرض تفاصيل الأمر
                    </a>
                </div>
            </div>
        </div>
        
        <!-- الإجراءات السريعة -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-bolt me-2"></i>
                    إجراءات سريعة
                </h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    @if($totalOrdered > $totalReceived)
                        <a href="{{ route('goods-receipts.create', ['purchase_order_id' => $goodsReceipt->purchaseOrder->id]) }}" 
                           class="btn btn-warning btn-sm">
                            <i class="fas fa-dolly me-2"></i>
                            استلام إضافي
                        </a>
                    @endif
                    
                    <button type="button" class="btn btn-success btn-sm" onclick="window.print()">
                        <i class="fas fa-print me-2"></i>
                        طباعة الاستلام
                    </button>
                    
                    <a href="{{ route('inventory.movements', ['reference_type' => get_class($goodsReceipt), 'reference_id' => $goodsReceipt->id]) }}" 
                       class="btn btn-info btn-sm">
                        <i class="fas fa-exchange-alt me-2"></i>
                        عرض حركات المخزون
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
@media print {
    .btn, .card-header, .d-print-none {
        display: none !important;
    }
    
    .card {
        border: 1px solid #000 !important;
        box-shadow: none !important;
        margin-bottom: 20px !important;
    }
    
    .badge {
        color: #000 !important;
        background-color: #fff !important;
        border: 1px solid #000 !important;
    }
}
</style>
@endpush