@extends('layouts.app')

@section('title', 'استلام البضائع')
@section('page-title', 'إدارة استلام البضائع')

@section('page-actions')
    <div class="btn-group" role="group">
        <a href="{{ route('goods-receipts.create') }}" class="btn btn-primary">
            <i class="fas fa-plus me-2"></i>
            إنشاء استلام جديد
        </a>
        <a href="{{ route('purchase-orders.index') }}" class="btn btn-secondary">
            <i class="fas fa-shopping-cart me-2"></i>
            أوامر الشراء
        </a>
    </div>
@endsection

@section('content')
<!-- فلاتر البحث -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('goods-receipts.index') }}">
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="status" class="form-label">الحالة</label>
                        <select class="form-control" id="status" name="status">
                            <option value="">جميع الحالات</option>
                            <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>معلق</option>
                            <option value="confirmed" {{ request('status') == 'confirmed' ? 'selected' : '' }}>مؤكد</option>
                            <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-search me-2"></i>
                                بحث
                            </button>
                            <a href="{{ route('goods-receipts.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times me-2"></i>
                                إعادة تعيين
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- قائمة استلام البضائع -->
<div class="card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fas fa-dolly me-2"></i>
            قائمة استلام البضائع
        </h5>
    </div>
    <div class="card-body">
        @if($receipts->count() > 0)
        <div class="table-responsive">
            <table class="table table-striped">
                    <tr>
                        <th>رقم الاستلام</th>
                        <th>أمر الشراء</th>
                        <th>المورد</th>
                        <th>تاريخ الاستلام</th>
                        <th>عدد العناصر</th>
                        <th>الحالة</th>
                        <th>المستلم</th>
                        <th>الإجراءات</th>
                    </tr>
       
                    @foreach($receipts as $receipt)
                    <tr>
                        <td>
                            <strong>{{ $receipt->receipt_number }}</strong>
                        </td>
                        <td>
                            <a href="{{ route('purchase-orders.show', $receipt->purchaseOrder) }}" class="text-decoration-none">
                                {{ $receipt->purchaseOrder->po_number }}
                            </a>
                        </td>
                        <td>{{ $receipt->purchaseOrder->supplier->name }}</td>
                        <td>{{ $receipt->receipt_date->format('Y/m/d') }}</td>
                        <td>
                            <span class="badge bg-primary">{{ $receipt->items->count() }}</span>
                        </td>
                        <td>
                            @switch($receipt->status)
                                @case('pending')
                                    <span class="badge bg-warning">معلق</span>
                                    @break
                                @case('confirmed')
                                    <span class="badge bg-success">مؤكد</span>
                                    @break
                                @case('cancelled')
                                    <span class="badge bg-danger">ملغي</span>
                                    @break
                            @endswitch
                        </td>
                        <td>{{ $receipt->user->name }}</td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="{{ route('goods-receipts.show', $receipt) }}" class="btn btn-sm btn-info">
                                    <i class="fas fa-eye"></i>
                                </a>
                                
                                @if($receipt->status == 'pending')
                                    <form method="POST" action="{{ route('goods-receipts.confirm', $receipt) }}" class="d-inline">
                                        @csrf
                                        <button type="submit" class="btn btn-sm btn-success" 
                                                onclick="return confirm('هل أنت متأكد من تأكيد الاستلام؟ سيتم تحديث المخزون.')">
                                            <i class="fas fa-check"></i>
                                        </button>
                                    </form>
                                    
                                    <form method="POST" action="{{ route('goods-receipts.cancel', $receipt) }}" class="d-inline">
                                        @csrf
                                        <button type="submit" class="btn btn-sm btn-warning" 
                                                onclick="return confirm('هل أنت متأكد من إلغاء الاستلام؟')">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </form>
                                @endif
                                
                                @if($receipt->status != 'confirmed')
                                    <form method="POST" action="{{ route('goods-receipts.destroy', $receipt) }}" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger" 
                                                onclick="return confirm('هل أنت متأكد من حذف الاستلام؟')">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @endforeach
            </table>
        </div>
        
        <div class="d-flex justify-content-center">
            {{ $receipts->links() }}
        </div>
        @else
        <div class="text-center py-5">
            <i class="fas fa-dolly text-muted" style="font-size: 4rem;"></i>
            <h4 class="mt-3 text-muted">لا توجد عمليات استلام</h4>
            <p class="text-muted">ابدأ بتسجيل أول عملية استلام بضائع</p>
            <a href="{{ route('goods-receipts.create') }}" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i>
                إنشاء استلام جديد
            </a>
        </div>
        @endif
    </div>
</div>

<!-- إحصائيات سريعة -->
@if($receipts->count() > 0)
<div class="row mt-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ $receipts->count() }}</h4>
                        <p class="mb-0">إجمالي الاستلامات</p>
                    </div>
                    <div>
                        <i class="fas fa-dolly fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ $receipts->where('status', 'pending')->count() }}</h4>
                        <p class="mb-0">استلامات معلقة</p>
                    </div>
                    <div>
                        <i class="fas fa-clock fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ $receipts->where('status', 'confirmed')->count() }}</h4>
                        <p class="mb-0">استلامات مؤكدة</p>
                    </div>
                    <div>
                        <i class="fas fa-check fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-info text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ $receipts->sum(function($r) { return $r->items->sum('received_quantity'); }) }}</h4>
                        <p class="mb-0">إجمالي الكمية المستلمة</p>
                    </div>
                    <div>
                        <i class="fas fa-boxes fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- أوامر الشراء المعلقة -->
@php
    $pendingOrders = \App\Models\PurchaseOrder::whereIn('status', ['approved', 'sent', 'partially_received'])
        ->with('supplier')
        ->latest()
        ->take(5)
        ->get();
@endphp

@if($pendingOrders->count() > 0)
<div class="card mt-4">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fas fa-exclamation-triangle me-2"></i>
            أوامر شراء بانتظار الاستلام
        </h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-sm">
                    <tr>
                        <th>رقم الأمر</th>
                        <th>المورد</th>
                        <th>تاريخ الأمر</th>
                        <th>المبلغ</th>
                        <th>الحالة</th>
                        <th>الإجراء</th>
                    </tr>
            
                    @foreach($pendingOrders as $order)
                    <tr>
                        <td>{{ $order->po_number }}</td>
                        <td>{{ $order->supplier->name }}</td>
                        <td>{{ $order->order_date->format('Y/m/d') }}</td>
                        <td>{{ number_format($order->total_amount, 2) }} ر.س</td>
                        <td>
                            @switch($order->status)
                                @case('approved')
                                    <span class="badge bg-info">مؤكد</span>
                                    @break
                                @case('sent')
                                    <span class="badge bg-primary">مرسل</span>
                                    @break
                                @case('partially_received')
                                    <span class="badge bg-warning">مستلم جزئي</span>
                                    @break
                            @endswitch
                        </td>
                        <td>
                            <a href="{{ route('goods-receipts.create', ['purchase_order_id' => $order->id]) }}" 
                               class="btn btn-sm btn-success">
                                <i class="fas fa-dolly me-1"></i> استلام
                            </a>
                        </td>
                    </tr>
                    @endforeach
            </table>
        </div>
    </div>
</div>
@endif
@endif
@endsection