<div class="folder-tree-item">
    <a href="{{ route('file-manager.index', ['folder' => $folder->id]) }}" 
       class="folder-item d-flex align-items-center {{ request('folder') == $folder->id ? 'active' : '' }}">
        <i class="{{ $folder->icon }}" style="color: {{ $folder->color }}; margin-left: 8px;"></i>
        <span class="folder-name flex-grow-1">{{ $folder->name }}</span>
        <div class="folder-stats">
            @if($folder->files_count > 0)
                <small class="text-muted">{{ $folder->files_count }}</small>
            @endif
            @if($folder->children->count() > 0)
                <button class="btn btn-sm btn-link p-0 ms-1 toggle-children" 
                        data-folder-id="{{ $folder->id }}"
                        title="توسيع/طي">
                    <i class="fas fa-chevron-left transition-transform"></i>
                </button>
            @endif
        </div>
    </a>
    
    @if($folder->children->count() > 0)
        <div class="folder-children collapse" id="children-{{ $folder->id }}">
            <div class="ms-3">
                @foreach($folder->children as $childFolder)
                    @include('file-manager.partials.folder-tree-item', ['folder' => $childFolder])
                @endforeach
            </div>
        </div>
    @endif
</div>

<style>
    .folder-tree-item {
        margin-bottom: 2px;
    }
    
    .folder-item {
        display: flex;
        align-items: center;
        padding: 8px 15px;
        color: #333;
        text-decoration: none;
        border-radius: 4px;
        transition: all 0.2s ease;
        position: relative;
    }
    
    .folder-item:hover {
        background-color: #f8f9fa;
        color: #007bff;
        text-decoration: none;
        transform: translateX(-2px);
    }
    
    .folder-item.active {
        background-color: #e3f2fd;
        color: #1976d2;
        border-right: 3px solid #1976d2;
    }
    
    .folder-name {
        font-weight: 500;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
    
    .folder-stats {
        display: flex;
        align-items: center;
        margin-right: 8px;
    }
    
    .folder-stats small {
        background: #e9ecef;
        padding: 2px 6px;
        border-radius: 10px;
        font-size: 0.7rem;
        min-width: 18px;
        text-align: center;
    }
    
    .toggle-children {
        color: #6c757d;
        border: none;
        background: none;
        padding: 0;
        width: 16px;
        height: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .toggle-children:hover {
        color: #007bff;
    }
    
    .toggle-children .fa-chevron-left {
        transition: transform 0.2s ease;
        font-size: 0.8rem;
    }
    
    .toggle-children[aria-expanded="true"] .fa-chevron-left {
        transform: rotate(-90deg);
    }
    
    .folder-children {
        transition: all 0.3s ease;
    }
    
    .folder-children.show {
        border-right: 1px dashed #dee2e6;
        margin-right: 8px;
    }
    
    /* تأثيرات تفاعلية */
    .folder-item::before {
        content: '';
        position: absolute;
        right: 0;
        top: 0;
        bottom: 0;
        width: 0;
        background: linear-gradient(90deg, transparent, rgba(0,123,255,0.1));
        transition: width 0.2s ease;
    }
    
    .folder-item:hover::before {
        width: 100%;
    }
    
    .folder-item.active::before {
        width: 100%;
        background: linear-gradient(90deg, transparent, rgba(25,118,210,0.1));
    }
    
    /* تحسين الإمكانية الوصول */
    .folder-item:focus {
        outline: 2px solid #007bff;
        outline-offset: -2px;
    }
    
    /* حالة التحميل */
    .folder-loading {
        opacity: 0.6;
        pointer-events: none;
    }
    
    .folder-loading::after {
        content: '';
        position: absolute;
        right: 10px;
        top: 50%;
        transform: translateY(-50%);
        width: 12px;
        height: 12px;
        border: 2px solid #f3f3f3;
        border-top: 2px solid #007bff;
        border-radius: 50%;
        animation: spin 1s linear infinite;
    }
    
    @keyframes spin {
        0% { transform: translateY(-50%) rotate(0deg); }
        100% { transform: translateY(-50%) rotate(360deg); }
    }
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // معالجة توسيع/طي المجلدات
    document.querySelectorAll('.toggle-children').forEach(button => {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            
            const folderId = this.dataset.folderId;
            const childrenDiv = document.getElementById(`children-${folderId}`);
            const chevron = this.querySelector('.fa-chevron-left');
            
            if (childrenDiv) {
                // تبديل العرض
                if (childrenDiv.classList.contains('show')) {
                    childrenDiv.classList.remove('show');
                    this.setAttribute('aria-expanded', 'false');
                    chevron.style.transform = 'rotate(0deg)';
                } else {
                    childrenDiv.classList.add('show');
                    this.setAttribute('aria-expanded', 'true');
                    chevron.style.transform = 'rotate(-90deg)';
                }
            }
        });
    });
    
    // تحميل المجلدات الفرعية بشكل تلقائي للمجلد الحالي
    const currentFolderId = new URLSearchParams(window.location.search).get('folder');
    if (currentFolderId) {
        expandParentFolders(currentFolderId);
    }
});

// توسيع المجلدات الأب للمجلد الحالي
function expandParentFolders(folderId) {
    const activeFolder = document.querySelector(`[data-folder-id="${folderId}"]`);
    if (activeFolder) {
        let parent = activeFolder.closest('.folder-children');
        while (parent) {
            parent.classList.add('show');
            const toggleButton = parent.previousElementSibling?.querySelector('.toggle-children');
            if (toggleButton) {
                toggleButton.setAttribute('aria-expanded', 'true');
                const chevron = toggleButton.querySelector('.fa-chevron-left');
                if (chevron) {
                    chevron.style.transform = 'rotate(-90deg)';
                }
            }
            parent = parent.parentElement?.closest('.folder-children');
        }
    }
}

// تحديث الشجرة بعد إضافة/تعديل/حذف مجلد
function refreshFolderTree() {
    // يمكن تحديث الشجرة عبر AJAX إذا لزم الأمر
    location.reload();
}

// إضافة تأثيرات الكيبورد للتنقل
document.addEventListener('keydown', function(e) {
    const activeFolder = document.querySelector('.folder-item.active');
    if (!activeFolder) return;
    
    switch(e.key) {
        case 'ArrowUp':
            e.preventDefault();
            const prevFolder = activeFolder.closest('.folder-tree-item').previousElementSibling?.querySelector('.folder-item');
            if (prevFolder) {
                prevFolder.focus();
                prevFolder.click();
            }
            break;
            
        case 'ArrowDown':
            e.preventDefault();
            const nextFolder = activeFolder.closest('.folder-tree-item').nextElementSibling?.querySelector('.folder-item');
            if (nextFolder) {
                nextFolder.focus();
                nextFolder.click();
            }
            break;
            
        case 'ArrowLeft':
            e.preventDefault();
            const toggleBtn = activeFolder.querySelector('.toggle-children');
            if (toggleBtn && toggleBtn.getAttribute('aria-expanded') === 'true') {
                toggleBtn.click();
            }
            break;
            
        case 'ArrowRight':
            e.preventDefault();
            const expandBtn = activeFolder.querySelector('.toggle-children');
            if (expandBtn && expandBtn.getAttribute('aria-expanded') !== 'true') {
                expandBtn.click();
            }
            break;
            
        case 'Enter':
            e.preventDefault();
            activeFolder.click();
            break;
    }
});
</script>