<tr class="file-row">
    <td>
        <div class="d-flex align-items-center">
            <!-- أيقونة/معاينة الملف -->
            <div class="file-icon-small me-3">
                @if($file->is_image)
                    <img src="{{ $file->file_url }}" alt="{{ $file->name }}" class="file-thumbnail">
                @else
                    <i class="{{ $file->getIcon() }}" style="color: {{ $file->getColor() }}; font-size: 1.5rem;"></i>
                @endif
            </div>
            
            <!-- اسم الملف ومعلومات إضافية -->
            <div>
                <div class="file-name fw-medium">{{ $file->name }}</div>
                <div class="file-meta text-muted small">
                    @if($file->description)
                        <span class="me-2">{{ Str::limit($file->description, 50) }}</span>
                    @endif
                    @if($file->tags && count($file->tags) > 0)
                        <span class="file-tags">
                            @foreach($file->tags as $tag)
                                <span class="badge bg-light text-dark badge-sm me-1">#{{ $tag }}</span>
                            @endforeach
                        </span>
                    @endif
                </div>
            </div>
        </div>
    </td>
    
    <td>
        <div class="d-flex align-items-center">
            <span class="badge" style="background-color: {{ $file->getColor() }}; color: white;">
                {{ strtoupper($file->extension) }}
            </span>
            <small class="text-muted ms-2">{{ $file->mime_type }}</small>
        </div>
    </td>
    
    <td>
        <span class="fw-medium">{{ $file->formatted_size }}</span>
    </td>
    
    <td>
        <div>
            <div class="fw-medium">{{ $file->created_at->format('Y/m/d') }}</div>
            <small class="text-muted">{{ $file->created_at->format('H:i') }}</small>
            <div class="text-muted small">{{ $file->created_at->diffForHumans() }}</div>
        </div>
    </td>
    
    <td>
        <div class="d-flex gap-1">
            <!-- زر التحميل السريع -->
            <a href="{{ $file->download_url }}" class="btn btn-sm btn-outline-primary" title="تحميل">
                <i class="fas fa-download"></i>
            </a>
            
            <!-- زر المعاينة -->
            @if($file->preview_url)
                <a href="{{ $file->preview_url }}" class="btn btn-sm btn-outline-secondary" target="_blank" title="معاينة">
                    <i class="fas fa-eye"></i>
                </a>
            @endif
            
            <!-- قائمة الإجراءات -->
            <div class="dropdown">
                <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                    <i class="fas fa-ellipsis-v"></i>
                </button>
                <ul class="dropdown-menu">
                    <li>
                        <a class="dropdown-item" href="{{ $file->download_url }}">
                            <i class="fas fa-download me-2"></i>
                            تحميل
                        </a>
                    </li>
                    @if($file->preview_url)
                        <li>
                            <a class="dropdown-item" href="{{ $file->preview_url }}" target="_blank">
                                <i class="fas fa-eye me-2"></i>
                                معاينة
                            </a>
                        </li>
                    @endif
                    <li>
                        <button class="dropdown-item" onclick="copyFileLink('{{ $file->file_url }}')">
                            <i class="fas fa-link me-2"></i>
                            نسخ الرابط
                        </button>
                    </li>
                    <li>
                        <button class="dropdown-item" onclick="editFile({{ $file->id }})">
                            <i class="fas fa-edit me-2"></i>
                            تعديل
                        </button>
                    </li>
                    <li>
                        <button class="dropdown-item" onclick="moveFile({{ $file->id }})">
                            <i class="fas fa-arrows-alt me-2"></i>
                            نقل
                        </button>
                    </li>
                    <li>
                        <button class="dropdown-item" onclick="shareFile({{ $file->id }})">
                            <i class="fas fa-share me-2"></i>
                            مشاركة
                        </button>
                    </li>
                    <li><hr class="dropdown-divider"></li>
                    <li>
                        <button class="dropdown-item text-danger" onclick="deleteFile({{ $file->id }})">
                            <i class="fas fa-trash me-2"></i>
                            حذف
                        </button>
                    </li>
                </ul>
            </div>
        </div>
    </td>
</tr>

<!-- معلومات إضافية قابلة للتوسع -->
<tr class="file-details-row d-none" id="details-{{ $file->id }}">
    <td colspan="5">
        <div class="file-details-content p-3 bg-light rounded">
            <div class="row">
                <div class="col-md-6">
                    <h6>معلومات الملف:</h6>
                    <ul class="list-unstyled mb-0">
                        <li><strong>المجلد:</strong> {{ $file->folder ? $file->folder->full_path : 'المجلد الرئيسي' }}</li>
                        <li><strong>التصنيف:</strong> {{ $file->category }}</li>
                        <li><strong>رفعه:</strong> {{ $file->uploader->name }}</li>
                        <li><strong>آخر تحديث:</strong> {{ $file->updated_at->diffForHumans() }}</li>
                    </ul>
                </div>
                <div class="col-md-6">
                    <h6>إحصائيات:</h6>
                    <ul class="list-unstyled mb-0">
                        <li><strong>عدد التحميلات:</strong> {{ $file->download_count }}</li>
                        <li><strong>آخر تحميل:</strong> {{ $file->last_downloaded_at ? $file->last_downloaded_at->diffForHumans() : 'لا يوجد' }}</li>
                        <li><strong>Hash:</strong> <code class="small">{{ Str::limit($file->hash, 16) }}...</code></li>
                        <li><strong>حالة الوصول:</strong> 
                            @if($file->is_public)
                                <span class="badge bg-success">عام</span>
                            @else
                                <span class="badge bg-warning">خاص</span>
                            @endif
                        </li>
                    </ul>
                </div>
            </div>
            
            @if($file->description)
                <div class="mt-3">
                    <h6>الوصف:</h6>
                    <p class="text-muted mb-0">{{ $file->description }}</p>
                </div>
            @endif
            
            @if($file->tags && count($file->tags) > 0)
                <div class="mt-3">
                    <h6>العلامات:</h6>
                    @foreach($file->tags as $tag)
                        <span class="badge bg-primary me-1">#{{ $tag }}</span>
                    @endforeach
                </div>
            @endif
        </div>
    </td>
</tr>

<style>
    .file-row {
        cursor: pointer;
        transition: background-color 0.2s ease;
    }
    
    .file-row:hover {
        background-color: #f8f9fa;
    }
    
    .file-thumbnail {
        width: 40px;
        height: 40px;
        object-fit: cover;
        border-radius: 4px;
        border: 1px solid #dee2e6;
    }
    
    .file-icon-small {
        width: 50px;
        text-align: center;
    }
    
    .file-name {
        color: #333;
        text-decoration: none;
    }
    
    .file-name:hover {
        color: #007bff;
        text-decoration: underline;
    }
    
    .file-tags .badge {
        font-size: 0.7rem;
    }
    
    .file-details-content {
        border-left: 4px solid #007bff;
        margin: 5px 0;
    }
    
    .badge-sm {
        font-size: 0.7rem;
        padding: 0.25em 0.4em;
    }
</style>

<script>
// تبديل عرض تفاصيل الملف
document.addEventListener('DOMContentLoaded', function() {
    // النقر على صف الملف لإظهار/إخفاء التفاصيل
    document.querySelectorAll('.file-row').forEach(row => {
        row.addEventListener('click', function(e) {
            // تجاهل النقر على الأزرار والروابط
            if (e.target.closest('a, button, .dropdown')) {
                return;
            }
            
            const fileId = this.id?.replace('file-', '') || 
                          this.querySelector('[onclick*="editFile"]')?.getAttribute('onclick')?.match(/\d+/)?.[0];
            
            if (fileId) {
                toggleFileDetails(fileId);
            }
        });
    });
});

// تبديل عرض تفاصيل الملف
function toggleFileDetails(fileId) {
    const detailsRow = document.getElementById(`details-${fileId}`);
    if (detailsRow) {
        detailsRow.classList.toggle('d-none');
    }
}

// نقل الملف
function moveFile(fileId) {
    // يمكن إضافة نافذة منبثقة لاختيار المجلد الوجهة
    console.log('نقل الملف:', fileId);
    // هذه دالة placeholder - يمكن تطويرها لاحقاً
}
</script>