<div class="file-card border rounded p-3 text-center position-relative h-100">
    <!-- معاينة الملف -->
    <div class="file-preview mb-3">
        @if($file->is_image)
            <img src="{{ $file->file_url }}" alt="{{ $file->name }}" class="file-preview-img">
        @else
            <div class="file-icon">
                <i class="{{ $file->getIcon() }}" style="color: {{ $file->getColor() }}"></i>
            </div>
        @endif
    </div>

    <!-- اسم الملف -->
    <h6 class="file-name mb-2" title="{{ $file->name }}">
        {{ Str::limit($file->name, 20) }}
    </h6>

    <!-- معلومات الملف -->
    <div class="file-info text-muted">
        <small class="d-block">{{ $file->formatted_size }}</small>
        <small class="d-block">{{ $file->created_at->diffForHumans() }}</small>
        @if($file->download_count > 0)
            <small class="d-block">
                <i class="fas fa-download me-1"></i>
                {{ $file->download_count }}
            </small>
        @endif
    </div>

    <!-- شارات الملف -->
    <div class="file-badges mt-2">
        @if($file->is_public)
            <span class="badge bg-success badge-sm">
                <i class="fas fa-globe me-1"></i>
                عام
            </span>
        @endif
        @if($file->category !== 'general')
            <span class="badge bg-secondary badge-sm">
                {{ $file->category }}
            </span>
        @endif
    </div>

    <!-- قائمة الإجراءات -->
    <div class="file-actions position-absolute top-0 end-0 p-2">
        <div class="dropdown">
            <button class="btn btn-sm btn-outline-secondary btn-action" data-bs-toggle="dropdown" aria-expanded="false">
                <i class="fas fa-ellipsis-v"></i>
            </button>
            <ul class="dropdown-menu">
                <li>
                    <a class="dropdown-item" href="{{ $file->download_url }}" target="_blank">
                        <i class="fas fa-download me-2"></i>
                        تحميل
                    </a>
                </li>
                @if($file->preview_url)
                    <li>
                        <a class="dropdown-item" href="{{ $file->preview_url }}" target="_blank">
                            <i class="fas fa-eye me-2"></i>
                            معاينة
                        </a>
                    </li>
                @endif
                <li>
                    <button class="dropdown-item" onclick="copyFileLink('{{ $file->file_url }}')">
                        <i class="fas fa-link me-2"></i>
                        نسخ الرابط
                    </button>
                </li>
                <li>
                    <button class="dropdown-item" onclick="editFile({{ $file->id }})">
                        <i class="fas fa-edit me-2"></i>
                        تعديل
                    </button>
                </li>
                <li>
                    <button class="dropdown-item" onclick="shareFile({{ $file->id }})">
                        <i class="fas fa-share me-2"></i>
                        مشاركة
                    </button>
                </li>
                <li><hr class="dropdown-divider"></li>
                <li>
                    <button class="dropdown-item text-danger" onclick="deleteFile({{ $file->id }})">
                        <i class="fas fa-trash me-2"></i>
                        حذف
                    </button>
                </li>
            </ul>
        </div>
    </div>

    <!-- رابط سريع للتحميل -->
    <a href="{{ $file->download_url }}" class="file-quick-download" title="تحميل سريع">
        <i class="fas fa-download"></i>
    </a>
</div>

<style>
    .file-card {
        transition: all 0.3s ease;
        cursor: pointer;
        min-height: 200px;
        background: #fff;
    }
    
    .file-card:hover {
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        transform: translateY(-2px);
    }
    
    .file-preview-img {
        width: 100%;
        height: 80px;
        object-fit: cover;
        border-radius: 8px;
    }
    
    .file-icon {
        font-size: 3rem;
        margin-bottom: 10px;
    }
    
    .file-name {
        font-weight: 500;
        color: #333;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
    
    .file-info {
        font-size: 0.75rem;
    }
    
    .file-badges .badge {
        font-size: 0.65rem;
        margin: 0 2px;
    }
    
    .btn-action {
        background: rgba(255,255,255,0.9);
        border: 1px solid rgba(0,0,0,0.1);
        backdrop-filter: blur(5px);
    }
    
    .file-quick-download {
        position: absolute;
        bottom: 10px;
        right: 10px;
        width: 30px;
        height: 30px;
        background: #007bff;
        color: white;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        text-decoration: none;
        opacity: 0;
        transition: all 0.3s ease;
        transform: scale(0.8);
    }
    
    .file-card:hover .file-quick-download {
        opacity: 1;
        transform: scale(1);
    }
    
    .file-quick-download:hover {
        background: #0056b3;
        color: white;
        text-decoration: none;
    }
</style>

<script>
// نسخ رابط الملف
function copyFileLink(url) {
    navigator.clipboard.writeText(url).then(function() {
        // إظهار توست
        showToast('تم نسخ الرابط بنجاح', 'success');
    }).catch(function(err) {
        console.error('خطأ في نسخ الرابط: ', err);
        // fallback للمتصفحات القديمة
        const textArea = document.createElement('textarea');
        textArea.value = url;
        document.body.appendChild(textArea);
        textArea.select();
        document.execCommand('copy');
        document.body.removeChild(textArea);
        showToast('تم نسخ الرابط بنجاح', 'success');
    });
}

// مشاركة الملف
function shareFile(fileId) {
    // يمكن إضافة نافذة مشاركة متقدمة هنا
    const url = window.location.origin + '/file-manager/files/' + fileId + '/download';
    copyFileLink(url);
}

// إظهار التوست
function showToast(message, type = 'info') {
    // إنشاء عنصر التوست
    const toastHtml = `
        <div class="toast align-items-center text-bg-${type} border-0" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="d-flex">
                <div class="toast-body">
                    ${message}
                </div>
                <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
            </div>
        </div>
    `;
    
    // إضافة التوست للصفحة
    let toastContainer = document.querySelector('.toast-container');
    if (!toastContainer) {
        toastContainer = document.createElement('div');
        toastContainer.className = 'toast-container position-fixed bottom-0 end-0 p-3';
        document.body.appendChild(toastContainer);
    }
    
    toastContainer.insertAdjacentHTML('beforeend', toastHtml);
    
    // إظهار التوست
    const toastElement = toastContainer.lastElementChild;
    const toast = new bootstrap.Toast(toastElement);
    toast.show();
    
    // إزالة التوست بعد اختفائه
    toastElement.addEventListener('hidden.bs.toast', function() {
        toastElement.remove();
    });
}
</script>