<!-- نافذة رفع الملفات -->
<div class="modal fade" id="uploadModal" tabindex="-1" aria-labelledby="uploadModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="uploadModalLabel">
                    <i class="fas fa-upload me-2"></i>
                    رفع ملفات جديدة
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
            </div>
            
            <form action="{{ route('file-manager.upload') }}" method="POST" enctype="multipart/form-data" id="uploadForm">
                @csrf
                @if(request('folder'))
                    <input type="hidden" name="folder_id" value="{{ request('folder') }}">
                @endif
                
                <div class="modal-body">
                    <!-- منطقة إسقاط الملفات -->
                    <div class="upload-zone border-2 border-dashed rounded p-4 text-center mb-4" 
                         ondrop="dropHandler(event);" 
                         ondragover="dragOverHandler(event);"
                         ondragleave="dragLeaveHandler(event);">
                        <i class="fas fa-cloud-upload-alt fa-3x text-muted mb-3"></i>
                        <h5>اسحب الملفات هنا أو انقر للاختيار</h5>
                        <p class="text-muted mb-3">
                            الحد الأقصى: 50 ميجابايت لكل ملف<br>
                            الأنواع المدعومة: الصور، المستندات، الفيديو، الصوت
                        </p>
                        <input type="file" name="files[]" multiple accept="image/*,video/*,audio/*,.pdf,.doc,.docx,.xls,.xlsx,.ppt,.pptx,.txt,.csv,.zip,.rar" 
                               class="form-control d-none" id="fileInput">
                        <button type="button" class="btn btn-primary" onclick="document.getElementById('fileInput').click()">
                            <i class="fas fa-folder-open me-2"></i>
                            اختيار ملفات
                        </button>
                    </div>

                    <!-- قائمة الملفات المختارة -->
                    <div id="selectedFiles" class="d-none">
                        <h6 class="mb-3">الملفات المختارة:</h6>
                        <div class="selected-files-list"></div>
                    </div>

                    <!-- خيارات إضافية -->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="category" class="form-label">التصنيف</label>
                                <select name="category" id="category" class="form-select">
                                    <option value="general">عام</option>
                                    <option value="documents">مستندات</option>
                                    <option value="images">صور</option>
                                    <option value="videos">فيديوهات</option>
                                    <option value="audio">ملفات صوتية</option>
                                    <option value="archives">أرشيف</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="tags" class="form-label">العلامات (مفصولة بفواصل)</label>
                                <input type="text" name="tags" id="tags" class="form-control" placeholder="مثال: مهم, عمل, مشروع">
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="description" class="form-label">وصف الملفات</label>
                        <textarea name="description" id="description" class="form-control" rows="3" placeholder="وصف اختياري للملفات"></textarea>
                    </div>

                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="is_public" id="is_public">
                        <label class="form-check-label" for="is_public">
                            جعل الملفات عامة (يمكن الوصول إليها بدون تسجيل دخول)
                        </label>
                    </div>

                    <!-- شريط التقدم -->
                    <div id="uploadProgress" class="progress mt-3 d-none">
                        <div class="progress-bar" role="progressbar" style="width: 0%"></div>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary" id="uploadBtn" disabled>
                        <i class="fas fa-upload me-2"></i>
                        رفع الملفات
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
    .upload-zone {
        border-color: #dee2e6 !important;
        transition: all 0.3s ease;
        cursor: pointer;
    }
    
    .upload-zone:hover,
    .upload-zone.dragover {
        border-color: #007bff !important;
        background-color: #f8f9ff;
    }
    
    .selected-file-item {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 8px 12px;
        margin-bottom: 8px;
        background-color: #f8f9fa;
        border: 1px solid #dee2e6;
        border-radius: 4px;
    }
    
    .file-info {
        display: flex;
        align-items: center;
    }
    
    .file-info i {
        margin-left: 8px;
        width: 20px;
        text-align: center;
    }
    
    .file-size {
        font-size: 0.875rem;
        color: #6c757d;
    }
    
    .remove-file {
        border: none;
        background: none;
        color: #dc3545;
        cursor: pointer;
    }
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const fileInput = document.getElementById('fileInput');
    const uploadBtn = document.getElementById('uploadBtn');
    const selectedFilesDiv = document.getElementById('selectedFiles');
    const selectedFilesList = document.querySelector('.selected-files-list');
    const uploadZone = document.querySelector('.upload-zone');
    let selectedFiles = [];

    // النقر على منطقة الرفع
    uploadZone.addEventListener('click', function() {
        fileInput.click();
    });

    // تغيير الملفات المختارة
    fileInput.addEventListener('change', function() {
        handleFiles(this.files);
    });

    // إسقاط الملفات
    window.dropHandler = function(ev) {
        ev.preventDefault();
        uploadZone.classList.remove('dragover');
        handleFiles(ev.dataTransfer.files);
    };

    window.dragOverHandler = function(ev) {
        ev.preventDefault();
        uploadZone.classList.add('dragover');
    };

    window.dragLeaveHandler = function(ev) {
        ev.preventDefault();
        uploadZone.classList.remove('dragover');
    };

    function handleFiles(files) {
        selectedFiles = Array.from(files);
        displaySelectedFiles();
        uploadBtn.disabled = selectedFiles.length === 0;
    }

    function displaySelectedFiles() {
        if (selectedFiles.length === 0) {
            selectedFilesDiv.classList.add('d-none');
            return;
        }

        selectedFilesDiv.classList.remove('d-none');
        selectedFilesList.innerHTML = '';

        selectedFiles.forEach((file, index) => {
            const fileItem = document.createElement('div');
            fileItem.className = 'selected-file-item';
            fileItem.innerHTML = `
                <div class="file-info">
                    <i class="${getFileIcon(file)}"></i>
                    <div>
                        <div class="file-name">${file.name}</div>
                        <div class="file-size">${formatFileSize(file.size)}</div>
                    </div>
                </div>
                <button type="button" class="remove-file" onclick="removeFile(${index})">
                    <i class="fas fa-times"></i>
                </button>
            `;
            selectedFilesList.appendChild(fileItem);
        });
    }

    window.removeFile = function(index) {
        selectedFiles.splice(index, 1);
        displaySelectedFiles();
        uploadBtn.disabled = selectedFiles.length === 0;
        
        // تحديث input الملفات
        const dt = new DataTransfer();
        selectedFiles.forEach(file => dt.items.add(file));
        fileInput.files = dt.files;
    };

    function getFileIcon(file) {
        const type = file.type;
        if (type.startsWith('image/')) return 'fas fa-image text-danger';
        if (type.startsWith('video/')) return 'fas fa-video text-primary';
        if (type.startsWith('audio/')) return 'fas fa-music text-warning';
        if (type === 'application/pdf') return 'fas fa-file-pdf text-danger';
        if (type.includes('word')) return 'fas fa-file-word text-primary';
        if (type.includes('excel') || type.includes('spreadsheet')) return 'fas fa-file-excel text-success';
        if (type.includes('powerpoint') || type.includes('presentation')) return 'fas fa-file-powerpoint text-warning';
        if (type.includes('zip') || type.includes('rar')) return 'fas fa-file-archive text-secondary';
        return 'fas fa-file text-secondary';
    }

    function formatFileSize(bytes) {
        if (bytes === 0) return '0 Bytes';
        const k = 1024;
        const sizes = ['Bytes', 'KB', 'MB', 'GB'];
        const i = Math.floor(Math.log(bytes) / Math.log(k));
        return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
    }

    // معالجة إرسال النموذج
    document.getElementById('uploadForm').addEventListener('submit', function(e) {
        if (selectedFiles.length === 0) {
            e.preventDefault();
            alert('يرجى اختيار ملفات للرفع');
            return;
        }

        // إظهار شريط التقدم
        document.getElementById('uploadProgress').classList.remove('d-none');
        uploadBtn.disabled = true;
        uploadBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>جاري الرفع...';
    });
});
</script>