<!-- نافذة تعديل المجلد -->
<div class="modal fade" id="editFolderModal" tabindex="-1" aria-labelledby="editFolderModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editFolderModalLabel">
                    <i class="fas fa-folder-open me-2"></i>
                    تعديل المجلد
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
            </div>
            
            <form id="editFolderForm" method="POST">
                @csrf
                @method('PUT')
                
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="editFolderName" class="form-label">اسم المجلد</label>
                        <input type="text" name="name" id="editFolderName" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label for="editFolderDescription" class="form-label">الوصف</label>
                        <textarea name="description" id="editFolderDescription" class="form-control" rows="3" placeholder="وصف المجلد"></textarea>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="editFolderColor" class="form-label">لون المجلد</label>
                                <div class="d-flex gap-2 flex-wrap">
                                    <input type="radio" class="btn-check" name="color" id="editColor1" value="#3498db">
                                    <label class="btn color-option" for="editColor1" style="background-color: #3498db;"></label>
                                    
                                    <input type="radio" class="btn-check" name="color" id="editColor2" value="#e74c3c">
                                    <label class="btn color-option" for="editColor2" style="background-color: #e74c3c;"></label>
                                    
                                    <input type="radio" class="btn-check" name="color" id="editColor3" value="#2ecc71">
                                    <label class="btn color-option" for="editColor3" style="background-color: #2ecc71;"></label>
                                    
                                    <input type="radio" class="btn-check" name="color" id="editColor4" value="#f39c12">
                                    <label class="btn color-option" for="editColor4" style="background-color: #f39c12;"></label>
                                    
                                    <input type="radio" class="btn-check" name="color" id="editColor5" value="#9b59b6">
                                    <label class="btn color-option" for="editColor5" style="background-color: #9b59b6;"></label>
                                    
                                    <input type="radio" class="btn-check" name="color" id="editColor6" value="#1abc9c">
                                    <label class="btn color-option" for="editColor6" style="background-color: #1abc9c;"></label>
                                    
                                    <input type="radio" class="btn-check" name="color" id="editColor7" value="#34495e">
                                    <label class="btn color-option" for="editColor7" style="background-color: #34495e;"></label>
                                    
                                    <input type="radio" class="btn-check" name="color" id="editColor8" value="#95a5a6">
                                    <label class="btn color-option" for="editColor8" style="background-color: #95a5a6;"></label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">معاينة المجلد</label>
                                <div class="folder-preview text-center p-3 border rounded">
                                    <i class="fas fa-folder fa-3x" id="editFolderPreviewIcon"></i>
                                    <div class="mt-2" id="editFolderPreviewName">اسم المجلد</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="is_public" id="editFolderIsPublic">
                        <label class="form-check-label" for="editFolderIsPublic">
                            جعل المجلد عاماً (يمكن الوصول إليه بدون تسجيل دخول)
                        </label>
                    </div>

                    <!-- معلومات إضافية -->
                    <div class="mt-4 p-3 bg-light rounded">
                        <h6 class="mb-2">إحصائيات المجلد:</h6>
                        <div class="row">
                            <div class="col-6">
                                <small class="text-muted">عدد الملفات:</small>
                                <div id="editFolderFilesCount">-</div>
                            </div>
                            <div class="col-6">
                                <small class="text-muted">المجلدات الفرعية:</small>
                                <div id="editFolderSubfoldersCount">-</div>
                            </div>
                            <div class="col-6 mt-2">
                                <small class="text-muted">الحجم الإجمالي:</small>
                                <div id="editFolderTotalSize">-</div>
                            </div>
                            <div class="col-6 mt-2">
                                <small class="text-muted">تاريخ الإنشاء:</small>
                                <div id="editFolderCreatedAt">-</div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-2"></i>
                        حفظ التعديلات
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// دالة تعديل المجلد
function editFolder(folderId) {
    // جلب بيانات المجلد
    fetch(`/file-manager/folders/${folderId}/edit`)
        .then(response => response.json())
        .then(folder => {
            // ملء النموذج
            document.getElementById('editFolderName').value = folder.name;
            document.getElementById('editFolderDescription').value = folder.description || '';
            document.getElementById('editFolderIsPublic').checked = folder.is_public;
            
            // تحديد اللون المختار
            const colorRadios = document.querySelectorAll('#editFolderModal input[name="color"]');
            colorRadios.forEach(radio => {
                radio.checked = radio.value === folder.color;
            });
            
            // تحديث المعاينة
            document.getElementById('editFolderPreviewName').textContent = folder.name;
            document.getElementById('editFolderPreviewIcon').style.color = folder.color;
            
            // ملء الإحصائيات
            document.getElementById('editFolderFilesCount').textContent = folder.files_count;
            document.getElementById('editFolderSubfoldersCount').textContent = folder.subfolders_count;
            document.getElementById('editFolderTotalSize').textContent = folder.formatted_total_size;
            document.getElementById('editFolderCreatedAt').textContent = new Date(folder.created_at).toLocaleDateString('ar-SA');
            
            // تحديث action النموذج
            document.getElementById('editFolderForm').action = `/file-manager/folders/${folderId}`;
            
            // إظهار النافذة
            new bootstrap.Modal(document.getElementById('editFolderModal')).show();
        })
        .catch(error => {
            console.error('خطأ في جلب بيانات المجلد:', error);
            alert('حدث خطأ في جلب بيانات المجلد');
        });
}

document.addEventListener('DOMContentLoaded', function() {
    const editFolderNameInput = document.getElementById('editFolderName');
    const editFolderPreviewName = document.getElementById('editFolderPreviewName');
    const editFolderPreviewIcon = document.getElementById('editFolderPreviewIcon');
    const editColorOptions = document.querySelectorAll('#editFolderModal input[name="color"]');

    // تحديث اسم المجلد في المعاينة
    editFolderNameInput.addEventListener('input', function() {
        const name = this.value.trim();
        editFolderPreviewName.textContent = name || 'اسم المجلد';
    });

    // تحديث لون المجلد في المعاينة
    editColorOptions.forEach(option => {
        option.addEventListener('change', function() {
            if (this.checked) {
                editFolderPreviewIcon.style.color = this.value;
            }
        });
    });
});
</script>