<!-- نافذة تعديل الملف -->
<div class="modal fade" id="editFileModal" tabindex="-1" aria-labelledby="editFileModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editFileModalLabel">
                    <i class="fas fa-edit me-2"></i>
                    تعديل معلومات الملف
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
            </div>
            
            <form id="editFileForm" method="POST">
                @csrf
                @method('PUT')
                
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="editFileName" class="form-label">اسم الملف</label>
                        <input type="text" name="name" id="editFileName" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label for="editFileDescription" class="form-label">الوصف</label>
                        <textarea name="description" id="editFileDescription" class="form-control" rows="3" placeholder="وصف الملف"></textarea>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="editFileCategory" class="form-label">التصنيف</label>
                                <select name="category" id="editFileCategory" class="form-select">
                                    <option value="general">عام</option>
                                    <option value="documents">مستندات</option>
                                    <option value="images">صور</option>
                                    <option value="videos">فيديوهات</option>
                                    <option value="audio">ملفات صوتية</option>
                                    <option value="archives">أرشيف</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="editFileTags" class="form-label">العلامات (مفصولة بفواصل)</label>
                                <input type="text" name="tags" id="editFileTags" class="form-control" placeholder="مثال: مهم, عمل, مشروع">
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="editFileFolder" class="form-label">المجلد</label>
                        <select name="folder_id" id="editFileFolder" class="form-select">
                            <option value="">المجلد الرئيسي</option>
                            <!-- سيتم ملؤها عبر JavaScript -->
                        </select>
                    </div>

                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="is_public" id="editFileIsPublic">
                        <label class="form-check-label" for="editFileIsPublic">
                            جعل الملف عاماً (يمكن الوصول إليه بدون تسجيل دخول)
                        </label>
                    </div>

                    <!-- معلومات إضافية -->
                    <div class="mt-4 p-3 bg-light rounded">
                        <h6 class="mb-2">معلومات الملف:</h6>
                        <div class="row">
                            <div class="col-6">
                                <small class="text-muted">الحجم:</small>
                                <div id="editFileSize">-</div>
                            </div>
                            <div class="col-6">
                                <small class="text-muted">النوع:</small>
                                <div id="editFileType">-</div>
                            </div>
                            <div class="col-6 mt-2">
                                <small class="text-muted">تاريخ الرفع:</small>
                                <div id="editFileDate">-</div>
                            </div>
                            <div class="col-6 mt-2">
                                <small class="text-muted">عدد التحميلات:</small>
                                <div id="editFileDownloads">-</div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-2"></i>
                        حفظ التعديلات
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// دالة تعديل الملف
function editFile(fileId) {
    // جلب بيانات الملف
    fetch(`/file-manager/files/${fileId}/edit`)
        .then(response => response.json())
        .then(file => {
            // ملء النموذج
            document.getElementById('editFileName').value = file.name;
            document.getElementById('editFileDescription').value = file.description || '';
            document.getElementById('editFileCategory').value = file.category;
            document.getElementById('editFileTags').value = file.tags ? file.tags.join(', ') : '';
            document.getElementById('editFileFolder').value = file.folder_id || '';
            document.getElementById('editFileIsPublic').checked = file.is_public;
            
            // ملء المعلومات الإضافية
            document.getElementById('editFileSize').textContent = file.formatted_size;
            document.getElementById('editFileType').textContent = file.extension.toUpperCase();
            document.getElementById('editFileDate').textContent = new Date(file.created_at).toLocaleDateString('ar-SA');
            document.getElementById('editFileDownloads').textContent = file.download_count;
            
            // تحديث action النموذج
            document.getElementById('editFileForm').action = `/file-manager/files/${fileId}`;
            
            // إظهار النافذة
            new bootstrap.Modal(document.getElementById('editFileModal')).show();
        })
        .catch(error => {
            console.error('خطأ في جلب بيانات الملف:', error);
            alert('حدث خطأ في جلب بيانات الملف');
        });
}

// تحميل قائمة المجلدات عند فتح النافذة
document.getElementById('editFileModal').addEventListener('show.bs.modal', function() {
    const folderSelect = document.getElementById('editFileFolder');
    
    // جلب قائمة المجلدات
    fetch('/file-manager/folders/list')
        .then(response => response.json())
        .then(folders => {
            // مسح الخيارات الحالية
            folderSelect.innerHTML = '<option value="">المجلد الرئيسي</option>';
            
            // إضافة المجلدات
            folders.forEach(folder => {
                const option = document.createElement('option');
                option.value = folder.id;
                option.textContent = folder.full_path;
                folderSelect.appendChild(option);
            });
        })
        .catch(error => {
            console.error('خطأ في جلب قائمة المجلدات:', error);
        });
});
</script>