<!-- نافذة إنشاء مجلد -->
<div class="modal fade" id="createFolderModal" tabindex="-1" aria-labelledby="createFolderModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="createFolderModalLabel">
                    <i class="fas fa-folder-plus me-2"></i>
                    إنشاء مجلد جديد
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
            </div>
            
            <form action="{{ route('file-manager.folders.create') }}" method="POST">
                @csrf
                @if(request('folder'))
                    <input type="hidden" name="parent_id" value="{{ request('folder') }}">
                @endif
                
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="folderName" class="form-label">اسم المجلد</label>
                        <input type="text" name="name" id="folderName" class="form-control" required placeholder="أدخل اسم المجلد">
                    </div>

                    <div class="mb-3">
                        <label for="folderDescription" class="form-label">الوصف (اختياري)</label>
                        <textarea name="description" id="folderDescription" class="form-control" rows="3" placeholder="وصف المجلد"></textarea>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="folderColor" class="form-label">لون المجلد</label>
                                <div class="d-flex gap-2 flex-wrap">
                                    <input type="radio" class="btn-check" name="color" id="color1" value="#3498db" checked>
                                    <label class="btn color-option" for="color1" style="background-color: #3498db;"></label>
                                    
                                    <input type="radio" class="btn-check" name="color" id="color2" value="#e74c3c">
                                    <label class="btn color-option" for="color2" style="background-color: #e74c3c;"></label>
                                    
                                    <input type="radio" class="btn-check" name="color" id="color3" value="#2ecc71">
                                    <label class="btn color-option" for="color3" style="background-color: #2ecc71;"></label>
                                    
                                    <input type="radio" class="btn-check" name="color" id="color4" value="#f39c12">
                                    <label class="btn color-option" for="color4" style="background-color: #f39c12;"></label>
                                    
                                    <input type="radio" class="btn-check" name="color" id="color5" value="#9b59b6">
                                    <label class="btn color-option" for="color5" style="background-color: #9b59b6;"></label>
                                    
                                    <input type="radio" class="btn-check" name="color" id="color6" value="#1abc9c">
                                    <label class="btn color-option" for="color6" style="background-color: #1abc9c;"></label>
                                    
                                    <input type="radio" class="btn-check" name="color" id="color7" value="#34495e">
                                    <label class="btn color-option" for="color7" style="background-color: #34495e;"></label>
                                    
                                    <input type="radio" class="btn-check" name="color" id="color8" value="#95a5a6">
                                    <label class="btn color-option" for="color8" style="background-color: #95a5a6;"></label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">معاينة المجلد</label>
                                <div class="folder-preview text-center p-3 border rounded">
                                    <i class="fas fa-folder fa-3x" id="folderPreviewIcon"></i>
                                    <div class="mt-2" id="folderPreviewName">مجلد جديد</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="is_public" id="folderIsPublic">
                        <label class="form-check-label" for="folderIsPublic">
                            جعل المجلد عاماً (يمكن الوصول إليه بدون تسجيل دخول)
                        </label>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-folder-plus me-2"></i>
                        إنشاء المجلد
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
    .color-option {
        width: 30px;
        height: 30px;
        border-radius: 50%;
        border: 2px solid #dee2e6;
        position: relative;
    }
    
    .color-option:hover {
        transform: scale(1.1);
        border-color: #007bff;
    }
    
    .btn-check:checked + .color-option {
        border-color: #007bff;
        border-width: 3px;
    }
    
    .btn-check:checked + .color-option::after {
        content: '✓';
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        color: white;
        font-weight: bold;
        font-size: 12px;
        text-shadow: 1px 1px 1px rgba(0,0,0,0.5);
    }
    
    .folder-preview {
        background-color: #f8f9fa;
    }
    
    #folderPreviewIcon {
        color: #3498db;
        transition: color 0.3s ease;
    }
    
    #folderPreviewName {
        font-weight: 500;
        color: #495057;
    }
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const folderNameInput = document.getElementById('folderName');
    const folderPreviewName = document.getElementById('folderPreviewName');
    const folderPreviewIcon = document.getElementById('folderPreviewIcon');
    const colorOptions = document.querySelectorAll('input[name="color"]');

    // تحديث اسم المجلد في المعاينة
    folderNameInput.addEventListener('input', function() {
        const name = this.value.trim();
        folderPreviewName.textContent = name || 'مجلد جديد';
    });

    // تحديث لون المجلد في المعاينة
    colorOptions.forEach(option => {
        option.addEventListener('change', function() {
            if (this.checked) {
                folderPreviewIcon.style.color = this.value;
            }
        });
    });

    // إعادة تعيين النموذج عند إغلاق النافذة
    const modal = document.getElementById('createFolderModal');
    modal.addEventListener('hidden.bs.modal', function() {
        folderNameInput.value = '';
        document.getElementById('folderDescription').value = '';
        document.getElementById('folderIsPublic').checked = false;
        folderPreviewName.textContent = 'مجلد جديد';
        folderPreviewIcon.style.color = '#3498db';
        document.getElementById('color1').checked = true;
    });
});
</script>