@extends('layouts.app')

@section('title', 'إدارة الملفات')

@section('page-title', 'إدارة الملفات')

@section('page-actions')
    <div class="btn-group" role="group">
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#uploadModal">
            <i class="fas fa-upload me-2"></i>
            رفع ملفات
        </button>
        <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#createFolderModal">
            <i class="fas fa-folder-plus me-2"></i>
            إنشاء مجلد
        </button>
        <div class="btn-group" role="group">
            <button type="button" class="btn btn-secondary dropdown-toggle" data-bs-toggle="dropdown">
                <i class="fas fa-filter me-2"></i>
                فلترة
            </button>
            <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="{{ route('file-manager.index') }}">جميع الملفات</a></li>
                <li><a class="dropdown-item" href="{{ route('file-manager.index', ['type' => 'image']) }}">الصور</a></li>
                <li><a class="dropdown-item" href="{{ route('file-manager.index', ['type' => 'video']) }}">الفيديوهات</a></li>
                <li><a class="dropdown-item" href="{{ route('file-manager.index', ['type' => 'audio']) }}">الملفات الصوتية</a></li>
                <li><a class="dropdown-item" href="{{ route('file-manager.index', ['type' => 'application']) }}">المستندات</a></li>
            </ul>
        </div>
    </div>
@endsection

@section('content')
<div class="row">
    <!-- شريط جانبي للتصفح -->
    <div class="col-md-3">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-folder-tree me-2"></i>
                    هيكل المجلدات
                </h5>
            </div>
            <div class="card-body p-0">
                <div class="file-tree">
                    @if($currentFolder)
                        <!-- مسار التنقل -->
                        <div class="breadcrumb-container p-3 border-bottom">
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb mb-0">
                                    <li class="breadcrumb-item">
                                        <a href="{{ route('file-manager.index') }}">
                                            <i class="fas fa-home"></i>
                                        </a>
                                    </li>
                                    @foreach($currentFolder->breadcrumb as $crumb)
                                        <li class="breadcrumb-item {{ $loop->last ? 'active' : '' }}">
                                            @if($loop->last)
                                                {{ $crumb['name'] }}
                                            @else
                                                <a href="{{ route('file-manager.index', ['folder' => $crumb['id']]) }}">
                                                    {{ $crumb['name'] }}
                                                </a>
                                            @endif
                                        </li>
                                    @endforeach
                                </ol>
                            </nav>
                        </div>
                    @endif

                    <!-- قائمة المجلدات -->
                    <div class="folder-list">
                        @if(!$currentFolder)
                            <a href="{{ route('file-manager.index') }}" class="folder-item active">
                                <i class="fas fa-home me-2"></i>
                                المجلد الرئيسي
                            </a>
                        @endif
                        
                        @foreach(\App\Models\Folder::root()->ordered()->get() as $rootFolder)
                            @include('file-manager.partials.folder-tree-item', ['folder' => $rootFolder])
                        @endforeach
                    </div>
                </div>
            </div>
        </div>

        <!-- إحصائيات سريعة -->
        <div class="card mt-3">
            <div class="card-header">
                <h6 class="mb-0">
                    <i class="fas fa-chart-bar me-2"></i>
                    إحصائيات
                </h6>
            </div>
            <div class="card-body">
                <div class="stats-list">
                    <div class="stat-item d-flex justify-content-between">
                        <span>إجمالي الملفات</span>
                        <span class="badge bg-primary">{{ number_format($stats['total_files']) }}</span>
                    </div>
                    <div class="stat-item d-flex justify-content-between">
                        <span>إجمالي المجلدات</span>
                        <span class="badge bg-success">{{ number_format($stats['total_folders']) }}</span>
                    </div>
                    <div class="stat-item d-flex justify-content-between">
                        <span>المساحة المستخدمة</span>
                        <span class="badge bg-warning">{{ \App\Models\File::formatBytes($stats['total_size']) }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- المحتوى الرئيسي -->
    <div class="col-md-9">
        <!-- شريط البحث والفلاتر -->
        <div class="card mb-3">
            <div class="card-body">
                <form method="GET" class="row g-3">
                    @if(request('folder'))
                        <input type="hidden" name="folder" value="{{ request('folder') }}">
                    @endif
                    
                    <div class="col-md-4">
                        <input type="text" class="form-control" name="search" placeholder="البحث في الملفات..." value="{{ request('search') }}">
                    </div>
                    <div class="col-md-3">
                        <select name="category" class="form-select">
                            <option value="">جميع التصنيفات</option>
                            @foreach($stats['categories'] as $category)
                                <option value="{{ $category }}" {{ request('category') == $category ? 'selected' : '' }}>
                                    {{ $category }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <select name="type" class="form-select">
                            <option value="">جميع الأنواع</option>
                            <option value="image" {{ request('type') == 'image' ? 'selected' : '' }}>صور</option>
                            <option value="video" {{ request('type') == 'video' ? 'selected' : '' }}>فيديو</option>
                            <option value="audio" {{ request('type') == 'audio' ? 'selected' : '' }}>صوت</option>
                            <option value="application" {{ request('type') == 'application' ? 'selected' : '' }}>مستندات</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <button type="submit" class="btn btn-outline-primary w-100">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- عرض المجلدات -->
        @if($folders->count() > 0)
            <div class="card mb-3">
                <div class="card-header">
                    <h6 class="mb-0">
                        <i class="fas fa-folder me-2"></i>
                        المجلدات ({{ $folders->count() }})
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        @foreach($folders as $folder)
                            <div class="col-md-3 col-sm-4 col-6 mb-3">
                                <div class="folder-card text-center p-3 border rounded position-relative">
                                    <div class="folder-icon mb-2">
                                        <i class="{{ $folder->icon }}" style="font-size: 3rem; color: {{ $folder->color }}"></i>
                                    </div>
                                    <h6 class="folder-name">{{ $folder->name }}</h6>
                                    <small class="text-muted">
                                        {{ $folder->files_count }} ملف
                                        @if($folder->subfolders_count > 0)
                                            - {{ $folder->subfolders_count }} مجلد
                                        @endif
                                    </small>
                                    
                                    <!-- قائمة الأجراءات -->
                                    <div class="folder-actions position-absolute top-0 end-0 p-2">
                                        <div class="dropdown">
                                            <button class="btn btn-sm btn-outline-secondary" data-bs-toggle="dropdown">
                                                <i class="fas fa-ellipsis-v"></i>
                                            </button>
                                            <ul class="dropdown-menu">
                                                <li>
                                                    <a class="dropdown-item" href="{{ route('file-manager.index', ['folder' => $folder->id]) }}">
                                                        <i class="fas fa-folder-open me-2"></i>فتح
                                                    </a>
                                                </li>
                                                <li>
                                                    <button class="dropdown-item" onclick="editFolder({{ $folder->id }})">
                                                        <i class="fas fa-edit me-2"></i>تعديل
                                                    </button>
                                                </li>
                                                <li>
                                                    <a class="dropdown-item" href="{{ route('file-manager.folders.download', $folder) }}">
                                                        <i class="fas fa-download me-2"></i>تحميل
                                                    </a>
                                                </li>
                                                @if(!$folder->is_system)
                                                    <li><hr class="dropdown-divider"></li>
                                                    <li>
                                                        <button class="dropdown-item text-danger" onclick="deleteFolder({{ $folder->id }})">
                                                            <i class="fas fa-trash me-2"></i>حذف
                                                        </button>
                                                    </li>
                                                @endif
                                            </ul>
                                        </div>
                                    </div>
                                    
                                    <!-- رابط فتح المجلد -->
                                    <a href="{{ route('file-manager.index', ['folder' => $folder->id]) }}" class="stretched-link"></a>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        @endif

        <!-- عرض الملفات -->
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h6 class="mb-0">
                    <i class="fas fa-file me-2"></i>
                    الملفات ({{ $files->total() }})
                </h6>
                <div class="view-toggle btn-group btn-group-sm">
                    <button class="btn btn-outline-secondary active" data-view="grid">
                        <i class="fas fa-th"></i>
                    </button>
                    <button class="btn btn-outline-secondary" data-view="list">
                        <i class="fas fa-list"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                @if($files->count() > 0)
                    <!-- عرض شبكي -->
                    <div id="grid-view" class="files-grid">
                        <div class="row">
                            @foreach($files as $file)
                                <div class="col-md-3 col-sm-4 col-6 mb-4">
                                    @include('file-manager.partials.file-card', ['file' => $file])
                                </div>
                            @endforeach
                        </div>
                    </div>

                    <!-- عرض قائمة -->
                    <div id="list-view" class="files-list d-none">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                    <tr>
                                        <th>الاسم</th>
                                        <th>النوع</th>
                                        <th>الحجم</th>
                                        <th>التاريخ</th>
                                        <th>الإجراءات</th>
                                    </tr>
                                <tbody>
                                    @foreach($files as $file)
                                        @include('file-manager.partials.file-row', ['file' => $file])
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- ترقيم الصفحات -->
                    <div class="d-flex justify-content-center">
                        {{ $files->links() }}
                    </div>
                @else
                    <div class="text-center py-5">
                        <i class="fas fa-folder-open fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">لا توجد ملفات</h5>
                        <p class="text-muted">قم برفع ملفات جديدة لتظهر هنا</p>
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#uploadModal">
                            <i class="fas fa-upload me-2"></i>
                            رفع ملفات
                        </button>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- نافذة رفع الملفات -->
@include('file-manager.modals.upload')

<!-- نافذة إنشاء مجلد -->
@include('file-manager.modals.create-folder')

<!-- نافذة تعديل الملف -->
@include('file-manager.modals.edit-file')

<!-- نافذة تعديل المجلد -->
@include('file-manager.modals.edit-folder')
@endsection

@push('styles')
<style>
    .folder-card {
        transition: all 0.3s ease;
        cursor: pointer;
    }
    
    .folder-card:hover {
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        transform: translateY(-2px);
    }
    
    .file-tree .folder-item {
        display: block;
        padding: 8px 15px;
        color: #333;
        text-decoration: none;
        border-bottom: 1px solid #f0f0f0;
    }
    
    .file-tree .folder-item:hover,
    .file-tree .folder-item.active {
        background-color: #f8f9fa;
        color: #007bff;
    }
    
    .stats-list .stat-item {
        padding: 8px 0;
        border-bottom: 1px solid #f0f0f0;
    }
    
    .stats-list .stat-item:last-child {
        border-bottom: none;
    }
    
    .file-preview {
        width: 100%;
        height: 120px;
        object-fit: cover;
        border-radius: 8px;
    }
    
    .file-icon {
        font-size: 4rem;
        margin-bottom: 10px;
    }
</style>
@endpush

@push('scripts')
<script>
    // تبديل العرض بين الشبكة والقائمة
    document.querySelectorAll('[data-view]').forEach(btn => {
        btn.addEventListener('click', function() {
            const view = this.dataset.view;
            
            // تحديث الأزرار
            document.querySelectorAll('[data-view]').forEach(b => b.classList.remove('active'));
            this.classList.add('active');
            
            // تبديل العرض
            if (view === 'grid') {
                document.getElementById('grid-view').classList.remove('d-none');
                document.getElementById('list-view').classList.add('d-none');
            } else {
                document.getElementById('grid-view').classList.add('d-none');
                document.getElementById('list-view').classList.remove('d-none');
            }
        });
    });

    // حذف مجلد
    function deleteFolder(folderId) {
        if (confirm('هل أنت متأكد من حذف هذا المجلد؟ سيتم حذف جميع المحتويات.')) {
            fetch(`/file-manager/folders/${folderId}`, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                }
            }).then(() => {
                location.reload();
            });
        }
    }

    // حذف ملف
    function deleteFile(fileId) {
        if (confirm('هل أنت متأكد من حذف هذا الملف؟')) {
            fetch(`/file-manager/files/${fileId}`, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                }
            }).then(() => {
                location.reload();
            });
        }
    }
</script>
@endpush