<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>اختبار إشعارات النظام</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            direction: rtl;
            text-align: right;
            background-color: #f8f9fa;
            margin: 0;
            padding: 20px;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background-color: white;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        .header {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 28px;
            font-weight: 300;
        }
        .test-badge {
            background-color: rgba(255,255,255,0.2);
            color: white;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: bold;
            display: inline-block;
            margin-bottom: 15px;
        }
        .content {
            padding: 30px;
        }
        .success-message {
            background-color: #d4edda;
            border: 2px solid #28a745;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
            text-align: center;
        }
        .success-message h3 {
            color: #155724;
            margin: 0 0 10px 0;
            font-size: 20px;
        }
        .success-message p {
            color: #155724;
            margin: 0;
            font-weight: bold;
        }
        .test-details {
            background-color: #f8f9fa;
            border-radius: 6px;
            padding: 20px;
            margin: 20px 0;
        }
        .test-details h3 {
            color: #495057;
            margin-top: 0;
            border-bottom: 2px solid #e9ecef;
            padding-bottom: 10px;
        }
        .detail-row {
            display: flex;
            justify-content: space-between;
            margin: 10px 0;
            padding: 8px 0;
            border-bottom: 1px solid #e9ecef;
        }
        .detail-row:last-child {
            border-bottom: none;
        }
        .label {
            font-weight: bold;
            color: #6c757d;
        }
        .value {
            color: #495057;
        }
        .features-list {
            background-color: #e7f3ff;
            border: 1px solid #b8daff;
            border-radius: 6px;
            padding: 20px;
            margin: 20px 0;
        }
        .features-list h4 {
            color: #0c5460;
            margin-top: 0;
        }
        .feature-item {
            background-color: white;
            border: 1px solid #b8daff;
            border-radius: 4px;
            padding: 10px;
            margin: 10px 0;
            display: flex;
            align-items: center;
        }
        .feature-icon {
            color: #28a745;
            font-size: 18px;
            margin-left: 10px;
            min-width: 25px;
        }
        .footer {
            background-color: #f8f9fa;
            padding: 20px;
            text-align: center;
            color: #6c757d;
            font-size: 14px;
        }
        .system-info {
            background-color: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 6px;
            padding: 15px;
            margin: 20px 0;
        }
        .system-info h4 {
            color: #856404;
            margin-top: 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="test-badge">اختبار النظام</div>
            <h1>✅ نجح الاختبار!</h1>
            <p style="margin: 0; opacity: 0.9;">تم إرسال الإشعار بنجاح</p>
        </div>
        
        <div class="content">
            <div class="success-message">
                <h3>🎉 تهانينا!</h3>
                <p>نظام الإشعارات يعمل بشكل صحيح</p>
            </div>
            
            <div class="test-details">
                <h3>📋 تفاصيل الاختبار</h3>
                
                <div class="detail-row">
                    <span class="label">رقم الفاتورة التجريبية:</span>
                    <span class="value">{{ $invoice->invoice_number }}</span>
                </div>
                
                <div class="detail-row">
                    <span class="label">المبلغ:</span>
                    <span class="value">{{ number_format($invoice->total_amount, 2) }} ر.س</span>
                </div>
                
                <div class="detail-row">
                    <span class="label">تاريخ الاختبار:</span>
                    <span class="value">{{ $invoice->issue_date->format('Y-m-d H:i:s') }}</span>
                </div>
                
                <div class="detail-row">
                    <span class="label">العميل التجريبي:</span>
                    <span class="value">{{ $invoice->customer->name }}</span>
                </div>
                
                <div class="detail-row">
                    <span class="label">البريد المرسل إليه:</span>
                    <span class="value">{{ $invoice->customer->email }}</span>
                </div>
                
                <div class="detail-row">
                    <span class="label">الشركة:</span>
                    <span class="value">{{ $invoice->company->name }}</span>
                </div>
            </div>
            
            <div class="features-list">
                <h4>✨ الميزات المفعلة في النظام</h4>
                
                <div class="feature-item">
                    <span class="feature-icon">✅</span>
                    <span>إرسال الفواتير عبر البريد الإلكتروني</span>
                </div>
                
                <div class="feature-item">
                    <span class="feature-icon">✅</span>
                    <span>تذكيرات السداد التلقائية</span>
                </div>
                
                <div class="feature-item">
                    <span class="feature-icon">✅</span>
                    <span>إشعارات الدائن والمدين</span>
                </div>
                
                <div class="feature-item">
                    <span class="feature-icon">✅</span>
                    <span>تتبع حالة الفواتير</span>
                </div>
                
                <div class="feature-item">
                    <span class="feature-icon">✅</span>
                    <span>إدارة الديون المتأخرة</span>
                </div>
                
                <div class="feature-item">
                    <span class="feature-icon">✅</span>
                    <span>تقارير أداء التحصيل</span>
                </div>
                
                <div class="feature-item">
                    <span class="feature-icon">✅</span>
                    <span>دعم الواتساب (اختياري)</span>
                </div>
                
                <div class="feature-item">
                    <span class="feature-icon">✅</span>
                    <span>توليد QR Code للفواتير</span>
                </div>
                
                <div class="feature-item">
                    <span class="feature-icon">✅</span>
                    <span>التكامل مع هيئة الزكاة والضريبة (ZATCA)</span>
                </div>
            </div>
            
            <div class="system-info">
                <h4>ℹ️ معلومات النظام</h4>
                <p><strong>نوع الاختبار:</strong> اختبار إعدادات الإشعارات</p>
                <p><strong>الغرض:</strong> التأكد من عمل نظام البريد الإلكتروني</p>
                <p><strong>الحالة:</strong> <span style="color: #28a745; font-weight: bold;">نجح ✅</span></p>
                <p><strong>التوقيت:</strong> {{ now()->format('Y-m-d H:i:s') }}</p>
            </div>
            
            <div style="background-color: #d1ecf1; border: 1px solid #b8daff; border-radius: 6px; padding: 20px; margin: 20px 0;">
                <h4 style="color: #0c5460; margin-top: 0;">📝 ملاحظات مهمة</h4>
                <ul style="color: #0c5460; margin: 0; padding-right: 20px;">
                    <li>هذه رسالة اختبار ولا تتطلب أي إجراء من جانبكم</li>
                    <li>تم إرسالها للتأكد من عمل نظام الإشعارات بشكل صحيح</li>
                    <li>جميع البيانات المعروضة هي بيانات تجريبية</li>
                    <li>في حالة وجود أي مشاكل، يرجى التواصل مع مدير النظام</li>
                </ul>
            </div>
            
            <div style="background-color: #d4edda; border: 2px solid #28a745; border-radius: 6px; padding: 20px; margin: 20px 0; text-align: center;">
                <h4 style="color: #155724; margin-top: 0;">🎯 النتيجة</h4>
                <p style="color: #155724; font-weight: bold; margin: 0; font-size: 16px;">
                    نظام الإشعارات يعمل بشكل مثالي!<br>
                    يمكنكم الآن الاعتماد على النظام لإرسال الفواتير والتذكيرات تلقائياً.
                </p>
            </div>
            
            <div style="text-align: center; margin: 30px 0;">
                <p style="color: #28a745; font-weight: bold; font-size: 18px;">
                    ✨ مرحباً بكم في نظام إدارة الفواتير المتطور ✨
                </p>
                <p style="color: #6c757d;">
                    نظام شامل ومتكامل لإدارة فواتيركم بكفاءة عالية
                </p>
            </div>
        </div>
        
        <div class="footer">
            <p><strong>نظام إدارة الفواتير</strong></p>
            <p>تم إرسال هذا الاختبار في: {{ now()->format('Y-m-d H:i:s') }}</p>
            <p style="color: #28a745; font-weight: bold;">✅ الاختبار مكتمل بنجاح</p>
        </div>
    </div>
</body>
</html>